=begin JA

= ǥХå

# *  (odakker)
#   * $Id: dc_trace.rd,v 1.2 2007/06/28 08:44:32 morikawa Exp $

=end JA

=begin JA

gt4f90io 饤֥ˤ, 
ǥХåθפ륵֥롼󶡤⥸塼 
((<dc_trace|URL:../code_reference/classes/dc_trace.html>)) Ѱդ
Ƥޤ. ѤȥǥХåΥץפŪưפ
ԤȤǽȤʤޤ. 

Ȥ, 
((<"Fortran 90/95 ѥ⥸塼: (1) ̥ѥ᥿"|URL:dc_clock.htm>)) 
Ѥ((<ץץ|URL:diffusion_4.f90>))
ǥХåϤäץ򼨤ޤ 
(ɤ((<|URL:diffusion_6.f90>))). 
ֻ(顼Ǥʤϥܡ) dc_trace ˴طƤսǤ.

=end JA

=begin HTML
<pre style="background-color: #FFFFFF; color: blue; border-style: groove; border-width: 2">
!= Sample program for gt4_history/gt4f90io
!
! * 2007/06/27 M.Odaka
! * 2006/10/25 Y.Morikawa
! * 2003/08/21 M.Odaka
! * 2001/02/27 S.Takehiro
!
! Solving diffusion equation
! \[
!     du/dt = \kappa d^2 u/dx^2
! \]
! for giving values of $u$ at $x=[0,1]$.
!
program diffusion_6

  use gt4_history                                   ! ⥸塼
  use dc_types, only : DP                           ! ⥸塼
  use dc_message, only : MessageNotify              ! ⥸塼
  <b><font color="red">use dc_trace, only : SetDebug, DbgMessage         ! ⥸塼</font></b>

  integer, parameter     :: nx=30                   ! åɿ
  integer, parameter     :: nt=200                  ! ֥ƥå׿
  integer, parameter     :: ndisp=10                ! ϴֳ
  real(DP), parameter    :: dx=1.0/(nx-1)           ! åɴֳ
  real(DP), parameter    :: dt=0.0005               ! ֳִ
  real(DP), dimension(nx):: x=(/(dx*(i-1),i=1,nx)/) ! ɸѿ
  real(DP), dimension(nx):: temp                    ! 
  real(DP), parameter    :: kappa=1.0               ! ǮȻ
  real(DP)               :: sigma                   ! ׻ѥ᥿

  <b><font color="red">call SetDebug                                     ! ǥХå⡼ɥ
  call DbgMessage(fmt="*** Debug Message [diffusion_6] *** Debug Message On")
                                                    ! ǥХå  </font></b>

  tinit = 0.0                                       ! 

  sigma = kappa*dt/dx**2.0d0

  if ( sigma >= 0.5d0 ) then
    call MessageNotify( "E", &                      ! 顼å 
      &                 "diffusion_6", &
      &                 "dt is too large: k*dt/(dx)^2 = %f", &
      &                  d=(/sigma/) )
  else if ( sigma >= 0.4d0 ) then
    call MessageNotify( "W", &                      ! ٹå 
      &                 "diffusion_6", &
      &                 "dt is moderately large: k*dt/(dx)^2 = %f", &
      &                 d=(/sigma/) )
  else
    call MessageNotify( "M", &                      ! å 
      &                 "diffusion_6", &
      &                 "dt is sufficiently small: k*dt/(dx)^2 = %f", &
      &                  d=(/sigma/) )
  end if
    
  temp = exp(-((x-0.5)/0.1)**2)                     ! 

  call HistoryCreate( &                             ! ҥȥ꡼
    & file='diffusion_6.nc', title='Diffusion equation', &
    & source='Sample program of gt4_history/gt4f90io',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','t'/), dimsizes=(/nx,0/),               &
    & longnames=(/'X-coordinate','time        '/),       &
    & units=(/'m','s'/),                                 &
    & origin=real(tinit), interval=real(ndisp*dt) )

  call HistoryPut('x',x)                            ! ѿ

  call HistoryAddVariable( &                        ! ѿ
    & varname='temp', dims=(/'x','t'/), &
    & longname='temperature', units='K', xtype='double')

  call HistoryAddAttr('temp','gt_graph_tick_all',1)
  call HistoryAddAttr('temp','gt_graph_contour_spacing',(/0.0,1.0,0.01/))
  call HistoryAddAttr('temp','+gt_user_davis_kappa',kappa)

  call HistoryPut('temp',temp)                      ! ѿ

  
    <b><font color="red">call DbgMessage(fmt="*** Debug Message [diffusion_6] *** Begin time integration")</font></b>
  
    do it=1,nt
  
      temp(2:nx-1) = temp(2:nx-1) &                   ! ʬ
        & + kappa*(temp(3:nx)-2*temp(2:nx-1)+temp(1:nx-2))/dx**2*dt
  
      if ( mod(it,ndisp) == 0 ) then
        call HistoryPut('temp',temp)                  ! ѿ
      endif
  
      <b><font color="red">call DbgMessage(fmt="*** Debug Message [diffusion_6] *** it=%d, &
        &             i= (/it/) )                     ! ǥХå </font></b>
  
    end do
  
    <b><font color="red">call DbgMessage(fmt="*** Debug Message [diffusion_6] *** End time integration")</font></b>
  
  call HistoryClose
  
  stop
  end program diffusion_6
  
</pre>
=end HTML
  
=begin JA
  
ΥץǤ, ʬ롼ʬȥ롼˥å
Ƥޤ. åɸϤ˽Ϥޤ. ϰʲǤ. 
gt4f90io 饤֥󶡤륵֥롼ΥǥХåϤ⥪ˤʤޤ.
  
  
    #SetDebug: dbg = 0
    #*** Debug Message [diffusion_5] *** Debug Message On
     *** WARNING [diffusion_6] ***  dt is moderately large: k*dt/(dx)^2 = 0.4205000231056476
    #call HistoryCreate1 version=<$Name: gt4f90io-20070711 $$Id: dc_trace.rd,v 1.2 2007/06/28 08:44:32 morikawa Exp $> : file=diffusion_6.nc ndims=2
    #|-dims(:)=x, t, dimsizes(:)=30, 0, longnames(:)=X-coordinate, time, units(:)=m, s
    #| call DCDateTimeCreate1 : current_time_used=<yes>
    #| end DCDateTimeCreate1 : time (caltype=4, day=733253, sec=5976., zone=+09:00, day_seconds=86400.)
    #| call DCDateTimeEval1
    #| end DCDateTimeEval1
    #| call GTVarCreateD version=<$Name: gt4f90io-20070711 $$Id: dc_trace.rd,v 1.2 2007/06/28 08:44:32 morikawa Exp $> : url=<diffusion_6.nc@x> length=30
    #| | call ANVarCreateD : url=<diffusion_6.nc@x>, xtype=<>, length=<30>
    #| | | call ANFileOpen : writable=yes overwrite=yes file=diffusion_6.nc
     *** MESSAGE [ANFileOpen] ***  diffusion_6.nc is overwritten.
    #| | | end ANFileOpen : id=4 stat=0
    #| | |-anfiledefinemode 4
    #| | |-an_vartable.add: added 1
    #| | end ANVarCreateD : stat=0
    #| |-[gt_variable 1: ndims=1, map.size=1]
    #| |-[dim1 dimno=1 ofs=0 step=1 all=30 start=1 count=30 stride=1 url=]
    #| |-[vartable 1: class=netcdf cid=1 ref=1]
    #| |-[AN_VARIABLE(file=4, var=1, dim=1)]
    #| end GTVarCreateD : class=netcdf mapid=1
  
  
ʲǤ dc_trace ⥸塼 ֥롼󤬹ԤäƤ뤳Ȥޤޤ.
ǰäƤʤ֥롼εǽޤܤ
((<ե󥹥ޥ˥奢|URL:../code_reference/classes/dc_trace.html>)) 
򻲾ȤƤ.
  
: use dc_trace
 
  ⥸塼λѤޤ. Fortran90 ᥤץƬˤ
  ޤ礦. Ǥ only ʸѤɬפʥ֥롼򻲾Ȥޤ. 
  
  
: SetDebug
  
  ǥХå⡼ɤ򥪥ˤޤ. ˤ, DbgMessage, BeginSub, EndSub
  ʤɤΥ֥롼ͭˤʤޤ. 
  
  
: DbgMessage(fmt, [i], [r], [d], [L], [n], [c1], [c2], [c3], [ca])
  
  SetDebug  call 줿,  ((*fmt*)) Ϳ줿ʸ
  ɸ२顼Ϥ˽Ϥޤ. ((*fmt*)) ѿͤޤ뤳ȤǤޤ.
  ξ, ץб뷿ѿꤷޤ.
  
  ưΰ̣ϰʲ̤Ǥ. 
    
  * ((*fmt*)) Ͻ񼰤ꤹǤ.
    Ǥѿ it ͤϤ뤿, ѿؼ ((*%i*)) 
    ѤƤޤ. 
    ѿؼξܺ٤ˤĤƤ ((<dcstringprintf.f90|URL:../code_reference/files/dcstringsprintf_f90.html>)) 򻲾ȤƤ.

  * ((*[i], [r], [d], [L], [n], [c1], [c2], [c3]*)) ϥץ, 
    ((*fmt*)) ѿͤꤷޤ. 
    ǤѿѤΥץ ((*[d]*)) 
    ѿ it Ƥޤ. ץξܺ٤ˤĤƤ
    ((<dc_string|URL:../code_reference/classes/dc_string.html>)) 
    ⥸塼
    ((<Cprintf|URL:../code_reference/classes/dc_string.html#M000818>)) 
    ؿ򻲾ȤƤ.


=end JA

=begin HTML
<hr /> <small>
  $Id: dc_trace.rd,v 1.2 2007/06/28 08:44:32 morikawa Exp $
</small>
=end HTML
