!= Sample program for gt4_history/gt4f90io
!
! * 2007/06/25 M.Odaka
! * 2006/10/25 Y.Morikawa
! * 2003/08/21 M.Odaka
! * 2001/02/27 S.Takehiro
!
! Solving diffusion equation
! \[
!     du/dt = \kappa d^2 u/dx^2
! \]
! for giving values of $u$ at $x=[0,1]$.
!
program diffusion_5

  use gt4_history                                   ! ⥸塼
  use dc_types, only : DP                           ! ⥸塼
  use dc_clock, only : CLOCK, Create, Close, Start, &
    &            Stop, Result, Predict, operator(+) ! ⥸塼

  integer, parameter     :: nx=30                   ! åɿ
  integer, parameter     :: nt=200                  ! ֥ƥå׿
  integer, parameter     :: ndisp=10                ! ϴֳ
  real(DP), parameter    :: dx=1.0/(nx-1)           ! åɴֳ
  real(DP), parameter    :: dt=0.0005               ! ֳִ
  real(DP), dimension(nx):: x=(/(dx*(i-1),i=1,nx)/) ! ɸѿ
  real(DP), dimension(nx):: temp                    ! 
  real(DP), parameter    :: kappa=1.0               ! ǮȻ
  type(CLOCK)            :: clock_init, clock_roop  ! CPU ַ¬ѿ

  call Create( clk = clock_init, &                  ! 
    &          name = 'initialization' )
  call Create( clk = clock_roop, &                  ! 
    &          name = 'time-integration' )

  call Start( clk = clock_init )                    ! CPU ַ¬

  tinit = 0.0                                       ! 
    
  temp = exp(-((x-0.5)/0.1)**2)                     ! 

  call HistoryCreate( &                             ! ҥȥ꡼
    & file='diffusion_5.nc', title='Diffusion equation', &
    & source='Sample program of gt4_history/gt4f90io',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','t'/), dimsizes=(/nx,0/),               &
    & longnames=(/'X-coordinate','time        '/),       &
    & units=(/'m','s'/),                                 &
    & origin=real(tinit), interval=real(ndisp*dt) )

  call HistoryPut('x',x)                            ! ѿ

  call HistoryAddVariable( &                        ! ѿ
    & varname='temp', dims=(/'x','t'/), &
    & longname='temperature', units='K', xtype='double')

  call HistoryAddAttr('temp','gt_graph_tick_all',1)
  call HistoryAddAttr('temp','gt_graph_contour_spacing',(/0.0,1.0,0.01/))
  call HistoryAddAttr('temp','+gt_user_davis_kappa',kappa)

  call HistoryPut('temp',temp)                      ! ѿ

  call Stop( clk = clock_init )                     ! CPU ַ¬λ

  do it=1,nt
    call Start ( clk = clock_roop )                 ! CPU ַ¬

    temp(2:nx-1) = temp(2:nx-1) &                   ! ʬ
      & + kappa*(temp(3:nx)-2*temp(2:nx-1)+temp(1:nx-2))/dx**2*dt

    if ( mod(it,ndisp) == 0 ) then
      call HistoryPut('temp',temp)                  ! ѿ
    endif

    call Stop( clk = clock_roop )                   ! CPU ַ¬λ
    call Predict( clk = clock_init + clock_roop, &  ! Ĥ֤ͽ¬
      &            progress = real(it)/real(nt) )

  end do

  call HistoryClose

  call Result( clks = (/clock_init, clock_roop/), & !  CPU ֤ɽ
    &          total_auto = .true. )
  call Close( clk = clock_init )                    ! 
  call Close( clk = clock_roop )                    ! 

  stop
end program diffusion_5
