=begin JA

= åν

# *  (odakker)
#   * $Id: dc_message.rd,v 1.3 2007/08/28 09:22:29 odakker2 Exp $

=end JA
=begin EN

= Message dump

# * Masatsugu Odaka (odakker)
#   * $Id: dc_message.rd,v 1.3 2007/08/28 09:22:29 odakker2 Exp $

=end EN


=begin JA

ץμ¹ˤޤޤʥåɸϤ˽Ϥ礬
ޤ. , write ʸѤɤߤ䤹ϤԤˤ, 񼰻
פɬפޤ. ѿͤޤʸϤˤ, 
ʸϢ䷿ѴԤʤɤνɬפȤʤݤǤ.

gt4f90io ˤϥåϤԤ֥롼󶡤⥸塼 
((<dc_message|URL:../code_reference/classes/dc_message.html>)) Ѱ
Ƥޤ. Υ⥸塼˴ޤޤ ((<MessageNotify|URL:../code_reference/classes/dc_message.html#M000416>)) ֥롼Ѥ, 
åϤñ˹ԤȤǤޤ.

Ȥ, 
((<"Fortran 90/95 ѥ⥸塼: (1) ̷ѥ᥿"|URL:dc_types.htm>)) 
Ѥ((<ץץ|URL:diffusion_3.f90>))˥å
äץ򼨤ޤ (ɤ((<|URL:diffusion_4.f90>))). 
Ǥѿ sigma ͤ˱ƻΥåϤޤ.
ֻ(顼Ǥʤϥܡ) dc_messege ˴طƤսǤ.

=end JA
=begin EN

In many cases, it is necessary to dump message on standard output
during program execution. However, well sophisticated WRITE and FORMAT
statements are required for readable message. Moreover, 
when the message includes variables of not character literal constants, 
the conversion of type and concatenation are required, which are 
troublesome for programers.

((<Dc_message|URL:../code_reference/classes/dc_message.html>)) module
of gt4f90io provide subroutine for message dump. 
By using the dc_message module, readable message dump is realized
in user's programs with ease.

For example, a sample program using the dc_message module
(((<diffusion_4.f90|URL:diffusion_4.f90>))) is shown here, which are
modified from ((<diffusion_3.f90|URL:diffusion_3.f90>)) in ((<"
Fortran 90/95 general-purpose modules: (1) Type parameter
specification"|URL:dc_types.htm.en>)).  Statements with colored font
(or bold font) are associataed with the dc_message module.

=end EN


=begin HTML
<pre style="background-color: #FFFFFF; color: blue; border-style: groove; border-width: 2">
!= Sample program for gt4_history/gt4f90io
!
! * 2007/06/25 M.Odaka
! * 2006/10/25 Y.Morikawa
! * 2003/08/21 M.Odaka
! * 2001/02/27 S.Takehiro
!
! Solving diffusion equation
! \[
!     du/dt = \kappa d^2 u/dx^2
! \]
! for giving values of $u$ at $x=[0,1]$.
!
program diffusion_4

  use gt4_history                                   ! ⥸塼
  use dc_types, only : DP                           ! ⥸塼
  <b><font color="red">use dc_message, only : MessageNotify              ! ⥸塼</font></b>

  integer, parameter     :: nx=30                   ! åɿ
  integer, parameter     :: nt=200                  ! ֥ƥå׿
  integer, parameter     :: ndisp=10                ! ϴֳ
  real(DP), parameter    :: dx=1.0/(nx-1)           ! åɴֳ
  real(DP), parameter    :: dt=0.0005               ! ֳִ
  real(DP), dimension(nx):: x=(/(dx*(i-1),i=1,nx)/) ! ɸѿ
  real(DP), dimension(nx):: temp                    ! 
  real(DP), parameter    :: kappa=1.0               ! ǮȻ
  real(DP)               :: sigma                   ! ׻ѥ᥿

  tinit = 0.0                                       ! 

  sigma = kappa*dt/dx**2.0d0

  <b><font color="red">if ( sigma >= 0.5d0 ) then
    call MessageNotify( "E", &amp;                      ! 顼å 
      &amp;                 "diffusion_4", &amp;
      &amp;                 "dt is too large: k*dt/(dx)^2 = %f", &amp;
      &amp;                  d=(/sigma/) )
  else if ( sigma >= 0.4d0 ) then
    call MessageNotify( "W", &amp;                      ! ٹå 
      &amp;                 "diffusion_4", &amp;
      &amp;                 "dt is moderately large: k*dt/(dx)^2 = %f", &amp;
      &amp;                 d=(/sigma/) )
  else
    call MessageNotify( "M", &amp;                      ! å 
      &amp;                 "diffusion_4", &amp;
      &amp;                 "dt is sufficiently small: k*dt/(dx)^2 = %f", &amp;
      &amp;                  d=(/sigma/) )
  end if</font></b>
    
  temp = exp(-((x-0.5)/0.1)**2)                     ! 

  call HistoryCreate( &amp;                             ! ҥȥ꡼
    &amp; file='diffusion_4.nc', title='Diffusion equation', &amp;
    &amp; source='Sample program of gt4_history/gt4f90io',   &amp;
    &amp; institution='GFD_Dennou Club davis project',       &amp;
    &amp; dims=(/'x','t'/), dimsizes=(/nx,0/),               &amp;
    &amp; longnames=(/'X-coordinate','time        '/),       &amp;
    &amp; units=(/'m','s'/),                                 &amp;
    &amp; origin=real(tinit), interval=real(ndisp*dt) )

  call HistoryPut('x',x)                            ! ѿ

  call HistoryAddVariable( &amp;                        ! ѿ
    &amp; varname='temp', dims=(/'x','t'/), &amp;
    &amp; longname='temperature', units='K', xtype='double')

  call HistoryAddAttr('temp','gt_graph_tick_all',1)
  call HistoryAddAttr('temp','gt_graph_contour_spacing',(/0.0,1.0,0.01/))
  call HistoryAddAttr('temp','+gt_user_davis_kappa',kappa)

  call HistoryPut('temp',temp)                      ! ѿ

  do it=1,nt
    temp(2:nx-1) = temp(2:nx-1) &amp;                   ! ʬ
      &amp; + kappa*(temp(3:nx)-2*temp(2:nx-1)+temp(1:nx-2))/dx**2*dt

    if ( mod(it,ndisp) == 0 ) then
      call HistoryPut('temp',temp)                  ! ѿ
    endif
  enddo

  call HistoryClose
  stop
end program diffusion_4
</pre>
=end HTML

=begin JA

Υץ¹Ԥ, ʲΤ褦ʥåɲä褦ˤʤޤ.

     \*** WARNING [diffusion_3] ***  dt is moderately large: k*dt/(dx)^2 = 0.4205000231056476

=end JA

=begin JA

嵭Υץˤɲä줿 dc_message ⥸塼 ֥롼
ԤäƤ뤳Ȥޤޤ. ܤ
((<ե󥹥ޥ˥奢|URL:../code_reference/classes/dc_message.html#M000416>)) 򻲾ȤƤ.

: use dc_message

  ⥸塼λѤޤ. Fortran90 ᥤץƬˤ
  ޤ礦. Ǥ only ʸѤ
  ((<MessageNotify|URL:../code_reference/classes/dc_message.html#M000416>)) 
  ֥롼򻲾Ȥޤ. 


: call MessageNotify(level, where, message, [i], [r], [d], [L], [n], [c1], [c2], [c3])

  åϤޤ. ưΰ̣ϰʲ̤Ǥ.

  * ((*level*)) ϥåμꤹǤ. 
    * "M" (ޤ "Message" ʤ "M" ǻϤޤʸ): ̾å
    * "W" (ޤ "Warning" ʤ "W" ǻϤޤʸ): ٹå
    * "E" (ޤ "Error" ʤ "E" ǻϤޤʸ): 顼å. 
      ꤹȥåϸ, ץλޤ. 

  * ((*where*)) Ͻϲս򼨤ץޤϥ֥롼̾ꤹǤ.

  * ((*message*)) ϽϤʸꤹǤ. 
    ʸѿޤ뤳ȤǤޤ. Ǥټ¿ѿ
    sigma ͤϤ뤿, ѿؼ ((*%f*)) ѤƤޤ. 
    ѿؼξܺ٤ˤĤƤ ((<dcstringprintf.f90|URL:../code_reference/files/dcstringsprintf_f90.html>)) 򻲾ȤƤ.

    
  * ((*[i], [r], [d], [L], [n], [c1], [c2], [c3]*)) ϥץǤ.
    ((*message*)) ˻ꤷʸѿͤꤷޤ. 
    ټ¿ѿѤΥץ ((*[d]*)) 
    ѿ sigma Ƥޤ. ץξܺ٤ˤĤƤ
    ((<dc_string|URL:../code_reference/classes/dc_string.html>)) 
    ⥸塼
    ((<Cprintf|URL:../code_reference/classes/dc_string.html#M000818>)) 
    ؿ򻲾ȤƤ.


=end JA


=begin EN

Summary of dc_message module and its subroutines used in the sample
program are as follows. In detail, please see ((<gt4f90io reference
manual|URL:../code_reference/classes/dc_message.html#M000416>)).

: use dc_message
 
  Access dc_message module. This statement is located at the begining
  of main program. In this case, only
  ((<MessageNotify|URL:../code_reference/classes/dc_message.html#M000416>)) 
  subroutine is accessed by ONLY option.

: call MessageNotify(level, where, message, [i], [r], [d], [L], [n], [c1], [c2], [c3])

  Dump message. Notation of each arguments are follows.

  * ((*level*)) specifies the kind of message. 
    * "M" (or "Message"): standard message
    * "W" (or "Warning"): warning message
    * "E" (or "Error" ) : error message. 
      When this argumet are specified, the program is terminated.

  * ((*where*)) specifies the program or subroutine name where 
    the MessageNotify subroutine is called.

  * ((*message*)) specifies the string of dump message,
    which can include variables. 
    In this case,
    double precition literal constant "sigma" 
    is included in the dump message by using 
    assignment argument ((*%f*)). 
    In details of assignment arguments, please see ((<dcstringprintf.f90|URL:../code_reference/files/dcstringsprintf_f90.html>)).

    
  * ((*[i], [r], [d], [L], [n], [c1], [c2], [c3]*)) are optional arguments
    which specify the variable included in the string assigned in
    ((*message*)).
    In this case, optional argument ((*[d]*)) for 
    double precition literal constant is used.
    In details of the optional arguments, 
    please see 
    ((<Cprintf|URL:../code_reference/classes/dc_string.html#M000818>)) 
    subroutine of 
    ((<dc_string|URL:../code_reference/classes/dc_string.html>)) module.



=end EN


=begin HTML
<hr /> <small>
  $Id: dc_message.rd,v 1.3 2007/08/28 09:22:29 odakker2 Exp $
</small>
=end HTML
