!
!= GTOOL ѿɽ
!
! Authors::   Eizi TOYODA, Yasuhiro MORIKAWA
! Version::   $Id: gt_vartable.f90,v 1.3 2006-06-06 06:49:14 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20080605 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! This file provides gt_vartable
!

module gt_vartable
  !
  ! Υ⥸塼 gtool ⥸塼뤫ľܤˤϰѤʤᡢ
  ! ̾λȤ򤷤Ƥ롣桼ϸƤǤϤʤʤ
  !
  !=== GTOOL ѿɽ
  !
  ! gtool ѿȤΤϼ¤ñʤϥɥ¿ƥ졼Ǥꡢ
  ! ϥɥϾͤǤ롣
  ! Τ˥뤿ˤϡϥɥͤ򥭡ˤƤޤޥåɽ
  ! 줿 vid 򥭡ˤѿɽơ
  ! ̤ȼ̤Ȥѿֹ롣Ϥݥ󥿡ܥեå
  ! ٤ΥȤǤ롣
  ! gtool ѿϼѿ饤ƥ졼ɬפʤ뤬
  ! ѿɽϼѿˤĤȥꤷʤΤǡȿġ
  ! Τᡢѿѿդƻȿ򤷤ʤƤ褯ʤ롣

  use dc_types, only: STRING
  implicit none
  private

  integer, parameter, public :: vid_invalid = -1

  integer, parameter, public :: VTB_CLASS_UNUSED = 0
  integer, parameter, public :: VTB_CLASS_MEMORY = 1
  integer, parameter, public :: VTB_CLASS_NETCDF = 2
  integer, parameter, public :: CLASSES_MAX = 2

  type VAR_TABLE_ENTRY
    integer:: class
    integer:: cid
    integer:: refcount
  end type VAR_TABLE_ENTRY

  type(VAR_TABLE_ENTRY), save, allocatable:: table(:)
  integer, parameter:: table_ini_size = 16

  public:: VarTableAdd, VarTableDelete, VarTableMore, VarTableLookup
  public:: vartable_dump
  private:: var_table_entry, table, table_ini_size
  private:: entry_cleanup

contains

  subroutine vartable_dump(vid)
    use dc_trace, only: DbgMessage
    use an_generic, only: an_variable, tostring
    integer, intent(in):: vid
    character(10):: class
    if (.not. allocated(table)) return
    if (vid <= 0 .or. vid > size(table)) return
    select case(table(vid)%class)
    case(vtb_class_netcdf)
      class = 'netcdf'
    case(vtb_class_memory)
      class = 'memory'
    case default
      write(class, fmt="(i10)") table(vid)%class
    end select
    call DbgMessage('[vartable %d: class=%c cid=%d ref=%d]', &
      & i=(/vid, table(vid)%cid, table(vid)%refcount/), &
      & c1=trim(class))
    select case(table(vid)%class)
    case(vtb_class_netcdf)
      call DbgMessage('[%c]', c1=trim(tostring(an_variable(table(vid)%cid))))
    end select
  end subroutine vartable_dump
  
  subroutine entry_cleanup(vtb_entry)
    type(VAR_TABLE_ENTRY), intent(out):: vtb_entry(:)
    vtb_entry(:)%class = VTB_CLASS_UNUSED
    vtb_entry(:)%cid = -1
    vtb_entry(:)%refcount = 0
  end subroutine entry_cleanup

  subroutine VarTableAdd(vid, class, cid)
    use dc_trace, only: DbgMessage
    integer, intent(out):: vid
    integer, intent(in):: class, cid
    type(VAR_TABLE_ENTRY), allocatable:: tmp_table(:)
    integer:: n
  continue
    ! ɬפʤн
    if (.not. allocated(table)) then
      allocate(table(table_ini_size))
      call entry_cleanup(table(:))
    endif
    ! лȿ
    do, n = 1, size(table)
      if (table(n)%class == class .and. table(n)%cid == cid) then
        table(n)%refcount = table(n)%refcount + 1
        call DbgMessage('gt_vartable.add(class=%d cid=%d) found (ref=%d)', &
          & i=(/table(n)%class, table(n)%cid, table(n)%refcount/))
        vid = n
        return
      endif
    enddo
    ! ⤷̵ɽĥ
    if (all(table(:)%class /= VTB_CLASS_UNUSED)) then
      n = size(table)
      allocate(tmp_table(n))
      tmp_table(:) = table(:)
      deallocate(table)
      allocate(table(n * 2))
      table(1:n) = tmp_table(1:n)
      deallocate(tmp_table)
      table(n+1:n*2) = var_table_entry(VTB_CLASS_UNUSED, -1, 0)
    endif
    do, n = 1, size(table)
      if (table(n)%class == VTB_CLASS_UNUSED) then
        table(n)%class = class
        table(n)%cid = cid
        table(n)%refcount = 1
        vid = n
        return
      endif
    enddo
    vid = vid_invalid
  end subroutine VarTableAdd

  subroutine VarTableDelete(vid, action, err)
    integer, intent(in):: vid
    logical, intent(out):: action
    logical, intent(out), optional:: err
    if (.not. allocated(table)) goto 999
    if (vid <= 0 .or. vid > size(table)) goto 999
    if (table(vid)%class <= VTB_CLASS_UNUSED) goto 999
    if (table(vid)%class > CLASSES_MAX) goto 999
    table(vid)%refcount = max(table(vid)%refcount - 1, 0)
    action = (table(vid)%refcount == 0)
    if (present(err)) err = .false.
    return
999 continue
    action = .false.
    if (present(err)) err = .true.
  end subroutine VarTableDelete

  subroutine VarTableLookup(vid, class, cid)
    ! ƱեֹѿɽȤ֤
    integer, intent(in):: vid
    integer, intent(out), optional:: class, cid
    if (.not. allocated(table)) goto 999
    if (vid <= 0 .or. vid > size(table)) goto 999
    if (table(vid)%class <= VTB_CLASS_UNUSED) goto 999
    if (table(vid)%class > CLASSES_MAX) goto 999
    if (present(class)) class = table(vid)%class
    if (present(cid)) cid = table(vid)%cid
    return
999 continue
    if (present(class)) class = VTB_CLASS_UNUSED
  end subroutine VarTableLookup

  subroutine VarTableMore(vid, err)
    ! ƱեֹλȥȤä롣
    integer, intent(in):: vid
    logical, intent(out), optional:: err
    if (.not. allocated(table)) goto 999
    if (vid <= 0 .or. vid > size(table)) goto 999
    if (table(vid)%class <= VTB_CLASS_UNUSED) goto 999
    if (table(vid)%class > CLASSES_MAX) goto 999
    table(vid)%refcount = table(vid)%refcount + 1
    if (present(err)) err = .false.
    return
999 continue
    if (present(err)) err = .true.
  end subroutine VarTableMore

end module
