!
!= ѿޤ°˴ؤ䤤碌
!
! Authors::   Eizi TOYODA, Yasuhiro MORIKAWA
! Version::   $Id: gtvarinquire.f90,v 1.4 2007-09-20 10:02:54 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20080720 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! ʲΥ֥롼󡢴ؿ gtdata_generic  gtdata_generic#Inquire
! Ȥ󶡤ޤ

subroutine GTVarInquire(var, growable, rank, alldims, allcount, &
  & size, xtype, name, url)
  !
  !== ѿ˴ؤ䤤碌
  !
  ! ѿ *var* ˴ؤ䤤碌Ԥޤ
  !
  ! ֤ͤȤʤʸμ°Ĺ­ʤȡ
  ! ̤»ʤޤʸĹȤ dc_types#STRING
  ! Ѥ뤳Ȥ侩ޤ
  !
  ! *Inquire* ʣΥ֥롼̾Ǥꡢ
  ! 䤤碌ˡʣѰդƤޤ
  ! Υ֥롼⻲ȤƤ
  !
  ! ¾ˤѿ˴ؤ䤤碌Τμ³Ȥ
  ! Get_Slice, Dimname_to_Dimord ޤ
  !
  !--
  ! Υ֥롼 INQUIRE ʸϤƺ줿Τǡ
  ! ֥ȡѿ°˴ؤ䤤碌Ԥޤ
  !++
  !
  use gtdata_types, only: GT_VARIABLE
  use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
  use an_generic, only: inquire, an_variable
  use dc_trace, only: beginsub, endsub, DbgMessage
  implicit none
  type(GT_VARIABLE), intent(in):: var
  character(len=*), intent(out), optional:: xtype
                                        ! ̾
  character(len=*), intent(out), optional:: name
                                        ! name ѿ̾κǾñ̤֤ޤ
                                        ! ե̾ޤޤʤ
                                        ! ץǤΰ
                                        ! ݾڤޤ
                                        ! 
  character(len=*), intent(out), optional:: url
                                        ! url ϥե̾ΤĤѿ̾
                                        ! ֤ޤ
                                        ! ץǰդǤ
                                        ! 
  integer, intent(out), optional:: rank
                                        ! ѥ()ʤ
                                        ! ο
                                        ! 
  integer, intent(out), optional:: alldims
                                        ! ༡ޤ
                                        ! dimord ˤϴŪˤ
                                        ! Ȥޤ
                                        ! 
  integer, intent(out), optional:: allcount
                                        ! ѿѿǤ硢
                                        ! ֤ޤ
                                        ! 顼ξϥ֤ޤ
                                        ! 
  integer, intent(out), optional:: size
                                        ! ѿΰ礭
                                        ! (ѿ¸ƼĹ
                                        ! [ʻ])
                                        ! 
  logical, intent(out), optional:: growable
                                        ! ѿѿǤ硢
                                        ! ưĥǽݤ֤ޤ
                                        ! ѿǤʤȤʤޤ
                                        ! 
  integer:: class, cid
continue
  call beginsub('gtvarinquire', 'var.mapid=%d', i=(/var%mapid/))
  call var_class(var, class, cid)
  select case(class)
  case(vtb_class_netcdf)
    if (present(xtype) .or. present(name) .or. present(url)) then
      call inquire(an_variable(cid), xtype=xtype, name=name, url=url)
      if (present(xtype)) call DbgMessage('xtype=%c', c1=trim(xtype))
      if (present(name)) call DbgMessage('name=%c', c1=trim(name))
      if (present(url)) call DbgMessage('url=%c', c1=trim(url))
    endif
    if (present(growable)) then
      call inquire(an_variable(cid), growable=growable)
      call DbgMessage('growable=%y', L=(/growable/))
    endif
  case(vtb_class_memory)
    call DbgMessage('vtb_class_memory not implemented: skipped')
  end select
  if (present(alldims)) alldims = internal_get_alldims(var)
  if (present(allcount)) allcount = internal_get_allcount(var)
  if (present(size)) size = internal_get_size(var)
  if (present(rank)) rank = internal_get_rank(var)
  call endsub('gtvarinquire')
  return
contains

  integer function internal_get_alldims(var) result(result)
    use gt_map, only: map_lookup
    implicit none
    type(GT_VARIABLE), intent(in):: var
    call map_lookup(var, ndims=result)
    call DbgMessage('alldims=%d', i=(/result/))
  end function internal_get_alldims

  integer function internal_get_allcount(var) result(result)
    use gt_map, only: gt_dimmap, map_lookup
    implicit none
    type(GT_VARIABLE), intent(in):: var
    type(gt_dimmap), allocatable:: map(:)
    integer:: nd
    call map_lookup(var, ndims=nd)
    if (nd <= 0) then
      call DbgMessage('internal_get_allcount: no map')
      result = 1
      return
    endif
    allocate(map(nd))
    call map_lookup(var, map=map)
    result = product(map(1:nd)%allcount)
    call DbgMessage('internal_get_allcount: %d map.size=%d', &
      & i=(/result, nd/))
    deallocate(map)
  end function internal_get_allcount

  integer function internal_get_size(var) result(result)
    use gt_map, only: gt_dimmap, map_lookup
    implicit none
    type(GT_VARIABLE), intent(in):: var
    type(gt_dimmap), allocatable:: map(:)
    integer:: nd
    call map_lookup(var, ndims=nd)
    if (nd <= 0) then
      call DbgMessage('internal_get_size: no map')
      result = 1
      return
    endif
    allocate(map(nd))
    call map_lookup(var, map=map)
    result = product(map(1:nd)%count)
    call DbgMessage('internal_get_size: %d map.size=%d', &
      & i=(/result, nd/))
    deallocate(map)
  end function internal_get_size

  integer function internal_get_rank(var) result(result)
    use gt_map, only: gt_dimmap, map_lookup
    implicit none
    type(GT_VARIABLE), intent(in):: var
    type(gt_dimmap), allocatable:: map(:)
    integer:: nd

    call map_lookup(var, ndims=nd)
    if (nd <= 0) then
      call DbgMessage('internal_get_rank: no map')
      result = 0
      return
    endif
    allocate(map(nd))
    call map_lookup(var, map=map)
    result = count(map(1:nd)%count > 1)
    call DbgMessage('internal_get_rank: %d', i=(/result/))
    deallocate(map)
  end function internal_get_rank

end subroutine GTVarInquire

subroutine GTVarInquire2(var, allcount)
  !
  !== ѿΰ¸뼡 (ʣ) 䤤碌
  !
  ! ѿ *var* ¸Ƽ֤ޤ
  ! *allcount* Υϰ¸뼡οɬפǤ
  ! ¸뼡οϾ嵭 *Inquire*  *alldims* Ĵ٤뤳Ȥ
  ! Ǥޤ
  !
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: inquire, open, close
  use dc_trace, only: beginsub, endsub
  type(GT_VARIABLE), intent(in):: var
  integer, intent(out):: allcount(:) ! alldims ɬ
  integer:: i, n
  type(GT_VARIABLE):: v
  call beginsub('gtvarinquire2')
  call inquire(var, alldims=n)
  do, i = 1, n
    call Open(v, var, i, count_compact=.true.)
    call inquire(var, allcount=allcount(i))
    call Close(v)
  enddo
  call endsub('gtvarinquire2')
end subroutine

subroutine GTVarInquireA(var, attrname, xtype)
  !
  !== ѿ°η䤤碌
  !
  ! ѿ *var* ° *attrname* ͤη *xtype* ֤ޤ
  !
  !--
  ! ʸʤѤʤȤ뤬ˤʤ
  !++
  use gtdata_types, only: GT_VARIABLE
  use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
  use dc_trace, only: beginsub, endsub
  use an_generic, only: inquire, an_variable
  type(GT_VARIABLE), intent(in):: var
  character(len=*), intent(in):: attrname
  character(len=*), intent(out), optional:: xtype
  integer:: class, cid
  character(len = *), parameter:: subnam = "gtvarinquireA"
continue
  call beginsub(subnam, "%c", c1=trim(attrname))
  call var_class(var, class, cid)
  select case(class)
  case(vtb_class_netcdf)
    call inquire(an_variable(cid), attrname=attrname, xtype=xtype)
  end select
  call endsub(subnam)
end subroutine GTVarInquireA

subroutine GTVarInquireD(var, dimord, url, allcount)
  !
  !== ѿμ˴ؤ䤤碌
  !
  ! ѿ *var* μֹ *dimord* б뼡
  ! URL *url*  *allcout* ֤ޤ
  ! 
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: open, close, inquire
  use dc_trace, only: beginsub, endsub
  implicit none
  type(GT_VARIABLE), intent(in):: var
  integer, intent(in):: dimord
  character(len=*), intent(out), optional:: url
  integer, intent(out), optional:: allcount
  type(GT_VARIABLE):: dimvar
  character(len = *), parameter:: subnam = "gtvarinquireD"
continue
  call beginsub(subnam, "%d", i=(/dimord/))
  call open(dimvar, source_var=var, dimord=dimord)
  if (present(url)) call inquire(dimvar, url=url)
  if (present(allcount)) call inquire(dimvar, allcount=allcount)
  call close(dimvar)
  call endsub(subnam)
end subroutine GTVarInquireD
