!== Monitor of CPU TIME
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dc_clock.f90,v 1.22 2008-07-28 09:51:14 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20080810 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

module dc_clock
  !
  !== Overview
  !
  ! ץνפ CPU ֤¬ɽޤ.
  !
  !== List
  !
  ! DCClockCreate               :: CLOCK ѿν
  ! DCClockStart                :: ¬γ
  ! DCClockStop                 :: ¬ΰ
  ! DCClockClose                :: ¤ CLOCK ѿνλ
  ! DCClockGet, DCClockEvalSec  :: CPU  (ñ: ) μ
  ! DCClockToChar               :: CPU ֤ŬʸѿѴ
  ! DCClockPutLine              :: ¤ CLOCK ѿξɽ
  ! DCClockResult               :: CPU ֤˴ؤŪʾɽ
  ! DCClockPredict              :: ץबλޤǤͽ¬ CPU , 
  !                                ɽ
  ! DCClockSetName              :: ̾Τκ
  ! #operator(+)                :: û (dc_clock#CLOCK Ʊ)
  ! #operator(-)                ::  (dc_clock#CLOCK Ʊ)
  !
  !== Usage
  !
  ! Ϥ, ¤ CLOCK ѿ, DCClockCreate ǽޤ.
  ! ץη¬ DCClockStart ƤӽФ,
  ! ¬ߤ DCClockStop ƤӽФޤ.
  ! DCClockResult ˤäƷв֤ɽޤ.
  ! DCClockPredict Ѥ뤳ȤǥץबλޤǤλĤ CPU 
  ! ͽ¬ͤɽ뤳ȤǽǤ.
  !
  !     program dc_clock_sapmle1
  !       use dc_clock, only: CLOCK, DCClockCreate, DCClockClose, & 
  !         & DCClockStart, DCClockStop, DCClockResult, DCClockPredict, & 
  !         & operator(+)
  !       implicit none
  !       type(CLOCK):: clock1, clock2
  !       integer:: i, j
  !       integer, parameter:: loop_num = 8
  !       real:: a, b
  !
  !       call DCClockCreate( clk = clock1, & ! (out)
  !         & name = 'exponential' )          ! (in)
  !       call DCClockCreate( clk = clock2, & ! (out)
  !         & name = 'four-operations' )      ! (in)
  !       a = 2.0
  !       b = 1.0
  !       do i = 1, loop_num
  !         call DCClockStart( clk = clock1 ) ! (inout)
  !         do j = 1, 1000000
  !           a = (a**2)**0.3 + 1.0
  !         enddo
  !         call DCClockStop( clk = clock1 )  ! (inout)
  !         call DCClockStart( clk = clock2 ) ! (inout)
  !         do j = 1, 1000000
  !           b = b / 3.0 * 2.0 + 1.0 - 1.0e-1
  !         enddo
  !         call DCClockStop( clk = clock2 ) ! (inout)
  !         call DCClockPredict( &
  !           & clk = clock1 + clock2, &            ! (in)
  !           & progress = real(i)/real(loop_num) ) ! (in)
  !       enddo
  !       call DCClockResult( &
  !         & clks = (/clock1, clock2/), &  ! (in)
  !         & total_auto = .true. )         ! (in)
  !       call DCClockClose( clk = clock1 ) ! (inout)
  !       call DCClockClose( clk = clock2 ) ! (inout)
  !
  !       write(*,*) 'a = ', a
  !       write(*,*) 'b = ', b
  !     end program dc_clock_sapmle1
  !
  !== Note
  !
  ! CPU ֤ϥƥ CPU ֤ȥ桼 CPU ֤Ȥʬ뤳Ȥ
  ! Ǥޤ. dc_clock Ǥ CPU ֤η¬ *cpu_time* ֥롼
  ! (Fortran 95 ʤƳ줿ȹߥ֥롼) ѤƤ뤿,
  ! ¬줿 CPU ֤ƥ CPU ֤ʤΤ桼 CPU ֤ʤΤ,
  ! ⤷ξιפʤΤɤϽϤ *cpu_time* ˰¸Ƥޤ.
  ! (ξιפǤ礬¿褦Ǥ).
  !
  !=== ߴ
  !
  ! С 20071009 Ѳǽäʲμ³, 
  ! ߴΤ, Ф餯ѲǽǤ. 
  ! 
  ! * Create, Close, Start, Stop, PutLine, Result, Set_Name
  !   Get, EvalSec, toChar, Predict

  use dc_types, only: STRING
  use dc_trace, only: BeginSub, EndSub, DbgMessage
  use dc_date_types, only: DC_DIFFTIME, DC_DATETIME
  implicit none
  private

  public:: CLOCK
  public:: DCClockCreate, DCClockClose, DCClockStart, DCClockStop
  public:: DCClockPutLine, DCClockResult, DCClockSetName
  public:: operator(+), operator(-)
  public:: DCClockGet, DCClockEvalSec, DCClocktoChar, DCClockPredict

  !-----------------------------------------------
  ! ߴ
  ! For backward compatibility
  public:: Create, Close, Start, Stop, PutLine, Result, Set_Name
  public:: Get, EvalSec, toChar, Predict

  type CLOCK
    !
    ! CPU ¬Ѥι¤ΤǤ.
    ! ˤ Create , λˤ Close Ѥޤ.
    !
    ! ܤȤ dc_clock  Usage 򻲾Ȥ.
    !
    private
    character(STRING):: name
    type(DC_DIFFTIME):: start_time   ! ¬򳫻Ϥ
                                     ! (¬ΰˤͤꤵ)
    type(DC_DIFFTIME):: elapsed_time ! в֤߷
    type(DC_DATETIME):: start_date   ! ¬򳫻Ϥ
    logical:: dummy
    logical:: initialized = .false. ! CLOCK ¤Τνåѥե饰
  end type CLOCK


  interface DCClockCreate
    module procedure DCClockCreate0
  end interface

  interface DCClockClose
    module procedure DCClockClose0
  end interface

  interface DCClockStart
    module procedure DCClockStart0
  end interface

  interface DCClockStop
    module procedure DCClockStop0
  end interface

  interface DCClockPutLine
    module procedure DCClockPutLine0
  end interface

  interface DCClockGet
    module procedure DCClockGetR
    module procedure DCClockGetD
  end interface

  interface DCClockEvalSec
    module procedure DCClockEvalSecD
  end interface

  interface DCClockToChar
    module procedure DCClockToChar0
  end interface

  interface DCClockResult
    module procedure DCClockResult0
  end interface

  interface operator(+)
    module procedure DCClockAdd
  end interface

  interface operator(-)
    module procedure DCClockSubtract
  end interface

  interface DCClockSetName
    module procedure DCClockSetName0
  end interface

  interface DCClockPredict
    module procedure DCClockPredict0
  end interface

  !-----------------------------------------------
  ! ߴ
  ! For backward compatibility
  interface Create
    module procedure DCClockCreate0
  end interface

  interface Close
    module procedure DCClockClose0
  end interface

  interface Start
    module procedure DCClockStart0
  end interface

  interface Stop
    module procedure DCClockStop0
  end interface

  interface PutLine
    module procedure DCClockPutLine0
  end interface

  interface Get
    module procedure DCClockGetR
    module procedure DCClockGetD
  end interface

  interface EvalSec
    module procedure DCClockEvalSecD
  end interface

  interface toChar
    module procedure DCClockToChar0
  end interface

  interface Result
    module procedure DCClockResult0
  end interface

  interface Set_Name
    module procedure DCClockSetName0
  end interface

  interface Predict
    module procedure DCClockPredict0
  end interface


  character(*), parameter:: version = &
    & '$Name: gt4f90io-20080810 $' // &
    & '$Id: dc_clock.f90,v 1.22 2008-07-28 09:51:14 morikawa Exp $'

contains

  subroutine DCClockCreate0(clk, name)
    !
    !=== CLOCK νѥ֥롼
    !
    ! CLOCK ѿѤݤˤϤޤΥ֥롼ˤä
    ! ԤäƤ. *name* ˤϷ¬ƤͿƤ.
    !
    use dc_message, only: MessageNotify
    use dc_date, only: assignment(=), DCDateTimeCreate
    implicit none
    type(CLOCK), intent(out):: clk
    character(*), intent(in):: name
    character(*), parameter:: subname = 'DCClockCreate'
  continue
    call BeginSub(subname, 'name=%c', c1=trim(name), version=version)
    if (clk % initialized) then
      call MessageNotify('W', subname, 'This argument (type CLOCK) is already initialized.')
      call DbgMessage('already initialized')
      goto 999
    end if
    clk % name = name
    clk % elapsed_time = 0.0
    clk % start_time = - 1.0
    clk % initialized = .true.
    call DCDateTimeCreate(clk % start_date)
    call DbgMessage('normal initialized')
999 continue
    call EndSub(subname)
  end subroutine DCClockCreate0

  subroutine DCClockClose0(clk)
    !
    !=== CLOCK νλ֥롼
    !
    ! CLOCK ѿ򥯥ޤ.
    !
    implicit none
    type(CLOCK), intent(inout):: clk
    character(*), parameter:: subname = 'DCClockClose'
  continue
    call BeginSub(subname)
    if (clk % initialized) then
      clk % initialized = .false.
      clk % name = ''
    end if
    call EndSub(subname)
  end subroutine DCClockClose0

  subroutine DCClockStart0(clk, err)
    !
    !=== ¬γ
    !
    ! Υ֥롼ƤǷ¬򳫻Ϥޤ.
    !
    !  *clk* Ф DCClockCreate ˤԤƤʤ,
    ! 顼ȯޤ. *err* Ϳˤ *err*  .true. ֤,
    ! ץ³Ԥޤ.
    !
    use dc_message, only: MessageNotify
    use dc_string, only: toChar
    use dc_types, only: DP
    use dc_error, only: StoreError, DC_ENOTINIT, DC_NOERR
    use dc_date, only: assignment(=), EvalSec
    implicit none
    type(CLOCK), intent(inout):: clk
    logical, intent(out), optional:: err
    character(STRING):: cause_c
    real(DP):: start_time
    integer:: stat
    character(*), parameter:: subname = 'DCClockStart'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = 'CLOCK'
    if (.not. clk % initialized) then
      call MessageNotify('W', subname, 'Call Create before Start in dc_clock.')
      call DbgMessage('Ignored because input argument was not initialized.')
      stat = DC_ENOTINIT
      goto 999
    end if
    call cpu_time(start_time)
    clk % start_time = start_time
    call DbgMessage('name=%c, cpu_time=%f', &
      & c1=trim(clk % name), d=(/EvalSec(clk % start_time)/) )
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DCClockStart0


  subroutine DCClockStop0(clk, err)
    !
    !=== ¬ΰ
    !
    ! Υ֥롼ƤǷ¬ߤޤ.
    !
    !  *clk* Ф DCClockCreate ˤԤƤʤ,
    ! 顼ȯޤ. *err* Ϳˤ *err*  .true. ֤,
    ! ץ³Ԥޤ.
    !
    use dc_message, only: MessageNotify
    use dc_string, only: toChar
    use dc_error, only: StoreError, DC_ENOTINIT, DC_NOERR
    use dc_date, only: EvalSec, assignment(=), operator(+), operator(-)
    use dc_date_types, only: DC_DIFFTIME
    use dc_types, only: DP
    implicit none
    type(CLOCK), intent(inout):: clk
    logical, intent(out), optional:: err
    character(STRING):: cause_c
    type(DC_DIFFTIME):: stop_timediff
    real:: stop_time
    integer:: stat
    character(*), parameter:: subname = 'DCClockStop'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = 'CLOCK'
    if (.not. clk % initialized) then
      call MessageNotify('W', subname, 'Call Create before Stop in dc_clock.')
      call DbgMessage('Ignored because input argument was not initialized.')
      stat = DC_ENOTINIT
      goto 999
    elseif (EvalSec(clk % start_time) < 0.0_DP) then
      call MessageNotify('W', subname, 'Call Start before Stop in dc_clock.')
      call DbgMessage('Ignored because input argument was not started.')
      goto 999
    end if
    call cpu_time(stop_time)
    stop_timediff = stop_time
    clk % elapsed_time = clk % elapsed_time &
      & + stop_timediff - clk % start_time
    clk % start_time = - 1.0
    call DbgMessage('name=%c, cpu_time=%r, elapsed_time=%f', &
      & c1=trim(clk % name), r=(/stop_time/), d=(/EvalSec(clk % elapsed_time)/))
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DCClockStop0

  subroutine DCClockGetR(clk, sec, err) !:doc-priority 40:
    !
    !=== CPU  (ñ: ) μ
    !
    ! CPU  (ñ: )  *sec* ˼ޤ.
    !
    !  *clk* Ф DCClockCreate ˤԤƤʤ,
    ! 顼ȯޤ. *err* Ϳˤ *err*  .true. ֤,
    ! ץ³Ԥޤ.
    !
    use dc_types, only: DP
    use dc_message, only: MessageNotify
    use dc_date, only: EvalSec
    use dc_string, only: CPrintf
    use dc_error, only: StoreError, DC_ENOTINIT, DC_NOERR
    implicit none
    type(CLOCK), intent(in):: clk
    real, intent(out):: sec
    logical, intent(out), optional:: err
    character(STRING):: cause_c
    integer:: stat
    character(*), parameter:: subname = 'DCClockGetR'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = 'CLOCK'
    if (.not. clk % initialized) then
      call MessageNotify('W', subname, 'Call Create before Get in dc_clock.')
      call DbgMessage('Ignored because input argument was not initialized.')
      stat = DC_ENOTINIT
      goto 999
    end if
    sec = real(EvalSec(clk % elapsed_time))
    call DbgMessage('name=%c, return sec=<%r>', &
      & c1=trim(clk % name), r=(/sec/))
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DCClockGetR

  subroutine DCClockGetD(clk, sec, err) !:doc-priority 60:
    !
    !=== CPU  (ñ: ) μ
    !
    ! CPU  (ñ: )  *sec* ˼ޤ.
    !
    !  *clk* Ф DCClockCreate ˤԤƤʤ,
    ! 顼ȯޤ.
    !  *err* Ϳˤ *err*  .true. ֤,
    ! ץ³Ԥޤ.
    !
    use dc_types, only: DP
    use dc_string, only: CPrintf
    use dc_message, only: MessageNotify
    use dc_date, only: EvalSec
    use dc_error, only: StoreError, DC_ENOTINIT, DC_NOERR
    implicit none
    type(CLOCK), intent(in):: clk
    real(DP), intent(out):: sec
    logical, intent(out), optional:: err
    character(STRING):: cause_c
    integer:: stat
    character(*), parameter:: subname = 'DCClockGetD'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = 'CLOCK'
    if (.not. clk % initialized) then
      call MessageNotify('W', subname, 'Call Create before Get in dc_clock.')
      call DbgMessage('Ignored because input argument was not initialized.')
      stat = DC_ENOTINIT
      goto 999
    end if
    sec = EvalSec(clk % elapsed_time)
    call DbgMessage('name=%c, return sec=<%f>', &
      & c1=trim(clk % name), d=(/sec/))
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DCClockGetD

  function DCClockEvalSecD(clk) result(result)
    !
    !=== CPU  (ñ: ) μ
    !
    ! CPU  (ñ: ) ֤ޤ.
    !
    !  *clk* Ф DCClockCreate 
    ! ˤԤƤʤ, -1.0 ֤ޤ.
    !
    use dc_types, only: DP
    implicit none
    type(CLOCK), intent(in):: clk
    real(DP):: result
    logical:: err
  continue
    call DCClockGetD(clk, result, err)
    if (err) result = -1.0_DP
  end function DCClockEvalSecD

  function DCClockToChar0(clk) result(result)
    !
    !=== CPU ֤ŬʸѿѴ
    !
    ! CPU ֤˴ؤŬԤ, ʸѿѴ֤ޤ.
    !
    !  *clk* Ф DCClockCreate
    ! ˤԤƤʤ, ʸ֤ޤ.
    !
    use dc_string, only: CPrintf
    use dc_date, only: EvalSec
    implicit none
    type(CLOCK), intent(in):: clk
    character(STRING):: result
    character(20):: clk_name
  continue
    clk_name = clk % name
    if (clk % initialized) then
      result = CPrintf(' %c%c  %c', c1 = clk_name, &
        & c2=trim(result_value_form(EvalSec(clk % elapsed_time))), &
        & c3=trim(fit_unit_value(clk % elapsed_time)))
    else
      result = ''
    end if
  end function DCClockToChar0

  subroutine DCClockPutLine0(clk, unit, indent, err)
    !
    !=== ¤ CLOCK ѿξɽ
    !
    ! ¤ CLOCK ѿ˴ؤɽޤ. *unit* ˤϽֹ
    ! ͿƤ. *unit* Ϳʤ, ɸϤɽޤ.
    !
    !  *clk* Ф DCClockCreate ˤԤƤʤ,
    ! 顼ȯޤ. *err* Ϳˤ *err*  .true. ֤,
    ! ץ³Ԥޤ.
    !
    use dc_types, only: STDOUT
    use dc_message, only: MessageNotify
    use dc_string, only: Printf, toChar, CPrintf
    use dc_date, only: EvalSec, EvalDay, toChar
    use dc_error, only: StoreError, DC_ENOTINIT, DC_NOERR
    use dc_types, only: DP
    implicit none
    type(CLOCK), intent(in):: clk
    integer, intent(in), optional:: unit
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
    integer:: out_unit
    character(STRING):: cause_c
    integer:: stat
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'DCClockPutLine'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = 'CLOCK'
    if (.not. clk % initialized) then
      call MessageNotify('W', subname, 'Call Create before PutLine in dc_clock.')
      call DbgMessage('Ignored because input argument was not initialized.')
      stat = DC_ENOTINIT
      goto 999
    end if
    if (present(unit)) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if
    indent_len = 0
    indent_str = ''
    if (present(indent)) then
      if (len(indent) /= 0) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if
    call Printf(out_unit, &
      & indent_str(1:indent_len) // &
      & '#<CLOCK:: @name=%c @clocking=%y @elapsed_time=%f sec. %c @start_date=%c>', &
      & c1=trim(clk % name), l=(/EvalSec(clk % start_time) > 0.0_DP/), &
      & d=(/EvalSec(clk % elapsed_time)/), &
      & c2=trim(fit_unit_value(clk % elapsed_time)), &
      & c3=trim(toChar(clk % start_date)))
    call DbgMessage('name=%c, output to device number %d', &
      & c1=trim(clk % name), i=(/out_unit/))
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DCClockPutLine0

  subroutine DCClockResult0(clks, unit, total_auto, clk_total, total_name, err)
    !
    !=== CPU ֤פɽ
    !
    ! CPU ֤פɽޤ. *clks* , CLOCK ѿ
    ! ͿƤ. ץκǸǸƤӽФ뤳Ȥ
    ! ꤷƤޤ. *unit* ˤϽֹ
    ! ͿƤ. *unit* Ϳʤ, ɸϤɽޤ.
    !
    !  *total_auto*  .true. Ϳ, *clks* ­碌
    ! ͤưŪɽޤ. ΰ *clk_total* ͿƤ
    !  *clk_total* ͥ褵ޤ.
    !
    !  *clk_total*  CLOCK ѿͿ, ѿͤ
    ! ɽޤ.
    !
    !  *total_name* ʸѿͿ, ץå
    ! ƬˤʸϤޤ.
    !
    !  *clk* Ф DCClockCreate ˤԤƤʤ,
    ! 顼ȯޤ. *err* Ϳˤ *err*  .true. ֤,
    ! ץ³Ԥޤ.
    !
    use dc_types, only: STDOUT, STRING, DP
    use dc_message, only: MessageNotify
    use dc_string, only: Printf, toChar, CPrintf
    use dc_date, only: EvalSec
    use dc_error, only: StoreError, DC_ENOTINIT, DC_NOERR
    implicit none
    type(CLOCK), intent(in):: clks(:)
    integer, intent(in), optional:: unit
    logical, intent(in), optional:: total_auto
    type(CLOCK), intent(in), optional:: clk_total
    logical, intent(out), optional:: err
    character(*), intent(in), optional:: total_name
    integer:: out_unit, i, clks_size
    character(20):: clk_name
    character(STRING):: cause_c
    character(STRING):: total_name_work
    type(CLOCK):: clk_auto_total
    logical:: total_print_complete
    real(DP):: elapsed_time_val_cor
    integer:: stat
    character(*), parameter:: total_time_mes = '       TOTAL TIME = '
    character(*), parameter:: subname = 'DCClockResult'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = 'CLOCK'
    clks_size = size(clks)
    do i = 1, clks_size
      if (.not. clks(i) % initialized) then
        call MessageNotify('W', subname, 'Call Create before Result in dc_clock.')
        call DbgMessage('Ignored because input argument was not initialized.')
        stat = DC_ENOTINIT
        goto 999
      end if
    end do
    if (present(unit)) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if
    if (present(total_name)) then
      total_name_work = ' (' // trim(total_name) // ')'
    else
      total_name_work = ''
    end if
    call Printf(out_unit, '')
    call Printf(out_unit, &
      & ' ############## CPU TIME SUMMARY%c################', &
      & c1=trim(total_name_work) // ' ')
    do i = 1, clks_size
      clk_name = clks(i) % name
      elapsed_time_val_cor = EvalSec(clks(i) % elapsed_time)
      if (elapsed_time_val_cor < 0.0_DP) elapsed_time_val_cor = 0.0_DP
      call Printf(out_unit, &
        & ' %c%c  %c', c1=clk_name, &
        & c2=trim(result_value_form(elapsed_time_val_cor)), &
        & c3=trim(fit_unit_value(clks(i) % elapsed_time)))
    end do
    total_print_complete = .false.
    if (present(clk_total)) then
      if (clk_total % initialized) then
        call Printf(out_unit, &
          & ' ------------------------------------------------')
        elapsed_time_val_cor = EvalSec(clk_total % elapsed_time)
        if (elapsed_time_val_cor < 0.0_DP) elapsed_time_val_cor = 0.0_DP
        call Printf(out_unit, &
          & ' %c%c  %c', c1=total_time_mes, &
          & c2=trim(result_value_form(elapsed_time_val_cor)), &
          & c3=trim(fit_unit_value(clk_total % elapsed_time)))
        total_print_complete = .true.
      end if
    end if

    if (present(total_auto) .and. .not. total_print_complete) then
      if (total_auto) then
        clk_auto_total = clks(1)
        if (clks_size > 1) then
          do i = 2, clks_size
            clk_auto_total = clk_auto_total + clks(i)
          end do
        end if
        call Printf(out_unit, &
          & ' ------------------------------------------------')
        elapsed_time_val_cor = EvalSec(clk_auto_total % elapsed_time)
        if (elapsed_time_val_cor < 0.0_DP) elapsed_time_val_cor = 0.0_DP
        call Printf(out_unit, &
          & ' %c%c  %c', c1=total_time_mes, &
          & c2=trim(result_value_form(elapsed_time_val_cor)), &
          & c3=trim(fit_unit_value(clk_auto_total % elapsed_time)))
      end if
    end if

    call DbgMessage('total results, output to device number %d', &
      & i=(/out_unit/))
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DCClockResult0

  function result_value_form(value) result(result)
    !
    !  value ȤͿ줿ټ¿Υǡ,
    ! ʲΥեޥåȤʸȤ֤ޤ.
    !
    !     0.183400E+02
    !
    use dc_types, only: DP, TOKEN
    implicit none
    character(TOKEN):: result
    real(DP), intent(in):: value
  continue
    write(result, "(e15.6)") value
  end function result_value_form

  function fit_unit_value(diff) result(result)
    !
    !  diff Ϳ줿 DC_DIFFTIME ѿ˳Ǽǡ
    ! ʲΥեޥåȤʸȤ֤ޤ.
    !
    !     (23.18 days)
    !
    ! ñ̤ days, hrs., minutes Ŭ
    ! Фޤ. (ͤ 1 ʾͤȤʤ褦Фޤ).
    ! 1 ʬξ϶ʸ֤ޤ.
    !
    use dc_types, only: DP, TOKEN
    use dc_date_types, only: DC_DIFFTIME
    use dc_date, only: EvalDay, EvalHour, EvalMin, EvalSec
    use dc_types, only: DP
    implicit none
    character(TOKEN):: result
    type(DC_DIFFTIME), intent(in):: diff
    character(TOKEN):: unit
    real(DP):: value
    character(TOKEN):: cval
  continue
    if (EvalDay(diff) > 1.0_DP) then
      unit = ' days'
      value = EvalDay(diff)
    elseif (EvalHour(diff) > 1.0_DP) then
      unit = ' hrs.'
      value = EvalHour(diff)
    elseif (EvalMin(diff) > 1.0_DP) then
      unit = ' minutes'
      value = EvalMin(diff)
    else
      result = ''
      return
    end if
    cval = printf_g5_2(value)
    result = '(' // trim(adjustl(cval)) // trim(unit) // ')'
  end function fit_unit_value

  function printf_g5_2(value) result(result)
    !
    !  value Ϳ줿ͥǡ
    ! ʲΥեޥåȤʸȤ֤ޤ.
    !
    !     23.18
    !      0.23
    !
    use dc_types, only: DP, TOKEN, STRING
    use dc_string, only: CPrintf
    implicit none
    character(TOKEN):: result
    real(DP), intent(in):: value
    character(TOKEN):: int_part, dem_part
    integer:: dem_int
  continue
    write(int_part, "(i20)") int(value)
    dem_int = nint((value - int(value)) * 100)
    if (dem_int < 0) dem_int = - dem_int
    if (dem_int == 100) then
      dem_int = 0
      write(int_part, "(i20)") int(value) + 1
    end if
    dem_part = CPrintf('%02d', i=(/dem_int/))
    result = trim(adjustl(int_part)) // '.' // trim(dem_part)
  end function printf_g5_2


  function DCClockAdd(clk1, clk2) result(clk_total)
    !
    !=== CLOCK ѿ­碌
    !
    ! CLOCK ѿ <b>clk1</b>  <b>clk2</b> ­碌ޤ.
    ! Ϳ줿 2 Ĥ CLOCK  ѿ CPU ֤פ,
    ! CLOCK ѿȤ֤ޤ. ¬Ƥ̾Τ <b>clk1</b>  <b>clk2</b>
    ! ̾Τ '+' Ȥ߹碌ΤȤʤޤ.
    !
    use dc_string, only: CPrintf
    use dc_date, only: operator(+), operator(<), assignment(=)
    implicit none
    type(CLOCK), intent(in):: clk1
    type(CLOCK), intent(in):: clk2
    type(CLOCK):: clk_total
  continue
    if (.not. clk1 % initialized .or. .not. clk2 % initialized) then
      clk_total % initialized = .false.
      return
    end if

    clk_total % name = CPrintf('%c+%c', &
      & c1=trim(clk1 % name), c2=trim(clk2 % name))
    clk_total % start_time = - 1.0
    clk_total % initialized = .true.
    clk_total % elapsed_time = 0.0

    if (clk1 % start_date < clk2 % start_date) then
      clk_total % start_date = clk1 % start_date
    else
      clk_total % start_date = clk2 % start_date
    end if

    clk_total % elapsed_time = &
      & clk1 % elapsed_time + clk2 % elapsed_time
  end function DCClockAdd

  function DCClockSubtract(clk1, clk2) result(clk_total)
    !
    !=== CLOCK ѿ­碌
    !
    ! CLOCK ѿ <b>clk1</b>  <b>clk2</b> ޤ. 
    ! 1 ܤ CLOCK ѿ CPU ֤
    ! 2 ܤ CLOCK ѿ CPU ֤Ȥκ
    ! CLOCK ѿȤ֤ޤ. ¬Ƥ̾Τ <b>clk1</b>  <b>clk2</b>
    ! ̾Τ '-' Ȥ߹碌ΤȤʤޤ.
    !
    use dc_string, only: CPrintf
    use dc_date, only: operator(-), operator(<), assignment(=)
    implicit none
    type(CLOCK), intent(in):: clk1
    type(CLOCK), intent(in):: clk2
    type(CLOCK):: clk_total
  continue
    if (.not. clk1 % initialized .or. .not. clk2 % initialized) then
      clk_total % initialized = .false.
      return
    end if

    clk_total % name = CPrintf('%c-%c', &
      & c1=trim(clk1 % name), c2=trim(clk2 % name))
    clk_total % start_time = - 1.0
    clk_total % initialized = .true.
    clk_total % elapsed_time = 0.0

    if (clk1 % start_date < clk2 % start_date) then
      clk_total % start_date = clk1 % start_date
    else
      clk_total % start_date = clk2 % start_date
    end if

    clk_total % elapsed_time = &
      & clk1 % elapsed_time - clk2 % elapsed_time
  end function DCClockSubtract

  subroutine DCClockSetName0(clk, name, err)
    !
    !=== ¬Ƥ̾Τѹ.
    !
    ! CLOCK ѿ *clk* η¬Ƥ̾Τѹޤ.
    ! ̾Τ Create  *name* ǻꤵ줿ΤǤ.
    !
    !  *clk* Ф DCClockCreate ˤԤƤʤ,
    ! 顼ȯޤ. *err* Ϳˤ *err*  .true. ֤,
    ! ץ³Ԥޤ.
    !
    use dc_message, only: MessageNotify
    use dc_string, only: toChar, CPrintf
    use dc_error, only: StoreError, DC_ENOTINIT, DC_NOERR
    implicit none
    type(CLOCK), intent(inout):: clk
    character(*), intent(in):: name
    logical, intent(out), optional:: err
    character(STRING):: cause_c
    integer:: stat
    character(*), parameter:: subname = 'DCClockSetName'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = 'CLOCK'
    if (.not. clk % initialized) then
      call MessageNotify('W', subname, 'Call Create before Set_Name in dc_clock.')
      call DbgMessage('Ignored because input argument was not initialized.')
      stat = DC_ENOTINIT
      goto 999
    end if
    clk % name = name
    call DbgMessage('set new name "%c"', c1=trim(clk % name))
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DCClockSetName0

  subroutine DCClockPredict0(clk, progress, unit, err)
    !
    !=== ץबλޤǤͽ¬ CPU , ɽ
    !
    ! CLOCK ѿ *clk*  *progress* , ץब
    ! λޤǤͽ¬ CPU , ʲΤ褦ɽޤ.
    !
    !     ########## PREDICTION OF CALCULATION ###########
    !     Start Date             2007-03-08T16:49:25+09:00
    !     Current Date           2007-03-08T16:49:27+09:00
    !     Progress     66.67%  [****************         ]
    !     Remaining CPU TIME      0.100000E+01
    !     Completion Date        2007-03-08T16:49:28+09:00
    !
    ! 2Ǥ *progress* ˤ 0  1 ޤǤͤͿƤ.
    ! ץγϻ 0, λ 1 Ȥޤ. (㤨,
    ! ץबȾʬʤˤ 0.5 Ϳޤ).
    !
    ! ǹԤͽ¬פȤ, ޤǤηв֤
    ! λץʬ̤ñʥ르ꥺǳФƤ
    ! ΤʤΤ, Τͽ¬֤ͤ櫓ǤϤޤ.
    ! ޤܰ¤ȤѤƤ.
    !
    !  *unit* ˤϽֹ
    ! ͿƤ. *unit* Ϳʤ, ɸϤɽޤ.
    !
    !  *clk* Ф DCClockCreate ˤԤƤʤ,
    ! 顼ȯޤ. *err* Ϳˤ *err*  .true. ֤,
    ! ץ³Ԥޤ.
    !
    use dc_types, only: STDOUT, DP
    use dc_message, only: MessageNotify
    use dc_string, only: toChar, CPrintf, Printf
    use dc_error, only: StoreError, DC_ENOTINIT, DC_NOERR
    use dc_date_types, only: DC_DIFFTIME, DC_DATETIME
    use dc_date, only: assignment(=), operator(+), DCDateTimeCreate, toChar, EvalSec
    implicit none
    type(CLOCK), intent(in):: clk
    real, intent(in):: progress
    integer, intent(in), optional:: unit
    logical, intent(out), optional:: err
    character(STRING):: cause_c
    integer:: stat, out_unit
    type(DC_DIFFTIME):: remain_diff
    type(DC_DATETIME):: comp_date, cur_date
    character(7):: prog_percent
    character(25):: prog_bar
    integer:: prog_bar_ptr
    real:: prog_valid
    character(*), parameter:: subname = 'DCClockPredict'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = 'CLOCK'
    if (.not. clk % initialized) then
      call MessageNotify('W', subname, 'Call Create before Predict in dc_clock.')
      call DbgMessage('Ignored because input argument was not initialized.')
      stat = DC_ENOTINIT
      goto 999
    end if
    if (progress <= 0.0) then
      call MessageNotify('W', subname, 'Specify 0.0 -- 1.0 value to "progress"')
      return
    elseif (progress > 1.0) then
      call MessageNotify('W', subname, 'Over 1.0 value to "progress" was modified to 1.0')
      prog_valid = 1.0
    else
      prog_valid = progress
    end if

    if (present(unit)) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    remain_diff = real(nint(EvalSec(clk) / prog_valid * (1.0 - prog_valid)))
    call DCDateTimeCreate(cur_date)
    comp_date = cur_date + remain_diff
    prog_percent = ''
    prog_percent = adjustr(trim(printf_g5_2(real(prog_valid * 100, DP))) // '%')
    prog_bar = ''
    prog_bar_ptr = int(prog_valid * 25)
    if (prog_bar_ptr > 0) prog_bar(1:prog_bar_ptr) = '*************************'

    call Printf(out_unit, '')
    call Printf(out_unit, &
      & ' ########## PREDICTION OF CALCULATION ###########')
    call Printf(out_unit, &
      & ' Start Date             %c', c1=trim(toChar(clk % start_date)))
    call Printf(out_unit, &
      & ' Current Date           %c', c1=trim(toChar(cur_date)))
    call Printf(out_unit, &
      & ' Progress     %c [%c]', c1=prog_percent, c2=prog_bar)
    call Printf(out_unit, &
      & ' Remaining CPU TIME   %c %c', &
      & c1=trim(result_value_form(EvalSec(remain_diff))), &
      & c2=trim(fit_unit_value(remain_diff)))
    call Printf(out_unit, &
      & ' Completion Date        %c', c1=trim(toChar(comp_date)))

999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine DCClockPredict0


end module dc_clock
