!
!= 2 Ĥѿμζ̲
!
! Authors::   Eizi TOYODA, Yasuhiro MORIKAWA
! Version::   $Id: gtvarlimitbinary.f90,v 1.3 2006/03/08 08:50:07 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20060627 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! ʲΥ֥롼󡢴ؿ gtdata_generic  gtdata_generic#Transform
! Ȥ󶡤ޤ

subroutine GTVarXformBinary(var1, var2, err)
  !
  !== 2 Ĥѿμ֤ζ̲
  !
  ! ѿ <b>var1</b> μ <b>var2</b> μƱˤʤ褦
  ! ϰϹ«Ԥޤʼ <b>var1</b> ˤ硢
  ! Ԥޤ(ɲäǤ褦ˤͽǤ)
  !
  ! 顼硢å
  ! ƥץ϶λޤ*err* ͿƤˤ
  ! ΰ .true. ֤ꡢץϽλޤ
  !
  !--
  ! Ĥѿ var1, var2 ϰϹ«äƼ֤̲롣
  ! ̤μϤȤꤢǥǻȤ褦˷᤿
  !    var2 ζ֤ݻ롣var1 ѷ롣
  !    var2 μ (ͭȤ) var2 ˤȤ롣
  !    ä var1 ˤƤ¸ߤʤ var2 򥫥С
  !    ʤФʤʤ
  !    var2 ˤʤ var1 μϸʤ褦ˤʤΤǽषƤ뤫
  !    ¸ߤʤΤǤʤФʤʤ
  !++
  use gtdata_types, only: gt_variable
  use gtdata_generic, only: inquire, get_slice
  use gt_map, only: map_allocate, map_apply, gt_dimmap, gtvar_dump
  use dc_error, only: StoreError, GT_ENOMATCHDIM, GT_EFAKE, DC_NOERR
  use dc_trace, only: beginsub, endsub, DbgMessage
  implicit none
  type(GT_VARIABLE), intent(inout):: var1, var2
  logical, intent(out), optional:: err
  integer:: ndim1, ndim2, ndimo
  integer, allocatable:: map1(:), map2(:)
  type(GT_DIMMAP), pointer:: newmap(:)
  integer:: i, j, stat
  character(*), parameter:: subnam = "GTVarXformBinary"
continue
  call beginsub(subnam, 'mapid=[%d, %d]', i=(/var1%mapid, var2%mapid/))
  call gtvar_dump(var1)
  call gtvar_dump(var2)
  !
  ! Ĥѿ var1, var2 鶦ͭĴ١бɽ map1, map2 Ĥ롣
  !
  if (present(err)) err = .false.
  call inquire(var1, alldims=ndim1)
  call inquire(var2, alldims=ndim2)
  ndimo = max(ndim1, ndim2, 0)
  allocate(map1(1:ndim1), map2(1:ndim2))
  call getmatch(var1, var2, ndim1, ndim2, map1, map2)
  call DbgMessage('map1=%*d map2=%*d', i=(/map1(1:ndim1), map2(1:ndim2)/), n=(/ndim1, ndim2/))
  if (all(map2(1:ndim2) == 0)) then
    stat = gt_enomatchdim
    goto 999
  endif
  !
  ! ֥ơ֥
  !
  ndimo = ndim2 + count(map1(1:ndim1) == 0)
  call map_allocate(newmap, ndimo)
  !
  ! 1..ndim2  map2 ˤä var2 μ˥ޥåפ
  !
  newmap(1:ndim2)%dimno = map2(1:ndim2)
  call inquire(var2, allcount=newmap(1:ndim2)%allcount)
  call get_slice(var2, count=newmap(1:ndim2)%count)
  do, j = 1, ndim2
    if (map2(j) == 0) then
      newmap(j)%start = 1
      newmap(j)%stride = 1
      call inquire(var2, j, url=newmap(j)%url)
    else
      ! бˤä var1 ¦Ǥγϰ֤ꤹ
      call adjust_slice(var1, var2, map2(j), j, &
        & newmap(j)%start, newmap(j)%stride)
    endif
  enddo
  !
  ! ndim2+1.. ndimo  var2 бʤ var1 μ򤪤
  !
  j = 0
  loop1: do, i = ndim2 + 1, ndimo
    do
      j = j + 1
      if (j > ndim1) exit loop1
      if (map1(j) <= 0) exit
    enddo
    newmap(i)%dimno = j
    call inquire(var1, dimord=j, allcount=newmap(i)%allcount)
    call get_slice(var1, dimord=j, start=newmap(i)%start, &
      & count=newmap(i)%count, stride=newmap(i)%stride)
  end do loop1
  !
  call map_apply(var1, map=newmap)
  !
  stat = dc_noerr
999 continue
  call StoreError(stat, subnam, err)
  call endsub(subnam, 'stat=%d', i=(/stat/))
  deallocate(map1, map2)
  return
contains

  !
  ! ĤμѿĴ١֤б褦
  ! start եȿ stride եꤹ
  !
  subroutine adjust_slice(var1, var2, idim1, idim2, offset, stepfact)
    use gtdata_generic, only: get, open, close
    type(GT_VARIABLE), intent(in):: var1, var2
    integer, intent(in):: idim1, idim2
    integer, intent(out):: offset, stepfact
    type(GT_VARIABLE):: var_d
    integer:: n, buf(1)
    real, allocatable:: val1(:), val2(:)
  continue
    call beginsub('adjust_slice')
    call open(var_d, source_var=var1, dimord=idim1, count_compact=.true.)
    call inquire(var_d, size=n)
    allocate(val1(n))
    call get(var_d, val1, n)
    call close(var_d)
    !
    call open(var_d, source_var=var2, dimord=idim2, count_compact=.true.)
    call inquire(var_d, size=n)
    allocate(val2(n))
    call get(var_d, val2, n)
    call close(var_d)
    !
    buf(1:1) = minloc(abs(val1(:) - val2(1)))
    offset = buf(1) - 1
    if (size(val2) < 2 .or. size(val1) < 2) then
      stepfact = 1
    else
      buf(1:1) = minloc(abs(val1(:) - val2(2)))
      stepfact = buf(1) - (offset + 1)
    endif
    !
    deallocate(val1, val2)
    call endsub('adjust_slice')
  end subroutine adjust_slice

  !
  ! Ĥѿ鶦ͭĴ١бɽ map1, map2 롣
  ! ʤ줾μֹ椫μֹɽǤ롣
  !
  subroutine getmatch(var1, var2, ndim1, ndim2, map1, map2)
    use dc_types, only: STRING
    use dc_units, only: UNITS, add_okay, assignment(=)
    use gtdata_generic, only: get_attr, open, close
    type(GT_VARIABLE), intent(in):: var1, var2
    integer, intent(in):: ndim1, ndim2
    integer, intent(out):: map1(:), map2(:)
    type(GT_VARIABLE):: var_d
    integer, allocatable:: map(:, :)
    integer:: i, j
    character(STRING):: su1, su2
    type(UNITS), allocatable:: u1(:), u2(:)
  continue
    call beginsub('getmatch')
    ! ֵͤϥǥե 0
    map1(:) = 0
    map2(:) = 0
    ! ɽι: ͤϾõˡȤ뤳Ȥ򼨤
    allocate(map(ndim1, ndim2))
    map(:, :) = 1

    ! ñ̤ˤб --- ûǽǤʤФˤʤ
    ! ñ̤ι
    allocate(u1(ndim1), u2(ndim2))
    do, i = 1, ndim1
      call open(var_d, var1, i, count_compact=.true.)
      call get_attr(var_d, 'units', su1)
      call close(var_d)
      call clear(u1(i))
      u1(i) = su1
    enddo
    do, j = 1, ndim2
      call open(var_d, var2, j, count_compact=.true.)
      call get_attr(var_d, 'units', su2)
      call close(var_d)
      call clear(u2(j))
      u2(j) = su2
    enddo
    ! 
    do, i = 1, ndim1
      do, j = 1, ndim2
        if (.not. add_okay(u1(i), u2(j))) &
          & map(i, j) = 0
      enddo
    enddo
    ! ñ̤Ѵ
    do, i = 1, ndim1
      call deallocate(u1(i))
    enddo
    do, j = 1, ndim2
      call deallocate(u2(j))
    enddo
    deallocate(u1, u2)

    if (map_finished(map)) goto 1000

    ! --- it fails ---
    call endsub('getmatch', 'fail')
    return

1000 continue
    do, i = 1, ndim1
      call DbgMessage('map(%d, :)=%*d', i=(/i, map(i,:)/), n=(/ndim2/))
    enddo
    do, i = 1, ndim1
      if (all(map(i, :) <= 0)) then
        map1(i) = 0
      else
        map1(i:i) = maxloc(map(i, :))
      endif
    enddo
    do, j = 1, ndim2
      if (all(map(:, j) <= 0)) then 
        map2(j) = 0
      else
        map2(j:j) = maxloc(map(:, j), dim=1)
      endif
    enddo
    call endsub('getmatch', 'okay')
  end subroutine getmatch

  logical function map_finished(map) result(result)
    integer:: map(:, :)
    integer:: i, j, ni
  continue
    call beginsub('map_finished')
    ni = size(map, dim=1)
    do, i = 1, ni
      if (count(map(i, :) > 0) > 1) then
        result = .false.
        goto 999
      endif
    enddo
    do, j = 1, ni
      if (count(map(j, :) > 0) > 1) then
        result = .false.
        goto 999
      endif
    enddo
    result = .true.
999 continue
    call endsub('map_finished')
  end function map_finished

end subroutine GTVarXformBinary
