!
!= ѿΥԡ
!
! Authors::   Yasuhiro MORIKAWA, Eizi TOYODA
! Version::   $Id: gtvarcreatecopy.f90,v 1.5 2006/06/11 08:28:02 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20060719-1 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! ʲΥ֥롼, ؿ gtdata_generic 󶡤ޤ
!

subroutine GTVarCreateCopyC(var, url, copyfrom, copyvalue, &
  & overwrite, err)
  !
  !== ѿΥԡ
  !
  ! ѿ *copyfrom* Ʊ°äѿ *url* ˺ޤ
  ! ɬפʤмѿʣޤ
  ! *copyvalue*  <tt>.true.</tt> ˻ꤹͤʣޤ
  ! 줿ѿ ID  var ֤ޤ
  !
  ! ¸ѿȤԤޤ
  ! overwrite == .true. Ǥо񤭤³Ԥޤ
  ! (ޤ *overwrite* ưݾ㤵Ƥޤ)
  !
  ! κݤ˥顼硢åϤƥץ
  ! λޤ*err* ͿƤˤϤΰ .true.
  ! ֤ꡢץϽλޤ
  !
  !--
  ! ʤѿʣ copyfrom  url ۤʤե
  ! ܤäƤ˹Ԥʤ롣 netCDF/an ꤷΤ
  ! ۤΥեɲä줿Ȥˤѹפ뤫⤷ʤ
  !++
  !
  use gtdata_types, only: GT_VARIABLE
  use dc_types, only: STRING, TOKEN
  use gtdata_generic, only: Open, Inquire, Close, Create, Copy_Attr
  use dc_url, only: UrlSplit, GT_ATMARK
  use dc_trace, only: BeginSub, EndSub
  use dc_error, only: StoreError, GT_ENOMEM
  implicit none
  intrinsic trim
  type(GT_VARIABLE),    intent(out)   :: var
  character(len = *),   intent(in)    :: url
  type(GT_VARIABLE),    intent(inout) :: copyfrom
  logical, intent(in),  optional      :: copyvalue
  logical, intent(in),  optional      :: overwrite
  logical, intent(out), optional      :: err
  type(GT_VARIABLE),    allocatable   :: vDimSource(:)
  type(GT_VARIABLE),    allocatable   :: vDimDest(:)
  integer                             :: i, nd, stat
  logical                             :: myerr
  character(STRING)                   :: vpart, upart, desturl
  character(TOKEN)                    :: xtype
  character(len = *),      parameter:: version = &
    & '$Name: gt4f90io-20060719-1 $' // &
    & '$Id: gtvarcreatecopy.f90,v 1.5 2006/06/11 08:28:02 morikawa Exp $'
continue
  call BeginSub('gtvarcreatecopy', 'url=%c copyfrom=%d', &
    & c1=trim(url), i=(/copyfrom%mapid/), version=version)
  stat = 0
  myerr = .FALSE.
  !-----------------------------------------------------------------
  !  ԡѿμ򥳥ԡΥե˺
  !-----------------------------------------------------------------
  !----- ԡ copyfrom μѿμ -----
  call Inquire(copyfrom, alldims=nd)
  allocate(vDimSource(nd), vDimDest(nd), stat=stat)
  if (stat /= 0) goto 999
  desturl = url
  !----- ԡ copyfrom γƼ vDimSource ˼Ф, -----
  !----- 򥳥ԡ desturl إԡƤμ ID        -----
  !----- vDimDest ֤Ƥ餦.                                -----
  do, i = 1, nd
    call Open(vDimSource(i), copyfrom, dimord=i, &
      & count_compact=.TRUE., err=myerr)
    call GTVarCopyDim(to=vDimDest(i), from=vDimSource(i), &
      & target=desturl)
  end do
  !-----------------------------------------------------------------
  !  ѿ
  !-----------------------------------------------------------------
  !----- url ѿ̵̾, ԡѿ̾ -----
  call UrlSplit(url, var=vpart)
  if (vpart == "") then
    call Inquire(copyfrom, url=upart)
    call UrlSplit(upart, var=vpart)
    desturl = trim(desturl) // GT_ATMARK // trim(vpart)
  end if
  !----- ºݤѿ -----
  call Inquire(copyfrom, xtype=xtype)
  call Create(var, trim(desturl), dims=vDimDest, xtype=xtype, &
    &      overwrite=overwrite, err=myerr)
  if (myerr) goto 990
  call copy_attr(to=var, from=copyfrom, err=myerr)
  if (myerr) goto 990
  if (present(copyvalue)) then
    if (copyvalue) then
      call GTVarCopyValue(to=var, from=copyfrom)
    endif
  endif
  do, i = 1, nd
    call Close(vDimSource(i))
    call Close(vDimDest(i))
  end do
990 continue
  deallocate(vDimSource, vDimDest, stat=stat)
999 continue
  if (stat /= 0) then
    call StoreError(GT_ENOMEM, "GTVarCreateCopy", err)
  else if (present(err)) then
    err = myerr
  else if (myerr) then
    call DumpError
  end if
  call EndSub('gtvarcreatecopy', 'result=%d', i=(/var%mapid/))
contains

  ! from ƱƤμѿ URL target Ǽѿκ
  ! ȤƻȤ褦 to ʣ̡
  ! ʤ٤ƥץǺѤޤȤ롣
  ! ʣ̤ʤ٤̾碌褦Ȥ롣
  !
  subroutine GTVarCopyDim(to, from, target)
    use gtdata_types
    use dc_string, only: var_str
    use dc_types, only: token, string
    use dc_url, only: UrlSplit, UrlMerge, operator(.onthesamefile.)
    use gtdata_generic, only: Open, Inquire, Create, copy_attr
    type(GT_VARIABLE), intent(out):: to
    type(GT_VARIABLE), intent(inout):: from
    character(len = *), intent(in):: target
    character(len = string):: url, file, dimname
    character(len = token):: xtype
    logical:: growable, myerr
    integer:: length
  continue
    call BeginSub('gtvarcopydim', 'from=%d target=<%c>', &
      & i=(/from%mapid/), c1=trim(target))
    !----- Ʊե˥ԡϻȥ󥿤1Ĳ󤹤 -----
    call Inquire(var=from, url=url)
    if (trim(url) .onthesamefile. trim(target)) then
      call Open(to, from, dimord=0)
      call EndSub('gtvarcopydim', 'dup-handle')
      return
    endif
    !----- ۤʤե˥ԡ, ˼ѿ from  -----
    !----- target μѿȤƴޤޤ뤫å              -----
    call UrlSplit(target, file=file)
    if (LookupEquivalent(to, from, file)) then
      !----- ޤޤϤǽλ -----
      call EndSub('gtvarcopydim', 'equivalent-exists')
      return
    else
      !----- ޤޤʤ缡ѿ from  target ˺ -----
      ! ѿ from ̵¼ǤˤĹ 0 
      call Inquire(var=from, growable=growable, allcount=length)
      if (growable) length = 0
      call Inquire(var=from, xtype=xtype, name=dimname)
      !
      url = urlmerge(file, dimname)
      call Create(to, trim(url), length, xtype, err=myerr)
      if (myerr) then
        ! ̾ΤǤޤʤϼư̾ˤ
        call Create(to, trim(file), length, xtype)
      endif
      call copy_attr(to, from, myerr)
      call GTVarCopyValue(to, from)
      call EndSub('gtvarcopydim', 'created')
      return
    endif
  end subroutine GTVarCopyDim

  !-----------------------------------------------------------------
  !   ѿ from  file ˤΤȽ
  !       ѿ from ԡ nc ե file ˴
  !       ¸ߤʤ .TRUE. ʤʤ .FALSE.  result ֤.
  !       result = .TRUE. ֤ˤϤ˳뼡 ID 
  !       to ֤.
  !       - Ƚ 1) from ̵¼, file ̵¼
  !         Ĥ, ޤ 2) ѿ from ΥȰפ뼡
  !         file ˤ, Ĥμñ̾ from ñ̾Ȱ
  !         뤳.
  !          ⤷Ⱦ郎­ʤΤʤ.
  !-----------------------------------------------------------------
  logical function LookupEquivalent(to, from, file) result(result)
    use dc_types, only: string
    use dc_string, only: var_str, toChar
    use gtdata_generic, only: Inquire, GTVarSearch, Open, get_attr
    type(GT_VARIABLE), intent(out):: to
    type(GT_VARIABLE), intent(in):: from
    character(len = *), intent(in):: file
    character(len = string):: url, units1, units2, reason
    logical:: end, growable1, growable2
    integer:: len1, len2
    character(len = *), parameter:: subnam = "lookupequivalent"
    call BeginSub(subnam, 'from=%d file=<%c>', &
      & i=(/from%mapid/), c1=trim(file))
    result = .FALSE.
    !----- ѿ from Υñ, ̵¼ɤõ -----
    call Inquire(from, allcount=len1, growable=growable1)
    call get_attr(from, 'units', units1, default='')
    !----- ԡ file ѿõ -----
    ! ȤꤢϼǤʤƤѿˤĤƳ
    call GTVarSearch(file)
    do
      call GTVarSearch(url, end)
      if (end) exit
      call Open(to, url, writable=.TRUE., err=end)
      if (end) exit
      ! ѿΥ, ̵¼ɤ
      !   (ѿǤʤΤΥ, ¸뼡ѿΥ
      !    ݤ碌ΤȤʤΤ, ⤷ȸư뤫).
      call Inquire(to, allcount=len2, growable=growable2)
      ! ѿ from ̵¼,  file μѿ
      ! ̵¼ξ, Ʊѿȹͤ.
      if (.not. growable1 .or. .not. growable2) then
        ! ѿ from Υ file μѿΥ
        ! ۤʤϥå
        if (len1 /= len2) then
          call Close(to)
          cycle
        endif
        call get_attr(to, 'units', units2, default='')
        !  dc_units Ӥ٤Ȥꤢʸ
        if (units1 /= units2) then
          call Close(to)
          cycle
        else
          reason = 'length of from is ' // trim(toChar(len1)) // &
            &   '. units of from is ' // "[" //               &
            &   trim(units1) // "]" //                        &
            &   '. And file has same length and units.'
        endif
      else
        reason = 'from is UNLIMITED dimension, and file has it'
      endif
      result = .TRUE.
      call EndSub(subnam, 'found (%c)', c1=trim(reason))
      return
    enddo
    call EndSub(subnam, 'not found')
  end function LookupEquivalent

  ! Ǥ¸ߤѿˤĤơͤ򥳥ԡ롣
  !
  subroutine GTVarCopyValue(to, from)
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: GTVarGetReal, GTVarPutReal, Inquire, Slice, Slice_Next
    use dc_error, only: DumpError
    use dc_string
    type(GT_VARIABLE), intent(inout):: to
    type(GT_VARIABLE), intent(inout):: from
    real, allocatable:: rbuffer(:)
    logical:: err
    integer:: siz, stat
    !
    call BeginSub('gtvarcopyvalue')
    ! ͤΥԡ
    call Slice(from)
    call Slice(to, compatible=from)
    call Inquire(from, size=siz)
    allocate (rbuffer(siz))
    do
      call GTVarGetReal(from, rbuffer, siz, err)
      if (err) call DumpError()
      call GtVarPutReal(to, rbuffer, siz, err)
      if (err) call DumpError()
      call Slice_Next(from, stat=stat)
      if (stat /= 0) exit
      call Slice_Next(to, stat=stat)
    enddo
    deallocate (rbuffer)
    call EndSub('gtvarcopyvalue')
  end subroutine GTVarCopyValue

end subroutine GTVarCreateCopyC
