#!/bin/sh
#---------------------------------------------------------------------
#     Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
#---------------------------------------------------------------------
#= Generate shell script "gt4config".
#
#   * Developers: Eizi TOYODA (toyoda), Yasuhiro MORIKAWA (morikawa)
#   * Version: $Id: gt4configgen.sh,v 1.4 2006/07/17 18:14:33 morikawa Exp $
#   * Tag Name: $Name: gt4f90io-20060827 $
#   * Change History: 
#
fc="$FC"
linker="$LINKF ${MODPATHFLAG}${MODINSTDIR:?}"
fflags="${MODPATHFLAG}${MODINSTDIR:?} $SYSFFLAGS"
ldflags="$SYSLDFLAGS -L$LIBINSTDIR"
ldlibs="-l${LIBNAME} $SYSLDLIBS"
out=${1:-gt4config}

if [ $F90MODTYPE = intel.d ]; then
	ldlibs=`echo $ldlibs | sed s/-lm//`
fi

LINKF_HEAD=`echo "$LINKF" | sed s'/ .*//'`
if [ X"$LINKF_HEAD" = X"$FC" ]; then
    linker_is_not_fortran=0
else
    linker_is_not_fortran=1
fi

cat > $out <<END_OF_HEADER
#!/bin/sh

fc="$fc"
linker="$linker"
fflags="$fflags"
ldflags="$ldflags"
ldlibs="$ldlibs"
END_OF_HEADER


if [ $linker_is_not_fortran = 0 ]; then
    cat >> $out <<END_OF_SCRIPT
usage() {
	cat <<EOF
usage: gt4config [OPTIONS]
options: one of --fc --fflags --ldflags --ldlibs
EOF
	exit 1
}

if test \$# -eq 0; then
	usage
fi

while test \$# -gt 0; do
    case \$1 in
	--fc)		echo \$fc ;;
	--fflags)	echo \$fflags ;;
	--ldflags)	echo \$ldflags ;;
	--ldlibs)	echo \$ldlibs ;;
	*)		usage ;;
    esac
    shift
done

END_OF_SCRIPT

else
    cat >> $out <<END_OF_SCRIPT
usage() {
	cat <<EOF
usage: gt4config [OPTIONS]
options: one of --fc --linker --fflags --ldflags --ldlibs
EOF
	exit 1
}

if test \$# -eq 0; then
	usage
fi

while test \$# -gt 0; do
    case \$1 in
	--fc)		echo \$fc ;;
	--linker)	echo \$linker ;;
	--fflags)	echo \$fflags ;;
	--ldflags)	echo \$ldflags ;;
	--ldlibs)	echo \$ldlibs ;;
	*)		usage ;;
    esac
    shift
done

END_OF_SCRIPT

fi