!== dc_date.f90 - դӻ˴ؤ³󶡤⥸塼
!
! Authors::   Yasuhiro MORIKAWA, Eizi TOYODA
! Version::   $Id: dc_date.f90,v 1.21 2007/06/15 04:59:09 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20070615 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]

module dc_date
  !== Overview
  !
  ! դӻ򰷤μ³󶡤ޤ
  !
  !== List
  !
  ! ʲμ³Ϲ¤ dc_date_types#DC_DATETIME ޤ
  ! dc_date_types#DC_DIFFTIME ѿ (, ˴ؤǼ)
  ! оݤȤޤ.
  !
  ! Create      :: 
  !
  ! #assignment(=) :: 
  !
  ! Eval        :: , ̤˼
  !
  ! toChar      :: , ʸѿѴ
  !
  ! PutLine    :: , ΰԤޤ.
  !
  ! EvalDay     ::  (¿) ˴Ƽ
  ! EvalHour    ::  (¿) ˴Ƽ
  ! EvalMin     :: ʬ (¿) ˴Ƽ
  ! EvalSec     ::  (¿) ˴Ƽ
  ! EvalByUnit  :: ñ̤ꤷ, , , ʬ, äΤŤ줫 (¿) 
  !                ˴Ƽ
  !
  ! #operator(+)  :: û (dc_date_types#DC_DATETIME  
  !                  dc_date_types#DC_DIFFTIME  Ʊ)
  ! #operator(-)  ::  (dc_date_types#DC_DATETIME  
  !                  dc_date_types#DC_DIFFTIME  Ʊ)
  ! #operator(*)  :: 軻 (dc_date_types#DC_DIFFTIME ȿͷ)
  ! #operator(/)  ::  (dc_date_types#DC_DIFFTIME ȿͷ)
  ! mod           :: ; (dc_date_types#DC_DIFFTIME Ʊ)
  ! #operator(==) ::  (dc_date_types#DC_DATETIME Ʊ)
  ! #operator(>)  ::  (dc_date_types#DC_DATETIME Ʊ)
  ! #operator(<)  ::  (dc_date_types#DC_DATETIME Ʊ)
  !
  ! SetZone     :: ॾѹ
  !
  !
  ! ʲμ³ dc_date_types ѿѹޤ.
  !
  ! SetCaltype  :: ˡΥǥեȤѹ
  ! SetSecOfDay :: 1 ÿΥǥեȤѹ
  !
  ! ¾μ³
  !
  ! ValidCaltype :: ˡͭʤΤå
  ! ValidZone    :: ॾȤͭå
  ! ZoneToDiff   :: ॾ dc_date_types#DC_DIFFTIME ѿؤѴ
  !
  !== Usage
  !
  !=== ߻ɽ
  !
  ! DC_DATETIME ѿ˥֥롼 Create Ѥ, 郎ꤵޤ.
  ! Τ褦äǯꤷʤȸ߻郎ꤵޤ.
  ! ꤵ줿 toChar ˤäʸѿؤѴǤޤ.
  ! ֥롼 Printf ˴ؤƤ dc_string#Printf 򻲾Ȥ.
  !
  !     program dc_date_sapmle1
  !       use dc_string, only: Printf
  !       use dc_date_types, only: DC_DATETIME
  !       use dc_date, only: Create, toChar
  !       implicit none
  !       type(DC_DATETIME) :: time
  !
  !       call Create(time)
  !       call Printf(fmt='current date and time is %c', c1=trim(toChar(time)))
  !     end program dc_date_sapmle1
  !
  !=== , βû
  !
  ! DC_DIFFTIME ѿɽޤ. Ǥ,
  ! ɽ뤿ѿȤ *diff*
  ! Ѱդ, ֥롼 Create ˤä 25  + 12  + 50 ʬ
  ! ꤷƤޤ. DC_DATETIME ѿ *time_before*  *diff* Ȥ
  ! #operator(+) ˤäƲû뤳Ȥ *time_before* 
  ! 25  + 12  + 50 ʬʤ᤿ *time_after* Ƥޤ.
  !
  !     program dc_date_sapmle2
  !       use dc_string, only: Printf
  !       use dc_date_types, only: DC_DATETIME, DC_DIFFTIME
  !       use dc_date, only: Create, toChar, operator(+)
  !       implicit none
  !       type(DC_DATETIME) :: time_before, time_after
  !       type(DC_DIFFTIME) :: diff
  !
  !       call Create(time_before, year=2006, mon=6, day=10, hour=14, min=15, sec=0.0d0)
  !       call Create(diff, day=25, hour=12, min=50)
  !       time_after = time_before + diff
  !
  !       call Printf(fmt='%c + %c = %c', &
  !         & c1=trim(toChar(time_before)), c2=trim(toChar(diff)), &
  !         & c3=trim(toChar(time_after)))
  !     end program dc_date_sapmle2
  !
  !
  !=== ʬΥ롼פؤα
  !
  ! ʲ dA/dt = - A ( 1, =0.0001)  t = 12 ()
  ! ޤǲ򤯥ץǤ. ʬˤʺʬѤƤޤ.
  ! t, ǡνϴֳ, ׻֤ DC_DIFFTIME Ѥ뤳Ȥ,
  ! 롼פνλ
  ! ǡϤκݤλӤưפȤʤޤ.
  !
  !     program dc_date_sapmle3
  !       use dc_types, only: DP
  !       use dc_date, only: Create, EvalSec, EvalByUnit, mod, &
  !         & operator(*), operator(==), operator(>)
  !       use dc_date_types, only: DC_DIFFTIME
  !       implicit none
  !       real(DP)                :: func_a = 1.0d0    ! ؿ A ν
  !       real(DP), parameter     :: alph   = 0.0001d0 !  
  !       character(*), parameter :: out_unit = 'hour' ! Ϥñ
  !       type(DC_DIFFTIME):: DelTimef, intervalf, calctimef
  !       integer :: i
  !     continue
  !       call Create(DelTimef,   5.0d0, 'sec')   ! t              =  5.0 ()
  !       call Create(intervalf,  1.0d0, 'min')   ! ǡνϴֳ =  1.0 (ʬ)
  !       call Create(calctimef, 12.0d0, 'hour')  ! ׻         = 12.0 ()
  !     
  !       open(10, file='dc_date_sample.dat')
  !       write(10,'(A,A,A)') '#  ', out_unit, '                value'
  !     
  !       i = 1
  !       do
  !         if (DelTimef * i > calctimef) exit    ! ׻֤᤮齪λ
  !     
  !         !---------------------------------------------
  !         ! A_(n+1) = (1 - t) * A_(n)
  !         !---------------------------------------------
  !         func_a = (1.0 - alph * EvalSec(DelTimef)) * func_a
  !     
  !         !---------------------------------------------
  !         ! intervalf (1 ʬ) ˥ǡ
  !         !---------------------------------------------
  !         if (mod(DelTimef * i, intervalf) == 0) then
  !           write(10,*) ' ', EvalByUnit(DelTimef * i, out_unit), func_a
  !         end if
  !         i = i + 1
  !       end do
  !     end program dc_date_sapmle3
  !
  !


  ! ջȻֳִ֤̤롣
  ! ˤäƼޤ륵֥롼 dc_date_types ֤

  use dc_date_types, only: DC_DATETIME, DC_DIFFTIME
  use dc_types,      only: DP, STRING
  use dc_present,    only: present_and_not_empty
  implicit none

  private
  public :: Create, assignment(=), Eval
  public :: SetCaltype, SetZone, SetSecOfDay
  public :: ValidCaltype, ValidZone, ZoneToDiff
  public :: mod, operator(/), operator(-), operator(+), operator(*)
  public :: operator(<), operator(>), operator(==)
  public :: toChar, EvalDay, EvalHour, EvalMin, EvalSec, EvalByUnit, PutLine
  public :: dcdate_normalize, dcdate_parse_unit

  interface Create
    subroutine DCDateTimeCreate1(time, &
      & year, mon, day, hour, min, sec, &
      & zone, caltype, day_seconds, err) !:doc-priority 40:
      use dc_types, only: DP
      use dc_date_types, only: DC_DATETIME
      type(DC_DATETIME), intent(out):: time
      integer, intent(in), optional:: year, mon, day, hour, min
      real(DP),intent(in), optional:: sec, day_seconds
      character(*), intent(in), optional :: zone
      integer, intent(in), optional:: caltype
      logical, intent(out), optional:: err
    end subroutine DCDateTimeCreate1

    subroutine DCDiffTimeCreate1(diff, &
      & year, mon, day, hour, min, sec, day_seconds) !:doc-priority 60:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      type(DC_DIFFTIME), intent(out) :: diff
      integer, intent(in), optional:: year, mon, day, hour, min
      real(DP),intent(in), optional:: sec, day_seconds
    end subroutine DCDiffTimeCreate1

    subroutine DCDiffTimeCreate2(diff, value, unit, err) !:doc-priority 70:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      type(DC_DIFFTIME), intent(out) :: diff
      real(DP), intent(in) :: value
      character(*), intent(in) :: unit
      logical, intent(out), optional :: err
    end subroutine DCDiffTimeCreate2
  end interface


  interface assignment(=)

    subroutine DCDateTimeCreateR(time, sec) !:doc-priority 30:
      use dc_date_types, only: DC_DATETIME
      type(DC_DATETIME), intent(out):: time
      real, intent(in):: sec
    end subroutine DCDateTimeCreateR

    subroutine DCDateTimeCreateD(time, sec) !:doc-priority 40:
      use dc_types, only: DP
      use dc_date_types, only: DC_DATETIME
      type(DC_DATETIME), intent(out):: time
      real(DP), intent(in):: sec
    end subroutine DCDateTimeCreateD

    subroutine DCDiffTimeCreateR(diff, sec) !:doc-priority 60:
      use dc_date_types, only: DC_DIFFTIME
      type(DC_DIFFTIME), intent(out):: diff
      real, intent(in):: sec
    end subroutine DCDiffTimeCreateR

    subroutine DCDiffTimeCreateD(diff, sec) !:doc-priority 70:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      type(DC_DIFFTIME), intent(out):: diff
      real(DP), intent(in):: sec
    end subroutine DCDiffTimeCreateD

!!$    subroutine DCDateLetFC(diff, string)
!!$      use dc_date_types, only: DC_DIFFTIME
!!$      type(DC_DIFFTIME), intent(out):: diff
!!$      character(len = *), intent(in):: string
!!$    end subroutine DCDateLetFC
!!$
!!$    subroutine DCDateLetTC(time, string)
!!$      use dc_date_types, only: DC_DATETIME
!!$      type(DC_DATETIME), intent(out):: time
!!$      character(len = *), intent(in):: string
!!$    end subroutine DCDateLetTC

  end interface

  interface SetCaltype
    subroutine DCDateTimeSetCaltype(caltype)
      integer, intent(in):: caltype
    end subroutine DCDateTimeSetCaltype
  end interface

  interface SetSecOfDay
    subroutine DCDateTimeSetSecOfDay(sec)
      use dc_types, only: DP
      real(DP), intent(in):: sec
    end subroutine DCDateTimeSetSecOfDay
  end interface

  interface ValidCaltype
    function DCDateTimeValidCaltype(caltype) result(result)
      integer, intent(in):: caltype
      logical:: result
    end function DCDateTimeValidCaltype
  end interface

  interface ValidZone
    function DCDateTimeValidZone(zone) result(result)
      character(*), intent(in):: zone
      logical:: result
    end function DCDateTimeValidZone
  end interface

  interface ZoneToDiff
    function DCDateTimeZoneToDiff(zone) result(diff)
      use dc_date_types, only: DC_DIFFTIME
      type(DC_DIFFTIME):: diff
      character(*), intent(in):: zone
    end function DCDateTimeZoneToDiff
  end interface

  interface SetZone
    subroutine DCDateTimeSetZone(time, zone, err)
      use dc_date_types, only: DC_DATETIME
      type(DC_DATETIME), intent(inout):: time
      character(*), intent(in):: zone
      logical, intent(out), optional:: err
    end subroutine DCDateTimeSetZone
  end interface


  interface Eval

    subroutine DCDateTimeEval1(time, &
      & year, mon, day, hour, min, sec, caltype, zone)  !:doc-priority 40:
      use dc_types, only: DP
      use dc_date_types, only: DC_DATETIME
      type(DC_DATETIME), intent(in):: time
      integer, intent(out), optional:: year, mon, day, hour, min, caltype
      real(DP), intent(out), optional:: sec
      character(*), intent(out), optional:: zone
    end subroutine DCDateTimeEval1

!!$    subroutine DCDateTimeEval0(time, mon, day, sec)
!!$      use dc_date_types, only: DC_DATETIME
!!$      use dc_types,      only: DP
!!$      type(DC_DATETIME), intent(in):: time
!!$      integer, intent(out):: mon, day
!!$      real(DP), intent(out):: sec
!!$    end subroutine DCDateTimeEval0

    subroutine DCDiffTimeEval1(diff, year, mon, day, hour, min, sec)  !:doc-priority 60:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      type(DC_DIFFTIME), intent(in):: diff
      integer, intent(out), optional:: year, mon, day, hour, min
      real(DP), intent(out), optional:: sec
    end subroutine DCDiffTimeEval1

  end interface

  interface EvalDay
    function DCDateTimeEvalDay(time) result(result)  !:doc-priority 40:
      use dc_types, only: DP
      use dc_date_types, only: DC_DATETIME
      real(DP):: result
      type(DC_DATETIME), intent(in):: time
    end function DCDateTimeEvalDay

    function DCDiffTimeEvalDay(diff) result(result)  !:doc-priority 60:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      real(DP):: result
      type(DC_DIFFTIME), intent(in):: diff
    end function DCDiffTimeEvalDay
  end interface

  interface EvalHour
    function DCDateTimeEvalHour(time) result(result) !:doc-priority 40:
      use dc_types, only: DP
      use dc_date_types, only: DC_DATETIME
      real(DP):: result
      type(DC_DATETIME), intent(in):: time
    end function DCDateTimeEvalHour

    function DCDifftimeEvalHour(diff) result(result) !:doc-priority 60:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      real(DP):: result
      type(DC_DIFFTIME), intent(in):: diff
    end function DCDifftimeEvalHour
  end interface

  interface EvalMin
    function DCDateTimeEvalMin(time) result(result) !:doc-priority 40:
      use dc_types, only: DP
      use dc_date_types, only: DC_DATETIME
      real(DP):: result
      type(DC_DATETIME), intent(in):: time
    end function DCDateTimeEvalMin

    function DCDifftimeEvalMin(diff) result(result) !:doc-priority 60:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      real(DP):: result
      type(DC_DIFFTIME), intent(in):: diff
    end function DCDifftimeEvalMin
  end interface

  interface EvalSec
    function DCDateTimeEvalSec(time) result(result) !:doc-priority 40:
      use dc_types, only: DP
      use dc_date_types, only: DC_DATETIME
      real(DP):: result
      type(DC_DATETIME), intent(in):: time
    end function DCDateTimeEvalSec

    function DCDifftimeEvalSec(diff) result(result) !:doc-priority 60:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      real(DP):: result
      type(DC_DIFFTIME), intent(in):: diff
    end function DCDifftimeEvalSec
  end interface

  interface EvalByUnit

    function DCDateTimeEvalByUnit(time, unit) result(result)
      use dc_types, only: DP, TOKEN
      use dc_date_types, only: DC_DATETIME
      real(DP):: result
      type(DC_DATETIME), intent(in):: time
      character(*), intent(in):: unit
    end function DCDateTimeEvalByUnit

    function DCDiffTimeEvalByUnit(diff, unit) result(result)
      use dc_types, only: DP, TOKEN
      use dc_date_types, only: DC_DIFFTIME
      real(DP):: result
      type(DC_DIFFTIME), intent(in):: diff
      character(*), intent(in):: unit
    end function DCDiffTimeEvalByUnit
  end interface



  interface toChar
    function DCDateTimeToChar(time) result(result) !:doc-priority 40:
      use dc_types, only: STRING
      use dc_date_types, only: DC_DATETIME
      character(STRING) :: result
      type(DC_DATETIME), intent(in):: time
    end function DCDateTimeToChar

    function DCDiffTimeToChar(diff) result(result) !:doc-priority 60:
      use dc_types, only: STRING
      use dc_date_types, only: DC_DIFFTIME
      character(STRING) :: result
      type(DC_DIFFTIME), intent(in):: diff
    end function DCDiffTimeToChar
  end interface

  interface PutLine
    subroutine DCDateTimePutLine(time, unit)
      use dc_date_types, only: DC_DATETIME
      type(DC_DATETIME), intent(in) :: time
      integer, intent(in), optional :: unit
    end subroutine DCDateTimePutLine

    subroutine DCDiffTimePutLine(diff, unit)
      use dc_date_types, only: DC_DIFFTIME
      type(DC_DIFFTIME), intent(in) :: diff
      integer, intent(in), optional :: unit
    end subroutine DCDiffTimePutLine
  end interface

  interface operator(+)
    module procedure dcdate_add_ft
    module procedure dcdate_add_tf
    module procedure dcdate_add_ff
  end interface

  interface operator(-)
    module procedure dcdate_sub_tf !:doc-priority 40:
    module procedure dcdate_sub_tt
    module procedure dcdate_sub_ff
  end interface

  interface operator(*)
    module procedure dcdate_mul_if !:doc-priority 51:
    module procedure dcdate_mul_fi !:doc-priority 52:
    module procedure dcdate_mul_rf !:doc-priority 61:
    module procedure dcdate_mul_fr !:doc-priority 62:
    module procedure dcdate_mul_df !:doc-priority 71:
    module procedure dcdate_mul_fd !:doc-priority 72:
  end interface

  interface operator(/)
    module procedure dcdate_div_fi
    module procedure dcdate_div_fr
    module procedure dcdate_div_fd
    module procedure dcdate_div_ff
  end interface

  interface mod
    module procedure dcdate_mod_ff
  end interface

  interface operator(==)
    module procedure dcdate_eq_tt !:doc-priority 30:
    module procedure dcdate_eq_ff !:doc-priority 40:
    module procedure dcdate_eq_if !:doc-priority 51:
    module procedure dcdate_eq_fi !:doc-priority 52:
    module procedure dcdate_eq_rf !:doc-priority 61:
    module procedure dcdate_eq_fr !:doc-priority 62:
    module procedure dcdate_eq_df !:doc-priority 71:
    module procedure dcdate_eq_fd !:doc-priority 72:
  end interface

  interface operator(>)
    module procedure dcdate_gt_tt !:doc-priority 30:
    module procedure dcdate_gt_ff !:doc-priority 40:
  end interface

  interface operator(<)
    module procedure dcdate_lt_tt !:doc-priority 30:
    module procedure dcdate_lt_ff !:doc-priority 40:
  end interface


contains

  subroutine dcdate_normalize(day, sec, day_seconds)
    !
    !=== ä
    !
    ! Υ֥롼ʤΤ dc_date ⥸塼볰Ǥ
    ! ϻѤʤǤ.
    !
    !  *day* ÿ *sec* Ԥޤ. *sec*  *day_seconds*
    ! (ά dc_date_types#day_seconds) Ķ, *day*
    ! ˷夲Ԥޤ.
    ! ޤ, *sec*  *day* 椬դξ, Ʊˤʤ褦
    ! ꤷޤ.
    !
    use dc_date_types, only: day_seconds_default => day_seconds
    implicit none
    integer, intent(inout):: day
    real(DP), intent(inout):: sec
    real(DP), intent(in), optional:: day_seconds
    integer:: sgn
    real(DP):: day_sec
  continue
    if (present(day_seconds)) then
      day_sec = day_seconds
    else
      day_sec = day_seconds_default
    end if
    if (abs(sec) > day_sec) then
      day = day + int(sec / day_sec)
      sec = modulo(sec, day_sec)
    end if
    if ((sec > 0.0 .and. day < 0) .or. (sec < 0.0 .and. day > 0)) then
      sgn = sign(day, 1)
      day = day - sgn
      sec = sec + sgn * day_sec
    endif
  end subroutine dcdate_normalize

  character(TOKEN) function dcdate_parse_unit(str) result(unit)
    !
    ! Υ֥롼ʤΤ dc_date ⥸塼볰Ǥ
    ! ϻѤʤǤ.
    !
    !  *str* Ϳ줿ʸᤷ, ñ̤
    ! ֤ޤ. 줾ʲʸñ̤ȤƲᤵޤ.
    ! ʸȾʸ϶̤ޤ.
    ! ֤ʸϰʲʸƬʸǤ.
    ! (: *str*  'hrs.' Ϳ, dc_date_types#UNIT_HOUR
    ! Ƭʸ UNIT_HOUR(1) ֤ޤ.)
    !
    ! ǯ :: dc_date_types#UNIT_YEAR
    !  :: dc_date_types#UNIT_MONTH
    !  :: dc_date_types#UNIT_DAY
    !  :: dc_date_types#UNIT_HOUR
    ! ʬ :: dc_date_types#UNIT_MIN
    !  :: dc_date_types#UNIT_SEC
    !
    ! ˳ʤʸ *str* Ϳ, ʸ֤ޤ.
    !
    use dc_types, only: TOKEN
    use dc_date_types, only: UNIT_YEAR, UNIT_MONTH, UNIT_DAY, &
      & UNIT_HOUR, UNIT_MIN, UNIT_SEC
    use dc_string, only: StriEq
    implicit none
    character(*), intent(in):: str
    integer :: unit_str_size, i
  continue
    unit = adjustl(str)
    unit_str_size = size(UNIT_SEC)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_SEC(i)))) then
        unit = UNIT_SEC(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_MIN)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_MIN(i)))) then
        unit = UNIT_MIN(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_HOUR)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_HOUR(i)))) then
        unit = UNIT_HOUR(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_DAY)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_DAY(i)))) then
        unit = UNIT_DAY(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_MONTH)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_MONTH(i)))) then
        unit = UNIT_MONTH(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_YEAR)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_YEAR(i)))) then
        unit = UNIT_YEAR(1)
        return
      end if
    end do

    unit = ''

  end function dcdate_parse_unit

  type(DC_DATETIME) function dcdate_add_ft(diff, time) result(result)
    !
    ! 2 Ĥ (DC_DATETIME ) ⤷
    !  (DC_DIFFTIME )βûԤޤ.
    !
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    type(DC_DATETIME), intent(in):: time
    integer:: time_year, time_mon, time_day, time_caltype
    real(DP):: time_sec
    character(6):: time_zone
  continue
    call Eval(time, year = time_year, mon = time_mon, day = time_day, &
      & sec = time_sec, caltype = time_caltype, zone = time_zone)
    call Create(result, year=time_year, mon = time_mon + diff % mon, &
      & day = time_day + diff % day, &
      & sec = time_sec + diff % sec, &
      & caltype = time_caltype, zone = time_zone)
  end function dcdate_add_ft

  type(DC_DATETIME) function dcdate_add_tf(time, diff) result(result)
    use dc_types, only: DP
    implicit none
    type(DC_DATETIME), intent(in):: time
    type(DC_DIFFTIME), intent(in):: diff
  continue
    result = dcdate_add_ft(diff, time)
  end function dcdate_add_tf

  type(DC_DIFFTIME) function dcdate_add_ff(diff1, diff2) result(result)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
  continue
    result % mon = diff1 % mon + diff2 % mon
    result % day = diff1 % day + diff2 % day
    result % sec = diff1 % sec + diff2 % sec
    result % day_seconds = diff1 % day_seconds
    call dcdate_normalize(result % day, result % sec, result % day_seconds)
  end function dcdate_add_ff

  type(DC_DATETIME) function dcdate_sub_tf(time, diff) result(result)
    !
    ! 2 Ĥ (DC_DATETIME ) ⤷
    !  (DC_DIFFTIME )θԤޤ.
    !
    implicit none
    type(DC_DATETIME), intent(in):: time
    type(DC_DIFFTIME), intent(in):: diff
    integer:: time_year, time_mon, time_day, time_caltype
    real(DP):: time_sec
    character(6):: time_zone
  continue
    call Eval(time, year = time_year, mon = time_mon, day = time_day, &
      & sec = time_sec, caltype = time_caltype, zone = time_zone)
    call Create(result, year=time_year, mon = time_mon - diff % mon, &
      & day = time_day - diff % day, &
      & sec = time_sec - diff % sec, &
      & caltype = time_caltype, zone = time_zone)
  end function dcdate_sub_tf

  type(DC_DIFFTIME) function dcdate_sub_tt(time1, time2) result(result)
    implicit none
    type(DC_DATETIME), intent(in):: time1, time2
  continue
    result % day = time1 % day - time2 % day
    result % sec = time1 % sec - time2 % sec &
      & + EvalSec(ZoneToDiff(time1 % zone) - ZoneToDiff(time2 % zone))
    result % day_seconds = time1 % day_seconds
    call dcdate_normalize(result % day, result % sec, result % day_seconds)
  end function dcdate_sub_tt

  type(DC_DIFFTIME) function dcdate_sub_ff(diff1, diff2) result(result)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
  continue
    result % mon = diff1 % mon - diff2 % mon
    result % day = diff1 % day - diff2 % day
    result % sec = diff1 % sec - diff2 % sec
    result % day_seconds = diff1 % day_seconds
    call dcdate_normalize(result % day, result % sec, result % day_seconds)
  end function dcdate_sub_ff

  type(DC_DIFFTIME) function dcdate_mul_if(factor, diff) result(result)
    !
    !  *diff*  *facter* Ȥ軻̤֤ޤ.
    !
    implicit none
    integer, intent(in):: factor
    type(DC_DIFFTIME), intent(in):: diff
  continue
    result % mon = factor * diff % mon
    result % day = factor * diff % day
    result % sec = factor * diff % sec
    result % day_seconds = diff % day_seconds
    call dcdate_normalize(result % day, result % sec, result % day_seconds)
  end function dcdate_mul_if

  type(DC_DIFFTIME) function dcdate_mul_fi(diff, factor) result(result)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    integer, intent(in):: factor
  continue
    result = dcdate_mul_if(factor, diff)
  end function dcdate_mul_fi

  type(DC_DIFFTIME) function dcdate_mul_rf(factor, diff) result(result)
    !
    !   : ܤȶṲ̄ˤʤ뤪줬ޤ
    use dc_types, only: DP
    implicit none
    real, intent(in):: factor
    type(DC_DIFFTIME), intent(in):: diff
  continue
    result = dcdate_mul_df(real(factor, DP), diff)
  end function dcdate_mul_rf

  type(DC_DIFFTIME) function dcdate_mul_fr(diff, factor) result(result)
    !
    !   : ܤȶṲ̄ˤʤ뤪줬ޤ
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real, intent(in):: factor
  continue
    result = dcdate_mul_rf(factor, diff)
  end function dcdate_mul_fr

  type(DC_DIFFTIME) function dcdate_mul_df(factor, diff) result(result)
    !
    !   : ܤȶṲ̄ˤʤ뤪줬ޤ
    use dc_types, only: DP
    use dc_date_types, only: CYCLIC_MDAYS
    implicit none
    real(DP), intent(in):: factor
    type(DC_DIFFTIME), intent(in):: diff
    real(DP):: month, day
  continue
    month = factor * diff % mon
    result % mon = int(month)
    day = factor * diff % day + int(CYCLIC_MDAYS * (month - result % mon))
    result % day = int(day)
    result % sec = &
      & factor * diff % sec + (day - result % day) * diff % day_seconds
    result % day_seconds = diff % day_seconds
    call dcdate_normalize(result % day, result % sec, result % day_seconds)
  end function dcdate_mul_df

  type(DC_DIFFTIME) function dcdate_mul_fd(diff, factor) result(result)
    !
    !   : ܤȶṲ̄ˤʤ뤪줬ޤ
    use dc_types, only: DP
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real(DP), intent(in):: factor
  continue
    result = dcdate_mul_df(factor, diff)
  end function dcdate_mul_fd

  type(DC_DIFFTIME) function dcdate_div_fi(diff, denominator) result(result)
    !
    !  *diff*  *denominator* ǽ̤֤ޤ.
    !
    !   : ȶṲ̄ˤʤ뤪줬ޤ
    use dc_date_types, only: CYCLIC_MDAYS
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    integer, intent(in):: denominator
  continue
    result % mon = diff % mon / denominator
    ! ζŪ겼ñ̤ǤԤʤ
    result % day = diff % day / denominator + &
      & int((CYCLIC_MDAYS * mod(diff % mon, denominator)) / &
      &     denominator)
    result % sec = diff % sec / denominator + &
      & (diff % day_seconds * mod(diff % day, denominator)) / &
      & denominator
  end function dcdate_div_fi

  type(DC_DIFFTIME) function dcdate_div_fr(diff, denominator) result(result)
    !
    !   : ȶṲ̄ˤʤ뤪줬ޤ
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real, intent(in):: denominator
  continue
    result = dcdate_div_fd(diff, real(denominator, DP))
  end function dcdate_div_fr

  type(DC_DIFFTIME) function dcdate_div_fd(diff, denominator) result(result)
    !
    !   : ȶṲ̄ˤʤ뤪줬ޤ
    use dc_date_types, only: CYCLIC_MDAYS
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real(DP), intent(in):: denominator
    real(DP):: month, day
  continue
    month = diff % mon / denominator
    result % mon = int(month)
    day = diff % day / denominator + int(CYCLIC_MDAYS * (month - result % mon))
    result % day = int(day)
    result % sec = &
      & diff % sec / denominator + (day - result % day) * diff % day_seconds
    result % day_seconds = diff % day_seconds
    call dcdate_normalize(result % day, result % sec, result % day_seconds)
  end function dcdate_div_fd

  real(DP) function dcdate_div_ff(diff1, diff2) result(result)
    !
    !   : κߤ϶Ṳ̄ˤʤ뤪줬ޤ
    use dc_date_types, only: CYCLIC_MDAYS
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
  continue
    ! бɤɬפ?
    result = &
      & (diff1 % day_seconds * (CYCLIC_MDAYS * diff1 % mon + diff1 % day) &
      & + diff1 % sec) / &
      & (diff2 % day_seconds * (CYCLIC_MDAYS * diff2 % mon + diff2 % day) &
      & + diff2 % sec)
  end function dcdate_div_ff

  type(DC_DIFFTIME) function dcdate_mod_ff(diff1, diff2) result(result)
    !
    !  <b>diff1</b>  <b>diff2</b> ǽݤ;֤ޤ.
    !
    !  : κߤ϶Ṳ̄ˤʤ뤪줬ޤ
    !
    use dc_date_types, only: CYCLIC_MDAYS
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
    real(DP):: sec1, sec2
  continue
    result % day_seconds = diff1 % day_seconds
    if (diff1 % day == 0 .and. diff2 % day == 0 .and. &
      & diff1 % sec == 0.0 .and. diff2 % sec == 0.0) then
      result % mon = mod(diff1 % mon, diff2 % mon)
      result % day = 0
      result % sec = 0.0
    else if (diff1 % sec == 0.0 .and. diff2 % sec == 0.0) then
      result % mon = 0
      result % day = mod((CYCLIC_MDAYS * diff1 % mon + diff1 % day), &
        & (CYCLIC_MDAYS * diff2 % mon + diff2 % day))
      result % sec = 0.0
    else
      sec1 = diff1 % day_seconds * (CYCLIC_MDAYS * diff1 % mon + diff1 % day) &
        & + diff1 % sec
      sec2 = diff2 % day_seconds * (CYCLIC_MDAYS * diff2 % mon + diff2 % day) &
        & + diff2 % sec
      result % sec = mod(sec1, sec2)
      result % day = 0.0
      result % mon = 0.0
      call dcdate_normalize(result % day, result % sec, result % day_seconds)
    endif
  end function dcdate_mod_ff

  logical function dcdate_gt_tt(time1, time2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 1 ܤΰ˳Ǽ 2 ܤΰ˳Ǽ
    ! ʤǤ, .true. ֤ޤ.
    !
    implicit none
    type(DC_DATETIME), intent(in):: time1, time2
    integer:: year1, year2
    real(DP):: time1_sec, time2_sec
  continue
    call Eval(time1, year=year1)
    call Eval(time2, year=year2)
    if (year1 > year2) then
      result = .true.
    elseif (year1 < year2) then
      result = .false.
    else
      time1_sec = EvalSec(time1) + EvalSec(ZoneToDiff(time1 % zone))
      time2_sec = EvalSec(time2) + EvalSec(ZoneToDiff(time2 % zone))
      if (time1_sec > time2_sec) then
        result = .true.
      else
        result = .false.
      end if
    end if
  end function dcdate_gt_tt

  logical function dcdate_gt_ff(diff1, diff2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 1 ܤΰ˳Ǽ 2 ܤΰ˳Ǽ
    ! 礭, .true. ֤ޤ.
    !
    use dc_date_types, only: CYCLIC_MDAYS
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
  continue
    if (EvalSec(diff1) > EvalSec(diff2)) then
      result = .true.
    else
      result = .false.
    end if
  end function dcdate_gt_ff


  logical function dcdate_lt_tt(time1, time2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 2 ܤΰ˳Ǽ 1 ܤΰ˳Ǽ
    ! ʤǤ, .true. ֤ޤ.
    !
    implicit none
    type(DC_DATETIME), intent(in):: time1, time2
  continue
    result = .not. dcdate_gt_tt(time1, time2)
  end function dcdate_lt_tt

  logical function dcdate_lt_ff(diff1, diff2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 2 ܤΰ˳Ǽ 1 ܤΰ˳Ǽ
    ! 礭, .true. ֤ޤ.
    !
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
  continue
    result = .not. dcdate_gt_ff(diff1, diff2)
  end function dcdate_lt_ff


  logical function dcdate_eq_tt(time1, time2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 1 ܤΰ˳Ǽ 2 ܤΰ˳Ǽ
    ! Ʊ, .true. ֤ޤ.
    !
    implicit none
    type(DC_DATETIME), intent(in):: time1, time2
    integer:: year1, year2
    real(DP):: time1_sec, time2_sec
  continue
    call Eval(time1, year=year1)
    call Eval(time2, year=year2)
    time1_sec = EvalSec(time1) + EvalSec(ZoneToDiff(time1 % zone))
    time2_sec = EvalSec(time2) + EvalSec(ZoneToDiff(time2 % zone))
    if (year1 == year2 .and. time1_sec == time2_sec) then
      result = .true.
    else
      result = .false.
    end if
  end function dcdate_eq_tt


  logical function dcdate_eq_ff(diff1, diff2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 1 ܤΰ˳Ǽ 2 ܤΰ˳Ǽ
    ! Ʊ, .true. ֤ޤ.
    !
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
  continue
    if (EvalSec(diff1) == EvalSec(diff2)) then
      result = .true.
    else
      result = .false.
    end if
  end function dcdate_eq_ff

  logical function dcdate_eq_if(i, diff) result(result)
    !
    !  *diff*  *i* ɤӤޤ. *diff*
    ! ÿ˴ͤ *i* Ȥ, .true. ֤ޤ.
    !
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    integer, intent(in):: i
  continue
    result = dcdate_eq_rf(real(i), diff)
  end function dcdate_eq_if

  logical function dcdate_eq_fi(diff, i) result(result)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    integer, intent(in):: i
  continue
    result = dcdate_eq_if(i, diff)
  end function dcdate_eq_fi

  logical function dcdate_eq_rf(r, diff) result(result)
    !
    !  *diff*  *r* ɤӤޤ. *diff*
    ! ÿ˴ͤ *r* Ȥ, .true. ֤ޤ.
    !
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real, intent(in):: r
  continue
    if (real(EvalSec(diff)) == r) then
      result = .true.
    else
      result = .false.
    end if
  end function dcdate_eq_rf

  logical function dcdate_eq_fr(diff, r) result(result)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real, intent(in):: r
  continue
    result = dcdate_eq_rf(r, diff)
  end function dcdate_eq_fr

  logical function dcdate_eq_df(d, diff) result(result)
    !
    !  *diff*  *d* ɤӤޤ. *diff*
    ! ÿ˴ͤ *d* Ȥ, .true. ֤ޤ.
    !
    use dc_types, only: DP
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real(DP), intent(in):: d
  continue
    if (real(EvalSec(diff)) == d) then
      result = .true.
    else
      result = .false.
    end if
  end function dcdate_eq_df

  logical function dcdate_eq_fd(diff, d) result(result)
    use dc_types, only: DP
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real(DP), intent(in):: d
  continue
    result = dcdate_eq_df(d, diff)
  end function dcdate_eq_fd

end module dc_date
