#!/usr/bin/env ruby
#
#== Makefile.win generator
#
#Authors::   Yasuhiro MORIKAWA
#Version::   $Id: gen-Makefile.win.rb,v 1.5 2007/04/17 15:29:20 morikawa Exp $
#Tag Name::  $Name: gt4f90io-20070629 $
#Copyright:: Copyright (C) GFD Dennou Club, 2007-. All rights reserved.
#License::   See COPYRIGHT[link:../../COPYRIGHT]
#
#
#GNU Make  Makefile Ǥ gt4f90io/src/Makefile 
#Windows  nmake  Makefile Ǥ
#gt4f90io/src/Makefile.win 륹ץ.
#ץ -i ˸ Makefile ̾Ϳ, ץ -o
#˽ϥե̾Ϳ.
#
#
require "gnumakefileparser"
require "optparse"

opt = OptionParser.new
OPTS = {}
ARGV.options{|opt|
  opt.on('-i=VAL', '--input=VAL',
         "Original Makefiles (delimiter is \",\")"
         ){|v| OPTS[:input] = v.gsub(/^=/, '')}

  opt.on('-o=VAL', '--output=VAL',
         "Output Makefile for nmake in Windows"
         ){|v| OPTS[:output] = v.gsub(/^=/, '')}

  opt.on('--stdin',
         "Input from standard input"
         ){|v| OPTS[:input] = STDIN}

  opt.on('--stdout',
         "Output to standard output"
         ){|v| OPTS[:output] = STDOUT}

  opt.on_tail('-h', '-H', '--help', 
              "This help message is output"
              ){|v| OPTS[:help] = v}
opt.parse!
}

if OPTS[:help] || !OPTS[:input] || !OPTS[:output]
  print <<-"EOF"

#{File.basename($0.to_s)}:

  USAGE: #{File.basename($0.to_s)} -i Makefile -o Makefile.win
         #{File.basename($0.to_s)} -i Makefile,depend --stdout
         #{File.basename($0.to_s)} --stdin -o Makefile.win

  OPTION: \n#{opt.to_a[1..-1].join("")}
  EOF
  exit
end

win32_gmakeobj = GNUMakefileParser.new('')
win32_gmakeobj.add('FC = ifort /MD')
win32_gmakeobj.add('LIBPROG = lib')
win32_gmakeobj.add('RM = del')
win32_gmakeobj.add('SYSDEPABORT=abort')
win32_gmakeobj.add('SYSDEPARG=common ')
win32_gmakeobj.add('SYSDEPENV=common ')

gmakeobj = GNUMakefileParser.new(OPTS[:input])

gmakeobj.list.collect!{|l|
  if l.class == GNUMakefileParser::MkTarget
    next false if l.target =~ /^(install|doc|clean-doc|.*f90|tags|an|gtdata|work\.pcl|depend|Makefile\.win)$/
    next false if l.target == '$(OBJS)'
    if l.target == '$(TARGET)'
      l.prerequisites = []
      l.prerequisites << '$(OBJS)'
      l.commands = []
      l.commands << '$(LIBPROG) /out:$(TARGET) $(OBJS)'
    end
    if l.target == 'clean'
      l.prerequisites = []
      l.commands = []
      l.commands << '$(RM) *.obj'
      l.commands << '$(RM) *.mod'
      l.commands << '$(RM) *.lib'
    end
    if l.target =~ /\.o$/
      l.target.sub!(/\.o$/, '.obj')
      l.prerequisites.collect!{|p|
        p.sub(/\.o$/, '.obj')
      }
    end
    l.target.gsub!(/^netcdf\_f77\.obj$/, 'netcdf_f77_win.obj')
    l.prerequisites.collect!{|p|
      p.sub(/^netcdf\_f77\.obj$/, 'netcdf_f77_win.obj')
    }
  elsif l.class == GNUMakefileParser::MkVariable
    next false if l.var =~ /^(RB2F90)$/
    if l.var == 'TARGET'
      l.value = 'gt4f90io.lib'
    end
    if l.var =~ /^OBJS/
      l.value.gsub!(/\.o /, '.obj ')
      l.value.gsub!(/\.o$/, '.obj')
      l.value.gsub!(/^netcdf\_f77\.obj /, 'netcdf_f77_win.obj ')
      l.value.gsub!(/ netcdf\_f77\.obj /, ' netcdf_f77_win.obj ')
      l.value.gsub!(/ netcdf\_f77\.obj$/, ' netcdf_f77_win.obj')
    end
  elsif l.class == GNUMakefileParser::MkOther
    if l.line =~ /^(ifeq|ifneq|ifdef|ifndef|else|endif)\s+/
      l.line = '!' + line
    end
    next false
  end
  next l
}

win32_gmakeobj += gmakeobj

win32_gmakeobj.add('.SUFFIX:  .obj .f90')
win32_gmakeobj.add('.f90.obj:
	$(FC) -c $*.f90
')
win32_gmakeobj.add('.f90.mod:
	$(FC) -c $*.f90
')
win32_gmakeobj.add('install:
	copy *.mod c:\uty\gt4f90io\lib\module
	copy *.lib c:\uty\gt4f90io\lib
')


header_msg = <<-EOH
#= Makefile for build of gt4f90io library in Windows
#
# Authors::   Naohito OTOBE (otobe), Yasuhiro MORIKAWA (morikawa)
# Version::   $Id: gen-Makefile.win.rb,v 1.5 2007/04/17 15:29:20 morikawa Exp $
# Tag Name::  $Name: gt4f90io-20070629 $
# Copyright:: Copyright (C) GFD Dennou Club, 2007-. All rights reserved.
# License::   See COPYRIGHT[link:../../COPYRIGHT]
#
#This "#{OPTS[:output].to_s}" was auto-generated by "#{File.basename($0.to_s)}".
#Original files are "#{OPTS[:input].to_s}".
#
######################################################################
EOH

footer_msg = <<-EOF
######################################################################
#== Mode setting for Emacs
EOF
footer_msg << "#" + "Local" + " Variables:\n"
footer_msg << "#" + "mode: makefile\n"
footer_msg << "#" + "End:\n"
footer_msg << <<-EOF
#
EOF

output_str = header_msg + win32_gmakeobj.to_s + footer_msg
if OPTS[:output].class == String
  open(OPTS[:output],'w') { |f| f << output_str }
elsif OPTS[:output] == STDOUT
  STDOUT.print output_str
end

