=begin JA

= ̷ѥ᥿

# *  (odakker)
#   * $Id: dc_types.rd,v 1.4 2007/08/28 10:16:20 morikawa Exp $

=end JA
=begin EN

= Type parameter specification

# * Masatsugu ODAKA (odakker)
#   * $Id: dc_types.rd,v 1.4 2007/08/28 10:16:20 morikawa Exp $

=end EN

=begin JA

¿ѿ٤ʸѿʸꤹݤ, Fortran90 
Ǥϼ̷ѥ᥿Ѥ뤳ȤǤޤ. 
gt4f90io ˤɸŪʼ̷ѥ᥿󶡤⥸塼 
((<dc_types|URL:../code_reference/classes/dc_types.html>)) Ѱ
Ƥޤ. ѤɸŪʼ̷ѥ᥿ʬ
ȤʤѤ뤳ȤǽȤʤޤ. 

Ȥ, ((<"ǡ: (3) °Ĥ"|URL:gthist_attr.htm>)) 
Ѥ((<ץץ|URL:diffusion_2.f90>))ˤ, 
¿ѿ٤̷ѥ᥿Ѥƻꤷץ򼨤ޤ
(ɤ((<|URL:diffusion_3.f90>))). 
ֻ(顼Ǥʤϥܡ) dc_types ˴طƤսǤ.

=end JA
=begin EN

In Fortran 90 programs, the value of the kind type parameter for a
given data type can be specified by the KIND intrinsic
function. 
((<Dc_types|URL:../code_reference/classes/dc_types.html>))
module of gt4f90io provides standard type parameters. 
By using the dc_trace module, it is not necessary to
define type parameters in user's programs.

For example, a sample program using the dc_trace module
(((<diffusion_3.f90|URL:diffusion_3.f90>))) is shown here, which are
modified from ((<diffusion_2.f90|URL:diffusion_2.f90>)) in ((<"Data
I/O interface: (3) Add attribute"|URL:gthist_attr.htm>)).  Statements
with colored font (or bold font) are associated with the
dc_types module.

=end EN

=begin HTML
<pre style="background-color: #FFFFFF; color: blue; border-style: groove; border-width: 2">
!= Sample program for gt4_history/gt4f90io
!
! * 2007/06/25 M.Odaka
! * 2006/10/25 Y.Morikawa
! * 2003/08/21 M.Odaka
! * 2001/02/27 S.Takehiro
!
! Solving diffusion equation
! \[
!     du/dt = \kappa d^2 u/dx^2
! \]
! for giving values of $u$ at $x=[0,1]$.
!
program diffusion_3

  use gt4_history                                   ! ⥸塼
  <b><font color="red">use dc_types, only : DP                           ! ⥸塼</font></b>

  integer, parameter     :: nx=30                   ! åɿ
  integer, parameter     :: nt=200                  ! ֥ƥå׿
  integer, parameter     :: ndisp=10                ! ϴֳ
  real(<b><font color="red">DP</font></b>), parameter    :: dx=1.0/(nx-1)           ! åɴֳ
  real(<b><font color="red">DP</font></b>), parameter    :: dt=0.0005               ! ֳִ
  real(<b><font color="red">DP</font></b>), dimension(nx):: x=(/(dx*(i-1),i=1,nx)/) ! ɸѿ
  real(<b><font color="red">DP</font></b>), dimension(nx):: temp                    ! 
  real(<b><font color="red">DP</font></b>), parameter    :: kappa=1.0               ! ǮȻ

  tinit = 0.0                                       ! 
  
  temp = exp(-((x-0.5)/0.1)**2)                     ! 

  call HistoryCreate( &amp;                             ! ҥȥ꡼
    &amp; file='diffusion_3.nc', title='Diffusion equation', &amp;
    &amp; source='Sample program of gt4_history/gt4f90io',   &amp;
    &amp; institution='GFD_Dennou Club davis project',       &amp;
    &amp; dims=(/'x','t'/), dimsizes=(/nx,0/),               &amp;
    &amp; longnames=(/'X-coordinate','time        '/),       &amp;
    &amp; units=(/'m','s'/),                                 &amp;
    &amp; origin=real(tinit), interval=real(ndisp*dt) )

  call HistoryPut('x',x)                            ! ѿ

  call HistoryAddVariable( &amp;                        ! ѿ
    &amp; varname='temp', dims=(/'x','t'/), &amp;
    &amp; longname='temperature', units='K', xtype='double')

  call HistoryAddAttr('temp','gt_graph_tick_all',1)
  call HistoryAddAttr('temp','gt_graph_contour_spacing',(/0.0,1.0,0.01/))
  call HistoryAddAttr('temp','+gt_user_davis_kappa',kappa)

  call HistoryPut('temp',temp)                      ! ѿ

  do it=1,nt
    temp(2:nx-1) = temp(2:nx-1) &amp;                   ! ʬ
      &amp; + kappa*(temp(3:nx)-2*temp(2:nx-1)+temp(1:nx-2))/dx**2*dt

    if ( mod(it,ndisp) == 0 ) then
      call HistoryPut('temp',temp)                  ! ѿ
    endif
  enddo

  call HistoryClose
  stop
end program diffusion_3
</pre>
=end HTML

=begin JA

Ǥϼ¿ѿ٤, dc_types ⥸塼뤬Ѱդ
ټ¿̷ѥ᥿ ((*DP*)) Ѥƻꤷޤ. 
dc_types ⥸塼ˤϤ¾ʸѿΤ
̷ѥ᥿ѰդƤޤ. ܤ
((<ե󥹥ޥ˥奢|URL:../code_reference/classes/dc_types.html>)) 
򻲾ȤƤ. 

=end JA

=begin EN

In this sample program, the parameter ((*DP*)) provided by dc_trace
module is used as the kind type parameter for double precision real
literal constant. The dc_trace module also provides 
kind type parameters for integer and character literal constants. 
In detail, please see 
((<gt4f90io reference manual|URL:../code_reference/classes/dc_types.html>)). 

=end EN

=begin HTML
<hr /> <small>
  $Id: dc_types.rd,v 1.4 2007/08/28 10:16:20 morikawa Exp $
</small>
=end HTML
