program dc_clock_test
  use dc_types, only: STRING, DP, STDOUT
  use dc_clock, only : CLOCK, Create, Close, Start, Stop, PutLine, Result, &
    & operator(+), Set_Name, Get, EvalSec, toChar, Predict
  use dc_args, only: ARGS, Open, Debug, Help, Strict, Close
  use dc_string, only: Printf
  implicit none
  type(CLOCK) :: clock1, clock2, clock_total
  type(ARGS) :: arg

  integer :: i, j
  real(DP) :: a, b, sec
  integer, parameter :: tmp_file_unit = 20
  integer, parameter :: loop_num = 3
  character(STRING) :: char

continue

  call Open(arg)
  call Debug(arg) ; call Help(arg) ; call Strict(arg)
  call Close(arg)

  call Create(clock1, 'Exp.')
  call Create(clock2, '4-op.')
  open(tmp_file_unit, file='dc_clock_test.tmp', status='replace')
  do i = 1, loop_num
    call Start(clock1)
    a = 2.0d0
    do j = 1, 1000000
      a = (a**2)**0.3 + 1.0d0
    enddo
    call Stop(clock1)
    call Start(clock2)
    b = 1.0d0
    do j = 1, 1000000
      b = b / 3.0d0 * 2.0d0 + 1.0d0 - 1.0d-1
    enddo
    call Stop(clock2)
    call Predict(clock1 + clock2, real(i)/real(loop_num))
  enddo
  call PutLine(clock1)
  call PutLine(clock2, indent=' ')

  call Get(clock1, sec)
  call Printf(STDOUT, 'clock1 sec=%f', d=(/sec/))
  sec = EvalSec(clock2)
  call Printf(STDOUT, 'clock2 sec=%f', d=(/sec/))

  char = toChar(clock1 + clock2)
  call Printf(STDOUT, 'clock1 + clock2 = %c', c1=trim(char))

  write(tmp_file_unit,*) a
  write(tmp_file_unit,*) b
  call Result((/clock1, clock2/), total_name='Total name test 1')
  call Result((/clock1/), total_auto=.true.)
  clock_total = clock1 + clock2
  call Result((/clock1, clock2/), clk_total=clock_total)

  call Close(clock1)
  call Close(clock2)
  close(tmp_file_unit)

end program dc_clock_test
