.TH ZLAEV2 l "15 June 2000" "LAPACK version 3.0" ")"
.SH NAME
ZLAEV2 - compute the eigendecomposition of a 2-by-2 Hermitian matrix [ A B ] [ CONJG(B) C ]
.SH SYNOPSIS
.TP 19
SUBROUTINE ZLAEV2(
A, B, C, RT1, RT2, CS1, SN1 )
.TP 19
.ti +4
DOUBLE
PRECISION CS1, RT1, RT2
.TP 19
.ti +4
COMPLEX*16
A, B, C, SN1
.SH PURPOSE
ZLAEV2 computes the eigendecomposition of a 2-by-2 Hermitian matrix [ A B ] [ CONJG(B) C ]. On return, RT1 is the eigenvalue of larger absolute value, RT2 is the
eigenvalue of smaller absolute value, and (CS1,SN1) is the unit right
eigenvector for RT1, giving the decomposition
.br

[ CS1  CONJG(SN1) ] [    A     B ] [ CS1 -CONJG(SN1) ] = [ RT1  0  ]
[-SN1     CS1     ] [ CONJG(B) C ] [ SN1     CS1     ]   [  0  RT2 ].

.SH ARGUMENTS
.TP 7
A      (input) COMPLEX*16
The (1,1) element of the 2-by-2 matrix.
.TP 7
B      (input) COMPLEX*16
The (1,2) element and the conjugate of the (2,1) element of
the 2-by-2 matrix.
.TP 7
C      (input) COMPLEX*16
The (2,2) element of the 2-by-2 matrix.
.TP 7
RT1    (output) DOUBLE PRECISION
The eigenvalue of larger absolute value.
.TP 7
RT2    (output) DOUBLE PRECISION
The eigenvalue of smaller absolute value.
.TP 7
CS1    (output) DOUBLE PRECISION
SN1    (output) COMPLEX*16
The vector (CS1, SN1) is a unit right eigenvector for RT1.
.SH FURTHER DETAILS
RT1 is accurate to a few ulps barring over/underflow.
.br

RT2 may be inaccurate if there is massive cancellation in the
determinant A*C-B*B; higher precision or correctly rounded or
correctly truncated arithmetic would be needed to compute RT2
accurately in all cases.
.br

CS1 and SN1 are accurate to a few ulps barring over/underflow.

Overflow is possible only if RT1 is within a factor of 5 of overflow.
Underflow is harmless if the input data is 0 or exceeds
.br
   underflow_threshold / macheps.
.br

