!----------------------------------------------------------------------
!     Copyright (c) 2005 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!$BI=Bj(B  at_module $B%5%s%W%k%W%m%0%i%`(B : $B@~7A2r@O(B($B%A%'%S%7%'%U6u4V(B)
!
!      $B3H;6J}Dx<0(B d zeta/dt = kappa d^2 zeta/dx^2
!
!      $B6-3&8GDj>r7o(B  \zeta=0 at x=0,1 => \sigma = -\kappa \pi^2 m^2 (m=1,2,..)
!
!$BMzNr(B  2005/01/27  $BC]9-??0l(B
!
program at_diff_eigen_cheb

  use eigmatrix
  use lumatrix
  use at_module
  use gt4_history
  implicit none

 !---- $B6u4V2rA|EY@_Dj(B ----
  integer, parameter :: im=16                ! $B3J;RE@$N@_Dj(B
  integer, parameter :: km=16                ! $B@ZCGGH?t$N@_Dj(B
  integer, parameter :: nm=10                ! $B=PNO8GM-%b!<%I$N@_Dj(B

 !---- $B:BI8JQ?t$J$I(B ----
  real(8), parameter :: xmin=0.0D0, xmax=1.0D0   ! $BHO0O(B

 !---- $BJQ?t(B ----
  !real(8), dimension(0:im)  :: g_zeta
  real(8), dimension(0:km)  :: t_zeta

  real(8), dimension(0:km)  :: t_dzetadt

 !---- $B@~7A2r@OMQJQ?t!<(B ----
  real(8), dimension(0:km-2,0:km-2)  :: matrix      ! $B78?t9TNs(B

  real(8), dimension(nm)             :: eigen_r     ! $B8GM-CM<BIt(B
  real(8), dimension(nm)             :: eigen_i     ! $B8GM-CM5uIt(B
  real(8), dimension(0:km-2,nm)      :: eigvec_r    ! $B8GM-%Y%/%H%k<BIt(B
  real(8), dimension(0:km-2,nm)      :: eigvec_i    ! $B8GM-%Y%/%H%k5uIt(B

  real(8), dimension(nm)             :: eigen_r_analytic  ! $B8GM-CM<BIt(B($B2r@O2r(B)

 !---- $BJ*M}%Q%i%a%?!<(B ----
  real(8), parameter, dimension(2) :: zetabndry=(/0.0,0.0/)  ! $B6-3&CM(B
  character(len=2), parameter :: tempbc='DD'    ! $B6-3&>r7o(B(DD/DN/ND/NN)
  real(8), parameter :: kappa=1.0               ! $B3H;678?t(B
  real(8) :: pi

  integer info, k, n

  pi = 4*atan(1.0d0)

 !---------------- $B:BI8CM$N@_Dj(B ---------------------
  call at_initial(im,km,xmin,xmax)

 !---------------- $B78?t9TNs7W;;(B ---------------------
  do k=0,km-2
     t_zeta    = 0.0
     t_zeta(k) = 1.0
     call boundaries
     t_dzetadt = kappa * t_dx_t(t_dx_t(t_zeta) )

     matrix(:,k) = t_dzetadt(0:km-2)
  enddo

 !------------------ $B8GM-CM7W;;(B ---------------------
  call eigen(matrix,eigen_r,eigen_i,eigvec_r,eigvec_i,info,&
       sort='R', reverse=.true.)

  eigen_r_analytic =(/(-kappa * pi**2 * n**2,n=1,nm)/)

 !------------------- $B=PNO(B ----------------------
  call output_gtool4_init                            ! $B%R%9%H%j!<=i4|2=(B
  call output_gtool4
  call output_gtool4_close                           ! $B%R%9%H%j!<8e=hM}(B

  stop

  contains

    subroutine boundaries
      if ( tempbc == 'DD' ) then
         call at_boundaries_DD(t_zeta,zetabndry)
      elseif ( tempbc == 'DN' ) then
         call at_boundaries_DN(t_zeta,zetabndry)
      elseif ( tempbc == 'ND' ) then
         call at_boundaries_ND(t_zeta,zetabndry)
      elseif ( tempbc == 'NN' ) then
         call at_boundaries_NN(t_zeta,zetabndry)
      else
         write(6,*) 'B.C. not supported'
      endif
    end subroutine boundaries

    subroutine output_gtool4_init
      call HistoryCreate( &                               ! $B%R%9%H%j!<:n@.(B
           file='at_diff_eigen_cheb.nc', title='Linear analysis fo diffusion equation (Chebyshev base)', &
           source='Sample program of gtool_history/gtool4', &
           institution='GFD_Dennou Club davis/spmodel project',&
           dims=(/'x   ','mode'/), dimsizes=(/im+1,0/), &
           longnames=(/'X-coordinate','mode number '/),    &
           units=(/'1','1'/),                              &
           origin=1.0, interval=1.0 ) 

      call HistoryPut('x',g_x)                            ! $BJQ?t=PNO(B

      call HistoryAddVariable( &                          ! $BJQ?tDj5A(B
           varname='eigen_r', dims=(/'mode'/), & 
           longname='Eigen value (R)', units='1', xtype='double')
      call HistoryAddVariable( &                          ! $BJQ?tDj5A(B
           varname='eigen_i', dims=(/'mode'/), & 
           longname='Eigen value (I)', units='1', xtype='double')
      call HistoryAddVariable( &                          ! $BJQ?tDj5A(B
           varname='eigen_r_analytic', dims=(/'mode'/), & 
           longname='Analytic Eigen value (R)', units='1', xtype='double')

      call HistoryAddVariable( &                          ! $BJQ?tDj5A(B
           varname='eigvec_r', dims=(/'x   ','mode'/), & 
           longname='Eigen vector (R)', units='1', xtype='double')
      call HistoryAddVariable( &                          ! $BJQ?tDj5A(B
           varname='eigvec_i', dims=(/'x   ','mode'/), & 
           longname='Eigen vector (I)', units='1', xtype='double')

    end subroutine output_gtool4_init

    subroutine output_gtool4
      do n=1,nm
         call HistoryPut('mode',real(n))
         call HistoryPut('eigen_r',eigen_r(n))
         call HistoryPut('eigen_i',eigen_i(n))
         call HistoryPut('eigen_r_analytic',eigen_r_analytic(n))

         t_zeta = 0.0 ; t_zeta(0:km-2) = eigvec_r(:,n)
         call boundaries
         call HistoryPut('eigvec_r',g_t(t_zeta))

         t_zeta = 0.0 ; t_zeta(0:km-2) = eigvec_i(:,n)
         call boundaries
         call HistoryPut('eigvec_i',g_t(t_zeta))
      enddo
    end subroutine output_gtool4
 
    subroutine output_gtool4_close
      call HistoryClose
    end subroutine output_gtool4_close

end program at_diff_eigen_cheb

