!----------------------------------------------------------------------
!     Copyright (c) 2002-2006 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  at_module
!
!      spml/at_module ⥸塼 1 ͭΰβǤήαư
!      ӥѴˤꥹڥȥͷ׻뤿 Fortran90 ؿ
!      󶡤. 
!
!      2 ǡ 1 ˴ؤƱ˥ڥȥ׻¹Ԥ뤿
!      ؿ󶡤Ƥ, 2, 3 ΰǤη׻Υ١󶡤. 
!
!      Υ⥸塼 ISPACK/FTPACK  Fortran77 ֥롼
!      ƤǤ. ڥȥǡӳʻǡγǼˡˤĤƤ
!      ISPACK/FTPACK Υޥ˥奢򻲾Ȥ줿.
!
!
!  2002/01/24  ݹ
!      2002/02/06  ݹ  ŤƳ. ̥󥿡եʤ. 
!                            η˱󥿡ե̾
!      2002/03/25  ݹ  ⥸塼̾ѹ
!      2002/08/20  ݹ  ʬʿѴؿɲ
!      2002/11/10  ݹ  ¶֤Ǥζ롼ɲ
!      2005/01/09  ݹ  msgdmp -> MessageNotify ѹ
!      2006/03/06  ݹ  Ȥ RDoc Ѥ˽
!      2006/03/19  ݹ  ѿ³򥳥Ȥɲ
!
module at_module
  !
  != at_module
  !
  !== 
  !
  !      spml/at_module ⥸塼 1 ͭΰβǤήαư
  !      ӥѴˤꥹڥȥͷ׻뤿 Fortran90 ؿ
  !      󶡤. 
  !
  !      2 ǡ 1 ˴ؤƱ˥ڥȥ׻¹Ԥ뤿
  !      ؿ󶡤Ƥ, 2, 3 ΰǤη׻Υ١󶡤. 
  !
  !      Υ⥸塼 ISPACK/FTPACK  Fortran77 ֥롼
  !      ƤǤ. ڥȥǡӳʻǡγǼˡˤĤƤ
  !      ISPACK/FTPACK Υޥ˥奢򻲾Ȥ줿.
  !
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !
  !   * ؿ̾Ƭ (e_, g_, at_, ag_) , ֤ͤη򼨤Ƥ.
  !      e_  : ӥեǡ
  !      g_  : 1 ʻǡ
  !      at_ : 1 ӥեǡʣ¤ 2 ǡ
  !      ag_ : 1 ʻǡʣ¤ 2 ǡ.
  !
  !   * ؿ̾δ֤ʸ(Dx), δؿκѤɽƤ.
  !
  !   * ؿ̾κǸ (_e,_at,_g, _ag) , ѿηӥեǡ
  !     ӳʻǡǤ뤳Ȥ򼨤Ƥ.
  !      _e  : ӥեǡ
  !      _g  : 1 ʻǡ
  !      _at : 1 ӥեǡʣ¤ 2 ǡ
  !      _ag : 1 ʻǡʣ¤ 2 ǡ
  !
  !=== ƥǡμ
  !
  !   * g : 1 ʻǡ.
  !      ѿμȼ real(8), dimension(0:im). 
  !      im  X ɸγʻǤ, ֥롼 at_Initial ˤ
  !      餫ꤷƤ.
  !
  !   * e : ӥեǡ.
  !      ѿμȼ real(8), dimension(0:km). 
  !      km  X κȿǤ, ֥롼 at_Initial ˤ
  !      餫ꤷƤ. ڥȥǡγǼΤˤĤƤ...
  !
  !   * ag : 1 (X)ʻǡ¤ 2 ǡ.
  !      ѿμȼ real(8), dimension(:,0:im). 
  !       2  X ɽ.
  !
  !   * at : 1 ӥեǡ¤ 2 ǡ.
  !      ѿμȼ real(8), dimension(:,0:km). 
  !       2 ڥȥɽ.
  !
  !   * g_ ǻϤޤؿ֤ͤ 1 ʻǡƱ.
  !
  !   * t_ ǻϤޤؿ֤ͤϥӥեǡƱ.
  !
  !   * ag_ ǻϤޤؿ֤ͤ 1 ʻǡ¤ 
  !     2 ǡƱ.
  !
  !   * at_ ǻϤޤؿ֤ͤ 1 ӥեǡ¤
  !     2 ǡƱ.
  !
  !   * ӥեǡФʬκѤȤ, бʻǡ
  !     ʬʤɤѤǡӥѴΤΤȤǤ.
  !
  !
  !== ѿ³
  !
  !====  
  !
  ! at_Initial  :: ӥѴγʻ, ȿ, ΰ礭
  ! 
  !==== ɸѿ
  !
  ! g_X        :: ʻɸ(X)Ǽ 1 
  ! g_X_Weight :: ŤߺɸǼ 1 
  !
  !==== Ѵ
  !
  ! g_t, ag_at :: ӥեǡʻҥǡؤѴ
  ! t_g, at_ag :: ʻҥǡӥեǡؤѴ
  !
  !==== ʬ
  !
  ! t_Dx_t, at_Dx_at :: ӥեǡ X ʬѤ
  !
  !==== 
  !
  ! at_Boundaries_DD, at_Boundaries_DN, :: ǥꥯ, Υޥ󶭳Ŭ
  ! at_Boundaries_ND, at_Boundaries_NN  :: 
  !
  ! at_BoundariesTau_DD, at_BoundariesTau_DN, :: ǥꥯ, Υޥ󶭳
  ! at_BoundariesTau_ND, at_BoundariesTau_NN  :: Ŭ(ˡ)
  !
  ! at_BoundariesGrid_DD, at_BoundariesGrid_DN, :: ǥꥯ, Υޥ󶭳
  ! at_BoundariesGrid_ND, at_BoundariesGrid_NN  :: Ŭ(ˡ)
  !
  !==== ʬʿ
  !
  ! a_Int_ag, a_Avr_ag :: 1 ʻǡ¤ 2 ʬʿ
  ! Int_g, Avr_g       :: 1 ʻǡʬʿ
  !
  use dc_message
  use lumatrix
  implicit none
  private
  public g_X, g_X_Weight                      ! ɸѿ
  public at_Initial                           ! 
  public ag_at, at_ag, g_t, t_g               ! Ѵ
  public at_Dx_at, t_Dx_t                     ! ʬ
  public at_Boundaries_DD, at_Boundaries_DN   ! 
  public at_Boundaries_ND, at_Boundaries_NN   ! 
  public at_BoundariesTau_DD, at_BoundariesTau_DN     ! 
  public at_BoundariesTau_ND, at_BoundariesTau_NN     ! 
  public at_BoundariesGrid_DD, at_BoundariesGrid_DN   ! 
  public at_BoundariesGrid_ND, at_BoundariesGrid_NN   ! 
  public a_Int_ag, Int_g, a_Avr_ag, Avr_g             ! ʬʿ

  interface at_Boundaries_DD            
     !
     ! ξüǥꥯ췿Ŭ(ˡ). 
     ! ξǤͤͿ.
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(:,0:km),intent(inout)       :: at_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(at_data,1),2), intent(in), optional :: values
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: t_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(2), intent(in), optional  :: values
     !    !(in) ŬѤ붭
     !
     module procedure at_BoundariesTau_DD_1d, at_BoundariesTau_DD_2d
  end interface

  interface at_Boundaries_DN
     !
     ! ǥꥯ졦Υޥ󷿶Ŭ(ˡ).
     ! i=0 , i=im ǸۤͤͿ.
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(:,0:km),intent(inout)       :: at_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(at_data,1),2), intent(in), optional :: values
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: t_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(2), intent(in), optional  :: values
     !    !(in) ŬѤ붭
     !
     module procedure at_BoundariesTau_DN_1d, at_BoundariesTau_DN_2d
  end interface

  interface at_Boundaries_ND
     !
     ! Υޥ󡦥ǥꥯ췿Ŭ(ˡ).
     ! i=0 Ǹۤ, i=im ͤͿ.
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(:,0:km),intent(inout)       :: at_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(at_data,1),2), intent(in), optional :: values
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: t_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(2), intent(in), optional  :: values
     !    !(in) ŬѤ붭
     !
     module procedure at_BoundariesTau_ND_1d, at_BoundariesTau_ND_2d
  end interface

  interface at_Boundaries_NN         
     !
     ! ξüΥޥŬ(ˡ). 
     ! ξǸۤͤͿ.
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(:,0:km),intent(inout)       :: at_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(at_data,1),2), intent(in), optional :: values
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: t_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(2), intent(in), optional  :: values
     !    !(in) ŬѤ붭
     !
     module procedure at_BoundariesTau_NN_1d, at_BoundariesTau_NN_2d
  end interface

  interface at_BoundariesTau_DD
     !
     ! ξüǥꥯ췿Ŭ(ˡ). 
     ! ξǤͤͿ.
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(:,0:km),intent(inout)       :: at_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(at_data,1),2), intent(in), optional :: values
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: t_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(2), intent(in), optional  :: values
     !    !(in) ŬѤ붭
     !
     module procedure at_BoundariesTau_DD_1d, at_BoundariesTau_DD_2d
  end interface

  interface at_BoundariesTau_DN
     !
     ! ǥꥯ졦Υޥ󷿶Ŭ(ˡ).
     ! i=0 , i=im ǸۤͤͿ.
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(:,0:km),intent(inout)       :: at_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(at_data,1),2), intent(in), optional :: values
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: t_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(2), intent(in), optional  :: values
     !    !(in) ŬѤ붭
     !
     module procedure at_BoundariesTau_DN_1d, at_BoundariesTau_DN_2d
  end interface

  interface at_BoundariesTau_ND
     !
     ! Υޥ󡦥ǥꥯ췿Ŭ(ˡ).
     ! i=0 Ǹۤ, i=im ͤͿ.
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(:,0:km),intent(inout)       :: at_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(at_data,1),2), intent(in), optional :: values
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: t_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(2), intent(in), optional  :: values
     !    !(in) ŬѤ붭
     !
     module procedure at_BoundariesTau_ND_1d, at_BoundariesTau_ND_2d
  end interface

  interface at_BoundariesTau_NN            ! ξüΥޥ(ˡ)
     !
     ! ξüΥޥŬ(ˡ). 
     ! ξǸۤͤͿ.
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(:,0:km),intent(inout)       :: at_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(at_data,1),2), intent(in), optional :: values
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: t_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(2), intent(in), optional  :: values
     !    !(in) ŬѤ붭
     !
     module procedure at_BoundariesTau_NN_1d, at_BoundariesTau_NN_2d
  end interface

  interface at_BoundariesGrid_DD
     !
     ! ξüǥꥯ췿Ŭ(¶֤Ǥɾ).
     ! ξǤͤͿ.
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(:,0:km),intent(inout)       :: at_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(at_data,1),2), intent(in), optional :: values
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: t_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(2), intent(in), optional  :: values
     !    !(in) ŬѤ붭
     !
     module procedure at_BoundariesGrid_DD_1d, at_BoundariesGrid_DD_2d
  end interface

  interface at_BoundariesGrid_DN
     !
     ! ǥꥯ졦Υޥ󷿶Ŭ(¶֤Ǥɾ).
     ! i=0 , i=im ǸۤͤͿ.
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(:,0:km),intent(inout)       :: at_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(at_data,1),2), intent(in), optional :: values
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: t_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(2), intent(in), optional  :: values
     !    !(in) ŬѤ붭
     !
     module procedure at_BoundariesGrid_DN_1d, at_BoundariesGrid_DN_2d
  end interface

  interface at_BoundariesGrid_ND
     !
     ! Υޥ󡦥ǥꥯ췿Ŭ(¶֤Ǥɾ)
     ! i=0 Ǹۤ, i=im ͤͿ.
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(:,0:km),intent(inout)       :: at_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(at_data,1),2), intent(in), optional :: values
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: t_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(2), intent(in), optional  :: values
     !    !(in) ŬѤ붭
     !
     module procedure at_BoundariesGrid_ND_1d, at_BoundariesGrid_ND_2d
  end interface

  interface at_BoundariesGrid_NN
     !
     ! ξüΥޥŬ(¶֤Ǥɾ).
     ! ξǸۤͤͿ.
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(:,0:km),intent(inout)       :: at_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(at_data,1),2), intent(in), optional :: values
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: t_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(2), intent(in), optional  :: values
     !    !(in) ŬѤ붭
     !
     module procedure at_BoundariesGrid_NN_1d, at_BoundariesGrid_NN_2d
  end interface


  integer, dimension(5)              :: it
  real(8), dimension(:), allocatable :: t
  real(8), parameter                 :: pi=3.1415926535897932385D0

  integer :: im, km                        ! ʻ, ȿ
  real(8) :: xl                            ! ΰ礭

  real(8), allocatable :: g_X(:)           
  ! ʻɸ
  ! km Υӥ¿༰ޤʻ

  real(8), allocatable :: g_X_Weight(:)
  ! ʻŤߺɸ
  ! ƳʻˤʬΤνŤߤǼƤ

  save :: im, km, xl, it, t, g_X, g_X_Weight

contains

! ----  ---- 
  subroutine at_Initial(i,k,xmin,xmax)
    !
    ! ӥѴγʻ, ȿ, ΰ礭ꤹ.
    !
    ! ¾δؿѿƤ, ǽˤΥ֥롼Ƥ
    ! 򤷤ʤФʤʤ.
    !
    integer,intent(in) :: i              !(in) ʻ
    integer,intent(in) :: k              !(in) ȿ
    real(8),intent(in) :: xmin, xmax     !(in) ɸϰ

    integer :: ii,kk

    im=i ; km=k 
    xl = xmax-xmin

    if ( im <= 0 .or. km <= 0 ) then
       call MessageNotify('E','at_initial', &
            'Number of grid points and waves should be positive')
    elseif ( mod(im,2) /= 0 ) then
       call MessageNotify('E','at_initial','Number of grid points should be even')
    elseif ( km > im ) then
       call MessageNotify('E','at_initial','KM shoud be less equal IM')
    endif

    allocate(t(3*im))
    call fttcti(im,it,t)

    allocate(g_X(0:im))
    do ii=0,im
       g_X(ii) = (xmax+xmin)/2 + xl/2 * cos(pi*ii/im)
    enddo

    allocate(g_X_Weight(0:im))
    do ii=0,im
       g_X_Weight(ii) = 1.0
       do kk=2,km,2
          g_X_Weight(ii) = g_X_Weight(ii) &
                          + 2/(1D0-kk**2) * cos(kk*ii*pi/im)
       enddo
       if ( (km == im) .and. (mod(im,2)==0) ) then  ! Ǹ¤ factor 1/2.
          g_X_Weight(ii) = g_X_Weight(ii) &
                          - 1/(1D0-km**2)* cos(km*ii*pi/im)
       endif
       g_X_Weight(ii) = 2D0/im * g_X_Weight(ii) * xl/2
    enddo
    g_X_Weight(0)  = g_X_Weight(0) / 2
    g_X_Weight(im) = g_X_Weight(im) / 2

  end subroutine at_Initial

! ---- Ѵ ---- 
  function ag_at(at_data)
    !
    ! ӥեǡʻҥǡѴ(2 ).
    !
    double precision, dimension(:,:), intent(in)      :: at_data
    !(in) ӥեǡ

    double precision, dimension(size(at_data,1),0:im)  :: ag_at
    !(out) ʻǡ

    real(8), dimension(size(at_data,1)*im) :: y
    ! 
    integer :: m

    m = size(at_data,1)
    if ( size(at_data,2)-1 < km ) then
       call MessageNotify('E','ag_at', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(at_data,2)-1 > km ) then
       call MessageNotify('W','ag_at', &
            'The Chebyshev dimension of input data too large.')
    endif

    ag_at = 0.0D0
    ag_at(:,0:km)=at_data
    call fttctb(m,im,ag_at,y,it,t)

  end function ag_at

  function g_t(t_data)
    !
    ! ӥեǡʻҥǡѴ(1 ).
    !
    double precision, dimension(:), intent(in)  :: t_data
    !(in) ӥեǡ

    double precision, dimension(0:im)           :: g_t
    !(out) ʻǡ

    double precision, dimension(1,size(t_data)) :: t_work
    ! 
    double precision, dimension(1,0:im)         :: g_work
    ! 

    t_work(1,:) = t_data  
    g_work = ag_at(t_work)
    g_t = g_work(1,:)

  end function g_t


! ---- Ѵ ---- 
  function at_ag(ag_data)
    !
    ! ʻҥǡӥեǡѴ(2 ).
    !
    double precision, dimension(:,:), intent(in)      :: ag_data
    !(in) ʻǡ

    double precision, dimension(size(ag_data,1),0:km) :: at_ag
    !(out) ӥեǡ

    real(8), dimension(size(ag_data,1)*im)   :: y
    real(8), dimension(size(ag_data,1),0:im) :: ag_work
    integer :: m

    m = size(ag_data,1)
    if ( size(ag_data,2)-1 < im ) then
       call MessageNotify('E','at_ag', &
            'The Grid points of input data too small.')
    elseif ( size(ag_data,2)-1 > im ) then
       call MessageNotify('W','at_ag', &
            'The Grid points of input data too large.')
    endif
    ag_work = ag_data

    call fttctf(m,im,ag_work,y,it,t)
    at_ag = ag_work(:,0:km)

  end function at_ag

  function t_g(g_data)  ! ʻ -> ڥȥ
    !
    ! ʻҥǡӥեǡѴ(2 ).
    !
    double precision, dimension(:), intent(in)     :: g_data
    !(in) ʻǡ

    double precision, dimension(0:km)              :: t_g
    !(out) ӥեǡ

    real(8), dimension(1,size(g_data)) :: ag_work
    real(8), dimension(1,0:km)         :: at_work

    ag_work(1,:) = g_data
    at_work = at_ag(ag_work)
    t_g = at_work(1,:)
    
  end function t_g

! ---- ʬ׻ ---- 
  function at_Dx_at(at_data)
    !
    ! ϥӥեǡ X ʬѤ(2 ).
    !
    ! ӥեǡ X ʬȤ, бʻǡ X ʬ
    ! ѤǡΥӥѴΤȤǤ.
    !
    !
    real(8), dimension(:,0:), intent(in)                    :: at_data
    !(in) ϥӥեǡ

    real(8), dimension(size(at_data,1),0:size(at_data,2)-1) :: at_Dx_at
    !(out) ӥեǡ X ʬ

    integer :: m, k
    integer :: nm, kmax

    nm=size(at_data,1)
    kmax=size(at_data,2)-1
    if ( kmax  < km ) then
       call MessageNotify('W','at_Dx_at', &
            'The Chebyshev dimension of input data too small.')
    elseif ( kmax > km ) then
       call MessageNotify('E','at_Dx_at', &
            'The Chebyshev dimension of input data too large.')
    endif

    if ( kmax == im ) then
       do m=1,nm
          at_Dx_at(m,kmax)   = 0. 
          at_Dx_at(m,kmax-1) = 2 * km * at_data(m,kmax) /2
       enddo
    else
       do m=1,nm
          at_Dx_at(m,kmax)   = 0. 
          at_Dx_at(m,kmax-1) = 2 * km * at_data(m,kmax) 
          ! Ȥϥåбȿ̤. Factor 1/2 
       enddo
    endif

    do k=kmax-2,0,-1
       do m=1,nm
          at_Dx_at(m,k) = at_Dx_at(m,k+2) + 2*(k+1)*at_data(m,k+1)
       enddo
    enddo

    do k=0,kmax
       do m=1,nm
          at_Dx_at(m,k) = 2/xl * at_Dx_at(m,k)
       enddo
    enddo

  end function at_Dx_at

  function t_Dx_t(t_data)
    !
    ! ϥӥեǡ X ʬѤ(1 ).
    !
    ! ӥեǡ X ʬȤ, бʻǡ X ʬ
    ! ѤǡΥӥѴΤȤǤ.
    !
    !
    real(8), dimension(:), intent(in)   :: t_data
    !(in) ϥӥեǡ

    real(8), dimension(size(t_data))    :: t_Dx_t
    !(out) ӥեǡ X ʬ

    real(8), dimension(1,size(t_data))  :: at_work
    ! 
    
    at_work(1,:) = t_data
    at_work = at_Dx_at(at_work)
    t_Dx_t = at_work(1,:)

  end function t_Dx_t

!---- Dirichlet (ˡ) ----

  subroutine at_BoundariesTau_DD_2d(at_data,values)
    !
    ! Dirichlet Ŭ(ˡ, 2 )
    ! ξǤͤͿ.
    !
    real(8), dimension(:,0:),intent(inout)         :: at_data ! ǡ(m,0:km)
    !(inout) ŬѤӥեǡ(m,0:km)

    real(8), dimension(:,:), intent(in), optional  :: values
    !(in) (m,2)

    real(8), dimension(:,:), allocatable  :: alu
    integer, dimension(:), allocatable    :: kp
    real(8), dimension(0:km,0:km)         :: tt_data
    real(8), dimension(0:km,0:im)         :: tg_data
    real(8), dimension(size(at_data,1))    :: value1, value2           ! 

    logical :: first = .true.
    integer :: k
    save    :: alu, kp, first

    if ( size(at_data,2)-1 < km ) then
       call MessageNotify('E','at_BoundariesTau_DD', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(at_data,2)-1 > km ) then
       call MessageNotify('W','at_BoundariesTau_DD', &
            'The Chebyshev dimension of input data too large.')
    endif

    if (.not. present(values)) then
       value1=0 ; value2=0
    else
       value1 = values(:,1) ; value2 = values(:,2)
    endif

    if ( first ) then
       first = .false.

       allocate(alu(0:km,0:km),kp(0:km))

       tt_data=0
       do k=0,km
          tt_data(k,k)=1
       enddo
       alu = tt_data

       tg_data = ag_at(tt_data)
       alu(km-1,:) = tg_data(:,0)
       alu(km,:)   = tg_data(:,im)

       call ludecomp(alu,kp)
    endif

    at_data(:,km-1) = value1
    at_data(:,km)   = value2
    at_data = lusolve(alu,kp,at_data)

  end subroutine at_BoundariesTau_DD_2d

  subroutine at_BoundariesTau_DD_1d(t_data,values)
    !
    ! Dirichlet Ŭ(ˡ, 1 )
    ! ξǤͤͿ.
    !
    real(8), dimension(0:km),intent(inout)       :: t_data
    !(inout) ŬѤӥեǡ(0:km)

    real(8), dimension(2), intent(in), optional  :: values
    !(in) 

    real(8), dimension(1,0:km)                   :: at_work
    real(8), dimension(1,2)                      :: vwork           ! 

    if (.not. present(values)) then
       vwork(1,1)=0 ; vwork(1,2)=0
    else
       vwork(1,:) = values
    endif

    at_work(1,:)=t_data
    call at_BoundariesTau_DD_2d(at_work,vwork)
    t_data=at_work(1,:)

  end subroutine at_BoundariesTau_DD_1d


!---- Dirichlet/Neumann (ˡ) ----

  subroutine at_BoundariesTau_DN_2d(at_data,values)
    !
    ! Dirichlet/Neumann Ŭ(ˡ, 2 )
    ! i=0 , i=im ǸۤͤͿ.
    !
    real(8), dimension(:,0:),intent(inout)         :: at_data
    !(inout) ŬѤӥեǡ(m,0:km)

    real(8), dimension(:,:), intent(in), optional  :: values
    !(in) (m,2)

    real(8), dimension(:,:), allocatable  :: alu
    integer, dimension(:), allocatable    :: kp
    real(8), dimension(0:km,0:km)         :: tt_data
    real(8), dimension(0:km,0:im)         :: tg_data
    real(8), dimension(size(at_data,1))    :: value1, value2           ! 

    logical :: first = .true.
    integer :: k
    save    :: alu, kp, first

    if ( size(at_data,2)-1 < km ) then
       call MessageNotify('E','at_BoundariesTau_DN', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(at_data,2)-1 > km ) then
       call MessageNotify('W','at_BoundariesTau_DN', &
            'The Chebyshev dimension of input data too large.')
    endif

    if (.not. present(values)) then
       value1=0 ; value2=0
    else
       value1 = values(:,1) ; value2 = values(:,2)
    endif

    if ( first ) then
       first = .false.

       allocate(alu(0:km,0:km),kp(0:km))

       tt_data = 0
       do k=0,km
          tt_data(k,k)=1
       enddo
       alu = tt_data

       tg_data = ag_at(tt_data)
       alu(km-1,:) = tg_data(:,0)
       tg_data = ag_at(at_Dx_at(tt_data))
       alu(km,:)   = tg_data(:,im)

       call ludecomp(alu,kp)
    endif

    at_data(:,km-1) = value1
    at_data(:,km)   = value2
    at_data = lusolve(alu,kp,at_data)

  end subroutine at_BoundariesTau_DN_2d

  subroutine at_BoundariesTau_DN_1d(t_data,values)
    !
    ! Dirichlet/Neumann Ŭ(ˡ, 1 )
    ! i=0 , i=im ǸۤͤͿ.
    !
    real(8), dimension(0:km),intent(inout)       :: t_data
    !(inout) ŬѤӥեǡ(0:km)

    real(8), dimension(2), intent(in), optional  :: values 
    !(in) 

    real(8), dimension(1,0:km)                   :: at_work
    real(8), dimension(1,2)                      :: vwork           ! 

    if (.not. present(values)) then
       vwork(1,1)=0 ; vwork(1,2)=0
    else
       vwork(1,:) = values
    endif

    at_work(1,:)=t_data
    call at_BoundariesTau_DN_2d(at_work,vwork)
    t_data=at_work(1,:)

  end subroutine at_BoundariesTau_DN_1d

!---- Neumann/Dirichlet (ˡ) ----

  subroutine at_BoundariesTau_ND_2d(at_data,values)
    !
    ! Neumann/Dirichlet Ŭ(ˡ, 2 )
    ! i=0 Ǹۤ, i=im ͤͿ.
    !
    real(8), dimension(:,0:),intent(inout)         :: at_data
    !(inout) ŬѤӥեǡ(m,0:km)

    real(8), dimension(:,:), intent(in), optional  :: values
    !(in) (m,2)

    real(8), dimension(:,:), allocatable  :: alu
    integer, dimension(:), allocatable    :: kp
    real(8), dimension(0:km,0:km)         :: tt_data
    real(8), dimension(0:km,0:im)         :: tg_data
    real(8), dimension(size(at_data,1))    :: value1, value2           ! 

    logical :: first = .true.
    integer :: k
    save    :: alu, kp, first

    if ( size(at_data,2)-1 < km ) then
       call MessageNotify('E','at_BoundariesTau_ND', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(at_data,2)-1 > km ) then
       call MessageNotify('W','at_BoundariesTau_ND', &
            'The Chebyshev dimension of input data too large.')
    endif

    if (.not. present(values)) then
       value1=0 ; value2=0
    else
       value1 = values(:,1) ; value2 = values(:,2)
    endif

    if ( first ) then
       first = .false.

       allocate(alu(0:km,0:km),kp(0:km))

       tt_data = 0
       do k=0,km
          tt_data(k,k)=1
       enddo
       alu = tt_data

       tg_data = ag_at(at_Dx_at(tt_data))
       alu(km-1,:) = tg_data(:,0)
       tg_data = ag_at(tt_data)
       alu(km,:)   = tg_data(:,im)

       call ludecomp(alu,kp)
    endif

    at_data(:,km-1) = value1
    at_data(:,km)   = value2
    at_data = lusolve(alu,kp,at_data)

  end subroutine at_BoundariesTau_ND_2d

  subroutine at_BoundariesTau_ND_1d(t_data,values)
    !
    ! Neumann/Dirichlet Ŭ(ˡ, 1 )
    ! i=0 Ǹۤ, i=im ͤͿ.
    !
    real(8), dimension(0:km),intent(inout)       :: t_data
    !(inout) ŬѤӥեǡ(0:km)

    real(8), dimension(2), intent(in), optional  :: values
    !(in) 

    real(8), dimension(1,0:km)                   :: at_work
    real(8), dimension(1,2)                      :: vwork           ! 

    if (.not. present(values)) then
       vwork(1,1)=0 ; vwork(1,2)=0
    else
       vwork(1,:) = values
    endif

    at_work(1,:)=t_data
    call at_BoundariesTau_ND_2d(at_work,vwork)
    t_data=at_work(1,:)

  end subroutine at_BoundariesTau_ND_1d


!---- Neumann (ˡ) ----

  subroutine at_BoundariesTau_NN_2d(at_data,values)
    !
    ! Neumann/Dirichlet Ŭ(ˡ, 2 )
    ! ξǸۤͤͿ.
    !
    real(8), dimension(:,0:),intent(inout)         :: at_data
    !(inout) ŬѤӥեǡ(m,0:km)

    real(8), dimension(:,:), intent(in), optional  :: values
    !(in) (m,2)

    real(8), dimension(:,:), allocatable  :: alu
    integer, dimension(:), allocatable    :: kp
    real(8), dimension(0:km,0:km)         :: tt_data
    real(8), dimension(0:km,0:im)         :: tg_data
    real(8), dimension(size(at_data,1))    :: value1, value2           ! 

    logical :: first = .true.
    integer :: k
    save    :: alu, kp, first

    if ( size(at_data,2)-1 < km ) then
       call MessageNotify('E','at_BoundariesTau_NN', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(at_data,2)-1 > km ) then
       call MessageNotify('W','at_BoundariesTau_NN', &
            'The Chebyshev dimension of input data too large.')
    endif

    if (.not. present(values)) then
       value1=0 ; value2=0
    else
       value1 = values(:,1) ; value2 = values(:,2)
    endif

    if ( first ) then
       first = .false.

       allocate(alu(0:km,0:km),kp(0:km))

       tt_data = 0
       do k=0,km
          tt_data(k,k)=1
       enddo
       alu = tt_data

       tg_data = ag_at(at_Dx_at(tt_data))
       alu(km-1,:) = tg_data(:,0)
       alu(km,:)   = tg_data(:,im)

       call ludecomp(alu,kp)
    endif

    at_data(:,km-1) = value1
    at_data(:,km)   = value2
    at_data = lusolve(alu,kp,at_data)

  end subroutine at_BoundariesTau_NN_2d

  subroutine at_BoundariesTau_NN_1d(t_data,values)
    !
    ! Neumann/Dirichlet Ŭ(ˡ, 1 )
    ! ξǸۤͤͿ.
    !
    ! Υ֥롼ľܻȤȤ򴫤ʤ. 
    ! ̥󥿡ե at_Boundaries_NN Ѥ뤳. 
    !
    real(8), dimension(0:km),intent(inout)       :: t_data
    !(inout) ŬѤӥեǡ(0:km)

    real(8), dimension(2), intent(in), optional  :: values
    !(in) 

    real(8), dimension(1,0:km)                   :: at_work
    real(8), dimension(1,2)                      :: vwork           ! 

    if (.not. present(values)) then
       vwork(1,1)=0 ; vwork(1,2)=0
    else
       vwork(1,:) = values
    endif

    at_work(1,:)=t_data
    call at_BoundariesTau_NN_2d(at_work,vwork)
    t_data=at_work(1,:)

  end subroutine at_BoundariesTau_NN_1d

  !--------------- ʬ׻ -----------------
    function a_Int_ag(ag)
      !
      ! 1 ʻǡ¤ 2 ʬ
      !
      real(8), dimension(:,0:), intent(in)     :: ag
      !(in)ϳʻǡ

      real(8), dimension(size(ag,1))           :: a_Int_ag
      !(out) ʬǡ
      integer :: i

      if ( size(ag,2) < im+1 ) then
         call MessageNotify('E','ae_ag', &
              'The Grid points of input data too small.')
      elseif ( size(ag,2) > im+1 ) then
         call MessageNotify('W','ae_ag', &
              'The Grid points of input data too large.')
      endif

      a_Int_ag = 0.0d0
      do i=0,im
         a_Int_ag(:) = a_Int_ag(:) + ag(:,i)*g_X_Weight(i)
      enddo
    end function a_Int_ag

    function Int_g(g)
      !
      ! 1 ʻǡʬʿ.
      !
      real(8), dimension(0:im), intent(in)   :: g
      !(in) ʻǡ

      real(8)                                :: Int_g
      !(out) ʬ

      Int_g = sum(g*g_X_Weight)
    end function Int_g

    function a_Avr_ag(ag)
      !
      ! 1 ʻǡ¤ 2 ʿ
      !
      real(8), dimension(:,0:), intent(in)   :: ag
      !(in)ϳʻǡ

      real(8), dimension(size(ag,1))         :: a_Avr_ag
      !(out) ʿѤǡ

      a_Avr_ag = a_Int_ag(ag)/sum(g_X_Weight)
    end function a_Avr_ag

    function Avr_g(g)
      !
      ! 1 ʻǡʿ
      !
      real(8), dimension(0:im), intent(in)   :: g
      !(in) ʻǡ

      real(8)                                :: Avr_g
      !(out) ʬ

      Avr_g = Int_g(g)/sum(g_X_Weight)
    end function Avr_g



!---- Dirichlet (¶֤Ǥɾ) ----

  subroutine at_BoundariesGrid_DD_2d(at_data,values)
    !
    ! Dirichlet Ŭ(¶֤Ǥɾ, 2 )
    ! ξǤͤͿ.
    !
    real(8), dimension(:,0:),intent(inout)         :: at_data
    !(inout) ŬѤӥեǡ(m,0:km)

    real(8), dimension(:,:), intent(in), optional  :: values
    !(in) (m,2)

    real(8), dimension(:,:), allocatable     :: alu
    integer, dimension(:), allocatable       :: kp
    real(8), dimension(size(at_data,1),0:im) :: ag_data
    real(8), dimension(0:km,0:km)            :: tt_data
    real(8), dimension(0:km,0:im)            :: tg_data
    real(8), dimension(size(at_data,1))      :: value1, value2  ! 

    logical :: first = .true.
    integer :: k
    save    :: alu, kp, first

    if ( im /= km ) then
       call MessageNotify('E','at_BoundariesGrid_DD', &
            'Chebyshev truncation and number of grid points should be same.')
    endif

    if ( size(at_data,2)-1 < km ) then
       call MessageNotify('E','at_BoundariesGrid_DD', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(at_data,2)-1 > km ) then
       call MessageNotify('W','at_BoundariesGrid_DD', &
            'The Chebyshev dimension of input data too large.')
    endif

    if (.not. present(values)) then
       value1=0 ; value2=0
    else
       value1 = values(:,1) ; value2 = values(:,2)
    endif

    if ( first ) then
       first = .false.
       allocate(alu(0:im,0:km),kp(0:im))

       tt_data = 0
       do k=0,km
          tt_data(k,k)=1.0
       enddo
       tg_data = ag_at(tt_data)
       alu = transpose(tg_data)
!       alu(km-1,:) = tg_data(:,0)
!       alu(km,:)   = tg_data(:,im)

       call ludecomp(alu,kp)
    endif

    ag_data = ag_at(at_data)
    ag_data(:,0)  = value1
    ag_data(:,im) = value2
    at_data = lusolve(alu,kp,ag_data)

  end subroutine at_BoundariesGrid_DD_2d

  subroutine at_BoundariesGrid_DD_1d(t_data,values)
    !
    ! Dirichlet Ŭ(¶֤Ǥɾ, 1 )
    ! ξǤͤͿ.
    !
    real(8), dimension(0:km),intent(inout)       :: t_data
    !(inout) ŬѤӥեǡ(0:km)

    real(8), dimension(2), intent(in), optional  :: values
    !(in) 

    real(8), dimension(1,0:km)                   :: at_work
    real(8), dimension(1,2)                      :: vwork           ! 

    if (.not. present(values)) then
       vwork(1,1)=0 ; vwork(1,2)=0
    else
       vwork(1,:) = values
    endif

    at_work(1,:)=t_data
    call at_BoundariesGrid_DD_2d(at_work,vwork)
    t_data=at_work(1,:)

  end subroutine at_BoundariesGrid_DD_1d

!---- Dirichlet/Neumann (¶֤Ǥɾ) ----

  subroutine at_BoundariesGrid_DN_2d(at_data,values)
    !
    ! Dirichlet/Neumann Ŭ(¶֤Ǥɾ, 2 )
    ! i=0 , i=im ǸۤͤͿ.
    !
    real(8), dimension(:,0:),intent(inout)         :: at_data
    !(inout) ŬѤӥեǡ(m,0:km)

    real(8), dimension(:,:), intent(in), optional  :: values
    !(in) (m,2)

    real(8), dimension(:,:), allocatable     :: alu
    integer, dimension(:), allocatable       :: kp
    real(8), dimension(size(at_data,1),0:im) :: ag_data
    real(8), dimension(0:km,0:km)            :: tt_data
    real(8), dimension(0:km,0:im)            :: tg_data
    real(8), dimension(size(at_data,1))      :: value1, value2  ! 

    logical :: first = .true.
    integer :: k
    save    :: alu, kp, first

    if ( im /= km ) then
       call MessageNotify('E','at_BoundariesGrid_DN', &
            'Chebyshev truncation and number of grid points should be same.')
    endif

    if ( size(at_data,2)-1 < km ) then
       call MessageNotify('E','at_BoundariesGrid_DN', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(at_data,2)-1 > km ) then
       call MessageNotify('W','at_BoundariesGrid_DN', &
            'The Chebyshev dimension of input data too large.')
    endif

    if (.not. present(values)) then
       value1=0 ; value2=0
    else
       value1 = values(:,1) ; value2 = values(:,2)
    endif

    if ( first ) then
       first = .false.
       allocate(alu(0:im,0:km),kp(0:im))

       tt_data = 0
       do k=0,km
          tt_data(k,k)=1.0
       enddo
       tg_data = ag_at(tt_data)
       alu = transpose(tg_data)

       tg_data = ag_at(at_dx_at(tt_data))
       alu(im,:) = tg_data(:,im)

       call ludecomp(alu,kp)
    endif

    ag_data = ag_at(at_data)
    ag_data(:,0)  = value1
    ag_data(:,im) = value2
    at_data = lusolve(alu,kp,ag_data)

  end subroutine at_BoundariesGrid_DN_2d

  subroutine at_BoundariesGrid_DN_1d(t_data,values)
    !
    ! Dirichlet/Neumann Ŭ(¶֤Ǥɾ, 1 )
    ! i=0 , i=im ǸۤͤͿ.
    !
    real(8), dimension(0:km),intent(inout)       :: t_data
    !(inout) ŬѤӥեǡ(0:km)

    real(8), dimension(2), intent(in), optional  :: values
    !(in) 

    real(8), dimension(1,0:km)                   :: at_work
    real(8), dimension(1,2)                      :: vwork           ! 

    if (.not. present(values)) then
       vwork(1,1)=0 ; vwork(1,2)=0
    else
       vwork(1,:) = values
    endif

    at_work(1,:)=t_data
    call at_BoundariesGrid_DN_2d(at_work,vwork)
    t_data=at_work(1,:)

  end subroutine at_BoundariesGrid_DN_1d

!---- Neumann/Dirichlet (¶֤Ǥɾ) ----

  subroutine at_BoundariesGrid_ND_2d(at_data,values)
    !
    ! Neumann/Dirichlet Ŭ(¶֤Ǥɾ, 2 )
    ! i=0 Ǹۤ, i=im ͤͿ.
    !
    real(8), dimension(:,0:),intent(inout)         :: at_data
    !(inout) ŬѤӥեǡ(m,0:km)

    real(8), dimension(:,:), intent(in), optional  :: values
    !(in) (m,2)

    real(8), dimension(:,:), allocatable     :: alu
    integer, dimension(:), allocatable       :: kp
    real(8), dimension(size(at_data,1),0:im) :: ag_data
    real(8), dimension(0:km,0:km)            :: tt_data
    real(8), dimension(0:km,0:im)            :: tg_data
    real(8), dimension(size(at_data,1))      :: value1, value2  ! 

    logical :: first = .true.
    integer :: k
    save    :: alu, kp, first

    if ( im /= km ) then
       call MessageNotify('E','at_BoundariesGrid_ND', &
            'Chebyshev truncation and number of grid points should be same.')
    endif

    if ( size(at_data,2)-1 < km ) then
       call MessageNotify('E','at_BoundariesGrid_ND', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(at_data,2)-1 > km ) then
       call MessageNotify('W','at_BoundariesGrid_DD', &
            'The Chebyshev dimension of input data too large.')
    endif

    if (.not. present(values)) then
       value1=0 ; value2=0
    else
       value1 = values(:,1) ; value2 = values(:,2)
    endif

    if ( first ) then
       first = .false.
       allocate(alu(0:im,0:km),kp(0:im))

       tt_data = 0
       do k=0,km
          tt_data(k,k)=1.0
       enddo
       tg_data = ag_at(tt_data)
       alu = transpose(tg_data)

       tg_data = ag_at(at_dx_at(tt_data))
       alu(0,:)  = tg_data(:,0)

       call ludecomp(alu,kp)
    endif

    ag_data = ag_at(at_data)
    ag_data(:,0)  = value1
    ag_data(:,im) = value2
    at_data = lusolve(alu,kp,ag_data)

  end subroutine at_BoundariesGrid_ND_2d

  subroutine at_BoundariesGrid_ND_1d(t_data,values)
    !
    ! Neumann Ŭ(¶֤Ǥɾ, 1 )
    ! i=0 Ǹۤ, i=im ͤͿ.
    !
    real(8), dimension(0:km),intent(inout)       :: t_data
    !(inout) ŬѤӥեǡ(0:km)

    real(8), dimension(2), intent(in), optional  :: values
    !(in) 

    real(8), dimension(1,0:km)                   :: at_work
    real(8), dimension(1,2)                      :: vwork           ! 

    if (.not. present(values)) then
       vwork(1,1)=0 ; vwork(1,2)=0
    else
       vwork(1,:) = values
    endif

    at_work(1,:)=t_data
    call at_BoundariesGrid_ND_2d(at_work,vwork)
    t_data=at_work(1,:)

  end subroutine at_BoundariesGrid_ND_1d

!---- Neumann  ----

  subroutine at_BoundariesGrid_NN_2d(at_data,values)
    !
    ! Neumann Ŭ(¶֤Ǥɾ, 2 )
    ! ξǸۤͤͿ.
    !
    real(8), dimension(:,0:),intent(inout)         :: at_data
    !(inout) ŬѤӥեǡ(m,0:km)

    real(8), dimension(:,:), intent(in), optional  :: values  
    !(in) (m,2)

    real(8), dimension(:,:), allocatable     :: alu
    integer, dimension(:), allocatable       :: kp
    real(8), dimension(size(at_data,1),0:im) :: ag_data
    real(8), dimension(0:km,0:km)            :: tt_data
    real(8), dimension(0:km,0:im)            :: tg_data
    real(8), dimension(size(at_data,1))      :: value1, value2  ! 

    logical :: first = .true.
    integer :: k
    save    :: alu, kp, first

    if ( im /= km ) then
       call MessageNotify('E','at_BoundariesGrid_NN', &
            'Chebyshev truncation and number of grid points should be same.')
    endif

    if ( size(at_data,2)-1 < km ) then
       call MessageNotify('E','at_BoundariesGrid_NN', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(at_data,2)-1 > km ) then
       call MessageNotify('W','at_BoundariesGrid_NN', &
            'The Chebyshev dimension of input data too large.')
    endif

    if (.not. present(values)) then
       value1=0 ; value2=0
    else
       value1 = values(:,1) ; value2 = values(:,2)
    endif

    if ( first ) then
       first = .false.
       allocate(alu(0:im,0:km),kp(0:im))

       tt_data = 0
       do k=0,km
          tt_data(k,k)=1.0
       enddo
       tg_data = ag_at(tt_data)
       alu = transpose(tg_data)

       tg_data = ag_at(at_dx_at(tt_data))
       alu(0,:)  = tg_data(:,0)
       alu(im,:) = tg_data(:,im)

       call ludecomp(alu,kp)
    endif

    ag_data = ag_at(at_data)
    ag_data(:,0)  = value1
    ag_data(:,im) = value2
    at_data = lusolve(alu,kp,ag_data)

  end subroutine at_BoundariesGrid_NN_2d

  subroutine at_BoundariesGrid_NN_1d(t_data,values)
    !
    ! Neumann Ŭ(¶֤Ǥɾ, 1 )
    ! ξǸۤͤͿ.
    !
    real(8), dimension(0:km),intent(inout)       :: t_data  
    !(inout) ŬѤӥեǡ(0:km)

    real(8), dimension(2), intent(in), optional  :: values  
    !(in) 

    real(8), dimension(1,0:km)                   :: at_work
    real(8), dimension(1,2)                      :: vwork           ! 

    if (.not. present(values)) then
       vwork(1,1)=0 ; vwork(1,2)=0
    else
       vwork(1,:) = values
    endif

    at_work(1,:)=t_data
    call at_BoundariesGrid_NN_2d(at_work,vwork)
    t_data=at_work(1,:)

  end subroutine at_BoundariesGrid_NN_1d

end module at_module
