!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!$BI=Bj(B  at_module $B%F%9%H%W%m%0%i%`(B
!
!$BMzNr(B  2002/04/10  $BC]9-??0l(B
!
program at_test2d

  use at_module
  implicit none
  integer, parameter :: im=8, km=5, nm=4
  real(8), parameter :: xmin=-1.0D0, xmax=1.0D0
  real(8), parameter :: eps=1.0D-14

  real(8), dimension(0:nm,0:im) :: ag_y
  real(8), dimension(0:nm,0:km) :: at_y
  real(8), dimension(0:nm,0:im) :: ag_yderiv

  integer :: k, i, m

  call at_initial(im,km,xmin,xmax)

  ag_y(0,:) = 1                          ! T_0
  ag_y(1,:) = g_x                        ! T_1
  ag_y(2,:) = 2*g_x**2 - 1               ! T_2
  ag_y(3,:) = 4*g_x**3 - 3*g_x           ! T_3
  ag_y(4,:) = 8*g_x**4 - 8*g_x**2 + 1
  ag_yderiv(0,:) = 0.0D0                 ! T_0'= 0
  ag_yderiv(1,:) = 1.0D0                 ! T_1'= T_0
  ag_yderiv(2,:) = 4*g_x                 ! T_2'= 4*T_1
  ag_yderiv(3,:) = 12*g_x**2 - 3         ! T_3'= 6*T_2 + 3*T_0
  ag_yderiv(4,:) = 32*g_x**3 - 16*g_x    ! T_4'= 8*T_3 + 8*T_1

  at_y = at_dx_at(at_ag(ag_y))

  write(6,*) 'X grid points'
  write(6,*) g_x
  write(6,*)

  write(6,*) 'y(n)=T_n(x), n=0...4'
  write(6,*) 'at_dx_at(at_ag(y))'
  do m=0,nm
     write(6,*) 'n=',m
     write(6,*) at_y(m,:)
  enddo

  write(6,*) 
  write(6,*) 'wrong values are displayed below...'
  ag_y=ag_at(at_y)
  do m=0,nm
     do i=0,im
        if ( abs(ag_y(m,i)-ag_yderiv(m,i)) .gt. eps ) then
           write(6,*) m,i, ag_y(m,i), ag_yderiv(m,i), ag_y(m,i)-ag_yderiv(m,i)
        endif
     enddo
  enddo

end program at_test2d

