require 'rbconfig'
require 'find'
require 'ftools'
require 'optparse'

include Config

$ruby = CONFIG['ruby_install_name']

##
# Install a binary file. We patch in on the way through to
# insert a #! line. If this is a Unix install, we name
# the command (for example) 'rdoc' and let the shebang line
# handle running it. Under windows, we add a '.rb' extension
# and let file associations to their stuff
#

# Main Program

opt = OptionParser.new
OPTS = {}
opt.summary_width = 23
opt.summary_indent = ''*1
opt.on('--libdir=VAL', 
       'Directory to which the libraries are installed') \
       {|v| $libdir = v.to_s}
opt.on('--help', 'Show help message') {|v| OPTS[:help] = v}

opt.parse!(ARGV)

$libdir = File.expand_path($libdir) if $libdir

install_opt = ""
install_opt = "--libdir=#{$libdir}" if $libdir

if $libdir
  $sitedir = $libdir
else
  $sitedir = CONFIG["sitelibdir"]
  unless $sitedir
    version = CONFIG["MAJOR"]+"."+CONFIG["MINOR"]
    $libdir = File.join(CONFIG["libdir"], "ruby", version)
    $sitedir = $:.find {|x| x =~ /site_ruby/}
    if !$sitedir
      $sitedir = File.join($libdir, "site_ruby")
    elsif $sitedir !~ Regexp.quote(version)
      $sitedir = File.join($sitedir, version)
    end
  end
end

macro_dest = File.join($sitedir, "mathml/macro")

# help message
if ARGV[0] || OPTS[:help]
  print <<-HELP

  This ruby script installs libraries to \"#{macro_dest}\",
  (See \"rbconfig.rb\")

  If you want to install other directory, use following options.

  OPTIONS: \n#{opt.to_a[1..-1].join("")}

HELP
  exit
end

# make directories
File::makedirs(macro_dest, true)

File::chmod(0755, macro_dest)


# The library files
files = %w{
 D6math.sty
}.collect {|f| Dir.glob(f)}.flatten

for aFile in files
  File::install(aFile, File.join(macro_dest, aFile), 0644, true)
end
