#!/usr/bin/ruby
#
# x-math.rbѥ˥åȥƥ
# $Id: test_math.rb 331 2006-01-26 15:19:35Z hiraku $
#
# Copyright (C) 2005, KURODA Hiraku <hiraku@hinet.mydns.jp>
# You can redistribute it and/or modify it under GPL2.
#
require 'test/unit'
require 'mathml.rb'

class TC_TeX2MathML < Test::Unit::TestCase
	include MathML
	include TeX2MathML

	def mathml(str, flg=false)
		Convertor.new(str, flg).to_s+"\n"
	end

	def test_operators
		def t(o)
			o=~REG_OPERATORS
		end
		assert(t('.'))
		assert(t(','))
		assert(t('+'))
		assert(t('-'))
		assert(t('/'))
		assert(t('('))
		assert(t(')'))
		assert(t('['))
		assert(t(']'))
		assert(t('\''))
		assert(t('"'))

	end

	def test_null
		assert_equal(<<M, mathml(''))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'></math>
M
	end

	def test_style
		assert_equal(<<M, mathml('', true))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='block'></math>
M
	end

	def test_numerics
		assert_equal(<<M, mathml('1234567890'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mn>1234567890</mn>
</math>
M
		assert_equal(<<M, mathml('{123}'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mrow>
  <mn>123</mn>
 </mrow>
</math>
M
		assert_equal(<<M, mathml('1.2'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mn>1.2</mn>
</math>
M
		assert_equal(<<M, mathml('1.'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mn>1</mn>
 <mo>.</mo>
</math>
M
		assert_equal(<<M, mathml('.2'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mn>.2</mn>
</math>
M
		assert_equal(<<M, mathml('1.2.3'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mn>1.2</mn>
 <mn>.3</mn>
</math>
M
	end

	def test_func
		assert_equal(<<M, mathml('f(x)=ax(1-x)'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mi>f</mi>
 <mo>(</mo>
 <mi>x</mi>
 <mo>)</mo>
 <mo>=</mo>
 <mi>a</mi>
 <mi>x</mi>
 <mo>(</mo>
 <mn>1</mn>
 <mo>-</mo>
 <mi>x</mi>
 <mo>)</mo>
</math>
M
	end

	def test_sub
		assert_equal(<<M, mathml('a_{bc}'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <msub>
  <mi>a</mi>
  <mrow>
   <mi>b</mi>
   <mi>c</mi>
  </mrow>
 </msub>
</math>
M
	end

	def test_sup
		assert_equal(<<M, mathml('a^{bc}'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <msup>
  <mi>a</mi>
  <mrow>
   <mi>b</mi>
   <mi>c</mi>
  </mrow>
 </msup>
</math>
M
	end

	def test_subsup
		assert_equal(<<M, mathml('a^{bc}_{de}'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <msubsup>
  <mi>a</mi>
  <mrow>
   <mi>d</mi>
   <mi>e</mi>
  </mrow>
  <mrow>
   <mi>b</mi>
   <mi>c</mi>
  </mrow>
 </msubsup>
</math>
M
	end

	def test_doublesub
		assert_raises(MathML::TeX2MathML::ConvertError){mathml('a_b_c')}
	end

	def test_sum_infty
		assert_equal(<<M, mathml('\sum_{i=1}^\infty'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <msubsup>
  <mo>&sum;</mo>
  <mrow>
   <mi>i</mi>
   <mo>=</mo>
   <mn>1</mn>
  </mrow>
  <mi mathvariant='normal'>&infin;</mi>
 </msubsup>
</math>
M
	end

	def test_change_font
		assert_equal(<<M, mathml('a{\bf b}c\bf d'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mi>a</mi>
 <mrow>
  <mi mathvariant='bold'>b</mi>
 </mrow>
 <mi>c</mi>
 <mi mathvariant='bold'>d</mi>
</math>
M
	end

	def test_subsup_notsubsup
		assert_equal(<<M, mathml('\sum'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mo>&sum;</mo>
</math>
M
	end

	def test_frac
		assert_equal(<<M, mathml('\frac a b'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mfrac>
  <mi>a</mi>
  <mi>b</mi>
 </mfrac>
</math>
M
		assert_equal(<<M, mathml('\frac ab'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mfrac>
  <mi>a</mi>
  <mi>b</mi>
 </mfrac>
</math>
M
		assert_raises(MathML::TeX2MathML::ConvertError){mathml('\frac a')}
		assert_equal(<<M, mathml('\frac12'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mfrac>
  <mn>1</mn>
  <mn>2</mn>
 </mfrac>
</math>
M
	end

	def test_array
		assert_equal(<<M, mathml('\begin{array}{cc}1&0\\\\ 0&1\end{array}'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mtable>
  <mtr>
   <mtd>
    <mn>1</mn>
   </mtd>
   <mtd>
    <mn>0</mn>
   </mtd>
  </mtr>
  <mtr>
   <mtd>
    <mn>0</mn>
   </mtd>
   <mtd>
    <mn>1</mn>
   </mtd>
  </mtr>
 </mtable>
</math>
M
		assert_equal(<<M, mathml(<<'T'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mtable>
  <mtr>
   <mtd>
    <mi>a</mi>
   </mtd>
   <mtd>
    <mi>b</mi>
   </mtd>
   <mtd>
    <mi>c</mi>
   </mtd>
  </mtr>
 </mtable>
</math>
M
\begin{array}{ccc}
a & b & c
\end{array}
T
		assert_equal(<<M, mathml(<<'T'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mtable>
  <mtr>
   <mtd>
    <mi>a</mi>
   </mtd>
   <mtd>
    <mi>b</mi>
   </mtd>
   <mtd>
    <mi>c</mi>
   </mtd>
  </mtr>
  <mtr>
   <mtd>
    <mi>f</mi>
    <mo>(</mo>
    <mi>x</mi>
    <mo>)</mo>
   </mtd>
   <mtd>
    <mo>=</mo>
   </mtd>
   <mtd>
    <mi>a</mi>
    <mi>x</mi>
   </mtd>
  </mtr>
 </mtable>
</math>
M
\begin{array}{ccc}
a & b & c\\
f(x) & = & ax \\
\end{array}
T
		assert_equal(<<M, mathml(<<'T'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mtable>
  <mtr>
   <mtd columnalign='right'>
    <mi>f</mi>
    <mo>(</mo>
    <mi>x</mi>
    <mo>)</mo>
   </mtd>
   <mtd>
    <mo>=</mo>
   </mtd>
   <mtd columnalign='left'>
    <mi>a</mi>
    <mi>x</mi>
   </mtd>
  </mtr>
  <mtr>
   <mtd columnalign='right'>
    <mi>g</mi>
    <mo>(</mo>
    <mi>y</mi>
    <mo>)</mo>
   </mtd>
   <mtd>
    <mo>=</mo>
   </mtd>
   <mtd columnalign='left'>
    <mi>b</mi>
    <mi>y</mi>
   </mtd>
  </mtr>
 </mtable>
</math>
M
\begin{array}{rcl}
f(x) & = & ax \\
g(y) &=& by
\end{array}
T
		assert_equal(<<M, mathml(<<'T'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mtable>
  <mtr>
   <mtd>
    <msubsup>
     <mo>&sum;</mo>
     <mrow>
      <mi>i</mi>
      <mo>=</mo>
      <mn>1</mn>
     </mrow>
     <mrow>
      <mi mathvariant='normal'>&infin;</mi>
     </mrow>
    </msubsup>
   </mtd>
  </mtr>
 </mtable>
</math>
M
\begin{array}{c}
\sum_{i=1}^{\infty}
\end{array}
T
	end

	def test_fenced
		assert_equal(<<M, mathml(<<'T'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mfenced open='{' close=''>
  <mrow>
   <mtable>
    <mtr>
     <mtd columnalign='right'>
      <mi>f</mi>
      <mo>(</mo>
      <mi>x</mi>
      <mo>)</mo>
     </mtd>
     <mtd>
      <mo>=</mo>
     </mtd>
     <mtd columnalign='left'>
      <mi>a</mi>
      <mi>x</mi>
     </mtd>
    </mtr>
    <mtr>
     <mtd columnalign='right'>
      <mi>g</mi>
      <mo>(</mo>
      <mi>y</mi>
      <mo>)</mo>
     </mtd>
     <mtd>
      <mo>=</mo>
     </mtd>
     <mtd columnalign='left'>
      <mi>b</mi>
      <mi>y</mi>
     </mtd>
    </mtr>
   </mtable>
  </mrow>
 </mfenced>
</math>
M
\left\{\begin{array}{rcl}
f(x) & = & ax \\
g(y) &=& by
\end{array}\right.
T
	end

	def test_braces
		assert_equal(<<M, mathml('\{\}'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mo>{</mo>
 <mo>}</mo>
</math>
M
	end

	def test_over
		assert_equal(<<M, mathml('\hat{abc}'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mover>
  <mrow>
   <mi>a</mi>
   <mi>b</mi>
   <mi>c</mi>
  </mrow>
  <mo>&circ;</mo>
 </mover>
</math>
M
	end

	def test_stackrel
		assert_equal(<<M, mathml('\stackrel\varphi\rightarrow'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mover>
  <mo>&rightarrow;</mo>
  <mo><mi>&varphi;</mi></mo>
 </mover>
</math>
M
	end

	def test_mbox
		assert_equal(<<M, mathml('\mbox{abc}'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mtext>abc</mtext>
</math>
M
		assert_equal(<<M, mathml('\mbox a'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mtext>a</mtext>
</math>
M
		assert_equal(<<M, mathml(<<'T'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mfenced open='{' close=''>
  <mrow>
   <mtable>
    <mtr>
     <mtd columnalign='right'>
      <mi>f</mi>
      <mo>(</mo>
      <mi>x</mi>
      <mo>)</mo>
     </mtd>
     <mtd>
      <mo>=</mo>
     </mtd>
     <mtd columnalign='left'>
      <msup>
       <mi>x</mi>
       <mn>2</mn>
      </msup>
      <mtext>mod</mtext>
      <mi>p</mi>
     </mtd>
    </mtr>
    <mtr>
     <mtd columnalign='right'>
      <mi>f</mi>
      <mo>(</mo>
      <mi>x</mi>
      <mo>)</mo>
     </mtd>
     <mtd>
      <mo>=</mo>
     </mtd>
     <mtd columnalign='left'>
      <msup>
       <mi>x</mi>
       <mn>2</mn>
      </msup>
      <mtext>mod</mtext>
      <mi>p</mi>
     </mtd>
    </mtr>
   </mtable>
  </mrow>
 </mfenced>
</math>
M
\left\{\begin{array}{rcl}
f(x)&=&x^2 \mbox{mod} p \\
f(x)&=&x^2 \mbox{mod} p
\end{array}\right.
T
	end

	def test_space_brace
		assert_equal(<<M, mathml(' { { a } }'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mrow>
  <mrow>
   <mi>a</mi>
  </mrow>
 </mrow>
</math>
M
	end

	def test_dollar
		assert_equal(<<M, mathml('\\$'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mo>$</mo>
</math>
M
	end

	def test_replace_operators
		assert_equal(<<M, mathml('<>"'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mo>&lt;</mo>
 <mo>&gt;</mo>
 <mo>&quot;</mo>
</math>
M
	end

	def test_comment
		assert_equal(<<M, mathml('a%bc'))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mi>a</mi>
</math>
M
	end

	def test_user_entity
		therefore = '\entity{therefore}'
		assert_raises(MathML::TeX2MathML::ConvertError) do
			mathml(therefore)
		end

		Convertor.unsecure_entity = true
		assert_equal(<<M, mathml(therefore))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mo>&therefore;</mo>
</math>
M

		Convertor.unsecure_entity = false
		assert_raises(MathML::TeX2MathML::ConvertError) do
			mathml(therefore)
		end

		Convertor.add_entity_list(['therefore'])
		assert_equal(<<M, mathml(therefore))
<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>
 <mo>&therefore;</mo>
</math>
M
	end
end
