/*
 *
 *  base16 encoding/decoding per RFC 4648
 *
 *   Copyright (C) 2013, 2016  Milan Kupcevic
 *   All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *  this list of conditions and the following disclaimer.
 *
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and/or other materials provided with the distribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 *  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

#include "basez.h"

static const unsigned char c16u[] = "0123456789ABCDEF";
static const unsigned char c16l[] = "0123456789abcdef";

static const unsigned char c16d[] = 
{
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* 00 - 07 */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* 08 - 0f */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* 10 - 17 */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* 18 - 1f */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* 20 - 27 */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* 28 - 2f */
  0x00, 0x01, 0x02, 0x03,    0x04, 0x05, 0x06, 0x07, /* 30 - 37 */
  0x08, 0x09, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* 38 - 3f */
  0xff, 0x0a, 0x0b, 0x0c,    0x0d, 0x0e, 0x0f, 0xff, /* 40 - 47 */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* 48 - 4f */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* 50 - 57 */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* 58 - 5f */
  0xff, 0x0a, 0x0b, 0x0c,    0x0d, 0x0e, 0x0f, 0xff, /* 60 - 67 */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* 68 - 6f */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* 70 - 77 */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* 78 - 7f */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* 80 - 87 */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* 88 - 8f */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* 90 - 97 */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* 98 - 9f */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* a0 - a7 */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* a8 - af */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* b0 - b7 */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* b8 - bf */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* c0 - c7 */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* c8 - cf */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* d0 - d7 */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* d8 - df */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* e0 - e7 */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* e8 - ef */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* f0 - f7 */
  0xff, 0xff, 0xff, 0xff,    0xff, 0xff, 0xff, 0xff, /* f8 - ff */
};

void
encode_base16u(
  const unsigned char *bin,
  unsigned char *bout)
{
  bout[1] = c16u[*bin & 0x0f];
  bout[0] = c16u[*bin >> 4];
}

void
encode_base16l(
  const unsigned char *bin,
  unsigned char *bout)
{
  bout[1] = c16l[*bin & 0x0f];
  bout[0] = c16l[*bin >> 4];
}

int
decode_base16(
  const unsigned char *bin,
  unsigned char *bout)
{
  if(c16d[bin[0]] != 0xff)
    *bout = c16d[bin[0]] << 4;
  else
    return 0;

  if(c16d[bin[1]] != 0xff)
    *bout = *bout | c16d[bin[1]];
  else
    return 0;

  return 1;
}

