{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdTextureTransform: TMFNode;
    { Internal wrapper for property @code(TextureTransform). This wrapper API may change, we advise to access simpler @code(TextureTransform) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTextureTransform: TMFNode read FFdTextureTransform;
    {  }
    procedure SetTextureTransform(const Value: array of TAbstractSingleTextureTransformNode);

{$endif read_interface}

{$ifdef read_implementation}

{ TMultiTextureTransformNode ----------------------------------------------- }

procedure TMultiTextureTransformNode.SetTextureTransform(const Value: array of TAbstractSingleTextureTransformNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractSingleTextureTransformNode));
  FdTextureTransform.Send(A);
end;

class function TMultiTextureTransformNode.ClassX3DType: String;
begin
  Result := 'MultiTextureTransform';
end;

procedure TMultiTextureTransformNode.CreateNode;
begin
  inherited;

  FFdTextureTransform := TMFNode.Create(Self, True, 'textureTransform', [TAbstractSingleTextureTransformNode]);
   FdTextureTransform.ChangeAlways := chEverything;
  AddField(FFdTextureTransform);
end;

{$endif read_implementation}
