# CiviCRM 5.21.0

Released January 1, 2020

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Default to 'copy' for non-empty fields on merge screen
  ([dev/core#1339](https://lab.civicrm.org/dev/core/issues/1339):
  [15595](https://github.com/civicrm/civicrm-core/pull/15595))**

  This updates the contact merge screen to default to copying data for all
  non-empty fields. This change makes it easier to keep too much data but harder
  to lose some.

- **Performance issue when exporting to CSV from reports with custom fields
  ([dev/report#19](https://lab.civicrm.org/dev/report/issues/19):
  [15248](https://github.com/civicrm/civicrm-core/pull/15248))**

  Performance improvements when exporting a report to CSV.

- **Memory error on creating large pdfs
  ([dev/core#574](https://lab.civicrm.org/dev/core/issues/574):
  [13232](https://github.com/civicrm/civicrm-core/pull/13232))**

  Improves performance when creating PDFs.

- **Update Country list: change Macedonia, Republic of into North Macedonia
  ([dev/core#1166](https://lab.civicrm.org/dev/core/issues/1166):
  [15997](https://github.com/civicrm/civicrm-core/pull/15997))**

  Updates the name of "Macedonia, Republic of" to "North Macedonia" in
  accordance with the iso 3166-1 list.

- **Tagsets should display vertically in activity/new case forms
  ([dev/core#1346](https://lab.civicrm.org/dev/core/issues/1346):
  [15649](https://github.com/civicrm/civicrm-core/pull/15649))**

  Improves the User interface of the "New Activity" and "New Case" forms by
  displaying the tag fields vertically instead of horizontally.

- **Make utf8mb4 status check language more for the general consumer
  ([15946](https://github.com/civicrm/civicrm-core/pull/15946))**

  This alters the language on the utf8mb4 status check so that it is a bit more
  general in nature and hopefully easier to digest for end users.

- **Include Metadata on advanced search form for membership, grant, pledge,
  contribution, and case fields
  ([15936](https://github.com/civicrm/civicrm-core/pull/15936),
  [15785](https://github.com/civicrm/civicrm-core/pull/15785), and
  [15928](https://github.com/civicrm/civicrm-core/pull/15928))**

  You can now set URL parameters for additional fields like
  `membership_join_date` and `pledge_payment_start_date` to pre-filter results
  on the advanced search form.

- **Fix activity search to work by url params
  ([15990](https://github.com/civicrm/civicrm-core/pull/15990))**

  You can now set URL parameters like `activity_date_time_high` to pre-filter
  results on the activity search form.

- **Replace all instances of CRM_Core_Fatal with throw new CRM_Core_Exception
  (Work towards [dev/core#560](https://lab.civicrm.org/dev/core/issues/560):
  [15903](https://github.com/civicrm/civicrm-core/pull/15903),
  [15770](https://github.com/civicrm/civicrm-core/pull/15770),
  [15941](https://github.com/civicrm/civicrm-core/pull/15941),
  [15775](https://github.com/civicrm/civicrm-core/pull/15775) and
  [15822](https://github.com/civicrm/civicrm-core/pull/15822))**

  Work towards throwing exceptions instead of fatal errors.

- **Remove background opacity in menus; improving accessibility/readability
  ([15847](https://github.com/civicrm/civicrm-core/pull/15847))**

  The CiviCRM menu is now opaque to improve readability.

- **Improve datePicker placeholder/icons
  ([15848](https://github.com/civicrm/civicrm-core/pull/15848))**

  Small tweaks to the datepicker widget to improve flexibility & consistency.

- **modified shared address note under contact dashboard
  ([15666](https://github.com/civicrm/civicrm-core/pull/15666) and
  [15769](https://github.com/civicrm/civicrm-core/pull/15769))**

  Improves the note below the Shared Address field to include a link to the
  contact that the address lives on to make it easier for get to the shared
  address to edit it.

- **Grant in Edit mode doesn't show the associated contact and standardize all
  screens accordingly. (Work Towards
  [dev/core#1065](https://lab.civicrm.org/dev/core/issues/1065):
  [15757](https://github.com/civicrm/civicrm-core/pull/15757),
  [15833](https://github.com/civicrm/civicrm-core/pull/15833) and
  [15840](https://github.com/civicrm/civicrm-core/pull/15840))**

  This standardizes edit screens for participant, grant, and membership records
  to ensure that a clickable link to the associated contact is included in a
  consistent way.

- **Temporary tables should follow consistent naming convention (Work Towards
  [dev/core#183](https://lab.civicrm.org/dev/core/issues/183):
  [15795](https://github.com/civicrm/civicrm-core/pull/15795),
  [15798](https://github.com/civicrm/civicrm-core/pull/15798),
  [15819](https://github.com/civicrm/civicrm-core/pull/15819),
  [15793](https://github.com/civicrm/civicrm-core/pull/15793),
  [15792](https://github.com/civicrm/civicrm-core/pull/15792),
  [15874](https://github.com/civicrm/civicrm-core/pull/15874),
  [15821](https://github.com/civicrm/civicrm-core/pull/15821),
  [15823](https://github.com/civicrm/civicrm-core/pull/15823),
  [15826](https://github.com/civicrm/civicrm-core/pull/15826),
  [15820](https://github.com/civicrm/civicrm-core/pull/15820),
  [15825](https://github.com/civicrm/civicrm-core/pull/15825),
  [15876](https://github.com/civicrm/civicrm-core/pull/15876), and
  [16155](https://github.com/civicrm/civicrm-core/pull/16155))**

  Begins work to enforce a common naming convention for temporary tables.

### CiviContribute

- **Develop getter & setter structure for Payment classes (Work Towards
  [dev/financial#82](https://lab.civicrm.org/dev/financial/issues/82):
  [15697](https://github.com/civicrm/civicrm-core/pull/15697),
  [16052](https://github.com/civicrm/civicrm-core/pull/16052),
  [16060](https://github.com/civicrm/civicrm-core/pull/16060), and
  [16081](https://github.com/civicrm/civicrm-core/pull/16081))**

  This PR adds a new class, `Civi\Payment\PropertyBag` which is designed to
  offer a consistent object for holding payment parameters as they are sent to
  and from payment processors.  For now, the legacy array of parameters is still
  valid, so this will not have much immediate impact, but it lays the groundwork
  for future work.

- **Always display amount paid even if it is 0.00. Blank looks like it's missing
  data rather than nothing paid
  ([16021](https://github.com/civicrm/civicrm-core/pull/16021))**

  This improves user experience by displaying contributions of 0 as 0 instead
  of blank.

### CiviMail

- **CiviMail - Only display "Headers and Footers" if there are headers and
  footers ([15326](https://github.com/civicrm/civicrm-core/pull/15326))**

  Makes it so when creating a CiviMail Mailing the "Headers and Footers" tab
  only displays if there are Headers and/or Footers configured on the site.

### Drupal Integration

- **Add participant is_test field to views
  ([590](https://github.com/civicrm/civicrm-drupal/pull/590))**

  Makes the Participant `is_test` field available in views.

### PayPal Implementation

- **PayPalImpl: Add SOLUTIONTYPE parameter that triggers allowing to pay without
  having to create a paypal account.
  ([15523](https://github.com/civicrm/civicrm-core/pull/15523))**

  Adds a `SOLUTIONTYPE` parameter to the PayPal checkout values so that one can
  make a contribution without having to create an account.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **CiviCRM Option Group with a name containing spaces cannot have any options
  added, error message is shown also impacts the in-place option editor
  ([dev/core#1405](https://lab.civicrm.org/dev/core/issues/1405) and
  [dev/core#1447](https://lab.civicrm.org/dev/core/issues/1447):
  [15937](https://github.com/civicrm/civicrm-core/pull/15937) and
  [16033](https://github.com/civicrm/civicrm-core/pull/16033))**

  Option group names are no longer exposed for editing, as they are now
  automatically generated from the title.  On upgrade, existing option group
  names that contain spaces will be rewritten.  *Extensions that provide or rely
  upon option group names that contain spaces will need to be rewritten.*

  Upon upgrade, if rewriting an option group name will duplicate another option
  group's name, that option group will be skipped and a post-upgrade message
  will show the details.

- **Quicksearch with phone filter doesn't work with non-numeric character
  ([dev/core#1420](https://lab.civicrm.org/dev/core/issues/1420):
  [15955](https://github.com/civicrm/civicrm-core/pull/15955))**

- **Option to open navigation item in new window (if present)
  ([dev/core#1398](https://lab.civicrm.org/dev/core/issues/1398):
  [15861](https://github.com/civicrm/civicrm-core/pull/15861))**

  Ensures the target attribute is respected for menu items that are added using
  the navigationMenu hook.

- **CIVI-SA-2019-21 may lead to regressions when following typehints on
  CRM_Core_BAO_Setting::setItem() (Work Towards
  [dev/core#1425](https://lab.civicrm.org/dev/core/issues/1425):
  [15981](https://github.com/civicrm/civicrm-core/pull/15981),
  [15988](https://github.com/civicrm/civicrm-core/pull/15988) and
  [15980](https://github.com/civicrm/civicrm-core/pull/15980))**

  Removes a misleading PHPDoc type hint for the `$value` parameter in
  `CRM_Core_BAO_Setting::setItem()` and updates tests that use this function.

- **Only add in the metadata for advanced search if user has access to the
  relevant component
  ([15987](https://github.com/civicrm/civicrm-core/pull/15987))**

  Ensures the user has access to the relevant component before adding metadata
  for that component to the advanced search form.

- **Fix api explorer formatting IS NULL clauses
  ([15817](https://github.com/civicrm/civicrm-core/pull/15817))**

  Fixes a formatting issue in the api explorer output where IS NULL and IS NOT
  NULL clauses would output invalid code due to the missing value piece of the
  clause.

- **Add in translation function around newly converted statusBounce messages
  ([15774](https://github.com/civicrm/civicrm-core/pull/15774))**

- **Fix cachekey string
  ([15761](https://github.com/civicrm/civicrm-core/pull/15761))**

  Fixes an obscure bug where no custom fields were being returned when doing a
  Contact.get api call with check_permissions=0.

- **Fix potential test glitch when repeatedly calling createLoggedInUser
  ([15965](https://github.com/civicrm/civicrm-core/pull/15965))**

- **Ensure that when sorting on columns in the find activity search the arrow
  shows which field is being sorted and direction
  ([15943](https://github.com/civicrm/civicrm-core/pull/15943))**

- **translate strings
  ([15858](https://github.com/civicrm/civicrm-core/pull/15858))**

  Some text in the extension manager was not wrapped in a translation function.

- **Filter contact sub-type by "is not one of" fails
  ([dev/report#23](https://lab.civicrm.org/dev/report/issues/23):
  [15971](https://github.com/civicrm/civicrm-core/pull/15971))**

- **Trying to edit the settings for a reserved option group gives a network
  error can't connect to server
  ([dev/core#1477](https://lab.civicrm.org/dev/core/issues/1477):
  [16107](https://github.com/civicrm/civicrm-core/pull/16107))**

### CiviCampaign

- **Activities not visible if they have a campaign_id & contact does not have
  'administer CiviCampaign'
  ([dev/core#1444](https://lab.civicrm.org/dev/core/issues/1444):
  [16057](https://github.com/civicrm/civicrm-core/pull/16057))**

### CiviCase

- **Case Activities Report includes core activities *always*
  ([dev/core#1366](https://lab.civicrm.org/dev/core/issues/1366):
  [15882](https://github.com/civicrm/civicrm-core/pull/15882) and
  [15877](https://github.com/civicrm/civicrm-core/pull/15877))**

- **Case search with force URL parameters gives php warning
  ([dev/core#1410](https://lab.civicrm.org/dev/core/issues/1410) and
  [dev/core#1414](https://lab.civicrm.org/dev/core/issues/1414):
  [15920](https://github.com/civicrm/civicrm-core/pull/15920) and
  [15924](https://github.com/civicrm/civicrm-core/pull/15924))**

- **CiviCase - Make static function `allActivityTypes()` static
  ([15839](https://github.com/civicrm/civicrm-core/pull/15839))**

### CiviContribute

- **Membership form permits creating invalid transactions
  ([dev/financial#100](https://lab.civicrm.org/dev/financial/issues/100):
  [15771](https://github.com/civicrm/civicrm-core/pull/15771))**

  To avoid users accidentally setting invalid statuses, this removes the
  statuses "Partially Paid", "Cancelled", and "Failed" from the `Payment Status`
  field when recording a payment for a Contribution related to a Membership.
  Additionally, removes the statuses "Partially Paid", "Overdue" and "In
  Progress" from the `Payment Status` field when  recording a payment for a
  Contribution related to an Event.

- **hook_civicrm_post() implementation results in DB Error: already exists for
  custom field values
  ([dev/core#1443](https://lab.civicrm.org/dev/core/issues/1443):
  [16061](https://github.com/civicrm/civicrm-core/pull/16061))**

  The post hook is invoked after storing custom values when adding contributions.

- **Lybunt report - remove broken chart functionality
  ([dev/core#523](https://lab.civicrm.org/dev/core/issues/523):
  [15989](https://github.com/civicrm/civicrm-core/pull/15989))**

  Fixes the LYBUNT charts.

- **allow PCP report to filter on contribution status
  ([16024](https://github.com/civicrm/civicrm-core/pull/16024))**

  The PCP report template lists all personal campaign pages with the total
  number of contributions made against each PCP page and the total amount
  raised. Before this change the report had no filter for Contribution Status,
  so canceled contributions were showing and throwing off the totals.  There is
  now a filter for contribution status allowing users to filter this list as
  they wish.

- **Fix api Payment.create to support overpayments
  ([15909](https://github.com/civicrm/civicrm-core/pull/15909))**

  Payments made to already paid-up contributions no longer result in an error.
  The payment continues to be "Completed" and no related entities are updated.

### CiviEvent

- **Fix Participant Search in force mode to support query parameters in URL
  ([15791](https://github.com/civicrm/civicrm-core/pull/15791) and
  [15807](https://github.com/civicrm/civicrm-core/pull/15807))**

- **Move greeting handling up as it is not paymentValidation dependent
  ([15904](https://github.com/civicrm/civicrm-core/pull/15904))**

  Validation of greetings on the frontend event registration form is no longer
  conditional on processing a payment.

- **Remove nbsp from UserDashboard Event section
  ([15880](https://github.com/civicrm/civicrm-core/pull/15880))**

### CiviMail

- **DB error in Mail Clickthroughs bar chart display
  ([dev/core#1434](https://lab.civicrm.org/dev/core/issues/1434):
  [16000](https://github.com/civicrm/civicrm-core/pull/16000))**

  Fixes the bar chart view on the Mail Clickthroughs report.

- **Unsubscribe broken if mailing sent to previous mailing recipients with an
  excluded group ([dev/core#1108](https://lab.civicrm.org/dev/core/issues/1108):
  [15815](https://github.com/civicrm/civicrm-core/pull/15815))**

### CiviMember

- **Search builder error on Membership source field.
  ([dev/core#1390](https://lab.civicrm.org/dev/core/issues/1390):
  [15845](https://github.com/civicrm/civicrm-core/pull/15845))**

  Fixes an error: "DB error: syntax error" when adding "Membership Source" on
  the search builder screen.

### Drupal Integration

- **Implement drupal_get_user_timezone()
  ([15794](https://github.com/civicrm/civicrm-core/pull/15794))**

  Ensures that the timezone is set using the drupal timezone on Contributions
  made by anonymous users (Drupal 8).

### Joomla Integration

- **New Accessible Menu Color Picker display issue on Joomla
  ([dev/core#874](https://lab.civicrm.org/dev/core/issues/874):
  [15945](https://github.com/civicrm/civicrm-core/pull/15945))**

  Fixes the display of the menubar color picker on Joomla so it looks more like
  the other CMSes.

## <a name="misc"></a>Miscellany

- **Field metadata cleanup: Contact & Activity & Custom
  ([15818](https://github.com/civicrm/civicrm-core/pull/15818))**

- **Create a GitLab general issue template
  ([15665](https://github.com/civicrm/civicrm-core/pull/15665))**

- **Don't pass \$input to completeOrder by reference - return values are never
  used ([15699](https://github.com/civicrm/civicrm-core/pull/15699))**

- **Fix incorrect reference on extracted function
  ([15865](https://github.com/civicrm/civicrm-core/pull/15865))**

- **Add $params type declaration to global API functions.
  ([15852](https://github.com/civicrm/civicrm-core/pull/15852))**

- **Add string type declarations to global API functions.
  ([15864](https://github.com/civicrm/civicrm-core/pull/15864))**

- **Convert fee selection test to use Order api
  ([15812](https://github.com/civicrm/civicrm-core/pull/15812))**

- **Fix CRM_Contribute_BAO_ContributionTest to no longer use unreliable legacy
  set up method ([15905](https://github.com/civicrm/civicrm-core/pull/15905))**

- **Sort CMS Database Table list
  ([15944](https://github.com/civicrm/civicrm-core/pull/15944))**

- **Rename activity search field from status_id to activity_status_id
  ([15947](https://github.com/civicrm/civicrm-core/pull/15947))**

- **CSV Export: Add deprecation warning
  ([15951](https://github.com/civicrm/civicrm-core/pull/15951))**

- **Remove CRM_Contact_Form_Search_Custom_Basic from searches added on install.
  ([15979](https://github.com/civicrm/civicrm-core/pull/15979))**

- **Add import & export metadata to activity.priority_id
  ([15993](https://github.com/civicrm/civicrm-core/pull/15993))**

- **Too many dead people in sample data
  ([dev/core#1329](https://lab.civicrm.org/dev/core/issues/1329):
  [15967](https://github.com/civicrm/civicrm-core/pull/15967))**

- **Update dompdf (0.8.0=>0.8.3) & dependencies
  ([15739](https://github.com/civicrm/civicrm-core/pull/15739))**

- **Upgrade ui-sortable angular library to v0.19.0
  ([15868](https://github.com/civicrm/civicrm-core/pull/15868))**

- **Remove unused parameter
  ([15953](https://github.com/civicrm/civicrm-core/pull/15953))**

- **Remove unused variables in completeOrder()
  ([15841](https://github.com/civicrm/civicrm-core/pull/15841))**

- **Make else statement more legible
  ([15974](https://github.com/civicrm/civicrm-core/pull/15974))**

- **Code style, remove typo, double ;; from code where it makes sense to do so
  ([16001](https://github.com/civicrm/civicrm-core/pull/16001))**

- **Remove obsolete warning
  ([15786](https://github.com/civicrm/civicrm-core/pull/15786))**

- **Remove calls to deprecated pseudoconstant activityType, test
  ([15995](https://github.com/civicrm/civicrm-core/pull/15995))**

- **Remove unused cancelledStatus assign on contributionView
  ([16019](https://github.com/civicrm/civicrm-core/pull/16019))**

- **Remove join to civicrm_option_value in favour of using getLabel funct…
  ([15734](https://github.com/civicrm/civicrm-core/pull/15734))**

- **Remove unused functions
  ([15956](https://github.com/civicrm/civicrm-core/pull/15956))**

- **Remove unused  parameter recur from CompleteOrder signature
  ([15800](https://github.com/civicrm/civicrm-core/pull/15800))**

- **[REF] minor refactor - move handling of 'skipMerge' to the skipMerge
  function ([15828](https://github.com/civicrm/civicrm-core/pull/15828))**

- **[REF] refactor on nasty Dedupe function
  ([15830](https://github.com/civicrm/civicrm-core/pull/15830))**

- **[REF] calculate 'amount' on ContributionPage in a shared way in one scenario
  ([15810](https://github.com/civicrm/civicrm-core/pull/15810))**

- **[REF] XMLProcessor/Report - Extract method to make it more testable
  ([15838](https://github.com/civicrm/civicrm-core/pull/15838))**

- **[REF] very minor tidy up
  ([15756](https://github.com/civicrm/civicrm-core/pull/15756))**

- **[REF] remove another unnecessary pass-by-reference
  ([15902](https://github.com/civicrm/civicrm-core/pull/15902))**

- **[REF] Convert CRM_Core_Error::fatal to CRM_Core_Error::statusBounce i…
  ([15863](https://github.com/civicrm/civicrm-core/pull/15863))**

- **[REF] CSV Export: Remove impossible checks on  var
  ([15954](https://github.com/civicrm/civicrm-core/pull/15954))**

- **[REF] Further cleanup on address handling in merge code.
  ([15950](https://github.com/civicrm/civicrm-core/pull/15950))**

- **[REF] Move CRM_Event_Form_EventFees::buildQuickForm to Participant_Form
  class ([15871](https://github.com/civicrm/civicrm-core/pull/15871))**

- **[REF] Minor simplifcation on initSet
  ([15870](https://github.com/civicrm/civicrm-core/pull/15870))**

- **[REF] remove unused lines of code
  ([15869](https://github.com/civicrm/civicrm-core/pull/15869))**

- **[REF] Standardise the Grant Search form handling
  ([15931](https://github.com/civicrm/civicrm-core/pull/15931))**

- **[REF] further removal of unnecessary  params
  ([15901](https://github.com/civicrm/civicrm-core/pull/15901))**

- **[REF] Remove unused parameter
  ([15960](https://github.com/civicrm/civicrm-core/pull/15960))**

- **[REF] clean up merge array.
  ([15970](https://github.com/civicrm/civicrm-core/pull/15970))**

- **[REF] replace copy & paste with shared getSortID function.
  ([15783](https://github.com/civicrm/civicrm-core/pull/15783))**

- **[REF] return determination of whether to show expired fields to the calling
  function ([15934](https://github.com/civicrm/civicrm-core/pull/15934))**

- **[REF] Minor code cleanup on the setting of contact greetings.
  ([15949](https://github.com/civicrm/civicrm-core/pull/15949))**

- **[REF] Standardise form handling in the Find Pledges search form
  ([15930](https://github.com/civicrm/civicrm-core/pull/15930))**

- **[REF] Add setSearchMetadata to each of the classes that extend
  CRM_Core_Form_Search
  ([15806](https://github.com/civicrm/civicrm-core/pull/15806))**

- **[REF] extract setDeprecatedDefaults
  ([15805](https://github.com/civicrm/civicrm-core/pull/15805))**

- **Add unit test for searching by participant_status_id & switch to generic
  function ([15803](https://github.com/civicrm/civicrm-core/pull/15803))**

- **Add testing for various params that pass through
  Contact_BAO_Query::optionValueQuery
  ([15996](https://github.com/civicrm/civicrm-core/pull/15996))**

- **Fix CRM/Event/BAO/AdditionalPaymentTest.php to use Order.create
  ([15813](https://github.com/civicrm/civicrm-core/pull/15813))**

- **Test fixes - addresses more invalid setup data
  ([15802](https://github.com/civicrm/civicrm-core/pull/15802))**

- **FinancialTrxnTest - Fix unit test to  be 'legit'
  ([15799](https://github.com/civicrm/civicrm-core/pull/15799))**

- **[Test] Remove hard coded it reference
  ([15906](https://github.com/civicrm/civicrm-core/pull/15906))**

- **[Test] fix test setup on ANet tests
  ([15908](https://github.com/civicrm/civicrm-core/pull/15908))**

- **CiviCaseTestCase setup() can make duplicate activity type option values
  (Test for [dev/core#1394](https://lab.civicrm.org/dev/core/issues/1394):
  [15853](https://github.com/civicrm/civicrm-core/pull/15853))**

- **[NFC] Add in unit test of code being altered by #15826
  ([15849](https://github.com/civicrm/civicrm-core/pull/15849))**

- **[NFC] [Test] Minor test cleanup on CiviMailUtils
  ([15907](https://github.com/civicrm/civicrm-core/pull/15907))**

- **(NFC) api_v3_ExtensionTest - Fix when executing on build with 25+ extensions
  ([15892](https://github.com/civicrm/civicrm-core/pull/15892))**

- **[NFC] [Test-only] Remove partially paid from statuses tested for
  RenewContribution
  ([15866](https://github.com/civicrm/civicrm-core/pull/15866))**

- **[NFC] Test fix - incorrect records created due to test set up using
  PartiallyPaid when no payment is made
  ([15854](https://github.com/civicrm/civicrm-core/pull/15854))**

- **[NFC] Update composer lockfile to remove warning
  ([15886](https://github.com/civicrm/civicrm-core/pull/15886))**

- **[NFC] Cleanup comments, string comparison in grant search
  ([15983](https://github.com/civicrm/civicrm-core/pull/15983))**

- **[NFC] cleanup on QueryTest
  ([15994](https://github.com/civicrm/civicrm-core/pull/15994))**

- **[NFC] reformat CiviUnitTestCase.php
  ([15801](https://github.com/civicrm/civicrm-core/pull/15801))**

- **[NFC] Reformat Contact_Form_Search_Advanced
  ([15777](https://github.com/civicrm/civicrm-core/pull/15777))**

- **[NFC] comment fixes - exceptions & don't declare NULL
  ([15776](https://github.com/civicrm/civicrm-core/pull/15776))**

- **[NFC] Update copyright date for 2020
  ([586](https://github.com/civicrm/civicrm-drupal/pull/586))**

- **Remove copyright & years from all code, except LICENSE.md etc
  ([dev/core#878](https://lab.civicrm.org/dev/core/issues/878):
  [588](https://github.com/civicrm/civicrm-drupal/pull/588),
  [169](https://github.com/civicrm/civicrm-wordpress/pull/169),
  [15843](https://github.com/civicrm/civicrm-core/pull/15843),
  [587](https://github.com/civicrm/civicrm-drupal/pull/587) and
  [104](https://github.com/civicrm/civicrm-backdrop/pull/104))**

- **[NFC] Update copyright date for 2020
  ([585](https://github.com/civicrm/civicrm-drupal/pull/585))**

- **[NFC] Update copyright date for 2020
  ([270](https://github.com/civicrm/civicrm-packages/pull/270))**

- **[NFC] Remove dinosaur function
  ([16010](https://github.com/civicrm/civicrm-core/pull/16010))**

- **[NFC] code cleanup in test class.
  ([16026](https://github.com/civicrm/civicrm-core/pull/16026))**

- **Membership and Event Related Contributions - shows all contributions (Clean
  up for [dev/core#1435](https://lab.civicrm.org/dev/core/issues/1435):
  [16023](https://github.com/civicrm/civicrm-core/pull/16023))**

- **[NFC] Remove unused variable not used since v4.4
  ([15835](https://github.com/civicrm/civicrm-core/pull/15835))**

- **(NFC) PULL_REQUEST_TEMPLATE.md - Improve suggestions for
  under-the-hood/non-UI changes
  ([15837](https://github.com/civicrm/civicrm-core/pull/15837))**

- **Duplicate custom field blocks on open case (Add Code Comments for
  [dev/core#1352](https://lab.civicrm.org/dev/core/issues/1352):
  [15851](https://github.com/civicrm/civicrm-core/pull/15851))**

- **[NFC] minimal test for Mailing.update_email_resetdate
  ([15832](https://github.com/civicrm/civicrm-core/pull/15832))**

- **[NFC] declare thrown exceptions
  ([15809](https://github.com/civicrm/civicrm-core/pull/15809))**

- **[NFC] fix test to correctly set up partially paid contribution
  ([15867](https://github.com/civicrm/civicrm-core/pull/15867))**

- **[NFC] Update copyright date for 2020
  ([167](https://github.com/civicrm/civicrm-wordpress/pull/167))**

- **[NFC] Update copyright date for 2020
  ([54](https://github.com/civicrm/civicrm-joomla/pull/54))**

- **[NFC] Update copyright date for 2020
  ([15755](https://github.com/civicrm/civicrm-core/pull/15755))**

- **Update copyright date for 2020
  ([102](https://github.com/civicrm/civicrm-backdrop/pull/102))**

- **add contributor name
  ([15758](https://github.com/civicrm/civicrm-core/pull/15758))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andrew Hunt; Agileware - Justin Freeman; Australian Greens -
Seamus Lee; Christian Wach; CiviCRM - Coleman Watts, Tim Otten; CiviDesk -
Yashodha Chaku; CompuCorp - Camilo Rodriguez; Coop SymbioTIC - Mathieu Lutfy;
Dave D; Electronic Frontier Foundation - Mark Burdett; Fuzion - Jitendra
Purohit; Greenpeace CEE - Patrick Figel; Jamie Tillman; Jens Schuppe; JMA
Consulting - Monish Deb; Joost Fock; Megaphone Technology Consulting - Jon
Goldberg; MJCO - Mikey O'Toole; MJW Consulting - Matthew Wire; Progressive
Technology Project - Jamie McClelland; Richard van Oosterhout; Semper IT - Karin
Gerritsen; Squiffle Consulting - Aidan Saunders; Tadpole Collective - Kevin
Cristiano; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Alice Frumin; Artful Robot - Rich Lott; Chris Burgess; Circle
Interactive - Dave Jenkins; John Kingsnorth; Freeform Solutions - Lola Slade;
OSSeed Technologies LLP - Revati Gawas

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
