(require "asdf")

(let ((tmpdir (uiop:getenv "AUTOPKGTEST_TMP")))
  ;; Store FASL in some temporary dir
  (asdf:clear-output-translations)
  (setq asdf:*user-cache* (uiop:getenv "AUTOPKGTEST_TMP"))
  (asdf:initialize-output-translations)

  ;; rt-test.lisp asks for a temporary filename on *standard-input*
  (with-input-from-string (*standard-input* (format nil "\"~A/tmpfile\"" tmpdir))
    (load #p"/usr/share/common-lisp/source/rt/rt-test.lisp")))

(or (do-tests)
    (error "Testsuite failed"))
