/// <reference types="react" />
export declare enum EmptyStateVariant {
    'xs' = "xs",
    sm = "sm",
    lg = "lg",
    'xl' = "xl",
    full = "full"
}
export declare enum EmptyStateStatus {
    danger = "danger",
    warning = "warning",
    success = "success",
    info = "info",
    custom = "custom"
}
export interface EmptyStateProps extends React.HTMLProps<HTMLDivElement> {
    /** Additional classes added to the empty state */
    className?: string;
    /** Content rendered inside the empty state */
    children?: React.ReactNode;
    /** Modifies empty state max-width and sizes of icon, title and body */
    variant?: 'xs' | 'sm' | 'lg' | 'xl' | 'full';
    /** Cause component to consume the available height of its container */
    isFullHeight?: boolean;
    /** Status of the empty state, will set a default status icon and color. Icon can be overwritten using the icon prop */
    status?: 'danger' | 'warning' | 'success' | 'info' | 'custom';
    /** Additional class names to apply to the empty state header */
    headerClassName?: string;
    /** Additional classes added to the title inside empty state header */
    titleClassName?: string;
    /** Text of the title inside empty state header, will be wrapped in headingLevel */
    titleText?: React.ReactNode;
    /** Empty state icon element to be rendered. Can also be a spinner component */
    icon?: React.ComponentType<any>;
    /** The heading level to use, default is h1 */
    headingLevel?: 'h1' | 'h2' | 'h3' | 'h4' | 'h5' | 'h6';
}
export declare const EmptyState: React.FunctionComponent<EmptyStateProps>;
//# sourceMappingURL=EmptyState.d.ts.map