!{\src2tex{textfont=tt}}
!!****m* etsf_dims/etsf_io_dims_def
!! NAME
!!  etsf_io_dims_def
!!
!! FUNCTION
!!    Create dimensions and set their values. For normal dimensions, their are defined
!!    if their values are different from etsf_no_dimension (see ETSF_IO_CONSTANTS).
!!    For split dimensions (my_<something>), they are defined only if they are
!!    different from etsf_no_dimension or from the value of dimension <something>.
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * ncid = 
!!     integer returned by an 'open' NetCDF call. The file can be 
!!     either in define or write mode. This status can be changed
!!     by the call.
!! * dims <type(etsf_dims)> = 
!!     contains all the dimensions required by the ETSF file. These values
!!     will be used later to allocate the disk space for variables, see
!!     etsf_io_electrons_def() or routines of the same kind.
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_dims_def(ncid, dims, lstat, error_data)

  !Arguments ------------------------------------
  integer, intent(in) :: ncid
  type(etsf_dims), intent(in) :: dims
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_dims_def'


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_dims_def : enter'
!ENDDEBUG

  if (dims%character_string_length /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "character_string_length", &
                             & dims%character_string_length, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%complex /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "complex", &
                             & dims%complex, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%max_number_of_angular_momenta /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "max_number_of_angular_momenta", &
                             & dims%max_number_of_angular_momenta, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%max_number_of_basis_grid_points /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "max_number_of_basis_grid_points", &
                             & dims%max_number_of_basis_grid_points, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%max_number_of_coefficients /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "max_number_of_coefficients", &
                             & dims%max_number_of_coefficients, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%max_number_of_projectors /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "max_number_of_projectors", &
                             & dims%max_number_of_projectors, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%max_number_of_states /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "max_number_of_states", &
                             & dims%max_number_of_states, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_atoms /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_atoms", &
                             & dims%number_of_atoms, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_atom_species /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_atom_species", &
                             & dims%number_of_atom_species, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_cartesian_directions /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_cartesian_directions", &
                             & dims%number_of_cartesian_directions, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_coefficients_dielectric_function /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_coefficients_dielectric_function", &
                             & dims%number_of_coefficients_dielectric_function, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_components /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_components", &
                             & dims%number_of_components, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_frequencies_dielectric_function /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_frequencies_dielectric_function", &
                             & dims%number_of_frequencies_dielectric_function, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_grid_points_vector1 /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_grid_points_vector1", &
                             & dims%number_of_grid_points_vector1, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_grid_points_vector2 /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_grid_points_vector2", &
                             & dims%number_of_grid_points_vector2, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_grid_points_vector3 /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_grid_points_vector3", &
                             & dims%number_of_grid_points_vector3, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_kpoints /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_kpoints", &
                             & dims%number_of_kpoints, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_localization_regions /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_localization_regions", &
                             & dims%number_of_localization_regions, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_qpoints_dielectric_function /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_qpoints_dielectric_function", &
                             & dims%number_of_qpoints_dielectric_function, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_qpoints_gamma_limit /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_qpoints_gamma_limit", &
                             & dims%number_of_qpoints_gamma_limit, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_reduced_dimensions /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_reduced_dimensions", &
                             & dims%number_of_reduced_dimensions, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_spinor_components /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_spinor_components", &
                             & dims%number_of_spinor_components, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_spins /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_spins", &
                             & dims%number_of_spins, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_symmetry_operations /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_symmetry_operations", &
                             & dims%number_of_symmetry_operations, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%number_of_vectors /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "number_of_vectors", &
                             & dims%number_of_vectors, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%real_or_complex_coefficients /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "real_or_complex_coefficients", &
                             & dims%real_or_complex_coefficients, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%real_or_complex_density /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "real_or_complex_density", &
                             & dims%real_or_complex_density, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%real_or_complex_gw_corrections /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "real_or_complex_gw_corrections", &
                             & dims%real_or_complex_gw_corrections, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%real_or_complex_potential /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "real_or_complex_potential", &
                             & dims%real_or_complex_potential, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%real_or_complex_wavefunctions /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "real_or_complex_wavefunctions", &
                             & dims%real_or_complex_wavefunctions, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%symbol_length /= etsf_no_dimension) then
    call etsf_io_low_write_dim(ncid, "symbol_length", &
                             & dims%symbol_length, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%my_max_number_of_coefficients /= etsf_no_dimension .and. &
      dims%my_max_number_of_coefficients /= dims%max_number_of_coefficients) then
    call etsf_io_low_write_dim(ncid, "my_max_number_of_coefficients", &
                             & dims%my_max_number_of_coefficients, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%my_max_number_of_states /= etsf_no_dimension .and. &
      dims%my_max_number_of_states /= dims%max_number_of_states) then
    call etsf_io_low_write_dim(ncid, "my_max_number_of_states", &
                             & dims%my_max_number_of_states, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%my_number_of_components /= etsf_no_dimension .and. &
      dims%my_number_of_components /= dims%number_of_components) then
    call etsf_io_low_write_dim(ncid, "my_number_of_components", &
                             & dims%my_number_of_components, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%my_number_of_grid_points_vect1 /= etsf_no_dimension .and. &
      dims%my_number_of_grid_points_vect1 /= dims%number_of_grid_points_vector1) then
    call etsf_io_low_write_dim(ncid, "my_number_of_grid_points_vector1", &
                             & dims%my_number_of_grid_points_vect1, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%my_number_of_grid_points_vect2 /= etsf_no_dimension .and. &
      dims%my_number_of_grid_points_vect2 /= dims%number_of_grid_points_vector2) then
    call etsf_io_low_write_dim(ncid, "my_number_of_grid_points_vector2", &
                             & dims%my_number_of_grid_points_vect2, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%my_number_of_grid_points_vect3 /= etsf_no_dimension .and. &
      dims%my_number_of_grid_points_vect3 /= dims%number_of_grid_points_vector3) then
    call etsf_io_low_write_dim(ncid, "my_number_of_grid_points_vector3", &
                             & dims%my_number_of_grid_points_vect3, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%my_number_of_kpoints /= etsf_no_dimension .and. &
      dims%my_number_of_kpoints /= dims%number_of_kpoints) then
    call etsf_io_low_write_dim(ncid, "my_number_of_kpoints", &
                             & dims%my_number_of_kpoints, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (dims%my_number_of_spins /= etsf_no_dimension .and. &
      dims%my_number_of_spins /= dims%number_of_spins) then
    call etsf_io_low_write_dim(ncid, "my_number_of_spins", &
                             & dims%my_number_of_spins, &
                             & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  lstat = .true.


!DEBUG
!write (*,*) 'etsf_io_dims_def : exit'
!ENDDEBUG

end subroutine etsf_io_dims_def
!!***
