/************************************************************************/
/*                                                                      */
/*                 Copyright 2011 by Ullrich Koethe                     */
/*                                                                      */
/*    This file is part of the VIGRA computer vision library.           */
/*    The VIGRA Website is                                              */
/*        http://hci.iwr.uni-heidelberg.de/vigra/                       */
/*    Please direct questions, bug reports, and contributions to        */
/*        ullrich.koethe@iwr.uni-heidelberg.de    or                    */
/*        vigra@informatik.uni-hamburg.de                               */
/*                                                                      */
/*    Permission is hereby granted, free of charge, to any person       */
/*    obtaining a copy of this software and associated documentation    */
/*    files (the "Software"), to deal in the Software without           */
/*    restriction, including without limitation the rights to use,      */
/*    copy, modify, merge, publish, distribute, sublicense, and/or      */
/*    sell copies of the Software, and to permit persons to whom the    */
/*    Software is furnished to do so, subject to the following          */
/*    conditions:                                                       */
/*                                                                      */
/*    The above copyright notice and this permission notice shall be    */
/*    included in all copies or substantial portions of the             */
/*    Software.                                                         */
/*                                                                      */
/*    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND    */
/*    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES   */
/*    OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND          */
/*    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT       */
/*    HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,      */
/*    WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING      */
/*    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR     */
/*    OTHER DEALINGS IN THE SOFTWARE.                                   */
/*                                                                      */
/************************************************************************/

#define PY_ARRAY_UNIQUE_SYMBOL vigranumpygraphs_PyArray_API
#define NO_IMPORT_ARRAY



#include "export_graph_visitor.hxx"
#include "export_graph_rag_visitor.hxx"
#include "export_graph_algorithm_visitor.hxx"
#include "export_graph_shortest_path_visitor.hxx"
#include "export_graph_hierarchical_clustering_visitor.hxx"

#include <vigra/numpy_array.hxx>
#include <vigra/numpy_array_converters.hxx>
#include <vigra/adjacency_list_graph.hxx>
#include <vigra/python_graph.hxx>
namespace python = boost::python;

namespace vigra{



    NumpyAnyArray pySerializeAdjacencyListGraph(
        const AdjacencyListGraph & graph,
        NumpyArray<1, UInt32> serialization
    ){
        serialization.reshapeIfEmpty( NumpyArray<1, UInt32>::difference_type(graph.serializationSize()));
        graph.serialize(serialization.begin());
        return serialization;
    }


    void pyDeserializeAdjacencyListGraph(
        AdjacencyListGraph & graph,
        const NumpyArray<1, UInt32> & serialization
    ){
        graph.clear();
        graph.deserialize(serialization.begin(),serialization.end());
    }


    void defineAdjacencyListGraph(){

        typedef AdjacencyListGraph  Graph;
        // define graph itself
        const std::string clsName = "AdjacencyListGraph";
        python::class_<Graph>(clsName.c_str(),"undirected adjacency list graph",
            python::init< const size_t,const size_t >( )
        )
        .def(LemonUndirectedGraphCoreVisitor<Graph>(clsName))
        .def(LemonUndirectedGraphAddItemsVisitor<Graph>(clsName))
        .def(LemonGraphAlgorithmVisitor<Graph>(clsName))
        .def(LemonGraphShortestPathVisitor<Graph>(clsName))
        .def(LemonGraphRagVisitor<Graph>(clsName))
        .def(LemonGraphHierachicalClusteringVisitor<Graph>(clsName))

        // serialization helper
        .def("serializationSize",&Graph::serializationSize, "number of integers needed to serialize graph")
        .def("serialize",registerConverters(&pySerializeAdjacencyListGraph),
            (
                python::arg("serialization")=python::object()
            )
        )
        .def("deserialize",registerConverters(&pyDeserializeAdjacencyListGraph) )
        ;
    }
}


