package ram

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPublicKeys invokes the ram.ListPublicKeys API synchronously
// api document: https://help.aliyun.com/api/ram/listpublickeys.html
func (client *Client) ListPublicKeys(request *ListPublicKeysRequest) (response *ListPublicKeysResponse, err error) {
	response = CreateListPublicKeysResponse()
	err = client.DoAction(request, response)
	return
}

// ListPublicKeysWithChan invokes the ram.ListPublicKeys API asynchronously
// api document: https://help.aliyun.com/api/ram/listpublickeys.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPublicKeysWithChan(request *ListPublicKeysRequest) (<-chan *ListPublicKeysResponse, <-chan error) {
	responseChan := make(chan *ListPublicKeysResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPublicKeys(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPublicKeysWithCallback invokes the ram.ListPublicKeys API asynchronously
// api document: https://help.aliyun.com/api/ram/listpublickeys.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPublicKeysWithCallback(request *ListPublicKeysRequest, callback func(response *ListPublicKeysResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPublicKeysResponse
		var err error
		defer close(result)
		response, err = client.ListPublicKeys(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPublicKeysRequest is the request struct for api ListPublicKeys
type ListPublicKeysRequest struct {
	*requests.RpcRequest
	UserName string `position:"Query" name:"UserName"`
}

// ListPublicKeysResponse is the response struct for api ListPublicKeys
type ListPublicKeysResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	PublicKeys PublicKeys `json:"PublicKeys" xml:"PublicKeys"`
}

// CreateListPublicKeysRequest creates a request to invoke ListPublicKeys API
func CreateListPublicKeysRequest() (request *ListPublicKeysRequest) {
	request = &ListPublicKeysRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ram", "2015-05-01", "ListPublicKeys", "ram", "openAPI")
	return
}

// CreateListPublicKeysResponse creates a response to parse from ListPublicKeys response
func CreateListPublicKeysResponse() (response *ListPublicKeysResponse) {
	response = &ListPublicKeysResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
