// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef AVTMATERIALMETADATA_H
#define AVTMATERIALMETADATA_H
#include <dbatts_exports.h>
#include <string>
#include <avtBaseVarMetaData.h>


// ****************************************************************************
// Class: avtMaterialMetaData
//
// Purpose:
//    Contains material metadata attributes
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class DBATTS_API avtMaterialMetaData : public avtBaseVarMetaData
{
public:
    // These constructors are for objects of this class
    avtMaterialMetaData();
    avtMaterialMetaData(const avtMaterialMetaData &obj);
protected:
    // These constructors are for objects derived from this class
    avtMaterialMetaData(private_tmfs_t tmfs);
    avtMaterialMetaData(const avtMaterialMetaData &obj, private_tmfs_t tmfs);
public:
    virtual ~avtMaterialMetaData();

    virtual avtMaterialMetaData& operator = (const avtMaterialMetaData &obj);
    virtual bool operator == (const avtMaterialMetaData &obj) const;
    virtual bool operator != (const avtMaterialMetaData &obj) const;
private:
    void Init();
    void Copy(const avtMaterialMetaData &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    avtMaterialMetaData(const std::string &, const std::string &, int, const stringVector &);
    avtMaterialMetaData(const std::string &, const std::string &, int, const stringVector &, const stringVector &);
    avtMaterialMetaData(const std::string &, const std::string &, int);
    void Print(ostream &, int = 0) const;

    // IDs that can be used to identify fields in case statements
    enum {
        ID_numMaterials = avtBaseVarMetaData::ID__LAST,
        ID_materialNames,
        ID_colorNames,
        ID__LAST
    };

public:
    int          numMaterials;
    stringVector materialNames;
    stringVector colorNames;

private:
    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define AVTMATERIALMETADATA_TMFS AVTBASEVARMETADATA_TMFS "is*s*"

#endif
