/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class FtileForkInnerOverlapped
extends AbstractFtile {
    private final List<Ftile> forks = new ArrayList<Ftile>();

    public FtileForkInnerOverlapped(List<Ftile> forks) {
        super(forks.get(0).skinParam());
        for (Ftile ftile : forks) {
            this.forks.add(ftile);
        }
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.forks.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return FtileForkInnerOverlapped.mergeSwimlanes(this.forks);
    }

    public static Set<Swimlane> mergeSwimlanes(List<Ftile> tiles) {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        for (Ftile tile : tiles) {
            result.addAll(tile.getSwimlanes());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public void drawU(UGraphic ug) {
        double xpos = 0.0;
        for (Ftile ftile : this.forks) {
            ug.apply(UTranslate.dx(0.0)).draw(ftile);
        }
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        double height = 0.0;
        double width = 0.0;
        for (Ftile ftile : this.forks) {
            FtileGeometry dim = ftile.calculateDimension(stringBounder);
            width = Math.max(width, ((Dimension2D)dim).getWidth());
            if (!(((Dimension2D)dim).getHeight() > height)) continue;
            height = ((Dimension2D)dim).getHeight();
        }
        Dimension2DDouble dimTotal = new Dimension2DDouble(width, height);
        return new FtileGeometry(dimTotal, ((Dimension2D)dimTotal).getWidth() / 2.0, 0.0, ((Dimension2D)dimTotal).getHeight());
    }

    @Override
    public UTranslate getTranslateFor(Ftile searched, StringBounder stringBounder) {
        double xpos = 0.0;
        for (Ftile ftile : this.forks) {
            if (ftile != searched) continue;
            return UTranslate.dx(0.0);
        }
        throw new IllegalArgumentException();
    }
}

