# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"


class MatchedBlockName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents the condition block name that matched blob properties."""

    IF = "If"
    ELSE = "Else"
    NONE = "None"
    IF_ENUM = "If"
    ELSE_ENUM = "Else"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents the provisioning state of the storage task."""

    VALIDATE_SUBSCRIPTION_QUOTA_BEGIN = "ValidateSubscriptionQuotaBegin"
    VALIDATE_SUBSCRIPTION_QUOTA_END = "ValidateSubscriptionQuotaEnd"
    ACCEPTED = "Accepted"
    CREATING = "Creating"
    SUCCEEDED = "Succeeded"
    DELETING = "Deleting"
    CANCELED = "Canceled"
    FAILED = "Failed"


class RunResult(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents the overall result of the execution for the run instance."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"


class RunStatusEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents the status of the execution."""

    IN_PROGRESS = "InProgress"
    FINISHED = "Finished"


class StorageTaskOperationName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operation to be performed on the object."""

    SET_BLOB_TIER = "SetBlobTier"
    SET_BLOB_TAGS = "SetBlobTags"
    SET_BLOB_IMMUTABILITY_POLICY = "SetBlobImmutabilityPolicy"
    SET_BLOB_LEGAL_HOLD = "SetBlobLegalHold"
    SET_BLOB_EXPIRY = "SetBlobExpiry"
    DELETE_BLOB = "DeleteBlob"
    UNDELETE_BLOB = "UndeleteBlob"
