/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 2001-2009, William Chia-Wei Cheng.
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Trolltech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/tidget.h,v 1.6 2011/05/16 16:22:00 william Exp $
 */

#ifndef _TIDGET_H_
#define _TIDGET_H_

#include "list.e"

#define TIDGET_TYPE_BASE  0
#define TIDGET_TYPE_LIST  1
#define TIDGET_TYPE_BTN   2
#define TIDGET_TYPE_EDIT  3
#define TIDGET_TYPE_DRAW  4
#define TIDGET_TYPE_MSG   5
#define TIDGET_TYPE_BROW  6
#define TIDGET_TYPE_BMPL  7
#define TIDGET_TYPE_SEDT  8

/* --------------------- Notifications --------------------- */

/*
 * TDGTNF_* are tidget notifications generated by a control.
 * nf_type is one of TDGTNF_*.
 * nf_arg and nf_arg2 are arguments to the notification event.
 */
#define TDGTNF_NO_NOTIFY 0

/* list control events */
#define TDGTNF_LIST_CLICKED 10 /* nf_arg is the item index,
		nf_arg2 is which mouse button was used when clicking */
#define TDGTNF_LIST_DBL_CLICKED 11 /* nf_arg is the item index */

/* button control events */
#define TDGTNF_BTN_CLICKED 20 /* nf_arg is 0 */
#define TDGTNF_MULTI_BTN_CLICKED 21 /* nf_arg is Button[1-3],
		nf_arg2 is color_index */

/* edit control events */
#define TDGTNF_EDIT_ENTERED 30 /* nf_arg is 0 */

/* --------------------- Commands --------------------- */

/*
 * TDGTCMD_* are tidget commands that can be send to a control.
 * cmd_type is one of TDGTCMD_*.
 * cmd_arg is an argument to the command.
 */
#define TDGTCMD_NO_CMD 200

/* bitmap list control commands */
#define TDGTCMD_LIST_RESETCONTENT 210 /* cmd_arg is 0 */
#define TDGTCMD_LIST_SEL_NEXT     211 /* cmd_arg is one of TDGTARG_MOVE_* */
#define     TDGTARG_MOVE_UP    0
#define     TDGTARG_MOVE_DOWN  1
#define     TDGTARG_MOVE_RIGHT 2
#define     TDGTARG_MOVE_LEFT  3
#define TDGTCMD_LIST_GETCURSEL    212 /* get marked_index,
		pv_cmd_userdata is of type (int*) */
#define TDGTCMD_LIST_GETITEM      213 /* cmd_arg is an index,
		if tidget is TdgtBmpList, pv_cmd_userdata is of type
		(BmpListItemInfo**), if tidget is TdgtList, pv_cmd_userdata
		is of type (ListItemInfo**) */

/* draw control commands */
#define TDGTCMD_DRAW_USER 240 /* cmd_arg is user defined */

/* --------------------- Structures --------------------- */

struct tagTidgetInfo;

typedef void (TidgetRedrawCallbackFunc)ARGS_DECL((struct tagTidgetInfo *));
typedef int (TidgetEvHandlerCallbackFunc)ARGS_DECL((struct tagTidgetInfo *,
		XEvent*, struct tagTidgetInfo *));
typedef int (TidgetIsEventCallbackFunc)ARGS_DECL((struct tagTidgetInfo *,
		XEvent*, struct tagTidgetInfo **));
typedef void (TidgetDestroyCallbackFunc)ARGS_DECL((struct tagTidgetInfo *));
typedef void (TidgetMapCallbackFunc)ARGS_DECL((struct tagTidgetInfo *));
typedef void (TidgetMoveResizeCallbackFunc)ARGS_DECL((struct tagTidgetInfo *,
		int x, int y, int w, int h));
typedef int (TidgetSendCmdCallbackFunc)ARGS_DECL((struct tagTidgetInfo *,
		int cmd_type, int cmd_arg, void *pv_cmd_userdata));

typedef struct tagTidgetCommonInfo {
   /*
    * If parent_tidgetinfo is NULL, the parent is not a tidget (just some sort
    *         of a window -- for an example, see "chat.c" and "tgtwb5dl.c").
    * The parent window is stored in parent_win.
    */
   struct tagTidgetInfo *parent_tidgetinfo;
   Window parent_win;
 
   Window win;
   SimpleWinInfo win_info;
 
   int state; /* TGBS_NORMAL, TGBS_GRAYED, TGBS_RAISED, or TGBS_LOWRED */
   int mapped;
   int redraw_disabled;
   int dirty; /* to be used with redraw_disabled */
 
   int h_pad, v_pad; /* horizontal and vertical padding */

   /*
    * content_w is usually win_info.w-(windowPadding<<1)-(h_pad<<1)
    * content_h is usually win_info.h-(windowPadding<<1)-(v_pad<<1)
    */
   int content_w, content_h;

   struct DynStrRec dyn_str; /* caption, msg, btn name, etc. */

   int ctl_id; /* so that objects can be named */

   int can_have_children; /* TRUE if a tidget can have child tidgets */
   CVList clist; /* list of (TIdgetInfo*) which are children tidgets */

   /* call back functions */
   TidgetRedrawCallbackFunc *pf_redraw_callback;
   TidgetEvHandlerCallbackFunc *pf_ev_handler_callback;
   TidgetIsEventCallbackFunc *pf_is_event_callback;
   TidgetDestroyCallbackFunc *pf_destroy_callback;
   TidgetMapCallbackFunc *pf_map_callback;
   TidgetMoveResizeCallbackFunc *pf_moveresize_callback;
   TidgetSendCmdCallbackFunc *pf_sendcmd_callback;
} TidgetCommonInfo;

typedef struct tagTidgetInfo {
   /*
    * type is one of TIDGET_TYPE_*
    * It is used to typecast the tidget field below to one of the
    *         known types.
    */
   int type;
   void *tidget; /* points to the actual tidget */

   TidgetCommonInfo tci;

   /* additional userdata */
   void *userdata;
} TidgetInfo;

typedef struct tagTdgtCmd {
   int cmd_type;
   int cmd_arg;
   void *cmd_userdata;
} TdgtCmd;

typedef struct tagTdgtNtfy {
   int ctl_id;
   int nf_type;
   int nf_arg;
   int nf_arg2;
} TdgtNtfy;

#endif /*_TIDGET_H_*/
