// This file has been auto-generated by the ontology2code script.
// Do not modify it directly.

/* ontology.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Seif Lotfy <seif@lotfy.com>
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/**
 * Get information about interpretation/manifestation symbols
 */

namespace Zeitgeist
{

    namespace Symbol
    {
        private static HashTable<string, Info> all_symbols = null;
        private static bool initialized = false;

        public static unowned string get_display_name (string symbol_uri)
        {
            initialize_symbols ();

            var symbol = all_symbols.lookup (symbol_uri);
            if (symbol == null) return symbol_uri;

            return symbol.display_name;
        }

        public static unowned string get_description (string symbol_uri)
        {
            initialize_symbols ();

            var symbol = all_symbols.lookup (symbol_uri);
            if (symbol == null) return "";

            return symbol.description;
        }

        public static List<unowned string> get_all_parents (string symbol_uri)
        {
            initialize_symbols ();

            var results = new List<unowned string> ();
            var symbol = all_symbols.lookup (symbol_uri);
            if (symbol == null) return results;

            foreach (unowned string uri in symbol.parents)
            {
                results.append (uri);
                // Recursively get the other parents
                foreach (unowned string parent_uri in get_all_parents (uri))
                    if (results.index (parent_uri) == -1)
                        results.append (parent_uri);
            }

            return results;
        }

        public static List<unowned string> get_all_children (string symbol_uri)
        {
            initialize_symbols ();

            var results = new List<unowned string> ();
            var symbol = all_symbols.lookup (symbol_uri);
            if (symbol == null) return results;

            foreach (unowned string uri in symbol.all_children)
                results.append (uri);

            return results;
        }

        public static List<unowned string> get_children (string symbol_uri)
        {
            initialize_symbols ();
            var results = new List<unowned string> ();
            var symbol = all_symbols.lookup (symbol_uri);
            if (symbol == null) return results;

            foreach (unowned string uri in symbol.children)
                results.append(uri);

            return results;
        }

        public static List<unowned string> get_parents (string symbol_uri)
        {
            initialize_symbols ();

            var results = new List<unowned string>();
            var symbol = all_symbols.lookup (symbol_uri);
            if (symbol == null) return results;

            foreach (unowned string uri in symbol.parents)
                results.append (uri);

            return results;
        }

        public static bool is_a (string? symbol_uri, string? parent_uri)
        {
            if (parent_uri == null || symbol_uri == null) return false;
            initialize_symbols ();

            var symbol = all_symbols.lookup (symbol_uri);
            if (symbol == null) return false;
            if (parent_uri == symbol_uri) return true;

            foreach (unowned string uri in get_all_parents (symbol_uri))
                if (parent_uri == uri)
                    return true;
            return false;
        }

        private static void initialize_symbols ()
        {
            if (initialized) return;
            initialized = true;
            string uri, display_name, description;
            string[] parents, children, all_children;

            uri = Zeitgeist.NCAL.ALARM;
            description = "Provide a grouping of component properties that define an alarm.";
            display_name = "Alarm";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NCAL.ATTACHMENT;
            description = "An object attached to a calendar entity. This class has been introduced to serve as a structured value of the ncal:attach property. See the documentation of ncal:attach for details.";
            display_name = "Attachment";
            parents = { NFO.ATTACHMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NCAL.CALENDAR;
            description = "A calendar. Inspirations for this class can be traced to the VCALENDAR component defined in RFC 2445 sec. 4.4, but it may just as well be used to represent any kind of Calendar.";
            display_name = "Calendar";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NCAL.CALENDAR_DATA_OBJECT;
            description = "A DataObject found in a calendar. It is usually interpreted as one of the calendar entity types (e.g. Event, Journal, Todo etc.)";
            display_name = "CalendarDataObject";
            parents = { NIE.DATA_OBJECT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NCAL.EVENT;
            description = "Provide a grouping of component properties that describe an event.";
            display_name = "Event";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NCAL.FREEBUSY;
            description = "Provide a grouping of component properties that describe either a request for free/busy time, describe a response to a request for free/busy time or describe a published set of busy time.";
            display_name = "Freebusy";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NCAL.JOURNAL;
            description = "Provide a grouping of component properties that describe a journal entry.";
            display_name = "Journal";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NCAL.TIMEZONE;
            description = "Provide a grouping of component properties that defines a time zone.";
            display_name = "Timezone";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NCAL.TODO;
            description = "Provide a grouping of calendar properties that describe a to-do.";
            display_name = "Todo";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NCO.CONTACT;
            description = "A Contact. A piece of data that can provide means to identify or communicate with an entity.";
            display_name = "Contact";
            parents = { NIE.INFORMATION_ELEMENT };
            children = { NCO.ORGANIZATION_CONTACT, NCO.PERSON_CONTACT };
            all_children = { NCO.ORGANIZATION_CONTACT, NCO.PERSON_CONTACT };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NCO.CONTACT_GROUP;
            description = "A group of Contacts. Could be used to express a group in an addressbook or on a contact list of an IM application. One contact can belong to many groups.";
            display_name = "ContactGroup";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NCO.CONTACT_LIST;
            description = "A contact list, this class represents an addressbook or a contact list of an IM application. Contacts inside a contact list can belong to contact groups.";
            display_name = "ContactList";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NCO.CONTACT_LIST_DATA_OBJECT;
            description = "An entity occuring on a contact list (usually interpreted as an nco:Contact)";
            display_name = "ContactListDataObject";
            parents = { NIE.DATA_OBJECT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NCO.ORGANIZATION_CONTACT;
            description = "A Contact that denotes on Organization.";
            display_name = "OrganizationContact";
            parents = { NCO.CONTACT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NCO.PERSON_CONTACT;
            description = "A Contact that denotes a Person. A person can have multiple Affiliations.";
            display_name = "PersonContact";
            parents = { NCO.CONTACT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.APPLICATION;
            description = "An application";
            display_name = "Application";
            parents = { NFO.SOFTWARE };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.ARCHIVE;
            description = "A compressed file. May contain other files or folder inside.";
            display_name = "Archive";
            parents = { NFO.DATA_CONTAINER };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.ARCHIVE_ITEM;
            description = "A file entity inside an archive.";
            display_name = "ArchiveItem";
            parents = { NFO.EMBEDDED_FILE_DATA_OBJECT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.ATTACHMENT;
            description = "A file attached to another data object. Many data formats allow for attachments: emails, vcards, ical events, id3 and exif...";
            display_name = "Attachment";
            parents = { NFO.EMBEDDED_FILE_DATA_OBJECT };
            children = { NCAL.ATTACHMENT };
            all_children = { NCAL.ATTACHMENT };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.AUDIO;
            description = "A file containing audio content";
            display_name = "Audio";
            parents = { NFO.MEDIA };
            children = { NMM.MUSIC_PIECE };
            all_children = { NMM.MUSIC_PIECE };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.BOOKMARK;
            description = "A bookmark of a webbrowser. Use nie:title for the name/label, nie:contentCreated to represent the date when the user added the bookmark, and nie:contentLastModified for modifications. nfo:bookmarks to store the link.";
            display_name = "Bookmark";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.BOOKMARK_FOLDER;
            description = "A folder with bookmarks of a webbrowser. Use nfo:containsBookmark to relate Bookmarks. Folders can contain subfolders, use containsBookmarkFolder to relate them.";
            display_name = "Bookmark Folder";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.CURSOR;
            description = "A Cursor.";
            display_name = "Cursor";
            parents = { NFO.RASTER_IMAGE };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.DATA_CONTAINER;
            description = "A superclass for all entities, whose primary purpose is to serve as containers for other data object. They usually don't have any \"meaning\" by themselves. Examples include folders, archives and optical disc images.";
            display_name = "DataContainer";
            parents = { NIE.INFORMATION_ELEMENT };
            children = { NFO.ARCHIVE, NFO.FOLDER, NFO.TRASH, NFO.FILESYSTEM };
            all_children = { NFO.FILESYSTEM_IMAGE, NFO.ARCHIVE, NFO.FOLDER, NFO.TRASH, NFO.FILESYSTEM };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.DELETED_RESOURCE;
            description = "A file entity that has been deleted from the original source. Usually such entities are stored within various kinds of 'Trash' or 'Recycle Bin' folders.";
            display_name = "DeletedResource";
            parents = { NFO.FILE_DATA_OBJECT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.DOCUMENT;
            description = "A generic document. A common superclass for all documents on the desktop.";
            display_name = "Document";
            parents = { NIE.INFORMATION_ELEMENT };
            children = { NFO.TEXT_DOCUMENT, NFO.SPREADSHEET, NFO.PRESENTATION, NFO.MIND_MAP };
            all_children = { NFO.TEXT_DOCUMENT, NFO.SOURCE_CODE, NFO.SPREADSHEET, NFO.PAGINATED_TEXT_DOCUMENT, NFO.PLAIN_TEXT_DOCUMENT, NFO.HTML_DOCUMENT, NFO.PRESENTATION, NFO.MIND_MAP };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.EMBEDDED_FILE_DATA_OBJECT;
            description = "A file embedded in another data object. There are many ways in which a file may be embedded in another one. Use this class directly only in cases if none of the subclasses gives a better description of your case.";
            display_name = "EmbeddedFileDataObject";
            parents = { NFO.FILE_DATA_OBJECT };
            children = { NFO.ATTACHMENT, NFO.ARCHIVE_ITEM };
            all_children = { NFO.ATTACHMENT, NCAL.ATTACHMENT, NFO.ARCHIVE_ITEM };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.EXECUTABLE;
            description = "An executable file.";
            display_name = "Executable";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.FILESYSTEM;
            description = "A filesystem. Examples of filesystems include hard disk partitions, removable media, but also images thereof stored in files such as ISO.";
            display_name = "Filesystem";
            parents = { NFO.DATA_CONTAINER };
            children = { NFO.FILESYSTEM_IMAGE };
            all_children = { NFO.FILESYSTEM_IMAGE };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.FILESYSTEM_IMAGE;
            description = "An image of a filesystem. Instances of this class may include CD images, DVD images or hard disk partition images created by various pieces of software (e.g. Norton Ghost). Deprecated in favor of nfo:Filesystem.";
            display_name = "FilesystemImage";
            parents = { NFO.FILESYSTEM };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.FILE_DATA_OBJECT;
            description = "A resource containing a finite sequence of bytes with arbitrary information, that is available to a computer program and is usually based on some kind of durable storage. A file is durable in the sense that it remains available for programs to use after the current program has finished.";
            display_name = "file";
            parents = { NIE.DATA_OBJECT };
            children = { NFO.EMBEDDED_FILE_DATA_OBJECT, NFO.DELETED_RESOURCE, NFO.REMOTE_DATA_OBJECT };
            all_children = { NFO.EMBEDDED_FILE_DATA_OBJECT, NFO.ATTACHMENT, NCAL.ATTACHMENT, NFO.ARCHIVE_ITEM, NFO.DELETED_RESOURCE, NFO.REMOTE_DATA_OBJECT };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.FOLDER;
            description = "A folder/directory. Examples of folders include folders on a filesystem and message folders in a mailbox.";
            display_name = "Folder";
            parents = { NFO.DATA_CONTAINER };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.FONT;
            description = "A font.";
            display_name = "Font";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.HARD_DISK_PARTITION;
            description = "A partition on a hard disk";
            display_name = "HardDiskPartition";
            parents = { NIE.DATA_OBJECT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.HTML_DOCUMENT;
            description = "A HTML document, may contain links to other files.";
            display_name = "HtmlDocument";
            parents = { NFO.PLAIN_TEXT_DOCUMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.ICON;
            description = "An Icon (regardless of whether it's a raster or a vector icon. A resource representing an icon could have two types (Icon and Raster, or Icon and Vector) if required.";
            display_name = "Icon";
            parents = { NFO.IMAGE };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.IMAGE;
            description = "A file containing an image.";
            display_name = "Image";
            parents = { NFO.VISUAL };
            children = { NFO.ICON, NFO.RASTER_IMAGE, NFO.VECTOR_IMAGE };
            all_children = { NFO.ICON, NFO.CURSOR, NFO.RASTER_IMAGE, NFO.VECTOR_IMAGE };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.MEDIA;
            description = "A piece of media content. This class may be used to express complex media containers with many streams of various media content (both aural and visual).";
            display_name = "Media";
            parents = { NIE.INFORMATION_ELEMENT };
            children = { NFO.AUDIO, NFO.VISUAL };
            all_children = { NFO.AUDIO, NFO.VISUAL, NFO.IMAGE, NFO.ICON, NMM.TVSHOW, NFO.CURSOR, NMM.MUSIC_PIECE, NFO.VIDEO, NFO.RASTER_IMAGE, NMM.MOVIE, NFO.VECTOR_IMAGE };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.MEDIA_LIST;
            description = "A file containing a list of media files.e.g. a playlist";
            display_name = "MediaList";
            parents = { NIE.INFORMATION_ELEMENT };
            children = { NMM.MUSIC_ALBUM };
            all_children = { NMM.MUSIC_ALBUM };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.MEDIA_STREAM;
            description = "A stream of multimedia content, usually contained within a media container such as a movie (containing both audio and video) or a DVD (possibly containing many streams of audio and video). Most common interpretations for such a DataObject include Audio and Video.";
            display_name = "MediaStream";
            parents = { NIE.DATA_OBJECT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.MIND_MAP;
            description = "A MindMap, created by a mind-mapping utility. Examples might include FreeMind or mind mapper.";
            display_name = "MindMap";
            parents = { NFO.DOCUMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.OPERATING_SYSTEM;
            description = "An OperatingSystem";
            display_name = "OperatingSystem";
            parents = { NFO.SOFTWARE };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.PAGINATED_TEXT_DOCUMENT;
            description = "A file containing a text document, that is unambiguously divided into pages. Examples might include PDF, DOC, PS, DVI etc.";
            display_name = "PaginatedTextDocument";
            parents = { NFO.TEXT_DOCUMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.PLAIN_TEXT_DOCUMENT;
            description = "A file containing plain text (ASCII, Unicode or other encodings). Examples may include TXT, HTML, XML, program source code etc.";
            display_name = "PlainTextDocument";
            parents = { NFO.TEXT_DOCUMENT };
            children = { NFO.HTML_DOCUMENT, NFO.SOURCE_CODE };
            all_children = { NFO.HTML_DOCUMENT, NFO.SOURCE_CODE };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.PRESENTATION;
            description = "A Presentation made by some presentation software (Corel Presentations, OpenOffice Impress, MS Powerpoint etc.)";
            display_name = "Presentation";
            parents = { NFO.DOCUMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.RASTER_IMAGE;
            description = "A raster image.";
            display_name = "RasterImage";
            parents = { NFO.IMAGE };
            children = { NFO.CURSOR };
            all_children = { NFO.CURSOR };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.REMOTE_DATA_OBJECT;
            description = "A file data object stored at a remote location. Don't confuse this class with a RemotePortAddress. This one applies to a particular resource, RemotePortAddress applies to an address, that can have various interpretations.";
            display_name = "RemoteDataObject";
            parents = { NFO.FILE_DATA_OBJECT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.REMOTE_PORT_ADDRESS;
            description = "An address specifying a remote host and port. Such an address can be interpreted in many ways (examples of such interpretations include mailboxes, websites, remote calendars or filesystems), depending on an interpretation, various kinds of data may be extracted from such an address.";
            display_name = "RemotePortAddress";
            parents = { NIE.DATA_OBJECT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.SOFTWARE;
            description = "A piece of software. Examples may include applications and the operating system. This interpretation most commonly applies to SoftwareItems.";
            display_name = "Software";
            parents = { NIE.INFORMATION_ELEMENT };
            children = { NFO.APPLICATION, NFO.OPERATING_SYSTEM };
            all_children = { NFO.APPLICATION, NFO.OPERATING_SYSTEM };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.SOFTWARE_ITEM;
            description = "A DataObject representing a piece of software. Examples of interpretations of a SoftwareItem include an Application and an OperatingSystem.";
            display_name = "SoftwareItem";
            parents = { NIE.DATA_OBJECT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.SOFTWARE_SERVICE;
            description = "A service published by a piece of software, either by an operating system or an application. Examples of such services may include calendar, addressbook and mailbox managed by a PIM application. This category is introduced to distinguish between data available directly from the applications (Via some Interprocess Communication Mechanisms) and data available from files on a disk. In either case both DataObjects would receive a similar interpretation (e.g. a Mailbox) and wouldn't differ on the content level.";
            display_name = "SoftwareService";
            parents = { NIE.DATA_OBJECT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.SOURCE_CODE;
            description = "Code in a compilable or interpreted programming language.";
            display_name = "SourceCode";
            parents = { NFO.PLAIN_TEXT_DOCUMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.SPREADSHEET;
            description = "A spreadsheet, created by a spreadsheet application. Examples might include Gnumeric, OpenOffice Calc or MS Excel.";
            display_name = "Spreadsheet";
            parents = { NFO.DOCUMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.TEXT_DOCUMENT;
            description = "A text document";
            display_name = "TextDocument";
            parents = { NFO.DOCUMENT };
            children = { NFO.PAGINATED_TEXT_DOCUMENT, NFO.PLAIN_TEXT_DOCUMENT };
            all_children = { NFO.HTML_DOCUMENT, NFO.SOURCE_CODE, NFO.PAGINATED_TEXT_DOCUMENT, NFO.PLAIN_TEXT_DOCUMENT };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.TRASH;
            description = "Represents a container for deleted files, a feature common in modern operating systems.";
            display_name = "Trash";
            parents = { NFO.DATA_CONTAINER };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.VECTOR_IMAGE;
            description = "";
            display_name = "VectorImage";
            parents = { NFO.IMAGE };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.VIDEO;
            description = "A video file.";
            display_name = "Video";
            parents = { NFO.VISUAL };
            children = { NMM.TVSHOW, NMM.MOVIE };
            all_children = { NMM.TVSHOW, NMM.MOVIE };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.VISUAL;
            description = "File containing visual content.";
            display_name = "Visual";
            parents = { NFO.MEDIA };
            children = { NFO.VIDEO, NFO.IMAGE };
            all_children = { NFO.IMAGE, NFO.ICON, NMM.TVSHOW, NFO.CURSOR, NFO.VIDEO, NFO.RASTER_IMAGE, NMM.MOVIE, NFO.VECTOR_IMAGE };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.WEBSITE;
            description = "A website, usually a container for remote resources, that may be interpreted as HTMLDocuments, images or other types of content.";
            display_name = "Website";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NFO.WEB_DATA_OBJECT;
            description = "An information resources of which representations (files, streams) can be retrieved through a web server. They may be generated at retrieval time. Typical examples are pages served by PHP or AJAX or mp3 streams.";
            display_name = "web data object";
            parents = { NIE.DATA_OBJECT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NIE.DATA_OBJECT;
            description = "A unit of data that is created, annotated and processed on the user desktop. It represents a native structure the user works with. The usage of the term 'native' is important. It means that a DataObject can be directly mapped to a data structure maintained by a native application. This may be a file, a set of files or a part of a file. The granularity depends on the user. This class is not intended to be instantiated by itself. Use more specific subclasses.";
            display_name = "DataObject";
            parents = {  };
            children = { NFO.FILE_DATA_OBJECT, NCAL.CALENDAR_DATA_OBJECT, NFO.HARD_DISK_PARTITION, NFO.MEDIA_STREAM, NCO.CONTACT_LIST_DATA_OBJECT, NFO.REMOTE_PORT_ADDRESS, NFO.SOFTWARE_SERVICE, NFO.SOFTWARE_ITEM, NFO.WEB_DATA_OBJECT, NMO.MAILBOX_DATA_OBJECT, ZG.EVENT_MANIFESTATION };
            all_children = { NFO.EMBEDDED_FILE_DATA_OBJECT, NCAL.CALENDAR_DATA_OBJECT, NFO.ATTACHMENT, NCAL.ATTACHMENT, NFO.ARCHIVE_ITEM, NFO.MEDIA_STREAM, NFO.REMOTE_PORT_ADDRESS, NFO.SOFTWARE_SERVICE, ZG.SYSTEM_NOTIFICATION, ZG.EVENT_MANIFESTATION, NFO.DELETED_RESOURCE, ZG.WORLD_ACTIVITY, NFO.FILE_DATA_OBJECT, ZG.HEURISTIC_ACTIVITY, NFO.HARD_DISK_PARTITION, NCO.CONTACT_LIST_DATA_OBJECT, NFO.SOFTWARE_ITEM, NFO.WEB_DATA_OBJECT, NMO.MAILBOX_DATA_OBJECT, ZG.SCHEDULED_ACTIVITY, ZG.USER_ACTIVITY, NFO.REMOTE_DATA_OBJECT };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NIE.INFORMATION_ELEMENT;
            description = "A unit of content the user works with. This is a superclass for all interpretations of a DataObject.";
            display_name = "InformationElement";
            parents = {  };
            children = { NMM.TVSERIES, NCAL.TODO, ZG.EVENT_INTERPRETATION, NFO.DOCUMENT, NMO.MIME_ENTITY, NFO.BOOKMARK_FOLDER, NCAL.EVENT, NCO.CONTACT_LIST, NFO.SOFTWARE, NCO.CONTACT_GROUP, NCAL.TIMEZONE, NCAL.ALARM, NFO.FONT, NFO.MEDIA, ZG.APPLICATION_ACTION, NFO.WEBSITE, NCO.CONTACT, NMO.MAILBOX, NFO.MEDIA_LIST, NFO.BOOKMARK, NCAL.JOURNAL, NCAL.CALENDAR, NMO.MESSAGE, NFO.EXECUTABLE, NCAL.FREEBUSY, NFO.DATA_CONTAINER };
            all_children = { NMM.TVSERIES, NFO.VISUAL, NMM.TVSHOW, ZG.EVENT_INTERPRETATION, NCAL.TODO, ZG.CREATE_EVENT, ZG.ACCEPT_EVENT, ZG.RECEIVE_EVENT, NFO.DOCUMENT, ZG.ACCESS_EVENT, NFO.HTML_DOCUMENT, NMO.MIME_ENTITY, NFO.BOOKMARK_FOLDER, NCAL.EVENT, NFO.IMAGE, NCO.CONTACT_LIST, NFO.SOFTWARE, NCO.CONTACT_GROUP, NCAL.TIMEZONE, NFO.MIND_MAP, NCAL.ALARM, NFO.FONT, NFO.FILESYSTEM, NMO.IMMESSAGE, NFO.MEDIA, NMM.MUSIC_PIECE, ZG.APPLICATION_ACTION, NFO.WEBSITE, NFO.RASTER_IMAGE, NFO.PRESENTATION, NMO.EMAIL, NFO.APPLICATION, ZG.DELETE_EVENT, NFO.FOLDER, NFO.OPERATING_SYSTEM, NFO.ICON, ZG.LEAVE_EVENT, NCO.CONTACT, NCO.ORGANIZATION_CONTACT, ZG.EXPIRE_EVENT, NCO.PERSON_CONTACT, NMO.MAILBOX, NFO.MEDIA_LIST, NFO.DATA_CONTAINER, NFO.SOURCE_CODE, NFO.CURSOR, NMM.MUSIC_ALBUM, NFO.FILESYSTEM_IMAGE, ZG.MODIFY_EVENT, NFO.TRASH, NMM.MOVIE, NFO.TEXT_DOCUMENT, NFO.BOOKMARK, NFO.AUDIO, ZG.MOVE_EVENT, ZG.DENY_EVENT, NFO.PAGINATED_TEXT_DOCUMENT, NFO.PLAIN_TEXT_DOCUMENT, NCAL.JOURNAL, NCAL.CALENDAR, ZG.SEND_EVENT, NMO.MESSAGE, NFO.SPREADSHEET, NFO.ARCHIVE, NFO.EXECUTABLE, NCAL.FREEBUSY, NFO.VIDEO, NFO.VECTOR_IMAGE };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NMM.MOVIE;
            description = "A Movie";
            display_name = "movie";
            parents = { NFO.VIDEO };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NMM.MUSIC_ALBUM;
            description = "The music album as provided by the publisher. Not to be confused with media lists or collections.";
            display_name = "music album";
            parents = { NFO.MEDIA_LIST };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NMM.MUSIC_PIECE;
            description = "Used to assign music-specific properties such a BPM to video and audio";
            display_name = "music";
            parents = { NFO.AUDIO };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NMM.TVSERIES;
            description = "A TV Series has multiple seasons and episodes";
            display_name = "tv series";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NMM.TVSHOW;
            description = "A TV Show";
            display_name = "tv show";
            parents = { NFO.VIDEO };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NMO.EMAIL;
            description = "An email.";
            display_name = "Email";
            parents = { NMO.MESSAGE };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NMO.IMMESSAGE;
            description = "A message sent with Instant Messaging software.";
            display_name = "IMMessage";
            parents = { NMO.MESSAGE };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NMO.MAILBOX;
            description = "A mailbox - container for MailboxDataObjects.";
            display_name = "Mailbox";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NMO.MAILBOX_DATA_OBJECT;
            description = "An entity encountered in a mailbox. Most common interpretations for such an entity include Message or Folder";
            display_name = "MailboxDataObject";
            parents = { NIE.DATA_OBJECT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NMO.MESSAGE;
            description = "A message. Could be an email, instant messanging message, SMS message etc.";
            display_name = "Message";
            parents = { NIE.INFORMATION_ELEMENT };
            children = { NMO.IMMESSAGE, NMO.EMAIL };
            all_children = { NMO.IMMESSAGE, NMO.EMAIL };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.NMO.MIME_ENTITY;
            description = "A MIME entity, as defined in RFC2045, Section 2.4.";
            display_name = "MimeEntity";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.ACCEPT_EVENT;
            description = "Event triggered when the user accepts a request of some sort. Examples could be answering a phone call, accepting a file transfer, or accepting a friendship request over an IM protocol. See also DenyEvent for when the user denies a similar request";
            display_name = "ACCEPT_EVENT";
            parents = { ZG.EVENT_INTERPRETATION };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.ACCESS_EVENT;
            description = "Event triggered by opening, accessing, or starting a resource. Most zg:AccessEvents will have an accompanying zg:LeaveEvent, but this need not always be the case";
            display_name = "ACCESS_EVENT";
            parents = { ZG.EVENT_INTERPRETATION };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.APPLICATION_ACTION;
            description = "Representation of a specific Action on an Application";
            display_name = "APPLICATION_ACTION";
            parents = { NIE.INFORMATION_ELEMENT };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.CREATE_EVENT;
            description = "Event type triggered when an item is created";
            display_name = "CREATE_EVENT";
            parents = { ZG.EVENT_INTERPRETATION };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.DELETE_EVENT;
            description = "Event triggered because a resource has been deleted or otherwise made permanently unavailable. Fx. when deleting a file. FIXME: How about when moving to trash?";
            display_name = "DELETE_EVENT";
            parents = { ZG.EVENT_INTERPRETATION };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.DENY_EVENT;
            description = "Event triggered when the user denies a request of some sort. Examples could be rejecting a phone call, rejecting a file transfer, or denying a friendship request over an IM protocol. See also AcceptEvent for the converse event type";
            display_name = "DENY_EVENT";
            parents = { ZG.EVENT_INTERPRETATION };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.EVENT_INTERPRETATION;
            description = "Base class for event interpretations. Please do no instantiate directly, but use one of the sub classes. The interpretation of an event describes 'what happened' - fx. 'something was created' or 'something was accessed'";
            display_name = "EVENT_INTERPRETATION";
            parents = { NIE.INFORMATION_ELEMENT };
            children = { ZG.MOVE_EVENT, ZG.DENY_EVENT, ZG.DELETE_EVENT, ZG.LEAVE_EVENT, ZG.EXPIRE_EVENT, ZG.SEND_EVENT, ZG.CREATE_EVENT, ZG.ACCEPT_EVENT, ZG.RECEIVE_EVENT, ZG.ACCESS_EVENT, ZG.MODIFY_EVENT };
            all_children = { ZG.MOVE_EVENT, ZG.DELETE_EVENT, ZG.DENY_EVENT, ZG.LEAVE_EVENT, ZG.EXPIRE_EVENT, ZG.SEND_EVENT, ZG.CREATE_EVENT, ZG.ACCEPT_EVENT, ZG.RECEIVE_EVENT, ZG.ACCESS_EVENT, ZG.MODIFY_EVENT };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.EVENT_MANIFESTATION;
            description = "Base class for event manifestation types. Please do no instantiate directly, but use one of the sub classes. The manifestation of an event describes 'how it happened'. Fx. 'the user did this' or 'the system notified the user'";
            display_name = "EVENT_MANIFESTATION";
            parents = { NIE.DATA_OBJECT };
            children = { ZG.WORLD_ACTIVITY, ZG.HEURISTIC_ACTIVITY, ZG.SYSTEM_NOTIFICATION, ZG.SCHEDULED_ACTIVITY, ZG.USER_ACTIVITY };
            all_children = { ZG.WORLD_ACTIVITY, ZG.HEURISTIC_ACTIVITY, ZG.SYSTEM_NOTIFICATION, ZG.SCHEDULED_ACTIVITY, ZG.USER_ACTIVITY };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.EXPIRE_EVENT;
            description = "Event triggered when something expires or times out. These types of events are normally not triggered by the user, but by the operating system or some external party. Examples are a recurring calendar item or task deadline that expires or a when the user fails to respond to an external request such as a phone call";
            display_name = "EXPIRE_EVENT";
            parents = { ZG.EVENT_INTERPRETATION };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.HEURISTIC_ACTIVITY;
            description = "An event that is caused indirectly from user activity or deducted via analysis of other events. Fx. if an algorithm divides a user workflow into disjoint 'projects' based on temporal analysis it could insert heuristic events when the user changed project";
            display_name = "HEURISTIC_ACTIVITY";
            parents = { ZG.EVENT_MANIFESTATION };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.LEAVE_EVENT;
            description = "Event triggered by closing, leaving, or stopping a resource. Most zg:LeaveEvents will be following a zg:Access event, but this need not always be the case";
            display_name = "LEAVE_EVENT";
            parents = { ZG.EVENT_INTERPRETATION };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.MODIFY_EVENT;
            description = "Event triggered by modifying an existing resources. Fx. when editing and saving a file on disk or correcting a typo in the name of a contact";
            display_name = "MODIFY_EVENT";
            parents = { ZG.EVENT_INTERPRETATION };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.MOVE_EVENT;
            description = "Event triggered when a resource has been moved from a location to another. Fx. moving a file from a folder to another.";
            display_name = "MOVE_EVENT";
            parents = { ZG.EVENT_INTERPRETATION };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.RECEIVE_EVENT;
            description = "Event triggered when something is received from an external party. The event manifestation must be set according to the world view of the receiving party. Most often the item that is being received will be some sort of message - an email, instant message, or broadcasted media such as micro blogging";
            display_name = "RECEIVE_EVENT";
            parents = { ZG.EVENT_INTERPRETATION };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.SCHEDULED_ACTIVITY;
            description = "An event that was directly triggered by some user initiated sequence of actions. For example a music player automatically changing to the next song in a playlist";
            display_name = "SCHEDULED_ACTIVITY";
            parents = { ZG.EVENT_MANIFESTATION };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.SEND_EVENT;
            description = "Event triggered when something is send to an external party. The event manifestation must be set according to the world view of the sending party. Most often the item that is being send will be some sort of message - an email, instant message, or broadcasted media such as micro blogging";
            display_name = "SEND_EVENT";
            parents = { ZG.EVENT_INTERPRETATION };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.SYSTEM_NOTIFICATION;
            description = "An event send to the user by the operating system. Examples could include when the user inserts a USB stick or when the system warns that the hard disk is full";
            display_name = "SYSTEM_NOTIFICATION";
            parents = { ZG.EVENT_MANIFESTATION };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.USER_ACTIVITY;
            description = "An event that was actively performed by the user. For example saving or opening a file by clicking on it in the file manager";
            display_name = "USER_ACTIVITY";
            parents = { ZG.EVENT_MANIFESTATION };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);

            uri = Zeitgeist.ZG.WORLD_ACTIVITY;
            description = "An event that was performed by an entity, usually human or organization, other than the user. An example could be logging the activities of other people in a team";
            display_name = "WORLD_ACTIVITY";
            parents = { ZG.EVENT_MANIFESTATION };
            children = {  };
            all_children = {  };
            Symbol.Info.register (uri, display_name, description, parents, children, all_children);
        }

    }

    private class Symbol.Info
    {
        public List<string> parents;
        public List<string> children;
        public List<string> all_children;
        public string uri;
        public string display_name;
        public string description;

        private Info (string uri, string display_name, string description,
            string[] parents, string[] children, string[] all_children)
        {
            this.uri = uri;
            this.display_name = display_name;
            this.description = description;
            this.parents = new List<string> ();
            for (int i = 0; i < parents.length; i++)
                this.parents.append (parents[i]);
            this.children = new List<string> ();
            for (int i = 0; i < children.length; i++)
                this.children.append (children[i]);
            this.all_children = new List<string> ();
            for (int i = 0; i < all_children.length; i++)
                this.all_children.append (all_children[i]);
        }

        internal static void register (string uri, string display_name,
            string description, string[] parents, string[] children,
            string[] all_children)
        {
            if (all_symbols == null)
                all_symbols = new HashTable<string, Info> (str_hash, str_equal);
            Info symbol = new Info (uri, display_name, description,
                parents, children, all_children);
            all_symbols.insert (uri, symbol);
        }

    }

}

// vim:expandtab:ts=4:sw=4
