/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.resolver;

import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.DefaultEndpoint;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticClusterResolver<T extends EurekaEndpoint>
implements ClusterResolver<T> {
    private static final Logger logger = LoggerFactory.getLogger(StaticClusterResolver.class);
    private final List<T> eurekaEndpoints;
    private final String region;

    @SafeVarargs
    public StaticClusterResolver(String region, T ... eurekaEndpoints) {
        this(region, Arrays.asList(eurekaEndpoints));
    }

    public StaticClusterResolver(String region, List<T> eurekaEndpoints) {
        this.eurekaEndpoints = eurekaEndpoints;
        this.region = region;
        logger.debug("Fixed resolver configuration: {}", eurekaEndpoints);
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public List<T> getClusterEndpoints() {
        return this.eurekaEndpoints;
    }

    public static ClusterResolver<EurekaEndpoint> fromURL(String regionName, URL serviceUrl) {
        boolean isSecure = "https".equalsIgnoreCase(serviceUrl.getProtocol());
        int defaultPort = isSecure ? 443 : 80;
        int port = serviceUrl.getPort() == -1 ? defaultPort : serviceUrl.getPort();
        return new StaticClusterResolver(regionName, new EurekaEndpoint[]{new DefaultEndpoint(serviceUrl.getHost(), port, isSecure, serviceUrl.getPath())});
    }
}

