package main

import (
	"sort"
	"strings"
)

// Local implementation of stdlib funcs that are not available in go 1.8

// slices.Contains().
func stringSliceContains(slice []string, str string) bool {
	for _, s := range slice {
		if s == str {
			return true
		}
	}
	return false
}

// strings.Cutprefix().
func cutPrefix(s, prefix string) (after string, found bool) {
	if !strings.HasPrefix(s, prefix) {
		return s, false
	}
	return s[len(prefix):], true
}

type stringSet struct {
	m map[string]bool
}

func newStringSet() *stringSet {
	return &stringSet{m: make(map[string]bool)}
}

func (ss *stringSet) add(s string) {
	if !ss.m[s] {
		ss.m[s] = true
	}
}

// String returns the set keys joined up with colons in alphabetical order.
func (ss stringSet) String() string {
	var keys []string
	for k := range ss.m {
		keys = append(keys, k)
	}
	sort.StringSlice(keys).Sort()
	return strings.Join(keys, ":")
}
