/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc;

import com.kreative.rsrc.MacResource;
import com.kreative.rsrc.pict.PICTUtilities;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

public class CursorResource
extends MacResource {
    public static final int RESOURCE_TYPE = 1129665107;

    public static boolean isMyType(int type) {
        return type == 1129665107;
    }

    public CursorResource(short id, byte[] data) {
        super(1129665107, id, data);
    }

    public CursorResource(short id, String name, byte[] data) {
        super(1129665107, id, name, data);
    }

    public CursorResource(short id, byte attr, byte[] data) {
        super(1129665107, id, attr, data);
    }

    public CursorResource(short id, byte attr, String name, byte[] data) {
        super(1129665107, id, attr, name, data);
    }

    public CursorResource(int type, short id, byte[] data) {
        super(type, id, data);
    }

    public CursorResource(int type, short id, String name, byte[] data) {
        super(type, id, name, data);
    }

    public CursorResource(int type, short id, byte attr, byte[] data) {
        super(type, id, attr, data);
    }

    public CursorResource(int type, short id, byte attr, String name, byte[] data) {
        super(type, id, attr, name, data);
    }

    public Image getImage() {
        int[] pixels = new int[512];
        int i = 0;
        int j = 0;
        while (i < 64 && j < 512) {
            pixels[j + 0] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x80) >> 7];
            pixels[j + 1] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x40) >> 6];
            pixels[j + 2] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x20) >> 5];
            pixels[j + 3] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x10) >> 4];
            pixels[j + 4] = PICTUtilities.COLORS_1BIT[(this.data[i] & 8) >> 3];
            pixels[j + 5] = PICTUtilities.COLORS_1BIT[(this.data[i] & 4) >> 2];
            pixels[j + 6] = PICTUtilities.COLORS_1BIT[(this.data[i] & 2) >> 1];
            pixels[j + 7] = PICTUtilities.COLORS_1BIT[(this.data[i] & 1) >> 0];
            ++i;
            j += 8;
        }
        BufferedImage img = new BufferedImage(16, 16, 2);
        img.setRGB(0, 0, 16, 16, pixels, 0, 16);
        return img;
    }

    public Image getMask() {
        int[] pixels = new int[512];
        int i = 0;
        int j = 0;
        while (i < 64 && j < 512) {
            pixels[j + 0] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x80) >> 7];
            pixels[j + 1] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x40) >> 6];
            pixels[j + 2] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x20) >> 5];
            pixels[j + 3] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x10) >> 4];
            pixels[j + 4] = PICTUtilities.COLORS_1BIT[(this.data[i] & 8) >> 3];
            pixels[j + 5] = PICTUtilities.COLORS_1BIT[(this.data[i] & 4) >> 2];
            pixels[j + 6] = PICTUtilities.COLORS_1BIT[(this.data[i] & 2) >> 1];
            pixels[j + 7] = PICTUtilities.COLORS_1BIT[(this.data[i] & 1) >> 0];
            ++i;
            j += 8;
        }
        BufferedImage img = new BufferedImage(16, 16, 2);
        img.setRGB(0, 0, 16, 16, pixels, 256, 16);
        return img;
    }

    public Image getComposite() {
        int[] pixels = new int[512];
        int i = 0;
        int j = 0;
        while (i < 64 && j < 512) {
            pixels[j + 0] = (this.data[i] & 0x80) >> 7;
            pixels[j + 1] = (this.data[i] & 0x40) >> 6;
            pixels[j + 2] = (this.data[i] & 0x20) >> 5;
            pixels[j + 3] = (this.data[i] & 0x10) >> 4;
            pixels[j + 4] = (this.data[i] & 8) >> 3;
            pixels[j + 5] = (this.data[i] & 4) >> 2;
            pixels[j + 6] = (this.data[i] & 2) >> 1;
            pixels[j + 7] = (this.data[i] & 1) >> 0;
            ++i;
            j += 8;
        }
        int[] pixelsx = new int[256];
        int i2 = 0;
        int j2 = 256;
        while (i2 < 256 && j2 < 512) {
            pixelsx[i2] = pixels[j2] != 0 ? (pixels[i2] != 0 ? -16777216 : -1) : (pixels[i2] != 0 ? -2139062144 : 0);
            ++i2;
            ++j2;
        }
        BufferedImage img = new BufferedImage(16, 16, 2);
        img.setRGB(0, 0, 16, 16, pixelsx, 0, 16);
        return img;
    }

    public Cursor toCursor(Toolkit tk) {
        try {
            return tk.createCustomCursor(this.getComposite(), this.getHotspot(), this.name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Point getHotspot() {
        int y = (this.data[64] & 0xFF) << 8 | this.data[65] & 0xFF;
        int x = (this.data[66] & 0xFF) << 8 | this.data[67] & 0xFF;
        return new Point(x, y);
    }

    public int getHotspotX() {
        return (this.data[66] & 0xFF) << 8 | this.data[67] & 0xFF;
    }

    public int getHotspotY() {
        return (this.data[64] & 0xFF) << 8 | this.data[65] & 0xFF;
    }
}

