#ifndef CAMV_CONF_CORE_H
#define CAMV_CONF_CORE_H

#include <librnd/core/conf.h>
#include <librnd/core/color.h>

typedef struct {
	const struct { /* appearance */
		struct { /* color */
			RND_CFT_COLOR layer[16];       /* default layer colors; when a new layer is created, a color from this list is assigned initially */
			RND_CFT_COLOR attached;
		} color;
		RND_CFT_STRING default_font;     /* path to the ttf of the default font */
	} appearance;
	const struct rc { /* rc */
		RND_CFT_BOOLEAN error_on_bad_cli_files;
	} rc;
	const struct { /* TODO: this should be in the corresponding plugin */
		const struct {
			RND_CFT_BOOLEAN laser;         /* Import g-code assuming laser plotting: M3/M4 is laser on, M5 is laser off */
		} import_gcode;
	} plugins;
} conf_core_t;


void conf_core_init();
extern conf_core_t conf_core;

#endif
