{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetGeoOrigin: TGeoOriginNode;
    procedure SetGeoOrigin(const Value: TGeoOriginNode);
  public
    procedure SetPoint(const Value: array of TVector3Double);
    procedure SetPoint(const Value: TVector3DoubleList);
    property GeoOrigin: TGeoOriginNode read GetGeoOrigin write SetGeoOrigin;
    procedure SetGeoSystem(const Value: array of string);
    procedure SetGeoSystem(const Value: TCastleStringList);

{$endif read_interface}

{$ifdef read_implementation}

{ TGeoCoordinateNode ----------------------------------------------- }

procedure TGeoCoordinateNode.SetPoint(const Value: array of TVector3Double);
begin
  FdPoint.Send(Value);
end;

procedure TGeoCoordinateNode.SetPoint(const Value: TVector3DoubleList);
begin
  FdPoint.Send(Value);
end;

function TGeoCoordinateNode.GetGeoOrigin: TGeoOriginNode;
begin
  if FdGeoOrigin.Value is TGeoOriginNode then
    Result := TGeoOriginNode(FdGeoOrigin.Value)
  else
    Result := nil;
end;

procedure TGeoCoordinateNode.SetGeoOrigin(const Value: TGeoOriginNode);
begin
  FdGeoOrigin.Send(Value);
end;

procedure TGeoCoordinateNode.SetGeoSystem(const Value: array of string);
begin
  FdGeoSystem.Send(Value);
end;

procedure TGeoCoordinateNode.SetGeoSystem(const Value: TCastleStringList);
begin
  FdGeoSystem.Send(Value);
end;

{$endif read_implementation}
