{
  Copyright 2014-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Manage game achievements. }
unit GameAchievements;

interface

uses CastleGameService;

const
  { Achievement ids.
    For Android: these are generated by creating achievements in Google Developer Console.
    For iOS: these are set by you in iTunes Connect. }
  AchievementMove        = {$ifdef ANDROID} 'CgkIvIv-jrANEAIQAQ' {$else} 'move'         {$endif};
  AchievementClickFollow = {$ifdef ANDROID} 'CgkIvIv-jrANEAIQAg' {$else} 'click_follow' {$endif};
  AchievementSeeLeft     = {$ifdef ANDROID} 'CgkIvIv-jrANEAIQBQ' {$else} 'see_left'     {$endif};
  AchievementSeeRight    = {$ifdef ANDROID} 'CgkIvIv-jrANEAIQBw' {$else} 'see_right'    {$endif};

var
  GameService: TGameService;

  { For achievements that can be detected *very* often (e.g. AchievementSeeLeft
    would be submitted 60x per second, if the dragon is on the left side of the world)
    you can use a flag to not send GameService.Achievement multiple times with the same value.

    This is only an optimization, to not overwhelm the GameService with useless calls.
    Sending the same achievement many times would be ignored anyway. }
  AchievementSeeLeftSubmitted, AchievementSeeRightSubmitted: boolean;

implementation

end.
