{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FEventActionKeyPress: TSFInt32Event;
    {  }
    public property EventActionKeyPress: TSFInt32Event read FEventActionKeyPress;

    strict private FEventActionKeyRelease: TSFInt32Event;
    {  }
    public property EventActionKeyRelease: TSFInt32Event read FEventActionKeyRelease;

    strict private FEventAltKey: TSFBoolEvent;
    {  }
    public property EventAltKey: TSFBoolEvent read FEventAltKey;

    strict private FEventControlKey: TSFBoolEvent;
    {  }
    public property EventControlKey: TSFBoolEvent read FEventControlKey;

    strict private FEventKeyPress: TSFStringEvent;
    {  }
    public property EventKeyPress: TSFStringEvent read FEventKeyPress;

    strict private FEventKeyRelease: TSFStringEvent;
    {  }
    public property EventKeyRelease: TSFStringEvent read FEventKeyRelease;

    strict private FEventShiftKey: TSFBoolEvent;
    {  }
    public property EventShiftKey: TSFBoolEvent read FEventShiftKey;

{$endif read_interface}

{$ifdef read_implementation}

{ TKeySensorNode ----------------------------------------------- }

class function TKeySensorNode.ClassX3DType: String;
begin
  Result := 'KeySensor';
end;

procedure TKeySensorNode.CreateNode;
begin
  inherited;

  FEventActionKeyPress := TSFInt32Event.Create(Self, 'actionKeyPress', false);
  AddEvent(FEventActionKeyPress);

  FEventActionKeyRelease := TSFInt32Event.Create(Self, 'actionKeyRelease', false);
  AddEvent(FEventActionKeyRelease);

  FEventAltKey := TSFBoolEvent.Create(Self, 'altKey', false);
  AddEvent(FEventAltKey);

  FEventControlKey := TSFBoolEvent.Create(Self, 'controlKey', false);
  AddEvent(FEventControlKey);

  FEventKeyPress := TSFStringEvent.Create(Self, 'keyPress', false);
  AddEvent(FEventKeyPress);

  FEventKeyRelease := TSFStringEvent.Create(Self, 'keyRelease', false);
  AddEvent(FEventKeyRelease);

  FEventShiftKey := TSFBoolEvent.Create(Self, 'shiftKey', false);
  AddEvent(FEventShiftKey);
end;

{$endif read_implementation}
