{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetDirection: TVector3;
    procedure SetDirection(const Value: TVector3);
    function GetProjectionRectangle: TVector4;
    procedure SetProjectionRectangle(const Value: TVector4);
    function GetProjectionLocation: TVector3;
    procedure SetProjectionLocation(const Value: TVector3);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdDirection: TSFVec3f;
    { Internal wrapper for property @code(Direction). This wrapper API may change, we advise to access simpler @code(Direction) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDirection: TSFVec3f read FFdDirection;
    {  }
    property Direction: TVector3 read GetDirection write SetDirection;

    strict private FFdProjectionRectangle: TSFVec4f;
    { Internal wrapper for property @code(ProjectionRectangle). This wrapper API may change, we advise to access simpler @code(ProjectionRectangle) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdProjectionRectangle: TSFVec4f read FFdProjectionRectangle;
    {  }
    property ProjectionRectangle: TVector4 read GetProjectionRectangle write SetProjectionRectangle;

    strict private FFdProjectionLocation: TSFVec3f;
    { Internal wrapper for property @code(ProjectionLocation). This wrapper API may change, we advise to access simpler @code(ProjectionLocation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdProjectionLocation: TSFVec3f read FFdProjectionLocation;
    {  }
    property ProjectionLocation: TVector3 read GetProjectionLocation write SetProjectionLocation;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractDirectionalLightNode ----------------------------------------------- }

function TAbstractDirectionalLightNode.GetDirection: TVector3;
begin
  Result := FdDirection.Value;
end;

procedure TAbstractDirectionalLightNode.SetDirection(const Value: TVector3);
begin
  FdDirection.Send(Value);
end;

function TAbstractDirectionalLightNode.GetProjectionRectangle: TVector4;
begin
  Result := FdProjectionRectangle.Value;
end;

procedure TAbstractDirectionalLightNode.SetProjectionRectangle(const Value: TVector4);
begin
  FdProjectionRectangle.Send(Value);
end;

function TAbstractDirectionalLightNode.GetProjectionLocation: TVector3;
begin
  Result := FdProjectionLocation.Value;
end;

procedure TAbstractDirectionalLightNode.SetProjectionLocation(const Value: TVector3);
begin
  FdProjectionLocation.Send(Value);
end;

class function TAbstractDirectionalLightNode.ClassX3DType: String;
begin
  Result := 'X3DDirectionalLightNode';
end;

procedure TAbstractDirectionalLightNode.CreateNode;
begin
  inherited;

  FFdDirection := TSFVec3f.Create(Self, True, 'direction', Vector3(0, 0, -1));
   FdDirection.ChangeAlways := chLightLocationDirection;
  AddField(FFdDirection);

  FFdProjectionRectangle := TSFVec4f.Create(Self, True, 'projectionRectangle', Vector4(0, 0, 0, 0));
   FdProjectionRectangle.ChangeAlways := chVisibleGeometry;
  AddField(FFdProjectionRectangle);

  FFdProjectionLocation := TSFVec3f.Create(Self, True, 'projectionLocation', Vector3(0, 0, 0));
   FdProjectionLocation.ChangeAlways := chVisibleGeometry;
  AddField(FFdProjectionLocation);
end;

{$endif read_implementation}
