/******************************************************************************
 *
 * 
 *
 *
 * Copyright (C) 1997-2015 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * Documents produced by Doxygen are derivative works derived from the
 * input used in their production; they are not affected by this license.
 *
 */

#ifndef _IMAGE_H
#define _IMAGE_H
#include <qglobal.h>

/** Class representing a bitmap image generated by doxygen. */
class Image
{
  public:
    Image(uint w,uint h);
   ~Image();
   
    void setPixel(uint x,uint y,uchar val);
    uchar getPixel(uint x,uint y) const;
    void writeChar(uint x,uint y,char c,uchar fg);
    void writeString(uint x,uint y,const char *s,uchar fg);
    void drawHorzLine(uint y,uint xs,uint xe,uchar colIndex,uint mask);
    void drawHorzArrow(uint y,uint xs,uint xe,uchar colIndex,uint mask);
    void drawVertLine(uint x,uint ys,uint ye,uchar colIndex,uint mask);
    void drawVertArrow(uint x,uint ys,uint ye,uchar colIndex,uint mask);
    void drawRect(uint x,uint y,uint width,uint height,uchar colIndex,uint mask);
    void fillRect(uint x,uint y,uint width,uint height,uchar colIndex,uint mask);
    bool save(const char *fileName,int mode=0);
    friend uint stringLength(const char *s);
    uint width() const { return m_width; }
    uint height() const { return m_height; }
    uchar *data() const { return m_data; }
    static uint stringLength(const char *s);
 
  private:
    uint m_width;
    uint m_height;
    uchar *m_data;
};

/** Class representing a bitmap image colored based on hue/sat/gamma settings. */
class ColoredImage
{
  public:
    ColoredImage(uint width,uint height,
           const uchar *greyLevels,const uchar *alphaLevels,
           int saturation,int hue,int gamma);
   ~ColoredImage();
    bool save(const char *fileName);
    static void hsl2rgb(double h,double s,double l,
                        double *pRed,double *pGreen,double *pBlue);
  private:
    uint m_width;
    uint m_height;
    uchar *m_data;
    bool m_hasAlpha;
};

#endif
