// A Bison parser, made by GNU Bison 3.7.5.

// Skeleton interface for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018-2021 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.


/**
 ** \file DynareBison.hh
 ** Define the Dynare::parser class.
 */

// C++ LALR(1) parser skeleton written by Akim Demaille.

// DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
// especially those whose name start with YY_ or yy_.  They are
// private implementation details that can be changed or removed.

#ifndef YY_YY_DYNAREBISON_HH_INCLUDED
# define YY_YY_DYNAREBISON_HH_INCLUDED
// "%code requires" blocks.
#line 34 "DynareBison.yy"

#include "ExprNode.hh"
#include "CodeInterpreter.hh"

#line 54 "DynareBison.hh"

# include <cassert>
# include <cstdlib> // std::abort
# include <iostream>
# include <stdexcept>
# include <string>
# include <vector>

#if defined __cplusplus
# define YY_CPLUSPLUS __cplusplus
#else
# define YY_CPLUSPLUS 199711L
#endif

// Support move semantics when possible.
#if 201103L <= YY_CPLUSPLUS
# define YY_MOVE           std::move
# define YY_MOVE_OR_COPY   move
# define YY_MOVE_REF(Type) Type&&
# define YY_RVREF(Type)    Type&&
# define YY_COPY(Type)     Type
#else
# define YY_MOVE
# define YY_MOVE_OR_COPY   copy
# define YY_MOVE_REF(Type) Type&
# define YY_RVREF(Type)    const Type&
# define YY_COPY(Type)     const Type&
#endif

// Support noexcept when possible.
#if 201103L <= YY_CPLUSPLUS
# define YY_NOEXCEPT noexcept
# define YY_NOTHROW
#else
# define YY_NOEXCEPT
# define YY_NOTHROW throw ()
#endif

// Support constexpr when possible.
#if 201703 <= YY_CPLUSPLUS
# define YY_CONSTEXPR constexpr
#else
# define YY_CONSTEXPR
#endif
# include "location.hh"
#include <typeinfo>
#ifndef YY_ASSERT
# include <cassert>
# define YY_ASSERT assert
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

#line 25 "DynareBison.yy"
namespace Dynare {
#line 189 "DynareBison.hh"




  /// A Bison parser.
  class parser
  {
  public:
#ifndef YYSTYPE
  /// A buffer to store and retrieve objects.
  ///
  /// Sort of a variant, but does not keep track of the nature
  /// of the stored data, since that knowledge is available
  /// via the current parser state.
  class semantic_type
  {
  public:
    /// Type of *this.
    typedef semantic_type self_type;

    /// Empty construction.
    semantic_type () YY_NOEXCEPT
      : yybuffer_ ()
      , yytypeid_ (YY_NULLPTR)
    {}

    /// Construct and fill.
    template <typename T>
    semantic_type (YY_RVREF (T) t)
      : yytypeid_ (&typeid (T))
    {
      YY_ASSERT (sizeof (T) <= size);
      new (yyas_<T> ()) T (YY_MOVE (t));
    }

#if 201103L <= YY_CPLUSPLUS
    /// Non copyable.
    semantic_type (const self_type&) = delete;
    /// Non copyable.
    self_type& operator= (const self_type&) = delete;
#endif

    /// Destruction, allowed only if empty.
    ~semantic_type () YY_NOEXCEPT
    {
      YY_ASSERT (!yytypeid_);
    }

# if 201103L <= YY_CPLUSPLUS
    /// Instantiate a \a T in here from \a t.
    template <typename T, typename... U>
    T&
    emplace (U&&... u)
    {
      YY_ASSERT (!yytypeid_);
      YY_ASSERT (sizeof (T) <= size);
      yytypeid_ = & typeid (T);
      return *new (yyas_<T> ()) T (std::forward <U>(u)...);
    }
# else
    /// Instantiate an empty \a T in here.
    template <typename T>
    T&
    emplace ()
    {
      YY_ASSERT (!yytypeid_);
      YY_ASSERT (sizeof (T) <= size);
      yytypeid_ = & typeid (T);
      return *new (yyas_<T> ()) T ();
    }

    /// Instantiate a \a T in here from \a t.
    template <typename T>
    T&
    emplace (const T& t)
    {
      YY_ASSERT (!yytypeid_);
      YY_ASSERT (sizeof (T) <= size);
      yytypeid_ = & typeid (T);
      return *new (yyas_<T> ()) T (t);
    }
# endif

    /// Instantiate an empty \a T in here.
    /// Obsolete, use emplace.
    template <typename T>
    T&
    build ()
    {
      return emplace<T> ();
    }

    /// Instantiate a \a T in here from \a t.
    /// Obsolete, use emplace.
    template <typename T>
    T&
    build (const T& t)
    {
      return emplace<T> (t);
    }

    /// Accessor to a built \a T.
    template <typename T>
    T&
    as () YY_NOEXCEPT
    {
      YY_ASSERT (yytypeid_);
      YY_ASSERT (*yytypeid_ == typeid (T));
      YY_ASSERT (sizeof (T) <= size);
      return *yyas_<T> ();
    }

    /// Const accessor to a built \a T (for %printer).
    template <typename T>
    const T&
    as () const YY_NOEXCEPT
    {
      YY_ASSERT (yytypeid_);
      YY_ASSERT (*yytypeid_ == typeid (T));
      YY_ASSERT (sizeof (T) <= size);
      return *yyas_<T> ();
    }

    /// Swap the content with \a that, of same type.
    ///
    /// Both variants must be built beforehand, because swapping the actual
    /// data requires reading it (with as()), and this is not possible on
    /// unconstructed variants: it would require some dynamic testing, which
    /// should not be the variant's responsibility.
    /// Swapping between built and (possibly) non-built is done with
    /// self_type::move ().
    template <typename T>
    void
    swap (self_type& that) YY_NOEXCEPT
    {
      YY_ASSERT (yytypeid_);
      YY_ASSERT (*yytypeid_ == *that.yytypeid_);
      std::swap (as<T> (), that.as<T> ());
    }

    /// Move the content of \a that to this.
    ///
    /// Destroys \a that.
    template <typename T>
    void
    move (self_type& that)
    {
# if 201103L <= YY_CPLUSPLUS
      emplace<T> (std::move (that.as<T> ()));
# else
      emplace<T> ();
      swap<T> (that);
# endif
      that.destroy<T> ();
    }

# if 201103L <= YY_CPLUSPLUS
    /// Move the content of \a that to this.
    template <typename T>
    void
    move (self_type&& that)
    {
      emplace<T> (std::move (that.as<T> ()));
      that.destroy<T> ();
    }
#endif

    /// Copy the content of \a that to this.
    template <typename T>
    void
    copy (const self_type& that)
    {
      emplace<T> (that.as<T> ());
    }

    /// Destroy the stored \a T.
    template <typename T>
    void
    destroy ()
    {
      as<T> ().~T ();
      yytypeid_ = YY_NULLPTR;
    }

  private:
#if YY_CPLUSPLUS < 201103L
    /// Non copyable.
    semantic_type (const self_type&);
    /// Non copyable.
    self_type& operator= (const self_type&);
#endif

    /// Accessor to raw memory as \a T.
    template <typename T>
    T*
    yyas_ () YY_NOEXCEPT
    {
      void *yyp = yybuffer_.yyraw;
      return static_cast<T*> (yyp);
     }

    /// Const accessor to raw memory as \a T.
    template <typename T>
    const T*
    yyas_ () const YY_NOEXCEPT
    {
      const void *yyp = yybuffer_.yyraw;
      return static_cast<const T*> (yyp);
     }

    /// An auxiliary type to compute the largest semantic type.
    union union_type
    {
      // prior_distribution
      // prior_pdf
      char dummy1[sizeof (PriorDistributions)];

      // change_type_arg
      char dummy2[sizeof (SymbolType)];

      // expression
      // expression_or_empty
      // equation
      // hand_side
      char dummy3[sizeof (expr_t)];

      // occbin_constraints_regime_options_list
      char dummy4[sizeof (map<string, expr_t>)];

      // calibration_range
      char dummy5[sizeof (pair<expr_t,expr_t>)];

      // occbin_constraints_regime_option
      char dummy6[sizeof (pair<string, expr_t>)];

      // named_var_elem
      // subsamples_eq_opt
      // integer_range_w_inf
      char dummy7[sizeof (pair<string,string>)];

      // FALSE
      // FLOAT_NUMBER
      // DATES
      // INT_NUMBER
      // NAME
      // QUOTED_STRING
      // TEX_NAME
      // TRUE
      // BIND
      // RELAX
      // ERROR_BIND
      // ERROR_RELAX
      // ALPHA
      // BETA
      // ABAND
      // NINV
      // CMS
      // NCMS
      // CNUM
      // GAMMA
      // INV_GAMMA
      // INV_GAMMA1
      // INV_GAMMA2
      // NORMAL
      // UNIFORM
      // EPS
      // PDF
      // FIG
      // DR
      // NONE
      // PRIOR
      // PRIOR_VARIANCE
      // HESSIAN
      // IDENTITY_MATRIX
      // DIRICHLET
      // DIAGONAL
      // OPTIMAL
      // signed_integer
      // non_negative_number
      // signed_number
      // signed_inf
      // signed_number_w_inf
      // boolean
      // date_str
      // date_expr
      // name_value_pair
      // name_value_pair_list
      // name_value_pair_with_boolean
      // name_value_pair_with_boolean_list
      // name_value_pair_with_suboptions
      // name_value_pair_with_suboptions_list
      // filename
      // namespace_qualified_symbol
      // namespace_qualified_filename
      // range
      // integer_range
      // signed_integer_range
      // vec_value_1
      // vec_value
      // vec_value_list
      // vec_of_vec_value
      // vec_value_1_w_inf
      // vec_value_w_inf
      // symbol
      char dummy8[sizeof (string)];

      // occbin_constraints_regime
      char dummy9[sizeof (tuple<string, BinaryOpNode *, BinaryOpNode *, expr_t, expr_t>)];

      // prior_eq_opt
      // options_eq_opt
      char dummy10[sizeof (tuple<string,string,string,string>)];

      // matched_moments_list
      // value_list
      char dummy11[sizeof (vector<expr_t>)];

      // vec_int_number
      // vec_int_elem
      // vec_int_1
      // vec_int
      char dummy12[sizeof (vector<int>)];

      // period_list
      char dummy13[sizeof (vector<pair<int, int>>)];

      // named_var_1
      // named_var
      char dummy14[sizeof (vector<pair<string,string>>)];

      // SYMBOL_VEC
      // change_type_var_list
      // vec_str_1
      // vec_str
      char dummy15[sizeof (vector<string>)];

      // occbin_constraints_regimes_list
      char dummy16[sizeof (vector<tuple<string, BinaryOpNode *, BinaryOpNode *, expr_t, expr_t>>)];
    };

    /// The size of the largest semantic type.
    enum { size = sizeof (union_type) };

    /// A buffer to store semantic values.
    union
    {
      /// Strongest alignment constraints.
      long double yyalign_me;
      /// A buffer large enough to store any of the semantic values.
      char yyraw[size];
    } yybuffer_;

    /// Whether the content is built: if defined, the name of the stored type.
    const std::type_info *yytypeid_;
  };

#else
    typedef YYSTYPE semantic_type;
#endif
    /// Symbol locations.
    typedef location location_type;

    /// Syntax errors thrown from user actions.
    struct syntax_error : std::runtime_error
    {
      syntax_error (const location_type& l, const std::string& m)
        : std::runtime_error (m)
        , location (l)
      {}

      syntax_error (const syntax_error& s)
        : std::runtime_error (s.what ())
        , location (s.location)
      {}

      ~syntax_error () YY_NOEXCEPT YY_NOTHROW;

      location_type location;
    };

    /// Token kinds.
    struct token
    {
      enum token_kind_type
      {
        YYEMPTY = -2,
    YYEOF = 0,                     // "end of file"
    YYerror = 256,                 // error
    YYUNDEF = 257,                 // "invalid token"
    AIM_SOLVER = 258,              // AIM_SOLVER
    ANALYTIC_DERIVATION = 259,     // ANALYTIC_DERIVATION
    ANALYTIC_DERIVATION_MODE = 260, // ANALYTIC_DERIVATION_MODE
    AR = 261,                      // AR
    POSTERIOR_SAMPLING_METHOD = 262, // POSTERIOR_SAMPLING_METHOD
    BALANCED_GROWTH_TEST_TOL = 263, // BALANCED_GROWTH_TEST_TOL
    BAYESIAN_IRF = 264,            // BAYESIAN_IRF
    BETA_PDF = 265,                // BETA_PDF
    BLOCK = 266,                   // BLOCK
    USE_CALIBRATION = 267,         // USE_CALIBRATION
    SILENT_OPTIMIZER = 268,        // SILENT_OPTIMIZER
    BVAR_DENSITY = 269,            // BVAR_DENSITY
    BVAR_FORECAST = 270,           // BVAR_FORECAST
    NODECOMPOSITION = 271,         // NODECOMPOSITION
    DR_DISPLAY_TOL = 272,          // DR_DISPLAY_TOL
    HUGE_NUMBER = 273,             // HUGE_NUMBER
    FIG_NAME = 274,                // FIG_NAME
    WRITE_XLS = 275,               // WRITE_XLS
    BVAR_PRIOR_DECAY = 276,        // BVAR_PRIOR_DECAY
    BVAR_PRIOR_FLAT = 277,         // BVAR_PRIOR_FLAT
    BVAR_PRIOR_LAMBDA = 278,       // BVAR_PRIOR_LAMBDA
    INTERACTIVE = 279,             // INTERACTIVE
    SCREEN_SHOCKS = 280,           // SCREEN_SHOCKS
    STEADYSTATE = 281,             // STEADYSTATE
    BVAR_PRIOR_MU = 282,           // BVAR_PRIOR_MU
    BVAR_PRIOR_OMEGA = 283,        // BVAR_PRIOR_OMEGA
    BVAR_PRIOR_TAU = 284,          // BVAR_PRIOR_TAU
    BVAR_PRIOR_TRAIN = 285,        // BVAR_PRIOR_TRAIN
    DETAIL_PLOT = 286,             // DETAIL_PLOT
    TYPE = 287,                    // TYPE
    BVAR_REPLIC = 288,             // BVAR_REPLIC
    BYTECODE = 289,                // BYTECODE
    ALL_VALUES_REQUIRED = 290,     // ALL_VALUES_REQUIRED
    PROPOSAL_DISTRIBUTION = 291,   // PROPOSAL_DISTRIBUTION
    REALTIME = 292,                // REALTIME
    VINTAGE = 293,                 // VINTAGE
    CALIB_SMOOTHER = 294,          // CALIB_SMOOTHER
    CHANGE_TYPE = 295,             // CHANGE_TYPE
    CHECK = 296,                   // CHECK
    CONDITIONAL_FORECAST = 297,    // CONDITIONAL_FORECAST
    CONDITIONAL_FORECAST_PATHS = 298, // CONDITIONAL_FORECAST_PATHS
    CONF_SIG = 299,                // CONF_SIG
    CONSTANT = 300,                // CONSTANT
    CONTROLLED_VAREXO = 301,       // CONTROLLED_VAREXO
    CORR = 302,                    // CORR
    CUTOFF = 303,                  // CUTOFF
    CYCLE_REDUCTION = 304,         // CYCLE_REDUCTION
    LOGARITHMIC_REDUCTION = 305,   // LOGARITHMIC_REDUCTION
    COMMA = 306,                   // COMMA
    CONSIDER_ALL_ENDOGENOUS = 307, // CONSIDER_ALL_ENDOGENOUS
    CONSIDER_ALL_ENDOGENOUS_AND_AUXILIARY = 308, // CONSIDER_ALL_ENDOGENOUS_AND_AUXILIARY
    CONSIDER_ONLY_OBSERVED = 309,  // CONSIDER_ONLY_OBSERVED
    INITIAL_CONDITION_DECOMPOSITION = 310, // INITIAL_CONDITION_DECOMPOSITION
    DATAFILE = 311,                // DATAFILE
    FILE = 312,                    // FILE
    SERIES = 313,                  // SERIES
    DOUBLING = 314,                // DOUBLING
    DR_CYCLE_REDUCTION_TOL = 315,  // DR_CYCLE_REDUCTION_TOL
    DR_LOGARITHMIC_REDUCTION_TOL = 316, // DR_LOGARITHMIC_REDUCTION_TOL
    DR_LOGARITHMIC_REDUCTION_MAXITER = 317, // DR_LOGARITHMIC_REDUCTION_MAXITER
    DR_ALGO = 318,                 // DR_ALGO
    DROP = 319,                    // DROP
    DSAMPLE = 320,                 // DSAMPLE
    DYNASAVE = 321,                // DYNASAVE
    DYNATYPE = 322,                // DYNATYPE
    CALIBRATION = 323,             // CALIBRATION
    DIFFERENTIATE_FORWARD_VARS = 324, // DIFFERENTIATE_FORWARD_VARS
    END = 325,                     // END
    ENDVAL = 326,                  // ENDVAL
    EQUAL = 327,                   // EQUAL
    ESTIMATION = 328,              // ESTIMATION
    ESTIMATED_PARAMS = 329,        // ESTIMATED_PARAMS
    ESTIMATED_PARAMS_BOUNDS = 330, // ESTIMATED_PARAMS_BOUNDS
    ESTIMATED_PARAMS_INIT = 331,   // ESTIMATED_PARAMS_INIT
    EXTENDED_PATH = 332,           // EXTENDED_PATH
    ENDOGENOUS_PRIOR = 333,        // ENDOGENOUS_PRIOR
    EXPRESSION = 334,              // EXPRESSION
    FILENAME = 335,                // FILENAME
    DIRNAME = 336,                 // DIRNAME
    FILTER_STEP_AHEAD = 337,       // FILTER_STEP_AHEAD
    FILTERED_VARS = 338,           // FILTERED_VARS
    FIRST_OBS = 339,               // FIRST_OBS
    FIRST_SIMULATION_PERIOD = 340, // FIRST_SIMULATION_PERIOD
    LAST_OBS = 341,                // LAST_OBS
    SET_TIME = 342,                // SET_TIME
    OSR_PARAMS_BOUNDS = 343,       // OSR_PARAMS_BOUNDS
    KEEP_KALMAN_ALGO_IF_SINGULARITY_IS_DETECTED = 344, // KEEP_KALMAN_ALGO_IF_SINGULARITY_IS_DETECTED
    FALSE = 345,                   // FALSE
    FLOAT_NUMBER = 346,            // FLOAT_NUMBER
    DATES = 347,                   // DATES
    DEFAULT = 348,                 // DEFAULT
    FIXED_POINT = 349,             // FIXED_POINT
    FLIP = 350,                    // FLIP
    OPT_ALGO = 351,                // OPT_ALGO
    COMPILATION_SETUP = 352,       // COMPILATION_SETUP
    COMPILER = 353,                // COMPILER
    ADD_FLAGS = 354,               // ADD_FLAGS
    SUBSTITUTE_FLAGS = 355,        // SUBSTITUTE_FLAGS
    ADD_LIBS = 356,                // ADD_LIBS
    SUBSTITUTE_LIBS = 357,         // SUBSTITUTE_LIBS
    FORECAST = 358,                // FORECAST
    K_ORDER_SOLVER = 359,          // K_ORDER_SOLVER
    INSTRUMENTS = 360,             // INSTRUMENTS
    SHIFT = 361,                   // SHIFT
    MEAN = 362,                    // MEAN
    STDEV = 363,                   // STDEV
    VARIANCE = 364,                // VARIANCE
    MODE = 365,                    // MODE
    INTERVAL = 366,                // INTERVAL
    SHAPE = 367,                   // SHAPE
    DOMAINN = 368,                 // DOMAINN
    GAMMA_PDF = 369,               // GAMMA_PDF
    GRAPH = 370,                   // GRAPH
    GRAPH_FORMAT = 371,            // GRAPH_FORMAT
    CONDITIONAL_VARIANCE_DECOMPOSITION = 372, // CONDITIONAL_VARIANCE_DECOMPOSITION
    NOCHECK = 373,                 // NOCHECK
    STD = 374,                     // STD
    HISTVAL = 375,                 // HISTVAL
    HISTVAL_FILE = 376,            // HISTVAL_FILE
    HOMOTOPY_SETUP = 377,          // HOMOTOPY_SETUP
    HOMOTOPY_MODE = 378,           // HOMOTOPY_MODE
    HOMOTOPY_STEPS = 379,          // HOMOTOPY_STEPS
    HOMOTOPY_FORCE_CONTINUE = 380, // HOMOTOPY_FORCE_CONTINUE
    HP_FILTER = 381,               // HP_FILTER
    HP_NGRID = 382,                // HP_NGRID
    FILTERED_THEORETICAL_MOMENTS_GRID = 383, // FILTERED_THEORETICAL_MOMENTS_GRID
    HYBRID = 384,                  // HYBRID
    ONE_SIDED_HP_FILTER = 385,     // ONE_SIDED_HP_FILTER
    IDENTIFICATION = 386,          // IDENTIFICATION
    INF_CONSTANT = 387,            // INF_CONSTANT
    INITVAL = 388,                 // INITVAL
    INITVAL_FILE = 389,            // INITVAL_FILE
    BOUNDS = 390,                  // BOUNDS
    JSCALE = 391,                  // JSCALE
    INIT = 392,                    // INIT
    INFILE = 393,                  // INFILE
    INVARS = 394,                  // INVARS
    INT_NUMBER = 395,              // INT_NUMBER
    INV_GAMMA_PDF = 396,           // INV_GAMMA_PDF
    INV_GAMMA1_PDF = 397,          // INV_GAMMA1_PDF
    INV_GAMMA2_PDF = 398,          // INV_GAMMA2_PDF
    IRF = 399,                     // IRF
    IRF_SHOCKS = 400,              // IRF_SHOCKS
    IRF_PLOT_THRESHOLD = 401,      // IRF_PLOT_THRESHOLD
    IRF_CALIBRATION = 402,         // IRF_CALIBRATION
    FAST_KALMAN_FILTER = 403,      // FAST_KALMAN_FILTER
    KALMAN_ALGO = 404,             // KALMAN_ALGO
    KALMAN_TOL = 405,              // KALMAN_TOL
    DIFFUSE_KALMAN_TOL = 406,      // DIFFUSE_KALMAN_TOL
    SCHUR_VEC_TOL = 407,           // SCHUR_VEC_TOL
    SUBSAMPLES = 408,              // SUBSAMPLES
    OPTIONS = 409,                 // OPTIONS
    TOLF = 410,                    // TOLF
    TOLX = 411,                    // TOLX
    PLOT_INIT_DATE = 412,          // PLOT_INIT_DATE
    PLOT_END_DATE = 413,           // PLOT_END_DATE
    LAPLACE = 414,                 // LAPLACE
    LIK_ALGO = 415,                // LIK_ALGO
    LIK_INIT = 416,                // LIK_INIT
    LINEAR = 417,                  // LINEAR
    LINEAR_DECOMPOSITION = 418,    // LINEAR_DECOMPOSITION
    LOAD_IDENT_FILES = 419,        // LOAD_IDENT_FILES
    LOAD_MH_FILE = 420,            // LOAD_MH_FILE
    LOAD_RESULTS_AFTER_LOAD_MH = 421, // LOAD_RESULTS_AFTER_LOAD_MH
    LOAD_PARAMS_AND_STEADY_STATE = 422, // LOAD_PARAMS_AND_STEADY_STATE
    LOGLINEAR = 423,               // LOGLINEAR
    LOGDATA = 424,                 // LOGDATA
    LYAPUNOV = 425,                // LYAPUNOV
    LINEAR_APPROXIMATION = 426,    // LINEAR_APPROXIMATION
    LYAPUNOV_COMPLEX_THRESHOLD = 427, // LYAPUNOV_COMPLEX_THRESHOLD
    LYAPUNOV_FIXED_POINT_TOL = 428, // LYAPUNOV_FIXED_POINT_TOL
    LYAPUNOV_DOUBLING_TOL = 429,   // LYAPUNOV_DOUBLING_TOL
    LOG_DEFLATOR = 430,            // LOG_DEFLATOR
    LOG_TREND_VAR = 431,           // LOG_TREND_VAR
    LOG_GROWTH_FACTOR = 432,       // LOG_GROWTH_FACTOR
    MATCHED_MOMENTS = 433,         // MATCHED_MOMENTS
    MARKOWITZ = 434,               // MARKOWITZ
    MARGINAL_DENSITY = 435,        // MARGINAL_DENSITY
    MAX = 436,                     // MAX
    MAXIT = 437,                   // MAXIT
    MFS = 438,                     // MFS
    MH_CONF_SIG = 439,             // MH_CONF_SIG
    MH_DROP = 440,                 // MH_DROP
    MH_INIT_SCALE = 441,           // MH_INIT_SCALE
    MH_JSCALE = 442,               // MH_JSCALE
    MH_TUNE_JSCALE = 443,          // MH_TUNE_JSCALE
    MH_TUNE_GUESS = 444,           // MH_TUNE_GUESS
    MH_POSTERIOR_MODE_ESTIMATION = 445, // MH_POSTERIOR_MODE_ESTIMATION
    MH_NBLOCKS = 446,              // MH_NBLOCKS
    MH_REPLIC = 447,               // MH_REPLIC
    MH_RECOVER = 448,              // MH_RECOVER
    MH_INITIALIZE_FROM_PREVIOUS_MCMC = 449, // MH_INITIALIZE_FROM_PREVIOUS_MCMC
    MH_INITIALIZE_FROM_PREVIOUS_MCMC_DIRECTORY = 450, // MH_INITIALIZE_FROM_PREVIOUS_MCMC_DIRECTORY
    MH_INITIALIZE_FROM_PREVIOUS_MCMC_RECORD = 451, // MH_INITIALIZE_FROM_PREVIOUS_MCMC_RECORD
    MH_INITIALIZE_FROM_PREVIOUS_MCMC_PRIOR = 452, // MH_INITIALIZE_FROM_PREVIOUS_MCMC_PRIOR
    POSTERIOR_MAX_SUBSAMPLE_DRAWS = 453, // POSTERIOR_MAX_SUBSAMPLE_DRAWS
    MIN = 454,                     // MIN
    MINIMAL_SOLVING_PERIODS = 455, // MINIMAL_SOLVING_PERIODS
    MODE_CHECK = 456,              // MODE_CHECK
    MODE_CHECK_NEIGHBOURHOOD_SIZE = 457, // MODE_CHECK_NEIGHBOURHOOD_SIZE
    MODE_CHECK_SYMMETRIC_PLOTS = 458, // MODE_CHECK_SYMMETRIC_PLOTS
    MODE_CHECK_NUMBER_OF_POINTS = 459, // MODE_CHECK_NUMBER_OF_POINTS
    MODE_COMPUTE = 460,            // MODE_COMPUTE
    MODE_FILE = 461,               // MODE_FILE
    MODEL = 462,                   // MODEL
    MODEL_COMPARISON = 463,        // MODEL_COMPARISON
    MODEL_INFO = 464,              // MODEL_INFO
    MSHOCKS = 465,                 // MSHOCKS
    ABS = 466,                     // ABS
    SIGN = 467,                    // SIGN
    MODEL_DIAGNOSTICS = 468,       // MODEL_DIAGNOSTICS
    MODIFIEDHARMONICMEAN = 469,    // MODIFIEDHARMONICMEAN
    MOMENTS_VARENDO = 470,         // MOMENTS_VARENDO
    CONTEMPORANEOUS_CORRELATION = 471, // CONTEMPORANEOUS_CORRELATION
    DIFFUSE_FILTER = 472,          // DIFFUSE_FILTER
    SUB_DRAWS = 473,               // SUB_DRAWS
    TAPER_STEPS = 474,             // TAPER_STEPS
    GEWEKE_INTERVAL = 475,         // GEWEKE_INTERVAL
    RAFTERY_LEWIS_QRS = 476,       // RAFTERY_LEWIS_QRS
    RAFTERY_LEWIS_DIAGNOSTICS = 477, // RAFTERY_LEWIS_DIAGNOSTICS
    MCMC_JUMPING_COVARIANCE = 478, // MCMC_JUMPING_COVARIANCE
    MOMENT_CALIBRATION = 479,      // MOMENT_CALIBRATION
    NUMBER_OF_PARTICLES = 480,     // NUMBER_OF_PARTICLES
    RESAMPLING = 481,              // RESAMPLING
    SYSTEMATIC = 482,              // SYSTEMATIC
    GENERIC = 483,                 // GENERIC
    RESAMPLING_THRESHOLD = 484,    // RESAMPLING_THRESHOLD
    RESAMPLING_METHOD = 485,       // RESAMPLING_METHOD
    KITAGAWA = 486,                // KITAGAWA
    STRATIFIED = 487,              // STRATIFIED
    SMOOTH = 488,                  // SMOOTH
    CPF_WEIGHTS = 489,             // CPF_WEIGHTS
    AMISANOTRISTANI = 490,         // AMISANOTRISTANI
    MURRAYJONESPARSLOW = 491,      // MURRAYJONESPARSLOW
    WRITE_EQUATION_TAGS = 492,     // WRITE_EQUATION_TAGS
    FILTER_INITIAL_STATE = 493,    // FILTER_INITIAL_STATE
    NONLINEAR_FILTER_INITIALIZATION = 494, // NONLINEAR_FILTER_INITIALIZATION
    FILTER_ALGORITHM = 495,        // FILTER_ALGORITHM
    PROPOSAL_APPROXIMATION = 496,  // PROPOSAL_APPROXIMATION
    CUBATURE = 497,                // CUBATURE
    UNSCENTED = 498,               // UNSCENTED
    MONTECARLO = 499,              // MONTECARLO
    DISTRIBUTION_APPROXIMATION = 500, // DISTRIBUTION_APPROXIMATION
    NAME = 501,                    // NAME
    USE_PENALIZED_OBJECTIVE_FOR_HESSIAN = 502, // USE_PENALIZED_OBJECTIVE_FOR_HESSIAN
    INIT_STATE = 503,              // INIT_STATE
    FAST_REALTIME = 504,           // FAST_REALTIME
    RESCALE_PREDICTION_ERROR_COVARIANCE = 505, // RESCALE_PREDICTION_ERROR_COVARIANCE
    GENERATE_IRFS = 506,           // GENERATE_IRFS
    NAN_CONSTANT = 507,            // NAN_CONSTANT
    NO_STATIC = 508,               // NO_STATIC
    NOBS = 509,                    // NOBS
    NOCONSTANT = 510,              // NOCONSTANT
    NODISPLAY = 511,               // NODISPLAY
    NOCORR = 512,                  // NOCORR
    NODIAGNOSTIC = 513,            // NODIAGNOSTIC
    NOFUNCTIONS = 514,             // NOFUNCTIONS
    NO_HOMOTOPY = 515,             // NO_HOMOTOPY
    NOGRAPH = 516,                 // NOGRAPH
    POSTERIOR_NOGRAPH = 517,       // POSTERIOR_NOGRAPH
    POSTERIOR_GRAPH = 518,         // POSTERIOR_GRAPH
    NOMOMENTS = 519,               // NOMOMENTS
    NOPRINT = 520,                 // NOPRINT
    NORMAL_PDF = 521,              // NORMAL_PDF
    SAVE_DRAWS = 522,              // SAVE_DRAWS
    MODEL_NAME = 523,              // MODEL_NAME
    STDERR_MULTIPLES = 524,        // STDERR_MULTIPLES
    DIAGONAL_ONLY = 525,           // DIAGONAL_ONLY
    DETERMINISTIC_TRENDS = 526,    // DETERMINISTIC_TRENDS
    OBSERVATION_TRENDS = 527,      // OBSERVATION_TRENDS
    OPTIM = 528,                   // OPTIM
    OPTIM_WEIGHTS = 529,           // OPTIM_WEIGHTS
    ORDER = 530,                   // ORDER
    OSR = 531,                     // OSR
    OSR_PARAMS = 532,              // OSR_PARAMS
    MAX_DIM_COVA_GROUP = 533,      // MAX_DIM_COVA_GROUP
    ADVANCED = 534,                // ADVANCED
    OUTFILE = 535,                 // OUTFILE
    OUTVARS = 536,                 // OUTVARS
    OVERWRITE = 537,               // OVERWRITE
    DISCOUNT = 538,                // DISCOUNT
    PARALLEL_LOCAL_FILES = 539,    // PARALLEL_LOCAL_FILES
    PARAMETERS = 540,              // PARAMETERS
    PARAMETER_SET = 541,           // PARAMETER_SET
    PARTIAL_INFORMATION = 542,     // PARTIAL_INFORMATION
    PERIODS = 543,                 // PERIODS
    PERIOD = 544,                  // PERIOD
    PLANNER_OBJECTIVE = 545,       // PLANNER_OBJECTIVE
    PLOT_CONDITIONAL_FORECAST = 546, // PLOT_CONDITIONAL_FORECAST
    PLOT_PRIORS = 547,             // PLOT_PRIORS
    PREFILTER = 548,               // PREFILTER
    PRESAMPLE = 549,               // PRESAMPLE
    PERFECT_FORESIGHT_SETUP = 550, // PERFECT_FORESIGHT_SETUP
    PERFECT_FORESIGHT_SOLVER = 551, // PERFECT_FORESIGHT_SOLVER
    NO_POSTERIOR_KERNEL_DENSITY = 552, // NO_POSTERIOR_KERNEL_DENSITY
    FUNCTION = 553,                // FUNCTION
    PERFECT_FORESIGHT_WITH_EXPECTATION_ERRORS_SETUP = 554, // PERFECT_FORESIGHT_WITH_EXPECTATION_ERRORS_SETUP
    PERFECT_FORESIGHT_WITH_EXPECTATION_ERRORS_SOLVER = 555, // PERFECT_FORESIGHT_WITH_EXPECTATION_ERRORS_SOLVER
    PRINT = 556,                   // PRINT
    PRIOR_MC = 557,                // PRIOR_MC
    PRIOR_TRUNC = 558,             // PRIOR_TRUNC
    PRIOR_MODE = 559,              // PRIOR_MODE
    PRIOR_MEAN = 560,              // PRIOR_MEAN
    POSTERIOR_MODE = 561,          // POSTERIOR_MODE
    POSTERIOR_MEAN = 562,          // POSTERIOR_MEAN
    POSTERIOR_MEDIAN = 563,        // POSTERIOR_MEDIAN
    MLE_MODE = 564,                // MLE_MODE
    PRUNING = 565,                 // PRUNING
    PARTICLE_FILTER_OPTIONS = 566, // PARTICLE_FILTER_OPTIONS
    QUOTED_STRING = 567,           // QUOTED_STRING
    QZ_CRITERIUM = 568,            // QZ_CRITERIUM
    QZ_ZERO_THRESHOLD = 569,       // QZ_ZERO_THRESHOLD
    DSGE_VAR = 570,                // DSGE_VAR
    DSGE_VARLAG = 571,             // DSGE_VARLAG
    DSGE_PRIOR_WEIGHT = 572,       // DSGE_PRIOR_WEIGHT
    TRUNCATE = 573,                // TRUNCATE
    PIPE_E = 574,                  // PIPE_E
    PIPE_X = 575,                  // PIPE_X
    PIPE_P = 576,                  // PIPE_P
    RELATIVE_IRF = 577,            // RELATIVE_IRF
    REPLIC = 578,                  // REPLIC
    SIMUL_REPLIC = 579,            // SIMUL_REPLIC
    RPLOT = 580,                   // RPLOT
    SAVE_PARAMS_AND_STEADY_STATE = 581, // SAVE_PARAMS_AND_STEADY_STATE
    PARAMETER_UNCERTAINTY = 582,   // PARAMETER_UNCERTAINTY
    TARGETS = 583,                 // TARGETS
    SHOCKS = 584,                  // SHOCKS
    HETEROSKEDASTIC_SHOCKS = 585,  // HETEROSKEDASTIC_SHOCKS
    SHOCK_DECOMPOSITION = 586,     // SHOCK_DECOMPOSITION
    SHOCK_GROUPS = 587,            // SHOCK_GROUPS
    USE_SHOCK_GROUPS = 588,        // USE_SHOCK_GROUPS
    SIGMA_E = 589,                 // SIGMA_E
    SIMUL = 590,                   // SIMUL
    SIMUL_ALGO = 591,              // SIMUL_ALGO
    SIMUL_SEED = 592,              // SIMUL_SEED
    ENDOGENOUS_TERMINAL_PERIOD = 593, // ENDOGENOUS_TERMINAL_PERIOD
    SMOOTHER = 594,                // SMOOTHER
    SMOOTHER2HISTVAL = 595,        // SMOOTHER2HISTVAL
    SQUARE_ROOT_SOLVER = 596,      // SQUARE_ROOT_SOLVER
    STACK_SOLVE_ALGO = 597,        // STACK_SOLVE_ALGO
    STEADY_STATE_MODEL = 598,      // STEADY_STATE_MODEL
    SOLVE_ALGO = 599,              // SOLVE_ALGO
    SOLVER_PERIODS = 600,          // SOLVER_PERIODS
    ROBUST_LIN_SOLVE = 601,        // ROBUST_LIN_SOLVE
    STDERR = 602,                  // STDERR
    STEADY = 603,                  // STEADY
    STOCH_SIMUL = 604,             // STOCH_SIMUL
    SYLVESTER = 605,               // SYLVESTER
    SYLVESTER_FIXED_POINT_TOL = 606, // SYLVESTER_FIXED_POINT_TOL
    REGIMES = 607,                 // REGIMES
    REGIME = 608,                  // REGIME
    REALTIME_SHOCK_DECOMPOSITION = 609, // REALTIME_SHOCK_DECOMPOSITION
    CONDITIONAL = 610,             // CONDITIONAL
    UNCONDITIONAL = 611,           // UNCONDITIONAL
    TEX = 612,                     // TEX
    RAMSEY_MODEL = 613,            // RAMSEY_MODEL
    RAMSEY_POLICY = 614,           // RAMSEY_POLICY
    RAMSEY_CONSTRAINTS = 615,      // RAMSEY_CONSTRAINTS
    PLANNER_DISCOUNT = 616,        // PLANNER_DISCOUNT
    PLANNER_DISCOUNT_LATEX_NAME = 617, // PLANNER_DISCOUNT_LATEX_NAME
    DISCRETIONARY_POLICY = 618,    // DISCRETIONARY_POLICY
    DISCRETIONARY_TOL = 619,       // DISCRETIONARY_TOL
    EVALUATE_PLANNER_OBJECTIVE = 620, // EVALUATE_PLANNER_OBJECTIVE
    OCCBIN_SETUP = 621,            // OCCBIN_SETUP
    OCCBIN_SOLVER = 622,           // OCCBIN_SOLVER
    OCCBIN_WRITE_REGIMES = 623,    // OCCBIN_WRITE_REGIMES
    OCCBIN_GRAPH = 624,            // OCCBIN_GRAPH
    SIMUL_MAXIT = 625,             // SIMUL_MAXIT
    LIKELIHOOD_MAXIT = 626,        // LIKELIHOOD_MAXIT
    SMOOTHER_MAXIT = 627,          // SMOOTHER_MAXIT
    SIMUL_PERIODS = 628,           // SIMUL_PERIODS
    LIKELIHOOD_PERIODS = 629,      // LIKELIHOOD_PERIODS
    SMOOTHER_PERIODS = 630,        // SMOOTHER_PERIODS
    SIMUL_CURB_RETRENCH = 631,     // SIMUL_CURB_RETRENCH
    LIKELIHOOD_CURB_RETRENCH = 632, // LIKELIHOOD_CURB_RETRENCH
    SMOOTHER_CURB_RETRENCH = 633,  // SMOOTHER_CURB_RETRENCH
    SIMUL_CHECK_AHEAD_PERIODS = 634, // SIMUL_CHECK_AHEAD_PERIODS
    LIKELIHOOD_CHECK_AHEAD_PERIODS = 635, // LIKELIHOOD_CHECK_AHEAD_PERIODS
    SMOOTHER_CHECK_AHEAD_PERIODS = 636, // SMOOTHER_CHECK_AHEAD_PERIODS
    SIMUL_DEBUG = 637,             // SIMUL_DEBUG
    SMOOTHER_DEBUG = 638,          // SMOOTHER_DEBUG
    SIMUL_PERIODIC_SOLUTION = 639, // SIMUL_PERIODIC_SOLUTION
    LIKELIHOOD_PERIODIC_SOLUTION = 640, // LIKELIHOOD_PERIODIC_SOLUTION
    SMOOTHER_PERIODIC_SOLUTION = 641, // SMOOTHER_PERIODIC_SOLUTION
    LIKELIHOOD_INVERSION_FILTER = 642, // LIKELIHOOD_INVERSION_FILTER
    SMOOTHER_INVERSION_FILTER = 643, // SMOOTHER_INVERSION_FILTER
    FILTER_USE_RELEXATION = 644,   // FILTER_USE_RELEXATION
    LIKELIHOOD_PIECEWISE_KALMAN_FILTER = 645, // LIKELIHOOD_PIECEWISE_KALMAN_FILTER
    SMOOTHER_PIECEWISE_KALMAN_FILTER = 646, // SMOOTHER_PIECEWISE_KALMAN_FILTER
    LIKELIHOOD_MAX_KALMAN_ITERATIONS = 647, // LIKELIHOOD_MAX_KALMAN_ITERATIONS
    TEX_NAME = 648,                // TEX_NAME
    TRUE = 649,                    // TRUE
    BIND = 650,                    // BIND
    RELAX = 651,                   // RELAX
    ERROR_BIND = 652,              // ERROR_BIND
    ERROR_RELAX = 653,             // ERROR_RELAX
    UNIFORM_PDF = 654,             // UNIFORM_PDF
    UNIT_ROOT_VARS = 655,          // UNIT_ROOT_VARS
    USE_DLL = 656,                 // USE_DLL
    USEAUTOCORR = 657,             // USEAUTOCORR
    GSA_SAMPLE_FILE = 658,         // GSA_SAMPLE_FILE
    USE_UNIVARIATE_FILTERS_IF_SINGULARITY_IS_DETECTED = 659, // USE_UNIVARIATE_FILTERS_IF_SINGULARITY_IS_DETECTED
    VALUES = 660,                  // VALUES
    SCALES = 661,                  // SCALES
    VAR = 662,                     // VAR
    VAREXO = 663,                  // VAREXO
    VAREXO_DET = 664,              // VAREXO_DET
    VARIABLE = 665,                // VARIABLE
    VAROBS = 666,                  // VAROBS
    VAREXOBS = 667,                // VAREXOBS
    PREDETERMINED_VARIABLES = 668, // PREDETERMINED_VARIABLES
    VAR_EXPECTATION = 669,         // VAR_EXPECTATION
    VAR_EXPECTATION_MODEL = 670,   // VAR_EXPECTATION_MODEL
    PLOT_SHOCK_DECOMPOSITION = 671, // PLOT_SHOCK_DECOMPOSITION
    MODEL_LOCAL_VARIABLE = 672,    // MODEL_LOCAL_VARIABLE
    WRITE_LATEX_DYNAMIC_MODEL = 673, // WRITE_LATEX_DYNAMIC_MODEL
    WRITE_LATEX_STATIC_MODEL = 674, // WRITE_LATEX_STATIC_MODEL
    WRITE_LATEX_ORIGINAL_MODEL = 675, // WRITE_LATEX_ORIGINAL_MODEL
    WRITE_LATEX_STEADY_STATE_MODEL = 676, // WRITE_LATEX_STEADY_STATE_MODEL
    XLS_SHEET = 677,               // XLS_SHEET
    XLS_RANGE = 678,               // XLS_RANGE
    LMMCP = 679,                   // LMMCP
    BANDPASS_FILTER = 680,         // BANDPASS_FILTER
    COLORMAP = 681,                // COLORMAP
    VAR_MODEL = 682,               // VAR_MODEL
    PAC_MODEL = 683,               // PAC_MODEL
    QOQ = 684,                     // QOQ
    YOY = 685,                     // YOY
    AOA = 686,                     // AOA
    PAC_EXPECTATION = 687,         // PAC_EXPECTATION
    TREND_COMPONENT_MODEL = 688,   // TREND_COMPONENT_MODEL
    EQUAL_EQUAL = 689,             // EQUAL_EQUAL
    EXCLAMATION_EQUAL = 690,       // EXCLAMATION_EQUAL
    LESS = 691,                    // LESS
    GREATER = 692,                 // GREATER
    LESS_EQUAL = 693,              // LESS_EQUAL
    GREATER_EQUAL = 694,           // GREATER_EQUAL
    PLUS = 695,                    // PLUS
    MINUS = 696,                   // MINUS
    TIMES = 697,                   // TIMES
    DIVIDE = 698,                  // DIVIDE
    UNARY = 699,                   // UNARY
    POWER = 700,                   // POWER
    EXP = 701,                     // EXP
    LOG = 702,                     // LOG
    LN = 703,                      // LN
    LOG10 = 704,                   // LOG10
    SIN = 705,                     // SIN
    COS = 706,                     // COS
    TAN = 707,                     // TAN
    ASIN = 708,                    // ASIN
    ACOS = 709,                    // ACOS
    ATAN = 710,                    // ATAN
    ERF = 711,                     // ERF
    DIFF = 712,                    // DIFF
    ADL = 713,                     // ADL
    AUXILIARY_MODEL_NAME = 714,    // AUXILIARY_MODEL_NAME
    SQRT = 715,                    // SQRT
    CBRT = 716,                    // CBRT
    NORMCDF = 717,                 // NORMCDF
    NORMPDF = 718,                 // NORMPDF
    STEADY_STATE = 719,            // STEADY_STATE
    EXPECTATION = 720,             // EXPECTATION
    DYNARE_SENSITIVITY = 721,      // DYNARE_SENSITIVITY
    MORRIS = 722,                  // MORRIS
    STAB = 723,                    // STAB
    REDFORM = 724,                 // REDFORM
    PPRIOR = 725,                  // PPRIOR
    PRIOR_RANGE = 726,             // PRIOR_RANGE
    PPOST = 727,                   // PPOST
    ILPTAU = 728,                  // ILPTAU
    MORRIS_NLIV = 729,             // MORRIS_NLIV
    MORRIS_NTRA = 730,             // MORRIS_NTRA
    NSAM = 731,                    // NSAM
    LOAD_REDFORM = 732,            // LOAD_REDFORM
    LOAD_RMSE = 733,               // LOAD_RMSE
    LOAD_STAB = 734,               // LOAD_STAB
    ALPHA2_STAB = 735,             // ALPHA2_STAB
    LOGTRANS_REDFORM = 736,        // LOGTRANS_REDFORM
    THRESHOLD_REDFORM = 737,       // THRESHOLD_REDFORM
    KSSTAT_REDFORM = 738,          // KSSTAT_REDFORM
    ALPHA2_REDFORM = 739,          // ALPHA2_REDFORM
    NAMENDO = 740,                 // NAMENDO
    NAMLAGENDO = 741,              // NAMLAGENDO
    NAMEXO = 742,                  // NAMEXO
    RMSE = 743,                    // RMSE
    LIK_ONLY = 744,                // LIK_ONLY
    VAR_RMSE = 745,                // VAR_RMSE
    PFILT_RMSE = 746,              // PFILT_RMSE
    ISTART_RMSE = 747,             // ISTART_RMSE
    ALPHA_RMSE = 748,              // ALPHA_RMSE
    ALPHA2_RMSE = 749,             // ALPHA2_RMSE
    FREQ = 750,                    // FREQ
    INITIAL_YEAR = 751,            // INITIAL_YEAR
    INITIAL_SUBPERIOD = 752,       // INITIAL_SUBPERIOD
    FINAL_YEAR = 753,              // FINAL_YEAR
    FINAL_SUBPERIOD = 754,         // FINAL_SUBPERIOD
    DATA = 755,                    // DATA
    VLIST = 756,                   // VLIST
    VLISTLOG = 757,                // VLISTLOG
    VLISTPER = 758,                // VLISTPER
    SPECTRAL_DENSITY = 759,        // SPECTRAL_DENSITY
    INIT2SHOCKS = 760,             // INIT2SHOCKS
    RESTRICTION = 761,             // RESTRICTION
    RESTRICTION_FNAME = 762,       // RESTRICTION_FNAME
    CROSS_RESTRICTIONS = 763,      // CROSS_RESTRICTIONS
    NLAGS = 764,                   // NLAGS
    CONTEMP_REDUCED_FORM = 765,    // CONTEMP_REDUCED_FORM
    REAL_PSEUDO_FORECAST = 766,    // REAL_PSEUDO_FORECAST
    DUMMY_OBS = 767,               // DUMMY_OBS
    NSTATES = 768,                 // NSTATES
    INDXSCALESSTATES = 769,        // INDXSCALESSTATES
    NO_BAYESIAN_PRIOR = 770,       // NO_BAYESIAN_PRIOR
    SPECIFICATION = 771,           // SPECIFICATION
    SIMS_ZHA = 772,                // SIMS_ZHA
    ALPHA = 773,                   // ALPHA
    BETA = 774,                    // BETA
    ABAND = 775,                   // ABAND
    NINV = 776,                    // NINV
    CMS = 777,                     // CMS
    NCMS = 778,                    // NCMS
    CNUM = 779,                    // CNUM
    GAMMA = 780,                   // GAMMA
    INV_GAMMA = 781,               // INV_GAMMA
    INV_GAMMA1 = 782,              // INV_GAMMA1
    INV_GAMMA2 = 783,              // INV_GAMMA2
    NORMAL = 784,                  // NORMAL
    UNIFORM = 785,                 // UNIFORM
    EPS = 786,                     // EPS
    PDF = 787,                     // PDF
    FIG = 788,                     // FIG
    DR = 789,                      // DR
    NONE = 790,                    // NONE
    PRIOR = 791,                   // PRIOR
    PRIOR_VARIANCE = 792,          // PRIOR_VARIANCE
    HESSIAN = 793,                 // HESSIAN
    IDENTITY_MATRIX = 794,         // IDENTITY_MATRIX
    DIRICHLET = 795,               // DIRICHLET
    DIAGONAL = 796,                // DIAGONAL
    OPTIMAL = 797,                 // OPTIMAL
    GSIG2_LMDM = 798,              // GSIG2_LMDM
    Q_DIAG = 799,                  // Q_DIAG
    FLAT_PRIOR = 800,              // FLAT_PRIOR
    NCSK = 801,                    // NCSK
    NSTD = 802,                    // NSTD
    WEIBULL = 803,                 // WEIBULL
    WEIBULL_PDF = 804,             // WEIBULL_PDF
    GMM = 805,                     // GMM
    SMM = 806,                     // SMM
    INDXPARR = 807,                // INDXPARR
    INDXOVR = 808,                 // INDXOVR
    INDXAP = 809,                  // INDXAP
    APBAND = 810,                  // APBAND
    INDXIMF = 811,                 // INDXIMF
    INDXFORE = 812,                // INDXFORE
    FOREBAND = 813,                // FOREBAND
    INDXGFOREHAT = 814,            // INDXGFOREHAT
    INDXGIMFHAT = 815,             // INDXGIMFHAT
    INDXESTIMA = 816,              // INDXESTIMA
    INDXGDLS = 817,                // INDXGDLS
    EQ_MS = 818,                   // EQ_MS
    FILTER_COVARIANCE = 819,       // FILTER_COVARIANCE
    FILTER_DECOMPOSITION = 820,    // FILTER_DECOMPOSITION
    SMOOTHED_STATE_UNCERTAINTY = 821, // SMOOTHED_STATE_UNCERTAINTY
    SMOOTHER_REDUX = 822,          // SMOOTHER_REDUX
    EQ_CMS = 823,                  // EQ_CMS
    TLINDX = 824,                  // TLINDX
    TLNUMBER = 825,                // TLNUMBER
    RESTRICTIONS = 826,            // RESTRICTIONS
    POSTERIOR_SAMPLER_OPTIONS = 827, // POSTERIOR_SAMPLER_OPTIONS
    OUTPUT_FILE_TAG = 828,         // OUTPUT_FILE_TAG
    HORIZON = 829,                 // HORIZON
    SBVAR = 830,                   // SBVAR
    TREND_VAR = 831,               // TREND_VAR
    DEFLATOR = 832,                // DEFLATOR
    GROWTH_FACTOR = 833,           // GROWTH_FACTOR
    MS_IRF = 834,                  // MS_IRF
    MS_VARIANCE_DECOMPOSITION = 835, // MS_VARIANCE_DECOMPOSITION
    GROWTH = 836,                  // GROWTH
    MS_ESTIMATION = 837,           // MS_ESTIMATION
    MS_SIMULATION = 838,           // MS_SIMULATION
    MS_COMPUTE_MDD = 839,          // MS_COMPUTE_MDD
    MS_COMPUTE_PROBABILITIES = 840, // MS_COMPUTE_PROBABILITIES
    MS_FORECAST = 841,             // MS_FORECAST
    SVAR_IDENTIFICATION = 842,     // SVAR_IDENTIFICATION
    EQUATION = 843,                // EQUATION
    EXCLUSION = 844,               // EXCLUSION
    LAG = 845,                     // LAG
    UPPER_CHOLESKY = 846,          // UPPER_CHOLESKY
    LOWER_CHOLESKY = 847,          // LOWER_CHOLESKY
    MONTHLY = 848,                 // MONTHLY
    QUARTERLY = 849,               // QUARTERLY
    MARKOV_SWITCHING = 850,        // MARKOV_SWITCHING
    CHAIN = 851,                   // CHAIN
    DURATION = 852,                // DURATION
    NUMBER_OF_REGIMES = 853,       // NUMBER_OF_REGIMES
    NUMBER_OF_LAGS = 854,          // NUMBER_OF_LAGS
    EPILOGUE = 855,                // EPILOGUE
    SVAR = 856,                    // SVAR
    SVAR_GLOBAL_IDENTIFICATION_CHECK = 857, // SVAR_GLOBAL_IDENTIFICATION_CHECK
    COEFF = 858,                   // COEFF
    COEFFICIENTS = 859,            // COEFFICIENTS
    VARIANCES = 860,               // VARIANCES
    CONSTANTS = 861,               // CONSTANTS
    EQUATIONS = 862,               // EQUATIONS
    EXTERNAL_FUNCTION = 863,       // EXTERNAL_FUNCTION
    EXT_FUNC_NAME = 864,           // EXT_FUNC_NAME
    EXT_FUNC_NARGS = 865,          // EXT_FUNC_NARGS
    FIRST_DERIV_PROVIDED = 866,    // FIRST_DERIV_PROVIDED
    SECOND_DERIV_PROVIDED = 867,   // SECOND_DERIV_PROVIDED
    SELECTED_VARIABLES_ONLY = 868, // SELECTED_VARIABLES_ONLY
    COVA_COMPUTE = 869,            // COVA_COMPUTE
    SIMULATION_FILE_TAG = 870,     // SIMULATION_FILE_TAG
    FILE_TAG = 871,                // FILE_TAG
    NO_ERROR_BANDS = 872,          // NO_ERROR_BANDS
    ERROR_BAND_PERCENTILES = 873,  // ERROR_BAND_PERCENTILES
    SHOCKS_PER_PARAMETER = 874,    // SHOCKS_PER_PARAMETER
    NO_CREATE_INIT = 875,          // NO_CREATE_INIT
    SHOCK_DRAWS = 876,             // SHOCK_DRAWS
    FREE_PARAMETERS = 877,         // FREE_PARAMETERS
    MEDIAN = 878,                  // MEDIAN
    DATA_OBS_NBR = 879,            // DATA_OBS_NBR
    NEIGHBORHOOD_WIDTH = 880,      // NEIGHBORHOOD_WIDTH
    PVALUE_KS = 881,               // PVALUE_KS
    PVALUE_CORR = 882,             // PVALUE_CORR
    FILTERED_PROBABILITIES = 883,  // FILTERED_PROBABILITIES
    REAL_TIME_SMOOTHED = 884,      // REAL_TIME_SMOOTHED
    PRIOR_FUNCTION = 885,          // PRIOR_FUNCTION
    POSTERIOR_FUNCTION = 886,      // POSTERIOR_FUNCTION
    SAMPLING_DRAWS = 887,          // SAMPLING_DRAWS
    PROPOSAL_TYPE = 888,           // PROPOSAL_TYPE
    PROPOSAL_UPPER_BOUND = 889,    // PROPOSAL_UPPER_BOUND
    PROPOSAL_LOWER_BOUND = 890,    // PROPOSAL_LOWER_BOUND
    PROPOSAL_DRAWS = 891,          // PROPOSAL_DRAWS
    USE_MEAN_CENTER = 892,         // USE_MEAN_CENTER
    ADAPTIVE_MH_DRAWS = 893,       // ADAPTIVE_MH_DRAWS
    THINNING_FACTOR = 894,         // THINNING_FACTOR
    COEFFICIENTS_PRIOR_HYPERPARAMETERS = 895, // COEFFICIENTS_PRIOR_HYPERPARAMETERS
    CONVERGENCE_STARTING_VALUE = 896, // CONVERGENCE_STARTING_VALUE
    CONVERGENCE_ENDING_VALUE = 897, // CONVERGENCE_ENDING_VALUE
    CONVERGENCE_INCREMENT_VALUE = 898, // CONVERGENCE_INCREMENT_VALUE
    MAX_ITERATIONS_STARTING_VALUE = 899, // MAX_ITERATIONS_STARTING_VALUE
    MAX_ITERATIONS_INCREMENT_VALUE = 900, // MAX_ITERATIONS_INCREMENT_VALUE
    MAX_BLOCK_ITERATIONS = 901,    // MAX_BLOCK_ITERATIONS
    MAX_REPEATED_OPTIMIZATION_RUNS = 902, // MAX_REPEATED_OPTIMIZATION_RUNS
    FUNCTION_CONVERGENCE_CRITERION = 903, // FUNCTION_CONVERGENCE_CRITERION
    SAVE_REALTIME = 904,           // SAVE_REALTIME
    PARAMETER_CONVERGENCE_CRITERION = 905, // PARAMETER_CONVERGENCE_CRITERION
    NUMBER_OF_LARGE_PERTURBATIONS = 906, // NUMBER_OF_LARGE_PERTURBATIONS
    NUMBER_OF_SMALL_PERTURBATIONS = 907, // NUMBER_OF_SMALL_PERTURBATIONS
    NUMBER_OF_POSTERIOR_DRAWS_AFTER_PERTURBATION = 908, // NUMBER_OF_POSTERIOR_DRAWS_AFTER_PERTURBATION
    MAX_NUMBER_OF_STAGES = 909,    // MAX_NUMBER_OF_STAGES
    RANDOM_FUNCTION_CONVERGENCE_CRITERION = 910, // RANDOM_FUNCTION_CONVERGENCE_CRITERION
    RANDOM_PARAMETER_CONVERGENCE_CRITERION = 911, // RANDOM_PARAMETER_CONVERGENCE_CRITERION
    NO_INIT_ESTIMATION_CHECK_FIRST_OBS = 912, // NO_INIT_ESTIMATION_CHECK_FIRST_OBS
    HETEROSKEDASTIC_FILTER = 913,  // HETEROSKEDASTIC_FILTER
    TIME_SHIFT = 914,              // TIME_SHIFT
    STRUCTURAL = 915,              // STRUCTURAL
    TERMINAL_STEADY_STATE_AS_GUESS_VALUE = 916, // TERMINAL_STEADY_STATE_AS_GUESS_VALUE
    SURPRISE = 917,                // SURPRISE
    OCCBIN_CONSTRAINTS = 918,      // OCCBIN_CONSTRAINTS
    METHOD_OF_MOMENTS = 919,       // METHOD_OF_MOMENTS
    MOM_METHOD = 920,              // MOM_METHOD
    BARTLETT_KERNEL_LAG = 921,     // BARTLETT_KERNEL_LAG
    WEIGHTING_MATRIX = 922,        // WEIGHTING_MATRIX
    WEIGHTING_MATRIX_SCALING_FACTOR = 923, // WEIGHTING_MATRIX_SCALING_FACTOR
    ANALYTIC_STANDARD_ERRORS = 924, // ANALYTIC_STANDARD_ERRORS
    ANALYTIC_JACOBIAN = 925,       // ANALYTIC_JACOBIAN
    PENALIZED_ESTIMATOR = 926,     // PENALIZED_ESTIMATOR
    VERBOSE = 927,                 // VERBOSE
    SIMULATION_MULTIPLE = 928,     // SIMULATION_MULTIPLE
    MOM_SEED = 929,                // MOM_SEED
    SEED = 930,                    // SEED
    BOUNDED_SHOCK_SUPPORT = 931,   // BOUNDED_SHOCK_SUPPORT
    ADDITIONAL_OPTIMIZER_STEPS = 932, // ADDITIONAL_OPTIMIZER_STEPS
    MOM_SE_TOLX = 933,             // MOM_SE_TOLX
    SE_TOLX = 934,                 // SE_TOLX
    MOM_BURNIN = 935,              // MOM_BURNIN
    BURNIN = 936,                  // BURNIN
    EQTAGS = 937,                  // EQTAGS
    ANALYTICAL_GIRF = 938,         // ANALYTICAL_GIRF
    IRF_IN_PERCENT = 939,          // IRF_IN_PERCENT
    EMAS_GIRF = 940,               // EMAS_GIRF
    EMAS_DROP = 941,               // EMAS_DROP
    EMAS_TOLF = 942,               // EMAS_TOLF
    EMAS_MAX_ITER = 943,           // EMAS_MAX_ITER
    NO_IDENTIFICATION_STRENGTH = 944, // NO_IDENTIFICATION_STRENGTH
    NO_IDENTIFICATION_REDUCEDFORM = 945, // NO_IDENTIFICATION_REDUCEDFORM
    NO_IDENTIFICATION_MOMENTS = 946, // NO_IDENTIFICATION_MOMENTS
    NO_IDENTIFICATION_MINIMAL = 947, // NO_IDENTIFICATION_MINIMAL
    NO_IDENTIFICATION_SPECTRUM = 948, // NO_IDENTIFICATION_SPECTRUM
    NORMALIZE_JACOBIANS = 949,     // NORMALIZE_JACOBIANS
    GRID_NBR = 950,                // GRID_NBR
    TOL_RANK = 951,                // TOL_RANK
    TOL_DERIV = 952,               // TOL_DERIV
    TOL_SV = 953,                  // TOL_SV
    CHECKS_VIA_SUBSETS = 954,      // CHECKS_VIA_SUBSETS
    MAX_DIM_SUBSETS_GROUPS = 955,  // MAX_DIM_SUBSETS_GROUPS
    ZERO_MOMENTS_TOLERANCE = 956,  // ZERO_MOMENTS_TOLERANCE
    MAX_NROWS = 957,               // MAX_NROWS
    SQUEEZE_SHOCK_DECOMPOSITION = 958, // SQUEEZE_SHOCK_DECOMPOSITION
    WITH_EPILOGUE = 959,           // WITH_EPILOGUE
    STATIC = 960,                  // STATIC
    INCIDENCE = 961,               // INCIDENCE
    SYMBOL_VEC = 962               // SYMBOL_VEC
      };
      /// Backward compatibility alias (Bison 3.6).
      typedef token_kind_type yytokentype;
    };

    /// Token kind, as returned by yylex.
    typedef token::yytokentype token_kind_type;

    /// Backward compatibility alias (Bison 3.6).
    typedef token_kind_type token_type;

    /// Symbol kinds.
    struct symbol_kind
    {
      enum symbol_kind_type
      {
        YYNTOKENS = 716, ///< Number of tokens.
        S_YYEMPTY = -2,
        S_YYEOF = 0,                             // "end of file"
        S_YYerror = 1,                           // error
        S_YYUNDEF = 2,                           // "invalid token"
        S_AIM_SOLVER = 3,                        // AIM_SOLVER
        S_ANALYTIC_DERIVATION = 4,               // ANALYTIC_DERIVATION
        S_ANALYTIC_DERIVATION_MODE = 5,          // ANALYTIC_DERIVATION_MODE
        S_AR = 6,                                // AR
        S_POSTERIOR_SAMPLING_METHOD = 7,         // POSTERIOR_SAMPLING_METHOD
        S_BALANCED_GROWTH_TEST_TOL = 8,          // BALANCED_GROWTH_TEST_TOL
        S_BAYESIAN_IRF = 9,                      // BAYESIAN_IRF
        S_BETA_PDF = 10,                         // BETA_PDF
        S_BLOCK = 11,                            // BLOCK
        S_USE_CALIBRATION = 12,                  // USE_CALIBRATION
        S_SILENT_OPTIMIZER = 13,                 // SILENT_OPTIMIZER
        S_BVAR_DENSITY = 14,                     // BVAR_DENSITY
        S_BVAR_FORECAST = 15,                    // BVAR_FORECAST
        S_NODECOMPOSITION = 16,                  // NODECOMPOSITION
        S_DR_DISPLAY_TOL = 17,                   // DR_DISPLAY_TOL
        S_HUGE_NUMBER = 18,                      // HUGE_NUMBER
        S_FIG_NAME = 19,                         // FIG_NAME
        S_WRITE_XLS = 20,                        // WRITE_XLS
        S_BVAR_PRIOR_DECAY = 21,                 // BVAR_PRIOR_DECAY
        S_BVAR_PRIOR_FLAT = 22,                  // BVAR_PRIOR_FLAT
        S_BVAR_PRIOR_LAMBDA = 23,                // BVAR_PRIOR_LAMBDA
        S_INTERACTIVE = 24,                      // INTERACTIVE
        S_SCREEN_SHOCKS = 25,                    // SCREEN_SHOCKS
        S_STEADYSTATE = 26,                      // STEADYSTATE
        S_BVAR_PRIOR_MU = 27,                    // BVAR_PRIOR_MU
        S_BVAR_PRIOR_OMEGA = 28,                 // BVAR_PRIOR_OMEGA
        S_BVAR_PRIOR_TAU = 29,                   // BVAR_PRIOR_TAU
        S_BVAR_PRIOR_TRAIN = 30,                 // BVAR_PRIOR_TRAIN
        S_DETAIL_PLOT = 31,                      // DETAIL_PLOT
        S_TYPE = 32,                             // TYPE
        S_BVAR_REPLIC = 33,                      // BVAR_REPLIC
        S_BYTECODE = 34,                         // BYTECODE
        S_ALL_VALUES_REQUIRED = 35,              // ALL_VALUES_REQUIRED
        S_PROPOSAL_DISTRIBUTION = 36,            // PROPOSAL_DISTRIBUTION
        S_REALTIME = 37,                         // REALTIME
        S_VINTAGE = 38,                          // VINTAGE
        S_CALIB_SMOOTHER = 39,                   // CALIB_SMOOTHER
        S_CHANGE_TYPE = 40,                      // CHANGE_TYPE
        S_CHECK = 41,                            // CHECK
        S_CONDITIONAL_FORECAST = 42,             // CONDITIONAL_FORECAST
        S_CONDITIONAL_FORECAST_PATHS = 43,       // CONDITIONAL_FORECAST_PATHS
        S_CONF_SIG = 44,                         // CONF_SIG
        S_CONSTANT = 45,                         // CONSTANT
        S_CONTROLLED_VAREXO = 46,                // CONTROLLED_VAREXO
        S_CORR = 47,                             // CORR
        S_CUTOFF = 48,                           // CUTOFF
        S_CYCLE_REDUCTION = 49,                  // CYCLE_REDUCTION
        S_LOGARITHMIC_REDUCTION = 50,            // LOGARITHMIC_REDUCTION
        S_COMMA = 51,                            // COMMA
        S_CONSIDER_ALL_ENDOGENOUS = 52,          // CONSIDER_ALL_ENDOGENOUS
        S_CONSIDER_ALL_ENDOGENOUS_AND_AUXILIARY = 53, // CONSIDER_ALL_ENDOGENOUS_AND_AUXILIARY
        S_CONSIDER_ONLY_OBSERVED = 54,           // CONSIDER_ONLY_OBSERVED
        S_INITIAL_CONDITION_DECOMPOSITION = 55,  // INITIAL_CONDITION_DECOMPOSITION
        S_DATAFILE = 56,                         // DATAFILE
        S_FILE = 57,                             // FILE
        S_SERIES = 58,                           // SERIES
        S_DOUBLING = 59,                         // DOUBLING
        S_DR_CYCLE_REDUCTION_TOL = 60,           // DR_CYCLE_REDUCTION_TOL
        S_DR_LOGARITHMIC_REDUCTION_TOL = 61,     // DR_LOGARITHMIC_REDUCTION_TOL
        S_DR_LOGARITHMIC_REDUCTION_MAXITER = 62, // DR_LOGARITHMIC_REDUCTION_MAXITER
        S_DR_ALGO = 63,                          // DR_ALGO
        S_DROP = 64,                             // DROP
        S_DSAMPLE = 65,                          // DSAMPLE
        S_DYNASAVE = 66,                         // DYNASAVE
        S_DYNATYPE = 67,                         // DYNATYPE
        S_CALIBRATION = 68,                      // CALIBRATION
        S_DIFFERENTIATE_FORWARD_VARS = 69,       // DIFFERENTIATE_FORWARD_VARS
        S_END = 70,                              // END
        S_ENDVAL = 71,                           // ENDVAL
        S_EQUAL = 72,                            // EQUAL
        S_ESTIMATION = 73,                       // ESTIMATION
        S_ESTIMATED_PARAMS = 74,                 // ESTIMATED_PARAMS
        S_ESTIMATED_PARAMS_BOUNDS = 75,          // ESTIMATED_PARAMS_BOUNDS
        S_ESTIMATED_PARAMS_INIT = 76,            // ESTIMATED_PARAMS_INIT
        S_EXTENDED_PATH = 77,                    // EXTENDED_PATH
        S_ENDOGENOUS_PRIOR = 78,                 // ENDOGENOUS_PRIOR
        S_EXPRESSION = 79,                       // EXPRESSION
        S_FILENAME = 80,                         // FILENAME
        S_DIRNAME = 81,                          // DIRNAME
        S_FILTER_STEP_AHEAD = 82,                // FILTER_STEP_AHEAD
        S_FILTERED_VARS = 83,                    // FILTERED_VARS
        S_FIRST_OBS = 84,                        // FIRST_OBS
        S_FIRST_SIMULATION_PERIOD = 85,          // FIRST_SIMULATION_PERIOD
        S_LAST_OBS = 86,                         // LAST_OBS
        S_SET_TIME = 87,                         // SET_TIME
        S_OSR_PARAMS_BOUNDS = 88,                // OSR_PARAMS_BOUNDS
        S_KEEP_KALMAN_ALGO_IF_SINGULARITY_IS_DETECTED = 89, // KEEP_KALMAN_ALGO_IF_SINGULARITY_IS_DETECTED
        S_FALSE = 90,                            // FALSE
        S_FLOAT_NUMBER = 91,                     // FLOAT_NUMBER
        S_DATES = 92,                            // DATES
        S_DEFAULT = 93,                          // DEFAULT
        S_FIXED_POINT = 94,                      // FIXED_POINT
        S_FLIP = 95,                             // FLIP
        S_OPT_ALGO = 96,                         // OPT_ALGO
        S_COMPILATION_SETUP = 97,                // COMPILATION_SETUP
        S_COMPILER = 98,                         // COMPILER
        S_ADD_FLAGS = 99,                        // ADD_FLAGS
        S_SUBSTITUTE_FLAGS = 100,                // SUBSTITUTE_FLAGS
        S_ADD_LIBS = 101,                        // ADD_LIBS
        S_SUBSTITUTE_LIBS = 102,                 // SUBSTITUTE_LIBS
        S_FORECAST = 103,                        // FORECAST
        S_K_ORDER_SOLVER = 104,                  // K_ORDER_SOLVER
        S_INSTRUMENTS = 105,                     // INSTRUMENTS
        S_SHIFT = 106,                           // SHIFT
        S_MEAN = 107,                            // MEAN
        S_STDEV = 108,                           // STDEV
        S_VARIANCE = 109,                        // VARIANCE
        S_MODE = 110,                            // MODE
        S_INTERVAL = 111,                        // INTERVAL
        S_SHAPE = 112,                           // SHAPE
        S_DOMAINN = 113,                         // DOMAINN
        S_GAMMA_PDF = 114,                       // GAMMA_PDF
        S_GRAPH = 115,                           // GRAPH
        S_GRAPH_FORMAT = 116,                    // GRAPH_FORMAT
        S_CONDITIONAL_VARIANCE_DECOMPOSITION = 117, // CONDITIONAL_VARIANCE_DECOMPOSITION
        S_NOCHECK = 118,                         // NOCHECK
        S_STD = 119,                             // STD
        S_HISTVAL = 120,                         // HISTVAL
        S_HISTVAL_FILE = 121,                    // HISTVAL_FILE
        S_HOMOTOPY_SETUP = 122,                  // HOMOTOPY_SETUP
        S_HOMOTOPY_MODE = 123,                   // HOMOTOPY_MODE
        S_HOMOTOPY_STEPS = 124,                  // HOMOTOPY_STEPS
        S_HOMOTOPY_FORCE_CONTINUE = 125,         // HOMOTOPY_FORCE_CONTINUE
        S_HP_FILTER = 126,                       // HP_FILTER
        S_HP_NGRID = 127,                        // HP_NGRID
        S_FILTERED_THEORETICAL_MOMENTS_GRID = 128, // FILTERED_THEORETICAL_MOMENTS_GRID
        S_HYBRID = 129,                          // HYBRID
        S_ONE_SIDED_HP_FILTER = 130,             // ONE_SIDED_HP_FILTER
        S_IDENTIFICATION = 131,                  // IDENTIFICATION
        S_INF_CONSTANT = 132,                    // INF_CONSTANT
        S_INITVAL = 133,                         // INITVAL
        S_INITVAL_FILE = 134,                    // INITVAL_FILE
        S_BOUNDS = 135,                          // BOUNDS
        S_JSCALE = 136,                          // JSCALE
        S_INIT = 137,                            // INIT
        S_INFILE = 138,                          // INFILE
        S_INVARS = 139,                          // INVARS
        S_INT_NUMBER = 140,                      // INT_NUMBER
        S_INV_GAMMA_PDF = 141,                   // INV_GAMMA_PDF
        S_INV_GAMMA1_PDF = 142,                  // INV_GAMMA1_PDF
        S_INV_GAMMA2_PDF = 143,                  // INV_GAMMA2_PDF
        S_IRF = 144,                             // IRF
        S_IRF_SHOCKS = 145,                      // IRF_SHOCKS
        S_IRF_PLOT_THRESHOLD = 146,              // IRF_PLOT_THRESHOLD
        S_IRF_CALIBRATION = 147,                 // IRF_CALIBRATION
        S_FAST_KALMAN_FILTER = 148,              // FAST_KALMAN_FILTER
        S_KALMAN_ALGO = 149,                     // KALMAN_ALGO
        S_KALMAN_TOL = 150,                      // KALMAN_TOL
        S_DIFFUSE_KALMAN_TOL = 151,              // DIFFUSE_KALMAN_TOL
        S_SCHUR_VEC_TOL = 152,                   // SCHUR_VEC_TOL
        S_SUBSAMPLES = 153,                      // SUBSAMPLES
        S_OPTIONS = 154,                         // OPTIONS
        S_TOLF = 155,                            // TOLF
        S_TOLX = 156,                            // TOLX
        S_PLOT_INIT_DATE = 157,                  // PLOT_INIT_DATE
        S_PLOT_END_DATE = 158,                   // PLOT_END_DATE
        S_LAPLACE = 159,                         // LAPLACE
        S_LIK_ALGO = 160,                        // LIK_ALGO
        S_LIK_INIT = 161,                        // LIK_INIT
        S_LINEAR = 162,                          // LINEAR
        S_LINEAR_DECOMPOSITION = 163,            // LINEAR_DECOMPOSITION
        S_LOAD_IDENT_FILES = 164,                // LOAD_IDENT_FILES
        S_LOAD_MH_FILE = 165,                    // LOAD_MH_FILE
        S_LOAD_RESULTS_AFTER_LOAD_MH = 166,      // LOAD_RESULTS_AFTER_LOAD_MH
        S_LOAD_PARAMS_AND_STEADY_STATE = 167,    // LOAD_PARAMS_AND_STEADY_STATE
        S_LOGLINEAR = 168,                       // LOGLINEAR
        S_LOGDATA = 169,                         // LOGDATA
        S_LYAPUNOV = 170,                        // LYAPUNOV
        S_LINEAR_APPROXIMATION = 171,            // LINEAR_APPROXIMATION
        S_LYAPUNOV_COMPLEX_THRESHOLD = 172,      // LYAPUNOV_COMPLEX_THRESHOLD
        S_LYAPUNOV_FIXED_POINT_TOL = 173,        // LYAPUNOV_FIXED_POINT_TOL
        S_LYAPUNOV_DOUBLING_TOL = 174,           // LYAPUNOV_DOUBLING_TOL
        S_LOG_DEFLATOR = 175,                    // LOG_DEFLATOR
        S_LOG_TREND_VAR = 176,                   // LOG_TREND_VAR
        S_LOG_GROWTH_FACTOR = 177,               // LOG_GROWTH_FACTOR
        S_MATCHED_MOMENTS = 178,                 // MATCHED_MOMENTS
        S_MARKOWITZ = 179,                       // MARKOWITZ
        S_MARGINAL_DENSITY = 180,                // MARGINAL_DENSITY
        S_MAX = 181,                             // MAX
        S_MAXIT = 182,                           // MAXIT
        S_MFS = 183,                             // MFS
        S_MH_CONF_SIG = 184,                     // MH_CONF_SIG
        S_MH_DROP = 185,                         // MH_DROP
        S_MH_INIT_SCALE = 186,                   // MH_INIT_SCALE
        S_MH_JSCALE = 187,                       // MH_JSCALE
        S_MH_TUNE_JSCALE = 188,                  // MH_TUNE_JSCALE
        S_MH_TUNE_GUESS = 189,                   // MH_TUNE_GUESS
        S_MH_POSTERIOR_MODE_ESTIMATION = 190,    // MH_POSTERIOR_MODE_ESTIMATION
        S_MH_NBLOCKS = 191,                      // MH_NBLOCKS
        S_MH_REPLIC = 192,                       // MH_REPLIC
        S_MH_RECOVER = 193,                      // MH_RECOVER
        S_MH_INITIALIZE_FROM_PREVIOUS_MCMC = 194, // MH_INITIALIZE_FROM_PREVIOUS_MCMC
        S_MH_INITIALIZE_FROM_PREVIOUS_MCMC_DIRECTORY = 195, // MH_INITIALIZE_FROM_PREVIOUS_MCMC_DIRECTORY
        S_MH_INITIALIZE_FROM_PREVIOUS_MCMC_RECORD = 196, // MH_INITIALIZE_FROM_PREVIOUS_MCMC_RECORD
        S_MH_INITIALIZE_FROM_PREVIOUS_MCMC_PRIOR = 197, // MH_INITIALIZE_FROM_PREVIOUS_MCMC_PRIOR
        S_POSTERIOR_MAX_SUBSAMPLE_DRAWS = 198,   // POSTERIOR_MAX_SUBSAMPLE_DRAWS
        S_MIN = 199,                             // MIN
        S_MINIMAL_SOLVING_PERIODS = 200,         // MINIMAL_SOLVING_PERIODS
        S_MODE_CHECK = 201,                      // MODE_CHECK
        S_MODE_CHECK_NEIGHBOURHOOD_SIZE = 202,   // MODE_CHECK_NEIGHBOURHOOD_SIZE
        S_MODE_CHECK_SYMMETRIC_PLOTS = 203,      // MODE_CHECK_SYMMETRIC_PLOTS
        S_MODE_CHECK_NUMBER_OF_POINTS = 204,     // MODE_CHECK_NUMBER_OF_POINTS
        S_MODE_COMPUTE = 205,                    // MODE_COMPUTE
        S_MODE_FILE = 206,                       // MODE_FILE
        S_MODEL = 207,                           // MODEL
        S_MODEL_COMPARISON = 208,                // MODEL_COMPARISON
        S_MODEL_INFO = 209,                      // MODEL_INFO
        S_MSHOCKS = 210,                         // MSHOCKS
        S_ABS = 211,                             // ABS
        S_SIGN = 212,                            // SIGN
        S_MODEL_DIAGNOSTICS = 213,               // MODEL_DIAGNOSTICS
        S_MODIFIEDHARMONICMEAN = 214,            // MODIFIEDHARMONICMEAN
        S_MOMENTS_VARENDO = 215,                 // MOMENTS_VARENDO
        S_CONTEMPORANEOUS_CORRELATION = 216,     // CONTEMPORANEOUS_CORRELATION
        S_DIFFUSE_FILTER = 217,                  // DIFFUSE_FILTER
        S_SUB_DRAWS = 218,                       // SUB_DRAWS
        S_TAPER_STEPS = 219,                     // TAPER_STEPS
        S_GEWEKE_INTERVAL = 220,                 // GEWEKE_INTERVAL
        S_RAFTERY_LEWIS_QRS = 221,               // RAFTERY_LEWIS_QRS
        S_RAFTERY_LEWIS_DIAGNOSTICS = 222,       // RAFTERY_LEWIS_DIAGNOSTICS
        S_MCMC_JUMPING_COVARIANCE = 223,         // MCMC_JUMPING_COVARIANCE
        S_MOMENT_CALIBRATION = 224,              // MOMENT_CALIBRATION
        S_NUMBER_OF_PARTICLES = 225,             // NUMBER_OF_PARTICLES
        S_RESAMPLING = 226,                      // RESAMPLING
        S_SYSTEMATIC = 227,                      // SYSTEMATIC
        S_GENERIC = 228,                         // GENERIC
        S_RESAMPLING_THRESHOLD = 229,            // RESAMPLING_THRESHOLD
        S_RESAMPLING_METHOD = 230,               // RESAMPLING_METHOD
        S_KITAGAWA = 231,                        // KITAGAWA
        S_STRATIFIED = 232,                      // STRATIFIED
        S_SMOOTH = 233,                          // SMOOTH
        S_CPF_WEIGHTS = 234,                     // CPF_WEIGHTS
        S_AMISANOTRISTANI = 235,                 // AMISANOTRISTANI
        S_MURRAYJONESPARSLOW = 236,              // MURRAYJONESPARSLOW
        S_WRITE_EQUATION_TAGS = 237,             // WRITE_EQUATION_TAGS
        S_FILTER_INITIAL_STATE = 238,            // FILTER_INITIAL_STATE
        S_NONLINEAR_FILTER_INITIALIZATION = 239, // NONLINEAR_FILTER_INITIALIZATION
        S_FILTER_ALGORITHM = 240,                // FILTER_ALGORITHM
        S_PROPOSAL_APPROXIMATION = 241,          // PROPOSAL_APPROXIMATION
        S_CUBATURE = 242,                        // CUBATURE
        S_UNSCENTED = 243,                       // UNSCENTED
        S_MONTECARLO = 244,                      // MONTECARLO
        S_DISTRIBUTION_APPROXIMATION = 245,      // DISTRIBUTION_APPROXIMATION
        S_NAME = 246,                            // NAME
        S_USE_PENALIZED_OBJECTIVE_FOR_HESSIAN = 247, // USE_PENALIZED_OBJECTIVE_FOR_HESSIAN
        S_INIT_STATE = 248,                      // INIT_STATE
        S_FAST_REALTIME = 249,                   // FAST_REALTIME
        S_RESCALE_PREDICTION_ERROR_COVARIANCE = 250, // RESCALE_PREDICTION_ERROR_COVARIANCE
        S_GENERATE_IRFS = 251,                   // GENERATE_IRFS
        S_NAN_CONSTANT = 252,                    // NAN_CONSTANT
        S_NO_STATIC = 253,                       // NO_STATIC
        S_NOBS = 254,                            // NOBS
        S_NOCONSTANT = 255,                      // NOCONSTANT
        S_NODISPLAY = 256,                       // NODISPLAY
        S_NOCORR = 257,                          // NOCORR
        S_NODIAGNOSTIC = 258,                    // NODIAGNOSTIC
        S_NOFUNCTIONS = 259,                     // NOFUNCTIONS
        S_NO_HOMOTOPY = 260,                     // NO_HOMOTOPY
        S_NOGRAPH = 261,                         // NOGRAPH
        S_POSTERIOR_NOGRAPH = 262,               // POSTERIOR_NOGRAPH
        S_POSTERIOR_GRAPH = 263,                 // POSTERIOR_GRAPH
        S_NOMOMENTS = 264,                       // NOMOMENTS
        S_NOPRINT = 265,                         // NOPRINT
        S_NORMAL_PDF = 266,                      // NORMAL_PDF
        S_SAVE_DRAWS = 267,                      // SAVE_DRAWS
        S_MODEL_NAME = 268,                      // MODEL_NAME
        S_STDERR_MULTIPLES = 269,                // STDERR_MULTIPLES
        S_DIAGONAL_ONLY = 270,                   // DIAGONAL_ONLY
        S_DETERMINISTIC_TRENDS = 271,            // DETERMINISTIC_TRENDS
        S_OBSERVATION_TRENDS = 272,              // OBSERVATION_TRENDS
        S_OPTIM = 273,                           // OPTIM
        S_OPTIM_WEIGHTS = 274,                   // OPTIM_WEIGHTS
        S_ORDER = 275,                           // ORDER
        S_OSR = 276,                             // OSR
        S_OSR_PARAMS = 277,                      // OSR_PARAMS
        S_MAX_DIM_COVA_GROUP = 278,              // MAX_DIM_COVA_GROUP
        S_ADVANCED = 279,                        // ADVANCED
        S_OUTFILE = 280,                         // OUTFILE
        S_OUTVARS = 281,                         // OUTVARS
        S_OVERWRITE = 282,                       // OVERWRITE
        S_DISCOUNT = 283,                        // DISCOUNT
        S_PARALLEL_LOCAL_FILES = 284,            // PARALLEL_LOCAL_FILES
        S_PARAMETERS = 285,                      // PARAMETERS
        S_PARAMETER_SET = 286,                   // PARAMETER_SET
        S_PARTIAL_INFORMATION = 287,             // PARTIAL_INFORMATION
        S_PERIODS = 288,                         // PERIODS
        S_PERIOD = 289,                          // PERIOD
        S_PLANNER_OBJECTIVE = 290,               // PLANNER_OBJECTIVE
        S_PLOT_CONDITIONAL_FORECAST = 291,       // PLOT_CONDITIONAL_FORECAST
        S_PLOT_PRIORS = 292,                     // PLOT_PRIORS
        S_PREFILTER = 293,                       // PREFILTER
        S_PRESAMPLE = 294,                       // PRESAMPLE
        S_PERFECT_FORESIGHT_SETUP = 295,         // PERFECT_FORESIGHT_SETUP
        S_PERFECT_FORESIGHT_SOLVER = 296,        // PERFECT_FORESIGHT_SOLVER
        S_NO_POSTERIOR_KERNEL_DENSITY = 297,     // NO_POSTERIOR_KERNEL_DENSITY
        S_FUNCTION = 298,                        // FUNCTION
        S_PERFECT_FORESIGHT_WITH_EXPECTATION_ERRORS_SETUP = 299, // PERFECT_FORESIGHT_WITH_EXPECTATION_ERRORS_SETUP
        S_PERFECT_FORESIGHT_WITH_EXPECTATION_ERRORS_SOLVER = 300, // PERFECT_FORESIGHT_WITH_EXPECTATION_ERRORS_SOLVER
        S_PRINT = 301,                           // PRINT
        S_PRIOR_MC = 302,                        // PRIOR_MC
        S_PRIOR_TRUNC = 303,                     // PRIOR_TRUNC
        S_PRIOR_MODE = 304,                      // PRIOR_MODE
        S_PRIOR_MEAN = 305,                      // PRIOR_MEAN
        S_POSTERIOR_MODE = 306,                  // POSTERIOR_MODE
        S_POSTERIOR_MEAN = 307,                  // POSTERIOR_MEAN
        S_POSTERIOR_MEDIAN = 308,                // POSTERIOR_MEDIAN
        S_MLE_MODE = 309,                        // MLE_MODE
        S_PRUNING = 310,                         // PRUNING
        S_PARTICLE_FILTER_OPTIONS = 311,         // PARTICLE_FILTER_OPTIONS
        S_QUOTED_STRING = 312,                   // QUOTED_STRING
        S_QZ_CRITERIUM = 313,                    // QZ_CRITERIUM
        S_QZ_ZERO_THRESHOLD = 314,               // QZ_ZERO_THRESHOLD
        S_DSGE_VAR = 315,                        // DSGE_VAR
        S_DSGE_VARLAG = 316,                     // DSGE_VARLAG
        S_DSGE_PRIOR_WEIGHT = 317,               // DSGE_PRIOR_WEIGHT
        S_TRUNCATE = 318,                        // TRUNCATE
        S_PIPE_E = 319,                          // PIPE_E
        S_PIPE_X = 320,                          // PIPE_X
        S_PIPE_P = 321,                          // PIPE_P
        S_RELATIVE_IRF = 322,                    // RELATIVE_IRF
        S_REPLIC = 323,                          // REPLIC
        S_SIMUL_REPLIC = 324,                    // SIMUL_REPLIC
        S_RPLOT = 325,                           // RPLOT
        S_SAVE_PARAMS_AND_STEADY_STATE = 326,    // SAVE_PARAMS_AND_STEADY_STATE
        S_PARAMETER_UNCERTAINTY = 327,           // PARAMETER_UNCERTAINTY
        S_TARGETS = 328,                         // TARGETS
        S_SHOCKS = 329,                          // SHOCKS
        S_HETEROSKEDASTIC_SHOCKS = 330,          // HETEROSKEDASTIC_SHOCKS
        S_SHOCK_DECOMPOSITION = 331,             // SHOCK_DECOMPOSITION
        S_SHOCK_GROUPS = 332,                    // SHOCK_GROUPS
        S_USE_SHOCK_GROUPS = 333,                // USE_SHOCK_GROUPS
        S_SIGMA_E = 334,                         // SIGMA_E
        S_SIMUL = 335,                           // SIMUL
        S_SIMUL_ALGO = 336,                      // SIMUL_ALGO
        S_SIMUL_SEED = 337,                      // SIMUL_SEED
        S_ENDOGENOUS_TERMINAL_PERIOD = 338,      // ENDOGENOUS_TERMINAL_PERIOD
        S_SMOOTHER = 339,                        // SMOOTHER
        S_SMOOTHER2HISTVAL = 340,                // SMOOTHER2HISTVAL
        S_SQUARE_ROOT_SOLVER = 341,              // SQUARE_ROOT_SOLVER
        S_STACK_SOLVE_ALGO = 342,                // STACK_SOLVE_ALGO
        S_STEADY_STATE_MODEL = 343,              // STEADY_STATE_MODEL
        S_SOLVE_ALGO = 344,                      // SOLVE_ALGO
        S_SOLVER_PERIODS = 345,                  // SOLVER_PERIODS
        S_ROBUST_LIN_SOLVE = 346,                // ROBUST_LIN_SOLVE
        S_STDERR = 347,                          // STDERR
        S_STEADY = 348,                          // STEADY
        S_STOCH_SIMUL = 349,                     // STOCH_SIMUL
        S_SYLVESTER = 350,                       // SYLVESTER
        S_SYLVESTER_FIXED_POINT_TOL = 351,       // SYLVESTER_FIXED_POINT_TOL
        S_REGIMES = 352,                         // REGIMES
        S_REGIME = 353,                          // REGIME
        S_REALTIME_SHOCK_DECOMPOSITION = 354,    // REALTIME_SHOCK_DECOMPOSITION
        S_CONDITIONAL = 355,                     // CONDITIONAL
        S_UNCONDITIONAL = 356,                   // UNCONDITIONAL
        S_TEX = 357,                             // TEX
        S_RAMSEY_MODEL = 358,                    // RAMSEY_MODEL
        S_RAMSEY_POLICY = 359,                   // RAMSEY_POLICY
        S_RAMSEY_CONSTRAINTS = 360,              // RAMSEY_CONSTRAINTS
        S_PLANNER_DISCOUNT = 361,                // PLANNER_DISCOUNT
        S_PLANNER_DISCOUNT_LATEX_NAME = 362,     // PLANNER_DISCOUNT_LATEX_NAME
        S_DISCRETIONARY_POLICY = 363,            // DISCRETIONARY_POLICY
        S_DISCRETIONARY_TOL = 364,               // DISCRETIONARY_TOL
        S_EVALUATE_PLANNER_OBJECTIVE = 365,      // EVALUATE_PLANNER_OBJECTIVE
        S_OCCBIN_SETUP = 366,                    // OCCBIN_SETUP
        S_OCCBIN_SOLVER = 367,                   // OCCBIN_SOLVER
        S_OCCBIN_WRITE_REGIMES = 368,            // OCCBIN_WRITE_REGIMES
        S_OCCBIN_GRAPH = 369,                    // OCCBIN_GRAPH
        S_SIMUL_MAXIT = 370,                     // SIMUL_MAXIT
        S_LIKELIHOOD_MAXIT = 371,                // LIKELIHOOD_MAXIT
        S_SMOOTHER_MAXIT = 372,                  // SMOOTHER_MAXIT
        S_SIMUL_PERIODS = 373,                   // SIMUL_PERIODS
        S_LIKELIHOOD_PERIODS = 374,              // LIKELIHOOD_PERIODS
        S_SMOOTHER_PERIODS = 375,                // SMOOTHER_PERIODS
        S_SIMUL_CURB_RETRENCH = 376,             // SIMUL_CURB_RETRENCH
        S_LIKELIHOOD_CURB_RETRENCH = 377,        // LIKELIHOOD_CURB_RETRENCH
        S_SMOOTHER_CURB_RETRENCH = 378,          // SMOOTHER_CURB_RETRENCH
        S_SIMUL_CHECK_AHEAD_PERIODS = 379,       // SIMUL_CHECK_AHEAD_PERIODS
        S_LIKELIHOOD_CHECK_AHEAD_PERIODS = 380,  // LIKELIHOOD_CHECK_AHEAD_PERIODS
        S_SMOOTHER_CHECK_AHEAD_PERIODS = 381,    // SMOOTHER_CHECK_AHEAD_PERIODS
        S_SIMUL_DEBUG = 382,                     // SIMUL_DEBUG
        S_SMOOTHER_DEBUG = 383,                  // SMOOTHER_DEBUG
        S_SIMUL_PERIODIC_SOLUTION = 384,         // SIMUL_PERIODIC_SOLUTION
        S_LIKELIHOOD_PERIODIC_SOLUTION = 385,    // LIKELIHOOD_PERIODIC_SOLUTION
        S_SMOOTHER_PERIODIC_SOLUTION = 386,      // SMOOTHER_PERIODIC_SOLUTION
        S_LIKELIHOOD_INVERSION_FILTER = 387,     // LIKELIHOOD_INVERSION_FILTER
        S_SMOOTHER_INVERSION_FILTER = 388,       // SMOOTHER_INVERSION_FILTER
        S_FILTER_USE_RELEXATION = 389,           // FILTER_USE_RELEXATION
        S_LIKELIHOOD_PIECEWISE_KALMAN_FILTER = 390, // LIKELIHOOD_PIECEWISE_KALMAN_FILTER
        S_SMOOTHER_PIECEWISE_KALMAN_FILTER = 391, // SMOOTHER_PIECEWISE_KALMAN_FILTER
        S_LIKELIHOOD_MAX_KALMAN_ITERATIONS = 392, // LIKELIHOOD_MAX_KALMAN_ITERATIONS
        S_TEX_NAME = 393,                        // TEX_NAME
        S_TRUE = 394,                            // TRUE
        S_BIND = 395,                            // BIND
        S_RELAX = 396,                           // RELAX
        S_ERROR_BIND = 397,                      // ERROR_BIND
        S_ERROR_RELAX = 398,                     // ERROR_RELAX
        S_UNIFORM_PDF = 399,                     // UNIFORM_PDF
        S_UNIT_ROOT_VARS = 400,                  // UNIT_ROOT_VARS
        S_USE_DLL = 401,                         // USE_DLL
        S_USEAUTOCORR = 402,                     // USEAUTOCORR
        S_GSA_SAMPLE_FILE = 403,                 // GSA_SAMPLE_FILE
        S_USE_UNIVARIATE_FILTERS_IF_SINGULARITY_IS_DETECTED = 404, // USE_UNIVARIATE_FILTERS_IF_SINGULARITY_IS_DETECTED
        S_VALUES = 405,                          // VALUES
        S_SCALES = 406,                          // SCALES
        S_VAR = 407,                             // VAR
        S_VAREXO = 408,                          // VAREXO
        S_VAREXO_DET = 409,                      // VAREXO_DET
        S_VARIABLE = 410,                        // VARIABLE
        S_VAROBS = 411,                          // VAROBS
        S_VAREXOBS = 412,                        // VAREXOBS
        S_PREDETERMINED_VARIABLES = 413,         // PREDETERMINED_VARIABLES
        S_VAR_EXPECTATION = 414,                 // VAR_EXPECTATION
        S_VAR_EXPECTATION_MODEL = 415,           // VAR_EXPECTATION_MODEL
        S_PLOT_SHOCK_DECOMPOSITION = 416,        // PLOT_SHOCK_DECOMPOSITION
        S_MODEL_LOCAL_VARIABLE = 417,            // MODEL_LOCAL_VARIABLE
        S_WRITE_LATEX_DYNAMIC_MODEL = 418,       // WRITE_LATEX_DYNAMIC_MODEL
        S_WRITE_LATEX_STATIC_MODEL = 419,        // WRITE_LATEX_STATIC_MODEL
        S_WRITE_LATEX_ORIGINAL_MODEL = 420,      // WRITE_LATEX_ORIGINAL_MODEL
        S_WRITE_LATEX_STEADY_STATE_MODEL = 421,  // WRITE_LATEX_STEADY_STATE_MODEL
        S_XLS_SHEET = 422,                       // XLS_SHEET
        S_XLS_RANGE = 423,                       // XLS_RANGE
        S_LMMCP = 424,                           // LMMCP
        S_BANDPASS_FILTER = 425,                 // BANDPASS_FILTER
        S_COLORMAP = 426,                        // COLORMAP
        S_VAR_MODEL = 427,                       // VAR_MODEL
        S_PAC_MODEL = 428,                       // PAC_MODEL
        S_QOQ = 429,                             // QOQ
        S_YOY = 430,                             // YOY
        S_AOA = 431,                             // AOA
        S_PAC_EXPECTATION = 432,                 // PAC_EXPECTATION
        S_TREND_COMPONENT_MODEL = 433,           // TREND_COMPONENT_MODEL
        S_EQUAL_EQUAL = 434,                     // EQUAL_EQUAL
        S_EXCLAMATION_EQUAL = 435,               // EXCLAMATION_EQUAL
        S_LESS = 436,                            // LESS
        S_GREATER = 437,                         // GREATER
        S_LESS_EQUAL = 438,                      // LESS_EQUAL
        S_GREATER_EQUAL = 439,                   // GREATER_EQUAL
        S_PLUS = 440,                            // PLUS
        S_MINUS = 441,                           // MINUS
        S_TIMES = 442,                           // TIMES
        S_DIVIDE = 443,                          // DIVIDE
        S_UNARY = 444,                           // UNARY
        S_POWER = 445,                           // POWER
        S_EXP = 446,                             // EXP
        S_LOG = 447,                             // LOG
        S_LN = 448,                              // LN
        S_LOG10 = 449,                           // LOG10
        S_SIN = 450,                             // SIN
        S_COS = 451,                             // COS
        S_TAN = 452,                             // TAN
        S_ASIN = 453,                            // ASIN
        S_ACOS = 454,                            // ACOS
        S_ATAN = 455,                            // ATAN
        S_ERF = 456,                             // ERF
        S_DIFF = 457,                            // DIFF
        S_ADL = 458,                             // ADL
        S_AUXILIARY_MODEL_NAME = 459,            // AUXILIARY_MODEL_NAME
        S_SQRT = 460,                            // SQRT
        S_CBRT = 461,                            // CBRT
        S_NORMCDF = 462,                         // NORMCDF
        S_NORMPDF = 463,                         // NORMPDF
        S_STEADY_STATE = 464,                    // STEADY_STATE
        S_EXPECTATION = 465,                     // EXPECTATION
        S_DYNARE_SENSITIVITY = 466,              // DYNARE_SENSITIVITY
        S_MORRIS = 467,                          // MORRIS
        S_STAB = 468,                            // STAB
        S_REDFORM = 469,                         // REDFORM
        S_PPRIOR = 470,                          // PPRIOR
        S_PRIOR_RANGE = 471,                     // PRIOR_RANGE
        S_PPOST = 472,                           // PPOST
        S_ILPTAU = 473,                          // ILPTAU
        S_MORRIS_NLIV = 474,                     // MORRIS_NLIV
        S_MORRIS_NTRA = 475,                     // MORRIS_NTRA
        S_NSAM = 476,                            // NSAM
        S_LOAD_REDFORM = 477,                    // LOAD_REDFORM
        S_LOAD_RMSE = 478,                       // LOAD_RMSE
        S_LOAD_STAB = 479,                       // LOAD_STAB
        S_ALPHA2_STAB = 480,                     // ALPHA2_STAB
        S_LOGTRANS_REDFORM = 481,                // LOGTRANS_REDFORM
        S_THRESHOLD_REDFORM = 482,               // THRESHOLD_REDFORM
        S_KSSTAT_REDFORM = 483,                  // KSSTAT_REDFORM
        S_ALPHA2_REDFORM = 484,                  // ALPHA2_REDFORM
        S_NAMENDO = 485,                         // NAMENDO
        S_NAMLAGENDO = 486,                      // NAMLAGENDO
        S_NAMEXO = 487,                          // NAMEXO
        S_RMSE = 488,                            // RMSE
        S_LIK_ONLY = 489,                        // LIK_ONLY
        S_VAR_RMSE = 490,                        // VAR_RMSE
        S_PFILT_RMSE = 491,                      // PFILT_RMSE
        S_ISTART_RMSE = 492,                     // ISTART_RMSE
        S_ALPHA_RMSE = 493,                      // ALPHA_RMSE
        S_ALPHA2_RMSE = 494,                     // ALPHA2_RMSE
        S_FREQ = 495,                            // FREQ
        S_INITIAL_YEAR = 496,                    // INITIAL_YEAR
        S_INITIAL_SUBPERIOD = 497,               // INITIAL_SUBPERIOD
        S_FINAL_YEAR = 498,                      // FINAL_YEAR
        S_FINAL_SUBPERIOD = 499,                 // FINAL_SUBPERIOD
        S_DATA = 500,                            // DATA
        S_VLIST = 501,                           // VLIST
        S_VLISTLOG = 502,                        // VLISTLOG
        S_VLISTPER = 503,                        // VLISTPER
        S_SPECTRAL_DENSITY = 504,                // SPECTRAL_DENSITY
        S_INIT2SHOCKS = 505,                     // INIT2SHOCKS
        S_RESTRICTION = 506,                     // RESTRICTION
        S_RESTRICTION_FNAME = 507,               // RESTRICTION_FNAME
        S_CROSS_RESTRICTIONS = 508,              // CROSS_RESTRICTIONS
        S_NLAGS = 509,                           // NLAGS
        S_CONTEMP_REDUCED_FORM = 510,            // CONTEMP_REDUCED_FORM
        S_REAL_PSEUDO_FORECAST = 511,            // REAL_PSEUDO_FORECAST
        S_DUMMY_OBS = 512,                       // DUMMY_OBS
        S_NSTATES = 513,                         // NSTATES
        S_INDXSCALESSTATES = 514,                // INDXSCALESSTATES
        S_NO_BAYESIAN_PRIOR = 515,               // NO_BAYESIAN_PRIOR
        S_SPECIFICATION = 516,                   // SPECIFICATION
        S_SIMS_ZHA = 517,                        // SIMS_ZHA
        S_ALPHA = 518,                           // ALPHA
        S_BETA = 519,                            // BETA
        S_ABAND = 520,                           // ABAND
        S_NINV = 521,                            // NINV
        S_CMS = 522,                             // CMS
        S_NCMS = 523,                            // NCMS
        S_CNUM = 524,                            // CNUM
        S_GAMMA = 525,                           // GAMMA
        S_INV_GAMMA = 526,                       // INV_GAMMA
        S_INV_GAMMA1 = 527,                      // INV_GAMMA1
        S_INV_GAMMA2 = 528,                      // INV_GAMMA2
        S_NORMAL = 529,                          // NORMAL
        S_UNIFORM = 530,                         // UNIFORM
        S_EPS = 531,                             // EPS
        S_PDF = 532,                             // PDF
        S_FIG = 533,                             // FIG
        S_DR = 534,                              // DR
        S_NONE = 535,                            // NONE
        S_PRIOR = 536,                           // PRIOR
        S_PRIOR_VARIANCE = 537,                  // PRIOR_VARIANCE
        S_HESSIAN = 538,                         // HESSIAN
        S_IDENTITY_MATRIX = 539,                 // IDENTITY_MATRIX
        S_DIRICHLET = 540,                       // DIRICHLET
        S_DIAGONAL = 541,                        // DIAGONAL
        S_OPTIMAL = 542,                         // OPTIMAL
        S_GSIG2_LMDM = 543,                      // GSIG2_LMDM
        S_Q_DIAG = 544,                          // Q_DIAG
        S_FLAT_PRIOR = 545,                      // FLAT_PRIOR
        S_NCSK = 546,                            // NCSK
        S_NSTD = 547,                            // NSTD
        S_WEIBULL = 548,                         // WEIBULL
        S_WEIBULL_PDF = 549,                     // WEIBULL_PDF
        S_GMM = 550,                             // GMM
        S_SMM = 551,                             // SMM
        S_INDXPARR = 552,                        // INDXPARR
        S_INDXOVR = 553,                         // INDXOVR
        S_INDXAP = 554,                          // INDXAP
        S_APBAND = 555,                          // APBAND
        S_INDXIMF = 556,                         // INDXIMF
        S_INDXFORE = 557,                        // INDXFORE
        S_FOREBAND = 558,                        // FOREBAND
        S_INDXGFOREHAT = 559,                    // INDXGFOREHAT
        S_INDXGIMFHAT = 560,                     // INDXGIMFHAT
        S_INDXESTIMA = 561,                      // INDXESTIMA
        S_INDXGDLS = 562,                        // INDXGDLS
        S_EQ_MS = 563,                           // EQ_MS
        S_FILTER_COVARIANCE = 564,               // FILTER_COVARIANCE
        S_FILTER_DECOMPOSITION = 565,            // FILTER_DECOMPOSITION
        S_SMOOTHED_STATE_UNCERTAINTY = 566,      // SMOOTHED_STATE_UNCERTAINTY
        S_SMOOTHER_REDUX = 567,                  // SMOOTHER_REDUX
        S_EQ_CMS = 568,                          // EQ_CMS
        S_TLINDX = 569,                          // TLINDX
        S_TLNUMBER = 570,                        // TLNUMBER
        S_RESTRICTIONS = 571,                    // RESTRICTIONS
        S_POSTERIOR_SAMPLER_OPTIONS = 572,       // POSTERIOR_SAMPLER_OPTIONS
        S_OUTPUT_FILE_TAG = 573,                 // OUTPUT_FILE_TAG
        S_HORIZON = 574,                         // HORIZON
        S_SBVAR = 575,                           // SBVAR
        S_TREND_VAR = 576,                       // TREND_VAR
        S_DEFLATOR = 577,                        // DEFLATOR
        S_GROWTH_FACTOR = 578,                   // GROWTH_FACTOR
        S_MS_IRF = 579,                          // MS_IRF
        S_MS_VARIANCE_DECOMPOSITION = 580,       // MS_VARIANCE_DECOMPOSITION
        S_GROWTH = 581,                          // GROWTH
        S_MS_ESTIMATION = 582,                   // MS_ESTIMATION
        S_MS_SIMULATION = 583,                   // MS_SIMULATION
        S_MS_COMPUTE_MDD = 584,                  // MS_COMPUTE_MDD
        S_MS_COMPUTE_PROBABILITIES = 585,        // MS_COMPUTE_PROBABILITIES
        S_MS_FORECAST = 586,                     // MS_FORECAST
        S_SVAR_IDENTIFICATION = 587,             // SVAR_IDENTIFICATION
        S_EQUATION = 588,                        // EQUATION
        S_EXCLUSION = 589,                       // EXCLUSION
        S_LAG = 590,                             // LAG
        S_UPPER_CHOLESKY = 591,                  // UPPER_CHOLESKY
        S_LOWER_CHOLESKY = 592,                  // LOWER_CHOLESKY
        S_MONTHLY = 593,                         // MONTHLY
        S_QUARTERLY = 594,                       // QUARTERLY
        S_MARKOV_SWITCHING = 595,                // MARKOV_SWITCHING
        S_CHAIN = 596,                           // CHAIN
        S_DURATION = 597,                        // DURATION
        S_NUMBER_OF_REGIMES = 598,               // NUMBER_OF_REGIMES
        S_NUMBER_OF_LAGS = 599,                  // NUMBER_OF_LAGS
        S_EPILOGUE = 600,                        // EPILOGUE
        S_SVAR = 601,                            // SVAR
        S_SVAR_GLOBAL_IDENTIFICATION_CHECK = 602, // SVAR_GLOBAL_IDENTIFICATION_CHECK
        S_COEFF = 603,                           // COEFF
        S_COEFFICIENTS = 604,                    // COEFFICIENTS
        S_VARIANCES = 605,                       // VARIANCES
        S_CONSTANTS = 606,                       // CONSTANTS
        S_EQUATIONS = 607,                       // EQUATIONS
        S_EXTERNAL_FUNCTION = 608,               // EXTERNAL_FUNCTION
        S_EXT_FUNC_NAME = 609,                   // EXT_FUNC_NAME
        S_EXT_FUNC_NARGS = 610,                  // EXT_FUNC_NARGS
        S_FIRST_DERIV_PROVIDED = 611,            // FIRST_DERIV_PROVIDED
        S_SECOND_DERIV_PROVIDED = 612,           // SECOND_DERIV_PROVIDED
        S_SELECTED_VARIABLES_ONLY = 613,         // SELECTED_VARIABLES_ONLY
        S_COVA_COMPUTE = 614,                    // COVA_COMPUTE
        S_SIMULATION_FILE_TAG = 615,             // SIMULATION_FILE_TAG
        S_FILE_TAG = 616,                        // FILE_TAG
        S_NO_ERROR_BANDS = 617,                  // NO_ERROR_BANDS
        S_ERROR_BAND_PERCENTILES = 618,          // ERROR_BAND_PERCENTILES
        S_SHOCKS_PER_PARAMETER = 619,            // SHOCKS_PER_PARAMETER
        S_NO_CREATE_INIT = 620,                  // NO_CREATE_INIT
        S_SHOCK_DRAWS = 621,                     // SHOCK_DRAWS
        S_FREE_PARAMETERS = 622,                 // FREE_PARAMETERS
        S_MEDIAN = 623,                          // MEDIAN
        S_DATA_OBS_NBR = 624,                    // DATA_OBS_NBR
        S_NEIGHBORHOOD_WIDTH = 625,              // NEIGHBORHOOD_WIDTH
        S_PVALUE_KS = 626,                       // PVALUE_KS
        S_PVALUE_CORR = 627,                     // PVALUE_CORR
        S_FILTERED_PROBABILITIES = 628,          // FILTERED_PROBABILITIES
        S_REAL_TIME_SMOOTHED = 629,              // REAL_TIME_SMOOTHED
        S_PRIOR_FUNCTION = 630,                  // PRIOR_FUNCTION
        S_POSTERIOR_FUNCTION = 631,              // POSTERIOR_FUNCTION
        S_SAMPLING_DRAWS = 632,                  // SAMPLING_DRAWS
        S_PROPOSAL_TYPE = 633,                   // PROPOSAL_TYPE
        S_PROPOSAL_UPPER_BOUND = 634,            // PROPOSAL_UPPER_BOUND
        S_PROPOSAL_LOWER_BOUND = 635,            // PROPOSAL_LOWER_BOUND
        S_PROPOSAL_DRAWS = 636,                  // PROPOSAL_DRAWS
        S_USE_MEAN_CENTER = 637,                 // USE_MEAN_CENTER
        S_ADAPTIVE_MH_DRAWS = 638,               // ADAPTIVE_MH_DRAWS
        S_THINNING_FACTOR = 639,                 // THINNING_FACTOR
        S_COEFFICIENTS_PRIOR_HYPERPARAMETERS = 640, // COEFFICIENTS_PRIOR_HYPERPARAMETERS
        S_CONVERGENCE_STARTING_VALUE = 641,      // CONVERGENCE_STARTING_VALUE
        S_CONVERGENCE_ENDING_VALUE = 642,        // CONVERGENCE_ENDING_VALUE
        S_CONVERGENCE_INCREMENT_VALUE = 643,     // CONVERGENCE_INCREMENT_VALUE
        S_MAX_ITERATIONS_STARTING_VALUE = 644,   // MAX_ITERATIONS_STARTING_VALUE
        S_MAX_ITERATIONS_INCREMENT_VALUE = 645,  // MAX_ITERATIONS_INCREMENT_VALUE
        S_MAX_BLOCK_ITERATIONS = 646,            // MAX_BLOCK_ITERATIONS
        S_MAX_REPEATED_OPTIMIZATION_RUNS = 647,  // MAX_REPEATED_OPTIMIZATION_RUNS
        S_FUNCTION_CONVERGENCE_CRITERION = 648,  // FUNCTION_CONVERGENCE_CRITERION
        S_SAVE_REALTIME = 649,                   // SAVE_REALTIME
        S_PARAMETER_CONVERGENCE_CRITERION = 650, // PARAMETER_CONVERGENCE_CRITERION
        S_NUMBER_OF_LARGE_PERTURBATIONS = 651,   // NUMBER_OF_LARGE_PERTURBATIONS
        S_NUMBER_OF_SMALL_PERTURBATIONS = 652,   // NUMBER_OF_SMALL_PERTURBATIONS
        S_NUMBER_OF_POSTERIOR_DRAWS_AFTER_PERTURBATION = 653, // NUMBER_OF_POSTERIOR_DRAWS_AFTER_PERTURBATION
        S_MAX_NUMBER_OF_STAGES = 654,            // MAX_NUMBER_OF_STAGES
        S_RANDOM_FUNCTION_CONVERGENCE_CRITERION = 655, // RANDOM_FUNCTION_CONVERGENCE_CRITERION
        S_RANDOM_PARAMETER_CONVERGENCE_CRITERION = 656, // RANDOM_PARAMETER_CONVERGENCE_CRITERION
        S_NO_INIT_ESTIMATION_CHECK_FIRST_OBS = 657, // NO_INIT_ESTIMATION_CHECK_FIRST_OBS
        S_HETEROSKEDASTIC_FILTER = 658,          // HETEROSKEDASTIC_FILTER
        S_TIME_SHIFT = 659,                      // TIME_SHIFT
        S_STRUCTURAL = 660,                      // STRUCTURAL
        S_TERMINAL_STEADY_STATE_AS_GUESS_VALUE = 661, // TERMINAL_STEADY_STATE_AS_GUESS_VALUE
        S_SURPRISE = 662,                        // SURPRISE
        S_OCCBIN_CONSTRAINTS = 663,              // OCCBIN_CONSTRAINTS
        S_METHOD_OF_MOMENTS = 664,               // METHOD_OF_MOMENTS
        S_MOM_METHOD = 665,                      // MOM_METHOD
        S_BARTLETT_KERNEL_LAG = 666,             // BARTLETT_KERNEL_LAG
        S_WEIGHTING_MATRIX = 667,                // WEIGHTING_MATRIX
        S_WEIGHTING_MATRIX_SCALING_FACTOR = 668, // WEIGHTING_MATRIX_SCALING_FACTOR
        S_ANALYTIC_STANDARD_ERRORS = 669,        // ANALYTIC_STANDARD_ERRORS
        S_ANALYTIC_JACOBIAN = 670,               // ANALYTIC_JACOBIAN
        S_PENALIZED_ESTIMATOR = 671,             // PENALIZED_ESTIMATOR
        S_VERBOSE = 672,                         // VERBOSE
        S_SIMULATION_MULTIPLE = 673,             // SIMULATION_MULTIPLE
        S_MOM_SEED = 674,                        // MOM_SEED
        S_SEED = 675,                            // SEED
        S_BOUNDED_SHOCK_SUPPORT = 676,           // BOUNDED_SHOCK_SUPPORT
        S_ADDITIONAL_OPTIMIZER_STEPS = 677,      // ADDITIONAL_OPTIMIZER_STEPS
        S_MOM_SE_TOLX = 678,                     // MOM_SE_TOLX
        S_SE_TOLX = 679,                         // SE_TOLX
        S_MOM_BURNIN = 680,                      // MOM_BURNIN
        S_BURNIN = 681,                          // BURNIN
        S_EQTAGS = 682,                          // EQTAGS
        S_ANALYTICAL_GIRF = 683,                 // ANALYTICAL_GIRF
        S_IRF_IN_PERCENT = 684,                  // IRF_IN_PERCENT
        S_EMAS_GIRF = 685,                       // EMAS_GIRF
        S_EMAS_DROP = 686,                       // EMAS_DROP
        S_EMAS_TOLF = 687,                       // EMAS_TOLF
        S_EMAS_MAX_ITER = 688,                   // EMAS_MAX_ITER
        S_NO_IDENTIFICATION_STRENGTH = 689,      // NO_IDENTIFICATION_STRENGTH
        S_NO_IDENTIFICATION_REDUCEDFORM = 690,   // NO_IDENTIFICATION_REDUCEDFORM
        S_NO_IDENTIFICATION_MOMENTS = 691,       // NO_IDENTIFICATION_MOMENTS
        S_NO_IDENTIFICATION_MINIMAL = 692,       // NO_IDENTIFICATION_MINIMAL
        S_NO_IDENTIFICATION_SPECTRUM = 693,      // NO_IDENTIFICATION_SPECTRUM
        S_NORMALIZE_JACOBIANS = 694,             // NORMALIZE_JACOBIANS
        S_GRID_NBR = 695,                        // GRID_NBR
        S_TOL_RANK = 696,                        // TOL_RANK
        S_TOL_DERIV = 697,                       // TOL_DERIV
        S_TOL_SV = 698,                          // TOL_SV
        S_CHECKS_VIA_SUBSETS = 699,              // CHECKS_VIA_SUBSETS
        S_MAX_DIM_SUBSETS_GROUPS = 700,          // MAX_DIM_SUBSETS_GROUPS
        S_ZERO_MOMENTS_TOLERANCE = 701,          // ZERO_MOMENTS_TOLERANCE
        S_MAX_NROWS = 702,                       // MAX_NROWS
        S_SQUEEZE_SHOCK_DECOMPOSITION = 703,     // SQUEEZE_SHOCK_DECOMPOSITION
        S_WITH_EPILOGUE = 704,                   // WITH_EPILOGUE
        S_STATIC = 705,                          // STATIC
        S_INCIDENCE = 706,                       // INCIDENCE
        S_SYMBOL_VEC = 707,                      // SYMBOL_VEC
        S_708_ = 708,                            // ';'
        S_709_ = 709,                            // '('
        S_710_ = 710,                            // ')'
        S_711_ = 711,                            // '['
        S_712_ = 712,                            // ']'
        S_713_ = 713,                            // '#'
        S_714_ = 714,                            // ':'
        S_715_ = 715,                            // '.'
        S_YYACCEPT = 716,                        // $accept
        S_statement_list = 717,                  // statement_list
        S_statement = 718,                       // statement
        S_dsample = 719,                         // dsample
        S_rplot = 720,                           // rplot
        S_trend_var = 721,                       // trend_var
        S_722_1 = 722,                           // $@1
        S_trend_var_list = 723,                  // trend_var_list
        S_log_trend_var = 724,                   // log_trend_var
        S_725_2 = 725,                           // $@2
        S_log_trend_var_list = 726,              // log_trend_var_list
        S_var = 727,                             // var
        S_728_3 = 728,                           // $@3
        S_729_4 = 729,                           // $@4
        S_var_model = 730,                       // var_model
        S_var_model_options_list = 731,          // var_model_options_list
        S_var_model_options = 732,               // var_model_options
        S_trend_component_model = 733,           // trend_component_model
        S_trend_component_model_options_list = 734, // trend_component_model_options_list
        S_trend_component_model_options = 735,   // trend_component_model_options
        S_pac_model = 736,                       // pac_model
        S_737_5 = 737,                           // $@5
        S_pac_model_options_list = 738,          // pac_model_options_list
        S_pac_model_options = 739,               // pac_model_options
        S_var_expectation_model = 740,           // var_expectation_model
        S_var_expectation_model_options_list = 741, // var_expectation_model_options_list
        S_var_expectation_model_option = 742,    // var_expectation_model_option
        S_743_6 = 743,                           // $@6
        S_nonstationary_var_list = 744,          // nonstationary_var_list
        S_varexo = 745,                          // varexo
        S_varexo_det = 746,                      // varexo_det
        S_predetermined_variables = 747,         // predetermined_variables
        S_parameters = 748,                      // parameters
        S_model_local_variable = 749,            // model_local_variable
        S_named_var_elem = 750,                  // named_var_elem
        S_named_var_1 = 751,                     // named_var_1
        S_named_var = 752,                       // named_var
        S_var_list = 753,                        // var_list
        S_varexo_list = 754,                     // varexo_list
        S_varexo_det_list = 755,                 // varexo_det_list
        S_parameter_list = 756,                  // parameter_list
        S_predetermined_variables_list = 757,    // predetermined_variables_list
        S_model_local_variable_list = 758,       // model_local_variable_list
        S_change_type = 759,                     // change_type
        S_change_type_arg = 760,                 // change_type_arg
        S_change_type_var_list = 761,            // change_type_var_list
        S_periods = 762,                         // periods
        S_init_param = 763,                      // init_param
        S_expression = 764,                      // expression
        S_765_7 = 765,                           // $@7
        S_comma_expression = 766,                // comma_expression
        S_expression_or_empty = 767,             // expression_or_empty
        S_initval = 768,                         // initval
        S_histval_file = 769,                    // histval_file
        S_initval_file = 770,                    // initval_file
        S_h_options_list = 771,                  // h_options_list
        S_h_options = 772,                       // h_options
        S_endval = 773,                          // endval
        S_initval_list = 774,                    // initval_list
        S_initval_elem = 775,                    // initval_elem
        S_histval = 776,                         // histval
        S_histval_list = 777,                    // histval_list
        S_histval_elem = 778,                    // histval_elem
        S_epilogue = 779,                        // epilogue
        S_780_8 = 780,                           // $@8
        S_epilogue_equation_list = 781,          // epilogue_equation_list
        S_epilogue_equation = 782,               // epilogue_equation
        S_783_9 = 783,                           // $@9
        S_compilation_setup = 784,               // compilation_setup
        S_compilation_setup_options_list = 785,  // compilation_setup_options_list
        S_compilation_setup_option = 786,        // compilation_setup_option
        S_matched_moments = 787,                 // matched_moments
        S_788_10 = 788,                          // $@10
        S_matched_moments_list = 789,            // matched_moments_list
        S_occbin_constraints = 790,              // occbin_constraints
        S_791_11 = 791,                          // $@11
        S_occbin_constraints_regimes_list = 792, // occbin_constraints_regimes_list
        S_occbin_constraints_regime = 793,       // occbin_constraints_regime
        S_occbin_constraints_regime_options_list = 794, // occbin_constraints_regime_options_list
        S_occbin_constraints_regime_option = 795, // occbin_constraints_regime_option
        S_model_options = 796,                   // model_options
        S_model_options_list = 797,              // model_options_list
        S_model = 798,                           // model
        S_799_12 = 799,                          // $@12
        S_800_13 = 800,                          // $@13
        S_equation_list = 801,                   // equation_list
        S_equation = 802,                        // equation
        S_tags_list = 803,                       // tags_list
        S_tag_pair = 804,                        // tag_pair
        S_hand_side = 805,                       // hand_side
        S_806_14 = 806,                          // $@14
        S_comma_hand_side = 807,                 // comma_hand_side
        S_pound_expression = 808,                // pound_expression
        S_shocks = 809,                          // shocks
        S_shock_list = 810,                      // shock_list
        S_shock_elem = 811,                      // shock_elem
        S_det_shock_elem = 812,                  // det_shock_elem
        S_surprise_shock_list = 813,             // surprise_shock_list
        S_heteroskedastic_shocks = 814,          // heteroskedastic_shocks
        S_heteroskedastic_shock_list = 815,      // heteroskedastic_shock_list
        S_heteroskedastic_shock_elem = 816,      // heteroskedastic_shock_elem
        S_svar_identification = 817,             // svar_identification
        S_818_15 = 818,                          // $@15
        S_svar_identification_list = 819,        // svar_identification_list
        S_svar_identification_elem = 820,        // svar_identification_elem
        S_821_16 = 821,                          // $@16
        S_822_17 = 822,                          // $@17
        S_svar_equation_list = 823,              // svar_equation_list
        S_svar_var_list = 824,                   // svar_var_list
        S_restriction_expression = 825,          // restriction_expression
        S_restriction_expression_1 = 826,        // restriction_expression_1
        S_restriction_elem_expression = 827,     // restriction_elem_expression
        S_svar_global_identification_check = 828, // svar_global_identification_check
        S_markov_switching = 829,                // markov_switching
        S_ms_options_list = 830,                 // ms_options_list
        S_ms_options = 831,                      // ms_options
        S_svar = 832,                            // svar
        S_svar_options_list = 833,               // svar_options_list
        S_svar_options = 834,                    // svar_options
        S_mshocks = 835,                         // mshocks
        S_mshock_list = 836,                     // mshock_list
        S_period_list = 837,                     // period_list
        S_sigma_e = 838,                         // sigma_e
        S_value_list = 839,                      // value_list
        S_triangular_matrix = 840,               // triangular_matrix
        S_triangular_row = 841,                  // triangular_row
        S_steady = 842,                          // steady
        S_steady_options_list = 843,             // steady_options_list
        S_steady_options = 844,                  // steady_options
        S_check = 845,                           // check
        S_check_options_list = 846,              // check_options_list
        S_check_options = 847,                   // check_options
        S_model_info = 848,                      // model_info
        S_model_info_options_list = 849,         // model_info_options_list
        S_model_info_options = 850,              // model_info_options
        S_perfect_foresight_setup = 851,         // perfect_foresight_setup
        S_perfect_foresight_setup_options_list = 852, // perfect_foresight_setup_options_list
        S_perfect_foresight_setup_options = 853, // perfect_foresight_setup_options
        S_perfect_foresight_solver = 854,        // perfect_foresight_solver
        S_perfect_foresight_solver_options_list = 855, // perfect_foresight_solver_options_list
        S_perfect_foresight_solver_options = 856, // perfect_foresight_solver_options
        S_perfect_foresight_with_expectation_errors_setup = 857, // perfect_foresight_with_expectation_errors_setup
        S_perfect_foresight_with_expectation_errors_setup_options_list = 858, // perfect_foresight_with_expectation_errors_setup_options_list
        S_perfect_foresight_with_expectation_errors_setup_options = 859, // perfect_foresight_with_expectation_errors_setup_options
        S_perfect_foresight_with_expectation_errors_solver = 860, // perfect_foresight_with_expectation_errors_solver
        S_perfect_foresight_with_expectation_errors_solver_options_list = 861, // perfect_foresight_with_expectation_errors_solver_options_list
        S_perfect_foresight_with_expectation_errors_solver_options = 862, // perfect_foresight_with_expectation_errors_solver_options
        S_method_of_moments = 863,               // method_of_moments
        S_method_of_moments_options_list = 864,  // method_of_moments_options_list
        S_method_of_moments_option = 865,        // method_of_moments_option
        S_prior_function = 866,                  // prior_function
        S_posterior_function = 867,              // posterior_function
        S_prior_posterior_function_options_list = 868, // prior_posterior_function_options_list
        S_prior_posterior_function_options = 869, // prior_posterior_function_options
        S_simul = 870,                           // simul
        S_simul_options_list = 871,              // simul_options_list
        S_simul_options = 872,                   // simul_options
        S_external_function = 873,               // external_function
        S_external_function_options_list = 874,  // external_function_options_list
        S_external_function_options = 875,       // external_function_options
        S_stoch_simul = 876,                     // stoch_simul
        S_stoch_simul_options_list = 877,        // stoch_simul_options_list
        S_stoch_simul_primary_options = 878,     // stoch_simul_primary_options
        S_stoch_simul_options = 879,             // stoch_simul_options
        S_symbol_list = 880,                     // symbol_list
        S_symbol_list_ext = 881,                 // symbol_list_ext
        S_signed_integer = 882,                  // signed_integer
        S_non_negative_number = 883,             // non_negative_number
        S_signed_number = 884,                   // signed_number
        S_signed_inf = 885,                      // signed_inf
        S_signed_number_w_inf = 886,             // signed_number_w_inf
        S_boolean = 887,                         // boolean
        S_estimated_params = 888,                // estimated_params
        S_estimated_list = 889,                  // estimated_list
        S_estimated_elem = 890,                  // estimated_elem
        S_estimated_elem1 = 891,                 // estimated_elem1
        S_estimated_elem2 = 892,                 // estimated_elem2
        S_estimated_elem3 = 893,                 // estimated_elem3
        S_estimated_params_init = 894,           // estimated_params_init
        S_estimated_init_list = 895,             // estimated_init_list
        S_estimated_init_elem = 896,             // estimated_init_elem
        S_estimated_params_bounds = 897,         // estimated_params_bounds
        S_estimated_bounds_list = 898,           // estimated_bounds_list
        S_estimated_bounds_elem = 899,           // estimated_bounds_elem
        S_osr_params_bounds = 900,               // osr_params_bounds
        S_osr_bounds_list = 901,                 // osr_bounds_list
        S_osr_bounds_elem = 902,                 // osr_bounds_elem
        S_prior_distribution = 903,              // prior_distribution
        S_prior_pdf = 904,                       // prior_pdf
        S_date_str = 905,                        // date_str
        S_date_expr = 906,                       // date_expr
        S_set_time = 907,                        // set_time
        S_data = 908,                            // data
        S_data_options_list = 909,               // data_options_list
        S_data_options = 910,                    // data_options
        S_subsamples = 911,                      // subsamples
        S_subsamples_eq = 912,                   // subsamples_eq
        S_subsamples_eq_opt = 913,               // subsamples_eq_opt
        S_subsamples_name_list = 914,            // subsamples_name_list
        S_prior = 915,                           // prior
        S_916_18 = 916,                          // $@18
        S_917_19 = 917,                          // $@19
        S_918_20 = 918,                          // $@20
        S_919_21 = 919,                          // $@21
        S_920_22 = 920,                          // $@22
        S_921_23 = 921,                          // $@23
        S_922_24 = 922,                          // $@24
        S_prior_options_list = 923,              // prior_options_list
        S_prior_options = 924,                   // prior_options
        S_joint_prior_options_list = 925,        // joint_prior_options_list
        S_joint_prior_options = 926,             // joint_prior_options
        S_prior_eq = 927,                        // prior_eq
        S_prior_eq_opt = 928,                    // prior_eq_opt
        S_options = 929,                         // options
        S_options_options_list = 930,            // options_options_list
        S_options_options = 931,                 // options_options
        S_options_eq = 932,                      // options_eq
        S_options_eq_opt = 933,                  // options_eq_opt
        S_estimation = 934,                      // estimation
        S_estimation_options_list = 935,         // estimation_options_list
        S_estimation_options = 936,              // estimation_options
        S_name_value_pair = 937,                 // name_value_pair
        S_name_value_pair_list = 938,            // name_value_pair_list
        S_name_value_pair_with_boolean = 939,    // name_value_pair_with_boolean
        S_name_value_pair_with_boolean_list = 940, // name_value_pair_with_boolean_list
        S_name_value_pair_with_suboptions = 941, // name_value_pair_with_suboptions
        S_name_value_pair_with_suboptions_list = 942, // name_value_pair_with_suboptions_list
        S_varobs = 943,                          // varobs
        S_944_25 = 944,                          // $@25
        S_varobs_list = 945,                     // varobs_list
        S_varexobs = 946,                        // varexobs
        S_947_26 = 947,                          // $@26
        S_varexobs_list = 948,                   // varexobs_list
        S_deterministic_trends = 949,            // deterministic_trends
        S_observation_trends = 950,              // observation_trends
        S_trend_list = 951,                      // trend_list
        S_trend_element = 952,                   // trend_element
        S_filter_initial_state = 953,            // filter_initial_state
        S_filter_initial_state_list = 954,       // filter_initial_state_list
        S_filter_initial_state_element = 955,    // filter_initial_state_element
        S_unit_root_vars = 956,                  // unit_root_vars
        S_optim_weights = 957,                   // optim_weights
        S_optim_weights_list = 958,              // optim_weights_list
        S_osr_params = 959,                      // osr_params
        S_osr_options_list = 960,                // osr_options_list
        S_osr_options = 961,                     // osr_options
        S_osr = 962,                             // osr
        S_dynatype = 963,                        // dynatype
        S_dynasave = 964,                        // dynasave
        S_load_params_and_steady_state = 965,    // load_params_and_steady_state
        S_save_params_and_steady_state = 966,    // save_params_and_steady_state
        S_identification = 967,                  // identification
        S_identification_options_list = 968,     // identification_options_list
        S_identification_option = 969,           // identification_option
        S_model_comparison = 970,                // model_comparison
        S_filename = 971,                        // filename
        S_namespace_qualified_symbol = 972,      // namespace_qualified_symbol
        S_namespace_qualified_filename = 973,    // namespace_qualified_filename
        S_parallel_local_filename_list = 974,    // parallel_local_filename_list
        S_mc_filename_list = 975,                // mc_filename_list
        S_planner_objective = 976,               // planner_objective
        S_977_27 = 977,                          // $@27
        S_978_28 = 978,                          // $@28
        S_ramsey_model = 979,                    // ramsey_model
        S_ramsey_policy = 980,                   // ramsey_policy
        S_ramsey_constraints = 981,              // ramsey_constraints
        S_ramsey_constraints_list = 982,         // ramsey_constraints_list
        S_ramsey_constraint = 983,               // ramsey_constraint
        S_evaluate_planner_objective = 984,      // evaluate_planner_objective
        S_occbin_setup = 985,                    // occbin_setup
        S_occbin_setup_options_list = 986,       // occbin_setup_options_list
        S_occbin_setup_option = 987,             // occbin_setup_option
        S_occbin_solver = 988,                   // occbin_solver
        S_occbin_solver_options_list = 989,      // occbin_solver_options_list
        S_occbin_solver_option = 990,            // occbin_solver_option
        S_occbin_write_regimes = 991,            // occbin_write_regimes
        S_occbin_write_regimes_options_list = 992, // occbin_write_regimes_options_list
        S_occbin_write_regimes_option = 993,     // occbin_write_regimes_option
        S_occbin_graph = 994,                    // occbin_graph
        S_occbin_graph_options_list = 995,       // occbin_graph_options_list
        S_occbin_graph_option = 996,             // occbin_graph_option
        S_discretionary_policy = 997,            // discretionary_policy
        S_discretionary_policy_options_list = 998, // discretionary_policy_options_list
        S_discretionary_policy_options = 999,    // discretionary_policy_options
        S_ramsey_model_options_list = 1000,      // ramsey_model_options_list
        S_ramsey_model_options = 1001,           // ramsey_model_options
        S_ramsey_policy_options_list = 1002,     // ramsey_policy_options_list
        S_ramsey_policy_options = 1003,          // ramsey_policy_options
        S_write_latex_dynamic_model = 1004,      // write_latex_dynamic_model
        S_write_latex_static_model = 1005,       // write_latex_static_model
        S_write_latex_original_model = 1006,     // write_latex_original_model
        S_write_latex_steady_state_model = 1007, // write_latex_steady_state_model
        S_shock_decomposition = 1008,            // shock_decomposition
        S_realtime_shock_decomposition = 1009,   // realtime_shock_decomposition
        S_plot_shock_decomposition = 1010,       // plot_shock_decomposition
        S_initial_condition_decomposition = 1011, // initial_condition_decomposition
        S_squeeze_shock_decomposition = 1012,    // squeeze_shock_decomposition
        S_bvar_prior_option = 1013,              // bvar_prior_option
        S_bvar_common_option = 1014,             // bvar_common_option
        S_bvar_density_options_list = 1015,      // bvar_density_options_list
        S_bvar_density = 1016,                   // bvar_density
        S_bvar_forecast_option = 1017,           // bvar_forecast_option
        S_bvar_forecast_options_list = 1018,     // bvar_forecast_options_list
        S_bvar_forecast = 1019,                  // bvar_forecast
        S_sbvar_option = 1020,                   // sbvar_option
        S_sbvar_options_list = 1021,             // sbvar_options_list
        S_sbvar = 1022,                          // sbvar
        S_ms_variance_decomposition_option = 1023, // ms_variance_decomposition_option
        S_ms_variance_decomposition_options_list = 1024, // ms_variance_decomposition_options_list
        S_ms_variance_decomposition = 1025,      // ms_variance_decomposition
        S_ms_forecast_option = 1026,             // ms_forecast_option
        S_ms_forecast_options_list = 1027,       // ms_forecast_options_list
        S_ms_forecast = 1028,                    // ms_forecast
        S_ms_irf_option = 1029,                  // ms_irf_option
        S_ms_irf_options_list = 1030,            // ms_irf_options_list
        S_ms_irf = 1031,                         // ms_irf
        S_ms_compute_probabilities_option = 1032, // ms_compute_probabilities_option
        S_ms_compute_probabilities_options_list = 1033, // ms_compute_probabilities_options_list
        S_ms_compute_probabilities = 1034,       // ms_compute_probabilities
        S_ms_compute_mdd_option = 1035,          // ms_compute_mdd_option
        S_ms_compute_mdd_options_list = 1036,    // ms_compute_mdd_options_list
        S_ms_compute_mdd = 1037,                 // ms_compute_mdd
        S_ms_simulation_option = 1038,           // ms_simulation_option
        S_ms_simulation_options_list = 1039,     // ms_simulation_options_list
        S_ms_simulation = 1040,                  // ms_simulation
        S_ms_estimation_option = 1041,           // ms_estimation_option
        S_ms_estimation_options_list = 1042,     // ms_estimation_options_list
        S_ms_estimation = 1043,                  // ms_estimation
        S_dynare_sensitivity = 1044,             // dynare_sensitivity
        S_dynare_sensitivity_options_list = 1045, // dynare_sensitivity_options_list
        S_dynare_sensitivity_option = 1046,      // dynare_sensitivity_option
        S_shock_decomposition_options_list = 1047, // shock_decomposition_options_list
        S_shock_decomposition_option = 1048,     // shock_decomposition_option
        S_realtime_shock_decomposition_options_list = 1049, // realtime_shock_decomposition_options_list
        S_realtime_shock_decomposition_option = 1050, // realtime_shock_decomposition_option
        S_plot_shock_decomposition_options_list = 1051, // plot_shock_decomposition_options_list
        S_plot_shock_decomposition_option = 1052, // plot_shock_decomposition_option
        S_initial_condition_decomposition_options_list = 1053, // initial_condition_decomposition_options_list
        S_initial_condition_decomposition_option = 1054, // initial_condition_decomposition_option
        S_homotopy_setup = 1055,                 // homotopy_setup
        S_homotopy_list = 1056,                  // homotopy_list
        S_homotopy_item = 1057,                  // homotopy_item
        S_forecast = 1058,                       // forecast
        S_forecast_options = 1059,               // forecast_options
        S_forecast_option = 1060,                // forecast_option
        S_conditional_forecast = 1061,           // conditional_forecast
        S_conditional_forecast_options = 1062,   // conditional_forecast_options
        S_conditional_forecast_option = 1063,    // conditional_forecast_option
        S_plot_conditional_forecast = 1064,      // plot_conditional_forecast
        S_conditional_forecast_paths = 1065,     // conditional_forecast_paths
        S_conditional_forecast_paths_shock_list = 1066, // conditional_forecast_paths_shock_list
        S_conditional_forecast_paths_shock_elem = 1067, // conditional_forecast_paths_shock_elem
        S_steady_state_model = 1068,             // steady_state_model
        S_1069_29 = 1069,                        // $@29
        S_steady_state_equation_list = 1070,     // steady_state_equation_list
        S_steady_state_equation = 1071,          // steady_state_equation
        S_calib_smoother = 1072,                 // calib_smoother
        S_calib_smoother_options_list = 1073,    // calib_smoother_options_list
        S_calib_smoother_option = 1074,          // calib_smoother_option
        S_generate_irfs = 1075,                  // generate_irfs
        S_generate_irfs_options_list = 1076,     // generate_irfs_options_list
        S_generate_irfs_option = 1077,           // generate_irfs_option
        S_generate_irfs_element_list = 1078,     // generate_irfs_element_list
        S_generate_irfs_element = 1079,          // generate_irfs_element
        S_generate_irfs_exog_element_list = 1080, // generate_irfs_exog_element_list
        S_extended_path = 1081,                  // extended_path
        S_extended_path_options_list = 1082,     // extended_path_options_list
        S_extended_path_option = 1083,           // extended_path_option
        S_model_diagnostics = 1084,              // model_diagnostics
        S_calibration_range = 1085,              // calibration_range
        S_moment_calibration = 1086,             // moment_calibration
        S_moment_calibration_list = 1087,        // moment_calibration_list
        S_moment_calibration_item = 1088,        // moment_calibration_item
        S_irf_calibration = 1089,                // irf_calibration
        S_irf_calibration_list = 1090,           // irf_calibration_list
        S_irf_calibration_item = 1091,           // irf_calibration_item
        S_smoother2histval = 1092,               // smoother2histval
        S_smoother2histval_options_list = 1093,  // smoother2histval_options_list
        S_smoother2histval_option = 1094,        // smoother2histval_option
        S_shock_groups = 1095,                   // shock_groups
        S_shock_group_list = 1096,               // shock_group_list
        S_shock_group_element = 1097,            // shock_group_element
        S_shock_name_list = 1098,                // shock_name_list
        S_init2shocks = 1099,                    // init2shocks
        S_init2shocks_list = 1100,               // init2shocks_list
        S_init2shocks_element = 1101,            // init2shocks_element
        S_o_dr_algo = 1102,                      // o_dr_algo
        S_o_solve_algo = 1103,                   // o_solve_algo
        S_o_simul_algo = 1104,                   // o_simul_algo
        S_o_stack_solve_algo = 1105,             // o_stack_solve_algo
        S_o_robust_lin_solve = 1106,             // o_robust_lin_solve
        S_o_endogenous_terminal_period = 1107,   // o_endogenous_terminal_period
        S_o_linear = 1108,                       // o_linear
        S_o_order = 1109,                        // o_order
        S_o_replic = 1110,                       // o_replic
        S_o_drop = 1111,                         // o_drop
        S_o_ar = 1112,                           // o_ar
        S_o_nocorr = 1113,                       // o_nocorr
        S_o_nofunctions = 1114,                  // o_nofunctions
        S_o_nomoments = 1115,                    // o_nomoments
        S_o_irf = 1116,                          // o_irf
        S_o_irf_shocks = 1117,                   // o_irf_shocks
        S_o_hp_filter = 1118,                    // o_hp_filter
        S_o_hp_ngrid = 1119,                     // o_hp_ngrid
        S_o_filtered_theoretical_moments_grid = 1120, // o_filtered_theoretical_moments_grid
        S_o_one_sided_hp_filter = 1121,          // o_one_sided_hp_filter
        S_o_periods = 1122,                      // o_periods
        S_o_solver_periods = 1123,               // o_solver_periods
        S_o_extended_path_order = 1124,          // o_extended_path_order
        S_o_hybrid = 1125,                       // o_hybrid
        S_o_steady_maxit = 1126,                 // o_steady_maxit
        S_o_simul_maxit = 1127,                  // o_simul_maxit
        S_o_bandpass_filter = 1128,              // o_bandpass_filter
        S_o_dp_maxit = 1129,                     // o_dp_maxit
        S_o_osr_maxit = 1130,                    // o_osr_maxit
        S_o_osr_tolf = 1131,                     // o_osr_tolf
        S_o_pf_tolf = 1132,                      // o_pf_tolf
        S_o_pf_tolx = 1133,                      // o_pf_tolx
        S_o_steady_tolf = 1134,                  // o_steady_tolf
        S_o_opt_algo = 1135,                     // o_opt_algo
        S_o_cutoff = 1136,                       // o_cutoff
        S_o_markowitz = 1137,                    // o_markowitz
        S_o_minimal_solving_periods = 1138,      // o_minimal_solving_periods
        S_o_mfs = 1139,                          // o_mfs
        S_o_simul = 1140,                        // o_simul
        S_o_simul_replic = 1141,                 // o_simul_replic
        S_o_simul_seed = 1142,                   // o_simul_seed
        S_o_qz_criterium = 1143,                 // o_qz_criterium
        S_o_qz_zero_threshold = 1144,            // o_qz_zero_threshold
        S_o_file = 1145,                         // o_file
        S_o_pac_name = 1146,                     // o_pac_name
        S_o_pac_aux_model_name = 1147,           // o_pac_aux_model_name
        S_o_pac_discount = 1148,                 // o_pac_discount
        S_o_pac_growth = 1149,                   // o_pac_growth
        S_1150_30 = 1150,                        // $@30
        S_o_var_name = 1151,                     // o_var_name
        S_o_series = 1152,                       // o_series
        S_o_datafile = 1153,                     // o_datafile
        S_o_filename = 1154,                     // o_filename
        S_o_var_eq_tags = 1155,                  // o_var_eq_tags
        S_o_var_structural = 1156,               // o_var_structural
        S_o_dirname = 1157,                      // o_dirname
        S_o_huge_number = 1158,                  // o_huge_number
        S_o_nobs = 1159,                         // o_nobs
        S_o_trend_component_model_name = 1160,   // o_trend_component_model_name
        S_o_trend_component_model_targets = 1161, // o_trend_component_model_targets
        S_o_trend_component_model_eq_tags = 1162, // o_trend_component_model_eq_tags
        S_o_conditional_variance_decomposition = 1163, // o_conditional_variance_decomposition
        S_o_est_first_obs = 1164,                // o_est_first_obs
        S_o_posterior_sampling_method = 1165,    // o_posterior_sampling_method
        S_o_first_obs = 1166,                    // o_first_obs
        S_o_data_first_obs = 1167,               // o_data_first_obs
        S_o_first_simulation_period = 1168,      // o_first_simulation_period
        S_o_date_first_simulation_period = 1169, // o_date_first_simulation_period
        S_o_last_obs = 1170,                     // o_last_obs
        S_o_data_last_obs = 1171,                // o_data_last_obs
        S_o_keep_kalman_algo_if_singularity_is_detected = 1172, // o_keep_kalman_algo_if_singularity_is_detected
        S_o_data_nobs = 1173,                    // o_data_nobs
        S_o_shift = 1174,                        // o_shift
        S_o_shape = 1175,                        // o_shape
        S_o_mode = 1176,                         // o_mode
        S_o_mean = 1177,                         // o_mean
        S_o_mean_vec = 1178,                     // o_mean_vec
        S_o_truncate = 1179,                     // o_truncate
        S_o_stdev = 1180,                        // o_stdev
        S_o_jscale = 1181,                       // o_jscale
        S_o_init = 1182,                         // o_init
        S_o_bounds = 1183,                       // o_bounds
        S_o_domain = 1184,                       // o_domain
        S_o_interval = 1185,                     // o_interval
        S_o_variance = 1186,                     // o_variance
        S_o_variance_mat = 1187,                 // o_variance_mat
        S_o_prefilter = 1188,                    // o_prefilter
        S_o_presample = 1189,                    // o_presample
        S_o_lik_algo = 1190,                     // o_lik_algo
        S_o_lik_init = 1191,                     // o_lik_init
        S_o_nograph = 1192,                      // o_nograph
        S_o_posterior_nograph = 1193,            // o_posterior_nograph
        S_o_psd_nograph = 1194,                  // o_psd_nograph
        S_o_shock_decomposition_nograph = 1195,  // o_shock_decomposition_nograph
        S_o_init_state = 1196,                   // o_init_state
        S_o_forecast_type = 1197,                // o_forecast_type
        S_o_shock_decomposition_presample = 1198, // o_shock_decomposition_presample
        S_o_shock_decomposition_forecast = 1199, // o_shock_decomposition_forecast
        S_o_save_realtime = 1200,                // o_save_realtime
        S_o_fast_realtime = 1201,                // o_fast_realtime
        S_o_nodisplay = 1202,                    // o_nodisplay
        S_o_icd_nodisplay = 1203,                // o_icd_nodisplay
        S_o_psd_nodisplay = 1204,                // o_psd_nodisplay
        S_o_psd_init2shocks = 1205,              // o_psd_init2shocks
        S_o_icd_max_nrows = 1206,                // o_icd_max_nrows
        S_o_psd_max_nrows = 1207,                // o_psd_max_nrows
        S_o_graph_format = 1208,                 // o_graph_format
        S_o_icd_graph_format = 1209,             // o_icd_graph_format
        S_o_psd_graph_format = 1210,             // o_psd_graph_format
        S_o_shock_decomposition_with_epilogue = 1211, // o_shock_decomposition_with_epilogue
        S_o_icd_with_epilogue = 1212,            // o_icd_with_epilogue
        S_allowed_graph_formats = 1213,          // allowed_graph_formats
        S_list_allowed_graph_formats = 1214,     // list_allowed_graph_formats
        S_o_subsample_name = 1215,               // o_subsample_name
        S_o_bvar_conf_sig = 1216,                // o_bvar_conf_sig
        S_o_forecasts_conf_sig = 1217,           // o_forecasts_conf_sig
        S_o_conditional_forecast_conf_sig = 1218, // o_conditional_forecast_conf_sig
        S_o_mh_conf_sig = 1219,                  // o_mh_conf_sig
        S_o_mh_replic = 1220,                    // o_mh_replic
        S_o_posterior_max_subsample_draws = 1221, // o_posterior_max_subsample_draws
        S_o_mh_drop = 1222,                      // o_mh_drop
        S_o_mh_jscale = 1223,                    // o_mh_jscale
        S_o_mh_tune_jscale = 1224,               // o_mh_tune_jscale
        S_o_mh_tune_guess = 1225,                // o_mh_tune_guess
        S_o_optim = 1226,                        // o_optim
        S_o_posterior_sampler_options = 1227,    // o_posterior_sampler_options
        S_o_proposal_distribution = 1228,        // o_proposal_distribution
        S_o_no_posterior_kernel_density = 1229,  // o_no_posterior_kernel_density
        S_o_mh_init_scale = 1230,                // o_mh_init_scale
        S_o_mode_file = 1231,                    // o_mode_file
        S_o_mode_compute = 1232,                 // o_mode_compute
        S_o_mode_check = 1233,                   // o_mode_check
        S_o_mode_check_neighbourhood_size = 1234, // o_mode_check_neighbourhood_size
        S_o_mode_check_number_of_points = 1235,  // o_mode_check_number_of_points
        S_o_mode_check_symmetric_plots = 1236,   // o_mode_check_symmetric_plots
        S_o_prior_trunc = 1237,                  // o_prior_trunc
        S_o_mh_posterior_mode_estimation = 1238, // o_mh_posterior_mode_estimation
        S_o_mh_nblocks = 1239,                   // o_mh_nblocks
        S_o_load_mh_file = 1240,                 // o_load_mh_file
        S_o_load_results_after_load_mh = 1241,   // o_load_results_after_load_mh
        S_o_loglinear = 1242,                    // o_loglinear
        S_o_linear_approximation = 1243,         // o_linear_approximation
        S_o_logdata = 1244,                      // o_logdata
        S_o_nodiagnostic = 1245,                 // o_nodiagnostic
        S_o_bayesian_irf = 1246,                 // o_bayesian_irf
        S_o_dsge_var = 1247,                     // o_dsge_var
        S_o_dsge_varlag = 1248,                  // o_dsge_varlag
        S_o_tex = 1249,                          // o_tex
        S_o_forecast = 1250,                     // o_forecast
        S_o_smoother = 1251,                     // o_smoother
        S_o_moments_varendo = 1252,              // o_moments_varendo
        S_o_contemporaneous_correlation = 1253,  // o_contemporaneous_correlation
        S_o_filtered_vars = 1254,                // o_filtered_vars
        S_o_relative_irf = 1255,                 // o_relative_irf
        S_o_fast_kalman_filter = 1256,           // o_fast_kalman_filter
        S_o_kalman_algo = 1257,                  // o_kalman_algo
        S_o_kalman_tol = 1258,                   // o_kalman_tol
        S_o_diffuse_kalman_tol = 1259,           // o_diffuse_kalman_tol
        S_o_schur_vec_tol = 1260,                // o_schur_vec_tol
        S_o_marginal_density = 1261,             // o_marginal_density
        S_o_print = 1262,                        // o_print
        S_o_noprint = 1263,                      // o_noprint
        S_o_xls_sheet = 1264,                    // o_xls_sheet
        S_o_xls_range = 1265,                    // o_xls_range
        S_o_filter_step_ahead = 1266,            // o_filter_step_ahead
        S_o_taper_steps = 1267,                  // o_taper_steps
        S_o_geweke_interval = 1268,              // o_geweke_interval
        S_o_raftery_lewis_diagnostics = 1269,    // o_raftery_lewis_diagnostics
        S_o_raftery_lewis_qrs = 1270,            // o_raftery_lewis_qrs
        S_o_constant = 1271,                     // o_constant
        S_o_noconstant = 1272,                   // o_noconstant
        S_o_mh_recover = 1273,                   // o_mh_recover
        S_o_mh_initialize_from_previous_mcmc = 1274, // o_mh_initialize_from_previous_mcmc
        S_o_mh_initialize_from_previous_mcmc_directory = 1275, // o_mh_initialize_from_previous_mcmc_directory
        S_o_mh_initialize_from_previous_mcmc_record = 1276, // o_mh_initialize_from_previous_mcmc_record
        S_o_mh_initialize_from_previous_mcmc_prior = 1277, // o_mh_initialize_from_previous_mcmc_prior
        S_o_diffuse_filter = 1278,               // o_diffuse_filter
        S_o_plot_priors = 1279,                  // o_plot_priors
        S_o_aim_solver = 1280,                   // o_aim_solver
        S_o_partial_information = 1281,          // o_partial_information
        S_o_sub_draws = 1282,                    // o_sub_draws
        S_o_planner_discount = 1283,             // o_planner_discount
        S_o_planner_discount_latex_name = 1284,  // o_planner_discount_latex_name
        S_o_sylvester = 1285,                    // o_sylvester
        S_o_sylvester_fixed_point_tol = 1286,    // o_sylvester_fixed_point_tol
        S_o_lyapunov = 1287,                     // o_lyapunov
        S_o_lyapunov_complex_threshold = 1288,   // o_lyapunov_complex_threshold
        S_o_lyapunov_fixed_point_tol = 1289,     // o_lyapunov_fixed_point_tol
        S_o_lyapunov_doubling_tol = 1290,        // o_lyapunov_doubling_tol
        S_o_dr = 1291,                           // o_dr
        S_o_dr_cycle_reduction_tol = 1292,       // o_dr_cycle_reduction_tol
        S_o_dr_logarithmic_reduction_tol = 1293, // o_dr_logarithmic_reduction_tol
        S_o_dr_logarithmic_reduction_maxiter = 1294, // o_dr_logarithmic_reduction_maxiter
        S_o_psd_detail_plot = 1295,              // o_psd_detail_plot
        S_o_icd_detail_plot = 1296,              // o_icd_detail_plot
        S_o_psd_interactive = 1297,              // o_psd_interactive
        S_o_psd_screen_shocks = 1298,            // o_psd_screen_shocks
        S_o_psd_steadystate = 1299,              // o_psd_steadystate
        S_o_icd_steadystate = 1300,              // o_icd_steadystate
        S_o_icd_fig_name = 1301,                 // o_icd_fig_name
        S_o_psd_fig_name = 1302,                 // o_psd_fig_name
        S_o_psd_type = 1303,                     // o_psd_type
        S_o_icd_type = 1304,                     // o_icd_type
        S_o_icd_plot_init_date = 1305,           // o_icd_plot_init_date
        S_o_icd_plot_end_date = 1306,            // o_icd_plot_end_date
        S_o_psd_plot_init_date = 1307,           // o_psd_plot_init_date
        S_o_psd_plot_end_date = 1308,            // o_psd_plot_end_date
        S_o_icd_write_xls = 1309,                // o_icd_write_xls
        S_o_psd_write_xls = 1310,                // o_psd_write_xls
        S_o_psd_realtime = 1311,                 // o_psd_realtime
        S_o_psd_vintage = 1312,                  // o_psd_vintage
        S_o_psd_diff = 1313,                     // o_psd_diff
        S_o_icd_diff = 1314,                     // o_icd_diff
        S_o_psd_flip = 1315,                     // o_psd_flip
        S_o_icd_flip = 1316,                     // o_icd_flip
        S_o_bvar_prior_tau = 1317,               // o_bvar_prior_tau
        S_o_bvar_prior_decay = 1318,             // o_bvar_prior_decay
        S_o_bvar_prior_lambda = 1319,            // o_bvar_prior_lambda
        S_o_bvar_prior_mu = 1320,                // o_bvar_prior_mu
        S_o_bvar_prior_omega = 1321,             // o_bvar_prior_omega
        S_o_bvar_prior_flat = 1322,              // o_bvar_prior_flat
        S_o_bvar_prior_train = 1323,             // o_bvar_prior_train
        S_o_bvar_replic = 1324,                  // o_bvar_replic
        S_o_stderr_multiples = 1325,             // o_stderr_multiples
        S_o_diagonal_only = 1326,                // o_diagonal_only
        S_o_number_of_particles = 1327,          // o_number_of_particles
        S_o_particle_filter_options = 1328,      // o_particle_filter_options
        S_o_resampling = 1329,                   // o_resampling
        S_o_resampling_threshold = 1330,         // o_resampling_threshold
        S_o_resampling_method = 1331,            // o_resampling_method
        S_o_cpf_weights = 1332,                  // o_cpf_weights
        S_o_filter_algorithm = 1333,             // o_filter_algorithm
        S_o_nonlinear_filter_initialization = 1334, // o_nonlinear_filter_initialization
        S_o_proposal_approximation = 1335,       // o_proposal_approximation
        S_o_distribution_approximation = 1336,   // o_distribution_approximation
        S_o_gsa_identification = 1337,           // o_gsa_identification
        S_o_gsa_morris = 1338,                   // o_gsa_morris
        S_o_gsa_stab = 1339,                     // o_gsa_stab
        S_o_gsa_redform = 1340,                  // o_gsa_redform
        S_o_gsa_pprior = 1341,                   // o_gsa_pprior
        S_o_gsa_prior_range = 1342,              // o_gsa_prior_range
        S_o_gsa_ppost = 1343,                    // o_gsa_ppost
        S_o_gsa_ilptau = 1344,                   // o_gsa_ilptau
        S_o_gsa_morris_nliv = 1345,              // o_gsa_morris_nliv
        S_o_gsa_morris_ntra = 1346,              // o_gsa_morris_ntra
        S_o_gsa_nsam = 1347,                     // o_gsa_nsam
        S_o_gsa_load_redform = 1348,             // o_gsa_load_redform
        S_o_gsa_load_rmse = 1349,                // o_gsa_load_rmse
        S_o_gsa_load_stab = 1350,                // o_gsa_load_stab
        S_o_gsa_alpha2_stab = 1351,              // o_gsa_alpha2_stab
        S_o_gsa_logtrans_redform = 1352,         // o_gsa_logtrans_redform
        S_o_gsa_threshold_redform = 1353,        // o_gsa_threshold_redform
        S_o_gsa_ksstat_redform = 1354,           // o_gsa_ksstat_redform
        S_o_gsa_alpha2_redform = 1355,           // o_gsa_alpha2_redform
        S_o_gsa_namendo = 1356,                  // o_gsa_namendo
        S_o_gsa_namlagendo = 1357,               // o_gsa_namlagendo
        S_o_gsa_namexo = 1358,                   // o_gsa_namexo
        S_o_gsa_rmse = 1359,                     // o_gsa_rmse
        S_o_gsa_lik_only = 1360,                 // o_gsa_lik_only
        S_o_gsa_var_rmse = 1361,                 // o_gsa_var_rmse
        S_o_gsa_pfilt_rmse = 1362,               // o_gsa_pfilt_rmse
        S_o_gsa_istart_rmse = 1363,              // o_gsa_istart_rmse
        S_o_gsa_alpha_rmse = 1364,               // o_gsa_alpha_rmse
        S_o_gsa_alpha2_rmse = 1365,              // o_gsa_alpha2_rmse
        S_o_gsa_sample_file = 1366,              // o_gsa_sample_file
        S_o_gsa_neighborhood_width = 1367,       // o_gsa_neighborhood_width
        S_o_gsa_pvalue_ks = 1368,                // o_gsa_pvalue_ks
        S_o_gsa_pvalue_corr = 1369,              // o_gsa_pvalue_corr
        S_o_load_ident_files = 1370,             // o_load_ident_files
        S_o_useautocorr = 1371,                  // o_useautocorr
        S_o_prior_mc = 1372,                     // o_prior_mc
        S_o_advanced = 1373,                     // o_advanced
        S_o_max_dim_cova_group = 1374,           // o_max_dim_cova_group
        S_o_homotopy_mode = 1375,                // o_homotopy_mode
        S_o_homotopy_steps = 1376,               // o_homotopy_steps
        S_o_homotopy_force_continue = 1377,      // o_homotopy_force_continue
        S_o_nocheck = 1378,                      // o_nocheck
        S_o_controlled_varexo = 1379,            // o_controlled_varexo
        S_o_parameter_set = 1380,                // o_parameter_set
        S_o_nodecomposition = 1381,              // o_nodecomposition
        S_o_spectral_density = 1382,             // o_spectral_density
        S_o_ms_drop = 1383,                      // o_ms_drop
        S_o_ms_mh_replic = 1384,                 // o_ms_mh_replic
        S_o_freq = 1385,                         // o_freq
        S_o_initial_year = 1386,                 // o_initial_year
        S_o_initial_subperiod = 1387,            // o_initial_subperiod
        S_o_final_year = 1388,                   // o_final_year
        S_o_final_subperiod = 1389,              // o_final_subperiod
        S_o_data = 1390,                         // o_data
        S_o_vlist = 1391,                        // o_vlist
        S_o_vlistlog = 1392,                     // o_vlistlog
        S_o_vlistper = 1393,                     // o_vlistper
        S_o_restriction_fname = 1394,            // o_restriction_fname
        S_o_nlags = 1395,                        // o_nlags
        S_o_cross_restrictions = 1396,           // o_cross_restrictions
        S_o_contemp_reduced_form = 1397,         // o_contemp_reduced_form
        S_o_real_pseudo_forecast = 1398,         // o_real_pseudo_forecast
        S_o_no_bayesian_prior = 1399,            // o_no_bayesian_prior
        S_o_dummy_obs = 1400,                    // o_dummy_obs
        S_o_nstates = 1401,                      // o_nstates
        S_o_indxscalesstates = 1402,             // o_indxscalesstates
        S_o_alpha = 1403,                        // o_alpha
        S_o_beta = 1404,                         // o_beta
        S_o_gsig2_lmdm = 1405,                   // o_gsig2_lmdm
        S_o_specification = 1406,                // o_specification
        S_o_q_diag = 1407,                       // o_q_diag
        S_o_flat_prior = 1408,                   // o_flat_prior
        S_o_ncsk = 1409,                         // o_ncsk
        S_o_nstd = 1410,                         // o_nstd
        S_o_ninv = 1411,                         // o_ninv
        S_o_indxparr = 1412,                     // o_indxparr
        S_o_indxovr = 1413,                      // o_indxovr
        S_o_aband = 1414,                        // o_aband
        S_o_indxap = 1415,                       // o_indxap
        S_o_apband = 1416,                       // o_apband
        S_o_indximf = 1417,                      // o_indximf
        S_o_indxfore = 1418,                     // o_indxfore
        S_o_foreband = 1419,                     // o_foreband
        S_o_indxgforhat = 1420,                  // o_indxgforhat
        S_o_indxgimfhat = 1421,                  // o_indxgimfhat
        S_o_indxestima = 1422,                   // o_indxestima
        S_o_indxgdls = 1423,                     // o_indxgdls
        S_o_eq_ms = 1424,                        // o_eq_ms
        S_o_cms = 1425,                          // o_cms
        S_o_ncms = 1426,                         // o_ncms
        S_o_eq_cms = 1427,                       // o_eq_cms
        S_o_tlindx = 1428,                       // o_tlindx
        S_o_tlnumber = 1429,                     // o_tlnumber
        S_o_cnum = 1430,                         // o_cnum
        S_o_k_order_solver = 1431,               // o_k_order_solver
        S_o_pruning = 1432,                      // o_pruning
        S_o_chain = 1433,                        // o_chain
        S_o_restrictions = 1434,                 // o_restrictions
        S_o_duration = 1435,                     // o_duration
        S_o_number_of_regimes = 1436,            // o_number_of_regimes
        S_o_number_of_lags = 1437,               // o_number_of_lags
        S_o_parameters = 1438,                   // o_parameters
        S_o_coefficients = 1439,                 // o_coefficients
        S_o_variances = 1440,                    // o_variances
        S_o_equations = 1441,                    // o_equations
        S_o_silent_optimizer = 1442,             // o_silent_optimizer
        S_o_instruments = 1443,                  // o_instruments
        S_o_ext_func_name = 1444,                // o_ext_func_name
        S_o_ext_func_nargs = 1445,               // o_ext_func_nargs
        S_o_first_deriv_provided = 1446,         // o_first_deriv_provided
        S_o_second_deriv_provided = 1447,        // o_second_deriv_provided
        S_o_filter_covariance = 1448,            // o_filter_covariance
        S_o_filter_decomposition = 1449,         // o_filter_decomposition
        S_o_smoothed_state_uncertainty = 1450,   // o_smoothed_state_uncertainty
        S_o_smoother_redux = 1451,               // o_smoother_redux
        S_o_selected_variables_only = 1452,      // o_selected_variables_only
        S_o_cova_compute = 1453,                 // o_cova_compute
        S_o_output_file_tag = 1454,              // o_output_file_tag
        S_o_file_tag = 1455,                     // o_file_tag
        S_o_no_create_init = 1456,               // o_no_create_init
        S_o_simulation_file_tag = 1457,          // o_simulation_file_tag
        S_o_coefficients_prior_hyperparameters = 1458, // o_coefficients_prior_hyperparameters
        S_o_convergence_starting_value = 1459,   // o_convergence_starting_value
        S_o_convergence_ending_value = 1460,     // o_convergence_ending_value
        S_o_convergence_increment_value = 1461,  // o_convergence_increment_value
        S_o_max_iterations_starting_value = 1462, // o_max_iterations_starting_value
        S_o_max_iterations_increment_value = 1463, // o_max_iterations_increment_value
        S_o_max_block_iterations = 1464,         // o_max_block_iterations
        S_o_max_repeated_optimization_runs = 1465, // o_max_repeated_optimization_runs
        S_o_function_convergence_criterion = 1466, // o_function_convergence_criterion
        S_o_parameter_convergence_criterion = 1467, // o_parameter_convergence_criterion
        S_o_number_of_large_perturbations = 1468, // o_number_of_large_perturbations
        S_o_number_of_small_perturbations = 1469, // o_number_of_small_perturbations
        S_o_number_of_posterior_draws_after_perturbation = 1470, // o_number_of_posterior_draws_after_perturbation
        S_o_max_number_of_stages = 1471,         // o_max_number_of_stages
        S_o_random_function_convergence_criterion = 1472, // o_random_function_convergence_criterion
        S_o_random_parameter_convergence_criterion = 1473, // o_random_parameter_convergence_criterion
        S_o_thinning_factor = 1474,              // o_thinning_factor
        S_o_adaptive_mh_draws = 1475,            // o_adaptive_mh_draws
        S_o_save_draws = 1476,                   // o_save_draws
        S_o_proposal_draws = 1477,               // o_proposal_draws
        S_o_use_mean_center = 1478,              // o_use_mean_center
        S_o_proposal_type = 1479,                // o_proposal_type
        S_o_proposal_lower_bound = 1480,         // o_proposal_lower_bound
        S_o_proposal_upper_bound = 1481,         // o_proposal_upper_bound
        S_o_parameter_uncertainty = 1482,        // o_parameter_uncertainty
        S_o_horizon = 1483,                      // o_horizon
        S_o_filtered_probabilities = 1484,       // o_filtered_probabilities
        S_o_real_time_smoothed = 1485,           // o_real_time_smoothed
        S_o_no_error_bands = 1486,               // o_no_error_bands
        S_o_error_band_percentiles = 1487,       // o_error_band_percentiles
        S_o_shock_draws = 1488,                  // o_shock_draws
        S_o_shocks_per_parameter = 1489,         // o_shocks_per_parameter
        S_o_free_parameters = 1490,              // o_free_parameters
        S_o_median = 1491,                       // o_median
        S_o_regimes = 1492,                      // o_regimes
        S_o_regime = 1493,                       // o_regime
        S_o_data_obs_nbr = 1494,                 // o_data_obs_nbr
        S_o_discretionary_tol = 1495,            // o_discretionary_tol
        S_o_analytic_derivation = 1496,          // o_analytic_derivation
        S_o_analytic_derivation_mode = 1497,     // o_analytic_derivation_mode
        S_o_endogenous_prior = 1498,             // o_endogenous_prior
        S_o_use_univariate_filters_if_singularity_is_detected = 1499, // o_use_univariate_filters_if_singularity_is_detected
        S_o_mcmc_jumping_covariance = 1500,      // o_mcmc_jumping_covariance
        S_o_rescale_prediction_error_covariance = 1501, // o_rescale_prediction_error_covariance
        S_o_use_penalized_objective_for_hessian = 1502, // o_use_penalized_objective_for_hessian
        S_o_irf_plot_threshold = 1503,           // o_irf_plot_threshold
        S_o_dr_display_tol = 1504,               // o_dr_display_tol
        S_o_consider_all_endogenous = 1505,      // o_consider_all_endogenous
        S_o_consider_all_endogenous_and_auxiliary = 1506, // o_consider_all_endogenous_and_auxiliary
        S_o_consider_only_observed = 1507,       // o_consider_only_observed
        S_o_no_homotopy = 1508,                  // o_no_homotopy
        S_o_infile = 1509,                       // o_infile
        S_o_invars = 1510,                       // o_invars
        S_o_period = 1511,                       // o_period
        S_o_outfile = 1512,                      // o_outfile
        S_o_outvars = 1513,                      // o_outvars
        S_o_lmmcp = 1514,                        // o_lmmcp
        S_o_function = 1515,                     // o_function
        S_o_sampling_draws = 1516,               // o_sampling_draws
        S_o_use_shock_groups = 1517,             // o_use_shock_groups
        S_o_colormap = 1518,                     // o_colormap
        S_o_icd_colormap = 1519,                 // o_icd_colormap
        S_o_no_init_estimation_check_first_obs = 1520, // o_no_init_estimation_check_first_obs
        S_o_heteroskedastic_filter = 1521,       // o_heteroskedastic_filter
        S_o_pfwee_terminal_steady_state_as_guess_value = 1522, // o_pfwee_terminal_steady_state_as_guess_value
        S_o_bartlett_kernel_lag = 1523,          // o_bartlett_kernel_lag
        S_o_weighting_matrix = 1524,             // o_weighting_matrix
        S_o_weighting_matrix_scaling_factor = 1525, // o_weighting_matrix_scaling_factor
        S_o_analytic_standard_errors = 1526,     // o_analytic_standard_errors
        S_o_analytic_jacobian = 1527,            // o_analytic_jacobian
        S_o_mom_method = 1528,                   // o_mom_method
        S_o_penalized_estimator = 1529,          // o_penalized_estimator
        S_o_verbose = 1530,                      // o_verbose
        S_o_simulation_multiple = 1531,          // o_simulation_multiple
        S_o_mom_burnin = 1532,                   // o_mom_burnin
        S_o_bounded_shock_support = 1533,        // o_bounded_shock_support
        S_o_mom_seed = 1534,                     // o_mom_seed
        S_o_additional_optimizer_steps = 1535,   // o_additional_optimizer_steps
        S_o_mom_se_tolx = 1536,                  // o_mom_se_tolx
        S_o_analytical_girf = 1537,              // o_analytical_girf
        S_o_irf_in_percent = 1538,               // o_irf_in_percent
        S_o_emas_girf = 1539,                    // o_emas_girf
        S_o_emas_drop = 1540,                    // o_emas_drop
        S_o_emas_tolf = 1541,                    // o_emas_tolf
        S_o_emas_max_iter = 1542,                // o_emas_max_iter
        S_o_no_identification_strength = 1543,   // o_no_identification_strength
        S_o_no_identification_reducedform = 1544, // o_no_identification_reducedform
        S_o_no_identification_moments = 1545,    // o_no_identification_moments
        S_o_no_identification_minimal = 1546,    // o_no_identification_minimal
        S_o_no_identification_spectrum = 1547,   // o_no_identification_spectrum
        S_o_normalize_jacobians = 1548,          // o_normalize_jacobians
        S_o_grid_nbr = 1549,                     // o_grid_nbr
        S_o_tol_rank = 1550,                     // o_tol_rank
        S_o_tol_deriv = 1551,                    // o_tol_deriv
        S_o_tol_sv = 1552,                       // o_tol_sv
        S_o_checks_via_subsets = 1553,           // o_checks_via_subsets
        S_o_max_dim_subsets_groups = 1554,       // o_max_dim_subsets_groups
        S_o_zero_moments_tolerance = 1555,       // o_zero_moments_tolerance
        S_o_static = 1556,                       // o_static
        S_o_incidence = 1557,                    // o_incidence
        S_o_occbin_simul_maxit = 1558,           // o_occbin_simul_maxit
        S_o_occbin_simul_periods = 1559,         // o_occbin_simul_periods
        S_o_occbin_simul_curb_retrench = 1560,   // o_occbin_simul_curb_retrench
        S_o_occbin_simul_check_ahead_periods = 1561, // o_occbin_simul_check_ahead_periods
        S_o_occbin_simul_debug = 1562,           // o_occbin_simul_debug
        S_o_occbin_simul_periodic_solution = 1563, // o_occbin_simul_periodic_solution
        S_o_occbin_likelihood_inversion_filter = 1564, // o_occbin_likelihood_inversion_filter
        S_o_occbin_likelihood_piecewise_kalman_filter = 1565, // o_occbin_likelihood_piecewise_kalman_filter
        S_o_occbin_likelihood_maxit = 1566,      // o_occbin_likelihood_maxit
        S_o_occbin_likelihood_periods = 1567,    // o_occbin_likelihood_periods
        S_o_occbin_likelihood_curb_retrench = 1568, // o_occbin_likelihood_curb_retrench
        S_o_occbin_likelihood_check_ahead_periods = 1569, // o_occbin_likelihood_check_ahead_periods
        S_o_occbin_likelihood_periodic_solution = 1570, // o_occbin_likelihood_periodic_solution
        S_o_occbin_likelihood_max_kalman_iterations = 1571, // o_occbin_likelihood_max_kalman_iterations
        S_o_occbin_smoother_inversion_filter = 1572, // o_occbin_smoother_inversion_filter
        S_o_occbin_smoother_piecewise_kalman_filter = 1573, // o_occbin_smoother_piecewise_kalman_filter
        S_o_occbin_smoother_maxit = 1574,        // o_occbin_smoother_maxit
        S_o_occbin_smoother_periods = 1575,      // o_occbin_smoother_periods
        S_o_occbin_smoother_curb_retrench = 1576, // o_occbin_smoother_curb_retrench
        S_o_occbin_smoother_check_ahead_periods = 1577, // o_occbin_smoother_check_ahead_periods
        S_o_occbin_smoother_debug = 1578,        // o_occbin_smoother_debug
        S_o_occbin_smoother_periodic_solution = 1579, // o_occbin_smoother_periodic_solution
        S_o_occbin_filter_use_relaxation = 1580, // o_occbin_filter_use_relaxation
        S_o_occbin_write_regimes_periods = 1581, // o_occbin_write_regimes_periods
        S_o_occbin_write_regimes_filename = 1582, // o_occbin_write_regimes_filename
        S_o_occbin_write_regimes_smoother = 1583, // o_occbin_write_regimes_smoother
        S_o_occbin_write_regimes_simul = 1584,   // o_occbin_write_regimes_simul
        S_o_occbin_graph_noconstant = 1585,      // o_occbin_graph_noconstant
        S_range = 1586,                          // range
        S_integer_range = 1587,                  // integer_range
        S_integer_range_w_inf = 1588,            // integer_range_w_inf
        S_signed_integer_range = 1589,           // signed_integer_range
        S_vec_int_number = 1590,                 // vec_int_number
        S_vec_int_elem = 1591,                   // vec_int_elem
        S_vec_int_1 = 1592,                      // vec_int_1
        S_vec_int = 1593,                        // vec_int
        S_vec_str_1 = 1594,                      // vec_str_1
        S_vec_str = 1595,                        // vec_str
        S_vec_value_1 = 1596,                    // vec_value_1
        S_vec_value = 1597,                      // vec_value
        S_vec_value_list = 1598,                 // vec_value_list
        S_vec_of_vec_value = 1599,               // vec_of_vec_value
        S_vec_value_1_w_inf = 1600,              // vec_value_1_w_inf
        S_vec_value_w_inf = 1601,                // vec_value_w_inf
        S_symbol = 1602                          // symbol
      };
    };

    /// (Internal) symbol kind.
    typedef symbol_kind::symbol_kind_type symbol_kind_type;

    /// The number of tokens.
    static const symbol_kind_type YYNTOKENS = symbol_kind::YYNTOKENS;

    /// A complete symbol.
    ///
    /// Expects its Base type to provide access to the symbol kind
    /// via kind ().
    ///
    /// Provide access to semantic value and location.
    template <typename Base>
    struct basic_symbol : Base
    {
      /// Alias to Base.
      typedef Base super_type;

      /// Default constructor.
      basic_symbol ()
        : value ()
        , location ()
      {}

#if 201103L <= YY_CPLUSPLUS
      /// Move constructor.
      basic_symbol (basic_symbol&& that)
        : Base (std::move (that))
        , value ()
        , location (std::move (that.location))
      {
        switch (this->kind ())
    {
      case symbol_kind::S_prior_distribution: // prior_distribution
      case symbol_kind::S_prior_pdf: // prior_pdf
        value.move< PriorDistributions > (std::move (that.value));
        break;

      case symbol_kind::S_change_type_arg: // change_type_arg
        value.move< SymbolType > (std::move (that.value));
        break;

      case symbol_kind::S_expression: // expression
      case symbol_kind::S_expression_or_empty: // expression_or_empty
      case symbol_kind::S_equation: // equation
      case symbol_kind::S_hand_side: // hand_side
        value.move< expr_t > (std::move (that.value));
        break;

      case symbol_kind::S_occbin_constraints_regime_options_list: // occbin_constraints_regime_options_list
        value.move< map<string, expr_t> > (std::move (that.value));
        break;

      case symbol_kind::S_calibration_range: // calibration_range
        value.move< pair<expr_t,expr_t> > (std::move (that.value));
        break;

      case symbol_kind::S_occbin_constraints_regime_option: // occbin_constraints_regime_option
        value.move< pair<string, expr_t> > (std::move (that.value));
        break;

      case symbol_kind::S_named_var_elem: // named_var_elem
      case symbol_kind::S_subsamples_eq_opt: // subsamples_eq_opt
      case symbol_kind::S_integer_range_w_inf: // integer_range_w_inf
        value.move< pair<string,string> > (std::move (that.value));
        break;

      case symbol_kind::S_FALSE: // FALSE
      case symbol_kind::S_FLOAT_NUMBER: // FLOAT_NUMBER
      case symbol_kind::S_DATES: // DATES
      case symbol_kind::S_INT_NUMBER: // INT_NUMBER
      case symbol_kind::S_NAME: // NAME
      case symbol_kind::S_QUOTED_STRING: // QUOTED_STRING
      case symbol_kind::S_TEX_NAME: // TEX_NAME
      case symbol_kind::S_TRUE: // TRUE
      case symbol_kind::S_BIND: // BIND
      case symbol_kind::S_RELAX: // RELAX
      case symbol_kind::S_ERROR_BIND: // ERROR_BIND
      case symbol_kind::S_ERROR_RELAX: // ERROR_RELAX
      case symbol_kind::S_ALPHA: // ALPHA
      case symbol_kind::S_BETA: // BETA
      case symbol_kind::S_ABAND: // ABAND
      case symbol_kind::S_NINV: // NINV
      case symbol_kind::S_CMS: // CMS
      case symbol_kind::S_NCMS: // NCMS
      case symbol_kind::S_CNUM: // CNUM
      case symbol_kind::S_GAMMA: // GAMMA
      case symbol_kind::S_INV_GAMMA: // INV_GAMMA
      case symbol_kind::S_INV_GAMMA1: // INV_GAMMA1
      case symbol_kind::S_INV_GAMMA2: // INV_GAMMA2
      case symbol_kind::S_NORMAL: // NORMAL
      case symbol_kind::S_UNIFORM: // UNIFORM
      case symbol_kind::S_EPS: // EPS
      case symbol_kind::S_PDF: // PDF
      case symbol_kind::S_FIG: // FIG
      case symbol_kind::S_DR: // DR
      case symbol_kind::S_NONE: // NONE
      case symbol_kind::S_PRIOR: // PRIOR
      case symbol_kind::S_PRIOR_VARIANCE: // PRIOR_VARIANCE
      case symbol_kind::S_HESSIAN: // HESSIAN
      case symbol_kind::S_IDENTITY_MATRIX: // IDENTITY_MATRIX
      case symbol_kind::S_DIRICHLET: // DIRICHLET
      case symbol_kind::S_DIAGONAL: // DIAGONAL
      case symbol_kind::S_OPTIMAL: // OPTIMAL
      case symbol_kind::S_signed_integer: // signed_integer
      case symbol_kind::S_non_negative_number: // non_negative_number
      case symbol_kind::S_signed_number: // signed_number
      case symbol_kind::S_signed_inf: // signed_inf
      case symbol_kind::S_signed_number_w_inf: // signed_number_w_inf
      case symbol_kind::S_boolean: // boolean
      case symbol_kind::S_date_str: // date_str
      case symbol_kind::S_date_expr: // date_expr
      case symbol_kind::S_name_value_pair: // name_value_pair
      case symbol_kind::S_name_value_pair_list: // name_value_pair_list
      case symbol_kind::S_name_value_pair_with_boolean: // name_value_pair_with_boolean
      case symbol_kind::S_name_value_pair_with_boolean_list: // name_value_pair_with_boolean_list
      case symbol_kind::S_name_value_pair_with_suboptions: // name_value_pair_with_suboptions
      case symbol_kind::S_name_value_pair_with_suboptions_list: // name_value_pair_with_suboptions_list
      case symbol_kind::S_filename: // filename
      case symbol_kind::S_namespace_qualified_symbol: // namespace_qualified_symbol
      case symbol_kind::S_namespace_qualified_filename: // namespace_qualified_filename
      case symbol_kind::S_range: // range
      case symbol_kind::S_integer_range: // integer_range
      case symbol_kind::S_signed_integer_range: // signed_integer_range
      case symbol_kind::S_vec_value_1: // vec_value_1
      case symbol_kind::S_vec_value: // vec_value
      case symbol_kind::S_vec_value_list: // vec_value_list
      case symbol_kind::S_vec_of_vec_value: // vec_of_vec_value
      case symbol_kind::S_vec_value_1_w_inf: // vec_value_1_w_inf
      case symbol_kind::S_vec_value_w_inf: // vec_value_w_inf
      case symbol_kind::S_symbol: // symbol
        value.move< string > (std::move (that.value));
        break;

      case symbol_kind::S_occbin_constraints_regime: // occbin_constraints_regime
        value.move< tuple<string, BinaryOpNode *, BinaryOpNode *, expr_t, expr_t> > (std::move (that.value));
        break;

      case symbol_kind::S_prior_eq_opt: // prior_eq_opt
      case symbol_kind::S_options_eq_opt: // options_eq_opt
        value.move< tuple<string,string,string,string> > (std::move (that.value));
        break;

      case symbol_kind::S_matched_moments_list: // matched_moments_list
      case symbol_kind::S_value_list: // value_list
        value.move< vector<expr_t> > (std::move (that.value));
        break;

      case symbol_kind::S_vec_int_number: // vec_int_number
      case symbol_kind::S_vec_int_elem: // vec_int_elem
      case symbol_kind::S_vec_int_1: // vec_int_1
      case symbol_kind::S_vec_int: // vec_int
        value.move< vector<int> > (std::move (that.value));
        break;

      case symbol_kind::S_period_list: // period_list
        value.move< vector<pair<int, int>> > (std::move (that.value));
        break;

      case symbol_kind::S_named_var_1: // named_var_1
      case symbol_kind::S_named_var: // named_var
        value.move< vector<pair<string,string>> > (std::move (that.value));
        break;

      case symbol_kind::S_SYMBOL_VEC: // SYMBOL_VEC
      case symbol_kind::S_change_type_var_list: // change_type_var_list
      case symbol_kind::S_vec_str_1: // vec_str_1
      case symbol_kind::S_vec_str: // vec_str
        value.move< vector<string> > (std::move (that.value));
        break;

      case symbol_kind::S_occbin_constraints_regimes_list: // occbin_constraints_regimes_list
        value.move< vector<tuple<string, BinaryOpNode *, BinaryOpNode *, expr_t, expr_t>> > (std::move (that.value));
        break;

      default:
        break;
    }

      }
#endif

      /// Copy constructor.
      basic_symbol (const basic_symbol& that);

      /// Constructors for typed symbols.
#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, location_type&& l)
        : Base (t)
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const location_type& l)
        : Base (t)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, PriorDistributions&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const PriorDistributions& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, SymbolType&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const SymbolType& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, expr_t&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const expr_t& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, map<string, expr_t>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const map<string, expr_t>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, pair<expr_t,expr_t>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const pair<expr_t,expr_t>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, pair<string, expr_t>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const pair<string, expr_t>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, pair<string,string>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const pair<string,string>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, string&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const string& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, tuple<string, BinaryOpNode *, BinaryOpNode *, expr_t, expr_t>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const tuple<string, BinaryOpNode *, BinaryOpNode *, expr_t, expr_t>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, tuple<string,string,string,string>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const tuple<string,string,string,string>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, vector<expr_t>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const vector<expr_t>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, vector<int>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const vector<int>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, vector<pair<int, int>>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const vector<pair<int, int>>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, vector<pair<string,string>>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const vector<pair<string,string>>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, vector<string>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const vector<string>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, vector<tuple<string, BinaryOpNode *, BinaryOpNode *, expr_t, expr_t>>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const vector<tuple<string, BinaryOpNode *, BinaryOpNode *, expr_t, expr_t>>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

      /// Destroy the symbol.
      ~basic_symbol ()
      {
        clear ();
      }

      /// Destroy contents, and record that is empty.
      void clear () YY_NOEXCEPT
      {
        // User destructor.
        symbol_kind_type yykind = this->kind ();
        basic_symbol<Base>& yysym = *this;
        (void) yysym;
        switch (yykind)
        {
       default:
          break;
        }

        // Value type destructor.
switch (yykind)
    {
      case symbol_kind::S_prior_distribution: // prior_distribution
      case symbol_kind::S_prior_pdf: // prior_pdf
        value.template destroy< PriorDistributions > ();
        break;

      case symbol_kind::S_change_type_arg: // change_type_arg
        value.template destroy< SymbolType > ();
        break;

      case symbol_kind::S_expression: // expression
      case symbol_kind::S_expression_or_empty: // expression_or_empty
      case symbol_kind::S_equation: // equation
      case symbol_kind::S_hand_side: // hand_side
        value.template destroy< expr_t > ();
        break;

      case symbol_kind::S_occbin_constraints_regime_options_list: // occbin_constraints_regime_options_list
        value.template destroy< map<string, expr_t> > ();
        break;

      case symbol_kind::S_calibration_range: // calibration_range
        value.template destroy< pair<expr_t,expr_t> > ();
        break;

      case symbol_kind::S_occbin_constraints_regime_option: // occbin_constraints_regime_option
        value.template destroy< pair<string, expr_t> > ();
        break;

      case symbol_kind::S_named_var_elem: // named_var_elem
      case symbol_kind::S_subsamples_eq_opt: // subsamples_eq_opt
      case symbol_kind::S_integer_range_w_inf: // integer_range_w_inf
        value.template destroy< pair<string,string> > ();
        break;

      case symbol_kind::S_FALSE: // FALSE
      case symbol_kind::S_FLOAT_NUMBER: // FLOAT_NUMBER
      case symbol_kind::S_DATES: // DATES
      case symbol_kind::S_INT_NUMBER: // INT_NUMBER
      case symbol_kind::S_NAME: // NAME
      case symbol_kind::S_QUOTED_STRING: // QUOTED_STRING
      case symbol_kind::S_TEX_NAME: // TEX_NAME
      case symbol_kind::S_TRUE: // TRUE
      case symbol_kind::S_BIND: // BIND
      case symbol_kind::S_RELAX: // RELAX
      case symbol_kind::S_ERROR_BIND: // ERROR_BIND
      case symbol_kind::S_ERROR_RELAX: // ERROR_RELAX
      case symbol_kind::S_ALPHA: // ALPHA
      case symbol_kind::S_BETA: // BETA
      case symbol_kind::S_ABAND: // ABAND
      case symbol_kind::S_NINV: // NINV
      case symbol_kind::S_CMS: // CMS
      case symbol_kind::S_NCMS: // NCMS
      case symbol_kind::S_CNUM: // CNUM
      case symbol_kind::S_GAMMA: // GAMMA
      case symbol_kind::S_INV_GAMMA: // INV_GAMMA
      case symbol_kind::S_INV_GAMMA1: // INV_GAMMA1
      case symbol_kind::S_INV_GAMMA2: // INV_GAMMA2
      case symbol_kind::S_NORMAL: // NORMAL
      case symbol_kind::S_UNIFORM: // UNIFORM
      case symbol_kind::S_EPS: // EPS
      case symbol_kind::S_PDF: // PDF
      case symbol_kind::S_FIG: // FIG
      case symbol_kind::S_DR: // DR
      case symbol_kind::S_NONE: // NONE
      case symbol_kind::S_PRIOR: // PRIOR
      case symbol_kind::S_PRIOR_VARIANCE: // PRIOR_VARIANCE
      case symbol_kind::S_HESSIAN: // HESSIAN
      case symbol_kind::S_IDENTITY_MATRIX: // IDENTITY_MATRIX
      case symbol_kind::S_DIRICHLET: // DIRICHLET
      case symbol_kind::S_DIAGONAL: // DIAGONAL
      case symbol_kind::S_OPTIMAL: // OPTIMAL
      case symbol_kind::S_signed_integer: // signed_integer
      case symbol_kind::S_non_negative_number: // non_negative_number
      case symbol_kind::S_signed_number: // signed_number
      case symbol_kind::S_signed_inf: // signed_inf
      case symbol_kind::S_signed_number_w_inf: // signed_number_w_inf
      case symbol_kind::S_boolean: // boolean
      case symbol_kind::S_date_str: // date_str
      case symbol_kind::S_date_expr: // date_expr
      case symbol_kind::S_name_value_pair: // name_value_pair
      case symbol_kind::S_name_value_pair_list: // name_value_pair_list
      case symbol_kind::S_name_value_pair_with_boolean: // name_value_pair_with_boolean
      case symbol_kind::S_name_value_pair_with_boolean_list: // name_value_pair_with_boolean_list
      case symbol_kind::S_name_value_pair_with_suboptions: // name_value_pair_with_suboptions
      case symbol_kind::S_name_value_pair_with_suboptions_list: // name_value_pair_with_suboptions_list
      case symbol_kind::S_filename: // filename
      case symbol_kind::S_namespace_qualified_symbol: // namespace_qualified_symbol
      case symbol_kind::S_namespace_qualified_filename: // namespace_qualified_filename
      case symbol_kind::S_range: // range
      case symbol_kind::S_integer_range: // integer_range
      case symbol_kind::S_signed_integer_range: // signed_integer_range
      case symbol_kind::S_vec_value_1: // vec_value_1
      case symbol_kind::S_vec_value: // vec_value
      case symbol_kind::S_vec_value_list: // vec_value_list
      case symbol_kind::S_vec_of_vec_value: // vec_of_vec_value
      case symbol_kind::S_vec_value_1_w_inf: // vec_value_1_w_inf
      case symbol_kind::S_vec_value_w_inf: // vec_value_w_inf
      case symbol_kind::S_symbol: // symbol
        value.template destroy< string > ();
        break;

      case symbol_kind::S_occbin_constraints_regime: // occbin_constraints_regime
        value.template destroy< tuple<string, BinaryOpNode *, BinaryOpNode *, expr_t, expr_t> > ();
        break;

      case symbol_kind::S_prior_eq_opt: // prior_eq_opt
      case symbol_kind::S_options_eq_opt: // options_eq_opt
        value.template destroy< tuple<string,string,string,string> > ();
        break;

      case symbol_kind::S_matched_moments_list: // matched_moments_list
      case symbol_kind::S_value_list: // value_list
        value.template destroy< vector<expr_t> > ();
        break;

      case symbol_kind::S_vec_int_number: // vec_int_number
      case symbol_kind::S_vec_int_elem: // vec_int_elem
      case symbol_kind::S_vec_int_1: // vec_int_1
      case symbol_kind::S_vec_int: // vec_int
        value.template destroy< vector<int> > ();
        break;

      case symbol_kind::S_period_list: // period_list
        value.template destroy< vector<pair<int, int>> > ();
        break;

      case symbol_kind::S_named_var_1: // named_var_1
      case symbol_kind::S_named_var: // named_var
        value.template destroy< vector<pair<string,string>> > ();
        break;

      case symbol_kind::S_SYMBOL_VEC: // SYMBOL_VEC
      case symbol_kind::S_change_type_var_list: // change_type_var_list
      case symbol_kind::S_vec_str_1: // vec_str_1
      case symbol_kind::S_vec_str: // vec_str
        value.template destroy< vector<string> > ();
        break;

      case symbol_kind::S_occbin_constraints_regimes_list: // occbin_constraints_regimes_list
        value.template destroy< vector<tuple<string, BinaryOpNode *, BinaryOpNode *, expr_t, expr_t>> > ();
        break;

      default:
        break;
    }

        Base::clear ();
      }

      /// The user-facing name of this symbol.
      std::string name () const YY_NOEXCEPT
      {
        return parser::symbol_name (this->kind ());
      }

      /// Backward compatibility (Bison 3.6).
      symbol_kind_type type_get () const YY_NOEXCEPT;

      /// Whether empty.
      bool empty () const YY_NOEXCEPT;

      /// Destructive move, \a s is emptied into this.
      void move (basic_symbol& s);

      /// The semantic value.
      semantic_type value;

      /// The location.
      location_type location;

    private:
#if YY_CPLUSPLUS < 201103L
      /// Assignment operator.
      basic_symbol& operator= (const basic_symbol& that);
#endif
    };

    /// Type access provider for token (enum) based symbols.
    struct by_kind
    {
      /// Default constructor.
      by_kind ();

#if 201103L <= YY_CPLUSPLUS
      /// Move constructor.
      by_kind (by_kind&& that);
#endif

      /// Copy constructor.
      by_kind (const by_kind& that);

      /// The symbol kind as needed by the constructor.
      typedef token_kind_type kind_type;

      /// Constructor from (external) token numbers.
      by_kind (kind_type t);

      /// Record that this symbol is empty.
      void clear () YY_NOEXCEPT;

      /// Steal the symbol kind from \a that.
      void move (by_kind& that);

      /// The (internal) type number (corresponding to \a type).
      /// \a empty when empty.
      symbol_kind_type kind () const YY_NOEXCEPT;

      /// Backward compatibility (Bison 3.6).
      symbol_kind_type type_get () const YY_NOEXCEPT;

      /// The symbol kind.
      /// \a S_YYEMPTY when empty.
      symbol_kind_type kind_;
    };

    /// Backward compatibility for a private implementation detail (Bison 3.6).
    typedef by_kind by_type;

    /// "External" symbols: returned by the scanner.
    struct symbol_type : basic_symbol<by_kind>
    {
      /// Superclass.
      typedef basic_symbol<by_kind> super_type;

      /// Empty symbol.
      symbol_type () {}

      /// Constructor for valueless symbols, and symbols from each type.
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, location_type l)
        : super_type(token_type (tok), std::move (l))
#else
      symbol_type (int tok, const location_type& l)
        : super_type(token_type (tok), l)
#endif
      {
        YY_ASSERT (tok == token::YYEOF
                   || (token::YYerror <= tok && tok <= token::KEEP_KALMAN_ALGO_IF_SINGULARITY_IS_DETECTED)
                   || (token::DEFAULT <= tok && tok <= token::INVARS)
                   || (token::INV_GAMMA_PDF <= tok && tok <= token::DISTRIBUTION_APPROXIMATION)
                   || (token::USE_PENALIZED_OBJECTIVE_FOR_HESSIAN <= tok && tok <= token::PARTICLE_FILTER_OPTIONS)
                   || (token::QZ_CRITERIUM <= tok && tok <= token::LIKELIHOOD_MAX_KALMAN_ITERATIONS)
                   || (token::UNIFORM_PDF <= tok && tok <= token::SIMS_ZHA)
                   || (token::GSIG2_LMDM <= tok && tok <= token::INCIDENCE)
                   || tok == 59
                   || (40 <= tok && tok <= 41)
                   || tok == 91
                   || tok == 93
                   || tok == 35
                   || tok == 58
                   || tok == 46);
      }
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, string v, location_type l)
        : super_type(token_type (tok), std::move (v), std::move (l))
#else
      symbol_type (int tok, const string& v, const location_type& l)
        : super_type(token_type (tok), v, l)
#endif
      {
        YY_ASSERT ((token::FALSE <= tok && tok <= token::DATES)
                   || tok == token::INT_NUMBER
                   || tok == token::NAME
                   || tok == token::QUOTED_STRING
                   || (token::TEX_NAME <= tok && tok <= token::ERROR_RELAX)
                   || (token::ALPHA <= tok && tok <= token::OPTIMAL));
      }
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, vector<string> v, location_type l)
        : super_type(token_type (tok), std::move (v), std::move (l))
#else
      symbol_type (int tok, const vector<string>& v, const location_type& l)
        : super_type(token_type (tok), v, l)
#endif
      {
        YY_ASSERT (tok == token::SYMBOL_VEC);
      }
    };

    /// Build a parser object.
    parser (ParsingDriver &driver_yyarg);
    virtual ~parser ();

#if 201103L <= YY_CPLUSPLUS
    /// Non copyable.
    parser (const parser&) = delete;
    /// Non copyable.
    parser& operator= (const parser&) = delete;
#endif

    /// Parse.  An alias for parse ().
    /// \returns  0 iff parsing succeeded.
    int operator() ();

    /// Parse.
    /// \returns  0 iff parsing succeeded.
    virtual int parse ();

#if YYDEBUG
    /// The current debugging stream.
    std::ostream& debug_stream () const YY_ATTRIBUTE_PURE;
    /// Set the current debugging stream.
    void set_debug_stream (std::ostream &);

    /// Type for debugging levels.
    typedef int debug_level_type;
    /// The current debugging level.
    debug_level_type debug_level () const YY_ATTRIBUTE_PURE;
    /// Set the current debugging level.
    void set_debug_level (debug_level_type l);
#endif

    /// Report a syntax error.
    /// \param loc    where the syntax error is found.
    /// \param msg    a description of the syntax error.
    virtual void error (const location_type& loc, const std::string& msg);

    /// Report a syntax error.
    void error (const syntax_error& err);

    /// The user-facing name of the symbol whose (internal) number is
    /// YYSYMBOL.  No bounds checking.
    static std::string symbol_name (symbol_kind_type yysymbol);

    // Implementation of make_symbol for each symbol type.
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_YYEOF (location_type l)
      {
        return symbol_type (token::YYEOF, std::move (l));
      }
#else
      static
      symbol_type
      make_YYEOF (const location_type& l)
      {
        return symbol_type (token::YYEOF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_YYerror (location_type l)
      {
        return symbol_type (token::YYerror, std::move (l));
      }
#else
      static
      symbol_type
      make_YYerror (const location_type& l)
      {
        return symbol_type (token::YYerror, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_YYUNDEF (location_type l)
      {
        return symbol_type (token::YYUNDEF, std::move (l));
      }
#else
      static
      symbol_type
      make_YYUNDEF (const location_type& l)
      {
        return symbol_type (token::YYUNDEF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AIM_SOLVER (location_type l)
      {
        return symbol_type (token::AIM_SOLVER, std::move (l));
      }
#else
      static
      symbol_type
      make_AIM_SOLVER (const location_type& l)
      {
        return symbol_type (token::AIM_SOLVER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ANALYTIC_DERIVATION (location_type l)
      {
        return symbol_type (token::ANALYTIC_DERIVATION, std::move (l));
      }
#else
      static
      symbol_type
      make_ANALYTIC_DERIVATION (const location_type& l)
      {
        return symbol_type (token::ANALYTIC_DERIVATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ANALYTIC_DERIVATION_MODE (location_type l)
      {
        return symbol_type (token::ANALYTIC_DERIVATION_MODE, std::move (l));
      }
#else
      static
      symbol_type
      make_ANALYTIC_DERIVATION_MODE (const location_type& l)
      {
        return symbol_type (token::ANALYTIC_DERIVATION_MODE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AR (location_type l)
      {
        return symbol_type (token::AR, std::move (l));
      }
#else
      static
      symbol_type
      make_AR (const location_type& l)
      {
        return symbol_type (token::AR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_SAMPLING_METHOD (location_type l)
      {
        return symbol_type (token::POSTERIOR_SAMPLING_METHOD, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_SAMPLING_METHOD (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_SAMPLING_METHOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BALANCED_GROWTH_TEST_TOL (location_type l)
      {
        return symbol_type (token::BALANCED_GROWTH_TEST_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_BALANCED_GROWTH_TEST_TOL (const location_type& l)
      {
        return symbol_type (token::BALANCED_GROWTH_TEST_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BAYESIAN_IRF (location_type l)
      {
        return symbol_type (token::BAYESIAN_IRF, std::move (l));
      }
#else
      static
      symbol_type
      make_BAYESIAN_IRF (const location_type& l)
      {
        return symbol_type (token::BAYESIAN_IRF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BETA_PDF (location_type l)
      {
        return symbol_type (token::BETA_PDF, std::move (l));
      }
#else
      static
      symbol_type
      make_BETA_PDF (const location_type& l)
      {
        return symbol_type (token::BETA_PDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BLOCK (location_type l)
      {
        return symbol_type (token::BLOCK, std::move (l));
      }
#else
      static
      symbol_type
      make_BLOCK (const location_type& l)
      {
        return symbol_type (token::BLOCK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_USE_CALIBRATION (location_type l)
      {
        return symbol_type (token::USE_CALIBRATION, std::move (l));
      }
#else
      static
      symbol_type
      make_USE_CALIBRATION (const location_type& l)
      {
        return symbol_type (token::USE_CALIBRATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SILENT_OPTIMIZER (location_type l)
      {
        return symbol_type (token::SILENT_OPTIMIZER, std::move (l));
      }
#else
      static
      symbol_type
      make_SILENT_OPTIMIZER (const location_type& l)
      {
        return symbol_type (token::SILENT_OPTIMIZER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_DENSITY (location_type l)
      {
        return symbol_type (token::BVAR_DENSITY, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_DENSITY (const location_type& l)
      {
        return symbol_type (token::BVAR_DENSITY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_FORECAST (location_type l)
      {
        return symbol_type (token::BVAR_FORECAST, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_FORECAST (const location_type& l)
      {
        return symbol_type (token::BVAR_FORECAST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NODECOMPOSITION (location_type l)
      {
        return symbol_type (token::NODECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_NODECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::NODECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DR_DISPLAY_TOL (location_type l)
      {
        return symbol_type (token::DR_DISPLAY_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_DR_DISPLAY_TOL (const location_type& l)
      {
        return symbol_type (token::DR_DISPLAY_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HUGE_NUMBER (location_type l)
      {
        return symbol_type (token::HUGE_NUMBER, std::move (l));
      }
#else
      static
      symbol_type
      make_HUGE_NUMBER (const location_type& l)
      {
        return symbol_type (token::HUGE_NUMBER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FIG_NAME (location_type l)
      {
        return symbol_type (token::FIG_NAME, std::move (l));
      }
#else
      static
      symbol_type
      make_FIG_NAME (const location_type& l)
      {
        return symbol_type (token::FIG_NAME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WRITE_XLS (location_type l)
      {
        return symbol_type (token::WRITE_XLS, std::move (l));
      }
#else
      static
      symbol_type
      make_WRITE_XLS (const location_type& l)
      {
        return symbol_type (token::WRITE_XLS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_PRIOR_DECAY (location_type l)
      {
        return symbol_type (token::BVAR_PRIOR_DECAY, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_PRIOR_DECAY (const location_type& l)
      {
        return symbol_type (token::BVAR_PRIOR_DECAY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_PRIOR_FLAT (location_type l)
      {
        return symbol_type (token::BVAR_PRIOR_FLAT, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_PRIOR_FLAT (const location_type& l)
      {
        return symbol_type (token::BVAR_PRIOR_FLAT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_PRIOR_LAMBDA (location_type l)
      {
        return symbol_type (token::BVAR_PRIOR_LAMBDA, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_PRIOR_LAMBDA (const location_type& l)
      {
        return symbol_type (token::BVAR_PRIOR_LAMBDA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INTERACTIVE (location_type l)
      {
        return symbol_type (token::INTERACTIVE, std::move (l));
      }
#else
      static
      symbol_type
      make_INTERACTIVE (const location_type& l)
      {
        return symbol_type (token::INTERACTIVE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SCREEN_SHOCKS (location_type l)
      {
        return symbol_type (token::SCREEN_SHOCKS, std::move (l));
      }
#else
      static
      symbol_type
      make_SCREEN_SHOCKS (const location_type& l)
      {
        return symbol_type (token::SCREEN_SHOCKS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STEADYSTATE (location_type l)
      {
        return symbol_type (token::STEADYSTATE, std::move (l));
      }
#else
      static
      symbol_type
      make_STEADYSTATE (const location_type& l)
      {
        return symbol_type (token::STEADYSTATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_PRIOR_MU (location_type l)
      {
        return symbol_type (token::BVAR_PRIOR_MU, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_PRIOR_MU (const location_type& l)
      {
        return symbol_type (token::BVAR_PRIOR_MU, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_PRIOR_OMEGA (location_type l)
      {
        return symbol_type (token::BVAR_PRIOR_OMEGA, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_PRIOR_OMEGA (const location_type& l)
      {
        return symbol_type (token::BVAR_PRIOR_OMEGA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_PRIOR_TAU (location_type l)
      {
        return symbol_type (token::BVAR_PRIOR_TAU, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_PRIOR_TAU (const location_type& l)
      {
        return symbol_type (token::BVAR_PRIOR_TAU, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_PRIOR_TRAIN (location_type l)
      {
        return symbol_type (token::BVAR_PRIOR_TRAIN, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_PRIOR_TRAIN (const location_type& l)
      {
        return symbol_type (token::BVAR_PRIOR_TRAIN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DETAIL_PLOT (location_type l)
      {
        return symbol_type (token::DETAIL_PLOT, std::move (l));
      }
#else
      static
      symbol_type
      make_DETAIL_PLOT (const location_type& l)
      {
        return symbol_type (token::DETAIL_PLOT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TYPE (location_type l)
      {
        return symbol_type (token::TYPE, std::move (l));
      }
#else
      static
      symbol_type
      make_TYPE (const location_type& l)
      {
        return symbol_type (token::TYPE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_REPLIC (location_type l)
      {
        return symbol_type (token::BVAR_REPLIC, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_REPLIC (const location_type& l)
      {
        return symbol_type (token::BVAR_REPLIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BYTECODE (location_type l)
      {
        return symbol_type (token::BYTECODE, std::move (l));
      }
#else
      static
      symbol_type
      make_BYTECODE (const location_type& l)
      {
        return symbol_type (token::BYTECODE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ALL_VALUES_REQUIRED (location_type l)
      {
        return symbol_type (token::ALL_VALUES_REQUIRED, std::move (l));
      }
#else
      static
      symbol_type
      make_ALL_VALUES_REQUIRED (const location_type& l)
      {
        return symbol_type (token::ALL_VALUES_REQUIRED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PROPOSAL_DISTRIBUTION (location_type l)
      {
        return symbol_type (token::PROPOSAL_DISTRIBUTION, std::move (l));
      }
#else
      static
      symbol_type
      make_PROPOSAL_DISTRIBUTION (const location_type& l)
      {
        return symbol_type (token::PROPOSAL_DISTRIBUTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REALTIME (location_type l)
      {
        return symbol_type (token::REALTIME, std::move (l));
      }
#else
      static
      symbol_type
      make_REALTIME (const location_type& l)
      {
        return symbol_type (token::REALTIME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VINTAGE (location_type l)
      {
        return symbol_type (token::VINTAGE, std::move (l));
      }
#else
      static
      symbol_type
      make_VINTAGE (const location_type& l)
      {
        return symbol_type (token::VINTAGE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CALIB_SMOOTHER (location_type l)
      {
        return symbol_type (token::CALIB_SMOOTHER, std::move (l));
      }
#else
      static
      symbol_type
      make_CALIB_SMOOTHER (const location_type& l)
      {
        return symbol_type (token::CALIB_SMOOTHER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CHANGE_TYPE (location_type l)
      {
        return symbol_type (token::CHANGE_TYPE, std::move (l));
      }
#else
      static
      symbol_type
      make_CHANGE_TYPE (const location_type& l)
      {
        return symbol_type (token::CHANGE_TYPE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CHECK (location_type l)
      {
        return symbol_type (token::CHECK, std::move (l));
      }
#else
      static
      symbol_type
      make_CHECK (const location_type& l)
      {
        return symbol_type (token::CHECK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONDITIONAL_FORECAST (location_type l)
      {
        return symbol_type (token::CONDITIONAL_FORECAST, std::move (l));
      }
#else
      static
      symbol_type
      make_CONDITIONAL_FORECAST (const location_type& l)
      {
        return symbol_type (token::CONDITIONAL_FORECAST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONDITIONAL_FORECAST_PATHS (location_type l)
      {
        return symbol_type (token::CONDITIONAL_FORECAST_PATHS, std::move (l));
      }
#else
      static
      symbol_type
      make_CONDITIONAL_FORECAST_PATHS (const location_type& l)
      {
        return symbol_type (token::CONDITIONAL_FORECAST_PATHS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONF_SIG (location_type l)
      {
        return symbol_type (token::CONF_SIG, std::move (l));
      }
#else
      static
      symbol_type
      make_CONF_SIG (const location_type& l)
      {
        return symbol_type (token::CONF_SIG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONSTANT (location_type l)
      {
        return symbol_type (token::CONSTANT, std::move (l));
      }
#else
      static
      symbol_type
      make_CONSTANT (const location_type& l)
      {
        return symbol_type (token::CONSTANT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONTROLLED_VAREXO (location_type l)
      {
        return symbol_type (token::CONTROLLED_VAREXO, std::move (l));
      }
#else
      static
      symbol_type
      make_CONTROLLED_VAREXO (const location_type& l)
      {
        return symbol_type (token::CONTROLLED_VAREXO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CORR (location_type l)
      {
        return symbol_type (token::CORR, std::move (l));
      }
#else
      static
      symbol_type
      make_CORR (const location_type& l)
      {
        return symbol_type (token::CORR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CUTOFF (location_type l)
      {
        return symbol_type (token::CUTOFF, std::move (l));
      }
#else
      static
      symbol_type
      make_CUTOFF (const location_type& l)
      {
        return symbol_type (token::CUTOFF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CYCLE_REDUCTION (location_type l)
      {
        return symbol_type (token::CYCLE_REDUCTION, std::move (l));
      }
#else
      static
      symbol_type
      make_CYCLE_REDUCTION (const location_type& l)
      {
        return symbol_type (token::CYCLE_REDUCTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOGARITHMIC_REDUCTION (location_type l)
      {
        return symbol_type (token::LOGARITHMIC_REDUCTION, std::move (l));
      }
#else
      static
      symbol_type
      make_LOGARITHMIC_REDUCTION (const location_type& l)
      {
        return symbol_type (token::LOGARITHMIC_REDUCTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COMMA (location_type l)
      {
        return symbol_type (token::COMMA, std::move (l));
      }
#else
      static
      symbol_type
      make_COMMA (const location_type& l)
      {
        return symbol_type (token::COMMA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONSIDER_ALL_ENDOGENOUS (location_type l)
      {
        return symbol_type (token::CONSIDER_ALL_ENDOGENOUS, std::move (l));
      }
#else
      static
      symbol_type
      make_CONSIDER_ALL_ENDOGENOUS (const location_type& l)
      {
        return symbol_type (token::CONSIDER_ALL_ENDOGENOUS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONSIDER_ALL_ENDOGENOUS_AND_AUXILIARY (location_type l)
      {
        return symbol_type (token::CONSIDER_ALL_ENDOGENOUS_AND_AUXILIARY, std::move (l));
      }
#else
      static
      symbol_type
      make_CONSIDER_ALL_ENDOGENOUS_AND_AUXILIARY (const location_type& l)
      {
        return symbol_type (token::CONSIDER_ALL_ENDOGENOUS_AND_AUXILIARY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONSIDER_ONLY_OBSERVED (location_type l)
      {
        return symbol_type (token::CONSIDER_ONLY_OBSERVED, std::move (l));
      }
#else
      static
      symbol_type
      make_CONSIDER_ONLY_OBSERVED (const location_type& l)
      {
        return symbol_type (token::CONSIDER_ONLY_OBSERVED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INITIAL_CONDITION_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::INITIAL_CONDITION_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_INITIAL_CONDITION_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::INITIAL_CONDITION_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DATAFILE (location_type l)
      {
        return symbol_type (token::DATAFILE, std::move (l));
      }
#else
      static
      symbol_type
      make_DATAFILE (const location_type& l)
      {
        return symbol_type (token::DATAFILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILE (location_type l)
      {
        return symbol_type (token::FILE, std::move (l));
      }
#else
      static
      symbol_type
      make_FILE (const location_type& l)
      {
        return symbol_type (token::FILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SERIES (location_type l)
      {
        return symbol_type (token::SERIES, std::move (l));
      }
#else
      static
      symbol_type
      make_SERIES (const location_type& l)
      {
        return symbol_type (token::SERIES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DOUBLING (location_type l)
      {
        return symbol_type (token::DOUBLING, std::move (l));
      }
#else
      static
      symbol_type
      make_DOUBLING (const location_type& l)
      {
        return symbol_type (token::DOUBLING, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DR_CYCLE_REDUCTION_TOL (location_type l)
      {
        return symbol_type (token::DR_CYCLE_REDUCTION_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_DR_CYCLE_REDUCTION_TOL (const location_type& l)
      {
        return symbol_type (token::DR_CYCLE_REDUCTION_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DR_LOGARITHMIC_REDUCTION_TOL (location_type l)
      {
        return symbol_type (token::DR_LOGARITHMIC_REDUCTION_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_DR_LOGARITHMIC_REDUCTION_TOL (const location_type& l)
      {
        return symbol_type (token::DR_LOGARITHMIC_REDUCTION_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DR_LOGARITHMIC_REDUCTION_MAXITER (location_type l)
      {
        return symbol_type (token::DR_LOGARITHMIC_REDUCTION_MAXITER, std::move (l));
      }
#else
      static
      symbol_type
      make_DR_LOGARITHMIC_REDUCTION_MAXITER (const location_type& l)
      {
        return symbol_type (token::DR_LOGARITHMIC_REDUCTION_MAXITER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DR_ALGO (location_type l)
      {
        return symbol_type (token::DR_ALGO, std::move (l));
      }
#else
      static
      symbol_type
      make_DR_ALGO (const location_type& l)
      {
        return symbol_type (token::DR_ALGO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DROP (location_type l)
      {
        return symbol_type (token::DROP, std::move (l));
      }
#else
      static
      symbol_type
      make_DROP (const location_type& l)
      {
        return symbol_type (token::DROP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DSAMPLE (location_type l)
      {
        return symbol_type (token::DSAMPLE, std::move (l));
      }
#else
      static
      symbol_type
      make_DSAMPLE (const location_type& l)
      {
        return symbol_type (token::DSAMPLE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DYNASAVE (location_type l)
      {
        return symbol_type (token::DYNASAVE, std::move (l));
      }
#else
      static
      symbol_type
      make_DYNASAVE (const location_type& l)
      {
        return symbol_type (token::DYNASAVE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DYNATYPE (location_type l)
      {
        return symbol_type (token::DYNATYPE, std::move (l));
      }
#else
      static
      symbol_type
      make_DYNATYPE (const location_type& l)
      {
        return symbol_type (token::DYNATYPE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CALIBRATION (location_type l)
      {
        return symbol_type (token::CALIBRATION, std::move (l));
      }
#else
      static
      symbol_type
      make_CALIBRATION (const location_type& l)
      {
        return symbol_type (token::CALIBRATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIFFERENTIATE_FORWARD_VARS (location_type l)
      {
        return symbol_type (token::DIFFERENTIATE_FORWARD_VARS, std::move (l));
      }
#else
      static
      symbol_type
      make_DIFFERENTIATE_FORWARD_VARS (const location_type& l)
      {
        return symbol_type (token::DIFFERENTIATE_FORWARD_VARS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_END (location_type l)
      {
        return symbol_type (token::END, std::move (l));
      }
#else
      static
      symbol_type
      make_END (const location_type& l)
      {
        return symbol_type (token::END, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ENDVAL (location_type l)
      {
        return symbol_type (token::ENDVAL, std::move (l));
      }
#else
      static
      symbol_type
      make_ENDVAL (const location_type& l)
      {
        return symbol_type (token::ENDVAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQUAL (location_type l)
      {
        return symbol_type (token::EQUAL, std::move (l));
      }
#else
      static
      symbol_type
      make_EQUAL (const location_type& l)
      {
        return symbol_type (token::EQUAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ESTIMATION (location_type l)
      {
        return symbol_type (token::ESTIMATION, std::move (l));
      }
#else
      static
      symbol_type
      make_ESTIMATION (const location_type& l)
      {
        return symbol_type (token::ESTIMATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ESTIMATED_PARAMS (location_type l)
      {
        return symbol_type (token::ESTIMATED_PARAMS, std::move (l));
      }
#else
      static
      symbol_type
      make_ESTIMATED_PARAMS (const location_type& l)
      {
        return symbol_type (token::ESTIMATED_PARAMS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ESTIMATED_PARAMS_BOUNDS (location_type l)
      {
        return symbol_type (token::ESTIMATED_PARAMS_BOUNDS, std::move (l));
      }
#else
      static
      symbol_type
      make_ESTIMATED_PARAMS_BOUNDS (const location_type& l)
      {
        return symbol_type (token::ESTIMATED_PARAMS_BOUNDS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ESTIMATED_PARAMS_INIT (location_type l)
      {
        return symbol_type (token::ESTIMATED_PARAMS_INIT, std::move (l));
      }
#else
      static
      symbol_type
      make_ESTIMATED_PARAMS_INIT (const location_type& l)
      {
        return symbol_type (token::ESTIMATED_PARAMS_INIT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXTENDED_PATH (location_type l)
      {
        return symbol_type (token::EXTENDED_PATH, std::move (l));
      }
#else
      static
      symbol_type
      make_EXTENDED_PATH (const location_type& l)
      {
        return symbol_type (token::EXTENDED_PATH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ENDOGENOUS_PRIOR (location_type l)
      {
        return symbol_type (token::ENDOGENOUS_PRIOR, std::move (l));
      }
#else
      static
      symbol_type
      make_ENDOGENOUS_PRIOR (const location_type& l)
      {
        return symbol_type (token::ENDOGENOUS_PRIOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXPRESSION (location_type l)
      {
        return symbol_type (token::EXPRESSION, std::move (l));
      }
#else
      static
      symbol_type
      make_EXPRESSION (const location_type& l)
      {
        return symbol_type (token::EXPRESSION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILENAME (location_type l)
      {
        return symbol_type (token::FILENAME, std::move (l));
      }
#else
      static
      symbol_type
      make_FILENAME (const location_type& l)
      {
        return symbol_type (token::FILENAME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIRNAME (location_type l)
      {
        return symbol_type (token::DIRNAME, std::move (l));
      }
#else
      static
      symbol_type
      make_DIRNAME (const location_type& l)
      {
        return symbol_type (token::DIRNAME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILTER_STEP_AHEAD (location_type l)
      {
        return symbol_type (token::FILTER_STEP_AHEAD, std::move (l));
      }
#else
      static
      symbol_type
      make_FILTER_STEP_AHEAD (const location_type& l)
      {
        return symbol_type (token::FILTER_STEP_AHEAD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILTERED_VARS (location_type l)
      {
        return symbol_type (token::FILTERED_VARS, std::move (l));
      }
#else
      static
      symbol_type
      make_FILTERED_VARS (const location_type& l)
      {
        return symbol_type (token::FILTERED_VARS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FIRST_OBS (location_type l)
      {
        return symbol_type (token::FIRST_OBS, std::move (l));
      }
#else
      static
      symbol_type
      make_FIRST_OBS (const location_type& l)
      {
        return symbol_type (token::FIRST_OBS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FIRST_SIMULATION_PERIOD (location_type l)
      {
        return symbol_type (token::FIRST_SIMULATION_PERIOD, std::move (l));
      }
#else
      static
      symbol_type
      make_FIRST_SIMULATION_PERIOD (const location_type& l)
      {
        return symbol_type (token::FIRST_SIMULATION_PERIOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LAST_OBS (location_type l)
      {
        return symbol_type (token::LAST_OBS, std::move (l));
      }
#else
      static
      symbol_type
      make_LAST_OBS (const location_type& l)
      {
        return symbol_type (token::LAST_OBS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SET_TIME (location_type l)
      {
        return symbol_type (token::SET_TIME, std::move (l));
      }
#else
      static
      symbol_type
      make_SET_TIME (const location_type& l)
      {
        return symbol_type (token::SET_TIME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OSR_PARAMS_BOUNDS (location_type l)
      {
        return symbol_type (token::OSR_PARAMS_BOUNDS, std::move (l));
      }
#else
      static
      symbol_type
      make_OSR_PARAMS_BOUNDS (const location_type& l)
      {
        return symbol_type (token::OSR_PARAMS_BOUNDS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_KEEP_KALMAN_ALGO_IF_SINGULARITY_IS_DETECTED (location_type l)
      {
        return symbol_type (token::KEEP_KALMAN_ALGO_IF_SINGULARITY_IS_DETECTED, std::move (l));
      }
#else
      static
      symbol_type
      make_KEEP_KALMAN_ALGO_IF_SINGULARITY_IS_DETECTED (const location_type& l)
      {
        return symbol_type (token::KEEP_KALMAN_ALGO_IF_SINGULARITY_IS_DETECTED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FALSE (string v, location_type l)
      {
        return symbol_type (token::FALSE, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_FALSE (const string& v, const location_type& l)
      {
        return symbol_type (token::FALSE, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FLOAT_NUMBER (string v, location_type l)
      {
        return symbol_type (token::FLOAT_NUMBER, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_FLOAT_NUMBER (const string& v, const location_type& l)
      {
        return symbol_type (token::FLOAT_NUMBER, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DATES (string v, location_type l)
      {
        return symbol_type (token::DATES, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_DATES (const string& v, const location_type& l)
      {
        return symbol_type (token::DATES, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DEFAULT (location_type l)
      {
        return symbol_type (token::DEFAULT, std::move (l));
      }
#else
      static
      symbol_type
      make_DEFAULT (const location_type& l)
      {
        return symbol_type (token::DEFAULT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FIXED_POINT (location_type l)
      {
        return symbol_type (token::FIXED_POINT, std::move (l));
      }
#else
      static
      symbol_type
      make_FIXED_POINT (const location_type& l)
      {
        return symbol_type (token::FIXED_POINT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FLIP (location_type l)
      {
        return symbol_type (token::FLIP, std::move (l));
      }
#else
      static
      symbol_type
      make_FLIP (const location_type& l)
      {
        return symbol_type (token::FLIP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OPT_ALGO (location_type l)
      {
        return symbol_type (token::OPT_ALGO, std::move (l));
      }
#else
      static
      symbol_type
      make_OPT_ALGO (const location_type& l)
      {
        return symbol_type (token::OPT_ALGO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COMPILATION_SETUP (location_type l)
      {
        return symbol_type (token::COMPILATION_SETUP, std::move (l));
      }
#else
      static
      symbol_type
      make_COMPILATION_SETUP (const location_type& l)
      {
        return symbol_type (token::COMPILATION_SETUP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COMPILER (location_type l)
      {
        return symbol_type (token::COMPILER, std::move (l));
      }
#else
      static
      symbol_type
      make_COMPILER (const location_type& l)
      {
        return symbol_type (token::COMPILER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ADD_FLAGS (location_type l)
      {
        return symbol_type (token::ADD_FLAGS, std::move (l));
      }
#else
      static
      symbol_type
      make_ADD_FLAGS (const location_type& l)
      {
        return symbol_type (token::ADD_FLAGS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SUBSTITUTE_FLAGS (location_type l)
      {
        return symbol_type (token::SUBSTITUTE_FLAGS, std::move (l));
      }
#else
      static
      symbol_type
      make_SUBSTITUTE_FLAGS (const location_type& l)
      {
        return symbol_type (token::SUBSTITUTE_FLAGS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ADD_LIBS (location_type l)
      {
        return symbol_type (token::ADD_LIBS, std::move (l));
      }
#else
      static
      symbol_type
      make_ADD_LIBS (const location_type& l)
      {
        return symbol_type (token::ADD_LIBS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SUBSTITUTE_LIBS (location_type l)
      {
        return symbol_type (token::SUBSTITUTE_LIBS, std::move (l));
      }
#else
      static
      symbol_type
      make_SUBSTITUTE_LIBS (const location_type& l)
      {
        return symbol_type (token::SUBSTITUTE_LIBS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FORECAST (location_type l)
      {
        return symbol_type (token::FORECAST, std::move (l));
      }
#else
      static
      symbol_type
      make_FORECAST (const location_type& l)
      {
        return symbol_type (token::FORECAST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_K_ORDER_SOLVER (location_type l)
      {
        return symbol_type (token::K_ORDER_SOLVER, std::move (l));
      }
#else
      static
      symbol_type
      make_K_ORDER_SOLVER (const location_type& l)
      {
        return symbol_type (token::K_ORDER_SOLVER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INSTRUMENTS (location_type l)
      {
        return symbol_type (token::INSTRUMENTS, std::move (l));
      }
#else
      static
      symbol_type
      make_INSTRUMENTS (const location_type& l)
      {
        return symbol_type (token::INSTRUMENTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHIFT (location_type l)
      {
        return symbol_type (token::SHIFT, std::move (l));
      }
#else
      static
      symbol_type
      make_SHIFT (const location_type& l)
      {
        return symbol_type (token::SHIFT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MEAN (location_type l)
      {
        return symbol_type (token::MEAN, std::move (l));
      }
#else
      static
      symbol_type
      make_MEAN (const location_type& l)
      {
        return symbol_type (token::MEAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STDEV (location_type l)
      {
        return symbol_type (token::STDEV, std::move (l));
      }
#else
      static
      symbol_type
      make_STDEV (const location_type& l)
      {
        return symbol_type (token::STDEV, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VARIANCE (location_type l)
      {
        return symbol_type (token::VARIANCE, std::move (l));
      }
#else
      static
      symbol_type
      make_VARIANCE (const location_type& l)
      {
        return symbol_type (token::VARIANCE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE (location_type l)
      {
        return symbol_type (token::MODE, std::move (l));
      }
#else
      static
      symbol_type
      make_MODE (const location_type& l)
      {
        return symbol_type (token::MODE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INTERVAL (location_type l)
      {
        return symbol_type (token::INTERVAL, std::move (l));
      }
#else
      static
      symbol_type
      make_INTERVAL (const location_type& l)
      {
        return symbol_type (token::INTERVAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHAPE (location_type l)
      {
        return symbol_type (token::SHAPE, std::move (l));
      }
#else
      static
      symbol_type
      make_SHAPE (const location_type& l)
      {
        return symbol_type (token::SHAPE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DOMAINN (location_type l)
      {
        return symbol_type (token::DOMAINN, std::move (l));
      }
#else
      static
      symbol_type
      make_DOMAINN (const location_type& l)
      {
        return symbol_type (token::DOMAINN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GAMMA_PDF (location_type l)
      {
        return symbol_type (token::GAMMA_PDF, std::move (l));
      }
#else
      static
      symbol_type
      make_GAMMA_PDF (const location_type& l)
      {
        return symbol_type (token::GAMMA_PDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GRAPH (location_type l)
      {
        return symbol_type (token::GRAPH, std::move (l));
      }
#else
      static
      symbol_type
      make_GRAPH (const location_type& l)
      {
        return symbol_type (token::GRAPH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GRAPH_FORMAT (location_type l)
      {
        return symbol_type (token::GRAPH_FORMAT, std::move (l));
      }
#else
      static
      symbol_type
      make_GRAPH_FORMAT (const location_type& l)
      {
        return symbol_type (token::GRAPH_FORMAT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONDITIONAL_VARIANCE_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::CONDITIONAL_VARIANCE_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_CONDITIONAL_VARIANCE_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::CONDITIONAL_VARIANCE_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOCHECK (location_type l)
      {
        return symbol_type (token::NOCHECK, std::move (l));
      }
#else
      static
      symbol_type
      make_NOCHECK (const location_type& l)
      {
        return symbol_type (token::NOCHECK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STD (location_type l)
      {
        return symbol_type (token::STD, std::move (l));
      }
#else
      static
      symbol_type
      make_STD (const location_type& l)
      {
        return symbol_type (token::STD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HISTVAL (location_type l)
      {
        return symbol_type (token::HISTVAL, std::move (l));
      }
#else
      static
      symbol_type
      make_HISTVAL (const location_type& l)
      {
        return symbol_type (token::HISTVAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HISTVAL_FILE (location_type l)
      {
        return symbol_type (token::HISTVAL_FILE, std::move (l));
      }
#else
      static
      symbol_type
      make_HISTVAL_FILE (const location_type& l)
      {
        return symbol_type (token::HISTVAL_FILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HOMOTOPY_SETUP (location_type l)
      {
        return symbol_type (token::HOMOTOPY_SETUP, std::move (l));
      }
#else
      static
      symbol_type
      make_HOMOTOPY_SETUP (const location_type& l)
      {
        return symbol_type (token::HOMOTOPY_SETUP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HOMOTOPY_MODE (location_type l)
      {
        return symbol_type (token::HOMOTOPY_MODE, std::move (l));
      }
#else
      static
      symbol_type
      make_HOMOTOPY_MODE (const location_type& l)
      {
        return symbol_type (token::HOMOTOPY_MODE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HOMOTOPY_STEPS (location_type l)
      {
        return symbol_type (token::HOMOTOPY_STEPS, std::move (l));
      }
#else
      static
      symbol_type
      make_HOMOTOPY_STEPS (const location_type& l)
      {
        return symbol_type (token::HOMOTOPY_STEPS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HOMOTOPY_FORCE_CONTINUE (location_type l)
      {
        return symbol_type (token::HOMOTOPY_FORCE_CONTINUE, std::move (l));
      }
#else
      static
      symbol_type
      make_HOMOTOPY_FORCE_CONTINUE (const location_type& l)
      {
        return symbol_type (token::HOMOTOPY_FORCE_CONTINUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HP_FILTER (location_type l)
      {
        return symbol_type (token::HP_FILTER, std::move (l));
      }
#else
      static
      symbol_type
      make_HP_FILTER (const location_type& l)
      {
        return symbol_type (token::HP_FILTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HP_NGRID (location_type l)
      {
        return symbol_type (token::HP_NGRID, std::move (l));
      }
#else
      static
      symbol_type
      make_HP_NGRID (const location_type& l)
      {
        return symbol_type (token::HP_NGRID, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILTERED_THEORETICAL_MOMENTS_GRID (location_type l)
      {
        return symbol_type (token::FILTERED_THEORETICAL_MOMENTS_GRID, std::move (l));
      }
#else
      static
      symbol_type
      make_FILTERED_THEORETICAL_MOMENTS_GRID (const location_type& l)
      {
        return symbol_type (token::FILTERED_THEORETICAL_MOMENTS_GRID, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HYBRID (location_type l)
      {
        return symbol_type (token::HYBRID, std::move (l));
      }
#else
      static
      symbol_type
      make_HYBRID (const location_type& l)
      {
        return symbol_type (token::HYBRID, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ONE_SIDED_HP_FILTER (location_type l)
      {
        return symbol_type (token::ONE_SIDED_HP_FILTER, std::move (l));
      }
#else
      static
      symbol_type
      make_ONE_SIDED_HP_FILTER (const location_type& l)
      {
        return symbol_type (token::ONE_SIDED_HP_FILTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IDENTIFICATION (location_type l)
      {
        return symbol_type (token::IDENTIFICATION, std::move (l));
      }
#else
      static
      symbol_type
      make_IDENTIFICATION (const location_type& l)
      {
        return symbol_type (token::IDENTIFICATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INF_CONSTANT (location_type l)
      {
        return symbol_type (token::INF_CONSTANT, std::move (l));
      }
#else
      static
      symbol_type
      make_INF_CONSTANT (const location_type& l)
      {
        return symbol_type (token::INF_CONSTANT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INITVAL (location_type l)
      {
        return symbol_type (token::INITVAL, std::move (l));
      }
#else
      static
      symbol_type
      make_INITVAL (const location_type& l)
      {
        return symbol_type (token::INITVAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INITVAL_FILE (location_type l)
      {
        return symbol_type (token::INITVAL_FILE, std::move (l));
      }
#else
      static
      symbol_type
      make_INITVAL_FILE (const location_type& l)
      {
        return symbol_type (token::INITVAL_FILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BOUNDS (location_type l)
      {
        return symbol_type (token::BOUNDS, std::move (l));
      }
#else
      static
      symbol_type
      make_BOUNDS (const location_type& l)
      {
        return symbol_type (token::BOUNDS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_JSCALE (location_type l)
      {
        return symbol_type (token::JSCALE, std::move (l));
      }
#else
      static
      symbol_type
      make_JSCALE (const location_type& l)
      {
        return symbol_type (token::JSCALE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INIT (location_type l)
      {
        return symbol_type (token::INIT, std::move (l));
      }
#else
      static
      symbol_type
      make_INIT (const location_type& l)
      {
        return symbol_type (token::INIT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INFILE (location_type l)
      {
        return symbol_type (token::INFILE, std::move (l));
      }
#else
      static
      symbol_type
      make_INFILE (const location_type& l)
      {
        return symbol_type (token::INFILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INVARS (location_type l)
      {
        return symbol_type (token::INVARS, std::move (l));
      }
#else
      static
      symbol_type
      make_INVARS (const location_type& l)
      {
        return symbol_type (token::INVARS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INT_NUMBER (string v, location_type l)
      {
        return symbol_type (token::INT_NUMBER, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_INT_NUMBER (const string& v, const location_type& l)
      {
        return symbol_type (token::INT_NUMBER, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INV_GAMMA_PDF (location_type l)
      {
        return symbol_type (token::INV_GAMMA_PDF, std::move (l));
      }
#else
      static
      symbol_type
      make_INV_GAMMA_PDF (const location_type& l)
      {
        return symbol_type (token::INV_GAMMA_PDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INV_GAMMA1_PDF (location_type l)
      {
        return symbol_type (token::INV_GAMMA1_PDF, std::move (l));
      }
#else
      static
      symbol_type
      make_INV_GAMMA1_PDF (const location_type& l)
      {
        return symbol_type (token::INV_GAMMA1_PDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INV_GAMMA2_PDF (location_type l)
      {
        return symbol_type (token::INV_GAMMA2_PDF, std::move (l));
      }
#else
      static
      symbol_type
      make_INV_GAMMA2_PDF (const location_type& l)
      {
        return symbol_type (token::INV_GAMMA2_PDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IRF (location_type l)
      {
        return symbol_type (token::IRF, std::move (l));
      }
#else
      static
      symbol_type
      make_IRF (const location_type& l)
      {
        return symbol_type (token::IRF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IRF_SHOCKS (location_type l)
      {
        return symbol_type (token::IRF_SHOCKS, std::move (l));
      }
#else
      static
      symbol_type
      make_IRF_SHOCKS (const location_type& l)
      {
        return symbol_type (token::IRF_SHOCKS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IRF_PLOT_THRESHOLD (location_type l)
      {
        return symbol_type (token::IRF_PLOT_THRESHOLD, std::move (l));
      }
#else
      static
      symbol_type
      make_IRF_PLOT_THRESHOLD (const location_type& l)
      {
        return symbol_type (token::IRF_PLOT_THRESHOLD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IRF_CALIBRATION (location_type l)
      {
        return symbol_type (token::IRF_CALIBRATION, std::move (l));
      }
#else
      static
      symbol_type
      make_IRF_CALIBRATION (const location_type& l)
      {
        return symbol_type (token::IRF_CALIBRATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FAST_KALMAN_FILTER (location_type l)
      {
        return symbol_type (token::FAST_KALMAN_FILTER, std::move (l));
      }
#else
      static
      symbol_type
      make_FAST_KALMAN_FILTER (const location_type& l)
      {
        return symbol_type (token::FAST_KALMAN_FILTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_KALMAN_ALGO (location_type l)
      {
        return symbol_type (token::KALMAN_ALGO, std::move (l));
      }
#else
      static
      symbol_type
      make_KALMAN_ALGO (const location_type& l)
      {
        return symbol_type (token::KALMAN_ALGO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_KALMAN_TOL (location_type l)
      {
        return symbol_type (token::KALMAN_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_KALMAN_TOL (const location_type& l)
      {
        return symbol_type (token::KALMAN_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIFFUSE_KALMAN_TOL (location_type l)
      {
        return symbol_type (token::DIFFUSE_KALMAN_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_DIFFUSE_KALMAN_TOL (const location_type& l)
      {
        return symbol_type (token::DIFFUSE_KALMAN_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SCHUR_VEC_TOL (location_type l)
      {
        return symbol_type (token::SCHUR_VEC_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_SCHUR_VEC_TOL (const location_type& l)
      {
        return symbol_type (token::SCHUR_VEC_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SUBSAMPLES (location_type l)
      {
        return symbol_type (token::SUBSAMPLES, std::move (l));
      }
#else
      static
      symbol_type
      make_SUBSAMPLES (const location_type& l)
      {
        return symbol_type (token::SUBSAMPLES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OPTIONS (location_type l)
      {
        return symbol_type (token::OPTIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_OPTIONS (const location_type& l)
      {
        return symbol_type (token::OPTIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TOLF (location_type l)
      {
        return symbol_type (token::TOLF, std::move (l));
      }
#else
      static
      symbol_type
      make_TOLF (const location_type& l)
      {
        return symbol_type (token::TOLF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TOLX (location_type l)
      {
        return symbol_type (token::TOLX, std::move (l));
      }
#else
      static
      symbol_type
      make_TOLX (const location_type& l)
      {
        return symbol_type (token::TOLX, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLOT_INIT_DATE (location_type l)
      {
        return symbol_type (token::PLOT_INIT_DATE, std::move (l));
      }
#else
      static
      symbol_type
      make_PLOT_INIT_DATE (const location_type& l)
      {
        return symbol_type (token::PLOT_INIT_DATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLOT_END_DATE (location_type l)
      {
        return symbol_type (token::PLOT_END_DATE, std::move (l));
      }
#else
      static
      symbol_type
      make_PLOT_END_DATE (const location_type& l)
      {
        return symbol_type (token::PLOT_END_DATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LAPLACE (location_type l)
      {
        return symbol_type (token::LAPLACE, std::move (l));
      }
#else
      static
      symbol_type
      make_LAPLACE (const location_type& l)
      {
        return symbol_type (token::LAPLACE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIK_ALGO (location_type l)
      {
        return symbol_type (token::LIK_ALGO, std::move (l));
      }
#else
      static
      symbol_type
      make_LIK_ALGO (const location_type& l)
      {
        return symbol_type (token::LIK_ALGO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIK_INIT (location_type l)
      {
        return symbol_type (token::LIK_INIT, std::move (l));
      }
#else
      static
      symbol_type
      make_LIK_INIT (const location_type& l)
      {
        return symbol_type (token::LIK_INIT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LINEAR (location_type l)
      {
        return symbol_type (token::LINEAR, std::move (l));
      }
#else
      static
      symbol_type
      make_LINEAR (const location_type& l)
      {
        return symbol_type (token::LINEAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LINEAR_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::LINEAR_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_LINEAR_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::LINEAR_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOAD_IDENT_FILES (location_type l)
      {
        return symbol_type (token::LOAD_IDENT_FILES, std::move (l));
      }
#else
      static
      symbol_type
      make_LOAD_IDENT_FILES (const location_type& l)
      {
        return symbol_type (token::LOAD_IDENT_FILES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOAD_MH_FILE (location_type l)
      {
        return symbol_type (token::LOAD_MH_FILE, std::move (l));
      }
#else
      static
      symbol_type
      make_LOAD_MH_FILE (const location_type& l)
      {
        return symbol_type (token::LOAD_MH_FILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOAD_RESULTS_AFTER_LOAD_MH (location_type l)
      {
        return symbol_type (token::LOAD_RESULTS_AFTER_LOAD_MH, std::move (l));
      }
#else
      static
      symbol_type
      make_LOAD_RESULTS_AFTER_LOAD_MH (const location_type& l)
      {
        return symbol_type (token::LOAD_RESULTS_AFTER_LOAD_MH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOAD_PARAMS_AND_STEADY_STATE (location_type l)
      {
        return symbol_type (token::LOAD_PARAMS_AND_STEADY_STATE, std::move (l));
      }
#else
      static
      symbol_type
      make_LOAD_PARAMS_AND_STEADY_STATE (const location_type& l)
      {
        return symbol_type (token::LOAD_PARAMS_AND_STEADY_STATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOGLINEAR (location_type l)
      {
        return symbol_type (token::LOGLINEAR, std::move (l));
      }
#else
      static
      symbol_type
      make_LOGLINEAR (const location_type& l)
      {
        return symbol_type (token::LOGLINEAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOGDATA (location_type l)
      {
        return symbol_type (token::LOGDATA, std::move (l));
      }
#else
      static
      symbol_type
      make_LOGDATA (const location_type& l)
      {
        return symbol_type (token::LOGDATA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LYAPUNOV (location_type l)
      {
        return symbol_type (token::LYAPUNOV, std::move (l));
      }
#else
      static
      symbol_type
      make_LYAPUNOV (const location_type& l)
      {
        return symbol_type (token::LYAPUNOV, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LINEAR_APPROXIMATION (location_type l)
      {
        return symbol_type (token::LINEAR_APPROXIMATION, std::move (l));
      }
#else
      static
      symbol_type
      make_LINEAR_APPROXIMATION (const location_type& l)
      {
        return symbol_type (token::LINEAR_APPROXIMATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LYAPUNOV_COMPLEX_THRESHOLD (location_type l)
      {
        return symbol_type (token::LYAPUNOV_COMPLEX_THRESHOLD, std::move (l));
      }
#else
      static
      symbol_type
      make_LYAPUNOV_COMPLEX_THRESHOLD (const location_type& l)
      {
        return symbol_type (token::LYAPUNOV_COMPLEX_THRESHOLD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LYAPUNOV_FIXED_POINT_TOL (location_type l)
      {
        return symbol_type (token::LYAPUNOV_FIXED_POINT_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_LYAPUNOV_FIXED_POINT_TOL (const location_type& l)
      {
        return symbol_type (token::LYAPUNOV_FIXED_POINT_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LYAPUNOV_DOUBLING_TOL (location_type l)
      {
        return symbol_type (token::LYAPUNOV_DOUBLING_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_LYAPUNOV_DOUBLING_TOL (const location_type& l)
      {
        return symbol_type (token::LYAPUNOV_DOUBLING_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOG_DEFLATOR (location_type l)
      {
        return symbol_type (token::LOG_DEFLATOR, std::move (l));
      }
#else
      static
      symbol_type
      make_LOG_DEFLATOR (const location_type& l)
      {
        return symbol_type (token::LOG_DEFLATOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOG_TREND_VAR (location_type l)
      {
        return symbol_type (token::LOG_TREND_VAR, std::move (l));
      }
#else
      static
      symbol_type
      make_LOG_TREND_VAR (const location_type& l)
      {
        return symbol_type (token::LOG_TREND_VAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOG_GROWTH_FACTOR (location_type l)
      {
        return symbol_type (token::LOG_GROWTH_FACTOR, std::move (l));
      }
#else
      static
      symbol_type
      make_LOG_GROWTH_FACTOR (const location_type& l)
      {
        return symbol_type (token::LOG_GROWTH_FACTOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MATCHED_MOMENTS (location_type l)
      {
        return symbol_type (token::MATCHED_MOMENTS, std::move (l));
      }
#else
      static
      symbol_type
      make_MATCHED_MOMENTS (const location_type& l)
      {
        return symbol_type (token::MATCHED_MOMENTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MARKOWITZ (location_type l)
      {
        return symbol_type (token::MARKOWITZ, std::move (l));
      }
#else
      static
      symbol_type
      make_MARKOWITZ (const location_type& l)
      {
        return symbol_type (token::MARKOWITZ, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MARGINAL_DENSITY (location_type l)
      {
        return symbol_type (token::MARGINAL_DENSITY, std::move (l));
      }
#else
      static
      symbol_type
      make_MARGINAL_DENSITY (const location_type& l)
      {
        return symbol_type (token::MARGINAL_DENSITY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX (location_type l)
      {
        return symbol_type (token::MAX, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX (const location_type& l)
      {
        return symbol_type (token::MAX, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAXIT (location_type l)
      {
        return symbol_type (token::MAXIT, std::move (l));
      }
#else
      static
      symbol_type
      make_MAXIT (const location_type& l)
      {
        return symbol_type (token::MAXIT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MFS (location_type l)
      {
        return symbol_type (token::MFS, std::move (l));
      }
#else
      static
      symbol_type
      make_MFS (const location_type& l)
      {
        return symbol_type (token::MFS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_CONF_SIG (location_type l)
      {
        return symbol_type (token::MH_CONF_SIG, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_CONF_SIG (const location_type& l)
      {
        return symbol_type (token::MH_CONF_SIG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_DROP (location_type l)
      {
        return symbol_type (token::MH_DROP, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_DROP (const location_type& l)
      {
        return symbol_type (token::MH_DROP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_INIT_SCALE (location_type l)
      {
        return symbol_type (token::MH_INIT_SCALE, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_INIT_SCALE (const location_type& l)
      {
        return symbol_type (token::MH_INIT_SCALE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_JSCALE (location_type l)
      {
        return symbol_type (token::MH_JSCALE, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_JSCALE (const location_type& l)
      {
        return symbol_type (token::MH_JSCALE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_TUNE_JSCALE (location_type l)
      {
        return symbol_type (token::MH_TUNE_JSCALE, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_TUNE_JSCALE (const location_type& l)
      {
        return symbol_type (token::MH_TUNE_JSCALE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_TUNE_GUESS (location_type l)
      {
        return symbol_type (token::MH_TUNE_GUESS, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_TUNE_GUESS (const location_type& l)
      {
        return symbol_type (token::MH_TUNE_GUESS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_POSTERIOR_MODE_ESTIMATION (location_type l)
      {
        return symbol_type (token::MH_POSTERIOR_MODE_ESTIMATION, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_POSTERIOR_MODE_ESTIMATION (const location_type& l)
      {
        return symbol_type (token::MH_POSTERIOR_MODE_ESTIMATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_NBLOCKS (location_type l)
      {
        return symbol_type (token::MH_NBLOCKS, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_NBLOCKS (const location_type& l)
      {
        return symbol_type (token::MH_NBLOCKS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_REPLIC (location_type l)
      {
        return symbol_type (token::MH_REPLIC, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_REPLIC (const location_type& l)
      {
        return symbol_type (token::MH_REPLIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_RECOVER (location_type l)
      {
        return symbol_type (token::MH_RECOVER, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_RECOVER (const location_type& l)
      {
        return symbol_type (token::MH_RECOVER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_INITIALIZE_FROM_PREVIOUS_MCMC (location_type l)
      {
        return symbol_type (token::MH_INITIALIZE_FROM_PREVIOUS_MCMC, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_INITIALIZE_FROM_PREVIOUS_MCMC (const location_type& l)
      {
        return symbol_type (token::MH_INITIALIZE_FROM_PREVIOUS_MCMC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_INITIALIZE_FROM_PREVIOUS_MCMC_DIRECTORY (location_type l)
      {
        return symbol_type (token::MH_INITIALIZE_FROM_PREVIOUS_MCMC_DIRECTORY, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_INITIALIZE_FROM_PREVIOUS_MCMC_DIRECTORY (const location_type& l)
      {
        return symbol_type (token::MH_INITIALIZE_FROM_PREVIOUS_MCMC_DIRECTORY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_INITIALIZE_FROM_PREVIOUS_MCMC_RECORD (location_type l)
      {
        return symbol_type (token::MH_INITIALIZE_FROM_PREVIOUS_MCMC_RECORD, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_INITIALIZE_FROM_PREVIOUS_MCMC_RECORD (const location_type& l)
      {
        return symbol_type (token::MH_INITIALIZE_FROM_PREVIOUS_MCMC_RECORD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_INITIALIZE_FROM_PREVIOUS_MCMC_PRIOR (location_type l)
      {
        return symbol_type (token::MH_INITIALIZE_FROM_PREVIOUS_MCMC_PRIOR, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_INITIALIZE_FROM_PREVIOUS_MCMC_PRIOR (const location_type& l)
      {
        return symbol_type (token::MH_INITIALIZE_FROM_PREVIOUS_MCMC_PRIOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_MAX_SUBSAMPLE_DRAWS (location_type l)
      {
        return symbol_type (token::POSTERIOR_MAX_SUBSAMPLE_DRAWS, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_MAX_SUBSAMPLE_DRAWS (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_MAX_SUBSAMPLE_DRAWS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MIN (location_type l)
      {
        return symbol_type (token::MIN, std::move (l));
      }
#else
      static
      symbol_type
      make_MIN (const location_type& l)
      {
        return symbol_type (token::MIN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MINIMAL_SOLVING_PERIODS (location_type l)
      {
        return symbol_type (token::MINIMAL_SOLVING_PERIODS, std::move (l));
      }
#else
      static
      symbol_type
      make_MINIMAL_SOLVING_PERIODS (const location_type& l)
      {
        return symbol_type (token::MINIMAL_SOLVING_PERIODS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_CHECK (location_type l)
      {
        return symbol_type (token::MODE_CHECK, std::move (l));
      }
#else
      static
      symbol_type
      make_MODE_CHECK (const location_type& l)
      {
        return symbol_type (token::MODE_CHECK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_CHECK_NEIGHBOURHOOD_SIZE (location_type l)
      {
        return symbol_type (token::MODE_CHECK_NEIGHBOURHOOD_SIZE, std::move (l));
      }
#else
      static
      symbol_type
      make_MODE_CHECK_NEIGHBOURHOOD_SIZE (const location_type& l)
      {
        return symbol_type (token::MODE_CHECK_NEIGHBOURHOOD_SIZE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_CHECK_SYMMETRIC_PLOTS (location_type l)
      {
        return symbol_type (token::MODE_CHECK_SYMMETRIC_PLOTS, std::move (l));
      }
#else
      static
      symbol_type
      make_MODE_CHECK_SYMMETRIC_PLOTS (const location_type& l)
      {
        return symbol_type (token::MODE_CHECK_SYMMETRIC_PLOTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_CHECK_NUMBER_OF_POINTS (location_type l)
      {
        return symbol_type (token::MODE_CHECK_NUMBER_OF_POINTS, std::move (l));
      }
#else
      static
      symbol_type
      make_MODE_CHECK_NUMBER_OF_POINTS (const location_type& l)
      {
        return symbol_type (token::MODE_CHECK_NUMBER_OF_POINTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_COMPUTE (location_type l)
      {
        return symbol_type (token::MODE_COMPUTE, std::move (l));
      }
#else
      static
      symbol_type
      make_MODE_COMPUTE (const location_type& l)
      {
        return symbol_type (token::MODE_COMPUTE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_FILE (location_type l)
      {
        return symbol_type (token::MODE_FILE, std::move (l));
      }
#else
      static
      symbol_type
      make_MODE_FILE (const location_type& l)
      {
        return symbol_type (token::MODE_FILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODEL (location_type l)
      {
        return symbol_type (token::MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_MODEL (const location_type& l)
      {
        return symbol_type (token::MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODEL_COMPARISON (location_type l)
      {
        return symbol_type (token::MODEL_COMPARISON, std::move (l));
      }
#else
      static
      symbol_type
      make_MODEL_COMPARISON (const location_type& l)
      {
        return symbol_type (token::MODEL_COMPARISON, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODEL_INFO (location_type l)
      {
        return symbol_type (token::MODEL_INFO, std::move (l));
      }
#else
      static
      symbol_type
      make_MODEL_INFO (const location_type& l)
      {
        return symbol_type (token::MODEL_INFO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MSHOCKS (location_type l)
      {
        return symbol_type (token::MSHOCKS, std::move (l));
      }
#else
      static
      symbol_type
      make_MSHOCKS (const location_type& l)
      {
        return symbol_type (token::MSHOCKS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ABS (location_type l)
      {
        return symbol_type (token::ABS, std::move (l));
      }
#else
      static
      symbol_type
      make_ABS (const location_type& l)
      {
        return symbol_type (token::ABS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIGN (location_type l)
      {
        return symbol_type (token::SIGN, std::move (l));
      }
#else
      static
      symbol_type
      make_SIGN (const location_type& l)
      {
        return symbol_type (token::SIGN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODEL_DIAGNOSTICS (location_type l)
      {
        return symbol_type (token::MODEL_DIAGNOSTICS, std::move (l));
      }
#else
      static
      symbol_type
      make_MODEL_DIAGNOSTICS (const location_type& l)
      {
        return symbol_type (token::MODEL_DIAGNOSTICS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODIFIEDHARMONICMEAN (location_type l)
      {
        return symbol_type (token::MODIFIEDHARMONICMEAN, std::move (l));
      }
#else
      static
      symbol_type
      make_MODIFIEDHARMONICMEAN (const location_type& l)
      {
        return symbol_type (token::MODIFIEDHARMONICMEAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MOMENTS_VARENDO (location_type l)
      {
        return symbol_type (token::MOMENTS_VARENDO, std::move (l));
      }
#else
      static
      symbol_type
      make_MOMENTS_VARENDO (const location_type& l)
      {
        return symbol_type (token::MOMENTS_VARENDO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONTEMPORANEOUS_CORRELATION (location_type l)
      {
        return symbol_type (token::CONTEMPORANEOUS_CORRELATION, std::move (l));
      }
#else
      static
      symbol_type
      make_CONTEMPORANEOUS_CORRELATION (const location_type& l)
      {
        return symbol_type (token::CONTEMPORANEOUS_CORRELATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIFFUSE_FILTER (location_type l)
      {
        return symbol_type (token::DIFFUSE_FILTER, std::move (l));
      }
#else
      static
      symbol_type
      make_DIFFUSE_FILTER (const location_type& l)
      {
        return symbol_type (token::DIFFUSE_FILTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SUB_DRAWS (location_type l)
      {
        return symbol_type (token::SUB_DRAWS, std::move (l));
      }
#else
      static
      symbol_type
      make_SUB_DRAWS (const location_type& l)
      {
        return symbol_type (token::SUB_DRAWS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TAPER_STEPS (location_type l)
      {
        return symbol_type (token::TAPER_STEPS, std::move (l));
      }
#else
      static
      symbol_type
      make_TAPER_STEPS (const location_type& l)
      {
        return symbol_type (token::TAPER_STEPS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GEWEKE_INTERVAL (location_type l)
      {
        return symbol_type (token::GEWEKE_INTERVAL, std::move (l));
      }
#else
      static
      symbol_type
      make_GEWEKE_INTERVAL (const location_type& l)
      {
        return symbol_type (token::GEWEKE_INTERVAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RAFTERY_LEWIS_QRS (location_type l)
      {
        return symbol_type (token::RAFTERY_LEWIS_QRS, std::move (l));
      }
#else
      static
      symbol_type
      make_RAFTERY_LEWIS_QRS (const location_type& l)
      {
        return symbol_type (token::RAFTERY_LEWIS_QRS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RAFTERY_LEWIS_DIAGNOSTICS (location_type l)
      {
        return symbol_type (token::RAFTERY_LEWIS_DIAGNOSTICS, std::move (l));
      }
#else
      static
      symbol_type
      make_RAFTERY_LEWIS_DIAGNOSTICS (const location_type& l)
      {
        return symbol_type (token::RAFTERY_LEWIS_DIAGNOSTICS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MCMC_JUMPING_COVARIANCE (location_type l)
      {
        return symbol_type (token::MCMC_JUMPING_COVARIANCE, std::move (l));
      }
#else
      static
      symbol_type
      make_MCMC_JUMPING_COVARIANCE (const location_type& l)
      {
        return symbol_type (token::MCMC_JUMPING_COVARIANCE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MOMENT_CALIBRATION (location_type l)
      {
        return symbol_type (token::MOMENT_CALIBRATION, std::move (l));
      }
#else
      static
      symbol_type
      make_MOMENT_CALIBRATION (const location_type& l)
      {
        return symbol_type (token::MOMENT_CALIBRATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NUMBER_OF_PARTICLES (location_type l)
      {
        return symbol_type (token::NUMBER_OF_PARTICLES, std::move (l));
      }
#else
      static
      symbol_type
      make_NUMBER_OF_PARTICLES (const location_type& l)
      {
        return symbol_type (token::NUMBER_OF_PARTICLES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RESAMPLING (location_type l)
      {
        return symbol_type (token::RESAMPLING, std::move (l));
      }
#else
      static
      symbol_type
      make_RESAMPLING (const location_type& l)
      {
        return symbol_type (token::RESAMPLING, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SYSTEMATIC (location_type l)
      {
        return symbol_type (token::SYSTEMATIC, std::move (l));
      }
#else
      static
      symbol_type
      make_SYSTEMATIC (const location_type& l)
      {
        return symbol_type (token::SYSTEMATIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GENERIC (location_type l)
      {
        return symbol_type (token::GENERIC, std::move (l));
      }
#else
      static
      symbol_type
      make_GENERIC (const location_type& l)
      {
        return symbol_type (token::GENERIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RESAMPLING_THRESHOLD (location_type l)
      {
        return symbol_type (token::RESAMPLING_THRESHOLD, std::move (l));
      }
#else
      static
      symbol_type
      make_RESAMPLING_THRESHOLD (const location_type& l)
      {
        return symbol_type (token::RESAMPLING_THRESHOLD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RESAMPLING_METHOD (location_type l)
      {
        return symbol_type (token::RESAMPLING_METHOD, std::move (l));
      }
#else
      static
      symbol_type
      make_RESAMPLING_METHOD (const location_type& l)
      {
        return symbol_type (token::RESAMPLING_METHOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_KITAGAWA (location_type l)
      {
        return symbol_type (token::KITAGAWA, std::move (l));
      }
#else
      static
      symbol_type
      make_KITAGAWA (const location_type& l)
      {
        return symbol_type (token::KITAGAWA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STRATIFIED (location_type l)
      {
        return symbol_type (token::STRATIFIED, std::move (l));
      }
#else
      static
      symbol_type
      make_STRATIFIED (const location_type& l)
      {
        return symbol_type (token::STRATIFIED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMOOTH (location_type l)
      {
        return symbol_type (token::SMOOTH, std::move (l));
      }
#else
      static
      symbol_type
      make_SMOOTH (const location_type& l)
      {
        return symbol_type (token::SMOOTH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CPF_WEIGHTS (location_type l)
      {
        return symbol_type (token::CPF_WEIGHTS, std::move (l));
      }
#else
      static
      symbol_type
      make_CPF_WEIGHTS (const location_type& l)
      {
        return symbol_type (token::CPF_WEIGHTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AMISANOTRISTANI (location_type l)
      {
        return symbol_type (token::AMISANOTRISTANI, std::move (l));
      }
#else
      static
      symbol_type
      make_AMISANOTRISTANI (const location_type& l)
      {
        return symbol_type (token::AMISANOTRISTANI, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MURRAYJONESPARSLOW (location_type l)
      {
        return symbol_type (token::MURRAYJONESPARSLOW, std::move (l));
      }
#else
      static
      symbol_type
      make_MURRAYJONESPARSLOW (const location_type& l)
      {
        return symbol_type (token::MURRAYJONESPARSLOW, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WRITE_EQUATION_TAGS (location_type l)
      {
        return symbol_type (token::WRITE_EQUATION_TAGS, std::move (l));
      }
#else
      static
      symbol_type
      make_WRITE_EQUATION_TAGS (const location_type& l)
      {
        return symbol_type (token::WRITE_EQUATION_TAGS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILTER_INITIAL_STATE (location_type l)
      {
        return symbol_type (token::FILTER_INITIAL_STATE, std::move (l));
      }
#else
      static
      symbol_type
      make_FILTER_INITIAL_STATE (const location_type& l)
      {
        return symbol_type (token::FILTER_INITIAL_STATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NONLINEAR_FILTER_INITIALIZATION (location_type l)
      {
        return symbol_type (token::NONLINEAR_FILTER_INITIALIZATION, std::move (l));
      }
#else
      static
      symbol_type
      make_NONLINEAR_FILTER_INITIALIZATION (const location_type& l)
      {
        return symbol_type (token::NONLINEAR_FILTER_INITIALIZATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILTER_ALGORITHM (location_type l)
      {
        return symbol_type (token::FILTER_ALGORITHM, std::move (l));
      }
#else
      static
      symbol_type
      make_FILTER_ALGORITHM (const location_type& l)
      {
        return symbol_type (token::FILTER_ALGORITHM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PROPOSAL_APPROXIMATION (location_type l)
      {
        return symbol_type (token::PROPOSAL_APPROXIMATION, std::move (l));
      }
#else
      static
      symbol_type
      make_PROPOSAL_APPROXIMATION (const location_type& l)
      {
        return symbol_type (token::PROPOSAL_APPROXIMATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CUBATURE (location_type l)
      {
        return symbol_type (token::CUBATURE, std::move (l));
      }
#else
      static
      symbol_type
      make_CUBATURE (const location_type& l)
      {
        return symbol_type (token::CUBATURE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNSCENTED (location_type l)
      {
        return symbol_type (token::UNSCENTED, std::move (l));
      }
#else
      static
      symbol_type
      make_UNSCENTED (const location_type& l)
      {
        return symbol_type (token::UNSCENTED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MONTECARLO (location_type l)
      {
        return symbol_type (token::MONTECARLO, std::move (l));
      }
#else
      static
      symbol_type
      make_MONTECARLO (const location_type& l)
      {
        return symbol_type (token::MONTECARLO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DISTRIBUTION_APPROXIMATION (location_type l)
      {
        return symbol_type (token::DISTRIBUTION_APPROXIMATION, std::move (l));
      }
#else
      static
      symbol_type
      make_DISTRIBUTION_APPROXIMATION (const location_type& l)
      {
        return symbol_type (token::DISTRIBUTION_APPROXIMATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NAME (string v, location_type l)
      {
        return symbol_type (token::NAME, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_NAME (const string& v, const location_type& l)
      {
        return symbol_type (token::NAME, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_USE_PENALIZED_OBJECTIVE_FOR_HESSIAN (location_type l)
      {
        return symbol_type (token::USE_PENALIZED_OBJECTIVE_FOR_HESSIAN, std::move (l));
      }
#else
      static
      symbol_type
      make_USE_PENALIZED_OBJECTIVE_FOR_HESSIAN (const location_type& l)
      {
        return symbol_type (token::USE_PENALIZED_OBJECTIVE_FOR_HESSIAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INIT_STATE (location_type l)
      {
        return symbol_type (token::INIT_STATE, std::move (l));
      }
#else
      static
      symbol_type
      make_INIT_STATE (const location_type& l)
      {
        return symbol_type (token::INIT_STATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FAST_REALTIME (location_type l)
      {
        return symbol_type (token::FAST_REALTIME, std::move (l));
      }
#else
      static
      symbol_type
      make_FAST_REALTIME (const location_type& l)
      {
        return symbol_type (token::FAST_REALTIME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RESCALE_PREDICTION_ERROR_COVARIANCE (location_type l)
      {
        return symbol_type (token::RESCALE_PREDICTION_ERROR_COVARIANCE, std::move (l));
      }
#else
      static
      symbol_type
      make_RESCALE_PREDICTION_ERROR_COVARIANCE (const location_type& l)
      {
        return symbol_type (token::RESCALE_PREDICTION_ERROR_COVARIANCE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GENERATE_IRFS (location_type l)
      {
        return symbol_type (token::GENERATE_IRFS, std::move (l));
      }
#else
      static
      symbol_type
      make_GENERATE_IRFS (const location_type& l)
      {
        return symbol_type (token::GENERATE_IRFS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NAN_CONSTANT (location_type l)
      {
        return symbol_type (token::NAN_CONSTANT, std::move (l));
      }
#else
      static
      symbol_type
      make_NAN_CONSTANT (const location_type& l)
      {
        return symbol_type (token::NAN_CONSTANT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_STATIC (location_type l)
      {
        return symbol_type (token::NO_STATIC, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_STATIC (const location_type& l)
      {
        return symbol_type (token::NO_STATIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOBS (location_type l)
      {
        return symbol_type (token::NOBS, std::move (l));
      }
#else
      static
      symbol_type
      make_NOBS (const location_type& l)
      {
        return symbol_type (token::NOBS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOCONSTANT (location_type l)
      {
        return symbol_type (token::NOCONSTANT, std::move (l));
      }
#else
      static
      symbol_type
      make_NOCONSTANT (const location_type& l)
      {
        return symbol_type (token::NOCONSTANT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NODISPLAY (location_type l)
      {
        return symbol_type (token::NODISPLAY, std::move (l));
      }
#else
      static
      symbol_type
      make_NODISPLAY (const location_type& l)
      {
        return symbol_type (token::NODISPLAY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOCORR (location_type l)
      {
        return symbol_type (token::NOCORR, std::move (l));
      }
#else
      static
      symbol_type
      make_NOCORR (const location_type& l)
      {
        return symbol_type (token::NOCORR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NODIAGNOSTIC (location_type l)
      {
        return symbol_type (token::NODIAGNOSTIC, std::move (l));
      }
#else
      static
      symbol_type
      make_NODIAGNOSTIC (const location_type& l)
      {
        return symbol_type (token::NODIAGNOSTIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOFUNCTIONS (location_type l)
      {
        return symbol_type (token::NOFUNCTIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_NOFUNCTIONS (const location_type& l)
      {
        return symbol_type (token::NOFUNCTIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_HOMOTOPY (location_type l)
      {
        return symbol_type (token::NO_HOMOTOPY, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_HOMOTOPY (const location_type& l)
      {
        return symbol_type (token::NO_HOMOTOPY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOGRAPH (location_type l)
      {
        return symbol_type (token::NOGRAPH, std::move (l));
      }
#else
      static
      symbol_type
      make_NOGRAPH (const location_type& l)
      {
        return symbol_type (token::NOGRAPH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_NOGRAPH (location_type l)
      {
        return symbol_type (token::POSTERIOR_NOGRAPH, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_NOGRAPH (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_NOGRAPH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_GRAPH (location_type l)
      {
        return symbol_type (token::POSTERIOR_GRAPH, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_GRAPH (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_GRAPH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOMOMENTS (location_type l)
      {
        return symbol_type (token::NOMOMENTS, std::move (l));
      }
#else
      static
      symbol_type
      make_NOMOMENTS (const location_type& l)
      {
        return symbol_type (token::NOMOMENTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOPRINT (location_type l)
      {
        return symbol_type (token::NOPRINT, std::move (l));
      }
#else
      static
      symbol_type
      make_NOPRINT (const location_type& l)
      {
        return symbol_type (token::NOPRINT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NORMAL_PDF (location_type l)
      {
        return symbol_type (token::NORMAL_PDF, std::move (l));
      }
#else
      static
      symbol_type
      make_NORMAL_PDF (const location_type& l)
      {
        return symbol_type (token::NORMAL_PDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SAVE_DRAWS (location_type l)
      {
        return symbol_type (token::SAVE_DRAWS, std::move (l));
      }
#else
      static
      symbol_type
      make_SAVE_DRAWS (const location_type& l)
      {
        return symbol_type (token::SAVE_DRAWS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODEL_NAME (location_type l)
      {
        return symbol_type (token::MODEL_NAME, std::move (l));
      }
#else
      static
      symbol_type
      make_MODEL_NAME (const location_type& l)
      {
        return symbol_type (token::MODEL_NAME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STDERR_MULTIPLES (location_type l)
      {
        return symbol_type (token::STDERR_MULTIPLES, std::move (l));
      }
#else
      static
      symbol_type
      make_STDERR_MULTIPLES (const location_type& l)
      {
        return symbol_type (token::STDERR_MULTIPLES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIAGONAL_ONLY (location_type l)
      {
        return symbol_type (token::DIAGONAL_ONLY, std::move (l));
      }
#else
      static
      symbol_type
      make_DIAGONAL_ONLY (const location_type& l)
      {
        return symbol_type (token::DIAGONAL_ONLY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DETERMINISTIC_TRENDS (location_type l)
      {
        return symbol_type (token::DETERMINISTIC_TRENDS, std::move (l));
      }
#else
      static
      symbol_type
      make_DETERMINISTIC_TRENDS (const location_type& l)
      {
        return symbol_type (token::DETERMINISTIC_TRENDS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OBSERVATION_TRENDS (location_type l)
      {
        return symbol_type (token::OBSERVATION_TRENDS, std::move (l));
      }
#else
      static
      symbol_type
      make_OBSERVATION_TRENDS (const location_type& l)
      {
        return symbol_type (token::OBSERVATION_TRENDS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OPTIM (location_type l)
      {
        return symbol_type (token::OPTIM, std::move (l));
      }
#else
      static
      symbol_type
      make_OPTIM (const location_type& l)
      {
        return symbol_type (token::OPTIM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OPTIM_WEIGHTS (location_type l)
      {
        return symbol_type (token::OPTIM_WEIGHTS, std::move (l));
      }
#else
      static
      symbol_type
      make_OPTIM_WEIGHTS (const location_type& l)
      {
        return symbol_type (token::OPTIM_WEIGHTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ORDER (location_type l)
      {
        return symbol_type (token::ORDER, std::move (l));
      }
#else
      static
      symbol_type
      make_ORDER (const location_type& l)
      {
        return symbol_type (token::ORDER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OSR (location_type l)
      {
        return symbol_type (token::OSR, std::move (l));
      }
#else
      static
      symbol_type
      make_OSR (const location_type& l)
      {
        return symbol_type (token::OSR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OSR_PARAMS (location_type l)
      {
        return symbol_type (token::OSR_PARAMS, std::move (l));
      }
#else
      static
      symbol_type
      make_OSR_PARAMS (const location_type& l)
      {
        return symbol_type (token::OSR_PARAMS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX_DIM_COVA_GROUP (location_type l)
      {
        return symbol_type (token::MAX_DIM_COVA_GROUP, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX_DIM_COVA_GROUP (const location_type& l)
      {
        return symbol_type (token::MAX_DIM_COVA_GROUP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ADVANCED (location_type l)
      {
        return symbol_type (token::ADVANCED, std::move (l));
      }
#else
      static
      symbol_type
      make_ADVANCED (const location_type& l)
      {
        return symbol_type (token::ADVANCED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OUTFILE (location_type l)
      {
        return symbol_type (token::OUTFILE, std::move (l));
      }
#else
      static
      symbol_type
      make_OUTFILE (const location_type& l)
      {
        return symbol_type (token::OUTFILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OUTVARS (location_type l)
      {
        return symbol_type (token::OUTVARS, std::move (l));
      }
#else
      static
      symbol_type
      make_OUTVARS (const location_type& l)
      {
        return symbol_type (token::OUTVARS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OVERWRITE (location_type l)
      {
        return symbol_type (token::OVERWRITE, std::move (l));
      }
#else
      static
      symbol_type
      make_OVERWRITE (const location_type& l)
      {
        return symbol_type (token::OVERWRITE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DISCOUNT (location_type l)
      {
        return symbol_type (token::DISCOUNT, std::move (l));
      }
#else
      static
      symbol_type
      make_DISCOUNT (const location_type& l)
      {
        return symbol_type (token::DISCOUNT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PARALLEL_LOCAL_FILES (location_type l)
      {
        return symbol_type (token::PARALLEL_LOCAL_FILES, std::move (l));
      }
#else
      static
      symbol_type
      make_PARALLEL_LOCAL_FILES (const location_type& l)
      {
        return symbol_type (token::PARALLEL_LOCAL_FILES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PARAMETERS (location_type l)
      {
        return symbol_type (token::PARAMETERS, std::move (l));
      }
#else
      static
      symbol_type
      make_PARAMETERS (const location_type& l)
      {
        return symbol_type (token::PARAMETERS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PARAMETER_SET (location_type l)
      {
        return symbol_type (token::PARAMETER_SET, std::move (l));
      }
#else
      static
      symbol_type
      make_PARAMETER_SET (const location_type& l)
      {
        return symbol_type (token::PARAMETER_SET, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PARTIAL_INFORMATION (location_type l)
      {
        return symbol_type (token::PARTIAL_INFORMATION, std::move (l));
      }
#else
      static
      symbol_type
      make_PARTIAL_INFORMATION (const location_type& l)
      {
        return symbol_type (token::PARTIAL_INFORMATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PERIODS (location_type l)
      {
        return symbol_type (token::PERIODS, std::move (l));
      }
#else
      static
      symbol_type
      make_PERIODS (const location_type& l)
      {
        return symbol_type (token::PERIODS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PERIOD (location_type l)
      {
        return symbol_type (token::PERIOD, std::move (l));
      }
#else
      static
      symbol_type
      make_PERIOD (const location_type& l)
      {
        return symbol_type (token::PERIOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLANNER_OBJECTIVE (location_type l)
      {
        return symbol_type (token::PLANNER_OBJECTIVE, std::move (l));
      }
#else
      static
      symbol_type
      make_PLANNER_OBJECTIVE (const location_type& l)
      {
        return symbol_type (token::PLANNER_OBJECTIVE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLOT_CONDITIONAL_FORECAST (location_type l)
      {
        return symbol_type (token::PLOT_CONDITIONAL_FORECAST, std::move (l));
      }
#else
      static
      symbol_type
      make_PLOT_CONDITIONAL_FORECAST (const location_type& l)
      {
        return symbol_type (token::PLOT_CONDITIONAL_FORECAST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLOT_PRIORS (location_type l)
      {
        return symbol_type (token::PLOT_PRIORS, std::move (l));
      }
#else
      static
      symbol_type
      make_PLOT_PRIORS (const location_type& l)
      {
        return symbol_type (token::PLOT_PRIORS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PREFILTER (location_type l)
      {
        return symbol_type (token::PREFILTER, std::move (l));
      }
#else
      static
      symbol_type
      make_PREFILTER (const location_type& l)
      {
        return symbol_type (token::PREFILTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRESAMPLE (location_type l)
      {
        return symbol_type (token::PRESAMPLE, std::move (l));
      }
#else
      static
      symbol_type
      make_PRESAMPLE (const location_type& l)
      {
        return symbol_type (token::PRESAMPLE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PERFECT_FORESIGHT_SETUP (location_type l)
      {
        return symbol_type (token::PERFECT_FORESIGHT_SETUP, std::move (l));
      }
#else
      static
      symbol_type
      make_PERFECT_FORESIGHT_SETUP (const location_type& l)
      {
        return symbol_type (token::PERFECT_FORESIGHT_SETUP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PERFECT_FORESIGHT_SOLVER (location_type l)
      {
        return symbol_type (token::PERFECT_FORESIGHT_SOLVER, std::move (l));
      }
#else
      static
      symbol_type
      make_PERFECT_FORESIGHT_SOLVER (const location_type& l)
      {
        return symbol_type (token::PERFECT_FORESIGHT_SOLVER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_POSTERIOR_KERNEL_DENSITY (location_type l)
      {
        return symbol_type (token::NO_POSTERIOR_KERNEL_DENSITY, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_POSTERIOR_KERNEL_DENSITY (const location_type& l)
      {
        return symbol_type (token::NO_POSTERIOR_KERNEL_DENSITY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FUNCTION (location_type l)
      {
        return symbol_type (token::FUNCTION, std::move (l));
      }
#else
      static
      symbol_type
      make_FUNCTION (const location_type& l)
      {
        return symbol_type (token::FUNCTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PERFECT_FORESIGHT_WITH_EXPECTATION_ERRORS_SETUP (location_type l)
      {
        return symbol_type (token::PERFECT_FORESIGHT_WITH_EXPECTATION_ERRORS_SETUP, std::move (l));
      }
#else
      static
      symbol_type
      make_PERFECT_FORESIGHT_WITH_EXPECTATION_ERRORS_SETUP (const location_type& l)
      {
        return symbol_type (token::PERFECT_FORESIGHT_WITH_EXPECTATION_ERRORS_SETUP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PERFECT_FORESIGHT_WITH_EXPECTATION_ERRORS_SOLVER (location_type l)
      {
        return symbol_type (token::PERFECT_FORESIGHT_WITH_EXPECTATION_ERRORS_SOLVER, std::move (l));
      }
#else
      static
      symbol_type
      make_PERFECT_FORESIGHT_WITH_EXPECTATION_ERRORS_SOLVER (const location_type& l)
      {
        return symbol_type (token::PERFECT_FORESIGHT_WITH_EXPECTATION_ERRORS_SOLVER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRINT (location_type l)
      {
        return symbol_type (token::PRINT, std::move (l));
      }
#else
      static
      symbol_type
      make_PRINT (const location_type& l)
      {
        return symbol_type (token::PRINT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIOR_MC (location_type l)
      {
        return symbol_type (token::PRIOR_MC, std::move (l));
      }
#else
      static
      symbol_type
      make_PRIOR_MC (const location_type& l)
      {
        return symbol_type (token::PRIOR_MC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIOR_TRUNC (location_type l)
      {
        return symbol_type (token::PRIOR_TRUNC, std::move (l));
      }
#else
      static
      symbol_type
      make_PRIOR_TRUNC (const location_type& l)
      {
        return symbol_type (token::PRIOR_TRUNC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIOR_MODE (location_type l)
      {
        return symbol_type (token::PRIOR_MODE, std::move (l));
      }
#else
      static
      symbol_type
      make_PRIOR_MODE (const location_type& l)
      {
        return symbol_type (token::PRIOR_MODE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIOR_MEAN (location_type l)
      {
        return symbol_type (token::PRIOR_MEAN, std::move (l));
      }
#else
      static
      symbol_type
      make_PRIOR_MEAN (const location_type& l)
      {
        return symbol_type (token::PRIOR_MEAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_MODE (location_type l)
      {
        return symbol_type (token::POSTERIOR_MODE, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_MODE (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_MODE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_MEAN (location_type l)
      {
        return symbol_type (token::POSTERIOR_MEAN, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_MEAN (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_MEAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_MEDIAN (location_type l)
      {
        return symbol_type (token::POSTERIOR_MEDIAN, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_MEDIAN (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_MEDIAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MLE_MODE (location_type l)
      {
        return symbol_type (token::MLE_MODE, std::move (l));
      }
#else
      static
      symbol_type
      make_MLE_MODE (const location_type& l)
      {
        return symbol_type (token::MLE_MODE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRUNING (location_type l)
      {
        return symbol_type (token::PRUNING, std::move (l));
      }
#else
      static
      symbol_type
      make_PRUNING (const location_type& l)
      {
        return symbol_type (token::PRUNING, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PARTICLE_FILTER_OPTIONS (location_type l)
      {
        return symbol_type (token::PARTICLE_FILTER_OPTIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_PARTICLE_FILTER_OPTIONS (const location_type& l)
      {
        return symbol_type (token::PARTICLE_FILTER_OPTIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_QUOTED_STRING (string v, location_type l)
      {
        return symbol_type (token::QUOTED_STRING, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_QUOTED_STRING (const string& v, const location_type& l)
      {
        return symbol_type (token::QUOTED_STRING, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_QZ_CRITERIUM (location_type l)
      {
        return symbol_type (token::QZ_CRITERIUM, std::move (l));
      }
#else
      static
      symbol_type
      make_QZ_CRITERIUM (const location_type& l)
      {
        return symbol_type (token::QZ_CRITERIUM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_QZ_ZERO_THRESHOLD (location_type l)
      {
        return symbol_type (token::QZ_ZERO_THRESHOLD, std::move (l));
      }
#else
      static
      symbol_type
      make_QZ_ZERO_THRESHOLD (const location_type& l)
      {
        return symbol_type (token::QZ_ZERO_THRESHOLD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DSGE_VAR (location_type l)
      {
        return symbol_type (token::DSGE_VAR, std::move (l));
      }
#else
      static
      symbol_type
      make_DSGE_VAR (const location_type& l)
      {
        return symbol_type (token::DSGE_VAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DSGE_VARLAG (location_type l)
      {
        return symbol_type (token::DSGE_VARLAG, std::move (l));
      }
#else
      static
      symbol_type
      make_DSGE_VARLAG (const location_type& l)
      {
        return symbol_type (token::DSGE_VARLAG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DSGE_PRIOR_WEIGHT (location_type l)
      {
        return symbol_type (token::DSGE_PRIOR_WEIGHT, std::move (l));
      }
#else
      static
      symbol_type
      make_DSGE_PRIOR_WEIGHT (const location_type& l)
      {
        return symbol_type (token::DSGE_PRIOR_WEIGHT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TRUNCATE (location_type l)
      {
        return symbol_type (token::TRUNCATE, std::move (l));
      }
#else
      static
      symbol_type
      make_TRUNCATE (const location_type& l)
      {
        return symbol_type (token::TRUNCATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PIPE_E (location_type l)
      {
        return symbol_type (token::PIPE_E, std::move (l));
      }
#else
      static
      symbol_type
      make_PIPE_E (const location_type& l)
      {
        return symbol_type (token::PIPE_E, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PIPE_X (location_type l)
      {
        return symbol_type (token::PIPE_X, std::move (l));
      }
#else
      static
      symbol_type
      make_PIPE_X (const location_type& l)
      {
        return symbol_type (token::PIPE_X, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PIPE_P (location_type l)
      {
        return symbol_type (token::PIPE_P, std::move (l));
      }
#else
      static
      symbol_type
      make_PIPE_P (const location_type& l)
      {
        return symbol_type (token::PIPE_P, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RELATIVE_IRF (location_type l)
      {
        return symbol_type (token::RELATIVE_IRF, std::move (l));
      }
#else
      static
      symbol_type
      make_RELATIVE_IRF (const location_type& l)
      {
        return symbol_type (token::RELATIVE_IRF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REPLIC (location_type l)
      {
        return symbol_type (token::REPLIC, std::move (l));
      }
#else
      static
      symbol_type
      make_REPLIC (const location_type& l)
      {
        return symbol_type (token::REPLIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMUL_REPLIC (location_type l)
      {
        return symbol_type (token::SIMUL_REPLIC, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMUL_REPLIC (const location_type& l)
      {
        return symbol_type (token::SIMUL_REPLIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RPLOT (location_type l)
      {
        return symbol_type (token::RPLOT, std::move (l));
      }
#else
      static
      symbol_type
      make_RPLOT (const location_type& l)
      {
        return symbol_type (token::RPLOT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SAVE_PARAMS_AND_STEADY_STATE (location_type l)
      {
        return symbol_type (token::SAVE_PARAMS_AND_STEADY_STATE, std::move (l));
      }
#else
      static
      symbol_type
      make_SAVE_PARAMS_AND_STEADY_STATE (const location_type& l)
      {
        return symbol_type (token::SAVE_PARAMS_AND_STEADY_STATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PARAMETER_UNCERTAINTY (location_type l)
      {
        return symbol_type (token::PARAMETER_UNCERTAINTY, std::move (l));
      }
#else
      static
      symbol_type
      make_PARAMETER_UNCERTAINTY (const location_type& l)
      {
        return symbol_type (token::PARAMETER_UNCERTAINTY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TARGETS (location_type l)
      {
        return symbol_type (token::TARGETS, std::move (l));
      }
#else
      static
      symbol_type
      make_TARGETS (const location_type& l)
      {
        return symbol_type (token::TARGETS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHOCKS (location_type l)
      {
        return symbol_type (token::SHOCKS, std::move (l));
      }
#else
      static
      symbol_type
      make_SHOCKS (const location_type& l)
      {
        return symbol_type (token::SHOCKS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HETEROSKEDASTIC_SHOCKS (location_type l)
      {
        return symbol_type (token::HETEROSKEDASTIC_SHOCKS, std::move (l));
      }
#else
      static
      symbol_type
      make_HETEROSKEDASTIC_SHOCKS (const location_type& l)
      {
        return symbol_type (token::HETEROSKEDASTIC_SHOCKS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHOCK_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::SHOCK_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_SHOCK_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::SHOCK_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHOCK_GROUPS (location_type l)
      {
        return symbol_type (token::SHOCK_GROUPS, std::move (l));
      }
#else
      static
      symbol_type
      make_SHOCK_GROUPS (const location_type& l)
      {
        return symbol_type (token::SHOCK_GROUPS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_USE_SHOCK_GROUPS (location_type l)
      {
        return symbol_type (token::USE_SHOCK_GROUPS, std::move (l));
      }
#else
      static
      symbol_type
      make_USE_SHOCK_GROUPS (const location_type& l)
      {
        return symbol_type (token::USE_SHOCK_GROUPS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIGMA_E (location_type l)
      {
        return symbol_type (token::SIGMA_E, std::move (l));
      }
#else
      static
      symbol_type
      make_SIGMA_E (const location_type& l)
      {
        return symbol_type (token::SIGMA_E, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMUL (location_type l)
      {
        return symbol_type (token::SIMUL, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMUL (const location_type& l)
      {
        return symbol_type (token::SIMUL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMUL_ALGO (location_type l)
      {
        return symbol_type (token::SIMUL_ALGO, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMUL_ALGO (const location_type& l)
      {
        return symbol_type (token::SIMUL_ALGO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMUL_SEED (location_type l)
      {
        return symbol_type (token::SIMUL_SEED, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMUL_SEED (const location_type& l)
      {
        return symbol_type (token::SIMUL_SEED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ENDOGENOUS_TERMINAL_PERIOD (location_type l)
      {
        return symbol_type (token::ENDOGENOUS_TERMINAL_PERIOD, std::move (l));
      }
#else
      static
      symbol_type
      make_ENDOGENOUS_TERMINAL_PERIOD (const location_type& l)
      {
        return symbol_type (token::ENDOGENOUS_TERMINAL_PERIOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMOOTHER (location_type l)
      {
        return symbol_type (token::SMOOTHER, std::move (l));
      }
#else
      static
      symbol_type
      make_SMOOTHER (const location_type& l)
      {
        return symbol_type (token::SMOOTHER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMOOTHER2HISTVAL (location_type l)
      {
        return symbol_type (token::SMOOTHER2HISTVAL, std::move (l));
      }
#else
      static
      symbol_type
      make_SMOOTHER2HISTVAL (const location_type& l)
      {
        return symbol_type (token::SMOOTHER2HISTVAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SQUARE_ROOT_SOLVER (location_type l)
      {
        return symbol_type (token::SQUARE_ROOT_SOLVER, std::move (l));
      }
#else
      static
      symbol_type
      make_SQUARE_ROOT_SOLVER (const location_type& l)
      {
        return symbol_type (token::SQUARE_ROOT_SOLVER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STACK_SOLVE_ALGO (location_type l)
      {
        return symbol_type (token::STACK_SOLVE_ALGO, std::move (l));
      }
#else
      static
      symbol_type
      make_STACK_SOLVE_ALGO (const location_type& l)
      {
        return symbol_type (token::STACK_SOLVE_ALGO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STEADY_STATE_MODEL (location_type l)
      {
        return symbol_type (token::STEADY_STATE_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_STEADY_STATE_MODEL (const location_type& l)
      {
        return symbol_type (token::STEADY_STATE_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SOLVE_ALGO (location_type l)
      {
        return symbol_type (token::SOLVE_ALGO, std::move (l));
      }
#else
      static
      symbol_type
      make_SOLVE_ALGO (const location_type& l)
      {
        return symbol_type (token::SOLVE_ALGO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SOLVER_PERIODS (location_type l)
      {
        return symbol_type (token::SOLVER_PERIODS, std::move (l));
      }
#else
      static
      symbol_type
      make_SOLVER_PERIODS (const location_type& l)
      {
        return symbol_type (token::SOLVER_PERIODS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ROBUST_LIN_SOLVE (location_type l)
      {
        return symbol_type (token::ROBUST_LIN_SOLVE, std::move (l));
      }
#else
      static
      symbol_type
      make_ROBUST_LIN_SOLVE (const location_type& l)
      {
        return symbol_type (token::ROBUST_LIN_SOLVE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STDERR (location_type l)
      {
        return symbol_type (token::STDERR, std::move (l));
      }
#else
      static
      symbol_type
      make_STDERR (const location_type& l)
      {
        return symbol_type (token::STDERR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STEADY (location_type l)
      {
        return symbol_type (token::STEADY, std::move (l));
      }
#else
      static
      symbol_type
      make_STEADY (const location_type& l)
      {
        return symbol_type (token::STEADY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STOCH_SIMUL (location_type l)
      {
        return symbol_type (token::STOCH_SIMUL, std::move (l));
      }
#else
      static
      symbol_type
      make_STOCH_SIMUL (const location_type& l)
      {
        return symbol_type (token::STOCH_SIMUL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SYLVESTER (location_type l)
      {
        return symbol_type (token::SYLVESTER, std::move (l));
      }
#else
      static
      symbol_type
      make_SYLVESTER (const location_type& l)
      {
        return symbol_type (token::SYLVESTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SYLVESTER_FIXED_POINT_TOL (location_type l)
      {
        return symbol_type (token::SYLVESTER_FIXED_POINT_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_SYLVESTER_FIXED_POINT_TOL (const location_type& l)
      {
        return symbol_type (token::SYLVESTER_FIXED_POINT_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REGIMES (location_type l)
      {
        return symbol_type (token::REGIMES, std::move (l));
      }
#else
      static
      symbol_type
      make_REGIMES (const location_type& l)
      {
        return symbol_type (token::REGIMES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REGIME (location_type l)
      {
        return symbol_type (token::REGIME, std::move (l));
      }
#else
      static
      symbol_type
      make_REGIME (const location_type& l)
      {
        return symbol_type (token::REGIME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REALTIME_SHOCK_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::REALTIME_SHOCK_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_REALTIME_SHOCK_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::REALTIME_SHOCK_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONDITIONAL (location_type l)
      {
        return symbol_type (token::CONDITIONAL, std::move (l));
      }
#else
      static
      symbol_type
      make_CONDITIONAL (const location_type& l)
      {
        return symbol_type (token::CONDITIONAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNCONDITIONAL (location_type l)
      {
        return symbol_type (token::UNCONDITIONAL, std::move (l));
      }
#else
      static
      symbol_type
      make_UNCONDITIONAL (const location_type& l)
      {
        return symbol_type (token::UNCONDITIONAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TEX (location_type l)
      {
        return symbol_type (token::TEX, std::move (l));
      }
#else
      static
      symbol_type
      make_TEX (const location_type& l)
      {
        return symbol_type (token::TEX, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RAMSEY_MODEL (location_type l)
      {
        return symbol_type (token::RAMSEY_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_RAMSEY_MODEL (const location_type& l)
      {
        return symbol_type (token::RAMSEY_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RAMSEY_POLICY (location_type l)
      {
        return symbol_type (token::RAMSEY_POLICY, std::move (l));
      }
#else
      static
      symbol_type
      make_RAMSEY_POLICY (const location_type& l)
      {
        return symbol_type (token::RAMSEY_POLICY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RAMSEY_CONSTRAINTS (location_type l)
      {
        return symbol_type (token::RAMSEY_CONSTRAINTS, std::move (l));
      }
#else
      static
      symbol_type
      make_RAMSEY_CONSTRAINTS (const location_type& l)
      {
        return symbol_type (token::RAMSEY_CONSTRAINTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLANNER_DISCOUNT (location_type l)
      {
        return symbol_type (token::PLANNER_DISCOUNT, std::move (l));
      }
#else
      static
      symbol_type
      make_PLANNER_DISCOUNT (const location_type& l)
      {
        return symbol_type (token::PLANNER_DISCOUNT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLANNER_DISCOUNT_LATEX_NAME (location_type l)
      {
        return symbol_type (token::PLANNER_DISCOUNT_LATEX_NAME, std::move (l));
      }
#else
      static
      symbol_type
      make_PLANNER_DISCOUNT_LATEX_NAME (const location_type& l)
      {
        return symbol_type (token::PLANNER_DISCOUNT_LATEX_NAME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DISCRETIONARY_POLICY (location_type l)
      {
        return symbol_type (token::DISCRETIONARY_POLICY, std::move (l));
      }
#else
      static
      symbol_type
      make_DISCRETIONARY_POLICY (const location_type& l)
      {
        return symbol_type (token::DISCRETIONARY_POLICY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DISCRETIONARY_TOL (location_type l)
      {
        return symbol_type (token::DISCRETIONARY_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_DISCRETIONARY_TOL (const location_type& l)
      {
        return symbol_type (token::DISCRETIONARY_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EVALUATE_PLANNER_OBJECTIVE (location_type l)
      {
        return symbol_type (token::EVALUATE_PLANNER_OBJECTIVE, std::move (l));
      }
#else
      static
      symbol_type
      make_EVALUATE_PLANNER_OBJECTIVE (const location_type& l)
      {
        return symbol_type (token::EVALUATE_PLANNER_OBJECTIVE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OCCBIN_SETUP (location_type l)
      {
        return symbol_type (token::OCCBIN_SETUP, std::move (l));
      }
#else
      static
      symbol_type
      make_OCCBIN_SETUP (const location_type& l)
      {
        return symbol_type (token::OCCBIN_SETUP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OCCBIN_SOLVER (location_type l)
      {
        return symbol_type (token::OCCBIN_SOLVER, std::move (l));
      }
#else
      static
      symbol_type
      make_OCCBIN_SOLVER (const location_type& l)
      {
        return symbol_type (token::OCCBIN_SOLVER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OCCBIN_WRITE_REGIMES (location_type l)
      {
        return symbol_type (token::OCCBIN_WRITE_REGIMES, std::move (l));
      }
#else
      static
      symbol_type
      make_OCCBIN_WRITE_REGIMES (const location_type& l)
      {
        return symbol_type (token::OCCBIN_WRITE_REGIMES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OCCBIN_GRAPH (location_type l)
      {
        return symbol_type (token::OCCBIN_GRAPH, std::move (l));
      }
#else
      static
      symbol_type
      make_OCCBIN_GRAPH (const location_type& l)
      {
        return symbol_type (token::OCCBIN_GRAPH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMUL_MAXIT (location_type l)
      {
        return symbol_type (token::SIMUL_MAXIT, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMUL_MAXIT (const location_type& l)
      {
        return symbol_type (token::SIMUL_MAXIT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIKELIHOOD_MAXIT (location_type l)
      {
        return symbol_type (token::LIKELIHOOD_MAXIT, std::move (l));
      }
#else
      static
      symbol_type
      make_LIKELIHOOD_MAXIT (const location_type& l)
      {
        return symbol_type (token::LIKELIHOOD_MAXIT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMOOTHER_MAXIT (location_type l)
      {
        return symbol_type (token::SMOOTHER_MAXIT, std::move (l));
      }
#else
      static
      symbol_type
      make_SMOOTHER_MAXIT (const location_type& l)
      {
        return symbol_type (token::SMOOTHER_MAXIT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMUL_PERIODS (location_type l)
      {
        return symbol_type (token::SIMUL_PERIODS, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMUL_PERIODS (const location_type& l)
      {
        return symbol_type (token::SIMUL_PERIODS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIKELIHOOD_PERIODS (location_type l)
      {
        return symbol_type (token::LIKELIHOOD_PERIODS, std::move (l));
      }
#else
      static
      symbol_type
      make_LIKELIHOOD_PERIODS (const location_type& l)
      {
        return symbol_type (token::LIKELIHOOD_PERIODS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMOOTHER_PERIODS (location_type l)
      {
        return symbol_type (token::SMOOTHER_PERIODS, std::move (l));
      }
#else
      static
      symbol_type
      make_SMOOTHER_PERIODS (const location_type& l)
      {
        return symbol_type (token::SMOOTHER_PERIODS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMUL_CURB_RETRENCH (location_type l)
      {
        return symbol_type (token::SIMUL_CURB_RETRENCH, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMUL_CURB_RETRENCH (const location_type& l)
      {
        return symbol_type (token::SIMUL_CURB_RETRENCH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIKELIHOOD_CURB_RETRENCH (location_type l)
      {
        return symbol_type (token::LIKELIHOOD_CURB_RETRENCH, std::move (l));
      }
#else
      static
      symbol_type
      make_LIKELIHOOD_CURB_RETRENCH (const location_type& l)
      {
        return symbol_type (token::LIKELIHOOD_CURB_RETRENCH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMOOTHER_CURB_RETRENCH (location_type l)
      {
        return symbol_type (token::SMOOTHER_CURB_RETRENCH, std::move (l));
      }
#else
      static
      symbol_type
      make_SMOOTHER_CURB_RETRENCH (const location_type& l)
      {
        return symbol_type (token::SMOOTHER_CURB_RETRENCH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMUL_CHECK_AHEAD_PERIODS (location_type l)
      {
        return symbol_type (token::SIMUL_CHECK_AHEAD_PERIODS, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMUL_CHECK_AHEAD_PERIODS (const location_type& l)
      {
        return symbol_type (token::SIMUL_CHECK_AHEAD_PERIODS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIKELIHOOD_CHECK_AHEAD_PERIODS (location_type l)
      {
        return symbol_type (token::LIKELIHOOD_CHECK_AHEAD_PERIODS, std::move (l));
      }
#else
      static
      symbol_type
      make_LIKELIHOOD_CHECK_AHEAD_PERIODS (const location_type& l)
      {
        return symbol_type (token::LIKELIHOOD_CHECK_AHEAD_PERIODS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMOOTHER_CHECK_AHEAD_PERIODS (location_type l)
      {
        return symbol_type (token::SMOOTHER_CHECK_AHEAD_PERIODS, std::move (l));
      }
#else
      static
      symbol_type
      make_SMOOTHER_CHECK_AHEAD_PERIODS (const location_type& l)
      {
        return symbol_type (token::SMOOTHER_CHECK_AHEAD_PERIODS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMUL_DEBUG (location_type l)
      {
        return symbol_type (token::SIMUL_DEBUG, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMUL_DEBUG (const location_type& l)
      {
        return symbol_type (token::SIMUL_DEBUG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMOOTHER_DEBUG (location_type l)
      {
        return symbol_type (token::SMOOTHER_DEBUG, std::move (l));
      }
#else
      static
      symbol_type
      make_SMOOTHER_DEBUG (const location_type& l)
      {
        return symbol_type (token::SMOOTHER_DEBUG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMUL_PERIODIC_SOLUTION (location_type l)
      {
        return symbol_type (token::SIMUL_PERIODIC_SOLUTION, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMUL_PERIODIC_SOLUTION (const location_type& l)
      {
        return symbol_type (token::SIMUL_PERIODIC_SOLUTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIKELIHOOD_PERIODIC_SOLUTION (location_type l)
      {
        return symbol_type (token::LIKELIHOOD_PERIODIC_SOLUTION, std::move (l));
      }
#else
      static
      symbol_type
      make_LIKELIHOOD_PERIODIC_SOLUTION (const location_type& l)
      {
        return symbol_type (token::LIKELIHOOD_PERIODIC_SOLUTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMOOTHER_PERIODIC_SOLUTION (location_type l)
      {
        return symbol_type (token::SMOOTHER_PERIODIC_SOLUTION, std::move (l));
      }
#else
      static
      symbol_type
      make_SMOOTHER_PERIODIC_SOLUTION (const location_type& l)
      {
        return symbol_type (token::SMOOTHER_PERIODIC_SOLUTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIKELIHOOD_INVERSION_FILTER (location_type l)
      {
        return symbol_type (token::LIKELIHOOD_INVERSION_FILTER, std::move (l));
      }
#else
      static
      symbol_type
      make_LIKELIHOOD_INVERSION_FILTER (const location_type& l)
      {
        return symbol_type (token::LIKELIHOOD_INVERSION_FILTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMOOTHER_INVERSION_FILTER (location_type l)
      {
        return symbol_type (token::SMOOTHER_INVERSION_FILTER, std::move (l));
      }
#else
      static
      symbol_type
      make_SMOOTHER_INVERSION_FILTER (const location_type& l)
      {
        return symbol_type (token::SMOOTHER_INVERSION_FILTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILTER_USE_RELEXATION (location_type l)
      {
        return symbol_type (token::FILTER_USE_RELEXATION, std::move (l));
      }
#else
      static
      symbol_type
      make_FILTER_USE_RELEXATION (const location_type& l)
      {
        return symbol_type (token::FILTER_USE_RELEXATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIKELIHOOD_PIECEWISE_KALMAN_FILTER (location_type l)
      {
        return symbol_type (token::LIKELIHOOD_PIECEWISE_KALMAN_FILTER, std::move (l));
      }
#else
      static
      symbol_type
      make_LIKELIHOOD_PIECEWISE_KALMAN_FILTER (const location_type& l)
      {
        return symbol_type (token::LIKELIHOOD_PIECEWISE_KALMAN_FILTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMOOTHER_PIECEWISE_KALMAN_FILTER (location_type l)
      {
        return symbol_type (token::SMOOTHER_PIECEWISE_KALMAN_FILTER, std::move (l));
      }
#else
      static
      symbol_type
      make_SMOOTHER_PIECEWISE_KALMAN_FILTER (const location_type& l)
      {
        return symbol_type (token::SMOOTHER_PIECEWISE_KALMAN_FILTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIKELIHOOD_MAX_KALMAN_ITERATIONS (location_type l)
      {
        return symbol_type (token::LIKELIHOOD_MAX_KALMAN_ITERATIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_LIKELIHOOD_MAX_KALMAN_ITERATIONS (const location_type& l)
      {
        return symbol_type (token::LIKELIHOOD_MAX_KALMAN_ITERATIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TEX_NAME (string v, location_type l)
      {
        return symbol_type (token::TEX_NAME, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_TEX_NAME (const string& v, const location_type& l)
      {
        return symbol_type (token::TEX_NAME, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TRUE (string v, location_type l)
      {
        return symbol_type (token::TRUE, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_TRUE (const string& v, const location_type& l)
      {
        return symbol_type (token::TRUE, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BIND (string v, location_type l)
      {
        return symbol_type (token::BIND, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_BIND (const string& v, const location_type& l)
      {
        return symbol_type (token::BIND, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RELAX (string v, location_type l)
      {
        return symbol_type (token::RELAX, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_RELAX (const string& v, const location_type& l)
      {
        return symbol_type (token::RELAX, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ERROR_BIND (string v, location_type l)
      {
        return symbol_type (token::ERROR_BIND, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_ERROR_BIND (const string& v, const location_type& l)
      {
        return symbol_type (token::ERROR_BIND, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ERROR_RELAX (string v, location_type l)
      {
        return symbol_type (token::ERROR_RELAX, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_ERROR_RELAX (const string& v, const location_type& l)
      {
        return symbol_type (token::ERROR_RELAX, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNIFORM_PDF (location_type l)
      {
        return symbol_type (token::UNIFORM_PDF, std::move (l));
      }
#else
      static
      symbol_type
      make_UNIFORM_PDF (const location_type& l)
      {
        return symbol_type (token::UNIFORM_PDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNIT_ROOT_VARS (location_type l)
      {
        return symbol_type (token::UNIT_ROOT_VARS, std::move (l));
      }
#else
      static
      symbol_type
      make_UNIT_ROOT_VARS (const location_type& l)
      {
        return symbol_type (token::UNIT_ROOT_VARS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_USE_DLL (location_type l)
      {
        return symbol_type (token::USE_DLL, std::move (l));
      }
#else
      static
      symbol_type
      make_USE_DLL (const location_type& l)
      {
        return symbol_type (token::USE_DLL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_USEAUTOCORR (location_type l)
      {
        return symbol_type (token::USEAUTOCORR, std::move (l));
      }
#else
      static
      symbol_type
      make_USEAUTOCORR (const location_type& l)
      {
        return symbol_type (token::USEAUTOCORR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GSA_SAMPLE_FILE (location_type l)
      {
        return symbol_type (token::GSA_SAMPLE_FILE, std::move (l));
      }
#else
      static
      symbol_type
      make_GSA_SAMPLE_FILE (const location_type& l)
      {
        return symbol_type (token::GSA_SAMPLE_FILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_USE_UNIVARIATE_FILTERS_IF_SINGULARITY_IS_DETECTED (location_type l)
      {
        return symbol_type (token::USE_UNIVARIATE_FILTERS_IF_SINGULARITY_IS_DETECTED, std::move (l));
      }
#else
      static
      symbol_type
      make_USE_UNIVARIATE_FILTERS_IF_SINGULARITY_IS_DETECTED (const location_type& l)
      {
        return symbol_type (token::USE_UNIVARIATE_FILTERS_IF_SINGULARITY_IS_DETECTED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VALUES (location_type l)
      {
        return symbol_type (token::VALUES, std::move (l));
      }
#else
      static
      symbol_type
      make_VALUES (const location_type& l)
      {
        return symbol_type (token::VALUES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SCALES (location_type l)
      {
        return symbol_type (token::SCALES, std::move (l));
      }
#else
      static
      symbol_type
      make_SCALES (const location_type& l)
      {
        return symbol_type (token::SCALES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAR (location_type l)
      {
        return symbol_type (token::VAR, std::move (l));
      }
#else
      static
      symbol_type
      make_VAR (const location_type& l)
      {
        return symbol_type (token::VAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAREXO (location_type l)
      {
        return symbol_type (token::VAREXO, std::move (l));
      }
#else
      static
      symbol_type
      make_VAREXO (const location_type& l)
      {
        return symbol_type (token::VAREXO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAREXO_DET (location_type l)
      {
        return symbol_type (token::VAREXO_DET, std::move (l));
      }
#else
      static
      symbol_type
      make_VAREXO_DET (const location_type& l)
      {
        return symbol_type (token::VAREXO_DET, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VARIABLE (location_type l)
      {
        return symbol_type (token::VARIABLE, std::move (l));
      }
#else
      static
      symbol_type
      make_VARIABLE (const location_type& l)
      {
        return symbol_type (token::VARIABLE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAROBS (location_type l)
      {
        return symbol_type (token::VAROBS, std::move (l));
      }
#else
      static
      symbol_type
      make_VAROBS (const location_type& l)
      {
        return symbol_type (token::VAROBS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAREXOBS (location_type l)
      {
        return symbol_type (token::VAREXOBS, std::move (l));
      }
#else
      static
      symbol_type
      make_VAREXOBS (const location_type& l)
      {
        return symbol_type (token::VAREXOBS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PREDETERMINED_VARIABLES (location_type l)
      {
        return symbol_type (token::PREDETERMINED_VARIABLES, std::move (l));
      }
#else
      static
      symbol_type
      make_PREDETERMINED_VARIABLES (const location_type& l)
      {
        return symbol_type (token::PREDETERMINED_VARIABLES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAR_EXPECTATION (location_type l)
      {
        return symbol_type (token::VAR_EXPECTATION, std::move (l));
      }
#else
      static
      symbol_type
      make_VAR_EXPECTATION (const location_type& l)
      {
        return symbol_type (token::VAR_EXPECTATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAR_EXPECTATION_MODEL (location_type l)
      {
        return symbol_type (token::VAR_EXPECTATION_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_VAR_EXPECTATION_MODEL (const location_type& l)
      {
        return symbol_type (token::VAR_EXPECTATION_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLOT_SHOCK_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::PLOT_SHOCK_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_PLOT_SHOCK_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::PLOT_SHOCK_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODEL_LOCAL_VARIABLE (location_type l)
      {
        return symbol_type (token::MODEL_LOCAL_VARIABLE, std::move (l));
      }
#else
      static
      symbol_type
      make_MODEL_LOCAL_VARIABLE (const location_type& l)
      {
        return symbol_type (token::MODEL_LOCAL_VARIABLE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WRITE_LATEX_DYNAMIC_MODEL (location_type l)
      {
        return symbol_type (token::WRITE_LATEX_DYNAMIC_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_WRITE_LATEX_DYNAMIC_MODEL (const location_type& l)
      {
        return symbol_type (token::WRITE_LATEX_DYNAMIC_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WRITE_LATEX_STATIC_MODEL (location_type l)
      {
        return symbol_type (token::WRITE_LATEX_STATIC_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_WRITE_LATEX_STATIC_MODEL (const location_type& l)
      {
        return symbol_type (token::WRITE_LATEX_STATIC_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WRITE_LATEX_ORIGINAL_MODEL (location_type l)
      {
        return symbol_type (token::WRITE_LATEX_ORIGINAL_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_WRITE_LATEX_ORIGINAL_MODEL (const location_type& l)
      {
        return symbol_type (token::WRITE_LATEX_ORIGINAL_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WRITE_LATEX_STEADY_STATE_MODEL (location_type l)
      {
        return symbol_type (token::WRITE_LATEX_STEADY_STATE_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_WRITE_LATEX_STEADY_STATE_MODEL (const location_type& l)
      {
        return symbol_type (token::WRITE_LATEX_STEADY_STATE_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_XLS_SHEET (location_type l)
      {
        return symbol_type (token::XLS_SHEET, std::move (l));
      }
#else
      static
      symbol_type
      make_XLS_SHEET (const location_type& l)
      {
        return symbol_type (token::XLS_SHEET, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_XLS_RANGE (location_type l)
      {
        return symbol_type (token::XLS_RANGE, std::move (l));
      }
#else
      static
      symbol_type
      make_XLS_RANGE (const location_type& l)
      {
        return symbol_type (token::XLS_RANGE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LMMCP (location_type l)
      {
        return symbol_type (token::LMMCP, std::move (l));
      }
#else
      static
      symbol_type
      make_LMMCP (const location_type& l)
      {
        return symbol_type (token::LMMCP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BANDPASS_FILTER (location_type l)
      {
        return symbol_type (token::BANDPASS_FILTER, std::move (l));
      }
#else
      static
      symbol_type
      make_BANDPASS_FILTER (const location_type& l)
      {
        return symbol_type (token::BANDPASS_FILTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COLORMAP (location_type l)
      {
        return symbol_type (token::COLORMAP, std::move (l));
      }
#else
      static
      symbol_type
      make_COLORMAP (const location_type& l)
      {
        return symbol_type (token::COLORMAP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAR_MODEL (location_type l)
      {
        return symbol_type (token::VAR_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_VAR_MODEL (const location_type& l)
      {
        return symbol_type (token::VAR_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PAC_MODEL (location_type l)
      {
        return symbol_type (token::PAC_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_PAC_MODEL (const location_type& l)
      {
        return symbol_type (token::PAC_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_QOQ (location_type l)
      {
        return symbol_type (token::QOQ, std::move (l));
      }
#else
      static
      symbol_type
      make_QOQ (const location_type& l)
      {
        return symbol_type (token::QOQ, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_YOY (location_type l)
      {
        return symbol_type (token::YOY, std::move (l));
      }
#else
      static
      symbol_type
      make_YOY (const location_type& l)
      {
        return symbol_type (token::YOY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AOA (location_type l)
      {
        return symbol_type (token::AOA, std::move (l));
      }
#else
      static
      symbol_type
      make_AOA (const location_type& l)
      {
        return symbol_type (token::AOA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PAC_EXPECTATION (location_type l)
      {
        return symbol_type (token::PAC_EXPECTATION, std::move (l));
      }
#else
      static
      symbol_type
      make_PAC_EXPECTATION (const location_type& l)
      {
        return symbol_type (token::PAC_EXPECTATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TREND_COMPONENT_MODEL (location_type l)
      {
        return symbol_type (token::TREND_COMPONENT_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_TREND_COMPONENT_MODEL (const location_type& l)
      {
        return symbol_type (token::TREND_COMPONENT_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQUAL_EQUAL (location_type l)
      {
        return symbol_type (token::EQUAL_EQUAL, std::move (l));
      }
#else
      static
      symbol_type
      make_EQUAL_EQUAL (const location_type& l)
      {
        return symbol_type (token::EQUAL_EQUAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXCLAMATION_EQUAL (location_type l)
      {
        return symbol_type (token::EXCLAMATION_EQUAL, std::move (l));
      }
#else
      static
      symbol_type
      make_EXCLAMATION_EQUAL (const location_type& l)
      {
        return symbol_type (token::EXCLAMATION_EQUAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LESS (location_type l)
      {
        return symbol_type (token::LESS, std::move (l));
      }
#else
      static
      symbol_type
      make_LESS (const location_type& l)
      {
        return symbol_type (token::LESS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GREATER (location_type l)
      {
        return symbol_type (token::GREATER, std::move (l));
      }
#else
      static
      symbol_type
      make_GREATER (const location_type& l)
      {
        return symbol_type (token::GREATER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LESS_EQUAL (location_type l)
      {
        return symbol_type (token::LESS_EQUAL, std::move (l));
      }
#else
      static
      symbol_type
      make_LESS_EQUAL (const location_type& l)
      {
        return symbol_type (token::LESS_EQUAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GREATER_EQUAL (location_type l)
      {
        return symbol_type (token::GREATER_EQUAL, std::move (l));
      }
#else
      static
      symbol_type
      make_GREATER_EQUAL (const location_type& l)
      {
        return symbol_type (token::GREATER_EQUAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLUS (location_type l)
      {
        return symbol_type (token::PLUS, std::move (l));
      }
#else
      static
      symbol_type
      make_PLUS (const location_type& l)
      {
        return symbol_type (token::PLUS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MINUS (location_type l)
      {
        return symbol_type (token::MINUS, std::move (l));
      }
#else
      static
      symbol_type
      make_MINUS (const location_type& l)
      {
        return symbol_type (token::MINUS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TIMES (location_type l)
      {
        return symbol_type (token::TIMES, std::move (l));
      }
#else
      static
      symbol_type
      make_TIMES (const location_type& l)
      {
        return symbol_type (token::TIMES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIVIDE (location_type l)
      {
        return symbol_type (token::DIVIDE, std::move (l));
      }
#else
      static
      symbol_type
      make_DIVIDE (const location_type& l)
      {
        return symbol_type (token::DIVIDE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNARY (location_type l)
      {
        return symbol_type (token::UNARY, std::move (l));
      }
#else
      static
      symbol_type
      make_UNARY (const location_type& l)
      {
        return symbol_type (token::UNARY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POWER (location_type l)
      {
        return symbol_type (token::POWER, std::move (l));
      }
#else
      static
      symbol_type
      make_POWER (const location_type& l)
      {
        return symbol_type (token::POWER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXP (location_type l)
      {
        return symbol_type (token::EXP, std::move (l));
      }
#else
      static
      symbol_type
      make_EXP (const location_type& l)
      {
        return symbol_type (token::EXP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOG (location_type l)
      {
        return symbol_type (token::LOG, std::move (l));
      }
#else
      static
      symbol_type
      make_LOG (const location_type& l)
      {
        return symbol_type (token::LOG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LN (location_type l)
      {
        return symbol_type (token::LN, std::move (l));
      }
#else
      static
      symbol_type
      make_LN (const location_type& l)
      {
        return symbol_type (token::LN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOG10 (location_type l)
      {
        return symbol_type (token::LOG10, std::move (l));
      }
#else
      static
      symbol_type
      make_LOG10 (const location_type& l)
      {
        return symbol_type (token::LOG10, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIN (location_type l)
      {
        return symbol_type (token::SIN, std::move (l));
      }
#else
      static
      symbol_type
      make_SIN (const location_type& l)
      {
        return symbol_type (token::SIN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COS (location_type l)
      {
        return symbol_type (token::COS, std::move (l));
      }
#else
      static
      symbol_type
      make_COS (const location_type& l)
      {
        return symbol_type (token::COS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TAN (location_type l)
      {
        return symbol_type (token::TAN, std::move (l));
      }
#else
      static
      symbol_type
      make_TAN (const location_type& l)
      {
        return symbol_type (token::TAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ASIN (location_type l)
      {
        return symbol_type (token::ASIN, std::move (l));
      }
#else
      static
      symbol_type
      make_ASIN (const location_type& l)
      {
        return symbol_type (token::ASIN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ACOS (location_type l)
      {
        return symbol_type (token::ACOS, std::move (l));
      }
#else
      static
      symbol_type
      make_ACOS (const location_type& l)
      {
        return symbol_type (token::ACOS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ATAN (location_type l)
      {
        return symbol_type (token::ATAN, std::move (l));
      }
#else
      static
      symbol_type
      make_ATAN (const location_type& l)
      {
        return symbol_type (token::ATAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ERF (location_type l)
      {
        return symbol_type (token::ERF, std::move (l));
      }
#else
      static
      symbol_type
      make_ERF (const location_type& l)
      {
        return symbol_type (token::ERF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIFF (location_type l)
      {
        return symbol_type (token::DIFF, std::move (l));
      }
#else
      static
      symbol_type
      make_DIFF (const location_type& l)
      {
        return symbol_type (token::DIFF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ADL (location_type l)
      {
        return symbol_type (token::ADL, std::move (l));
      }
#else
      static
      symbol_type
      make_ADL (const location_type& l)
      {
        return symbol_type (token::ADL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AUXILIARY_MODEL_NAME (location_type l)
      {
        return symbol_type (token::AUXILIARY_MODEL_NAME, std::move (l));
      }
#else
      static
      symbol_type
      make_AUXILIARY_MODEL_NAME (const location_type& l)
      {
        return symbol_type (token::AUXILIARY_MODEL_NAME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SQRT (location_type l)
      {
        return symbol_type (token::SQRT, std::move (l));
      }
#else
      static
      symbol_type
      make_SQRT (const location_type& l)
      {
        return symbol_type (token::SQRT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CBRT (location_type l)
      {
        return symbol_type (token::CBRT, std::move (l));
      }
#else
      static
      symbol_type
      make_CBRT (const location_type& l)
      {
        return symbol_type (token::CBRT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NORMCDF (location_type l)
      {
        return symbol_type (token::NORMCDF, std::move (l));
      }
#else
      static
      symbol_type
      make_NORMCDF (const location_type& l)
      {
        return symbol_type (token::NORMCDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NORMPDF (location_type l)
      {
        return symbol_type (token::NORMPDF, std::move (l));
      }
#else
      static
      symbol_type
      make_NORMPDF (const location_type& l)
      {
        return symbol_type (token::NORMPDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STEADY_STATE (location_type l)
      {
        return symbol_type (token::STEADY_STATE, std::move (l));
      }
#else
      static
      symbol_type
      make_STEADY_STATE (const location_type& l)
      {
        return symbol_type (token::STEADY_STATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXPECTATION (location_type l)
      {
        return symbol_type (token::EXPECTATION, std::move (l));
      }
#else
      static
      symbol_type
      make_EXPECTATION (const location_type& l)
      {
        return symbol_type (token::EXPECTATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DYNARE_SENSITIVITY (location_type l)
      {
        return symbol_type (token::DYNARE_SENSITIVITY, std::move (l));
      }
#else
      static
      symbol_type
      make_DYNARE_SENSITIVITY (const location_type& l)
      {
        return symbol_type (token::DYNARE_SENSITIVITY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MORRIS (location_type l)
      {
        return symbol_type (token::MORRIS, std::move (l));
      }
#else
      static
      symbol_type
      make_MORRIS (const location_type& l)
      {
        return symbol_type (token::MORRIS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STAB (location_type l)
      {
        return symbol_type (token::STAB, std::move (l));
      }
#else
      static
      symbol_type
      make_STAB (const location_type& l)
      {
        return symbol_type (token::STAB, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REDFORM (location_type l)
      {
        return symbol_type (token::REDFORM, std::move (l));
      }
#else
      static
      symbol_type
      make_REDFORM (const location_type& l)
      {
        return symbol_type (token::REDFORM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PPRIOR (location_type l)
      {
        return symbol_type (token::PPRIOR, std::move (l));
      }
#else
      static
      symbol_type
      make_PPRIOR (const location_type& l)
      {
        return symbol_type (token::PPRIOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIOR_RANGE (location_type l)
      {
        return symbol_type (token::PRIOR_RANGE, std::move (l));
      }
#else
      static
      symbol_type
      make_PRIOR_RANGE (const location_type& l)
      {
        return symbol_type (token::PRIOR_RANGE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PPOST (location_type l)
      {
        return symbol_type (token::PPOST, std::move (l));
      }
#else
      static
      symbol_type
      make_PPOST (const location_type& l)
      {
        return symbol_type (token::PPOST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ILPTAU (location_type l)
      {
        return symbol_type (token::ILPTAU, std::move (l));
      }
#else
      static
      symbol_type
      make_ILPTAU (const location_type& l)
      {
        return symbol_type (token::ILPTAU, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MORRIS_NLIV (location_type l)
      {
        return symbol_type (token::MORRIS_NLIV, std::move (l));
      }
#else
      static
      symbol_type
      make_MORRIS_NLIV (const location_type& l)
      {
        return symbol_type (token::MORRIS_NLIV, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MORRIS_NTRA (location_type l)
      {
        return symbol_type (token::MORRIS_NTRA, std::move (l));
      }
#else
      static
      symbol_type
      make_MORRIS_NTRA (const location_type& l)
      {
        return symbol_type (token::MORRIS_NTRA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NSAM (location_type l)
      {
        return symbol_type (token::NSAM, std::move (l));
      }
#else
      static
      symbol_type
      make_NSAM (const location_type& l)
      {
        return symbol_type (token::NSAM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOAD_REDFORM (location_type l)
      {
        return symbol_type (token::LOAD_REDFORM, std::move (l));
      }
#else
      static
      symbol_type
      make_LOAD_REDFORM (const location_type& l)
      {
        return symbol_type (token::LOAD_REDFORM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOAD_RMSE (location_type l)
      {
        return symbol_type (token::LOAD_RMSE, std::move (l));
      }
#else
      static
      symbol_type
      make_LOAD_RMSE (const location_type& l)
      {
        return symbol_type (token::LOAD_RMSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOAD_STAB (location_type l)
      {
        return symbol_type (token::LOAD_STAB, std::move (l));
      }
#else
      static
      symbol_type
      make_LOAD_STAB (const location_type& l)
      {
        return symbol_type (token::LOAD_STAB, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ALPHA2_STAB (location_type l)
      {
        return symbol_type (token::ALPHA2_STAB, std::move (l));
      }
#else
      static
      symbol_type
      make_ALPHA2_STAB (const location_type& l)
      {
        return symbol_type (token::ALPHA2_STAB, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOGTRANS_REDFORM (location_type l)
      {
        return symbol_type (token::LOGTRANS_REDFORM, std::move (l));
      }
#else
      static
      symbol_type
      make_LOGTRANS_REDFORM (const location_type& l)
      {
        return symbol_type (token::LOGTRANS_REDFORM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_THRESHOLD_REDFORM (location_type l)
      {
        return symbol_type (token::THRESHOLD_REDFORM, std::move (l));
      }
#else
      static
      symbol_type
      make_THRESHOLD_REDFORM (const location_type& l)
      {
        return symbol_type (token::THRESHOLD_REDFORM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_KSSTAT_REDFORM (location_type l)
      {
        return symbol_type (token::KSSTAT_REDFORM, std::move (l));
      }
#else
      static
      symbol_type
      make_KSSTAT_REDFORM (const location_type& l)
      {
        return symbol_type (token::KSSTAT_REDFORM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ALPHA2_REDFORM (location_type l)
      {
        return symbol_type (token::ALPHA2_REDFORM, std::move (l));
      }
#else
      static
      symbol_type
      make_ALPHA2_REDFORM (const location_type& l)
      {
        return symbol_type (token::ALPHA2_REDFORM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NAMENDO (location_type l)
      {
        return symbol_type (token::NAMENDO, std::move (l));
      }
#else
      static
      symbol_type
      make_NAMENDO (const location_type& l)
      {
        return symbol_type (token::NAMENDO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NAMLAGENDO (location_type l)
      {
        return symbol_type (token::NAMLAGENDO, std::move (l));
      }
#else
      static
      symbol_type
      make_NAMLAGENDO (const location_type& l)
      {
        return symbol_type (token::NAMLAGENDO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NAMEXO (location_type l)
      {
        return symbol_type (token::NAMEXO, std::move (l));
      }
#else
      static
      symbol_type
      make_NAMEXO (const location_type& l)
      {
        return symbol_type (token::NAMEXO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RMSE (location_type l)
      {
        return symbol_type (token::RMSE, std::move (l));
      }
#else
      static
      symbol_type
      make_RMSE (const location_type& l)
      {
        return symbol_type (token::RMSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIK_ONLY (location_type l)
      {
        return symbol_type (token::LIK_ONLY, std::move (l));
      }
#else
      static
      symbol_type
      make_LIK_ONLY (const location_type& l)
      {
        return symbol_type (token::LIK_ONLY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAR_RMSE (location_type l)
      {
        return symbol_type (token::VAR_RMSE, std::move (l));
      }
#else
      static
      symbol_type
      make_VAR_RMSE (const location_type& l)
      {
        return symbol_type (token::VAR_RMSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PFILT_RMSE (location_type l)
      {
        return symbol_type (token::PFILT_RMSE, std::move (l));
      }
#else
      static
      symbol_type
      make_PFILT_RMSE (const location_type& l)
      {
        return symbol_type (token::PFILT_RMSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ISTART_RMSE (location_type l)
      {
        return symbol_type (token::ISTART_RMSE, std::move (l));
      }
#else
      static
      symbol_type
      make_ISTART_RMSE (const location_type& l)
      {
        return symbol_type (token::ISTART_RMSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ALPHA_RMSE (location_type l)
      {
        return symbol_type (token::ALPHA_RMSE, std::move (l));
      }
#else
      static
      symbol_type
      make_ALPHA_RMSE (const location_type& l)
      {
        return symbol_type (token::ALPHA_RMSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ALPHA2_RMSE (location_type l)
      {
        return symbol_type (token::ALPHA2_RMSE, std::move (l));
      }
#else
      static
      symbol_type
      make_ALPHA2_RMSE (const location_type& l)
      {
        return symbol_type (token::ALPHA2_RMSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FREQ (location_type l)
      {
        return symbol_type (token::FREQ, std::move (l));
      }
#else
      static
      symbol_type
      make_FREQ (const location_type& l)
      {
        return symbol_type (token::FREQ, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INITIAL_YEAR (location_type l)
      {
        return symbol_type (token::INITIAL_YEAR, std::move (l));
      }
#else
      static
      symbol_type
      make_INITIAL_YEAR (const location_type& l)
      {
        return symbol_type (token::INITIAL_YEAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INITIAL_SUBPERIOD (location_type l)
      {
        return symbol_type (token::INITIAL_SUBPERIOD, std::move (l));
      }
#else
      static
      symbol_type
      make_INITIAL_SUBPERIOD (const location_type& l)
      {
        return symbol_type (token::INITIAL_SUBPERIOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FINAL_YEAR (location_type l)
      {
        return symbol_type (token::FINAL_YEAR, std::move (l));
      }
#else
      static
      symbol_type
      make_FINAL_YEAR (const location_type& l)
      {
        return symbol_type (token::FINAL_YEAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FINAL_SUBPERIOD (location_type l)
      {
        return symbol_type (token::FINAL_SUBPERIOD, std::move (l));
      }
#else
      static
      symbol_type
      make_FINAL_SUBPERIOD (const location_type& l)
      {
        return symbol_type (token::FINAL_SUBPERIOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DATA (location_type l)
      {
        return symbol_type (token::DATA, std::move (l));
      }
#else
      static
      symbol_type
      make_DATA (const location_type& l)
      {
        return symbol_type (token::DATA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VLIST (location_type l)
      {
        return symbol_type (token::VLIST, std::move (l));
      }
#else
      static
      symbol_type
      make_VLIST (const location_type& l)
      {
        return symbol_type (token::VLIST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VLISTLOG (location_type l)
      {
        return symbol_type (token::VLISTLOG, std::move (l));
      }
#else
      static
      symbol_type
      make_VLISTLOG (const location_type& l)
      {
        return symbol_type (token::VLISTLOG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VLISTPER (location_type l)
      {
        return symbol_type (token::VLISTPER, std::move (l));
      }
#else
      static
      symbol_type
      make_VLISTPER (const location_type& l)
      {
        return symbol_type (token::VLISTPER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SPECTRAL_DENSITY (location_type l)
      {
        return symbol_type (token::SPECTRAL_DENSITY, std::move (l));
      }
#else
      static
      symbol_type
      make_SPECTRAL_DENSITY (const location_type& l)
      {
        return symbol_type (token::SPECTRAL_DENSITY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INIT2SHOCKS (location_type l)
      {
        return symbol_type (token::INIT2SHOCKS, std::move (l));
      }
#else
      static
      symbol_type
      make_INIT2SHOCKS (const location_type& l)
      {
        return symbol_type (token::INIT2SHOCKS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RESTRICTION (location_type l)
      {
        return symbol_type (token::RESTRICTION, std::move (l));
      }
#else
      static
      symbol_type
      make_RESTRICTION (const location_type& l)
      {
        return symbol_type (token::RESTRICTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RESTRICTION_FNAME (location_type l)
      {
        return symbol_type (token::RESTRICTION_FNAME, std::move (l));
      }
#else
      static
      symbol_type
      make_RESTRICTION_FNAME (const location_type& l)
      {
        return symbol_type (token::RESTRICTION_FNAME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CROSS_RESTRICTIONS (location_type l)
      {
        return symbol_type (token::CROSS_RESTRICTIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_CROSS_RESTRICTIONS (const location_type& l)
      {
        return symbol_type (token::CROSS_RESTRICTIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NLAGS (location_type l)
      {
        return symbol_type (token::NLAGS, std::move (l));
      }
#else
      static
      symbol_type
      make_NLAGS (const location_type& l)
      {
        return symbol_type (token::NLAGS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONTEMP_REDUCED_FORM (location_type l)
      {
        return symbol_type (token::CONTEMP_REDUCED_FORM, std::move (l));
      }
#else
      static
      symbol_type
      make_CONTEMP_REDUCED_FORM (const location_type& l)
      {
        return symbol_type (token::CONTEMP_REDUCED_FORM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REAL_PSEUDO_FORECAST (location_type l)
      {
        return symbol_type (token::REAL_PSEUDO_FORECAST, std::move (l));
      }
#else
      static
      symbol_type
      make_REAL_PSEUDO_FORECAST (const location_type& l)
      {
        return symbol_type (token::REAL_PSEUDO_FORECAST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DUMMY_OBS (location_type l)
      {
        return symbol_type (token::DUMMY_OBS, std::move (l));
      }
#else
      static
      symbol_type
      make_DUMMY_OBS (const location_type& l)
      {
        return symbol_type (token::DUMMY_OBS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NSTATES (location_type l)
      {
        return symbol_type (token::NSTATES, std::move (l));
      }
#else
      static
      symbol_type
      make_NSTATES (const location_type& l)
      {
        return symbol_type (token::NSTATES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXSCALESSTATES (location_type l)
      {
        return symbol_type (token::INDXSCALESSTATES, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXSCALESSTATES (const location_type& l)
      {
        return symbol_type (token::INDXSCALESSTATES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_BAYESIAN_PRIOR (location_type l)
      {
        return symbol_type (token::NO_BAYESIAN_PRIOR, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_BAYESIAN_PRIOR (const location_type& l)
      {
        return symbol_type (token::NO_BAYESIAN_PRIOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SPECIFICATION (location_type l)
      {
        return symbol_type (token::SPECIFICATION, std::move (l));
      }
#else
      static
      symbol_type
      make_SPECIFICATION (const location_type& l)
      {
        return symbol_type (token::SPECIFICATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMS_ZHA (location_type l)
      {
        return symbol_type (token::SIMS_ZHA, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMS_ZHA (const location_type& l)
      {
        return symbol_type (token::SIMS_ZHA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ALPHA (string v, location_type l)
      {
        return symbol_type (token::ALPHA, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_ALPHA (const string& v, const location_type& l)
      {
        return symbol_type (token::ALPHA, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BETA (string v, location_type l)
      {
        return symbol_type (token::BETA, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_BETA (const string& v, const location_type& l)
      {
        return symbol_type (token::BETA, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ABAND (string v, location_type l)
      {
        return symbol_type (token::ABAND, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_ABAND (const string& v, const location_type& l)
      {
        return symbol_type (token::ABAND, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NINV (string v, location_type l)
      {
        return symbol_type (token::NINV, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_NINV (const string& v, const location_type& l)
      {
        return symbol_type (token::NINV, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CMS (string v, location_type l)
      {
        return symbol_type (token::CMS, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CMS (const string& v, const location_type& l)
      {
        return symbol_type (token::CMS, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NCMS (string v, location_type l)
      {
        return symbol_type (token::NCMS, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_NCMS (const string& v, const location_type& l)
      {
        return symbol_type (token::NCMS, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CNUM (string v, location_type l)
      {
        return symbol_type (token::CNUM, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CNUM (const string& v, const location_type& l)
      {
        return symbol_type (token::CNUM, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GAMMA (string v, location_type l)
      {
        return symbol_type (token::GAMMA, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_GAMMA (const string& v, const location_type& l)
      {
        return symbol_type (token::GAMMA, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INV_GAMMA (string v, location_type l)
      {
        return symbol_type (token::INV_GAMMA, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_INV_GAMMA (const string& v, const location_type& l)
      {
        return symbol_type (token::INV_GAMMA, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INV_GAMMA1 (string v, location_type l)
      {
        return symbol_type (token::INV_GAMMA1, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_INV_GAMMA1 (const string& v, const location_type& l)
      {
        return symbol_type (token::INV_GAMMA1, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INV_GAMMA2 (string v, location_type l)
      {
        return symbol_type (token::INV_GAMMA2, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_INV_GAMMA2 (const string& v, const location_type& l)
      {
        return symbol_type (token::INV_GAMMA2, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NORMAL (string v, location_type l)
      {
        return symbol_type (token::NORMAL, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_NORMAL (const string& v, const location_type& l)
      {
        return symbol_type (token::NORMAL, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNIFORM (string v, location_type l)
      {
        return symbol_type (token::UNIFORM, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_UNIFORM (const string& v, const location_type& l)
      {
        return symbol_type (token::UNIFORM, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EPS (string v, location_type l)
      {
        return symbol_type (token::EPS, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_EPS (const string& v, const location_type& l)
      {
        return symbol_type (token::EPS, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PDF (string v, location_type l)
      {
        return symbol_type (token::PDF, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_PDF (const string& v, const location_type& l)
      {
        return symbol_type (token::PDF, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FIG (string v, location_type l)
      {
        return symbol_type (token::FIG, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_FIG (const string& v, const location_type& l)
      {
        return symbol_type (token::FIG, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DR (string v, location_type l)
      {
        return symbol_type (token::DR, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_DR (const string& v, const location_type& l)
      {
        return symbol_type (token::DR, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NONE (string v, location_type l)
      {
        return symbol_type (token::NONE, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_NONE (const string& v, const location_type& l)
      {
        return symbol_type (token::NONE, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIOR (string v, location_type l)
      {
        return symbol_type (token::PRIOR, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_PRIOR (const string& v, const location_type& l)
      {
        return symbol_type (token::PRIOR, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIOR_VARIANCE (string v, location_type l)
      {
        return symbol_type (token::PRIOR_VARIANCE, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_PRIOR_VARIANCE (const string& v, const location_type& l)
      {
        return symbol_type (token::PRIOR_VARIANCE, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HESSIAN (string v, location_type l)
      {
        return symbol_type (token::HESSIAN, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_HESSIAN (const string& v, const location_type& l)
      {
        return symbol_type (token::HESSIAN, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IDENTITY_MATRIX (string v, location_type l)
      {
        return symbol_type (token::IDENTITY_MATRIX, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_IDENTITY_MATRIX (const string& v, const location_type& l)
      {
        return symbol_type (token::IDENTITY_MATRIX, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIRICHLET (string v, location_type l)
      {
        return symbol_type (token::DIRICHLET, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_DIRICHLET (const string& v, const location_type& l)
      {
        return symbol_type (token::DIRICHLET, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIAGONAL (string v, location_type l)
      {
        return symbol_type (token::DIAGONAL, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_DIAGONAL (const string& v, const location_type& l)
      {
        return symbol_type (token::DIAGONAL, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OPTIMAL (string v, location_type l)
      {
        return symbol_type (token::OPTIMAL, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_OPTIMAL (const string& v, const location_type& l)
      {
        return symbol_type (token::OPTIMAL, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GSIG2_LMDM (location_type l)
      {
        return symbol_type (token::GSIG2_LMDM, std::move (l));
      }
#else
      static
      symbol_type
      make_GSIG2_LMDM (const location_type& l)
      {
        return symbol_type (token::GSIG2_LMDM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_Q_DIAG (location_type l)
      {
        return symbol_type (token::Q_DIAG, std::move (l));
      }
#else
      static
      symbol_type
      make_Q_DIAG (const location_type& l)
      {
        return symbol_type (token::Q_DIAG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FLAT_PRIOR (location_type l)
      {
        return symbol_type (token::FLAT_PRIOR, std::move (l));
      }
#else
      static
      symbol_type
      make_FLAT_PRIOR (const location_type& l)
      {
        return symbol_type (token::FLAT_PRIOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NCSK (location_type l)
      {
        return symbol_type (token::NCSK, std::move (l));
      }
#else
      static
      symbol_type
      make_NCSK (const location_type& l)
      {
        return symbol_type (token::NCSK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NSTD (location_type l)
      {
        return symbol_type (token::NSTD, std::move (l));
      }
#else
      static
      symbol_type
      make_NSTD (const location_type& l)
      {
        return symbol_type (token::NSTD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WEIBULL (location_type l)
      {
        return symbol_type (token::WEIBULL, std::move (l));
      }
#else
      static
      symbol_type
      make_WEIBULL (const location_type& l)
      {
        return symbol_type (token::WEIBULL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WEIBULL_PDF (location_type l)
      {
        return symbol_type (token::WEIBULL_PDF, std::move (l));
      }
#else
      static
      symbol_type
      make_WEIBULL_PDF (const location_type& l)
      {
        return symbol_type (token::WEIBULL_PDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GMM (location_type l)
      {
        return symbol_type (token::GMM, std::move (l));
      }
#else
      static
      symbol_type
      make_GMM (const location_type& l)
      {
        return symbol_type (token::GMM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMM (location_type l)
      {
        return symbol_type (token::SMM, std::move (l));
      }
#else
      static
      symbol_type
      make_SMM (const location_type& l)
      {
        return symbol_type (token::SMM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXPARR (location_type l)
      {
        return symbol_type (token::INDXPARR, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXPARR (const location_type& l)
      {
        return symbol_type (token::INDXPARR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXOVR (location_type l)
      {
        return symbol_type (token::INDXOVR, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXOVR (const location_type& l)
      {
        return symbol_type (token::INDXOVR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXAP (location_type l)
      {
        return symbol_type (token::INDXAP, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXAP (const location_type& l)
      {
        return symbol_type (token::INDXAP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_APBAND (location_type l)
      {
        return symbol_type (token::APBAND, std::move (l));
      }
#else
      static
      symbol_type
      make_APBAND (const location_type& l)
      {
        return symbol_type (token::APBAND, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXIMF (location_type l)
      {
        return symbol_type (token::INDXIMF, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXIMF (const location_type& l)
      {
        return symbol_type (token::INDXIMF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXFORE (location_type l)
      {
        return symbol_type (token::INDXFORE, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXFORE (const location_type& l)
      {
        return symbol_type (token::INDXFORE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FOREBAND (location_type l)
      {
        return symbol_type (token::FOREBAND, std::move (l));
      }
#else
      static
      symbol_type
      make_FOREBAND (const location_type& l)
      {
        return symbol_type (token::FOREBAND, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXGFOREHAT (location_type l)
      {
        return symbol_type (token::INDXGFOREHAT, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXGFOREHAT (const location_type& l)
      {
        return symbol_type (token::INDXGFOREHAT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXGIMFHAT (location_type l)
      {
        return symbol_type (token::INDXGIMFHAT, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXGIMFHAT (const location_type& l)
      {
        return symbol_type (token::INDXGIMFHAT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXESTIMA (location_type l)
      {
        return symbol_type (token::INDXESTIMA, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXESTIMA (const location_type& l)
      {
        return symbol_type (token::INDXESTIMA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXGDLS (location_type l)
      {
        return symbol_type (token::INDXGDLS, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXGDLS (const location_type& l)
      {
        return symbol_type (token::INDXGDLS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQ_MS (location_type l)
      {
        return symbol_type (token::EQ_MS, std::move (l));
      }
#else
      static
      symbol_type
      make_EQ_MS (const location_type& l)
      {
        return symbol_type (token::EQ_MS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILTER_COVARIANCE (location_type l)
      {
        return symbol_type (token::FILTER_COVARIANCE, std::move (l));
      }
#else
      static
      symbol_type
      make_FILTER_COVARIANCE (const location_type& l)
      {
        return symbol_type (token::FILTER_COVARIANCE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILTER_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::FILTER_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_FILTER_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::FILTER_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMOOTHED_STATE_UNCERTAINTY (location_type l)
      {
        return symbol_type (token::SMOOTHED_STATE_UNCERTAINTY, std::move (l));
      }
#else
      static
      symbol_type
      make_SMOOTHED_STATE_UNCERTAINTY (const location_type& l)
      {
        return symbol_type (token::SMOOTHED_STATE_UNCERTAINTY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMOOTHER_REDUX (location_type l)
      {
        return symbol_type (token::SMOOTHER_REDUX, std::move (l));
      }
#else
      static
      symbol_type
      make_SMOOTHER_REDUX (const location_type& l)
      {
        return symbol_type (token::SMOOTHER_REDUX, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQ_CMS (location_type l)
      {
        return symbol_type (token::EQ_CMS, std::move (l));
      }
#else
      static
      symbol_type
      make_EQ_CMS (const location_type& l)
      {
        return symbol_type (token::EQ_CMS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TLINDX (location_type l)
      {
        return symbol_type (token::TLINDX, std::move (l));
      }
#else
      static
      symbol_type
      make_TLINDX (const location_type& l)
      {
        return symbol_type (token::TLINDX, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TLNUMBER (location_type l)
      {
        return symbol_type (token::TLNUMBER, std::move (l));
      }
#else
      static
      symbol_type
      make_TLNUMBER (const location_type& l)
      {
        return symbol_type (token::TLNUMBER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RESTRICTIONS (location_type l)
      {
        return symbol_type (token::RESTRICTIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_RESTRICTIONS (const location_type& l)
      {
        return symbol_type (token::RESTRICTIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_SAMPLER_OPTIONS (location_type l)
      {
        return symbol_type (token::POSTERIOR_SAMPLER_OPTIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_SAMPLER_OPTIONS (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_SAMPLER_OPTIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OUTPUT_FILE_TAG (location_type l)
      {
        return symbol_type (token::OUTPUT_FILE_TAG, std::move (l));
      }
#else
      static
      symbol_type
      make_OUTPUT_FILE_TAG (const location_type& l)
      {
        return symbol_type (token::OUTPUT_FILE_TAG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HORIZON (location_type l)
      {
        return symbol_type (token::HORIZON, std::move (l));
      }
#else
      static
      symbol_type
      make_HORIZON (const location_type& l)
      {
        return symbol_type (token::HORIZON, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SBVAR (location_type l)
      {
        return symbol_type (token::SBVAR, std::move (l));
      }
#else
      static
      symbol_type
      make_SBVAR (const location_type& l)
      {
        return symbol_type (token::SBVAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TREND_VAR (location_type l)
      {
        return symbol_type (token::TREND_VAR, std::move (l));
      }
#else
      static
      symbol_type
      make_TREND_VAR (const location_type& l)
      {
        return symbol_type (token::TREND_VAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DEFLATOR (location_type l)
      {
        return symbol_type (token::DEFLATOR, std::move (l));
      }
#else
      static
      symbol_type
      make_DEFLATOR (const location_type& l)
      {
        return symbol_type (token::DEFLATOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GROWTH_FACTOR (location_type l)
      {
        return symbol_type (token::GROWTH_FACTOR, std::move (l));
      }
#else
      static
      symbol_type
      make_GROWTH_FACTOR (const location_type& l)
      {
        return symbol_type (token::GROWTH_FACTOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MS_IRF (location_type l)
      {
        return symbol_type (token::MS_IRF, std::move (l));
      }
#else
      static
      symbol_type
      make_MS_IRF (const location_type& l)
      {
        return symbol_type (token::MS_IRF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MS_VARIANCE_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::MS_VARIANCE_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_MS_VARIANCE_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::MS_VARIANCE_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GROWTH (location_type l)
      {
        return symbol_type (token::GROWTH, std::move (l));
      }
#else
      static
      symbol_type
      make_GROWTH (const location_type& l)
      {
        return symbol_type (token::GROWTH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MS_ESTIMATION (location_type l)
      {
        return symbol_type (token::MS_ESTIMATION, std::move (l));
      }
#else
      static
      symbol_type
      make_MS_ESTIMATION (const location_type& l)
      {
        return symbol_type (token::MS_ESTIMATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MS_SIMULATION (location_type l)
      {
        return symbol_type (token::MS_SIMULATION, std::move (l));
      }
#else
      static
      symbol_type
      make_MS_SIMULATION (const location_type& l)
      {
        return symbol_type (token::MS_SIMULATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MS_COMPUTE_MDD (location_type l)
      {
        return symbol_type (token::MS_COMPUTE_MDD, std::move (l));
      }
#else
      static
      symbol_type
      make_MS_COMPUTE_MDD (const location_type& l)
      {
        return symbol_type (token::MS_COMPUTE_MDD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MS_COMPUTE_PROBABILITIES (location_type l)
      {
        return symbol_type (token::MS_COMPUTE_PROBABILITIES, std::move (l));
      }
#else
      static
      symbol_type
      make_MS_COMPUTE_PROBABILITIES (const location_type& l)
      {
        return symbol_type (token::MS_COMPUTE_PROBABILITIES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MS_FORECAST (location_type l)
      {
        return symbol_type (token::MS_FORECAST, std::move (l));
      }
#else
      static
      symbol_type
      make_MS_FORECAST (const location_type& l)
      {
        return symbol_type (token::MS_FORECAST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SVAR_IDENTIFICATION (location_type l)
      {
        return symbol_type (token::SVAR_IDENTIFICATION, std::move (l));
      }
#else
      static
      symbol_type
      make_SVAR_IDENTIFICATION (const location_type& l)
      {
        return symbol_type (token::SVAR_IDENTIFICATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQUATION (location_type l)
      {
        return symbol_type (token::EQUATION, std::move (l));
      }
#else
      static
      symbol_type
      make_EQUATION (const location_type& l)
      {
        return symbol_type (token::EQUATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXCLUSION (location_type l)
      {
        return symbol_type (token::EXCLUSION, std::move (l));
      }
#else
      static
      symbol_type
      make_EXCLUSION (const location_type& l)
      {
        return symbol_type (token::EXCLUSION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LAG (location_type l)
      {
        return symbol_type (token::LAG, std::move (l));
      }
#else
      static
      symbol_type
      make_LAG (const location_type& l)
      {
        return symbol_type (token::LAG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UPPER_CHOLESKY (location_type l)
      {
        return symbol_type (token::UPPER_CHOLESKY, std::move (l));
      }
#else
      static
      symbol_type
      make_UPPER_CHOLESKY (const location_type& l)
      {
        return symbol_type (token::UPPER_CHOLESKY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOWER_CHOLESKY (location_type l)
      {
        return symbol_type (token::LOWER_CHOLESKY, std::move (l));
      }
#else
      static
      symbol_type
      make_LOWER_CHOLESKY (const location_type& l)
      {
        return symbol_type (token::LOWER_CHOLESKY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MONTHLY (location_type l)
      {
        return symbol_type (token::MONTHLY, std::move (l));
      }
#else
      static
      symbol_type
      make_MONTHLY (const location_type& l)
      {
        return symbol_type (token::MONTHLY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_QUARTERLY (location_type l)
      {
        return symbol_type (token::QUARTERLY, std::move (l));
      }
#else
      static
      symbol_type
      make_QUARTERLY (const location_type& l)
      {
        return symbol_type (token::QUARTERLY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MARKOV_SWITCHING (location_type l)
      {
        return symbol_type (token::MARKOV_SWITCHING, std::move (l));
      }
#else
      static
      symbol_type
      make_MARKOV_SWITCHING (const location_type& l)
      {
        return symbol_type (token::MARKOV_SWITCHING, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CHAIN (location_type l)
      {
        return symbol_type (token::CHAIN, std::move (l));
      }
#else
      static
      symbol_type
      make_CHAIN (const location_type& l)
      {
        return symbol_type (token::CHAIN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DURATION (location_type l)
      {
        return symbol_type (token::DURATION, std::move (l));
      }
#else
      static
      symbol_type
      make_DURATION (const location_type& l)
      {
        return symbol_type (token::DURATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NUMBER_OF_REGIMES (location_type l)
      {
        return symbol_type (token::NUMBER_OF_REGIMES, std::move (l));
      }
#else
      static
      symbol_type
      make_NUMBER_OF_REGIMES (const location_type& l)
      {
        return symbol_type (token::NUMBER_OF_REGIMES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NUMBER_OF_LAGS (location_type l)
      {
        return symbol_type (token::NUMBER_OF_LAGS, std::move (l));
      }
#else
      static
      symbol_type
      make_NUMBER_OF_LAGS (const location_type& l)
      {
        return symbol_type (token::NUMBER_OF_LAGS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EPILOGUE (location_type l)
      {
        return symbol_type (token::EPILOGUE, std::move (l));
      }
#else
      static
      symbol_type
      make_EPILOGUE (const location_type& l)
      {
        return symbol_type (token::EPILOGUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SVAR (location_type l)
      {
        return symbol_type (token::SVAR, std::move (l));
      }
#else
      static
      symbol_type
      make_SVAR (const location_type& l)
      {
        return symbol_type (token::SVAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SVAR_GLOBAL_IDENTIFICATION_CHECK (location_type l)
      {
        return symbol_type (token::SVAR_GLOBAL_IDENTIFICATION_CHECK, std::move (l));
      }
#else
      static
      symbol_type
      make_SVAR_GLOBAL_IDENTIFICATION_CHECK (const location_type& l)
      {
        return symbol_type (token::SVAR_GLOBAL_IDENTIFICATION_CHECK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COEFF (location_type l)
      {
        return symbol_type (token::COEFF, std::move (l));
      }
#else
      static
      symbol_type
      make_COEFF (const location_type& l)
      {
        return symbol_type (token::COEFF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COEFFICIENTS (location_type l)
      {
        return symbol_type (token::COEFFICIENTS, std::move (l));
      }
#else
      static
      symbol_type
      make_COEFFICIENTS (const location_type& l)
      {
        return symbol_type (token::COEFFICIENTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VARIANCES (location_type l)
      {
        return symbol_type (token::VARIANCES, std::move (l));
      }
#else
      static
      symbol_type
      make_VARIANCES (const location_type& l)
      {
        return symbol_type (token::VARIANCES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONSTANTS (location_type l)
      {
        return symbol_type (token::CONSTANTS, std::move (l));
      }
#else
      static
      symbol_type
      make_CONSTANTS (const location_type& l)
      {
        return symbol_type (token::CONSTANTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQUATIONS (location_type l)
      {
        return symbol_type (token::EQUATIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_EQUATIONS (const location_type& l)
      {
        return symbol_type (token::EQUATIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXTERNAL_FUNCTION (location_type l)
      {
        return symbol_type (token::EXTERNAL_FUNCTION, std::move (l));
      }
#else
      static
      symbol_type
      make_EXTERNAL_FUNCTION (const location_type& l)
      {
        return symbol_type (token::EXTERNAL_FUNCTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXT_FUNC_NAME (location_type l)
      {
        return symbol_type (token::EXT_FUNC_NAME, std::move (l));
      }
#else
      static
      symbol_type
      make_EXT_FUNC_NAME (const location_type& l)
      {
        return symbol_type (token::EXT_FUNC_NAME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXT_FUNC_NARGS (location_type l)
      {
        return symbol_type (token::EXT_FUNC_NARGS, std::move (l));
      }
#else
      static
      symbol_type
      make_EXT_FUNC_NARGS (const location_type& l)
      {
        return symbol_type (token::EXT_FUNC_NARGS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FIRST_DERIV_PROVIDED (location_type l)
      {
        return symbol_type (token::FIRST_DERIV_PROVIDED, std::move (l));
      }
#else
      static
      symbol_type
      make_FIRST_DERIV_PROVIDED (const location_type& l)
      {
        return symbol_type (token::FIRST_DERIV_PROVIDED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SECOND_DERIV_PROVIDED (location_type l)
      {
        return symbol_type (token::SECOND_DERIV_PROVIDED, std::move (l));
      }
#else
      static
      symbol_type
      make_SECOND_DERIV_PROVIDED (const location_type& l)
      {
        return symbol_type (token::SECOND_DERIV_PROVIDED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SELECTED_VARIABLES_ONLY (location_type l)
      {
        return symbol_type (token::SELECTED_VARIABLES_ONLY, std::move (l));
      }
#else
      static
      symbol_type
      make_SELECTED_VARIABLES_ONLY (const location_type& l)
      {
        return symbol_type (token::SELECTED_VARIABLES_ONLY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COVA_COMPUTE (location_type l)
      {
        return symbol_type (token::COVA_COMPUTE, std::move (l));
      }
#else
      static
      symbol_type
      make_COVA_COMPUTE (const location_type& l)
      {
        return symbol_type (token::COVA_COMPUTE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMULATION_FILE_TAG (location_type l)
      {
        return symbol_type (token::SIMULATION_FILE_TAG, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMULATION_FILE_TAG (const location_type& l)
      {
        return symbol_type (token::SIMULATION_FILE_TAG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILE_TAG (location_type l)
      {
        return symbol_type (token::FILE_TAG, std::move (l));
      }
#else
      static
      symbol_type
      make_FILE_TAG (const location_type& l)
      {
        return symbol_type (token::FILE_TAG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_ERROR_BANDS (location_type l)
      {
        return symbol_type (token::NO_ERROR_BANDS, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_ERROR_BANDS (const location_type& l)
      {
        return symbol_type (token::NO_ERROR_BANDS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ERROR_BAND_PERCENTILES (location_type l)
      {
        return symbol_type (token::ERROR_BAND_PERCENTILES, std::move (l));
      }
#else
      static
      symbol_type
      make_ERROR_BAND_PERCENTILES (const location_type& l)
      {
        return symbol_type (token::ERROR_BAND_PERCENTILES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHOCKS_PER_PARAMETER (location_type l)
      {
        return symbol_type (token::SHOCKS_PER_PARAMETER, std::move (l));
      }
#else
      static
      symbol_type
      make_SHOCKS_PER_PARAMETER (const location_type& l)
      {
        return symbol_type (token::SHOCKS_PER_PARAMETER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_CREATE_INIT (location_type l)
      {
        return symbol_type (token::NO_CREATE_INIT, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_CREATE_INIT (const location_type& l)
      {
        return symbol_type (token::NO_CREATE_INIT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHOCK_DRAWS (location_type l)
      {
        return symbol_type (token::SHOCK_DRAWS, std::move (l));
      }
#else
      static
      symbol_type
      make_SHOCK_DRAWS (const location_type& l)
      {
        return symbol_type (token::SHOCK_DRAWS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FREE_PARAMETERS (location_type l)
      {
        return symbol_type (token::FREE_PARAMETERS, std::move (l));
      }
#else
      static
      symbol_type
      make_FREE_PARAMETERS (const location_type& l)
      {
        return symbol_type (token::FREE_PARAMETERS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MEDIAN (location_type l)
      {
        return symbol_type (token::MEDIAN, std::move (l));
      }
#else
      static
      symbol_type
      make_MEDIAN (const location_type& l)
      {
        return symbol_type (token::MEDIAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DATA_OBS_NBR (location_type l)
      {
        return symbol_type (token::DATA_OBS_NBR, std::move (l));
      }
#else
      static
      symbol_type
      make_DATA_OBS_NBR (const location_type& l)
      {
        return symbol_type (token::DATA_OBS_NBR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NEIGHBORHOOD_WIDTH (location_type l)
      {
        return symbol_type (token::NEIGHBORHOOD_WIDTH, std::move (l));
      }
#else
      static
      symbol_type
      make_NEIGHBORHOOD_WIDTH (const location_type& l)
      {
        return symbol_type (token::NEIGHBORHOOD_WIDTH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PVALUE_KS (location_type l)
      {
        return symbol_type (token::PVALUE_KS, std::move (l));
      }
#else
      static
      symbol_type
      make_PVALUE_KS (const location_type& l)
      {
        return symbol_type (token::PVALUE_KS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PVALUE_CORR (location_type l)
      {
        return symbol_type (token::PVALUE_CORR, std::move (l));
      }
#else
      static
      symbol_type
      make_PVALUE_CORR (const location_type& l)
      {
        return symbol_type (token::PVALUE_CORR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILTERED_PROBABILITIES (location_type l)
      {
        return symbol_type (token::FILTERED_PROBABILITIES, std::move (l));
      }
#else
      static
      symbol_type
      make_FILTERED_PROBABILITIES (const location_type& l)
      {
        return symbol_type (token::FILTERED_PROBABILITIES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REAL_TIME_SMOOTHED (location_type l)
      {
        return symbol_type (token::REAL_TIME_SMOOTHED, std::move (l));
      }
#else
      static
      symbol_type
      make_REAL_TIME_SMOOTHED (const location_type& l)
      {
        return symbol_type (token::REAL_TIME_SMOOTHED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIOR_FUNCTION (location_type l)
      {
        return symbol_type (token::PRIOR_FUNCTION, std::move (l));
      }
#else
      static
      symbol_type
      make_PRIOR_FUNCTION (const location_type& l)
      {
        return symbol_type (token::PRIOR_FUNCTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_FUNCTION (location_type l)
      {
        return symbol_type (token::POSTERIOR_FUNCTION, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_FUNCTION (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_FUNCTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SAMPLING_DRAWS (location_type l)
      {
        return symbol_type (token::SAMPLING_DRAWS, std::move (l));
      }
#else
      static
      symbol_type
      make_SAMPLING_DRAWS (const location_type& l)
      {
        return symbol_type (token::SAMPLING_DRAWS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PROPOSAL_TYPE (location_type l)
      {
        return symbol_type (token::PROPOSAL_TYPE, std::move (l));
      }
#else
      static
      symbol_type
      make_PROPOSAL_TYPE (const location_type& l)
      {
        return symbol_type (token::PROPOSAL_TYPE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PROPOSAL_UPPER_BOUND (location_type l)
      {
        return symbol_type (token::PROPOSAL_UPPER_BOUND, std::move (l));
      }
#else
      static
      symbol_type
      make_PROPOSAL_UPPER_BOUND (const location_type& l)
      {
        return symbol_type (token::PROPOSAL_UPPER_BOUND, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PROPOSAL_LOWER_BOUND (location_type l)
      {
        return symbol_type (token::PROPOSAL_LOWER_BOUND, std::move (l));
      }
#else
      static
      symbol_type
      make_PROPOSAL_LOWER_BOUND (const location_type& l)
      {
        return symbol_type (token::PROPOSAL_LOWER_BOUND, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PROPOSAL_DRAWS (location_type l)
      {
        return symbol_type (token::PROPOSAL_DRAWS, std::move (l));
      }
#else
      static
      symbol_type
      make_PROPOSAL_DRAWS (const location_type& l)
      {
        return symbol_type (token::PROPOSAL_DRAWS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_USE_MEAN_CENTER (location_type l)
      {
        return symbol_type (token::USE_MEAN_CENTER, std::move (l));
      }
#else
      static
      symbol_type
      make_USE_MEAN_CENTER (const location_type& l)
      {
        return symbol_type (token::USE_MEAN_CENTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ADAPTIVE_MH_DRAWS (location_type l)
      {
        return symbol_type (token::ADAPTIVE_MH_DRAWS, std::move (l));
      }
#else
      static
      symbol_type
      make_ADAPTIVE_MH_DRAWS (const location_type& l)
      {
        return symbol_type (token::ADAPTIVE_MH_DRAWS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_THINNING_FACTOR (location_type l)
      {
        return symbol_type (token::THINNING_FACTOR, std::move (l));
      }
#else
      static
      symbol_type
      make_THINNING_FACTOR (const location_type& l)
      {
        return symbol_type (token::THINNING_FACTOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COEFFICIENTS_PRIOR_HYPERPARAMETERS (location_type l)
      {
        return symbol_type (token::COEFFICIENTS_PRIOR_HYPERPARAMETERS, std::move (l));
      }
#else
      static
      symbol_type
      make_COEFFICIENTS_PRIOR_HYPERPARAMETERS (const location_type& l)
      {
        return symbol_type (token::COEFFICIENTS_PRIOR_HYPERPARAMETERS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONVERGENCE_STARTING_VALUE (location_type l)
      {
        return symbol_type (token::CONVERGENCE_STARTING_VALUE, std::move (l));
      }
#else
      static
      symbol_type
      make_CONVERGENCE_STARTING_VALUE (const location_type& l)
      {
        return symbol_type (token::CONVERGENCE_STARTING_VALUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONVERGENCE_ENDING_VALUE (location_type l)
      {
        return symbol_type (token::CONVERGENCE_ENDING_VALUE, std::move (l));
      }
#else
      static
      symbol_type
      make_CONVERGENCE_ENDING_VALUE (const location_type& l)
      {
        return symbol_type (token::CONVERGENCE_ENDING_VALUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONVERGENCE_INCREMENT_VALUE (location_type l)
      {
        return symbol_type (token::CONVERGENCE_INCREMENT_VALUE, std::move (l));
      }
#else
      static
      symbol_type
      make_CONVERGENCE_INCREMENT_VALUE (const location_type& l)
      {
        return symbol_type (token::CONVERGENCE_INCREMENT_VALUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX_ITERATIONS_STARTING_VALUE (location_type l)
      {
        return symbol_type (token::MAX_ITERATIONS_STARTING_VALUE, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX_ITERATIONS_STARTING_VALUE (const location_type& l)
      {
        return symbol_type (token::MAX_ITERATIONS_STARTING_VALUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX_ITERATIONS_INCREMENT_VALUE (location_type l)
      {
        return symbol_type (token::MAX_ITERATIONS_INCREMENT_VALUE, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX_ITERATIONS_INCREMENT_VALUE (const location_type& l)
      {
        return symbol_type (token::MAX_ITERATIONS_INCREMENT_VALUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX_BLOCK_ITERATIONS (location_type l)
      {
        return symbol_type (token::MAX_BLOCK_ITERATIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX_BLOCK_ITERATIONS (const location_type& l)
      {
        return symbol_type (token::MAX_BLOCK_ITERATIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX_REPEATED_OPTIMIZATION_RUNS (location_type l)
      {
        return symbol_type (token::MAX_REPEATED_OPTIMIZATION_RUNS, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX_REPEATED_OPTIMIZATION_RUNS (const location_type& l)
      {
        return symbol_type (token::MAX_REPEATED_OPTIMIZATION_RUNS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FUNCTION_CONVERGENCE_CRITERION (location_type l)
      {
        return symbol_type (token::FUNCTION_CONVERGENCE_CRITERION, std::move (l));
      }
#else
      static
      symbol_type
      make_FUNCTION_CONVERGENCE_CRITERION (const location_type& l)
      {
        return symbol_type (token::FUNCTION_CONVERGENCE_CRITERION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SAVE_REALTIME (location_type l)
      {
        return symbol_type (token::SAVE_REALTIME, std::move (l));
      }
#else
      static
      symbol_type
      make_SAVE_REALTIME (const location_type& l)
      {
        return symbol_type (token::SAVE_REALTIME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PARAMETER_CONVERGENCE_CRITERION (location_type l)
      {
        return symbol_type (token::PARAMETER_CONVERGENCE_CRITERION, std::move (l));
      }
#else
      static
      symbol_type
      make_PARAMETER_CONVERGENCE_CRITERION (const location_type& l)
      {
        return symbol_type (token::PARAMETER_CONVERGENCE_CRITERION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NUMBER_OF_LARGE_PERTURBATIONS (location_type l)
      {
        return symbol_type (token::NUMBER_OF_LARGE_PERTURBATIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_NUMBER_OF_LARGE_PERTURBATIONS (const location_type& l)
      {
        return symbol_type (token::NUMBER_OF_LARGE_PERTURBATIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NUMBER_OF_SMALL_PERTURBATIONS (location_type l)
      {
        return symbol_type (token::NUMBER_OF_SMALL_PERTURBATIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_NUMBER_OF_SMALL_PERTURBATIONS (const location_type& l)
      {
        return symbol_type (token::NUMBER_OF_SMALL_PERTURBATIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NUMBER_OF_POSTERIOR_DRAWS_AFTER_PERTURBATION (location_type l)
      {
        return symbol_type (token::NUMBER_OF_POSTERIOR_DRAWS_AFTER_PERTURBATION, std::move (l));
      }
#else
      static
      symbol_type
      make_NUMBER_OF_POSTERIOR_DRAWS_AFTER_PERTURBATION (const location_type& l)
      {
        return symbol_type (token::NUMBER_OF_POSTERIOR_DRAWS_AFTER_PERTURBATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX_NUMBER_OF_STAGES (location_type l)
      {
        return symbol_type (token::MAX_NUMBER_OF_STAGES, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX_NUMBER_OF_STAGES (const location_type& l)
      {
        return symbol_type (token::MAX_NUMBER_OF_STAGES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RANDOM_FUNCTION_CONVERGENCE_CRITERION (location_type l)
      {
        return symbol_type (token::RANDOM_FUNCTION_CONVERGENCE_CRITERION, std::move (l));
      }
#else
      static
      symbol_type
      make_RANDOM_FUNCTION_CONVERGENCE_CRITERION (const location_type& l)
      {
        return symbol_type (token::RANDOM_FUNCTION_CONVERGENCE_CRITERION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RANDOM_PARAMETER_CONVERGENCE_CRITERION (location_type l)
      {
        return symbol_type (token::RANDOM_PARAMETER_CONVERGENCE_CRITERION, std::move (l));
      }
#else
      static
      symbol_type
      make_RANDOM_PARAMETER_CONVERGENCE_CRITERION (const location_type& l)
      {
        return symbol_type (token::RANDOM_PARAMETER_CONVERGENCE_CRITERION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_INIT_ESTIMATION_CHECK_FIRST_OBS (location_type l)
      {
        return symbol_type (token::NO_INIT_ESTIMATION_CHECK_FIRST_OBS, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_INIT_ESTIMATION_CHECK_FIRST_OBS (const location_type& l)
      {
        return symbol_type (token::NO_INIT_ESTIMATION_CHECK_FIRST_OBS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HETEROSKEDASTIC_FILTER (location_type l)
      {
        return symbol_type (token::HETEROSKEDASTIC_FILTER, std::move (l));
      }
#else
      static
      symbol_type
      make_HETEROSKEDASTIC_FILTER (const location_type& l)
      {
        return symbol_type (token::HETEROSKEDASTIC_FILTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TIME_SHIFT (location_type l)
      {
        return symbol_type (token::TIME_SHIFT, std::move (l));
      }
#else
      static
      symbol_type
      make_TIME_SHIFT (const location_type& l)
      {
        return symbol_type (token::TIME_SHIFT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STRUCTURAL (location_type l)
      {
        return symbol_type (token::STRUCTURAL, std::move (l));
      }
#else
      static
      symbol_type
      make_STRUCTURAL (const location_type& l)
      {
        return symbol_type (token::STRUCTURAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TERMINAL_STEADY_STATE_AS_GUESS_VALUE (location_type l)
      {
        return symbol_type (token::TERMINAL_STEADY_STATE_AS_GUESS_VALUE, std::move (l));
      }
#else
      static
      symbol_type
      make_TERMINAL_STEADY_STATE_AS_GUESS_VALUE (const location_type& l)
      {
        return symbol_type (token::TERMINAL_STEADY_STATE_AS_GUESS_VALUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SURPRISE (location_type l)
      {
        return symbol_type (token::SURPRISE, std::move (l));
      }
#else
      static
      symbol_type
      make_SURPRISE (const location_type& l)
      {
        return symbol_type (token::SURPRISE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OCCBIN_CONSTRAINTS (location_type l)
      {
        return symbol_type (token::OCCBIN_CONSTRAINTS, std::move (l));
      }
#else
      static
      symbol_type
      make_OCCBIN_CONSTRAINTS (const location_type& l)
      {
        return symbol_type (token::OCCBIN_CONSTRAINTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_METHOD_OF_MOMENTS (location_type l)
      {
        return symbol_type (token::METHOD_OF_MOMENTS, std::move (l));
      }
#else
      static
      symbol_type
      make_METHOD_OF_MOMENTS (const location_type& l)
      {
        return symbol_type (token::METHOD_OF_MOMENTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MOM_METHOD (location_type l)
      {
        return symbol_type (token::MOM_METHOD, std::move (l));
      }
#else
      static
      symbol_type
      make_MOM_METHOD (const location_type& l)
      {
        return symbol_type (token::MOM_METHOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BARTLETT_KERNEL_LAG (location_type l)
      {
        return symbol_type (token::BARTLETT_KERNEL_LAG, std::move (l));
      }
#else
      static
      symbol_type
      make_BARTLETT_KERNEL_LAG (const location_type& l)
      {
        return symbol_type (token::BARTLETT_KERNEL_LAG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WEIGHTING_MATRIX (location_type l)
      {
        return symbol_type (token::WEIGHTING_MATRIX, std::move (l));
      }
#else
      static
      symbol_type
      make_WEIGHTING_MATRIX (const location_type& l)
      {
        return symbol_type (token::WEIGHTING_MATRIX, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WEIGHTING_MATRIX_SCALING_FACTOR (location_type l)
      {
        return symbol_type (token::WEIGHTING_MATRIX_SCALING_FACTOR, std::move (l));
      }
#else
      static
      symbol_type
      make_WEIGHTING_MATRIX_SCALING_FACTOR (const location_type& l)
      {
        return symbol_type (token::WEIGHTING_MATRIX_SCALING_FACTOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ANALYTIC_STANDARD_ERRORS (location_type l)
      {
        return symbol_type (token::ANALYTIC_STANDARD_ERRORS, std::move (l));
      }
#else
      static
      symbol_type
      make_ANALYTIC_STANDARD_ERRORS (const location_type& l)
      {
        return symbol_type (token::ANALYTIC_STANDARD_ERRORS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ANALYTIC_JACOBIAN (location_type l)
      {
        return symbol_type (token::ANALYTIC_JACOBIAN, std::move (l));
      }
#else
      static
      symbol_type
      make_ANALYTIC_JACOBIAN (const location_type& l)
      {
        return symbol_type (token::ANALYTIC_JACOBIAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PENALIZED_ESTIMATOR (location_type l)
      {
        return symbol_type (token::PENALIZED_ESTIMATOR, std::move (l));
      }
#else
      static
      symbol_type
      make_PENALIZED_ESTIMATOR (const location_type& l)
      {
        return symbol_type (token::PENALIZED_ESTIMATOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VERBOSE (location_type l)
      {
        return symbol_type (token::VERBOSE, std::move (l));
      }
#else
      static
      symbol_type
      make_VERBOSE (const location_type& l)
      {
        return symbol_type (token::VERBOSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMULATION_MULTIPLE (location_type l)
      {
        return symbol_type (token::SIMULATION_MULTIPLE, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMULATION_MULTIPLE (const location_type& l)
      {
        return symbol_type (token::SIMULATION_MULTIPLE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MOM_SEED (location_type l)
      {
        return symbol_type (token::MOM_SEED, std::move (l));
      }
#else
      static
      symbol_type
      make_MOM_SEED (const location_type& l)
      {
        return symbol_type (token::MOM_SEED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SEED (location_type l)
      {
        return symbol_type (token::SEED, std::move (l));
      }
#else
      static
      symbol_type
      make_SEED (const location_type& l)
      {
        return symbol_type (token::SEED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BOUNDED_SHOCK_SUPPORT (location_type l)
      {
        return symbol_type (token::BOUNDED_SHOCK_SUPPORT, std::move (l));
      }
#else
      static
      symbol_type
      make_BOUNDED_SHOCK_SUPPORT (const location_type& l)
      {
        return symbol_type (token::BOUNDED_SHOCK_SUPPORT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ADDITIONAL_OPTIMIZER_STEPS (location_type l)
      {
        return symbol_type (token::ADDITIONAL_OPTIMIZER_STEPS, std::move (l));
      }
#else
      static
      symbol_type
      make_ADDITIONAL_OPTIMIZER_STEPS (const location_type& l)
      {
        return symbol_type (token::ADDITIONAL_OPTIMIZER_STEPS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MOM_SE_TOLX (location_type l)
      {
        return symbol_type (token::MOM_SE_TOLX, std::move (l));
      }
#else
      static
      symbol_type
      make_MOM_SE_TOLX (const location_type& l)
      {
        return symbol_type (token::MOM_SE_TOLX, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SE_TOLX (location_type l)
      {
        return symbol_type (token::SE_TOLX, std::move (l));
      }
#else
      static
      symbol_type
      make_SE_TOLX (const location_type& l)
      {
        return symbol_type (token::SE_TOLX, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MOM_BURNIN (location_type l)
      {
        return symbol_type (token::MOM_BURNIN, std::move (l));
      }
#else
      static
      symbol_type
      make_MOM_BURNIN (const location_type& l)
      {
        return symbol_type (token::MOM_BURNIN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BURNIN (location_type l)
      {
        return symbol_type (token::BURNIN, std::move (l));
      }
#else
      static
      symbol_type
      make_BURNIN (const location_type& l)
      {
        return symbol_type (token::BURNIN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQTAGS (location_type l)
      {
        return symbol_type (token::EQTAGS, std::move (l));
      }
#else
      static
      symbol_type
      make_EQTAGS (const location_type& l)
      {
        return symbol_type (token::EQTAGS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ANALYTICAL_GIRF (location_type l)
      {
        return symbol_type (token::ANALYTICAL_GIRF, std::move (l));
      }
#else
      static
      symbol_type
      make_ANALYTICAL_GIRF (const location_type& l)
      {
        return symbol_type (token::ANALYTICAL_GIRF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IRF_IN_PERCENT (location_type l)
      {
        return symbol_type (token::IRF_IN_PERCENT, std::move (l));
      }
#else
      static
      symbol_type
      make_IRF_IN_PERCENT (const location_type& l)
      {
        return symbol_type (token::IRF_IN_PERCENT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EMAS_GIRF (location_type l)
      {
        return symbol_type (token::EMAS_GIRF, std::move (l));
      }
#else
      static
      symbol_type
      make_EMAS_GIRF (const location_type& l)
      {
        return symbol_type (token::EMAS_GIRF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EMAS_DROP (location_type l)
      {
        return symbol_type (token::EMAS_DROP, std::move (l));
      }
#else
      static
      symbol_type
      make_EMAS_DROP (const location_type& l)
      {
        return symbol_type (token::EMAS_DROP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EMAS_TOLF (location_type l)
      {
        return symbol_type (token::EMAS_TOLF, std::move (l));
      }
#else
      static
      symbol_type
      make_EMAS_TOLF (const location_type& l)
      {
        return symbol_type (token::EMAS_TOLF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EMAS_MAX_ITER (location_type l)
      {
        return symbol_type (token::EMAS_MAX_ITER, std::move (l));
      }
#else
      static
      symbol_type
      make_EMAS_MAX_ITER (const location_type& l)
      {
        return symbol_type (token::EMAS_MAX_ITER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_IDENTIFICATION_STRENGTH (location_type l)
      {
        return symbol_type (token::NO_IDENTIFICATION_STRENGTH, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_IDENTIFICATION_STRENGTH (const location_type& l)
      {
        return symbol_type (token::NO_IDENTIFICATION_STRENGTH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_IDENTIFICATION_REDUCEDFORM (location_type l)
      {
        return symbol_type (token::NO_IDENTIFICATION_REDUCEDFORM, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_IDENTIFICATION_REDUCEDFORM (const location_type& l)
      {
        return symbol_type (token::NO_IDENTIFICATION_REDUCEDFORM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_IDENTIFICATION_MOMENTS (location_type l)
      {
        return symbol_type (token::NO_IDENTIFICATION_MOMENTS, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_IDENTIFICATION_MOMENTS (const location_type& l)
      {
        return symbol_type (token::NO_IDENTIFICATION_MOMENTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_IDENTIFICATION_MINIMAL (location_type l)
      {
        return symbol_type (token::NO_IDENTIFICATION_MINIMAL, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_IDENTIFICATION_MINIMAL (const location_type& l)
      {
        return symbol_type (token::NO_IDENTIFICATION_MINIMAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_IDENTIFICATION_SPECTRUM (location_type l)
      {
        return symbol_type (token::NO_IDENTIFICATION_SPECTRUM, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_IDENTIFICATION_SPECTRUM (const location_type& l)
      {
        return symbol_type (token::NO_IDENTIFICATION_SPECTRUM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NORMALIZE_JACOBIANS (location_type l)
      {
        return symbol_type (token::NORMALIZE_JACOBIANS, std::move (l));
      }
#else
      static
      symbol_type
      make_NORMALIZE_JACOBIANS (const location_type& l)
      {
        return symbol_type (token::NORMALIZE_JACOBIANS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GRID_NBR (location_type l)
      {
        return symbol_type (token::GRID_NBR, std::move (l));
      }
#else
      static
      symbol_type
      make_GRID_NBR (const location_type& l)
      {
        return symbol_type (token::GRID_NBR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TOL_RANK (location_type l)
      {
        return symbol_type (token::TOL_RANK, std::move (l));
      }
#else
      static
      symbol_type
      make_TOL_RANK (const location_type& l)
      {
        return symbol_type (token::TOL_RANK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TOL_DERIV (location_type l)
      {
        return symbol_type (token::TOL_DERIV, std::move (l));
      }
#else
      static
      symbol_type
      make_TOL_DERIV (const location_type& l)
      {
        return symbol_type (token::TOL_DERIV, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TOL_SV (location_type l)
      {
        return symbol_type (token::TOL_SV, std::move (l));
      }
#else
      static
      symbol_type
      make_TOL_SV (const location_type& l)
      {
        return symbol_type (token::TOL_SV, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CHECKS_VIA_SUBSETS (location_type l)
      {
        return symbol_type (token::CHECKS_VIA_SUBSETS, std::move (l));
      }
#else
      static
      symbol_type
      make_CHECKS_VIA_SUBSETS (const location_type& l)
      {
        return symbol_type (token::CHECKS_VIA_SUBSETS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX_DIM_SUBSETS_GROUPS (location_type l)
      {
        return symbol_type (token::MAX_DIM_SUBSETS_GROUPS, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX_DIM_SUBSETS_GROUPS (const location_type& l)
      {
        return symbol_type (token::MAX_DIM_SUBSETS_GROUPS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ZERO_MOMENTS_TOLERANCE (location_type l)
      {
        return symbol_type (token::ZERO_MOMENTS_TOLERANCE, std::move (l));
      }
#else
      static
      symbol_type
      make_ZERO_MOMENTS_TOLERANCE (const location_type& l)
      {
        return symbol_type (token::ZERO_MOMENTS_TOLERANCE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX_NROWS (location_type l)
      {
        return symbol_type (token::MAX_NROWS, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX_NROWS (const location_type& l)
      {
        return symbol_type (token::MAX_NROWS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SQUEEZE_SHOCK_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::SQUEEZE_SHOCK_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_SQUEEZE_SHOCK_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::SQUEEZE_SHOCK_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WITH_EPILOGUE (location_type l)
      {
        return symbol_type (token::WITH_EPILOGUE, std::move (l));
      }
#else
      static
      symbol_type
      make_WITH_EPILOGUE (const location_type& l)
      {
        return symbol_type (token::WITH_EPILOGUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STATIC (location_type l)
      {
        return symbol_type (token::STATIC, std::move (l));
      }
#else
      static
      symbol_type
      make_STATIC (const location_type& l)
      {
        return symbol_type (token::STATIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INCIDENCE (location_type l)
      {
        return symbol_type (token::INCIDENCE, std::move (l));
      }
#else
      static
      symbol_type
      make_INCIDENCE (const location_type& l)
      {
        return symbol_type (token::INCIDENCE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SYMBOL_VEC (vector<string> v, location_type l)
      {
        return symbol_type (token::SYMBOL_VEC, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_SYMBOL_VEC (const vector<string>& v, const location_type& l)
      {
        return symbol_type (token::SYMBOL_VEC, v, l);
      }
#endif


    class context
    {
    public:
      context (const parser& yyparser, const symbol_type& yyla);
      const symbol_type& lookahead () const YY_NOEXCEPT { return yyla_; }
      symbol_kind_type token () const YY_NOEXCEPT { return yyla_.kind (); }
      const location_type& location () const YY_NOEXCEPT { return yyla_.location; }

      /// Put in YYARG at most YYARGN of the expected tokens, and return the
      /// number of tokens stored in YYARG.  If YYARG is null, return the
      /// number of expected tokens (guaranteed to be less than YYNTOKENS).
      int expected_tokens (symbol_kind_type yyarg[], int yyargn) const;

    private:
      const parser& yyparser_;
      const symbol_type& yyla_;
    };

  private:
#if YY_CPLUSPLUS < 201103L
    /// Non copyable.
    parser (const parser&);
    /// Non copyable.
    parser& operator= (const parser&);
#endif


    /// Stored state numbers (used for stacks).
    typedef short state_type;

    /// The arguments of the error message.
    int yy_syntax_error_arguments_ (const context& yyctx,
                                    symbol_kind_type yyarg[], int yyargn) const;

    /// Generate an error message.
    /// \param yyctx     the context in which the error occurred.
    virtual std::string yysyntax_error_ (const context& yyctx) const;
    /// Compute post-reduction state.
    /// \param yystate   the current state
    /// \param yysym     the nonterminal to push on the stack
    static state_type yy_lr_goto_state_ (state_type yystate, int yysym);

    /// Whether the given \c yypact_ value indicates a defaulted state.
    /// \param yyvalue   the value to check
    static bool yy_pact_value_is_default_ (int yyvalue);

    /// Whether the given \c yytable_ value indicates a syntax error.
    /// \param yyvalue   the value to check
    static bool yy_table_value_is_error_ (int yyvalue);

    static const short yypact_ninf_;
    static const short yytable_ninf_;

    /// Convert a scanner token kind \a t to a symbol kind.
    /// In theory \a t should be a token_kind_type, but character literals
    /// are valid, yet not members of the token_type enum.
    static symbol_kind_type yytranslate_ (int t);

    /// Convert the symbol name \a n to a form suitable for a diagnostic.
    static std::string yytnamerr_ (const char *yystr);

    /// For a symbol, its name in clear.
    static const char* const yytname_[];


    // Tables.
    // YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
    // STATE-NUM.
    static const short yypact_[];

    // YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
    // Performed when YYTABLE does not specify something else to do.  Zero
    // means the default is an error.
    static const short yydefact_[];

    // YYPGOTO[NTERM-NUM].
    static const short yypgoto_[];

    // YYDEFGOTO[NTERM-NUM].
    static const short yydefgoto_[];

    // YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
    // positive, shift that token.  If negative, reduce the rule whose
    // number is the opposite.  If YYTABLE_NINF, syntax error.
    static const short yytable_[];

    static const short yycheck_[];

    // YYSTOS[STATE-NUM] -- The (internal number of the) accessing
    // symbol of state STATE-NUM.
    static const short yystos_[];

    // YYR1[YYN] -- Symbol number of symbol that rule YYN derives.
    static const short yyr1_[];

    // YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.
    static const signed char yyr2_[];


#if YYDEBUG
    // YYRLINE[YYN] -- Source line where rule number YYN was defined.
    static const short yyrline_[];
    /// Report on the debug stream that the rule \a r is going to be reduced.
    virtual void yy_reduce_print_ (int r) const;
    /// Print the state stack on the debug stream.
    virtual void yy_stack_print_ () const;

    /// Debugging level.
    int yydebug_;
    /// Debug stream.
    std::ostream* yycdebug_;

    /// \brief Display a symbol kind, value and location.
    /// \param yyo    The output stream.
    /// \param yysym  The symbol.
    template <typename Base>
    void yy_print_ (std::ostream& yyo, const basic_symbol<Base>& yysym) const;
#endif

    /// \brief Reclaim the memory associated to a symbol.
    /// \param yymsg     Why this token is reclaimed.
    ///                  If null, print nothing.
    /// \param yysym     The symbol.
    template <typename Base>
    void yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const;

  private:
    /// Type access provider for state based symbols.
    struct by_state
    {
      /// Default constructor.
      by_state () YY_NOEXCEPT;

      /// The symbol kind as needed by the constructor.
      typedef state_type kind_type;

      /// Constructor.
      by_state (kind_type s) YY_NOEXCEPT;

      /// Copy constructor.
      by_state (const by_state& that) YY_NOEXCEPT;

      /// Record that this symbol is empty.
      void clear () YY_NOEXCEPT;

      /// Steal the symbol kind from \a that.
      void move (by_state& that);

      /// The symbol kind (corresponding to \a state).
      /// \a symbol_kind::S_YYEMPTY when empty.
      symbol_kind_type kind () const YY_NOEXCEPT;

      /// The state number used to denote an empty symbol.
      /// We use the initial state, as it does not have a value.
      enum { empty_state = 0 };

      /// The state.
      /// \a empty when empty.
      state_type state;
    };

    /// "Internal" symbol: element of the stack.
    struct stack_symbol_type : basic_symbol<by_state>
    {
      /// Superclass.
      typedef basic_symbol<by_state> super_type;
      /// Construct an empty symbol.
      stack_symbol_type ();
      /// Move or copy construction.
      stack_symbol_type (YY_RVREF (stack_symbol_type) that);
      /// Steal the contents from \a sym to build this.
      stack_symbol_type (state_type s, YY_MOVE_REF (symbol_type) sym);
#if YY_CPLUSPLUS < 201103L
      /// Assignment, needed by push_back by some old implementations.
      /// Moves the contents of that.
      stack_symbol_type& operator= (stack_symbol_type& that);

      /// Assignment, needed by push_back by other implementations.
      /// Needed by some other old implementations.
      stack_symbol_type& operator= (const stack_symbol_type& that);
#endif
    };

    /// A stack with random access from its top.
    template <typename T, typename S = std::vector<T> >
    class stack
    {
    public:
      // Hide our reversed order.
      typedef typename S::iterator iterator;
      typedef typename S::const_iterator const_iterator;
      typedef typename S::size_type size_type;
      typedef typename std::ptrdiff_t index_type;

      stack (size_type n = 200)
        : seq_ (n)
      {}

#if 201103L <= YY_CPLUSPLUS
      /// Non copyable.
      stack (const stack&) = delete;
      /// Non copyable.
      stack& operator= (const stack&) = delete;
#endif

      /// Random access.
      ///
      /// Index 0 returns the topmost element.
      const T&
      operator[] (index_type i) const
      {
        return seq_[size_type (size () - 1 - i)];
      }

      /// Random access.
      ///
      /// Index 0 returns the topmost element.
      T&
      operator[] (index_type i)
      {
        return seq_[size_type (size () - 1 - i)];
      }

      /// Steal the contents of \a t.
      ///
      /// Close to move-semantics.
      void
      push (YY_MOVE_REF (T) t)
      {
        seq_.push_back (T ());
        operator[] (0).move (t);
      }

      /// Pop elements from the stack.
      void
      pop (std::ptrdiff_t n = 1) YY_NOEXCEPT
      {
        for (; 0 < n; --n)
          seq_.pop_back ();
      }

      /// Pop all elements from the stack.
      void
      clear () YY_NOEXCEPT
      {
        seq_.clear ();
      }

      /// Number of elements on the stack.
      index_type
      size () const YY_NOEXCEPT
      {
        return index_type (seq_.size ());
      }

      /// Iterator on top of the stack (going downwards).
      const_iterator
      begin () const YY_NOEXCEPT
      {
        return seq_.begin ();
      }

      /// Bottom of the stack.
      const_iterator
      end () const YY_NOEXCEPT
      {
        return seq_.end ();
      }

      /// Present a slice of the top of a stack.
      class slice
      {
      public:
        slice (const stack& stack, index_type range)
          : stack_ (stack)
          , range_ (range)
        {}

        const T&
        operator[] (index_type i) const
        {
          return stack_[range_ - i];
        }

      private:
        const stack& stack_;
        index_type range_;
      };

    private:
#if YY_CPLUSPLUS < 201103L
      /// Non copyable.
      stack (const stack&);
      /// Non copyable.
      stack& operator= (const stack&);
#endif
      /// The wrapped container.
      S seq_;
    };


    /// Stack type.
    typedef stack<stack_symbol_type> stack_type;

    /// The stack.
    stack_type yystack_;

    /// Push a new state on the stack.
    /// \param m    a debug message to display
    ///             if null, no trace is output.
    /// \param sym  the symbol
    /// \warning the contents of \a s.value is stolen.
    void yypush_ (const char* m, YY_MOVE_REF (stack_symbol_type) sym);

    /// Push a new look ahead token on the state on the stack.
    /// \param m    a debug message to display
    ///             if null, no trace is output.
    /// \param s    the state
    /// \param sym  the symbol (for its value and location).
    /// \warning the contents of \a sym.value is stolen.
    void yypush_ (const char* m, state_type s, YY_MOVE_REF (symbol_type) sym);

    /// Pop \a n symbols from the stack.
    void yypop_ (int n = 1);

    /// Constants.
    enum
    {
      yylast_ = 17121,     ///< Last index in yytable_.
      yynnts_ = 887,  ///< Number of nonterminal symbols.
      yyfinal_ = 470 ///< Termination state number.
    };


    // User arguments.
    ParsingDriver &driver;

  };


#line 25 "DynareBison.yy"
} // Dynare
#line 14641 "DynareBison.hh"




#endif // !YY_YY_DYNAREBISON_HH_INCLUDED
