// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file calculatorCdrAux.ipp
 * This source file contains some declarations of CDR related functions.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__CALCULATORCDRAUX_IPP
#define FAST_DDS_GENERATED__CALCULATORCDRAUX_IPP

#include "calculatorCdrAux.hpp"

#include <fastcdr/Cdr.h>
#include <fastcdr/CdrSizeCalculator.hpp>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

namespace eprosima {
namespace fastcdr {

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const calculator_example::OverflowException& data,
        size_t& current_alignment)
{
    using namespace calculator_example;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};

    std::string msg = data.what();
    calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0), msg, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const calculator_example::OverflowException& data)
{
    using namespace calculator_example;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr << eprosima::fastcdr::MemberId(0) << data.what();
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        calculator_example::OverflowException& data)
{
    using namespace calculator_example;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                    case 0:
                    {
                        std::string msg;
                        dcdr >> msg;
                        calculator_example::OverflowException tmp{msg};
                        data = tmp;
                        break;
                    }

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

//{ calculator_example::Calculator interface

//{ representation_limits
// Serialization methods for calculator_example::detail::Calculator_representation_limits_In
/*
struct Calculator_representation_limits_In
{
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_representation_limits_In& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};



    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_representation_limits_In& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    static_cast<void>(data);

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_representation_limits_In& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                static_cast<void>(data);
                static_cast<void>(dcdr);
                static_cast<void>(mid);
                return false;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_representation_limits_In& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}


// Serialization methods for calculator_example::detail::Calculator_representation_limits_Out
/*
struct Calculator_representation_limits_Out
{
    int32_t min_value;
    int32_t max_value;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_representation_limits_Out& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.min_value, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.max_value, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_representation_limits_Out& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.min_value
        << eprosima::fastcdr::MemberId(1) << data.max_value
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_representation_limits_Out& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.min_value;
                                            break;

                                        case 1:
                                                dcdr >> data.max_value;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_representation_limits_Out& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

// Serialization methods for calculator_example::detail::Calculator_representation_limits_Result
/*
struct Calculator_representation_limits_Result
{
    eprosima::fastcdr::optional<Calculator_representation_limits_Out> result;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_representation_limits_Result& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0784a8b4),
                data.result, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_representation_limits_Result& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x0784a8b4) << data.result
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_representation_limits_Result& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x0784a8b4:
                                                dcdr >> data.result;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_representation_limits_Result& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

//}  // representation_limits
 
//{ addition
// Serialization methods for calculator_example::detail::Calculator_addition_In
/*
struct Calculator_addition_In
{
    int32_t value1; 
    int32_t value2; 
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_addition_In& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.value1, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.value2, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_addition_In& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.value1
        << eprosima::fastcdr::MemberId(1) << data.value2
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_addition_In& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.value1;
                                            break;

                                        case 1:
                                                dcdr >> data.value2;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_addition_In& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

  

// Serialization methods for calculator_example::detail::Calculator_addition_Out
/*
struct Calculator_addition_Out
{
    int32_t return_;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_addition_Out& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.return_, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_addition_Out& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.return_
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_addition_Out& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.return_;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_addition_Out& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

// Serialization methods for calculator_example::detail::Calculator_addition_Result
/*
struct Calculator_addition_Result
{
    eprosima::fastcdr::optional<Calculator_addition_Out> result;
    eprosima::fastcdr::optional<calculator_example::OverflowException> calculator_example_OverflowException_ex;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_addition_Result& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0784a8b4),
                data.result, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0d39fcce),
                data.calculator_example_OverflowException_ex, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_addition_Result& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x0784a8b4) << data.result
        << eprosima::fastcdr::MemberId(0x0d39fcce) << data.calculator_example_OverflowException_ex
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_addition_Result& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x0784a8b4:
                                                dcdr >> data.result;
                                            break;

                                        case 0x0d39fcce:
                                                dcdr >> data.calculator_example_OverflowException_ex;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_addition_Result& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

//}  // addition
 
//{ subtraction
// Serialization methods for calculator_example::detail::Calculator_subtraction_In
/*
struct Calculator_subtraction_In
{
    int32_t value1; 
    int32_t value2; 
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_subtraction_In& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.value1, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.value2, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_subtraction_In& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.value1
        << eprosima::fastcdr::MemberId(1) << data.value2
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_subtraction_In& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.value1;
                                            break;

                                        case 1:
                                                dcdr >> data.value2;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_subtraction_In& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

  

// Serialization methods for calculator_example::detail::Calculator_subtraction_Out
/*
struct Calculator_subtraction_Out
{
    int32_t return_;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_subtraction_Out& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.return_, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_subtraction_Out& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.return_
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_subtraction_Out& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.return_;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_subtraction_Out& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

// Serialization methods for calculator_example::detail::Calculator_subtraction_Result
/*
struct Calculator_subtraction_Result
{
    eprosima::fastcdr::optional<Calculator_subtraction_Out> result;
    eprosima::fastcdr::optional<calculator_example::OverflowException> calculator_example_OverflowException_ex;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_subtraction_Result& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0784a8b4),
                data.result, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0d39fcce),
                data.calculator_example_OverflowException_ex, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_subtraction_Result& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x0784a8b4) << data.result
        << eprosima::fastcdr::MemberId(0x0d39fcce) << data.calculator_example_OverflowException_ex
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_subtraction_Result& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x0784a8b4:
                                                dcdr >> data.result;
                                            break;

                                        case 0x0d39fcce:
                                                dcdr >> data.calculator_example_OverflowException_ex;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_subtraction_Result& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

//}  // subtraction
 
//{ fibonacci_seq
// Serialization methods for calculator_example::detail::Calculator_fibonacci_seq_In
/*
struct Calculator_fibonacci_seq_In
{
    uint32_t n_results; 
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_fibonacci_seq_In& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.n_results, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_fibonacci_seq_In& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.n_results
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_fibonacci_seq_In& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.n_results;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_fibonacci_seq_In& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

 

// Serialization methods for calculator_example::detail::Calculator_fibonacci_seq_Out
/*
struct Calculator_fibonacci_seq_Out
{
    eprosima::fastcdr::optional<int32_t> return_;
    eprosima::fastcdr::optional<bool> finished_;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_fibonacci_seq_Out& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.return_, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.finished_, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_fibonacci_seq_Out& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.return_
        << eprosima::fastcdr::MemberId(1) << data.finished_
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_fibonacci_seq_Out& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.return_;
                                            break;

                                        case 1:
                                                dcdr >> data.finished_;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_fibonacci_seq_Out& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

// Serialization methods for calculator_example::detail::Calculator_fibonacci_seq_Result
/*
struct Calculator_fibonacci_seq_Result
{
    eprosima::fastcdr::optional<Calculator_fibonacci_seq_Out> result;
    eprosima::fastcdr::optional<calculator_example::OverflowException> calculator_example_OverflowException_ex;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_fibonacci_seq_Result& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0784a8b4),
                data.result, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0d39fcce),
                data.calculator_example_OverflowException_ex, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_fibonacci_seq_Result& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x0784a8b4) << data.result
        << eprosima::fastcdr::MemberId(0x0d39fcce) << data.calculator_example_OverflowException_ex
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_fibonacci_seq_Result& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x0784a8b4:
                                                dcdr >> data.result;
                                            break;

                                        case 0x0d39fcce:
                                                dcdr >> data.calculator_example_OverflowException_ex;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_fibonacci_seq_Result& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

//}  // fibonacci_seq
 
//{ sum_all
// Serialization methods for calculator_example::detail::Calculator_sum_all_In
/*
struct Calculator_sum_all_In
{
     
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_sum_all_In& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};



    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_sum_all_In& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    static_cast<void>(data);

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_sum_all_In& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                static_cast<void>(data);
                static_cast<void>(dcdr);
                static_cast<void>(mid);
                return false;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_sum_all_In& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

// Serialization methods for calculator_example::detail::Calculator_sum_all_value_Feed
/*
struct Calculator_sum_all_value_Feed
{
    eprosima::fastcdr::optional<int32_t> value;
    eprosima::fastcdr::optional<eprosima::fastdds::dds::rpc::RpcStatusCode> finished_;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_sum_all_value_Feed& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.value, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.finished_, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_sum_all_value_Feed& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.value
        << eprosima::fastcdr::MemberId(1) << data.finished_
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_sum_all_value_Feed& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.value;
                                            break;

                                        case 1:
                                                dcdr >> data.finished_;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_sum_all_value_Feed& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
} 

// Serialization methods for calculator_example::detail::Calculator_sum_all_Out
/*
struct Calculator_sum_all_Out
{
    int32_t return_;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_sum_all_Out& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.return_, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_sum_all_Out& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.return_
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_sum_all_Out& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.return_;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_sum_all_Out& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

// Serialization methods for calculator_example::detail::Calculator_sum_all_Result
/*
struct Calculator_sum_all_Result
{
    eprosima::fastcdr::optional<Calculator_sum_all_Out> result;
    eprosima::fastcdr::optional<calculator_example::OverflowException> calculator_example_OverflowException_ex;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_sum_all_Result& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0784a8b4),
                data.result, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0d39fcce),
                data.calculator_example_OverflowException_ex, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_sum_all_Result& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x0784a8b4) << data.result
        << eprosima::fastcdr::MemberId(0x0d39fcce) << data.calculator_example_OverflowException_ex
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_sum_all_Result& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x0784a8b4:
                                                dcdr >> data.result;
                                            break;

                                        case 0x0d39fcce:
                                                dcdr >> data.calculator_example_OverflowException_ex;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_sum_all_Result& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

//}  // sum_all
 
//{ accumulator
// Serialization methods for calculator_example::detail::Calculator_accumulator_In
/*
struct Calculator_accumulator_In
{
     
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_accumulator_In& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};



    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_accumulator_In& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    static_cast<void>(data);

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_accumulator_In& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                static_cast<void>(data);
                static_cast<void>(dcdr);
                static_cast<void>(mid);
                return false;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_accumulator_In& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

// Serialization methods for calculator_example::detail::Calculator_accumulator_value_Feed
/*
struct Calculator_accumulator_value_Feed
{
    eprosima::fastcdr::optional<int32_t> value;
    eprosima::fastcdr::optional<eprosima::fastdds::dds::rpc::RpcStatusCode> finished_;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_accumulator_value_Feed& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.value, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.finished_, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_accumulator_value_Feed& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.value
        << eprosima::fastcdr::MemberId(1) << data.finished_
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_accumulator_value_Feed& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.value;
                                            break;

                                        case 1:
                                                dcdr >> data.finished_;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_accumulator_value_Feed& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
} 

// Serialization methods for calculator_example::detail::Calculator_accumulator_Out
/*
struct Calculator_accumulator_Out
{
    eprosima::fastcdr::optional<int32_t> return_;
    eprosima::fastcdr::optional<bool> finished_;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_accumulator_Out& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.return_, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.finished_, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_accumulator_Out& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.return_
        << eprosima::fastcdr::MemberId(1) << data.finished_
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_accumulator_Out& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.return_;
                                            break;

                                        case 1:
                                                dcdr >> data.finished_;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_accumulator_Out& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

// Serialization methods for calculator_example::detail::Calculator_accumulator_Result
/*
struct Calculator_accumulator_Result
{
    eprosima::fastcdr::optional<Calculator_accumulator_Out> result;
    eprosima::fastcdr::optional<calculator_example::OverflowException> calculator_example_OverflowException_ex;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_accumulator_Result& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0784a8b4),
                data.result, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0d39fcce),
                data.calculator_example_OverflowException_ex, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_accumulator_Result& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x0784a8b4) << data.result
        << eprosima::fastcdr::MemberId(0x0d39fcce) << data.calculator_example_OverflowException_ex
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_accumulator_Result& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x0784a8b4:
                                                dcdr >> data.result;
                                            break;

                                        case 0x0d39fcce:
                                                dcdr >> data.calculator_example_OverflowException_ex;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_accumulator_Result& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

//}  // accumulator
 
//{ filter
// Serialization methods for calculator_example::detail::Calculator_filter_In
/*
struct Calculator_filter_In
{
     
    calculator_example::FilterKind filter_kind; 
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_filter_In& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.filter_kind, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_filter_In& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.filter_kind
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_filter_In& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.filter_kind;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_filter_In& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

// Serialization methods for calculator_example::detail::Calculator_filter_value_Feed
/*
struct Calculator_filter_value_Feed
{
    eprosima::fastcdr::optional<int32_t> value;
    eprosima::fastcdr::optional<eprosima::fastdds::dds::rpc::RpcStatusCode> finished_;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_filter_value_Feed& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.value, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.finished_, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_filter_value_Feed& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.value
        << eprosima::fastcdr::MemberId(1) << data.finished_
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_filter_value_Feed& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.value;
                                            break;

                                        case 1:
                                                dcdr >> data.finished_;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_filter_value_Feed& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}  

// Serialization methods for calculator_example::detail::Calculator_filter_Out
/*
struct Calculator_filter_Out
{
    eprosima::fastcdr::optional<int32_t> return_;
    eprosima::fastcdr::optional<bool> finished_;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_filter_Out& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.return_, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.finished_, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_filter_Out& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.return_
        << eprosima::fastcdr::MemberId(1) << data.finished_
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_filter_Out& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.return_;
                                            break;

                                        case 1:
                                                dcdr >> data.finished_;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_filter_Out& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

// Serialization methods for calculator_example::detail::Calculator_filter_Result
/*
struct Calculator_filter_Result
{
    eprosima::fastcdr::optional<Calculator_filter_Out> result;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_filter_Result& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0784a8b4),
                data.result, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_filter_Result& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x0784a8b4) << data.result
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_filter_Result& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x0784a8b4:
                                                dcdr >> data.result;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_filter_Result& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

//}  // filter
 

//{ top level

// Serialization methods for calculator_example::detail::Calculator_Request
/*
struct Calculator_Request
{
    eprosima::fastcdr::optional<Calculator_representation_limits_In> representation_limits; 
    eprosima::fastcdr::optional<Calculator_addition_In> addition;   
    eprosima::fastcdr::optional<Calculator_subtraction_In> subtraction;   
    eprosima::fastcdr::optional<Calculator_fibonacci_seq_In> fibonacci_seq;  
    eprosima::fastcdr::optional<Calculator_sum_all_In> sum_all;
    eprosima::fastcdr::optional<Calculator_sum_all_value_Feed> sum_all_value;  
    eprosima::fastcdr::optional<Calculator_accumulator_In> accumulator;
    eprosima::fastcdr::optional<Calculator_accumulator_value_Feed> accumulator_value;  
    eprosima::fastcdr::optional<Calculator_filter_In> filter;
    eprosima::fastcdr::optional<Calculator_filter_value_Feed> filter_value;   
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_Request& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0e205a8d),
                data.representation_limits, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x04e82a2b),
                data.addition, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x096bbc8d),
                data.subtraction, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0bad50ff),
                data.fibonacci_seq, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0635cd81),
                data.sum_all, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x04efb71e),
                data.sum_all_value, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x03d4c1bd),
                data.accumulator, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0916f618),
                data.accumulator_value, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x047ac9b2),
                data.filter, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x09fd5a08),
                data.filter_value, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0f62acde),
                data.feed_cancel_, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_Request& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x0e205a8d) << data.representation_limits
        << eprosima::fastcdr::MemberId(0x04e82a2b) << data.addition
        << eprosima::fastcdr::MemberId(0x096bbc8d) << data.subtraction
        << eprosima::fastcdr::MemberId(0x0bad50ff) << data.fibonacci_seq
        << eprosima::fastcdr::MemberId(0x0635cd81) << data.sum_all
        << eprosima::fastcdr::MemberId(0x04efb71e) << data.sum_all_value
        << eprosima::fastcdr::MemberId(0x03d4c1bd) << data.accumulator
        << eprosima::fastcdr::MemberId(0x0916f618) << data.accumulator_value
        << eprosima::fastcdr::MemberId(0x047ac9b2) << data.filter
        << eprosima::fastcdr::MemberId(0x09fd5a08) << data.filter_value
        << eprosima::fastcdr::MemberId(0x0f62acde) << data.feed_cancel_
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_Request& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x0e205a8d:
                                                dcdr >> data.representation_limits;
                                            break;

                                        case 0x04e82a2b:
                                                dcdr >> data.addition;
                                            break;

                                        case 0x096bbc8d:
                                                dcdr >> data.subtraction;
                                            break;

                                        case 0x0bad50ff:
                                                dcdr >> data.fibonacci_seq;
                                            break;

                                        case 0x0635cd81:
                                                dcdr >> data.sum_all;
                                            break;

                                        case 0x04efb71e:
                                                dcdr >> data.sum_all_value;
                                            break;

                                        case 0x03d4c1bd:
                                                dcdr >> data.accumulator;
                                            break;

                                        case 0x0916f618:
                                                dcdr >> data.accumulator_value;
                                            break;

                                        case 0x047ac9b2:
                                                dcdr >> data.filter;
                                            break;

                                        case 0x09fd5a08:
                                                dcdr >> data.filter_value;
                                            break;

                                        case 0x0f62acde:
                                                dcdr >> data.feed_cancel_;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_Request& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

// Serialization methods for calculator_example::detail::Calculator_Reply
/*
struct Calculator_Reply
{
    eprosima::fastcdr::optional<Calculator_representation_limits_Result> representation_limits; 
    eprosima::fastcdr::optional<Calculator_addition_Result> addition; 
    eprosima::fastcdr::optional<Calculator_subtraction_Result> subtraction; 
    eprosima::fastcdr::optional<Calculator_fibonacci_seq_Result> fibonacci_seq; 
    eprosima::fastcdr::optional<Calculator_sum_all_Result> sum_all; 
    eprosima::fastcdr::optional<Calculator_accumulator_Result> accumulator; 
    eprosima::fastcdr::optional<Calculator_filter_Result> filter; 
    eprosima::fastcdr::optional<eprosima::fastdds::dds::rpc::RemoteExceptionCode_t> remoteEx;
};
*/
template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ::calculator_example::detail::Calculator_Reply& data,
        size_t& current_alignment)
{
    using namespace calculator_example::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0e205a8d),
                data.representation_limits, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x04e82a2b),
                data.addition, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x096bbc8d),
                data.subtraction, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0bad50ff),
                data.fibonacci_seq, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0635cd81),
                data.sum_all, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x03d4c1bd),
                data.accumulator, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x047ac9b2),
                data.filter, current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0f8e48f0),
                data.remoteEx, current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_Reply& data)
{
    using namespace calculator_example::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x0e205a8d) << data.representation_limits
        << eprosima::fastcdr::MemberId(0x04e82a2b) << data.addition
        << eprosima::fastcdr::MemberId(0x096bbc8d) << data.subtraction
        << eprosima::fastcdr::MemberId(0x0bad50ff) << data.fibonacci_seq
        << eprosima::fastcdr::MemberId(0x0635cd81) << data.sum_all
        << eprosima::fastcdr::MemberId(0x03d4c1bd) << data.accumulator
        << eprosima::fastcdr::MemberId(0x047ac9b2) << data.filter
        << eprosima::fastcdr::MemberId(0x0f8e48f0) << data.remoteEx
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ::calculator_example::detail::Calculator_Reply& data)
{
    using namespace calculator_example::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x0e205a8d:
                                                dcdr >> data.representation_limits;
                                            break;

                                        case 0x04e82a2b:
                                                dcdr >> data.addition;
                                            break;

                                        case 0x096bbc8d:
                                                dcdr >> data.subtraction;
                                            break;

                                        case 0x0bad50ff:
                                                dcdr >> data.fibonacci_seq;
                                            break;

                                        case 0x0635cd81:
                                                dcdr >> data.sum_all;
                                            break;

                                        case 0x03d4c1bd:
                                                dcdr >> data.accumulator;
                                            break;

                                        case 0x047ac9b2:
                                                dcdr >> data.filter;
                                            break;

                                        case 0x0f8e48f0:
                                                dcdr >> data.remoteEx;
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ::calculator_example::detail::Calculator_Reply& data)
{
    static_cast<void>(scdr);
    static_cast<void>(data);
}

//}  // top level

//}  // calculator_example::Calculator interface


} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__CALCULATORCDRAUX_IPP

