/*
 * fhist - file history and comparison tools
 * Copyright (C) 1991-1994, 1998, 2006, 2008, 2012 Peter Miller
 *
 * Derived from a work
 * Copyright (C) 1990 David I. Bell.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FHIST_H
#define FHIST_H

#ifdef DOS
#define PATH_STR "\\"           /* the path separator character */
#define MAXMODULES 100          /* number of explicitly named modules */
#else
#define PATH_STR "/"            /* the path separator character */
#define MAXMODULES 1000         /* maximum number of modules in one command */
#endif


#define MAX_INFO 80             /* maximum size of information line */
#define MODIFY_LINES 25         /* default lines to check for modifying */
#define EDITALLOCSIZE 100       /* how many edit structures to allocate */
#define HEADERFORMAT "%c %06ld %06ld %06ld %012ld\n"    /* header line format */
#define HEADERLINELENGTH 36     /* length of the header line */
#define DEFAULTPATH "FHIST"     /* default pathname for sources */
#define OLDESTNAME "oldest"     /* special edit name for oldest version */
#define NEWESTNAME "newest"     /* special edit name for newest version */
#define NOSEEK ((long)(-1))     /* value to indicate no seeking */


/*
 * Filename extensions for files in the edit history directory.
 */
#ifdef DOS
#define EXT_SOURCE      "-S"    /* latest source file */
#define EXT_HISTORY     "-E"    /* edit history file */
#define EXT_NEW         "-N"    /* temporary new file */
#define EXT_OLD         "-O"    /* temporary old file */
#else
#define EXT_SOURCE      ".s"    /* latest source file */
#define EXT_HISTORY     ".e"    /* edit history file */
#define EXT_NEW         ".n"    /* temporary new file */
#define EXT_OLD         ".o"    /* temporary old file */
#endif


/*
 * Types of lines in the edit history file.
 * These letters appear as the first character of each line to identify its
 * type.  They are followed by a space if more data is present on the line.
 */
#define T_HEADER 'H'            /* header line */
#define T_BEGINEDIT 'B'         /* beginning of edit line */
#define T_REMARK 'R'            /* remark line (informational only) */
#define T_CHANGE 'C'            /* change lines */
#define T_TEXT 'T'              /* text being inserted line */
#define T_ENDEDIT 'E'           /* end of edit line */
#define T_FILE 'F'              /* read full edit from file */
#define T_POSITION 'P'          /* position of edit line */
#define T_EOF 'Z'               /* end of file line */
#define T_NONE -1               /* special value to indicate don't check type */


/*
 * Structure holding information about an edit for special character sequence
 * replacements during extracts.
 */
typedef struct INFO INFO;
struct INFO
{
    char    *i_edit;        /* edit number string */
    char    *i_date;        /* date string */
    char    *i_user;        /* user string */
};


/*
 * Structure to remember the position table information
 */
typedef struct POS POS;
struct POS
{
    long    p_pos;          /* position of beginning of edit */
    char    *p_names;       /* pointer to names for this edit (or NULL) */
};


typedef struct SC_DATA SC_DATA;
struct SC_DATA
{
    const char *remarkname;    /* name of file for remarks, or NULL if none */
    const char *remark_string; /* string of remark, or NULL if none */
    long    firstedit;      /* first legal edit number in history file */
    long    lastedit;       /* last legal edit number in history file */
    long    lastfile;       /* last file number used */
    long    tablepos;       /* position in edit history of position table */
    long    linelen;        /* length of line */
    long    modifylines;    /* number of lines to modify */
    char    *modifybuffer;  /* buffer for modified lines */
    short   forceupdateflag; /* don't ask questions about updating */
    short   forcewriteflag; /* don't ask questions about overwriting */
    short   nowriteflag;    /* don't overwrite existing files */
    const char *dirname;       /* path for edit history directory */
    const char *modulename;    /* module name being manipulated */
    char    basename[1024]; /* base name of history files */
    char    historyname[1024]; /* full path of edit history file */
    char    sourcename[1024]; /* full path of latest source file */
};

extern SC_DATA sc;              /* all external data for sc */

#endif /* FHIST_H */
/* vim: set ts=8 sw=4 et : */
