// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package executor

import (
	"context"
	"math"

	executorpb "cloud.google.com/go/spanner/executor/apiv1/executorpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	"google.golang.org/grpc"
)

var newSpannerExecutorProxyClientHook clientHook

// SpannerExecutorProxyCallOptions contains the retry settings for each method of SpannerExecutorProxyClient.
type SpannerExecutorProxyCallOptions struct {
	ExecuteActionAsync []gax.CallOption
}

func defaultSpannerExecutorProxyGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("spanner-cloud-executor.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("spanner-cloud-executor.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("spanner-cloud-executor.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://spanner-cloud-executor.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultSpannerExecutorProxyCallOptions() *SpannerExecutorProxyCallOptions {
	return &SpannerExecutorProxyCallOptions{
		ExecuteActionAsync: []gax.CallOption{},
	}
}

// internalSpannerExecutorProxyClient is an interface that defines the methods available from Cloud Spanner Executor test API.
type internalSpannerExecutorProxyClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ExecuteActionAsync(context.Context, ...gax.CallOption) (executorpb.SpannerExecutorProxy_ExecuteActionAsyncClient, error)
}

// SpannerExecutorProxyClient is a client for interacting with Cloud Spanner Executor test API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Service that executes SpannerActions asynchronously.
type SpannerExecutorProxyClient struct {
	// The internal transport-dependent client.
	internalClient internalSpannerExecutorProxyClient

	// The call options for this service.
	CallOptions *SpannerExecutorProxyCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *SpannerExecutorProxyClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *SpannerExecutorProxyClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *SpannerExecutorProxyClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ExecuteActionAsync executeActionAsync is a streaming call that starts executing a new Spanner
// action.
//
// For each request, the server will reply with one or more responses, but
// only the last response will contain status in the outcome.
//
// Responses can be matched to requests by action_id. It is allowed to have
// multiple actions in flight–in that case, actions are be executed in
// parallel.
func (c *SpannerExecutorProxyClient) ExecuteActionAsync(ctx context.Context, opts ...gax.CallOption) (executorpb.SpannerExecutorProxy_ExecuteActionAsyncClient, error) {
	return c.internalClient.ExecuteActionAsync(ctx, opts...)
}

// spannerExecutorProxyGRPCClient is a client for interacting with Cloud Spanner Executor test API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type spannerExecutorProxyGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing SpannerExecutorProxyClient
	CallOptions **SpannerExecutorProxyCallOptions

	// The gRPC API client.
	spannerExecutorProxyClient executorpb.SpannerExecutorProxyClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewSpannerExecutorProxyClient creates a new spanner executor proxy client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Service that executes SpannerActions asynchronously.
func NewSpannerExecutorProxyClient(ctx context.Context, opts ...option.ClientOption) (*SpannerExecutorProxyClient, error) {
	clientOpts := defaultSpannerExecutorProxyGRPCClientOptions()
	if newSpannerExecutorProxyClientHook != nil {
		hookOpts, err := newSpannerExecutorProxyClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := SpannerExecutorProxyClient{CallOptions: defaultSpannerExecutorProxyCallOptions()}

	c := &spannerExecutorProxyGRPCClient{
		connPool:                   connPool,
		spannerExecutorProxyClient: executorpb.NewSpannerExecutorProxyClient(connPool),
		CallOptions:                &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *spannerExecutorProxyGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *spannerExecutorProxyGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{"x-goog-api-client", gax.XGoogHeader(kv...)}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *spannerExecutorProxyGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *spannerExecutorProxyGRPCClient) ExecuteActionAsync(ctx context.Context, opts ...gax.CallOption) (executorpb.SpannerExecutorProxy_ExecuteActionAsyncClient, error) {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	var resp executorpb.SpannerExecutorProxy_ExecuteActionAsyncClient
	opts = append((*c.CallOptions).ExecuteActionAsync[0:len((*c.CallOptions).ExecuteActionAsync):len((*c.CallOptions).ExecuteActionAsync)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.spannerExecutorProxyClient.ExecuteActionAsync(ctx, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
