//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetapp

import "time"

// Account - NetApp account resource
type Account struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// NetApp Account properties
	Properties *AccountProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccountBackupsClientBeginDeleteOptions contains the optional parameters for the AccountBackupsClient.BeginDelete method.
type AccountBackupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountBackupsClientGetOptions contains the optional parameters for the AccountBackupsClient.Get method.
type AccountBackupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AccountBackupsClientListOptions contains the optional parameters for the AccountBackupsClient.List method.
type AccountBackupsClientListOptions struct {
	// placeholder for future optional parameters
}

// AccountEncryption - Encryption settings
type AccountEncryption struct {
	// Identity used to authenticate to KeyVault. Applicable if keySource is 'Microsoft.KeyVault'.
	Identity *EncryptionIdentity `json:"identity,omitempty"`

	// The encryption keySource (provider). Possible values (case-insensitive): Microsoft.NetApp, Microsoft.KeyVault
	KeySource *KeySource `json:"keySource,omitempty"`

	// Properties provided by KeVault. Applicable if keySource is 'Microsoft.KeyVault'.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
}

// AccountList - List of NetApp account resources
type AccountList struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Multiple NetApp accounts
	Value []*Account `json:"value,omitempty"`
}

// AccountPatch - NetApp account patch resource
type AccountPatch struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// NetApp Account properties
	Properties *AccountProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccountProperties - NetApp account properties
type AccountProperties struct {
	// Active Directories
	ActiveDirectories []*ActiveDirectory `json:"activeDirectories,omitempty"`

	// Encryption settings
	Encryption *AccountEncryption `json:"encryption,omitempty"`

	// READ-ONLY; Shows the status of disableShowmount for all volumes under the subscription, null equals false
	DisableShowmount *bool `json:"disableShowmount,omitempty" azure:"ro"`

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// AccountsClientBeginCreateOrUpdateOptions contains the optional parameters for the AccountsClient.BeginCreateOrUpdate method.
type AccountsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginDeleteOptions contains the optional parameters for the AccountsClient.BeginDelete method.
type AccountsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginRenewCredentialsOptions contains the optional parameters for the AccountsClient.BeginRenewCredentials
// method.
type AccountsClientBeginRenewCredentialsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginUpdateOptions contains the optional parameters for the AccountsClient.BeginUpdate method.
type AccountsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientGetOptions contains the optional parameters for the AccountsClient.Get method.
type AccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListBySubscriptionOptions contains the optional parameters for the AccountsClient.ListBySubscription method.
type AccountsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListOptions contains the optional parameters for the AccountsClient.List method.
type AccountsClientListOptions struct {
	// placeholder for future optional parameters
}

// ActiveDirectory - Active Directory
type ActiveDirectory struct {
	// Id of the Active Directory
	ActiveDirectoryID *string `json:"activeDirectoryId,omitempty"`

	// Name of the active directory machine. This optional parameter is used only while creating kerberos volume
	AdName *string `json:"adName,omitempty"`

	// Users to be added to the Built-in Administrators active directory group. A list of unique usernames without domain specifier
	Administrators []*string `json:"administrators,omitempty"`

	// If enabled, AES encryption will be enabled for SMB communication.
	AesEncryption *bool `json:"aesEncryption,omitempty"`

	// If enabled, NFS client local users can also (in addition to LDAP users) access the NFS volumes.
	AllowLocalNfsUsersWithLdap *bool `json:"allowLocalNfsUsersWithLdap,omitempty"`

	// Users to be added to the Built-in Backup Operator active directory group. A list of unique usernames without domain specifier
	BackupOperators []*string `json:"backupOperators,omitempty"`

	// Comma separated list of DNS server IP addresses (IPv4 only) for the Active Directory domain
	DNS *string `json:"dns,omitempty"`

	// Name of the Active Directory domain
	Domain *string `json:"domain,omitempty"`

	// If enabled, Traffic between the SMB server to Domain Controller (DC) will be encrypted.
	EncryptDCConnections *bool `json:"encryptDCConnections,omitempty"`

	// kdc server IP addresses for the active directory machine. This optional parameter is used only while creating kerberos
	// volume.
	KdcIP *string `json:"kdcIP,omitempty"`

	// Specifies whether or not the LDAP traffic needs to be secured via TLS.
	LdapOverTLS *bool `json:"ldapOverTLS,omitempty"`

	// LDAP Search scope options
	LdapSearchScope *LdapSearchScopeOpt `json:"ldapSearchScope,omitempty"`

	// Specifies whether or not the LDAP traffic needs to be signed.
	LdapSigning *bool `json:"ldapSigning,omitempty"`

	// The Organizational Unit (OU) within the Windows Active Directory
	OrganizationalUnit *string `json:"organizationalUnit,omitempty"`

	// Plain text password of Active Directory domain administrator, value is masked in the response
	Password *string `json:"password,omitempty"`

	// Domain Users in the Active directory to be given SeSecurityPrivilege privilege (Needed for SMB Continuously available shares
	// for SQL). A list of unique usernames without domain specifier
	SecurityOperators []*string `json:"securityOperators,omitempty"`

	// When LDAP over SSL/TLS is enabled, the LDAP client is required to have base64 encoded Active Directory Certificate Service's
	// self-signed root CA certificate, this optional parameter is used only for
	// dual protocol with LDAP user-mapping volumes.
	ServerRootCACertificate *string `json:"serverRootCACertificate,omitempty"`

	// The Active Directory site the service will limit Domain Controller discovery to
	Site *string `json:"site,omitempty"`

	// NetBIOS name of the SMB server. This name will be registered as a computer account in the AD and used to mount volumes
	SmbServerName *string `json:"smbServerName,omitempty"`

	// Username of Active Directory domain administrator
	Username *string `json:"username,omitempty"`

	// READ-ONLY; Status of the Active Directory
	Status *ActiveDirectoryStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Any details in regards to the Status of the Active Directory
	StatusDetails *string `json:"statusDetails,omitempty" azure:"ro"`
}

// AuthorizeRequest - Authorize request
type AuthorizeRequest struct {
	// Resource id of the remote volume
	RemoteVolumeResourceID *string `json:"remoteVolumeResourceId,omitempty"`
}

// Backup of a Volume
type Backup struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; Backup Properties
	Properties *BackupProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupPatch - Backup patch
type BackupPatch struct {
	// Backup Properties
	Properties *BackupProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// BackupPoliciesClientBeginCreateOptions contains the optional parameters for the BackupPoliciesClient.BeginCreate method.
type BackupPoliciesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupPoliciesClientBeginDeleteOptions contains the optional parameters for the BackupPoliciesClient.BeginDelete method.
type BackupPoliciesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupPoliciesClientBeginUpdateOptions contains the optional parameters for the BackupPoliciesClient.BeginUpdate method.
type BackupPoliciesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupPoliciesClientGetOptions contains the optional parameters for the BackupPoliciesClient.Get method.
type BackupPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// BackupPoliciesClientListOptions contains the optional parameters for the BackupPoliciesClient.List method.
type BackupPoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

// BackupPoliciesList - List of Backup Policies
type BackupPoliciesList struct {
	// A list of backup policies
	Value []*BackupPolicy `json:"value,omitempty"`
}

// BackupPolicy - Backup policy information
type BackupPolicy struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; Backup policy Properties
	Properties *BackupPolicyProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupPolicyPatch - Backup policy Details for create and update
type BackupPolicyPatch struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Backup policy Properties
	Properties *BackupPolicyProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupPolicyProperties - Backup policy properties
type BackupPolicyProperties struct {
	// Daily backups count to keep
	DailyBackupsToKeep *int32 `json:"dailyBackupsToKeep,omitempty"`

	// The property to decide policy is enabled or not
	Enabled *bool `json:"enabled,omitempty"`

	// Monthly backups count to keep
	MonthlyBackupsToKeep *int32 `json:"monthlyBackupsToKeep,omitempty"`

	// Weekly backups count to keep
	WeeklyBackupsToKeep *int32 `json:"weeklyBackupsToKeep,omitempty"`

	// READ-ONLY; Backup Policy Resource ID
	BackupPolicyID *string `json:"backupPolicyId,omitempty" azure:"ro"`

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; A list of volumes assigned to this policy
	VolumeBackups []*VolumeBackups `json:"volumeBackups,omitempty" azure:"ro"`

	// READ-ONLY; Volumes using current backup policy
	VolumesAssigned *int32 `json:"volumesAssigned,omitempty" azure:"ro"`
}

// BackupProperties - Backup properties
type BackupProperties struct {
	// Label for backup
	Label *string `json:"label,omitempty"`

	// Manual backup an already existing snapshot. This will always be false for scheduled backups and true/false for manual backups
	UseExistingSnapshot *bool `json:"useExistingSnapshot,omitempty"`

	// READ-ONLY; UUID v4 used to identify the Backup
	BackupID *string `json:"backupId,omitempty" azure:"ro"`

	// READ-ONLY; Type of backup Manual or Scheduled
	BackupType *BackupType `json:"backupType,omitempty" azure:"ro"`

	// READ-ONLY; The creation date of the backup
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; Failure reason
	FailureReason *string `json:"failureReason,omitempty" azure:"ro"`

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Size of backup
	Size *int64 `json:"size,omitempty" azure:"ro"`

	// READ-ONLY; Volume name
	VolumeName *string `json:"volumeName,omitempty" azure:"ro"`
}

// BackupStatus - Backup status
type BackupStatus struct {
	// READ-ONLY; Displays error message if the backup is in an error state
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; Backup health status
	Healthy *bool `json:"healthy,omitempty" azure:"ro"`

	// READ-ONLY; Displays the last transfer size
	LastTransferSize *int64 `json:"lastTransferSize,omitempty" azure:"ro"`

	// READ-ONLY; Displays the last transfer type
	LastTransferType *string `json:"lastTransferType,omitempty" azure:"ro"`

	// READ-ONLY; The status of the backup
	MirrorState *MirrorState `json:"mirrorState,omitempty" azure:"ro"`

	// READ-ONLY; Status of the backup mirror relationship
	RelationshipStatus *RelationshipStatus `json:"relationshipStatus,omitempty" azure:"ro"`

	// READ-ONLY; Displays the total bytes transferred
	TotalTransferBytes *int64 `json:"totalTransferBytes,omitempty" azure:"ro"`

	// READ-ONLY; Reason for the unhealthy backup relationship
	UnhealthyReason *string `json:"unhealthyReason,omitempty" azure:"ro"`
}

// BackupsClientBeginCreateOptions contains the optional parameters for the BackupsClient.BeginCreate method.
type BackupsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupsClientBeginDeleteOptions contains the optional parameters for the BackupsClient.BeginDelete method.
type BackupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupsClientBeginUpdateOptions contains the optional parameters for the BackupsClient.BeginUpdate method.
type BackupsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupsClientGetOptions contains the optional parameters for the BackupsClient.Get method.
type BackupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// BackupsClientGetStatusOptions contains the optional parameters for the BackupsClient.GetStatus method.
type BackupsClientGetStatusOptions struct {
	// placeholder for future optional parameters
}

// BackupsClientGetVolumeRestoreStatusOptions contains the optional parameters for the BackupsClient.GetVolumeRestoreStatus
// method.
type BackupsClientGetVolumeRestoreStatusOptions struct {
	// placeholder for future optional parameters
}

// BackupsClientListOptions contains the optional parameters for the BackupsClient.List method.
type BackupsClientListOptions struct {
	// placeholder for future optional parameters
}

// BackupsList - List of Backups
type BackupsList struct {
	// A list of Backups
	Value []*Backup `json:"value,omitempty"`
}

// BreakReplicationRequest - Break replication request
type BreakReplicationRequest struct {
	// If replication is in status transferring and you want to force break the replication, set to true
	ForceBreakReplication *bool `json:"forceBreakReplication,omitempty"`
}

// CapacityPool - Capacity pool resource
type CapacityPool struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; Capacity pool properties
	Properties *PoolProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CapacityPoolList - List of capacity pool resources
type CapacityPoolList struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Capacity pools
	Value []*CapacityPool `json:"value,omitempty"`
}

// CapacityPoolPatch - Capacity pool patch resource
type CapacityPoolPatch struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Capacity pool properties
	Properties *PoolPatchProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CheckAvailabilityResponse - Information regarding availability of a resource.
type CheckAvailabilityResponse struct {
	// true indicates name is valid and available. false indicates the name is invalid, unavailable, or both.
	IsAvailable *bool `json:"isAvailable,omitempty"`

	// If reason == invalid, provide the user with the reason why the given name is invalid, and provide the resource naming requirements
	// so that the user can select a valid name. If reason == AlreadyExists,
	// explain that resource name is already in use, and direct them to select a different name.
	Message *string `json:"message,omitempty"`

	// Invalid indicates the name provided does not match Azure App Service naming requirements. AlreadyExists indicates that
	// the name is already in use and is therefore unavailable.
	Reason *InAvailabilityReasonType `json:"reason,omitempty"`
}

// DailySchedule - Daily Schedule properties
type DailySchedule struct {
	// Indicates which hour in UTC timezone a snapshot should be taken
	Hour *int32 `json:"hour,omitempty"`

	// Indicates which minute snapshot should be taken
	Minute *int32 `json:"minute,omitempty"`

	// Daily snapshot count to keep
	SnapshotsToKeep *int32 `json:"snapshotsToKeep,omitempty"`

	// Resource size in bytes, current storage usage for the volume in bytes
	UsedBytes *int64 `json:"usedBytes,omitempty"`
}

// Dimension of blobs, possibly be blob type or access tier.
type Dimension struct {
	// Display name of dimension.
	DisplayName *string `json:"displayName,omitempty"`

	// Display name of dimension.
	Name *string `json:"name,omitempty"`
}

// EncryptionIdentity - Identity used to authenticate with key vault.
type EncryptionIdentity struct {
	// The ARM resource identifier of the user assigned identity used to authenticate with key vault. Applicable if identity.type
	// has 'UserAssigned'. It should match key of identity.userAssignedIdentities.
	UserAssignedIdentity *string `json:"userAssignedIdentity,omitempty"`

	// READ-ONLY; The principal ID (object ID) of the identity used to authenticate with key vault. Read-only.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// ExportPolicyRule - Volume Export Policy Rule
type ExportPolicyRule struct {
	// Client ingress specification as comma separated string with IPv4 CIDRs, IPv4 host addresses and host names
	AllowedClients *string `json:"allowedClients,omitempty"`

	// This parameter specifies who is authorized to change the ownership of a file. restricted - Only root user can change the
	// ownership of the file. unrestricted - Non-root users can change ownership of
	// files that they own.
	ChownMode *ChownMode `json:"chownMode,omitempty"`

	// Allows CIFS protocol
	Cifs *bool `json:"cifs,omitempty"`

	// Has root access to volume
	HasRootAccess *bool `json:"hasRootAccess,omitempty"`

	// Kerberos5i Read only access. To be use with swagger version 2020-05-01 or later
	Kerberos5IReadOnly *bool `json:"kerberos5iReadOnly,omitempty"`

	// Kerberos5i Read and write access. To be use with swagger version 2020-05-01 or later
	Kerberos5IReadWrite *bool `json:"kerberos5iReadWrite,omitempty"`

	// Kerberos5p Read only access. To be use with swagger version 2020-05-01 or later
	Kerberos5PReadOnly *bool `json:"kerberos5pReadOnly,omitempty"`

	// Kerberos5p Read and write access. To be use with swagger version 2020-05-01 or later
	Kerberos5PReadWrite *bool `json:"kerberos5pReadWrite,omitempty"`

	// Kerberos5 Read only access. To be use with swagger version 2020-05-01 or later
	Kerberos5ReadOnly *bool `json:"kerberos5ReadOnly,omitempty"`

	// Kerberos5 Read and write access. To be use with swagger version 2020-05-01 or later
	Kerberos5ReadWrite *bool `json:"kerberos5ReadWrite,omitempty"`

	// Allows NFSv3 protocol. Enable only for NFSv3 type volumes
	Nfsv3 *bool `json:"nfsv3,omitempty"`

	// Allows NFSv4.1 protocol. Enable only for NFSv4.1 type volumes
	Nfsv41 *bool `json:"nfsv41,omitempty"`

	// Order index
	RuleIndex *int32 `json:"ruleIndex,omitempty"`

	// Read only access
	UnixReadOnly *bool `json:"unixReadOnly,omitempty"`

	// Read and write access
	UnixReadWrite *bool `json:"unixReadWrite,omitempty"`
}

// FilePathAvailabilityRequest - File path availability request content - availability is based on the name and the subnetId.
type FilePathAvailabilityRequest struct {
	// REQUIRED; File path to verify.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes
	SubnetID *string `json:"subnetId,omitempty"`
}

// HourlySchedule - Hourly Schedule properties
type HourlySchedule struct {
	// Indicates which minute snapshot should be taken
	Minute *int32 `json:"minute,omitempty"`

	// Hourly snapshot count to keep
	SnapshotsToKeep *int32 `json:"snapshotsToKeep,omitempty"`

	// Resource size in bytes, current storage usage for the volume in bytes
	UsedBytes *int64 `json:"usedBytes,omitempty"`
}

// Identity for the resource.
type Identity struct {
	// REQUIRED; The identity type.
	Type *IdentityType `json:"type,omitempty"`

	// Gets or sets a list of key value pairs that describe the set of User Assigned identities that will be used with this storage
	// account. The key is the ARM resource identifier of the identity. Only 1
	// User Assigned identity is permitted here.
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// KeyVaultProperties - Properties of key vault.
type KeyVaultProperties struct {
	// REQUIRED; The name of KeyVault key.
	KeyName *string `json:"keyName,omitempty"`

	// REQUIRED; The resource ID of KeyVault.
	KeyVaultResourceID *string `json:"keyVaultResourceId,omitempty"`

	// REQUIRED; The Uri of KeyVault.
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`

	// READ-ONLY; UUID v4 used to identify the Azure Key Vault configuration
	KeyVaultID *string `json:"keyVaultId,omitempty" azure:"ro"`

	// READ-ONLY; Status of the KeyVault connection.
	Status *KeyVaultStatus `json:"status,omitempty" azure:"ro"`
}

// LdapSearchScopeOpt - LDAP search scope
type LdapSearchScopeOpt struct {
	// This specifies the group DN, which overrides the base DN for group lookups.
	GroupDN *string `json:"groupDN,omitempty"`

	// This specifies the custom LDAP search filter to be used when looking up group membership from LDAP server.
	GroupMembershipFilter *string `json:"groupMembershipFilter,omitempty"`

	// This specifies the user DN, which overrides the base DN for user lookups.
	UserDN *string `json:"userDN,omitempty"`
}

// ListReplications - List Replications
type ListReplications struct {
	// A list of replications
	Value []*Replication `json:"value,omitempty"`
}

// LogSpecification - Log Definition of a single resource metric.
type LogSpecification struct {
	// Display name of log specification.
	DisplayName *string `json:"displayName,omitempty"`

	// Name of log specification.
	Name *string `json:"name,omitempty"`
}

// MetricSpecification - Metric specification of operation.
type MetricSpecification struct {
	// Aggregation type could be Average.
	AggregationType *string `json:"aggregationType,omitempty"`

	// The category this metric specification belong to, could be Capacity.
	Category *string `json:"category,omitempty"`

	// Dimensions of blobs, including blob type and access tier.
	Dimensions []*Dimension `json:"dimensions,omitempty"`

	// Display description of metric specification.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Display name of metric specification.
	DisplayName *string `json:"displayName,omitempty"`

	// Whether or not the service is using regional MDM accounts.
	EnableRegionalMdmAccount *bool `json:"enableRegionalMdmAccount,omitempty"`

	// The property to decide fill gap with zero or not.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`

	// The internal metric name.
	InternalMetricName *string `json:"internalMetricName,omitempty"`

	// Whether the metric is internal.
	IsInternal *bool `json:"isInternal,omitempty"`

	// Name of metric specification.
	Name *string `json:"name,omitempty"`

	// Account Resource Id.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`

	// The source MDM account.
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty"`

	// The source MDM namespace.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`

	// Support metric aggregation type.
	SupportedAggregationTypes []*MetricAggregationType `json:"supportedAggregationTypes,omitempty"`

	// The supported time grain types for the metrics.
	SupportedTimeGrainTypes []*string `json:"supportedTimeGrainTypes,omitempty"`

	// Unit could be Bytes or Count.
	Unit *string `json:"unit,omitempty"`
}

// MonthlySchedule - Monthly Schedule properties
type MonthlySchedule struct {
	// Indicates which days of the month snapshot should be taken. A comma delimited string.
	DaysOfMonth *string `json:"daysOfMonth,omitempty"`

	// Indicates which hour in UTC timezone a snapshot should be taken
	Hour *int32 `json:"hour,omitempty"`

	// Indicates which minute snapshot should be taken
	Minute *int32 `json:"minute,omitempty"`

	// Monthly snapshot count to keep
	SnapshotsToKeep *int32 `json:"snapshotsToKeep,omitempty"`

	// Resource size in bytes, current storage usage for the volume in bytes
	UsedBytes *int64 `json:"usedBytes,omitempty"`
}

// MountTargetProperties - Mount target properties
type MountTargetProperties struct {
	// REQUIRED; UUID v4 used to identify the MountTarget
	FileSystemID *string `json:"fileSystemId,omitempty"`

	// The SMB server's Fully Qualified Domain Name, FQDN
	SmbServerFqdn *string `json:"smbServerFqdn,omitempty"`

	// READ-ONLY; The mount target's IPv4 address
	IPAddress *string `json:"ipAddress,omitempty" azure:"ro"`

	// READ-ONLY; UUID v4 used to identify the MountTarget
	MountTargetID *string `json:"mountTargetId,omitempty" azure:"ro"`
}

// Operation - Microsoft.NetApp REST API operation definition.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`

	// The origin of operations.
	Origin *string `json:"origin,omitempty"`

	// Properties of operation, include metric specifications.
	Properties *OperationProperties `json:"properties,omitempty"`
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Operation description.
	Description *string `json:"description,omitempty"`

	// Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft NetApp.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list Cloud Volume operations. It contains a list of operations and a URL
// link to get the next set of results.
type OperationListResult struct {
	// List of Storage operations supported by the Storage resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationProperties - Properties of operation, include metric specifications.
type OperationProperties struct {
	// One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PlacementKeyValuePairs - Application specific parameters for the placement of volumes in the volume group
type PlacementKeyValuePairs struct {
	// REQUIRED; Key for an application specific parameter for the placement of volumes in the volume group
	Key *string `json:"key,omitempty"`

	// REQUIRED; Value for an application specific parameter for the placement of volumes in the volume group
	Value *string `json:"value,omitempty"`
}

// PoolChangeRequest - Pool change request
type PoolChangeRequest struct {
	// REQUIRED; Resource id of the pool to move volume to
	NewPoolResourceID *string `json:"newPoolResourceId,omitempty"`
}

// PoolPatchProperties - Patchable pool properties
type PoolPatchProperties struct {
	// If enabled (true) the pool can contain cool Access enabled volumes.
	CoolAccess *bool `json:"coolAccess,omitempty"`

	// The qos type of the pool
	QosType *QosType `json:"qosType,omitempty"`

	// Provisioned size of the pool (in bytes). Allowed values are in 1TiB chunks (value must be multiply of 4398046511104).
	Size *int64 `json:"size,omitempty"`
}

// PoolProperties - Pool properties
type PoolProperties struct {
	// REQUIRED; The service level of the file system
	ServiceLevel *ServiceLevel `json:"serviceLevel,omitempty"`

	// REQUIRED; Provisioned size of the pool (in bytes). Allowed values are in 1TiB chunks (value must be multiply of 4398046511104).
	Size *int64 `json:"size,omitempty"`

	// If enabled (true) the pool can contain cool Access enabled volumes.
	CoolAccess *bool `json:"coolAccess,omitempty"`

	// Encryption type of the capacity pool, set encryption type for data at rest for this pool and all volumes in it. This value
	// can only be set when creating new pool.
	EncryptionType *EncryptionType `json:"encryptionType,omitempty"`

	// The qos type of the pool
	QosType *QosType `json:"qosType,omitempty"`

	// READ-ONLY; UUID v4 used to identify the Pool
	PoolID *string `json:"poolId,omitempty" azure:"ro"`

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Total throughput of pool in MiB/s
	TotalThroughputMibps *float32 `json:"totalThroughputMibps,omitempty" azure:"ro"`

	// READ-ONLY; Utilized throughput of pool in MiB/s
	UtilizedThroughputMibps *float32 `json:"utilizedThroughputMibps,omitempty" azure:"ro"`
}

// PoolsClientBeginCreateOrUpdateOptions contains the optional parameters for the PoolsClient.BeginCreateOrUpdate method.
type PoolsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PoolsClientBeginDeleteOptions contains the optional parameters for the PoolsClient.BeginDelete method.
type PoolsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PoolsClientBeginUpdateOptions contains the optional parameters for the PoolsClient.BeginUpdate method.
type PoolsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PoolsClientGetOptions contains the optional parameters for the PoolsClient.Get method.
type PoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PoolsClientListOptions contains the optional parameters for the PoolsClient.List method.
type PoolsClientListOptions struct {
	// placeholder for future optional parameters
}

// QuotaAvailabilityRequest - Quota availability request content.
type QuotaAvailabilityRequest struct {
	// REQUIRED; Name of the resource to verify.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Resource group name.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// REQUIRED; Resource type used for verification.
	Type *CheckQuotaNameResourceTypes `json:"type,omitempty"`
}

// ReestablishReplicationRequest - Re-establish request object supplied in the body of the operation.
type ReestablishReplicationRequest struct {
	// Resource id of the source volume for the replication
	SourceVolumeID *string `json:"sourceVolumeId,omitempty"`
}

// RegionInfo - Provides region specific information.
type RegionInfo struct {
	// Provides logical availability zone mappings for the subscription for a region.
	AvailabilityZoneMappings []*RegionInfoAvailabilityZoneMappingsItem `json:"availabilityZoneMappings,omitempty"`

	// Provides storage to network proximity information in the region.
	StorageToNetworkProximity *RegionStorageToNetworkProximity `json:"storageToNetworkProximity,omitempty"`
}

type RegionInfoAvailabilityZoneMappingsItem struct {
	// Logical availability zone.
	AvailabilityZone *string `json:"availabilityZone,omitempty"`

	// Available availability zone
	IsAvailable *bool `json:"isAvailable,omitempty"`
}

// RelocateVolumeRequest - Relocate volume request
type RelocateVolumeRequest struct {
	// New creation token for the volume that controls the mount point name
	CreationToken *string `json:"creationToken,omitempty"`
}

// Replication properties
type Replication struct {
	// REQUIRED; The resource ID of the remote volume.
	RemoteVolumeResourceID *string `json:"remoteVolumeResourceId,omitempty"`

	// Indicates whether the local volume is the source or destination for the Volume Replication
	EndpointType *EndpointType `json:"endpointType,omitempty"`

	// The remote region for the other end of the Volume Replication.
	RemoteVolumeRegion *string `json:"remoteVolumeRegion,omitempty"`

	// Schedule
	ReplicationSchedule *ReplicationSchedule `json:"replicationSchedule,omitempty"`
}

// ReplicationObject - Replication properties
type ReplicationObject struct {
	// REQUIRED; The resource ID of the remote volume.
	RemoteVolumeResourceID *string `json:"remoteVolumeResourceId,omitempty"`

	// Indicates whether the local volume is the source or destination for the Volume Replication
	EndpointType *EndpointType `json:"endpointType,omitempty"`

	// The remote region for the other end of the Volume Replication.
	RemoteVolumeRegion *string `json:"remoteVolumeRegion,omitempty"`

	// Id
	ReplicationID *string `json:"replicationId,omitempty"`

	// Schedule
	ReplicationSchedule *ReplicationSchedule `json:"replicationSchedule,omitempty"`
}

// ReplicationStatus - Replication status
type ReplicationStatus struct {
	// Displays error message if the replication is in an error state
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// Replication health check
	Healthy *bool `json:"healthy,omitempty"`

	// The status of the replication
	MirrorState *MirrorState `json:"mirrorState,omitempty"`

	// Status of the mirror relationship
	RelationshipStatus *RelationshipStatus `json:"relationshipStatus,omitempty"`

	// The progress of the replication
	TotalProgress *string `json:"totalProgress,omitempty"`
}

// ResourceClientCheckFilePathAvailabilityOptions contains the optional parameters for the ResourceClient.CheckFilePathAvailability
// method.
type ResourceClientCheckFilePathAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ResourceClientCheckNameAvailabilityOptions contains the optional parameters for the ResourceClient.CheckNameAvailability
// method.
type ResourceClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ResourceClientCheckQuotaAvailabilityOptions contains the optional parameters for the ResourceClient.CheckQuotaAvailability
// method.
type ResourceClientCheckQuotaAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ResourceClientQueryRegionInfoOptions contains the optional parameters for the ResourceClient.QueryRegionInfo method.
type ResourceClientQueryRegionInfoOptions struct {
	// placeholder for future optional parameters
}

// ResourceNameAvailabilityRequest - Resource name availability request content.
type ResourceNameAvailabilityRequest struct {
	// REQUIRED; Resource name to verify.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Resource group name.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// REQUIRED; Resource type used for verification.
	Type *CheckNameResourceTypes `json:"type,omitempty"`
}

// ResourceQuotaLimitsClientGetOptions contains the optional parameters for the ResourceQuotaLimitsClient.Get method.
type ResourceQuotaLimitsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ResourceQuotaLimitsClientListOptions contains the optional parameters for the ResourceQuotaLimitsClient.List method.
type ResourceQuotaLimitsClientListOptions struct {
	// placeholder for future optional parameters
}

// RestoreStatus - Restore status
type RestoreStatus struct {
	// READ-ONLY; Displays error message if the restore is in an error state
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; Restore health status
	Healthy *bool `json:"healthy,omitempty" azure:"ro"`

	// READ-ONLY; The status of the restore
	MirrorState *MirrorState `json:"mirrorState,omitempty" azure:"ro"`

	// READ-ONLY; Status of the restore SnapMirror relationship
	RelationshipStatus *RelationshipStatus `json:"relationshipStatus,omitempty" azure:"ro"`

	// READ-ONLY; Displays the total bytes transferred
	TotalTransferBytes *int64 `json:"totalTransferBytes,omitempty" azure:"ro"`

	// READ-ONLY; Reason for the unhealthy restore relationship
	UnhealthyReason *string `json:"unhealthyReason,omitempty" azure:"ro"`
}

// ServiceSpecification - One property of operation, include metric specifications.
type ServiceSpecification struct {
	// Log specification of operation.
	LogSpecifications []*LogSpecification `json:"logSpecifications,omitempty"`

	// Metric specifications of operation.
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty"`
}

// Snapshot of a Volume
type Snapshot struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Snapshot Properties
	Properties *SnapshotProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SnapshotPoliciesClientBeginDeleteOptions contains the optional parameters for the SnapshotPoliciesClient.BeginDelete method.
type SnapshotPoliciesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SnapshotPoliciesClientBeginUpdateOptions contains the optional parameters for the SnapshotPoliciesClient.BeginUpdate method.
type SnapshotPoliciesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SnapshotPoliciesClientCreateOptions contains the optional parameters for the SnapshotPoliciesClient.Create method.
type SnapshotPoliciesClientCreateOptions struct {
	// placeholder for future optional parameters
}

// SnapshotPoliciesClientGetOptions contains the optional parameters for the SnapshotPoliciesClient.Get method.
type SnapshotPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SnapshotPoliciesClientListOptions contains the optional parameters for the SnapshotPoliciesClient.List method.
type SnapshotPoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

// SnapshotPoliciesClientListVolumesOptions contains the optional parameters for the SnapshotPoliciesClient.ListVolumes method.
type SnapshotPoliciesClientListVolumesOptions struct {
	// placeholder for future optional parameters
}

// SnapshotPoliciesList - List of Snapshot Policies
type SnapshotPoliciesList struct {
	// A list of snapshot policies
	Value []*SnapshotPolicy `json:"value,omitempty"`
}

// SnapshotPolicy - Snapshot policy information
type SnapshotPolicy struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; Snapshot policy Properties
	Properties *SnapshotPolicyProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SnapshotPolicyPatch - Snapshot policy Details for create and update
type SnapshotPolicyPatch struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Snapshot Policy properties
	Properties *SnapshotPolicyProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SnapshotPolicyProperties - Snapshot policy properties
type SnapshotPolicyProperties struct {
	// Schedule for daily snapshots
	DailySchedule *DailySchedule `json:"dailySchedule,omitempty"`

	// The property to decide policy is enabled or not
	Enabled *bool `json:"enabled,omitempty"`

	// Schedule for hourly snapshots
	HourlySchedule *HourlySchedule `json:"hourlySchedule,omitempty"`

	// Schedule for monthly snapshots
	MonthlySchedule *MonthlySchedule `json:"monthlySchedule,omitempty"`

	// Schedule for weekly snapshots
	WeeklySchedule *WeeklySchedule `json:"weeklySchedule,omitempty"`

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// SnapshotPolicyVolumeList - Volumes associated with snapshot policy
type SnapshotPolicyVolumeList struct {
	// List of volumes
	Value []*Volume `json:"value,omitempty"`
}

// SnapshotProperties - Snapshot properties
type SnapshotProperties struct {
	// READ-ONLY; The creation date of the snapshot
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; UUID v4 used to identify the Snapshot
	SnapshotID *string `json:"snapshotId,omitempty" azure:"ro"`
}

// SnapshotRestoreFiles - Restore payload for Single File Snapshot Restore
type SnapshotRestoreFiles struct {
	// REQUIRED; List of files to be restored
	FilePaths []*string `json:"filePaths,omitempty"`

	// Destination folder where the files will be restored
	DestinationPath *string `json:"destinationPath,omitempty"`
}

// SnapshotsClientBeginCreateOptions contains the optional parameters for the SnapshotsClient.BeginCreate method.
type SnapshotsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SnapshotsClientBeginDeleteOptions contains the optional parameters for the SnapshotsClient.BeginDelete method.
type SnapshotsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SnapshotsClientBeginRestoreFilesOptions contains the optional parameters for the SnapshotsClient.BeginRestoreFiles method.
type SnapshotsClientBeginRestoreFilesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SnapshotsClientBeginUpdateOptions contains the optional parameters for the SnapshotsClient.BeginUpdate method.
type SnapshotsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SnapshotsClientGetOptions contains the optional parameters for the SnapshotsClient.Get method.
type SnapshotsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsClientListOptions contains the optional parameters for the SnapshotsClient.List method.
type SnapshotsClientListOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsList - List of Snapshots
type SnapshotsList struct {
	// A list of Snapshots
	Value []*Snapshot `json:"value,omitempty"`
}

// SubscriptionQuotaItem - Information regarding Subscription Quota Item.
type SubscriptionQuotaItem struct {
	// SubscriptionQuotaItem properties
	Properties *SubscriptionQuotaItemProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SubscriptionQuotaItemList - List of Subscription Quota Items
type SubscriptionQuotaItemList struct {
	// A list of SubscriptionQuotaItems
	Value []*SubscriptionQuotaItem `json:"value,omitempty"`
}

// SubscriptionQuotaItemProperties - SubscriptionQuotaItem Properties
type SubscriptionQuotaItemProperties struct {
	// READ-ONLY; The current quota value.
	Current *int32 `json:"current,omitempty" azure:"ro"`

	// READ-ONLY; The default quota value.
	Default *int32 `json:"default,omitempty" azure:"ro"`
}

// SubvolumeInfo - Subvolume Information properties
type SubvolumeInfo struct {
	// Subvolume Properties
	Properties *SubvolumeProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SubvolumeModel - Result of the post subvolume and action is to get metadata of the subvolume.
type SubvolumeModel struct {
	// It represents the minimal properties of the subvolume.
	Properties *SubvolumeModelProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SubvolumeModelProperties - Properties which represents actual subvolume model which is stored as a file in the system.
type SubvolumeModelProperties struct {
	// Most recent access time and date
	AccessedTimeStamp *time.Time `json:"accessedTimeStamp,omitempty"`

	// Bytes used
	BytesUsed *int64 `json:"bytesUsed,omitempty"`

	// Most recent change time and date
	ChangedTimeStamp *time.Time `json:"changedTimeStamp,omitempty"`

	// Creation time and date
	CreationTimeStamp *time.Time `json:"creationTimeStamp,omitempty"`

	// Most recent modification time and date
	ModifiedTimeStamp *time.Time `json:"modifiedTimeStamp,omitempty"`

	// Path to the parent subvolume
	ParentPath *string `json:"parentPath,omitempty"`

	// Path to the subvolume
	Path *string `json:"path,omitempty"`

	// Permissions of the subvolume
	Permissions *string `json:"permissions,omitempty"`

	// Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// Size of subvolume
	Size *int64 `json:"size,omitempty"`
}

// SubvolumePatchParams - Parameters with which a subvolume can be updated
type SubvolumePatchParams struct {
	// path to the subvolume
	Path *string `json:"path,omitempty"`

	// Truncate subvolume to the provided size in bytes
	Size *int64 `json:"size,omitempty"`
}

// SubvolumePatchRequest - Subvolume Patch Request properties
type SubvolumePatchRequest struct {
	// Subvolume Properties
	Properties *SubvolumePatchParams `json:"properties,omitempty"`
}

// SubvolumeProperties - This represents path associated with the subvolume
type SubvolumeProperties struct {
	// parent path to the subvolume
	ParentPath *string `json:"parentPath,omitempty"`

	// Path to the subvolume
	Path *string `json:"path,omitempty"`

	// Truncate subvolume to the provided size in bytes
	Size *int64 `json:"size,omitempty"`

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// SubvolumesClientBeginCreateOptions contains the optional parameters for the SubvolumesClient.BeginCreate method.
type SubvolumesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SubvolumesClientBeginDeleteOptions contains the optional parameters for the SubvolumesClient.BeginDelete method.
type SubvolumesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SubvolumesClientBeginGetMetadataOptions contains the optional parameters for the SubvolumesClient.BeginGetMetadata method.
type SubvolumesClientBeginGetMetadataOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SubvolumesClientBeginUpdateOptions contains the optional parameters for the SubvolumesClient.BeginUpdate method.
type SubvolumesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SubvolumesClientGetOptions contains the optional parameters for the SubvolumesClient.Get method.
type SubvolumesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SubvolumesClientListByVolumeOptions contains the optional parameters for the SubvolumesClient.ListByVolume method.
type SubvolumesClientListByVolumeOptions struct {
	// placeholder for future optional parameters
}

// SubvolumesList - List of Subvolumes
type SubvolumesList struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of Subvolumes
	Value []*SubvolumeInfo `json:"value,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// UserAssignedIdentity for the resource.
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal ID of the identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// Vault information
type Vault struct {
	// REQUIRED; Vault Properties
	Properties *VaultProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VaultList - List of Vaults
type VaultList struct {
	// A list of vaults
	Value []*Vault `json:"value,omitempty"`
}

// VaultProperties - Vault properties
type VaultProperties struct {
	// Vault Name
	VaultName *string `json:"vaultName,omitempty"`
}

// VaultsClientListOptions contains the optional parameters for the VaultsClient.List method.
type VaultsClientListOptions struct {
	// placeholder for future optional parameters
}

// Volume resource
type Volume struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; Volume properties
	Properties *VolumeProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// Availability Zone
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VolumeBackupProperties - Volume Backup Properties
type VolumeBackupProperties struct {
	// Backup Enabled
	BackupEnabled *bool `json:"backupEnabled,omitempty"`

	// Backup Policy Resource ID
	BackupPolicyID *string `json:"backupPolicyId,omitempty"`

	// Policy Enforced
	PolicyEnforced *bool `json:"policyEnforced,omitempty"`

	// Vault Resource ID
	VaultID *string `json:"vaultId,omitempty"`
}

// VolumeBackups - Volume details using the backup policy
type VolumeBackups struct {
	// Total count of backups for volume
	BackupsCount *int32 `json:"backupsCount,omitempty"`

	// Policy enabled
	PolicyEnabled *bool `json:"policyEnabled,omitempty"`

	// Volume name
	VolumeName *string `json:"volumeName,omitempty"`
}

// VolumeGroup - Volume group resource
type VolumeGroup struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Volume group properties
	Properties *VolumeGroupListProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VolumeGroupDetails - Volume group resource for create
type VolumeGroupDetails struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Volume group properties
	Properties *VolumeGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VolumeGroupList - List of volume group resources
type VolumeGroupList struct {
	// List of volume Groups
	Value []*VolumeGroup `json:"value,omitempty"`
}

// VolumeGroupListProperties - Volume group properties
type VolumeGroupListProperties struct {
	// Volume group details
	GroupMetaData *VolumeGroupMetaData `json:"groupMetaData,omitempty"`

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// VolumeGroupMetaData - Volume group properties
type VolumeGroupMetaData struct {
	// Application specific identifier
	ApplicationIdentifier *string `json:"applicationIdentifier,omitempty"`

	// Application Type
	ApplicationType *ApplicationType `json:"applicationType,omitempty"`

	// Application specific identifier of deployment rules for the volume group
	DeploymentSpecID *string `json:"deploymentSpecId,omitempty"`

	// Application specific placement rules for the volume group
	GlobalPlacementRules []*PlacementKeyValuePairs `json:"globalPlacementRules,omitempty"`

	// Group Description
	GroupDescription *string `json:"groupDescription,omitempty"`

	// READ-ONLY; Number of volumes in volume group
	VolumesCount *int64 `json:"volumesCount,omitempty" azure:"ro"`
}

// VolumeGroupProperties - Volume group properties
type VolumeGroupProperties struct {
	// Volume group details
	GroupMetaData *VolumeGroupMetaData `json:"groupMetaData,omitempty"`

	// List of volumes from group
	Volumes []*VolumeGroupVolumeProperties `json:"volumes,omitempty"`

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// VolumeGroupVolumeProperties - Volume resource
type VolumeGroupVolumeProperties struct {
	// REQUIRED; Volume properties
	Properties *VolumeProperties `json:"properties,omitempty"`

	// Resource name
	Name *string `json:"name,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VolumeGroupsClientBeginCreateOptions contains the optional parameters for the VolumeGroupsClient.BeginCreate method.
type VolumeGroupsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumeGroupsClientBeginDeleteOptions contains the optional parameters for the VolumeGroupsClient.BeginDelete method.
type VolumeGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumeGroupsClientGetOptions contains the optional parameters for the VolumeGroupsClient.Get method.
type VolumeGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VolumeGroupsClientListByNetAppAccountOptions contains the optional parameters for the VolumeGroupsClient.ListByNetAppAccount
// method.
type VolumeGroupsClientListByNetAppAccountOptions struct {
	// placeholder for future optional parameters
}

// VolumeList - List of volume resources
type VolumeList struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of volumes
	Value []*Volume `json:"value,omitempty"`
}

// VolumePatch - Volume patch resource
type VolumePatch struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Patchable volume properties
	Properties *VolumePatchProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VolumePatchProperties - Patchable volume properties
type VolumePatchProperties struct {
	// Specifies whether Cool Access(tiering) is enabled for the volume.
	CoolAccess *bool `json:"coolAccess,omitempty"`

	// Specifies the number of days after which data that is not accessed by clients will be tiered.
	CoolnessPeriod *int32 `json:"coolnessPeriod,omitempty"`

	// DataProtection type volumes include an object containing details of the replication
	DataProtection *VolumePatchPropertiesDataProtection `json:"dataProtection,omitempty"`

	// Default group quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
	DefaultGroupQuotaInKiBs *int64 `json:"defaultGroupQuotaInKiBs,omitempty"`

	// Default user quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
	DefaultUserQuotaInKiBs *int64 `json:"defaultUserQuotaInKiBs,omitempty"`

	// Set of export policy rules
	ExportPolicy *VolumePatchPropertiesExportPolicy `json:"exportPolicy,omitempty"`

	// Specifies if default quota is enabled for the volume.
	IsDefaultQuotaEnabled *bool `json:"isDefaultQuotaEnabled,omitempty"`

	// The service level of the file system
	ServiceLevel *ServiceLevel `json:"serviceLevel,omitempty"`

	// Maximum throughput in Mibps that can be achieved by this volume and this will be accepted as input only for manual qosType
	// volume
	ThroughputMibps *float32 `json:"throughputMibps,omitempty"`

	// UNIX permissions for NFS volume accepted in octal 4 digit format. First digit selects the set user ID(4), set group ID
	// (2) and sticky (1) attributes. Second digit selects permission for the owner of
	// the file: read (4), write (2) and execute (1). Third selects permissions for other users in the same group. the fourth
	// for other users not in the group. 0755 - gives read/write/execute permissions to
	// owner and read/execute to group and other users.
	UnixPermissions *string `json:"unixPermissions,omitempty"`

	// Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is
	// 100 GiB. Upper limit is 100TiB, 500Tib for LargeVolume. Specified in bytes.
	UsageThreshold *int64 `json:"usageThreshold,omitempty"`
}

// VolumePatchPropertiesDataProtection - DataProtection type volumes include an object containing details of the replication
type VolumePatchPropertiesDataProtection struct {
	// Backup Properties
	Backup *VolumeBackupProperties `json:"backup,omitempty"`

	// Snapshot properties.
	Snapshot *VolumeSnapshotProperties `json:"snapshot,omitempty"`
}

// VolumePatchPropertiesExportPolicy - Set of export policy rules
type VolumePatchPropertiesExportPolicy struct {
	// Export policy rule
	Rules []*ExportPolicyRule `json:"rules,omitempty"`
}

// VolumeProperties - Volume properties
type VolumeProperties struct {
	// REQUIRED; A unique file path for the volume. Used when creating mount targets
	CreationToken *string `json:"creationToken,omitempty"`

	// REQUIRED; The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes
	SubnetID *string `json:"subnetId,omitempty"`

	// REQUIRED; Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum
	// size is 500 GiB. Upper limit is 100TiB, 500Tib for LargeVolume. Specified in bytes.
	UsageThreshold *int64 `json:"usageThreshold,omitempty"`

	// Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose
	AvsDataStore *AvsDataStore `json:"avsDataStore,omitempty"`

	// UUID v4 or resource identifier used to identify the Backup.
	BackupID *string `json:"backupId,omitempty"`

	// Pool Resource Id used in case of creating a volume through volume group
	CapacityPoolResourceID *string `json:"capacityPoolResourceId,omitempty"`

	// Specifies whether Cool Access(tiering) is enabled for the volume.
	CoolAccess *bool `json:"coolAccess,omitempty"`

	// Specifies the number of days after which data that is not accessed by clients will be tiered.
	CoolnessPeriod *int32 `json:"coolnessPeriod,omitempty"`

	// DataProtection type volumes include an object containing details of the replication
	DataProtection *VolumePropertiesDataProtection `json:"dataProtection,omitempty"`

	// Default group quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
	DefaultGroupQuotaInKiBs *int64 `json:"defaultGroupQuotaInKiBs,omitempty"`

	// Default user quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
	DefaultUserQuotaInKiBs *int64 `json:"defaultUserQuotaInKiBs,omitempty"`

	// If enabled (true) the snapshot the volume was created from will be automatically deleted after the volume create operation
	// has finished. Defaults to false
	DeleteBaseSnapshot *bool `json:"deleteBaseSnapshot,omitempty"`

	// Flag indicating whether subvolume operations are enabled on the volume
	EnableSubvolumes *EnableSubvolumes `json:"enableSubvolumes,omitempty"`

	// Source of key used to encrypt data in volume. Applicable if NetApp account has encryption.keySource = 'Microsoft.KeyVault'.
	// Possible values (case-insensitive) are: 'Microsoft.NetApp,
	// Microsoft.KeyVault'
	EncryptionKeySource *EncryptionKeySource `json:"encryptionKeySource,omitempty"`

	// Set of export policy rules
	ExportPolicy *VolumePropertiesExportPolicy `json:"exportPolicy,omitempty"`

	// Specifies if default quota is enabled for the volume.
	IsDefaultQuotaEnabled *bool `json:"isDefaultQuotaEnabled,omitempty"`

	// Restoring
	IsRestoring *bool `json:"isRestoring,omitempty"`

	// Describe if a volume is KerberosEnabled. To be use with swagger version 2020-05-01 or later
	KerberosEnabled *bool `json:"kerberosEnabled,omitempty"`

	// The resource ID of private endpoint for KeyVault. It must reside in the same VNET as the volume. Only applicable if encryptionKeySource
	// = 'Microsoft.KeyVault'.
	KeyVaultPrivateEndpointResourceID *string `json:"keyVaultPrivateEndpointResourceId,omitempty"`

	// Specifies whether LDAP is enabled or not for a given NFS volume.
	LdapEnabled *bool `json:"ldapEnabled,omitempty"`

	// Basic network, or Standard features available to the volume.
	NetworkFeatures *NetworkFeatures `json:"networkFeatures,omitempty"`

	// Application specific placement rules for the particular volume
	PlacementRules []*PlacementKeyValuePairs `json:"placementRules,omitempty"`

	// Set of protocol types, default NFSv3, CIFS for SMB protocol
	ProtocolTypes []*string `json:"protocolTypes,omitempty"`

	// Proximity placement group associated with the volume
	ProximityPlacementGroup *string `json:"proximityPlacementGroup,omitempty"`

	// The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS protocol
	SecurityStyle *SecurityStyle `json:"securityStyle,omitempty"`

	// The service level of the file system
	ServiceLevel *ServiceLevel `json:"serviceLevel,omitempty"`

	// Enables access based enumeration share property for SMB Shares. Only applicable for SMB/DualProtocol volume
	SmbAccessBasedEnumeration *SmbAccessBasedEnumeration `json:"smbAccessBasedEnumeration,omitempty"`

	// Enables continuously available share property for smb volume. Only applicable for SMB volume
	SmbContinuouslyAvailable *bool `json:"smbContinuouslyAvailable,omitempty"`

	// Enables encryption for in-flight smb3 data. Only applicable for SMB/DualProtocol volume. To be used with swagger version
	// 2020-08-01 or later
	SmbEncryption *bool `json:"smbEncryption,omitempty"`

	// Enables non browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume
	SmbNonBrowsable *SmbNonBrowsable `json:"smbNonBrowsable,omitempty"`

	// If enabled (true) the volume will contain a read-only snapshot directory which provides access to each of the volume's
	// snapshots (default to true).
	SnapshotDirectoryVisible *bool `json:"snapshotDirectoryVisible,omitempty"`

	// UUID v4 or resource identifier used to identify the Snapshot.
	SnapshotID *string `json:"snapshotId,omitempty"`

	// Maximum throughput in MiB/s that can be achieved by this volume and this will be accepted as input only for manual qosType
	// volume
	ThroughputMibps *float32 `json:"throughputMibps,omitempty"`

	// UNIX permissions for NFS volume accepted in octal 4 digit format. First digit selects the set user ID(4), set group ID
	// (2) and sticky (1) attributes. Second digit selects permission for the owner of
	// the file: read (4), write (2) and execute (1). Third selects permissions for other users in the same group. the fourth
	// for other users not in the group. 0755 - gives read/write/execute permissions to
	// owner and read/execute to group and other users.
	UnixPermissions *string `json:"unixPermissions,omitempty"`

	// Volume spec name is the application specific designation or identifier for the particular volume in a volume group for
	// e.g. data, log
	VolumeSpecName *string `json:"volumeSpecName,omitempty"`

	// What type of volume is this. For destination volumes in Cross Region Replication, set type to DataProtection
	VolumeType *string `json:"volumeType,omitempty"`

	// READ-ONLY; Unique Baremetal Tenant Identifier.
	BaremetalTenantID *string `json:"baremetalTenantId,omitempty" azure:"ro"`

	// READ-ONLY; When a volume is being restored from another volume's snapshot, will show the percentage completion of this
	// cloning process. When this value is empty/null there is no cloning process currently
	// happening on this volume. This value will update every 5 minutes during cloning.
	CloneProgress *int32 `json:"cloneProgress,omitempty" azure:"ro"`

	// READ-ONLY; Specifies if the volume is encrypted or not. Only available on volumes created or updated after 2022-01-01.
	Encrypted *bool `json:"encrypted,omitempty" azure:"ro"`

	// READ-ONLY; Unique FileSystem Identifier.
	FileSystemID *string `json:"fileSystemId,omitempty" azure:"ro"`

	// READ-ONLY; Maximum number of files allowed. Needs a service request in order to be changed. Only allowed to be changed
	// if volume quota is more than 4TiB.
	MaximumNumberOfFiles *int64 `json:"maximumNumberOfFiles,omitempty" azure:"ro"`

	// READ-ONLY; List of mount targets
	MountTargets []*MountTargetProperties `json:"mountTargets,omitempty" azure:"ro"`

	// READ-ONLY; Network Sibling Set ID for the the group of volumes sharing networking resources.
	NetworkSiblingSetID *string `json:"networkSiblingSetId,omitempty" azure:"ro"`

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Provides storage to network proximity information for the volume.
	StorageToNetworkProximity *VolumeStorageToNetworkProximity `json:"storageToNetworkProximity,omitempty" azure:"ro"`

	// READ-ONLY; T2 network information
	T2Network *string `json:"t2Network,omitempty" azure:"ro"`

	// READ-ONLY; Volume Group Name
	VolumeGroupName *string `json:"volumeGroupName,omitempty" azure:"ro"`
}

// VolumePropertiesDataProtection - DataProtection type volumes include an object containing details of the replication
type VolumePropertiesDataProtection struct {
	// Backup Properties
	Backup *VolumeBackupProperties `json:"backup,omitempty"`

	// Replication properties
	Replication *ReplicationObject `json:"replication,omitempty"`

	// Snapshot properties.
	Snapshot *VolumeSnapshotProperties `json:"snapshot,omitempty"`
}

// VolumePropertiesExportPolicy - Set of export policy rules
type VolumePropertiesExportPolicy struct {
	// Export policy rule
	Rules []*ExportPolicyRule `json:"rules,omitempty"`
}

// VolumeQuotaRule - Quota Rule of a Volume
type VolumeQuotaRule struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Volume Quota Rule Properties
	Properties *VolumeQuotaRulesProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VolumeQuotaRulePatch - Patchable Quota Rule of a Volume
type VolumeQuotaRulePatch struct {
	// Volume Quota Rule Properties
	Properties *VolumeQuotaRulesProperties `json:"properties,omitempty"`
}

// VolumeQuotaRulesClientBeginCreateOptions contains the optional parameters for the VolumeQuotaRulesClient.BeginCreate method.
type VolumeQuotaRulesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumeQuotaRulesClientBeginDeleteOptions contains the optional parameters for the VolumeQuotaRulesClient.BeginDelete method.
type VolumeQuotaRulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumeQuotaRulesClientBeginUpdateOptions contains the optional parameters for the VolumeQuotaRulesClient.BeginUpdate method.
type VolumeQuotaRulesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumeQuotaRulesClientGetOptions contains the optional parameters for the VolumeQuotaRulesClient.Get method.
type VolumeQuotaRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VolumeQuotaRulesClientListByVolumeOptions contains the optional parameters for the VolumeQuotaRulesClient.ListByVolume
// method.
type VolumeQuotaRulesClientListByVolumeOptions struct {
	// placeholder for future optional parameters
}

// VolumeQuotaRulesList - List of Volume Quota Rules
type VolumeQuotaRulesList struct {
	// A list of Volume Quota Rules
	Value []*VolumeQuotaRule `json:"value,omitempty"`
}

// VolumeQuotaRulesProperties - Volume Quota Rule properties
type VolumeQuotaRulesProperties struct {
	// Size of quota
	QuotaSizeInKiBs *int64 `json:"quotaSizeInKiBs,omitempty"`

	// UserID/GroupID/SID based on the quota target type. UserID and groupID can be found by running ‘id’ or ‘getent’ command
	// for the user or group and SID can be found by running
	QuotaTarget *string `json:"quotaTarget,omitempty"`

	// Type of quota
	QuotaType *Type `json:"quotaType,omitempty"`

	// READ-ONLY; Gets the status of the VolumeQuotaRule at the time the operation was called.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// VolumeRevert - revert a volume to the snapshot
type VolumeRevert struct {
	// Resource id of the snapshot
	SnapshotID *string `json:"snapshotId,omitempty"`
}

// VolumeSnapshotProperties - Volume Snapshot Properties
type VolumeSnapshotProperties struct {
	// Snapshot Policy ResourceId
	SnapshotPolicyID *string `json:"snapshotPolicyId,omitempty"`
}

// VolumesClientBeginAuthorizeReplicationOptions contains the optional parameters for the VolumesClient.BeginAuthorizeReplication
// method.
type VolumesClientBeginAuthorizeReplicationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientBeginBreakReplicationOptions contains the optional parameters for the VolumesClient.BeginBreakReplication
// method.
type VolumesClientBeginBreakReplicationOptions struct {
	// Optional body to force break the replication.
	Body *BreakReplicationRequest
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientBeginCreateOrUpdateOptions contains the optional parameters for the VolumesClient.BeginCreateOrUpdate method.
type VolumesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientBeginDeleteOptions contains the optional parameters for the VolumesClient.BeginDelete method.
type VolumesClientBeginDeleteOptions struct {
	// An option to force delete the volume. Will cleanup resources connected to the particular volume
	ForceDelete *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientBeginDeleteReplicationOptions contains the optional parameters for the VolumesClient.BeginDeleteReplication
// method.
type VolumesClientBeginDeleteReplicationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientBeginFinalizeRelocationOptions contains the optional parameters for the VolumesClient.BeginFinalizeRelocation
// method.
type VolumesClientBeginFinalizeRelocationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientBeginPoolChangeOptions contains the optional parameters for the VolumesClient.BeginPoolChange method.
type VolumesClientBeginPoolChangeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientBeginReInitializeReplicationOptions contains the optional parameters for the VolumesClient.BeginReInitializeReplication
// method.
type VolumesClientBeginReInitializeReplicationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientBeginReestablishReplicationOptions contains the optional parameters for the VolumesClient.BeginReestablishReplication
// method.
type VolumesClientBeginReestablishReplicationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientBeginRelocateOptions contains the optional parameters for the VolumesClient.BeginRelocate method.
type VolumesClientBeginRelocateOptions struct {
	// Relocate volume request
	Body *RelocateVolumeRequest
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientBeginResetCifsPasswordOptions contains the optional parameters for the VolumesClient.BeginResetCifsPassword
// method.
type VolumesClientBeginResetCifsPasswordOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientBeginResyncReplicationOptions contains the optional parameters for the VolumesClient.BeginResyncReplication
// method.
type VolumesClientBeginResyncReplicationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientBeginRevertOptions contains the optional parameters for the VolumesClient.BeginRevert method.
type VolumesClientBeginRevertOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientBeginRevertRelocationOptions contains the optional parameters for the VolumesClient.BeginRevertRelocation
// method.
type VolumesClientBeginRevertRelocationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientBeginUpdateOptions contains the optional parameters for the VolumesClient.BeginUpdate method.
type VolumesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientGetOptions contains the optional parameters for the VolumesClient.Get method.
type VolumesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VolumesClientListOptions contains the optional parameters for the VolumesClient.List method.
type VolumesClientListOptions struct {
	// placeholder for future optional parameters
}

// VolumesClientListReplicationsOptions contains the optional parameters for the VolumesClient.ListReplications method.
type VolumesClientListReplicationsOptions struct {
	// placeholder for future optional parameters
}

// VolumesClientReplicationStatusOptions contains the optional parameters for the VolumesClient.ReplicationStatus method.
type VolumesClientReplicationStatusOptions struct {
	// placeholder for future optional parameters
}

// WeeklySchedule - Weekly Schedule properties, make a snapshot every week at a specific day or days
type WeeklySchedule struct {
	// Indicates which weekdays snapshot should be taken, accepts a comma separated list of week day names in english
	Day *string `json:"day,omitempty"`

	// Indicates which hour in UTC timezone a snapshot should be taken
	Hour *int32 `json:"hour,omitempty"`

	// Indicates which minute snapshot should be taken
	Minute *int32 `json:"minute,omitempty"`

	// Weekly snapshot count to keep
	SnapshotsToKeep *int32 `json:"snapshotsToKeep,omitempty"`

	// Resource size in bytes, current storage usage for the volume in bytes
	UsedBytes *int64 `json:"usedBytes,omitempty"`
}
