//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurityinsights

const (
	moduleName    = "armsecurityinsights"
	moduleVersion = "v2.0.0-beta.2"
)

// ActionType - The type of the automation rule action.
type ActionType string

const (
	// ActionTypeModifyProperties - Modify an object's properties
	ActionTypeModifyProperties ActionType = "ModifyProperties"
	// ActionTypeRunPlaybook - Run a playbook on an object
	ActionTypeRunPlaybook ActionType = "RunPlaybook"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeModifyProperties,
		ActionTypeRunPlaybook,
	}
}

// AlertDetail - Alert detail
type AlertDetail string

const (
	// AlertDetailDisplayName - Alert display name
	AlertDetailDisplayName AlertDetail = "DisplayName"
	// AlertDetailSeverity - Alert severity
	AlertDetailSeverity AlertDetail = "Severity"
)

// PossibleAlertDetailValues returns the possible values for the AlertDetail const type.
func PossibleAlertDetailValues() []AlertDetail {
	return []AlertDetail{
		AlertDetailDisplayName,
		AlertDetailSeverity,
	}
}

// AlertRuleKind - The kind of the alert rule
type AlertRuleKind string

const (
	AlertRuleKindFusion                            AlertRuleKind = "Fusion"
	AlertRuleKindMLBehaviorAnalytics               AlertRuleKind = "MLBehaviorAnalytics"
	AlertRuleKindMicrosoftSecurityIncidentCreation AlertRuleKind = "MicrosoftSecurityIncidentCreation"
	AlertRuleKindNRT                               AlertRuleKind = "NRT"
	AlertRuleKindScheduled                         AlertRuleKind = "Scheduled"
	AlertRuleKindThreatIntelligence                AlertRuleKind = "ThreatIntelligence"
)

// PossibleAlertRuleKindValues returns the possible values for the AlertRuleKind const type.
func PossibleAlertRuleKindValues() []AlertRuleKind {
	return []AlertRuleKind{
		AlertRuleKindFusion,
		AlertRuleKindMLBehaviorAnalytics,
		AlertRuleKindMicrosoftSecurityIncidentCreation,
		AlertRuleKindNRT,
		AlertRuleKindScheduled,
		AlertRuleKindThreatIntelligence,
	}
}

// AlertSeverity - The severity of the alert
type AlertSeverity string

const (
	// AlertSeverityHigh - High severity
	AlertSeverityHigh AlertSeverity = "High"
	// AlertSeverityInformational - Informational severity
	AlertSeverityInformational AlertSeverity = "Informational"
	// AlertSeverityLow - Low severity
	AlertSeverityLow AlertSeverity = "Low"
	// AlertSeverityMedium - Medium severity
	AlertSeverityMedium AlertSeverity = "Medium"
)

// PossibleAlertSeverityValues returns the possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{
		AlertSeverityHigh,
		AlertSeverityInformational,
		AlertSeverityLow,
		AlertSeverityMedium,
	}
}

// AlertStatus - The lifecycle status of the alert.
type AlertStatus string

const (
	// AlertStatusDismissed - Alert dismissed as false positive
	AlertStatusDismissed AlertStatus = "Dismissed"
	// AlertStatusInProgress - Alert is being handled
	AlertStatusInProgress AlertStatus = "InProgress"
	// AlertStatusNew - New alert
	AlertStatusNew AlertStatus = "New"
	// AlertStatusResolved - Alert closed after handling
	AlertStatusResolved AlertStatus = "Resolved"
	// AlertStatusUnknown - Unknown value
	AlertStatusUnknown AlertStatus = "Unknown"
)

// PossibleAlertStatusValues returns the possible values for the AlertStatus const type.
func PossibleAlertStatusValues() []AlertStatus {
	return []AlertStatus{
		AlertStatusDismissed,
		AlertStatusInProgress,
		AlertStatusNew,
		AlertStatusResolved,
		AlertStatusUnknown,
	}
}

// AntispamMailDirection - The directionality of this mail message
type AntispamMailDirection string

const (
	// AntispamMailDirectionInbound - Inbound
	AntispamMailDirectionInbound AntispamMailDirection = "Inbound"
	// AntispamMailDirectionIntraorg - Intraorg
	AntispamMailDirectionIntraorg AntispamMailDirection = "Intraorg"
	// AntispamMailDirectionOutbound - Outbound
	AntispamMailDirectionOutbound AntispamMailDirection = "Outbound"
	// AntispamMailDirectionUnknown - Unknown
	AntispamMailDirectionUnknown AntispamMailDirection = "Unknown"
)

// PossibleAntispamMailDirectionValues returns the possible values for the AntispamMailDirection const type.
func PossibleAntispamMailDirectionValues() []AntispamMailDirection {
	return []AntispamMailDirection{
		AntispamMailDirectionInbound,
		AntispamMailDirectionIntraorg,
		AntispamMailDirectionOutbound,
		AntispamMailDirectionUnknown,
	}
}

// AttackTactic - The severity for alerts created by this alert rule.
type AttackTactic string

const (
	AttackTacticCollection              AttackTactic = "Collection"
	AttackTacticCommandAndControl       AttackTactic = "CommandAndControl"
	AttackTacticCredentialAccess        AttackTactic = "CredentialAccess"
	AttackTacticDefenseEvasion          AttackTactic = "DefenseEvasion"
	AttackTacticDiscovery               AttackTactic = "Discovery"
	AttackTacticExecution               AttackTactic = "Execution"
	AttackTacticExfiltration            AttackTactic = "Exfiltration"
	AttackTacticImpact                  AttackTactic = "Impact"
	AttackTacticImpairProcessControl    AttackTactic = "ImpairProcessControl"
	AttackTacticInhibitResponseFunction AttackTactic = "InhibitResponseFunction"
	AttackTacticInitialAccess           AttackTactic = "InitialAccess"
	AttackTacticLateralMovement         AttackTactic = "LateralMovement"
	AttackTacticPersistence             AttackTactic = "Persistence"
	AttackTacticPreAttack               AttackTactic = "PreAttack"
	AttackTacticPrivilegeEscalation     AttackTactic = "PrivilegeEscalation"
	AttackTacticReconnaissance          AttackTactic = "Reconnaissance"
	AttackTacticResourceDevelopment     AttackTactic = "ResourceDevelopment"
)

// PossibleAttackTacticValues returns the possible values for the AttackTactic const type.
func PossibleAttackTacticValues() []AttackTactic {
	return []AttackTactic{
		AttackTacticCollection,
		AttackTacticCommandAndControl,
		AttackTacticCredentialAccess,
		AttackTacticDefenseEvasion,
		AttackTacticDiscovery,
		AttackTacticExecution,
		AttackTacticExfiltration,
		AttackTacticImpact,
		AttackTacticImpairProcessControl,
		AttackTacticInhibitResponseFunction,
		AttackTacticInitialAccess,
		AttackTacticLateralMovement,
		AttackTacticPersistence,
		AttackTacticPreAttack,
		AttackTacticPrivilegeEscalation,
		AttackTacticReconnaissance,
		AttackTacticResourceDevelopment,
	}
}

type AutomationRuleBooleanConditionSupportedOperator string

const (
	// AutomationRuleBooleanConditionSupportedOperatorAnd - Evaluates as true if all the item conditions are evaluated as true
	AutomationRuleBooleanConditionSupportedOperatorAnd AutomationRuleBooleanConditionSupportedOperator = "And"
	// AutomationRuleBooleanConditionSupportedOperatorOr - Evaluates as true if at least one of the item conditions are evaluated
	// as true
	AutomationRuleBooleanConditionSupportedOperatorOr AutomationRuleBooleanConditionSupportedOperator = "Or"
)

// PossibleAutomationRuleBooleanConditionSupportedOperatorValues returns the possible values for the AutomationRuleBooleanConditionSupportedOperator const type.
func PossibleAutomationRuleBooleanConditionSupportedOperatorValues() []AutomationRuleBooleanConditionSupportedOperator {
	return []AutomationRuleBooleanConditionSupportedOperator{
		AutomationRuleBooleanConditionSupportedOperatorAnd,
		AutomationRuleBooleanConditionSupportedOperatorOr,
	}
}

type AutomationRulePropertyArrayChangedConditionSupportedArrayType string

const (
	// AutomationRulePropertyArrayChangedConditionSupportedArrayTypeAlerts - Evaluate the condition on the alerts
	AutomationRulePropertyArrayChangedConditionSupportedArrayTypeAlerts AutomationRulePropertyArrayChangedConditionSupportedArrayType = "Alerts"
	// AutomationRulePropertyArrayChangedConditionSupportedArrayTypeComments - Evaluate the condition on the comments
	AutomationRulePropertyArrayChangedConditionSupportedArrayTypeComments AutomationRulePropertyArrayChangedConditionSupportedArrayType = "Comments"
	// AutomationRulePropertyArrayChangedConditionSupportedArrayTypeLabels - Evaluate the condition on the labels
	AutomationRulePropertyArrayChangedConditionSupportedArrayTypeLabels AutomationRulePropertyArrayChangedConditionSupportedArrayType = "Labels"
	// AutomationRulePropertyArrayChangedConditionSupportedArrayTypeTactics - Evaluate the condition on the tactics
	AutomationRulePropertyArrayChangedConditionSupportedArrayTypeTactics AutomationRulePropertyArrayChangedConditionSupportedArrayType = "Tactics"
)

// PossibleAutomationRulePropertyArrayChangedConditionSupportedArrayTypeValues returns the possible values for the AutomationRulePropertyArrayChangedConditionSupportedArrayType const type.
func PossibleAutomationRulePropertyArrayChangedConditionSupportedArrayTypeValues() []AutomationRulePropertyArrayChangedConditionSupportedArrayType {
	return []AutomationRulePropertyArrayChangedConditionSupportedArrayType{
		AutomationRulePropertyArrayChangedConditionSupportedArrayTypeAlerts,
		AutomationRulePropertyArrayChangedConditionSupportedArrayTypeComments,
		AutomationRulePropertyArrayChangedConditionSupportedArrayTypeLabels,
		AutomationRulePropertyArrayChangedConditionSupportedArrayTypeTactics,
	}
}

type AutomationRulePropertyArrayChangedConditionSupportedChangeType string

const (
	// AutomationRulePropertyArrayChangedConditionSupportedChangeTypeAdded - Evaluate the condition on items added to the array
	AutomationRulePropertyArrayChangedConditionSupportedChangeTypeAdded AutomationRulePropertyArrayChangedConditionSupportedChangeType = "Added"
)

// PossibleAutomationRulePropertyArrayChangedConditionSupportedChangeTypeValues returns the possible values for the AutomationRulePropertyArrayChangedConditionSupportedChangeType const type.
func PossibleAutomationRulePropertyArrayChangedConditionSupportedChangeTypeValues() []AutomationRulePropertyArrayChangedConditionSupportedChangeType {
	return []AutomationRulePropertyArrayChangedConditionSupportedChangeType{
		AutomationRulePropertyArrayChangedConditionSupportedChangeTypeAdded,
	}
}

type AutomationRulePropertyArrayConditionSupportedArrayConditionType string

const (
	// AutomationRulePropertyArrayConditionSupportedArrayConditionTypeAnyItem - Evaluate the condition as true if any item fulfills
	// it
	AutomationRulePropertyArrayConditionSupportedArrayConditionTypeAnyItem AutomationRulePropertyArrayConditionSupportedArrayConditionType = "AnyItem"
)

// PossibleAutomationRulePropertyArrayConditionSupportedArrayConditionTypeValues returns the possible values for the AutomationRulePropertyArrayConditionSupportedArrayConditionType const type.
func PossibleAutomationRulePropertyArrayConditionSupportedArrayConditionTypeValues() []AutomationRulePropertyArrayConditionSupportedArrayConditionType {
	return []AutomationRulePropertyArrayConditionSupportedArrayConditionType{
		AutomationRulePropertyArrayConditionSupportedArrayConditionTypeAnyItem,
	}
}

type AutomationRulePropertyArrayConditionSupportedArrayType string

const (
	// AutomationRulePropertyArrayConditionSupportedArrayTypeCustomDetailValues - Evaluate the condition on a custom detail's
	// values
	AutomationRulePropertyArrayConditionSupportedArrayTypeCustomDetailValues AutomationRulePropertyArrayConditionSupportedArrayType = "CustomDetailValues"
	// AutomationRulePropertyArrayConditionSupportedArrayTypeCustomDetails - Evaluate the condition on the custom detail keys
	AutomationRulePropertyArrayConditionSupportedArrayTypeCustomDetails AutomationRulePropertyArrayConditionSupportedArrayType = "CustomDetails"
)

// PossibleAutomationRulePropertyArrayConditionSupportedArrayTypeValues returns the possible values for the AutomationRulePropertyArrayConditionSupportedArrayType const type.
func PossibleAutomationRulePropertyArrayConditionSupportedArrayTypeValues() []AutomationRulePropertyArrayConditionSupportedArrayType {
	return []AutomationRulePropertyArrayConditionSupportedArrayType{
		AutomationRulePropertyArrayConditionSupportedArrayTypeCustomDetailValues,
		AutomationRulePropertyArrayConditionSupportedArrayTypeCustomDetails,
	}
}

type AutomationRulePropertyChangedConditionSupportedChangedType string

const (
	// AutomationRulePropertyChangedConditionSupportedChangedTypeChangedFrom - Evaluate the condition on the previous value of
	// the property
	AutomationRulePropertyChangedConditionSupportedChangedTypeChangedFrom AutomationRulePropertyChangedConditionSupportedChangedType = "ChangedFrom"
	// AutomationRulePropertyChangedConditionSupportedChangedTypeChangedTo - Evaluate the condition on the updated value of the
	// property
	AutomationRulePropertyChangedConditionSupportedChangedTypeChangedTo AutomationRulePropertyChangedConditionSupportedChangedType = "ChangedTo"
)

// PossibleAutomationRulePropertyChangedConditionSupportedChangedTypeValues returns the possible values for the AutomationRulePropertyChangedConditionSupportedChangedType const type.
func PossibleAutomationRulePropertyChangedConditionSupportedChangedTypeValues() []AutomationRulePropertyChangedConditionSupportedChangedType {
	return []AutomationRulePropertyChangedConditionSupportedChangedType{
		AutomationRulePropertyChangedConditionSupportedChangedTypeChangedFrom,
		AutomationRulePropertyChangedConditionSupportedChangedTypeChangedTo,
	}
}

type AutomationRulePropertyChangedConditionSupportedPropertyType string

const (
	// AutomationRulePropertyChangedConditionSupportedPropertyTypeIncidentOwner - Evaluate the condition on the incident owner
	AutomationRulePropertyChangedConditionSupportedPropertyTypeIncidentOwner AutomationRulePropertyChangedConditionSupportedPropertyType = "IncidentOwner"
	// AutomationRulePropertyChangedConditionSupportedPropertyTypeIncidentSeverity - Evaluate the condition on the incident severity
	AutomationRulePropertyChangedConditionSupportedPropertyTypeIncidentSeverity AutomationRulePropertyChangedConditionSupportedPropertyType = "IncidentSeverity"
	// AutomationRulePropertyChangedConditionSupportedPropertyTypeIncidentStatus - Evaluate the condition on the incident status
	AutomationRulePropertyChangedConditionSupportedPropertyTypeIncidentStatus AutomationRulePropertyChangedConditionSupportedPropertyType = "IncidentStatus"
)

// PossibleAutomationRulePropertyChangedConditionSupportedPropertyTypeValues returns the possible values for the AutomationRulePropertyChangedConditionSupportedPropertyType const type.
func PossibleAutomationRulePropertyChangedConditionSupportedPropertyTypeValues() []AutomationRulePropertyChangedConditionSupportedPropertyType {
	return []AutomationRulePropertyChangedConditionSupportedPropertyType{
		AutomationRulePropertyChangedConditionSupportedPropertyTypeIncidentOwner,
		AutomationRulePropertyChangedConditionSupportedPropertyTypeIncidentSeverity,
		AutomationRulePropertyChangedConditionSupportedPropertyTypeIncidentStatus,
	}
}

type AutomationRulePropertyConditionSupportedOperator string

const (
	// AutomationRulePropertyConditionSupportedOperatorContains - Evaluates if the property contains at least one of the condition
	// values
	AutomationRulePropertyConditionSupportedOperatorContains AutomationRulePropertyConditionSupportedOperator = "Contains"
	// AutomationRulePropertyConditionSupportedOperatorEndsWith - Evaluates if the property ends with any of the condition values
	AutomationRulePropertyConditionSupportedOperatorEndsWith AutomationRulePropertyConditionSupportedOperator = "EndsWith"
	// AutomationRulePropertyConditionSupportedOperatorEquals - Evaluates if the property equals at least one of the condition
	// values
	AutomationRulePropertyConditionSupportedOperatorEquals AutomationRulePropertyConditionSupportedOperator = "Equals"
	// AutomationRulePropertyConditionSupportedOperatorNotContains - Evaluates if the property does not contain any of the condition
	// values
	AutomationRulePropertyConditionSupportedOperatorNotContains AutomationRulePropertyConditionSupportedOperator = "NotContains"
	// AutomationRulePropertyConditionSupportedOperatorNotEndsWith - Evaluates if the property does not end with any of the condition
	// values
	AutomationRulePropertyConditionSupportedOperatorNotEndsWith AutomationRulePropertyConditionSupportedOperator = "NotEndsWith"
	// AutomationRulePropertyConditionSupportedOperatorNotEquals - Evaluates if the property does not equal any of the condition
	// values
	AutomationRulePropertyConditionSupportedOperatorNotEquals AutomationRulePropertyConditionSupportedOperator = "NotEquals"
	// AutomationRulePropertyConditionSupportedOperatorNotStartsWith - Evaluates if the property does not start with any of the
	// condition values
	AutomationRulePropertyConditionSupportedOperatorNotStartsWith AutomationRulePropertyConditionSupportedOperator = "NotStartsWith"
	// AutomationRulePropertyConditionSupportedOperatorStartsWith - Evaluates if the property starts with any of the condition
	// values
	AutomationRulePropertyConditionSupportedOperatorStartsWith AutomationRulePropertyConditionSupportedOperator = "StartsWith"
)

// PossibleAutomationRulePropertyConditionSupportedOperatorValues returns the possible values for the AutomationRulePropertyConditionSupportedOperator const type.
func PossibleAutomationRulePropertyConditionSupportedOperatorValues() []AutomationRulePropertyConditionSupportedOperator {
	return []AutomationRulePropertyConditionSupportedOperator{
		AutomationRulePropertyConditionSupportedOperatorContains,
		AutomationRulePropertyConditionSupportedOperatorEndsWith,
		AutomationRulePropertyConditionSupportedOperatorEquals,
		AutomationRulePropertyConditionSupportedOperatorNotContains,
		AutomationRulePropertyConditionSupportedOperatorNotEndsWith,
		AutomationRulePropertyConditionSupportedOperatorNotEquals,
		AutomationRulePropertyConditionSupportedOperatorNotStartsWith,
		AutomationRulePropertyConditionSupportedOperatorStartsWith,
	}
}

// AutomationRulePropertyConditionSupportedProperty - The property to evaluate in an automation rule property condition.
type AutomationRulePropertyConditionSupportedProperty string

const (
	// AutomationRulePropertyConditionSupportedPropertyAccountAADTenantID - The account Azure Active Directory tenant id
	AutomationRulePropertyConditionSupportedPropertyAccountAADTenantID AutomationRulePropertyConditionSupportedProperty = "AccountAadTenantId"
	// AutomationRulePropertyConditionSupportedPropertyAccountAADUserID - The account Azure Active Directory user id
	AutomationRulePropertyConditionSupportedPropertyAccountAADUserID AutomationRulePropertyConditionSupportedProperty = "AccountAadUserId"
	// AutomationRulePropertyConditionSupportedPropertyAccountNTDomain - The account NetBIOS domain name
	AutomationRulePropertyConditionSupportedPropertyAccountNTDomain AutomationRulePropertyConditionSupportedProperty = "AccountNTDomain"
	// AutomationRulePropertyConditionSupportedPropertyAccountName - The account name
	AutomationRulePropertyConditionSupportedPropertyAccountName AutomationRulePropertyConditionSupportedProperty = "AccountName"
	// AutomationRulePropertyConditionSupportedPropertyAccountObjectGUID - The account unique identifier
	AutomationRulePropertyConditionSupportedPropertyAccountObjectGUID AutomationRulePropertyConditionSupportedProperty = "AccountObjectGuid"
	// AutomationRulePropertyConditionSupportedPropertyAccountPUID - The account Azure Active Directory Passport User ID
	AutomationRulePropertyConditionSupportedPropertyAccountPUID AutomationRulePropertyConditionSupportedProperty = "AccountPUID"
	// AutomationRulePropertyConditionSupportedPropertyAccountSid - The account security identifier
	AutomationRulePropertyConditionSupportedPropertyAccountSid AutomationRulePropertyConditionSupportedProperty = "AccountSid"
	// AutomationRulePropertyConditionSupportedPropertyAccountUPNSuffix - The account user principal name suffix
	AutomationRulePropertyConditionSupportedPropertyAccountUPNSuffix AutomationRulePropertyConditionSupportedProperty = "AccountUPNSuffix"
	// AutomationRulePropertyConditionSupportedPropertyAlertAnalyticRuleIDs - The analytic rule ids of the alert
	AutomationRulePropertyConditionSupportedPropertyAlertAnalyticRuleIDs AutomationRulePropertyConditionSupportedProperty = "AlertAnalyticRuleIds"
	// AutomationRulePropertyConditionSupportedPropertyAlertProductNames - The name of the product of the alert
	AutomationRulePropertyConditionSupportedPropertyAlertProductNames AutomationRulePropertyConditionSupportedProperty = "AlertProductNames"
	// AutomationRulePropertyConditionSupportedPropertyAzureResourceResourceID - The Azure resource id
	AutomationRulePropertyConditionSupportedPropertyAzureResourceResourceID AutomationRulePropertyConditionSupportedProperty = "AzureResourceResourceId"
	// AutomationRulePropertyConditionSupportedPropertyAzureResourceSubscriptionID - The Azure resource subscription id
	AutomationRulePropertyConditionSupportedPropertyAzureResourceSubscriptionID AutomationRulePropertyConditionSupportedProperty = "AzureResourceSubscriptionId"
	// AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppID - The cloud application identifier
	AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppID AutomationRulePropertyConditionSupportedProperty = "CloudApplicationAppId"
	// AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppName - The cloud application name
	AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppName AutomationRulePropertyConditionSupportedProperty = "CloudApplicationAppName"
	// AutomationRulePropertyConditionSupportedPropertyDNSDomainName - The dns record domain name
	AutomationRulePropertyConditionSupportedPropertyDNSDomainName AutomationRulePropertyConditionSupportedProperty = "DNSDomainName"
	// AutomationRulePropertyConditionSupportedPropertyFileDirectory - The file directory full path
	AutomationRulePropertyConditionSupportedPropertyFileDirectory AutomationRulePropertyConditionSupportedProperty = "FileDirectory"
	// AutomationRulePropertyConditionSupportedPropertyFileHashValue - The file hash value
	AutomationRulePropertyConditionSupportedPropertyFileHashValue AutomationRulePropertyConditionSupportedProperty = "FileHashValue"
	// AutomationRulePropertyConditionSupportedPropertyFileName - The file name without path
	AutomationRulePropertyConditionSupportedPropertyFileName AutomationRulePropertyConditionSupportedProperty = "FileName"
	// AutomationRulePropertyConditionSupportedPropertyHostAzureID - The host Azure resource id
	AutomationRulePropertyConditionSupportedPropertyHostAzureID AutomationRulePropertyConditionSupportedProperty = "HostAzureID"
	// AutomationRulePropertyConditionSupportedPropertyHostNTDomain - The host NT domain
	AutomationRulePropertyConditionSupportedPropertyHostNTDomain AutomationRulePropertyConditionSupportedProperty = "HostNTDomain"
	// AutomationRulePropertyConditionSupportedPropertyHostName - The host name without domain
	AutomationRulePropertyConditionSupportedPropertyHostName AutomationRulePropertyConditionSupportedProperty = "HostName"
	// AutomationRulePropertyConditionSupportedPropertyHostNetBiosName - The host NetBIOS name
	AutomationRulePropertyConditionSupportedPropertyHostNetBiosName AutomationRulePropertyConditionSupportedProperty = "HostNetBiosName"
	// AutomationRulePropertyConditionSupportedPropertyHostOSVersion - The host operating system
	AutomationRulePropertyConditionSupportedPropertyHostOSVersion AutomationRulePropertyConditionSupportedProperty = "HostOSVersion"
	// AutomationRulePropertyConditionSupportedPropertyIPAddress - The IP address
	AutomationRulePropertyConditionSupportedPropertyIPAddress AutomationRulePropertyConditionSupportedProperty = "IPAddress"
	// AutomationRulePropertyConditionSupportedPropertyIncidentCustomDetailsKey - The incident custom detail key
	AutomationRulePropertyConditionSupportedPropertyIncidentCustomDetailsKey AutomationRulePropertyConditionSupportedProperty = "IncidentCustomDetailsKey"
	// AutomationRulePropertyConditionSupportedPropertyIncidentCustomDetailsValue - The incident custom detail value
	AutomationRulePropertyConditionSupportedPropertyIncidentCustomDetailsValue AutomationRulePropertyConditionSupportedProperty = "IncidentCustomDetailsValue"
	// AutomationRulePropertyConditionSupportedPropertyIncidentDescription - The description of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentDescription AutomationRulePropertyConditionSupportedProperty = "IncidentDescription"
	// AutomationRulePropertyConditionSupportedPropertyIncidentLabel - The labels of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentLabel AutomationRulePropertyConditionSupportedProperty = "IncidentLabel"
	// AutomationRulePropertyConditionSupportedPropertyIncidentProviderName - The provider name of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentProviderName AutomationRulePropertyConditionSupportedProperty = "IncidentProviderName"
	// AutomationRulePropertyConditionSupportedPropertyIncidentRelatedAnalyticRuleIDs - The related Analytic rule ids of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentRelatedAnalyticRuleIDs AutomationRulePropertyConditionSupportedProperty = "IncidentRelatedAnalyticRuleIds"
	// AutomationRulePropertyConditionSupportedPropertyIncidentSeverity - The severity of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentSeverity AutomationRulePropertyConditionSupportedProperty = "IncidentSeverity"
	// AutomationRulePropertyConditionSupportedPropertyIncidentStatus - The status of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentStatus AutomationRulePropertyConditionSupportedProperty = "IncidentStatus"
	// AutomationRulePropertyConditionSupportedPropertyIncidentTactics - The tactics of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentTactics AutomationRulePropertyConditionSupportedProperty = "IncidentTactics"
	// AutomationRulePropertyConditionSupportedPropertyIncidentTitle - The title of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentTitle AutomationRulePropertyConditionSupportedProperty = "IncidentTitle"
	// AutomationRulePropertyConditionSupportedPropertyIncidentUpdatedBySource - The update source of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentUpdatedBySource AutomationRulePropertyConditionSupportedProperty = "IncidentUpdatedBySource"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceID - "The IoT device id
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceID AutomationRulePropertyConditionSupportedProperty = "IoTDeviceId"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceModel - The IoT device model
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceModel AutomationRulePropertyConditionSupportedProperty = "IoTDeviceModel"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceName - The IoT device name
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceName AutomationRulePropertyConditionSupportedProperty = "IoTDeviceName"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceOperatingSystem - The IoT device operating system
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceOperatingSystem AutomationRulePropertyConditionSupportedProperty = "IoTDeviceOperatingSystem"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceType - The IoT device type
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceType AutomationRulePropertyConditionSupportedProperty = "IoTDeviceType"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceVendor - The IoT device vendor
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceVendor AutomationRulePropertyConditionSupportedProperty = "IoTDeviceVendor"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryAction - The mail message delivery action
	AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryAction AutomationRulePropertyConditionSupportedProperty = "MailMessageDeliveryAction"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryLocation - The mail message delivery location
	AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryLocation AutomationRulePropertyConditionSupportedProperty = "MailMessageDeliveryLocation"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageP1Sender - The mail message P1 sender
	AutomationRulePropertyConditionSupportedPropertyMailMessageP1Sender AutomationRulePropertyConditionSupportedProperty = "MailMessageP1Sender"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageP2Sender - The mail message P2 sender
	AutomationRulePropertyConditionSupportedPropertyMailMessageP2Sender AutomationRulePropertyConditionSupportedProperty = "MailMessageP2Sender"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageRecipient - The mail message recipient
	AutomationRulePropertyConditionSupportedPropertyMailMessageRecipient AutomationRulePropertyConditionSupportedProperty = "MailMessageRecipient"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageSenderIP - The mail message sender IP address
	AutomationRulePropertyConditionSupportedPropertyMailMessageSenderIP AutomationRulePropertyConditionSupportedProperty = "MailMessageSenderIP"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageSubject - The mail message subject
	AutomationRulePropertyConditionSupportedPropertyMailMessageSubject AutomationRulePropertyConditionSupportedProperty = "MailMessageSubject"
	// AutomationRulePropertyConditionSupportedPropertyMailboxDisplayName - The mailbox display name
	AutomationRulePropertyConditionSupportedPropertyMailboxDisplayName AutomationRulePropertyConditionSupportedProperty = "MailboxDisplayName"
	// AutomationRulePropertyConditionSupportedPropertyMailboxPrimaryAddress - The mailbox primary address
	AutomationRulePropertyConditionSupportedPropertyMailboxPrimaryAddress AutomationRulePropertyConditionSupportedProperty = "MailboxPrimaryAddress"
	// AutomationRulePropertyConditionSupportedPropertyMailboxUPN - The mailbox user principal name
	AutomationRulePropertyConditionSupportedPropertyMailboxUPN AutomationRulePropertyConditionSupportedProperty = "MailboxUPN"
	// AutomationRulePropertyConditionSupportedPropertyMalwareCategory - The malware category
	AutomationRulePropertyConditionSupportedPropertyMalwareCategory AutomationRulePropertyConditionSupportedProperty = "MalwareCategory"
	// AutomationRulePropertyConditionSupportedPropertyMalwareName - The malware name
	AutomationRulePropertyConditionSupportedPropertyMalwareName AutomationRulePropertyConditionSupportedProperty = "MalwareName"
	// AutomationRulePropertyConditionSupportedPropertyProcessCommandLine - The process execution command line
	AutomationRulePropertyConditionSupportedPropertyProcessCommandLine AutomationRulePropertyConditionSupportedProperty = "ProcessCommandLine"
	// AutomationRulePropertyConditionSupportedPropertyProcessID - The process id
	AutomationRulePropertyConditionSupportedPropertyProcessID AutomationRulePropertyConditionSupportedProperty = "ProcessId"
	// AutomationRulePropertyConditionSupportedPropertyRegistryKey - The registry key path
	AutomationRulePropertyConditionSupportedPropertyRegistryKey AutomationRulePropertyConditionSupportedProperty = "RegistryKey"
	// AutomationRulePropertyConditionSupportedPropertyRegistryValueData - The registry key value in string formatted representation
	AutomationRulePropertyConditionSupportedPropertyRegistryValueData AutomationRulePropertyConditionSupportedProperty = "RegistryValueData"
	// AutomationRulePropertyConditionSupportedPropertyURL - The url
	AutomationRulePropertyConditionSupportedPropertyURL AutomationRulePropertyConditionSupportedProperty = "Url"
)

// PossibleAutomationRulePropertyConditionSupportedPropertyValues returns the possible values for the AutomationRulePropertyConditionSupportedProperty const type.
func PossibleAutomationRulePropertyConditionSupportedPropertyValues() []AutomationRulePropertyConditionSupportedProperty {
	return []AutomationRulePropertyConditionSupportedProperty{
		AutomationRulePropertyConditionSupportedPropertyAccountAADTenantID,
		AutomationRulePropertyConditionSupportedPropertyAccountAADUserID,
		AutomationRulePropertyConditionSupportedPropertyAccountNTDomain,
		AutomationRulePropertyConditionSupportedPropertyAccountName,
		AutomationRulePropertyConditionSupportedPropertyAccountObjectGUID,
		AutomationRulePropertyConditionSupportedPropertyAccountPUID,
		AutomationRulePropertyConditionSupportedPropertyAccountSid,
		AutomationRulePropertyConditionSupportedPropertyAccountUPNSuffix,
		AutomationRulePropertyConditionSupportedPropertyAlertAnalyticRuleIDs,
		AutomationRulePropertyConditionSupportedPropertyAlertProductNames,
		AutomationRulePropertyConditionSupportedPropertyAzureResourceResourceID,
		AutomationRulePropertyConditionSupportedPropertyAzureResourceSubscriptionID,
		AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppID,
		AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppName,
		AutomationRulePropertyConditionSupportedPropertyDNSDomainName,
		AutomationRulePropertyConditionSupportedPropertyFileDirectory,
		AutomationRulePropertyConditionSupportedPropertyFileHashValue,
		AutomationRulePropertyConditionSupportedPropertyFileName,
		AutomationRulePropertyConditionSupportedPropertyHostAzureID,
		AutomationRulePropertyConditionSupportedPropertyHostNTDomain,
		AutomationRulePropertyConditionSupportedPropertyHostName,
		AutomationRulePropertyConditionSupportedPropertyHostNetBiosName,
		AutomationRulePropertyConditionSupportedPropertyHostOSVersion,
		AutomationRulePropertyConditionSupportedPropertyIPAddress,
		AutomationRulePropertyConditionSupportedPropertyIncidentCustomDetailsKey,
		AutomationRulePropertyConditionSupportedPropertyIncidentCustomDetailsValue,
		AutomationRulePropertyConditionSupportedPropertyIncidentDescription,
		AutomationRulePropertyConditionSupportedPropertyIncidentLabel,
		AutomationRulePropertyConditionSupportedPropertyIncidentProviderName,
		AutomationRulePropertyConditionSupportedPropertyIncidentRelatedAnalyticRuleIDs,
		AutomationRulePropertyConditionSupportedPropertyIncidentSeverity,
		AutomationRulePropertyConditionSupportedPropertyIncidentStatus,
		AutomationRulePropertyConditionSupportedPropertyIncidentTactics,
		AutomationRulePropertyConditionSupportedPropertyIncidentTitle,
		AutomationRulePropertyConditionSupportedPropertyIncidentUpdatedBySource,
		AutomationRulePropertyConditionSupportedPropertyIoTDeviceID,
		AutomationRulePropertyConditionSupportedPropertyIoTDeviceModel,
		AutomationRulePropertyConditionSupportedPropertyIoTDeviceName,
		AutomationRulePropertyConditionSupportedPropertyIoTDeviceOperatingSystem,
		AutomationRulePropertyConditionSupportedPropertyIoTDeviceType,
		AutomationRulePropertyConditionSupportedPropertyIoTDeviceVendor,
		AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryAction,
		AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryLocation,
		AutomationRulePropertyConditionSupportedPropertyMailMessageP1Sender,
		AutomationRulePropertyConditionSupportedPropertyMailMessageP2Sender,
		AutomationRulePropertyConditionSupportedPropertyMailMessageRecipient,
		AutomationRulePropertyConditionSupportedPropertyMailMessageSenderIP,
		AutomationRulePropertyConditionSupportedPropertyMailMessageSubject,
		AutomationRulePropertyConditionSupportedPropertyMailboxDisplayName,
		AutomationRulePropertyConditionSupportedPropertyMailboxPrimaryAddress,
		AutomationRulePropertyConditionSupportedPropertyMailboxUPN,
		AutomationRulePropertyConditionSupportedPropertyMalwareCategory,
		AutomationRulePropertyConditionSupportedPropertyMalwareName,
		AutomationRulePropertyConditionSupportedPropertyProcessCommandLine,
		AutomationRulePropertyConditionSupportedPropertyProcessID,
		AutomationRulePropertyConditionSupportedPropertyRegistryKey,
		AutomationRulePropertyConditionSupportedPropertyRegistryValueData,
		AutomationRulePropertyConditionSupportedPropertyURL,
	}
}

type ConditionType string

const (
	// ConditionTypeBoolean - Apply a boolean operator (e.g AND, OR) to conditions
	ConditionTypeBoolean ConditionType = "Boolean"
	// ConditionTypeProperty - Evaluate an object property value
	ConditionTypeProperty ConditionType = "Property"
	// ConditionTypePropertyArray - Evaluate an object array property value
	ConditionTypePropertyArray ConditionType = "PropertyArray"
	// ConditionTypePropertyArrayChanged - Evaluate an object array property changed value
	ConditionTypePropertyArrayChanged ConditionType = "PropertyArrayChanged"
	// ConditionTypePropertyChanged - Evaluate an object property changed value
	ConditionTypePropertyChanged ConditionType = "PropertyChanged"
)

// PossibleConditionTypeValues returns the possible values for the ConditionType const type.
func PossibleConditionTypeValues() []ConditionType {
	return []ConditionType{
		ConditionTypeBoolean,
		ConditionTypeProperty,
		ConditionTypePropertyArray,
		ConditionTypePropertyArrayChanged,
		ConditionTypePropertyChanged,
	}
}

// ConfidenceLevel - The confidence level of this alert.
type ConfidenceLevel string

const (
	// ConfidenceLevelHigh - High confidence that the alert is true positive malicious
	ConfidenceLevelHigh ConfidenceLevel = "High"
	// ConfidenceLevelLow - Low confidence, meaning we have some doubts this is indeed malicious or part of an attack
	ConfidenceLevelLow ConfidenceLevel = "Low"
	// ConfidenceLevelUnknown - Unknown confidence, the is the default value
	ConfidenceLevelUnknown ConfidenceLevel = "Unknown"
)

// PossibleConfidenceLevelValues returns the possible values for the ConfidenceLevel const type.
func PossibleConfidenceLevelValues() []ConfidenceLevel {
	return []ConfidenceLevel{
		ConfidenceLevelHigh,
		ConfidenceLevelLow,
		ConfidenceLevelUnknown,
	}
}

// ConfidenceScoreStatus - The confidence score calculation status, i.e. indicating if score calculation is pending for this
// alert, not applicable or final.
type ConfidenceScoreStatus string

const (
	// ConfidenceScoreStatusFinal - Final score was calculated and available
	ConfidenceScoreStatusFinal ConfidenceScoreStatus = "Final"
	// ConfidenceScoreStatusInProcess - No score was set yet and calculation is in progress
	ConfidenceScoreStatusInProcess ConfidenceScoreStatus = "InProcess"
	// ConfidenceScoreStatusNotApplicable - Score will not be calculated for this alert as it is not supported by virtual analyst
	ConfidenceScoreStatusNotApplicable ConfidenceScoreStatus = "NotApplicable"
	// ConfidenceScoreStatusNotFinal - Score is calculated and shown as part of the alert, but may be updated again at a later
	// time following the processing of additional data
	ConfidenceScoreStatusNotFinal ConfidenceScoreStatus = "NotFinal"
)

// PossibleConfidenceScoreStatusValues returns the possible values for the ConfidenceScoreStatus const type.
func PossibleConfidenceScoreStatusValues() []ConfidenceScoreStatus {
	return []ConfidenceScoreStatus{
		ConfidenceScoreStatusFinal,
		ConfidenceScoreStatusInProcess,
		ConfidenceScoreStatusNotApplicable,
		ConfidenceScoreStatusNotFinal,
	}
}

// ConnectAuthKind - The authentication kind used to poll the data
type ConnectAuthKind string

const (
	ConnectAuthKindAPIKey ConnectAuthKind = "APIKey"
	ConnectAuthKindBasic  ConnectAuthKind = "Basic"
	ConnectAuthKindOAuth2 ConnectAuthKind = "OAuth2"
)

// PossibleConnectAuthKindValues returns the possible values for the ConnectAuthKind const type.
func PossibleConnectAuthKindValues() []ConnectAuthKind {
	return []ConnectAuthKind{
		ConnectAuthKindAPIKey,
		ConnectAuthKindBasic,
		ConnectAuthKindOAuth2,
	}
}

// ConnectivityType - type of connectivity
type ConnectivityType string

const (
	ConnectivityTypeIsConnectedQuery ConnectivityType = "IsConnectedQuery"
)

// PossibleConnectivityTypeValues returns the possible values for the ConnectivityType const type.
func PossibleConnectivityTypeValues() []ConnectivityType {
	return []ConnectivityType{
		ConnectivityTypeIsConnectedQuery,
	}
}

// ContentType - The content type of a source control path.
type ContentType string

const (
	ContentTypeAnalyticRule ContentType = "AnalyticRule"
	ContentTypeWorkbook     ContentType = "Workbook"
)

// PossibleContentTypeValues returns the possible values for the ContentType const type.
func PossibleContentTypeValues() []ContentType {
	return []ContentType{
		ContentTypeAnalyticRule,
		ContentTypeWorkbook,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// CustomEntityQueryKind - The kind of the entity query that supports put request.
type CustomEntityQueryKind string

const (
	CustomEntityQueryKindActivity CustomEntityQueryKind = "Activity"
)

// PossibleCustomEntityQueryKindValues returns the possible values for the CustomEntityQueryKind const type.
func PossibleCustomEntityQueryKindValues() []CustomEntityQueryKind {
	return []CustomEntityQueryKind{
		CustomEntityQueryKindActivity,
	}
}

// DataConnectorAuthorizationState - Describes the state of user's authorization for a connector kind.
type DataConnectorAuthorizationState string

const (
	DataConnectorAuthorizationStateInvalid DataConnectorAuthorizationState = "Invalid"
	DataConnectorAuthorizationStateValid   DataConnectorAuthorizationState = "Valid"
)

// PossibleDataConnectorAuthorizationStateValues returns the possible values for the DataConnectorAuthorizationState const type.
func PossibleDataConnectorAuthorizationStateValues() []DataConnectorAuthorizationState {
	return []DataConnectorAuthorizationState{
		DataConnectorAuthorizationStateInvalid,
		DataConnectorAuthorizationStateValid,
	}
}

// DataConnectorKind - The kind of the data connector
type DataConnectorKind string

const (
	DataConnectorKindAPIPolling                                DataConnectorKind = "APIPolling"
	DataConnectorKindAmazonWebServicesCloudTrail               DataConnectorKind = "AmazonWebServicesCloudTrail"
	DataConnectorKindAmazonWebServicesS3                       DataConnectorKind = "AmazonWebServicesS3"
	DataConnectorKindAzureActiveDirectory                      DataConnectorKind = "AzureActiveDirectory"
	DataConnectorKindAzureAdvancedThreatProtection             DataConnectorKind = "AzureAdvancedThreatProtection"
	DataConnectorKindAzureSecurityCenter                       DataConnectorKind = "AzureSecurityCenter"
	DataConnectorKindDynamics365                               DataConnectorKind = "Dynamics365"
	DataConnectorKindGenericUI                                 DataConnectorKind = "GenericUI"
	DataConnectorKindIOT                                       DataConnectorKind = "IOT"
	DataConnectorKindMicrosoftCloudAppSecurity                 DataConnectorKind = "MicrosoftCloudAppSecurity"
	DataConnectorKindMicrosoftDefenderAdvancedThreatProtection DataConnectorKind = "MicrosoftDefenderAdvancedThreatProtection"
	DataConnectorKindMicrosoftThreatIntelligence               DataConnectorKind = "MicrosoftThreatIntelligence"
	DataConnectorKindMicrosoftThreatProtection                 DataConnectorKind = "MicrosoftThreatProtection"
	DataConnectorKindOffice365                                 DataConnectorKind = "Office365"
	DataConnectorKindOffice365Project                          DataConnectorKind = "Office365Project"
	DataConnectorKindOfficeATP                                 DataConnectorKind = "OfficeATP"
	DataConnectorKindOfficeIRM                                 DataConnectorKind = "OfficeIRM"
	DataConnectorKindOfficePowerBI                             DataConnectorKind = "OfficePowerBI"
	DataConnectorKindThreatIntelligence                        DataConnectorKind = "ThreatIntelligence"
	DataConnectorKindThreatIntelligenceTaxii                   DataConnectorKind = "ThreatIntelligenceTaxii"
)

// PossibleDataConnectorKindValues returns the possible values for the DataConnectorKind const type.
func PossibleDataConnectorKindValues() []DataConnectorKind {
	return []DataConnectorKind{
		DataConnectorKindAPIPolling,
		DataConnectorKindAmazonWebServicesCloudTrail,
		DataConnectorKindAmazonWebServicesS3,
		DataConnectorKindAzureActiveDirectory,
		DataConnectorKindAzureAdvancedThreatProtection,
		DataConnectorKindAzureSecurityCenter,
		DataConnectorKindDynamics365,
		DataConnectorKindGenericUI,
		DataConnectorKindIOT,
		DataConnectorKindMicrosoftCloudAppSecurity,
		DataConnectorKindMicrosoftDefenderAdvancedThreatProtection,
		DataConnectorKindMicrosoftThreatIntelligence,
		DataConnectorKindMicrosoftThreatProtection,
		DataConnectorKindOffice365,
		DataConnectorKindOffice365Project,
		DataConnectorKindOfficeATP,
		DataConnectorKindOfficeIRM,
		DataConnectorKindOfficePowerBI,
		DataConnectorKindThreatIntelligence,
		DataConnectorKindThreatIntelligenceTaxii,
	}
}

// DataConnectorLicenseState - Describes the state of user's license for a connector kind.
type DataConnectorLicenseState string

const (
	DataConnectorLicenseStateInvalid DataConnectorLicenseState = "Invalid"
	DataConnectorLicenseStateUnknown DataConnectorLicenseState = "Unknown"
	DataConnectorLicenseStateValid   DataConnectorLicenseState = "Valid"
)

// PossibleDataConnectorLicenseStateValues returns the possible values for the DataConnectorLicenseState const type.
func PossibleDataConnectorLicenseStateValues() []DataConnectorLicenseState {
	return []DataConnectorLicenseState{
		DataConnectorLicenseStateInvalid,
		DataConnectorLicenseStateUnknown,
		DataConnectorLicenseStateValid,
	}
}

// DataTypeState - Describe whether this data type connection is enabled or not.
type DataTypeState string

const (
	DataTypeStateDisabled DataTypeState = "Disabled"
	DataTypeStateEnabled  DataTypeState = "Enabled"
)

// PossibleDataTypeStateValues returns the possible values for the DataTypeState const type.
func PossibleDataTypeStateValues() []DataTypeState {
	return []DataTypeState{
		DataTypeStateDisabled,
		DataTypeStateEnabled,
	}
}

// DeleteStatus - Indicates whether the file was deleted from the storage account.
type DeleteStatus string

const (
	// DeleteStatusDeleted - The file was deleted.
	DeleteStatusDeleted DeleteStatus = "Deleted"
	// DeleteStatusNotDeleted - The file was not deleted.
	DeleteStatusNotDeleted DeleteStatus = "NotDeleted"
	// DeleteStatusUnspecified - Unspecified
	DeleteStatusUnspecified DeleteStatus = "Unspecified"
)

// PossibleDeleteStatusValues returns the possible values for the DeleteStatus const type.
func PossibleDeleteStatusValues() []DeleteStatus {
	return []DeleteStatus{
		DeleteStatusDeleted,
		DeleteStatusNotDeleted,
		DeleteStatusUnspecified,
	}
}

// DeliveryAction - The delivery action of this mail message like Delivered, Blocked, Replaced etc
type DeliveryAction string

const (
	// DeliveryActionUnknown - Unknown
	DeliveryActionUnknown DeliveryAction = "Unknown"
	// DeliveryActionDeliveredAsSpam - DeliveredAsSpam
	DeliveryActionDeliveredAsSpam DeliveryAction = "DeliveredAsSpam"
	// DeliveryActionDelivered - Delivered
	DeliveryActionDelivered DeliveryAction = "Delivered"
	// DeliveryActionBlocked - Blocked
	DeliveryActionBlocked DeliveryAction = "Blocked"
	// DeliveryActionReplaced - Replaced
	DeliveryActionReplaced DeliveryAction = "Replaced"
)

// PossibleDeliveryActionValues returns the possible values for the DeliveryAction const type.
func PossibleDeliveryActionValues() []DeliveryAction {
	return []DeliveryAction{
		DeliveryActionUnknown,
		DeliveryActionDeliveredAsSpam,
		DeliveryActionDelivered,
		DeliveryActionBlocked,
		DeliveryActionReplaced,
	}
}

// DeliveryLocation - The delivery location of this mail message like Inbox, JunkFolder etc
type DeliveryLocation string

const (
	// DeliveryLocationUnknown - Unknown
	DeliveryLocationUnknown DeliveryLocation = "Unknown"
	// DeliveryLocationInbox - Inbox
	DeliveryLocationInbox DeliveryLocation = "Inbox"
	// DeliveryLocationJunkFolder - JunkFolder
	DeliveryLocationJunkFolder DeliveryLocation = "JunkFolder"
	// DeliveryLocationDeletedFolder - DeletedFolder
	DeliveryLocationDeletedFolder DeliveryLocation = "DeletedFolder"
	// DeliveryLocationQuarantine - Quarantine
	DeliveryLocationQuarantine DeliveryLocation = "Quarantine"
	// DeliveryLocationExternal - External
	DeliveryLocationExternal DeliveryLocation = "External"
	// DeliveryLocationFailed - Failed
	DeliveryLocationFailed DeliveryLocation = "Failed"
	// DeliveryLocationDropped - Dropped
	DeliveryLocationDropped DeliveryLocation = "Dropped"
	// DeliveryLocationForwarded - Forwarded
	DeliveryLocationForwarded DeliveryLocation = "Forwarded"
)

// PossibleDeliveryLocationValues returns the possible values for the DeliveryLocation const type.
func PossibleDeliveryLocationValues() []DeliveryLocation {
	return []DeliveryLocation{
		DeliveryLocationUnknown,
		DeliveryLocationInbox,
		DeliveryLocationJunkFolder,
		DeliveryLocationDeletedFolder,
		DeliveryLocationQuarantine,
		DeliveryLocationExternal,
		DeliveryLocationFailed,
		DeliveryLocationDropped,
		DeliveryLocationForwarded,
	}
}

// DeploymentFetchStatus - Status while trying to fetch the deployment information.
type DeploymentFetchStatus string

const (
	DeploymentFetchStatusNotFound     DeploymentFetchStatus = "NotFound"
	DeploymentFetchStatusSuccess      DeploymentFetchStatus = "Success"
	DeploymentFetchStatusUnauthorized DeploymentFetchStatus = "Unauthorized"
)

// PossibleDeploymentFetchStatusValues returns the possible values for the DeploymentFetchStatus const type.
func PossibleDeploymentFetchStatusValues() []DeploymentFetchStatus {
	return []DeploymentFetchStatus{
		DeploymentFetchStatusNotFound,
		DeploymentFetchStatusSuccess,
		DeploymentFetchStatusUnauthorized,
	}
}

// DeploymentResult - Status while trying to fetch the deployment information.
type DeploymentResult string

const (
	DeploymentResultCanceled DeploymentResult = "Canceled"
	DeploymentResultFailed   DeploymentResult = "Failed"
	DeploymentResultSuccess  DeploymentResult = "Success"
)

// PossibleDeploymentResultValues returns the possible values for the DeploymentResult const type.
func PossibleDeploymentResultValues() []DeploymentResult {
	return []DeploymentResult{
		DeploymentResultCanceled,
		DeploymentResultFailed,
		DeploymentResultSuccess,
	}
}

// DeploymentState - The current state of the deployment.
type DeploymentState string

const (
	DeploymentStateCanceling  DeploymentState = "Canceling"
	DeploymentStateCompleted  DeploymentState = "Completed"
	DeploymentStateInProgress DeploymentState = "In_Progress"
	DeploymentStateQueued     DeploymentState = "Queued"
)

// PossibleDeploymentStateValues returns the possible values for the DeploymentState const type.
func PossibleDeploymentStateValues() []DeploymentState {
	return []DeploymentState{
		DeploymentStateCanceling,
		DeploymentStateCompleted,
		DeploymentStateInProgress,
		DeploymentStateQueued,
	}
}

// DeviceImportance - Device importance, determines if the device classified as 'crown jewel'
type DeviceImportance string

const (
	// DeviceImportanceHigh - High
	DeviceImportanceHigh DeviceImportance = "High"
	// DeviceImportanceLow - Low
	DeviceImportanceLow DeviceImportance = "Low"
	// DeviceImportanceNormal - Normal
	DeviceImportanceNormal DeviceImportance = "Normal"
	// DeviceImportanceUnknown - Unknown - Default value
	DeviceImportanceUnknown DeviceImportance = "Unknown"
)

// PossibleDeviceImportanceValues returns the possible values for the DeviceImportance const type.
func PossibleDeviceImportanceValues() []DeviceImportance {
	return []DeviceImportance{
		DeviceImportanceHigh,
		DeviceImportanceLow,
		DeviceImportanceNormal,
		DeviceImportanceUnknown,
	}
}

// ElevationToken - The elevation token associated with the process.
type ElevationToken string

const (
	// ElevationTokenDefault - Default elevation token
	ElevationTokenDefault ElevationToken = "Default"
	// ElevationTokenFull - Full elevation token
	ElevationTokenFull ElevationToken = "Full"
	// ElevationTokenLimited - Limited elevation token
	ElevationTokenLimited ElevationToken = "Limited"
)

// PossibleElevationTokenValues returns the possible values for the ElevationToken const type.
func PossibleElevationTokenValues() []ElevationToken {
	return []ElevationToken{
		ElevationTokenDefault,
		ElevationTokenFull,
		ElevationTokenLimited,
	}
}

type EntityItemQueryKind string

const (
	// EntityItemQueryKindInsight - insight
	EntityItemQueryKindInsight EntityItemQueryKind = "Insight"
)

// PossibleEntityItemQueryKindValues returns the possible values for the EntityItemQueryKind const type.
func PossibleEntityItemQueryKindValues() []EntityItemQueryKind {
	return []EntityItemQueryKind{
		EntityItemQueryKindInsight,
	}
}

// EntityKind - The kind of the entity
type EntityKind string

const (
	// EntityKindAccount - Entity represents account in the system.
	EntityKindAccount EntityKind = "Account"
	// EntityKindAzureResource - Entity represents azure resource in the system.
	EntityKindAzureResource EntityKind = "AzureResource"
	// EntityKindBookmark - Entity represents bookmark in the system.
	EntityKindBookmark EntityKind = "Bookmark"
	// EntityKindCloudApplication - Entity represents cloud application in the system.
	EntityKindCloudApplication EntityKind = "CloudApplication"
	// EntityKindDNSResolution - Entity represents dns resolution in the system.
	EntityKindDNSResolution EntityKind = "DnsResolution"
	// EntityKindFile - Entity represents file in the system.
	EntityKindFile EntityKind = "File"
	// EntityKindFileHash - Entity represents file hash in the system.
	EntityKindFileHash EntityKind = "FileHash"
	// EntityKindHost - Entity represents host in the system.
	EntityKindHost EntityKind = "Host"
	// EntityKindIP - Entity represents ip in the system.
	EntityKindIP EntityKind = "Ip"
	// EntityKindIoTDevice - Entity represents IoT device in the system.
	EntityKindIoTDevice EntityKind = "IoTDevice"
	// EntityKindMailCluster - Entity represents mail cluster in the system.
	EntityKindMailCluster EntityKind = "MailCluster"
	// EntityKindMailMessage - Entity represents mail message in the system.
	EntityKindMailMessage EntityKind = "MailMessage"
	// EntityKindMailbox - Entity represents mailbox in the system.
	EntityKindMailbox EntityKind = "Mailbox"
	// EntityKindMalware - Entity represents malware in the system.
	EntityKindMalware EntityKind = "Malware"
	// EntityKindNic - Entity represents network interface in the system.
	EntityKindNic EntityKind = "Nic"
	// EntityKindProcess - Entity represents process in the system.
	EntityKindProcess EntityKind = "Process"
	// EntityKindRegistryKey - Entity represents registry key in the system.
	EntityKindRegistryKey EntityKind = "RegistryKey"
	// EntityKindRegistryValue - Entity represents registry value in the system.
	EntityKindRegistryValue EntityKind = "RegistryValue"
	// EntityKindSecurityAlert - Entity represents security alert in the system.
	EntityKindSecurityAlert EntityKind = "SecurityAlert"
	// EntityKindSecurityGroup - Entity represents security group in the system.
	EntityKindSecurityGroup EntityKind = "SecurityGroup"
	// EntityKindSubmissionMail - Entity represents submission mail in the system.
	EntityKindSubmissionMail EntityKind = "SubmissionMail"
	// EntityKindURL - Entity represents url in the system.
	EntityKindURL EntityKind = "Url"
)

// PossibleEntityKindValues returns the possible values for the EntityKind const type.
func PossibleEntityKindValues() []EntityKind {
	return []EntityKind{
		EntityKindAccount,
		EntityKindAzureResource,
		EntityKindBookmark,
		EntityKindCloudApplication,
		EntityKindDNSResolution,
		EntityKindFile,
		EntityKindFileHash,
		EntityKindHost,
		EntityKindIP,
		EntityKindIoTDevice,
		EntityKindMailCluster,
		EntityKindMailMessage,
		EntityKindMailbox,
		EntityKindMalware,
		EntityKindNic,
		EntityKindProcess,
		EntityKindRegistryKey,
		EntityKindRegistryValue,
		EntityKindSecurityAlert,
		EntityKindSecurityGroup,
		EntityKindSubmissionMail,
		EntityKindURL,
	}
}

// EntityMappingType - The V3 type of the mapped entity
type EntityMappingType string

const (
	// EntityMappingTypeAccount - User account entity type
	EntityMappingTypeAccount EntityMappingType = "Account"
	// EntityMappingTypeAzureResource - Azure resource entity type
	EntityMappingTypeAzureResource EntityMappingType = "AzureResource"
	// EntityMappingTypeCloudApplication - Cloud app entity type
	EntityMappingTypeCloudApplication EntityMappingType = "CloudApplication"
	// EntityMappingTypeDNS - DNS entity type
	EntityMappingTypeDNS EntityMappingType = "DNS"
	// EntityMappingTypeFile - System file entity type
	EntityMappingTypeFile EntityMappingType = "File"
	// EntityMappingTypeFileHash - File-hash entity type
	EntityMappingTypeFileHash EntityMappingType = "FileHash"
	// EntityMappingTypeHost - Host entity type
	EntityMappingTypeHost EntityMappingType = "Host"
	// EntityMappingTypeIP - IP address entity type
	EntityMappingTypeIP EntityMappingType = "IP"
	// EntityMappingTypeMailCluster - Mail cluster entity type
	EntityMappingTypeMailCluster EntityMappingType = "MailCluster"
	// EntityMappingTypeMailMessage - Mail message entity type
	EntityMappingTypeMailMessage EntityMappingType = "MailMessage"
	// EntityMappingTypeMailbox - Mailbox entity type
	EntityMappingTypeMailbox EntityMappingType = "Mailbox"
	// EntityMappingTypeMalware - Malware entity type
	EntityMappingTypeMalware EntityMappingType = "Malware"
	// EntityMappingTypeProcess - Process entity type
	EntityMappingTypeProcess EntityMappingType = "Process"
	// EntityMappingTypeRegistryKey - Registry key entity type
	EntityMappingTypeRegistryKey EntityMappingType = "RegistryKey"
	// EntityMappingTypeRegistryValue - Registry value entity type
	EntityMappingTypeRegistryValue EntityMappingType = "RegistryValue"
	// EntityMappingTypeSecurityGroup - Security group entity type
	EntityMappingTypeSecurityGroup EntityMappingType = "SecurityGroup"
	// EntityMappingTypeSubmissionMail - Submission mail entity type
	EntityMappingTypeSubmissionMail EntityMappingType = "SubmissionMail"
	// EntityMappingTypeURL - URL entity type
	EntityMappingTypeURL EntityMappingType = "URL"
)

// PossibleEntityMappingTypeValues returns the possible values for the EntityMappingType const type.
func PossibleEntityMappingTypeValues() []EntityMappingType {
	return []EntityMappingType{
		EntityMappingTypeAccount,
		EntityMappingTypeAzureResource,
		EntityMappingTypeCloudApplication,
		EntityMappingTypeDNS,
		EntityMappingTypeFile,
		EntityMappingTypeFileHash,
		EntityMappingTypeHost,
		EntityMappingTypeIP,
		EntityMappingTypeMailCluster,
		EntityMappingTypeMailMessage,
		EntityMappingTypeMailbox,
		EntityMappingTypeMalware,
		EntityMappingTypeProcess,
		EntityMappingTypeRegistryKey,
		EntityMappingTypeRegistryValue,
		EntityMappingTypeSecurityGroup,
		EntityMappingTypeSubmissionMail,
		EntityMappingTypeURL,
	}
}

// EntityProviders - The entity provider that is synced.
type EntityProviders string

const (
	EntityProvidersActiveDirectory      EntityProviders = "ActiveDirectory"
	EntityProvidersAzureActiveDirectory EntityProviders = "AzureActiveDirectory"
)

// PossibleEntityProvidersValues returns the possible values for the EntityProviders const type.
func PossibleEntityProvidersValues() []EntityProviders {
	return []EntityProviders{
		EntityProvidersActiveDirectory,
		EntityProvidersAzureActiveDirectory,
	}
}

// EntityQueryKind - The kind of the entity query
type EntityQueryKind string

const (
	EntityQueryKindActivity  EntityQueryKind = "Activity"
	EntityQueryKindExpansion EntityQueryKind = "Expansion"
	EntityQueryKindInsight   EntityQueryKind = "Insight"
)

// PossibleEntityQueryKindValues returns the possible values for the EntityQueryKind const type.
func PossibleEntityQueryKindValues() []EntityQueryKind {
	return []EntityQueryKind{
		EntityQueryKindActivity,
		EntityQueryKindExpansion,
		EntityQueryKindInsight,
	}
}

// EntityQueryTemplateKind - The kind of the entity query template.
type EntityQueryTemplateKind string

const (
	EntityQueryTemplateKindActivity EntityQueryTemplateKind = "Activity"
)

// PossibleEntityQueryTemplateKindValues returns the possible values for the EntityQueryTemplateKind const type.
func PossibleEntityQueryTemplateKindValues() []EntityQueryTemplateKind {
	return []EntityQueryTemplateKind{
		EntityQueryTemplateKindActivity,
	}
}

// EntityTimelineKind - The entity query kind
type EntityTimelineKind string

const (
	// EntityTimelineKindActivity - activity
	EntityTimelineKindActivity EntityTimelineKind = "Activity"
	// EntityTimelineKindAnomaly - anomaly
	EntityTimelineKindAnomaly EntityTimelineKind = "Anomaly"
	// EntityTimelineKindBookmark - bookmarks
	EntityTimelineKindBookmark EntityTimelineKind = "Bookmark"
	// EntityTimelineKindSecurityAlert - security alerts
	EntityTimelineKindSecurityAlert EntityTimelineKind = "SecurityAlert"
)

// PossibleEntityTimelineKindValues returns the possible values for the EntityTimelineKind const type.
func PossibleEntityTimelineKindValues() []EntityTimelineKind {
	return []EntityTimelineKind{
		EntityTimelineKindActivity,
		EntityTimelineKindAnomaly,
		EntityTimelineKindBookmark,
		EntityTimelineKindSecurityAlert,
	}
}

// EntityType - The type of the entity
type EntityType string

const (
	// EntityTypeAccount - Entity represents account in the system.
	EntityTypeAccount EntityType = "Account"
	// EntityTypeAzureResource - Entity represents azure resource in the system.
	EntityTypeAzureResource EntityType = "AzureResource"
	// EntityTypeCloudApplication - Entity represents cloud application in the system.
	EntityTypeCloudApplication EntityType = "CloudApplication"
	// EntityTypeDNS - Entity represents dns in the system.
	EntityTypeDNS EntityType = "DNS"
	// EntityTypeFile - Entity represents file in the system.
	EntityTypeFile EntityType = "File"
	// EntityTypeFileHash - Entity represents file hash in the system.
	EntityTypeFileHash EntityType = "FileHash"
	// EntityTypeHost - Entity represents host in the system.
	EntityTypeHost EntityType = "Host"
	// EntityTypeHuntingBookmark - Entity represents HuntingBookmark in the system.
	EntityTypeHuntingBookmark EntityType = "HuntingBookmark"
	// EntityTypeIP - Entity represents ip in the system.
	EntityTypeIP EntityType = "IP"
	// EntityTypeIoTDevice - Entity represents IoT device in the system.
	EntityTypeIoTDevice EntityType = "IoTDevice"
	// EntityTypeMailCluster - Entity represents mail cluster in the system.
	EntityTypeMailCluster EntityType = "MailCluster"
	// EntityTypeMailMessage - Entity represents mail message in the system.
	EntityTypeMailMessage EntityType = "MailMessage"
	// EntityTypeMailbox - Entity represents mailbox in the system.
	EntityTypeMailbox EntityType = "Mailbox"
	// EntityTypeMalware - Entity represents malware in the system.
	EntityTypeMalware EntityType = "Malware"
	// EntityTypeNic - Entity represents network interface in the system.
	EntityTypeNic EntityType = "Nic"
	// EntityTypeProcess - Entity represents process in the system.
	EntityTypeProcess EntityType = "Process"
	// EntityTypeRegistryKey - Entity represents registry key in the system.
	EntityTypeRegistryKey EntityType = "RegistryKey"
	// EntityTypeRegistryValue - Entity represents registry value in the system.
	EntityTypeRegistryValue EntityType = "RegistryValue"
	// EntityTypeSecurityAlert - Entity represents security alert in the system.
	EntityTypeSecurityAlert EntityType = "SecurityAlert"
	// EntityTypeSecurityGroup - Entity represents security group in the system.
	EntityTypeSecurityGroup EntityType = "SecurityGroup"
	// EntityTypeSubmissionMail - Entity represents submission mail in the system.
	EntityTypeSubmissionMail EntityType = "SubmissionMail"
	// EntityTypeURL - Entity represents url in the system.
	EntityTypeURL EntityType = "URL"
)

// PossibleEntityTypeValues returns the possible values for the EntityType const type.
func PossibleEntityTypeValues() []EntityType {
	return []EntityType{
		EntityTypeAccount,
		EntityTypeAzureResource,
		EntityTypeCloudApplication,
		EntityTypeDNS,
		EntityTypeFile,
		EntityTypeFileHash,
		EntityTypeHost,
		EntityTypeHuntingBookmark,
		EntityTypeIP,
		EntityTypeIoTDevice,
		EntityTypeMailCluster,
		EntityTypeMailMessage,
		EntityTypeMailbox,
		EntityTypeMalware,
		EntityTypeNic,
		EntityTypeProcess,
		EntityTypeRegistryKey,
		EntityTypeRegistryValue,
		EntityTypeSecurityAlert,
		EntityTypeSecurityGroup,
		EntityTypeSubmissionMail,
		EntityTypeURL,
	}
}

type Enum13 string

const (
	Enum13Activity  Enum13 = "Activity"
	Enum13Expansion Enum13 = "Expansion"
)

// PossibleEnum13Values returns the possible values for the Enum13 const type.
func PossibleEnum13Values() []Enum13 {
	return []Enum13{
		Enum13Activity,
		Enum13Expansion,
	}
}

type Enum15 string

const (
	Enum15Activity Enum15 = "Activity"
)

// PossibleEnum15Values returns the possible values for the Enum15 const type.
func PossibleEnum15Values() []Enum15 {
	return []Enum15{
		Enum15Activity,
	}
}

// EventGroupingAggregationKind - The event grouping aggregation kinds
type EventGroupingAggregationKind string

const (
	EventGroupingAggregationKindAlertPerResult EventGroupingAggregationKind = "AlertPerResult"
	EventGroupingAggregationKindSingleAlert    EventGroupingAggregationKind = "SingleAlert"
)

// PossibleEventGroupingAggregationKindValues returns the possible values for the EventGroupingAggregationKind const type.
func PossibleEventGroupingAggregationKindValues() []EventGroupingAggregationKind {
	return []EventGroupingAggregationKind{
		EventGroupingAggregationKindAlertPerResult,
		EventGroupingAggregationKindSingleAlert,
	}
}

// FileFormat - The format of the file
type FileFormat string

const (
	// FileFormatCSV - A CSV file.
	FileFormatCSV FileFormat = "CSV"
	// FileFormatJSON - A JSON file.
	FileFormatJSON FileFormat = "JSON"
	// FileFormatUnspecified - A file of other format.
	FileFormatUnspecified FileFormat = "Unspecified"
)

// PossibleFileFormatValues returns the possible values for the FileFormat const type.
func PossibleFileFormatValues() []FileFormat {
	return []FileFormat{
		FileFormatCSV,
		FileFormatJSON,
		FileFormatUnspecified,
	}
}

// FileHashAlgorithm - The hash algorithm type.
type FileHashAlgorithm string

const (
	// FileHashAlgorithmMD5 - MD5 hash type
	FileHashAlgorithmMD5 FileHashAlgorithm = "MD5"
	// FileHashAlgorithmSHA1 - SHA1 hash type
	FileHashAlgorithmSHA1 FileHashAlgorithm = "SHA1"
	// FileHashAlgorithmSHA256 - SHA256 hash type
	FileHashAlgorithmSHA256 FileHashAlgorithm = "SHA256"
	// FileHashAlgorithmSHA256AC - SHA256 Authenticode hash type
	FileHashAlgorithmSHA256AC FileHashAlgorithm = "SHA256AC"
	// FileHashAlgorithmUnknown - Unknown hash algorithm
	FileHashAlgorithmUnknown FileHashAlgorithm = "Unknown"
)

// PossibleFileHashAlgorithmValues returns the possible values for the FileHashAlgorithm const type.
func PossibleFileHashAlgorithmValues() []FileHashAlgorithm {
	return []FileHashAlgorithm{
		FileHashAlgorithmMD5,
		FileHashAlgorithmSHA1,
		FileHashAlgorithmSHA256,
		FileHashAlgorithmSHA256AC,
		FileHashAlgorithmUnknown,
	}
}

// FileImportContentType - The content type of this file.
type FileImportContentType string

const (
	// FileImportContentTypeBasicIndicator - File containing records with the core fields of an indicator, plus the observables
	// to construct the STIX pattern.
	FileImportContentTypeBasicIndicator FileImportContentType = "BasicIndicator"
	// FileImportContentTypeStixIndicator - File containing STIX indicators.
	FileImportContentTypeStixIndicator FileImportContentType = "StixIndicator"
	// FileImportContentTypeUnspecified - File containing other records.
	FileImportContentTypeUnspecified FileImportContentType = "Unspecified"
)

// PossibleFileImportContentTypeValues returns the possible values for the FileImportContentType const type.
func PossibleFileImportContentTypeValues() []FileImportContentType {
	return []FileImportContentType{
		FileImportContentTypeBasicIndicator,
		FileImportContentTypeStixIndicator,
		FileImportContentTypeUnspecified,
	}
}

// FileImportState - The state of the file import.
type FileImportState string

const (
	// FileImportStateFatalError - A fatal error has occurred while ingesting the file.
	FileImportStateFatalError FileImportState = "FatalError"
	// FileImportStateInProgress - The file ingestion is in progress.
	FileImportStateInProgress FileImportState = "InProgress"
	// FileImportStateIngested - The file has been ingested.
	FileImportStateIngested FileImportState = "Ingested"
	// FileImportStateIngestedWithErrors - The file has been ingested with errors.
	FileImportStateIngestedWithErrors FileImportState = "IngestedWithErrors"
	// FileImportStateInvalid - The file is invalid.
	FileImportStateInvalid FileImportState = "Invalid"
	// FileImportStateUnspecified - Unspecified state.
	FileImportStateUnspecified FileImportState = "Unspecified"
	// FileImportStateWaitingForUpload - Waiting for the file to be uploaded.
	FileImportStateWaitingForUpload FileImportState = "WaitingForUpload"
)

// PossibleFileImportStateValues returns the possible values for the FileImportState const type.
func PossibleFileImportStateValues() []FileImportState {
	return []FileImportState{
		FileImportStateFatalError,
		FileImportStateInProgress,
		FileImportStateIngested,
		FileImportStateIngestedWithErrors,
		FileImportStateInvalid,
		FileImportStateUnspecified,
		FileImportStateWaitingForUpload,
	}
}

// GetInsightsError - the query kind
type GetInsightsError string

const (
	GetInsightsErrorInsight GetInsightsError = "Insight"
)

// PossibleGetInsightsErrorValues returns the possible values for the GetInsightsError const type.
func PossibleGetInsightsErrorValues() []GetInsightsError {
	return []GetInsightsError{
		GetInsightsErrorInsight,
	}
}

// IncidentClassification - The reason the incident was closed
type IncidentClassification string

const (
	// IncidentClassificationBenignPositive - Incident was benign positive
	IncidentClassificationBenignPositive IncidentClassification = "BenignPositive"
	// IncidentClassificationFalsePositive - Incident was false positive
	IncidentClassificationFalsePositive IncidentClassification = "FalsePositive"
	// IncidentClassificationTruePositive - Incident was true positive
	IncidentClassificationTruePositive IncidentClassification = "TruePositive"
	// IncidentClassificationUndetermined - Incident classification was undetermined
	IncidentClassificationUndetermined IncidentClassification = "Undetermined"
)

// PossibleIncidentClassificationValues returns the possible values for the IncidentClassification const type.
func PossibleIncidentClassificationValues() []IncidentClassification {
	return []IncidentClassification{
		IncidentClassificationBenignPositive,
		IncidentClassificationFalsePositive,
		IncidentClassificationTruePositive,
		IncidentClassificationUndetermined,
	}
}

// IncidentClassificationReason - The classification reason the incident was closed with
type IncidentClassificationReason string

const (
	// IncidentClassificationReasonInaccurateData - Classification reason was inaccurate data
	IncidentClassificationReasonInaccurateData IncidentClassificationReason = "InaccurateData"
	// IncidentClassificationReasonIncorrectAlertLogic - Classification reason was incorrect alert logic
	IncidentClassificationReasonIncorrectAlertLogic IncidentClassificationReason = "IncorrectAlertLogic"
	// IncidentClassificationReasonSuspiciousActivity - Classification reason was suspicious activity
	IncidentClassificationReasonSuspiciousActivity IncidentClassificationReason = "SuspiciousActivity"
	// IncidentClassificationReasonSuspiciousButExpected - Classification reason was suspicious but expected
	IncidentClassificationReasonSuspiciousButExpected IncidentClassificationReason = "SuspiciousButExpected"
)

// PossibleIncidentClassificationReasonValues returns the possible values for the IncidentClassificationReason const type.
func PossibleIncidentClassificationReasonValues() []IncidentClassificationReason {
	return []IncidentClassificationReason{
		IncidentClassificationReasonInaccurateData,
		IncidentClassificationReasonIncorrectAlertLogic,
		IncidentClassificationReasonSuspiciousActivity,
		IncidentClassificationReasonSuspiciousButExpected,
	}
}

// IncidentLabelType - The type of the label
type IncidentLabelType string

const (
	// IncidentLabelTypeAutoAssigned - Label automatically created by the system
	IncidentLabelTypeAutoAssigned IncidentLabelType = "AutoAssigned"
	// IncidentLabelTypeUser - Label manually created by a user
	IncidentLabelTypeUser IncidentLabelType = "User"
)

// PossibleIncidentLabelTypeValues returns the possible values for the IncidentLabelType const type.
func PossibleIncidentLabelTypeValues() []IncidentLabelType {
	return []IncidentLabelType{
		IncidentLabelTypeAutoAssigned,
		IncidentLabelTypeUser,
	}
}

// IncidentSeverity - The severity of the incident
type IncidentSeverity string

const (
	// IncidentSeverityHigh - High severity
	IncidentSeverityHigh IncidentSeverity = "High"
	// IncidentSeverityInformational - Informational severity
	IncidentSeverityInformational IncidentSeverity = "Informational"
	// IncidentSeverityLow - Low severity
	IncidentSeverityLow IncidentSeverity = "Low"
	// IncidentSeverityMedium - Medium severity
	IncidentSeverityMedium IncidentSeverity = "Medium"
)

// PossibleIncidentSeverityValues returns the possible values for the IncidentSeverity const type.
func PossibleIncidentSeverityValues() []IncidentSeverity {
	return []IncidentSeverity{
		IncidentSeverityHigh,
		IncidentSeverityInformational,
		IncidentSeverityLow,
		IncidentSeverityMedium,
	}
}

// IncidentStatus - The status of the incident
type IncidentStatus string

const (
	// IncidentStatusActive - An active incident which is being handled
	IncidentStatusActive IncidentStatus = "Active"
	// IncidentStatusClosed - A non-active incident
	IncidentStatusClosed IncidentStatus = "Closed"
	// IncidentStatusNew - An active incident which isn't being handled currently
	IncidentStatusNew IncidentStatus = "New"
)

// PossibleIncidentStatusValues returns the possible values for the IncidentStatus const type.
func PossibleIncidentStatusValues() []IncidentStatus {
	return []IncidentStatus{
		IncidentStatusActive,
		IncidentStatusClosed,
		IncidentStatusNew,
	}
}

// IngestionMode - Describes how to ingest the records in the file.
type IngestionMode string

const (
	// IngestionModeIngestAnyValidRecords - Valid records should still be ingested when invalid records are detected.
	IngestionModeIngestAnyValidRecords IngestionMode = "IngestAnyValidRecords"
	// IngestionModeIngestOnlyIfAllAreValid - No records should be ingested when invalid records are detected.
	IngestionModeIngestOnlyIfAllAreValid IngestionMode = "IngestOnlyIfAllAreValid"
	// IngestionModeUnspecified - Unspecified
	IngestionModeUnspecified IngestionMode = "Unspecified"
)

// PossibleIngestionModeValues returns the possible values for the IngestionMode const type.
func PossibleIngestionModeValues() []IngestionMode {
	return []IngestionMode{
		IngestionModeIngestAnyValidRecords,
		IngestionModeIngestOnlyIfAllAreValid,
		IngestionModeUnspecified,
	}
}

// KillChainIntent - Holds the alert intent stage(s) mapping for this alert.
type KillChainIntent string

const (
	// KillChainIntentCollection - Collection consists of techniques used to identify and gather information, such as sensitive
	// files, from a target network prior to exfiltration. This category also covers locations on a system or network where the
	// adversary may look for information to exfiltrate.
	KillChainIntentCollection KillChainIntent = "Collection"
	// KillChainIntentCommandAndControl - The command and control tactic represents how adversaries communicate with systems under
	// their control within a target network.
	KillChainIntentCommandAndControl KillChainIntent = "CommandAndControl"
	// KillChainIntentCredentialAccess - Credential access represents techniques resulting in access to or control over system,
	// domain, or service credentials that are used within an enterprise environment. Adversaries will likely attempt to obtain
	// legitimate credentials from users or administrator accounts (local system administrator or domain users with administrator
	// access) to use within the network. With sufficient access within a network, an adversary can create accounts for later
	// use within the environment.
	KillChainIntentCredentialAccess KillChainIntent = "CredentialAccess"
	// KillChainIntentDefenseEvasion - Defense evasion consists of techniques an adversary may use to evade detection or avoid
	// other defenses. Sometimes these actions are the same as or variations of techniques in other categories that have the added
	// benefit of subverting a particular defense or mitigation.
	KillChainIntentDefenseEvasion KillChainIntent = "DefenseEvasion"
	// KillChainIntentDiscovery - Discovery consists of techniques that allow the adversary to gain knowledge about the system
	// and internal network. When adversaries gain access to a new system, they must orient themselves to what they now have control
	// of and what benefits operating from that system give to their current objective or overall goals during the intrusion.
	// The operating system provides many native tools that aid in this post-compromise information-gathering phase.
	KillChainIntentDiscovery KillChainIntent = "Discovery"
	// KillChainIntentExecution - The execution tactic represents techniques that result in execution of adversary-controlled
	// code on a local or remote system. This tactic is often used in conjunction with lateral movement to expand access to remote
	// systems on a network.
	KillChainIntentExecution KillChainIntent = "Execution"
	// KillChainIntentExfiltration - Exfiltration refers to techniques and attributes that result or aid in the adversary removing
	// files and information from a target network. This category also covers locations on a system or network where the adversary
	// may look for information to exfiltrate.
	KillChainIntentExfiltration KillChainIntent = "Exfiltration"
	// KillChainIntentExploitation - Exploitation is the stage where an attacker manage to get foothold on the attacked resource.
	// This stage is applicable not only for compute hosts, but also for resources such as user accounts, certificates etc. Adversaries
	// will often be able to control the resource after this stage.
	KillChainIntentExploitation KillChainIntent = "Exploitation"
	// KillChainIntentImpact - The impact intent primary objective is to directly reduce the availability or integrity of a system,
	// service, or network; including manipulation of data to impact a business or operational process. This would often refer
	// to techniques such as ransom-ware, defacement, data manipulation and others.
	KillChainIntentImpact KillChainIntent = "Impact"
	// KillChainIntentLateralMovement - Lateral movement consists of techniques that enable an adversary to access and control
	// remote systems on a network and could, but does not necessarily, include execution of tools on remote systems. The lateral
	// movement techniques could allow an adversary to gather information from a system without needing additional tools, such
	// as a remote access tool. An adversary can use lateral movement for many purposes, including remote Execution of tools,
	// pivoting to additional systems, access to specific information or files, access to additional credentials, or to cause
	// an effect.
	KillChainIntentLateralMovement KillChainIntent = "LateralMovement"
	// KillChainIntentPersistence - Persistence is any access, action, or configuration change to a system that gives an adversary
	// a persistent presence on that system. Adversaries will often need to maintain access to systems through interruptions such
	// as system restarts, loss of credentials, or other failures that would require a remote access tool to restart or alternate
	// backdoor for them to regain access.
	KillChainIntentPersistence KillChainIntent = "Persistence"
	// KillChainIntentPrivilegeEscalation - Privilege escalation is the result of actions that allow an adversary to obtain a
	// higher level of permissions on a system or network. Certain tools or actions require a higher level of privilege to work
	// and are likely necessary at many points throughout an operation. User accounts with permissions to access specific systems
	// or perform specific functions necessary for adversaries to achieve their objective may also be considered an escalation
	// of privilege.
	KillChainIntentPrivilegeEscalation KillChainIntent = "PrivilegeEscalation"
	// KillChainIntentProbing - Probing could be an attempt to access a certain resource regardless of a malicious intent or a
	// failed attempt to gain access to a target system to gather information prior to exploitation. This step is usually detected
	// as an attempt originating from outside the network in attempt to scan the target system and find a way in.
	KillChainIntentProbing KillChainIntent = "Probing"
	// KillChainIntentUnknown - The default value.
	KillChainIntentUnknown KillChainIntent = "Unknown"
)

// PossibleKillChainIntentValues returns the possible values for the KillChainIntent const type.
func PossibleKillChainIntentValues() []KillChainIntent {
	return []KillChainIntent{
		KillChainIntentCollection,
		KillChainIntentCommandAndControl,
		KillChainIntentCredentialAccess,
		KillChainIntentDefenseEvasion,
		KillChainIntentDiscovery,
		KillChainIntentExecution,
		KillChainIntentExfiltration,
		KillChainIntentExploitation,
		KillChainIntentImpact,
		KillChainIntentLateralMovement,
		KillChainIntentPersistence,
		KillChainIntentPrivilegeEscalation,
		KillChainIntentProbing,
		KillChainIntentUnknown,
	}
}

// Kind - The kind of content the metadata is for.
type Kind string

const (
	KindAnalyticsRule            Kind = "AnalyticsRule"
	KindAnalyticsRuleTemplate    Kind = "AnalyticsRuleTemplate"
	KindAutomationRule           Kind = "AutomationRule"
	KindAzureFunction            Kind = "AzureFunction"
	KindDataConnector            Kind = "DataConnector"
	KindDataType                 Kind = "DataType"
	KindHuntingQuery             Kind = "HuntingQuery"
	KindInvestigationQuery       Kind = "InvestigationQuery"
	KindLogicAppsCustomConnector Kind = "LogicAppsCustomConnector"
	KindParser                   Kind = "Parser"
	KindPlaybook                 Kind = "Playbook"
	KindPlaybookTemplate         Kind = "PlaybookTemplate"
	KindSolution                 Kind = "Solution"
	KindWatchlist                Kind = "Watchlist"
	KindWatchlistTemplate        Kind = "WatchlistTemplate"
	KindWorkbook                 Kind = "Workbook"
	KindWorkbookTemplate         Kind = "WorkbookTemplate"
)

// PossibleKindValues returns the possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{
		KindAnalyticsRule,
		KindAnalyticsRuleTemplate,
		KindAutomationRule,
		KindAzureFunction,
		KindDataConnector,
		KindDataType,
		KindHuntingQuery,
		KindInvestigationQuery,
		KindLogicAppsCustomConnector,
		KindParser,
		KindPlaybook,
		KindPlaybookTemplate,
		KindSolution,
		KindWatchlist,
		KindWatchlistTemplate,
		KindWorkbook,
		KindWorkbookTemplate,
	}
}

// MatchingMethod - Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails,
// groupByCustomDetails must be provided and not empty.
type MatchingMethod string

const (
	// MatchingMethodAllEntities - Grouping alerts into a single incident if all the entities match
	MatchingMethodAllEntities MatchingMethod = "AllEntities"
	// MatchingMethodAnyAlert - Grouping any alerts triggered by this rule into a single incident
	MatchingMethodAnyAlert MatchingMethod = "AnyAlert"
	// MatchingMethodSelected - Grouping alerts into a single incident if the selected entities, custom details and alert details
	// match
	MatchingMethodSelected MatchingMethod = "Selected"
)

// PossibleMatchingMethodValues returns the possible values for the MatchingMethod const type.
func PossibleMatchingMethodValues() []MatchingMethod {
	return []MatchingMethod{
		MatchingMethodAllEntities,
		MatchingMethodAnyAlert,
		MatchingMethodSelected,
	}
}

// MicrosoftSecurityProductName - The alerts' productName on which the cases will be generated
type MicrosoftSecurityProductName string

const (
	MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection    MicrosoftSecurityProductName = "Azure Active Directory Identity Protection"
	MicrosoftSecurityProductNameAzureAdvancedThreatProtection             MicrosoftSecurityProductName = "Azure Advanced Threat Protection"
	MicrosoftSecurityProductNameAzureSecurityCenter                       MicrosoftSecurityProductName = "Azure Security Center"
	MicrosoftSecurityProductNameAzureSecurityCenterForIoT                 MicrosoftSecurityProductName = "Azure Security Center for IoT"
	MicrosoftSecurityProductNameMicrosoftCloudAppSecurity                 MicrosoftSecurityProductName = "Microsoft Cloud App Security"
	MicrosoftSecurityProductNameMicrosoftDefenderAdvancedThreatProtection MicrosoftSecurityProductName = "Microsoft Defender Advanced Threat Protection"
	MicrosoftSecurityProductNameOffice365AdvancedThreatProtection         MicrosoftSecurityProductName = "Office 365 Advanced Threat Protection"
)

// PossibleMicrosoftSecurityProductNameValues returns the possible values for the MicrosoftSecurityProductName const type.
func PossibleMicrosoftSecurityProductNameValues() []MicrosoftSecurityProductName {
	return []MicrosoftSecurityProductName{
		MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection,
		MicrosoftSecurityProductNameAzureAdvancedThreatProtection,
		MicrosoftSecurityProductNameAzureSecurityCenter,
		MicrosoftSecurityProductNameAzureSecurityCenterForIoT,
		MicrosoftSecurityProductNameMicrosoftCloudAppSecurity,
		MicrosoftSecurityProductNameMicrosoftDefenderAdvancedThreatProtection,
		MicrosoftSecurityProductNameOffice365AdvancedThreatProtection,
	}
}

// OSFamily - The operating system type.
type OSFamily string

const (
	// OSFamilyLinux - Host with Linux operating system.
	OSFamilyLinux OSFamily = "Linux"
	// OSFamilyWindows - Host with Windows operating system.
	OSFamilyWindows OSFamily = "Windows"
	// OSFamilyAndroid - Host with Android operating system.
	OSFamilyAndroid OSFamily = "Android"
	// OSFamilyIOS - Host with IOS operating system.
	OSFamilyIOS OSFamily = "IOS"
	// OSFamilyUnknown - Host with Unknown operating system.
	OSFamilyUnknown OSFamily = "Unknown"
)

// PossibleOSFamilyValues returns the possible values for the OSFamily const type.
func PossibleOSFamilyValues() []OSFamily {
	return []OSFamily{
		OSFamilyLinux,
		OSFamilyWindows,
		OSFamilyAndroid,
		OSFamilyIOS,
		OSFamilyUnknown,
	}
}

// Operator - Operator used for list of dependencies in criteria array.
type Operator string

const (
	OperatorAND Operator = "AND"
	OperatorOR  Operator = "OR"
)

// PossibleOperatorValues returns the possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{
		OperatorAND,
		OperatorOR,
	}
}

// OutputType - Insights Column type.
type OutputType string

const (
	OutputTypeDate   OutputType = "Date"
	OutputTypeEntity OutputType = "Entity"
	OutputTypeNumber OutputType = "Number"
	OutputTypeString OutputType = "String"
)

// PossibleOutputTypeValues returns the possible values for the OutputType const type.
func PossibleOutputTypeValues() []OutputType {
	return []OutputType{
		OutputTypeDate,
		OutputTypeEntity,
		OutputTypeNumber,
		OutputTypeString,
	}
}

// OwnerType - The type of the owner the incident is assigned to.
type OwnerType string

const (
	// OwnerTypeGroup - The incident owner type is an AAD group
	OwnerTypeGroup OwnerType = "Group"
	// OwnerTypeUnknown - The incident owner type is unknown
	OwnerTypeUnknown OwnerType = "Unknown"
	// OwnerTypeUser - The incident owner type is an AAD user
	OwnerTypeUser OwnerType = "User"
)

// PossibleOwnerTypeValues returns the possible values for the OwnerType const type.
func PossibleOwnerTypeValues() []OwnerType {
	return []OwnerType{
		OwnerTypeGroup,
		OwnerTypeUnknown,
		OwnerTypeUser,
	}
}

// PermissionProviderScope - Permission provider scope
type PermissionProviderScope string

const (
	PermissionProviderScopeResourceGroup PermissionProviderScope = "ResourceGroup"
	PermissionProviderScopeSubscription  PermissionProviderScope = "Subscription"
	PermissionProviderScopeWorkspace     PermissionProviderScope = "Workspace"
)

// PossiblePermissionProviderScopeValues returns the possible values for the PermissionProviderScope const type.
func PossiblePermissionProviderScopeValues() []PermissionProviderScope {
	return []PermissionProviderScope{
		PermissionProviderScopeResourceGroup,
		PermissionProviderScopeSubscription,
		PermissionProviderScopeWorkspace,
	}
}

// PollingFrequency - The polling frequency for the TAXII server.
type PollingFrequency string

const (
	// PollingFrequencyOnceADay - Once a day
	PollingFrequencyOnceADay PollingFrequency = "OnceADay"
	// PollingFrequencyOnceAMinute - Once a minute
	PollingFrequencyOnceAMinute PollingFrequency = "OnceAMinute"
	// PollingFrequencyOnceAnHour - Once an hour
	PollingFrequencyOnceAnHour PollingFrequency = "OnceAnHour"
)

// PossiblePollingFrequencyValues returns the possible values for the PollingFrequency const type.
func PossiblePollingFrequencyValues() []PollingFrequency {
	return []PollingFrequency{
		PollingFrequencyOnceADay,
		PollingFrequencyOnceAMinute,
		PollingFrequencyOnceAnHour,
	}
}

// ProviderName - Provider name
type ProviderName string

const (
	ProviderNameMicrosoftAadiamDiagnosticSettings                 ProviderName = "microsoft.aadiam/diagnosticSettings"
	ProviderNameMicrosoftAuthorizationPolicyAssignments           ProviderName = "Microsoft.Authorization/policyAssignments"
	ProviderNameMicrosoftOperationalInsightsSolutions             ProviderName = "Microsoft.OperationalInsights/solutions"
	ProviderNameMicrosoftOperationalInsightsWorkspaces            ProviderName = "Microsoft.OperationalInsights/workspaces"
	ProviderNameMicrosoftOperationalInsightsWorkspacesDatasources ProviderName = "Microsoft.OperationalInsights/workspaces/datasources"
	ProviderNameMicrosoftOperationalInsightsWorkspacesSharedKeys  ProviderName = "Microsoft.OperationalInsights/workspaces/sharedKeys"
)

// PossibleProviderNameValues returns the possible values for the ProviderName const type.
func PossibleProviderNameValues() []ProviderName {
	return []ProviderName{
		ProviderNameMicrosoftAadiamDiagnosticSettings,
		ProviderNameMicrosoftAuthorizationPolicyAssignments,
		ProviderNameMicrosoftOperationalInsightsSolutions,
		ProviderNameMicrosoftOperationalInsightsWorkspaces,
		ProviderNameMicrosoftOperationalInsightsWorkspacesDatasources,
		ProviderNameMicrosoftOperationalInsightsWorkspacesSharedKeys,
	}
}

// RegistryHive - the hive that holds the registry key.
type RegistryHive string

const (
	// RegistryHiveHKEYA - HKEY_A
	RegistryHiveHKEYA RegistryHive = "HKEY_A"
	// RegistryHiveHKEYCLASSESROOT - HKEY_CLASSES_ROOT
	RegistryHiveHKEYCLASSESROOT RegistryHive = "HKEY_CLASSES_ROOT"
	// RegistryHiveHKEYCURRENTCONFIG - HKEY_CURRENT_CONFIG
	RegistryHiveHKEYCURRENTCONFIG RegistryHive = "HKEY_CURRENT_CONFIG"
	// RegistryHiveHKEYCURRENTUSER - HKEY_CURRENT_USER
	RegistryHiveHKEYCURRENTUSER RegistryHive = "HKEY_CURRENT_USER"
	// RegistryHiveHKEYCURRENTUSERLOCALSETTINGS - HKEY_CURRENT_USER_LOCAL_SETTINGS
	RegistryHiveHKEYCURRENTUSERLOCALSETTINGS RegistryHive = "HKEY_CURRENT_USER_LOCAL_SETTINGS"
	// RegistryHiveHKEYLOCALMACHINE - HKEY_LOCAL_MACHINE
	RegistryHiveHKEYLOCALMACHINE RegistryHive = "HKEY_LOCAL_MACHINE"
	// RegistryHiveHKEYPERFORMANCEDATA - HKEY_PERFORMANCE_DATA
	RegistryHiveHKEYPERFORMANCEDATA RegistryHive = "HKEY_PERFORMANCE_DATA"
	// RegistryHiveHKEYPERFORMANCENLSTEXT - HKEY_PERFORMANCE_NLSTEXT
	RegistryHiveHKEYPERFORMANCENLSTEXT RegistryHive = "HKEY_PERFORMANCE_NLSTEXT"
	// RegistryHiveHKEYPERFORMANCETEXT - HKEY_PERFORMANCE_TEXT
	RegistryHiveHKEYPERFORMANCETEXT RegistryHive = "HKEY_PERFORMANCE_TEXT"
	// RegistryHiveHKEYUSERS - HKEY_USERS
	RegistryHiveHKEYUSERS RegistryHive = "HKEY_USERS"
)

// PossibleRegistryHiveValues returns the possible values for the RegistryHive const type.
func PossibleRegistryHiveValues() []RegistryHive {
	return []RegistryHive{
		RegistryHiveHKEYA,
		RegistryHiveHKEYCLASSESROOT,
		RegistryHiveHKEYCURRENTCONFIG,
		RegistryHiveHKEYCURRENTUSER,
		RegistryHiveHKEYCURRENTUSERLOCALSETTINGS,
		RegistryHiveHKEYLOCALMACHINE,
		RegistryHiveHKEYPERFORMANCEDATA,
		RegistryHiveHKEYPERFORMANCENLSTEXT,
		RegistryHiveHKEYPERFORMANCETEXT,
		RegistryHiveHKEYUSERS,
	}
}

// RegistryValueKind - Specifies the data types to use when storing values in the registry, or identifies the data type of
// a value in the registry.
type RegistryValueKind string

const (
	// RegistryValueKindBinary - Binary value type
	RegistryValueKindBinary RegistryValueKind = "Binary"
	// RegistryValueKindDWord - DWord value type
	RegistryValueKindDWord RegistryValueKind = "DWord"
	// RegistryValueKindExpandString - ExpandString value type
	RegistryValueKindExpandString RegistryValueKind = "ExpandString"
	// RegistryValueKindMultiString - MultiString value type
	RegistryValueKindMultiString RegistryValueKind = "MultiString"
	// RegistryValueKindNone - None
	RegistryValueKindNone RegistryValueKind = "None"
	// RegistryValueKindQWord - QWord value type
	RegistryValueKindQWord RegistryValueKind = "QWord"
	// RegistryValueKindString - String value type
	RegistryValueKindString RegistryValueKind = "String"
	// RegistryValueKindUnknown - Unknown value type
	RegistryValueKindUnknown RegistryValueKind = "Unknown"
)

// PossibleRegistryValueKindValues returns the possible values for the RegistryValueKind const type.
func PossibleRegistryValueKindValues() []RegistryValueKind {
	return []RegistryValueKind{
		RegistryValueKindBinary,
		RegistryValueKindDWord,
		RegistryValueKindExpandString,
		RegistryValueKindMultiString,
		RegistryValueKindNone,
		RegistryValueKindQWord,
		RegistryValueKindString,
		RegistryValueKindUnknown,
	}
}

// RepoType - The type of repository.
type RepoType string

const (
	RepoTypeDevOps RepoType = "DevOps"
	RepoTypeGithub RepoType = "Github"
)

// PossibleRepoTypeValues returns the possible values for the RepoType const type.
func PossibleRepoTypeValues() []RepoType {
	return []RepoType{
		RepoTypeDevOps,
		RepoTypeGithub,
	}
}

// SecurityMLAnalyticsSettingsKind - The kind of security ML analytics settings
type SecurityMLAnalyticsSettingsKind string

const (
	SecurityMLAnalyticsSettingsKindAnomaly SecurityMLAnalyticsSettingsKind = "Anomaly"
)

// PossibleSecurityMLAnalyticsSettingsKindValues returns the possible values for the SecurityMLAnalyticsSettingsKind const type.
func PossibleSecurityMLAnalyticsSettingsKindValues() []SecurityMLAnalyticsSettingsKind {
	return []SecurityMLAnalyticsSettingsKind{
		SecurityMLAnalyticsSettingsKindAnomaly,
	}
}

// SettingKind - The kind of the setting
type SettingKind string

const (
	SettingKindAnomalies       SettingKind = "Anomalies"
	SettingKindEntityAnalytics SettingKind = "EntityAnalytics"
	SettingKindEyesOn          SettingKind = "EyesOn"
	SettingKindUeba            SettingKind = "Ueba"
)

// PossibleSettingKindValues returns the possible values for the SettingKind const type.
func PossibleSettingKindValues() []SettingKind {
	return []SettingKind{
		SettingKindAnomalies,
		SettingKindEntityAnalytics,
		SettingKindEyesOn,
		SettingKindUeba,
	}
}

// SettingType - The kind of the setting
type SettingType string

const (
	SettingTypeCopyableLabel         SettingType = "CopyableLabel"
	SettingTypeInfoMessage           SettingType = "InfoMessage"
	SettingTypeInstructionStepsGroup SettingType = "InstructionStepsGroup"
)

// PossibleSettingTypeValues returns the possible values for the SettingType const type.
func PossibleSettingTypeValues() []SettingType {
	return []SettingType{
		SettingTypeCopyableLabel,
		SettingTypeInfoMessage,
		SettingTypeInstructionStepsGroup,
	}
}

// SettingsStatus - The anomaly SecurityMLAnalyticsSettings status
type SettingsStatus string

const (
	// SettingsStatusFlighting - Anomaly settings status in Flighting mode
	SettingsStatusFlighting SettingsStatus = "Flighting"
	// SettingsStatusProduction - Anomaly settings status in Production mode
	SettingsStatusProduction SettingsStatus = "Production"
)

// PossibleSettingsStatusValues returns the possible values for the SettingsStatus const type.
func PossibleSettingsStatusValues() []SettingsStatus {
	return []SettingsStatus{
		SettingsStatusFlighting,
		SettingsStatusProduction,
	}
}

// SourceKind - Source type of the content
type SourceKind string

const (
	SourceKindCommunity        SourceKind = "Community"
	SourceKindLocalWorkspace   SourceKind = "LocalWorkspace"
	SourceKindSolution         SourceKind = "Solution"
	SourceKindSourceRepository SourceKind = "SourceRepository"
)

// PossibleSourceKindValues returns the possible values for the SourceKind const type.
func PossibleSourceKindValues() []SourceKind {
	return []SourceKind{
		SourceKindCommunity,
		SourceKindLocalWorkspace,
		SourceKindSolution,
		SourceKindSourceRepository,
	}
}

// SourceType - The sourceType of the watchlist
type SourceType string

const (
	SourceTypeLocalFile     SourceType = "Local file"
	SourceTypeRemoteStorage SourceType = "Remote storage"
)

// PossibleSourceTypeValues returns the possible values for the SourceType const type.
func PossibleSourceTypeValues() []SourceType {
	return []SourceType{
		SourceTypeLocalFile,
		SourceTypeRemoteStorage,
	}
}

// SupportTier - Type of support for content item
type SupportTier string

const (
	SupportTierCommunity SupportTier = "Community"
	SupportTierMicrosoft SupportTier = "Microsoft"
	SupportTierPartner   SupportTier = "Partner"
)

// PossibleSupportTierValues returns the possible values for the SupportTier const type.
func PossibleSupportTierValues() []SupportTier {
	return []SupportTier{
		SupportTierCommunity,
		SupportTierMicrosoft,
		SupportTierPartner,
	}
}

// TemplateStatus - The alert rule template status.
type TemplateStatus string

const (
	// TemplateStatusAvailable - Alert rule template is available.
	TemplateStatusAvailable TemplateStatus = "Available"
	// TemplateStatusInstalled - Alert rule template installed. and can not use more then once
	TemplateStatusInstalled TemplateStatus = "Installed"
	// TemplateStatusNotAvailable - Alert rule template is not available
	TemplateStatusNotAvailable TemplateStatus = "NotAvailable"
)

// PossibleTemplateStatusValues returns the possible values for the TemplateStatus const type.
func PossibleTemplateStatusValues() []TemplateStatus {
	return []TemplateStatus{
		TemplateStatusAvailable,
		TemplateStatusInstalled,
		TemplateStatusNotAvailable,
	}
}

// ThreatIntelligenceResourceKindEnum - The kind of the threat intelligence entity
type ThreatIntelligenceResourceKindEnum string

const (
	// ThreatIntelligenceResourceKindEnumIndicator - Entity represents threat intelligence indicator in the system.
	ThreatIntelligenceResourceKindEnumIndicator ThreatIntelligenceResourceKindEnum = "indicator"
)

// PossibleThreatIntelligenceResourceKindEnumValues returns the possible values for the ThreatIntelligenceResourceKindEnum const type.
func PossibleThreatIntelligenceResourceKindEnumValues() []ThreatIntelligenceResourceKindEnum {
	return []ThreatIntelligenceResourceKindEnum{
		ThreatIntelligenceResourceKindEnumIndicator,
	}
}

// ThreatIntelligenceSortingCriteriaEnum - Sorting order (ascending/descending/unsorted).
type ThreatIntelligenceSortingCriteriaEnum string

const (
	ThreatIntelligenceSortingCriteriaEnumAscending  ThreatIntelligenceSortingCriteriaEnum = "ascending"
	ThreatIntelligenceSortingCriteriaEnumDescending ThreatIntelligenceSortingCriteriaEnum = "descending"
	ThreatIntelligenceSortingCriteriaEnumUnsorted   ThreatIntelligenceSortingCriteriaEnum = "unsorted"
)

// PossibleThreatIntelligenceSortingCriteriaEnumValues returns the possible values for the ThreatIntelligenceSortingCriteriaEnum const type.
func PossibleThreatIntelligenceSortingCriteriaEnumValues() []ThreatIntelligenceSortingCriteriaEnum {
	return []ThreatIntelligenceSortingCriteriaEnum{
		ThreatIntelligenceSortingCriteriaEnumAscending,
		ThreatIntelligenceSortingCriteriaEnumDescending,
		ThreatIntelligenceSortingCriteriaEnumUnsorted,
	}
}

// TriggerOperator - The operation against the threshold that triggers alert rule.
type TriggerOperator string

const (
	TriggerOperatorGreaterThan TriggerOperator = "GreaterThan"
	TriggerOperatorLessThan    TriggerOperator = "LessThan"
	TriggerOperatorEqual       TriggerOperator = "Equal"
	TriggerOperatorNotEqual    TriggerOperator = "NotEqual"
)

// PossibleTriggerOperatorValues returns the possible values for the TriggerOperator const type.
func PossibleTriggerOperatorValues() []TriggerOperator {
	return []TriggerOperator{
		TriggerOperatorGreaterThan,
		TriggerOperatorLessThan,
		TriggerOperatorEqual,
		TriggerOperatorNotEqual,
	}
}

type TriggersOn string

const (
	// TriggersOnAlerts - Trigger on Alerts
	TriggersOnAlerts TriggersOn = "Alerts"
	// TriggersOnIncidents - Trigger on Incidents
	TriggersOnIncidents TriggersOn = "Incidents"
)

// PossibleTriggersOnValues returns the possible values for the TriggersOn const type.
func PossibleTriggersOnValues() []TriggersOn {
	return []TriggersOn{
		TriggersOnAlerts,
		TriggersOnIncidents,
	}
}

type TriggersWhen string

const (
	// TriggersWhenCreated - Trigger on created objects
	TriggersWhenCreated TriggersWhen = "Created"
	// TriggersWhenUpdated - Trigger on updated objects
	TriggersWhenUpdated TriggersWhen = "Updated"
)

// PossibleTriggersWhenValues returns the possible values for the TriggersWhen const type.
func PossibleTriggersWhenValues() []TriggersWhen {
	return []TriggersWhen{
		TriggersWhenCreated,
		TriggersWhenUpdated,
	}
}

// UebaDataSources - The data source that enriched by ueba.
type UebaDataSources string

const (
	UebaDataSourcesAuditLogs     UebaDataSources = "AuditLogs"
	UebaDataSourcesAzureActivity UebaDataSources = "AzureActivity"
	UebaDataSourcesSecurityEvent UebaDataSources = "SecurityEvent"
	UebaDataSourcesSigninLogs    UebaDataSources = "SigninLogs"
)

// PossibleUebaDataSourcesValues returns the possible values for the UebaDataSources const type.
func PossibleUebaDataSourcesValues() []UebaDataSources {
	return []UebaDataSources{
		UebaDataSourcesAuditLogs,
		UebaDataSourcesAzureActivity,
		UebaDataSourcesSecurityEvent,
		UebaDataSourcesSigninLogs,
	}
}

// Version - The version of the source control.
type Version string

const (
	VersionV1 Version = "V1"
	VersionV2 Version = "V2"
)

// PossibleVersionValues returns the possible values for the Version const type.
func PossibleVersionValues() []Version {
	return []Version{
		VersionV1,
		VersionV2,
	}
}
