// Code generated by smithy-go-codegen DO NOT EDIT.

package redshiftserverless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/redshiftserverless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of scheduled actions. You can use the flags to filter the list
// of returned scheduled actions.
func (c *Client) ListScheduledActions(ctx context.Context, params *ListScheduledActionsInput, optFns ...func(*Options)) (*ListScheduledActionsOutput, error) {
	if params == nil {
		params = &ListScheduledActionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListScheduledActions", params, optFns, c.addOperationListScheduledActionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListScheduledActionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListScheduledActionsInput struct {

	// An optional parameter that specifies the maximum number of results to return.
	// Use nextToken to display the next page of results.
	MaxResults *int32

	// The name of namespace associated with the scheduled action to retrieve.
	NamespaceName *string

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again using
	// the returned token to retrieve the next page.
	NextToken *string

	noSmithyDocumentSerde
}

type ListScheduledActionsOutput struct {

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again using
	// the returned token to retrieve the next page.
	NextToken *string

	// All of the returned scheduled action association objects.
	ScheduledActions []types.ScheduledActionAssociation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListScheduledActionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListScheduledActions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListScheduledActions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListScheduledActions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListScheduledActions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListScheduledActionsAPIClient is a client that implements the
// ListScheduledActions operation.
type ListScheduledActionsAPIClient interface {
	ListScheduledActions(context.Context, *ListScheduledActionsInput, ...func(*Options)) (*ListScheduledActionsOutput, error)
}

var _ ListScheduledActionsAPIClient = (*Client)(nil)

// ListScheduledActionsPaginatorOptions is the paginator options for
// ListScheduledActions
type ListScheduledActionsPaginatorOptions struct {
	// An optional parameter that specifies the maximum number of results to return.
	// Use nextToken to display the next page of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListScheduledActionsPaginator is a paginator for ListScheduledActions
type ListScheduledActionsPaginator struct {
	options   ListScheduledActionsPaginatorOptions
	client    ListScheduledActionsAPIClient
	params    *ListScheduledActionsInput
	nextToken *string
	firstPage bool
}

// NewListScheduledActionsPaginator returns a new ListScheduledActionsPaginator
func NewListScheduledActionsPaginator(client ListScheduledActionsAPIClient, params *ListScheduledActionsInput, optFns ...func(*ListScheduledActionsPaginatorOptions)) *ListScheduledActionsPaginator {
	if params == nil {
		params = &ListScheduledActionsInput{}
	}

	options := ListScheduledActionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListScheduledActionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListScheduledActionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListScheduledActions page.
func (p *ListScheduledActionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListScheduledActionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListScheduledActions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListScheduledActions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListScheduledActions",
	}
}
