---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab ci run`

Create or run a new CI/CD pipeline.

```plaintext
glab ci run [flags]
```

## Aliases

```plaintext
create
```

## Examples

```plaintext
glab ci run
glab ci run -b main
glab ci run -b main --variables-env key1:val1
glab ci run -b main --variables-env key1:val1,key2:val2
glab ci run -b main --variables-env key1:val1 --variables-env key2:val2
glab ci run -b main --variables-file MYKEY:file1 --variables KEY2:some_value

```

## Options

```plaintext
  -b, --branch string            Create pipeline on branch/ref <string>.
      --variables strings        Pass variables to pipeline in format <key>:<value>.
      --variables-env strings    Pass variables to pipeline in format <key>:<value>.
      --variables-file strings   Pass file contents as a file variable to pipeline in format <key>:<filename>.
  -f, --variables-from string    JSON file containing variables for pipeline execution.
```

## Options inherited from parent commands

```plaintext
      --help              Show help for this command.
  -R, --repo OWNER/REPO   Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
```
